/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.api.python;

import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.Interval;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.api.python.PythonDStream;
import org.apache.spark.streaming.api.python.PythonTransformFunction;
import org.apache.spark.streaming.api.python.TransformFunction;
import org.apache.spark.streaming.dstream.DStream;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u000114Q!\u0001\u0002\u0001\u00059\u0011A\u0004U=uQ>t'+\u001a3vG\u0016$w+\u001b8e_^,G\rR*ue\u0016\fWN\u0003\u0002\u0004\t\u00051\u0001/\u001f;i_:T!!\u0002\u0004\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\b\u0011\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sON\u0011\u0001a\u0004\t\u0003!Ei\u0011AA\u0005\u0003%\t\u0011Q\u0002U=uQ>tGi\u0015;sK\u0006l\u0007\u0002\u0003\u000b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\f\u0002\rA\f'/\u001a8u\u0007\u0001\u00012a\u0006\u000e\u001d\u001b\u0005A\"BA\r\u0007\u0003\u001d!7\u000f\u001e:fC6L!a\u0007\r\u0003\u000f\u0011\u001bFO]3b[B\u0019Q\u0004\t\u0012\u000e\u0003yQ\u0011aH\u0001\u0006g\u000e\fG.Y\u0005\u0003Cy\u0011Q!\u0011:sCf\u0004\"!H\u0012\n\u0005\u0011r\"\u0001\u0002\"zi\u0016D\u0001B\n\u0001\u0003\u0002\u0003\u0006IaJ\u0001\faJ,G-^2f\rVt7\r\u0005\u0002\u0011Q%\u0011\u0011F\u0001\u0002\u0018!f$\bn\u001c8Ue\u0006t7OZ8s[\u001a+hn\u0019;j_:D\u0001b\u000b\u0001\u0003\u0006\u0004%I\u0001L\u0001\u000fa&tgOU3ek\u000e,g)\u001e8d+\u00059\u0003\u0002\u0003\u0018\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\u0002\u001fALgN\u001e*fIV\u001cWMR;oG\u0002B#!\f\u0019\u0011\u0005u\t\u0014B\u0001\u001a\u001f\u0005%!(/\u00198tS\u0016tG\u000f\u0003\u00055\u0001\t\u0005\t\u0015!\u00036\u0003=yv/\u001b8e_^$UO]1uS>t\u0007C\u0001\u001c8\u001b\u00051\u0011B\u0001\u001d\u0007\u0005!!UO]1uS>t\u0007\u0002\u0003\u001e\u0001\u0005\u0003\u0005\u000b\u0011B\u001b\u0002\u001d}\u001bH.\u001b3f\tV\u0014\u0018\r^5p]\")A\b\u0001C\u0001{\u00051A(\u001b8jiz\"bAP A\u0003\n\u001b\u0005C\u0001\t\u0001\u0011\u0015!2\b1\u0001\u0017\u0011\u001513\b1\u0001(\u0011\u0015Y3\b1\u0001(\u0011\u0015!4\b1\u00016\u0011\u0015Q4\b1\u00016\u0011\u001d)\u0005A1A\u0005B\u0019\u000ba\"\\;ti\u000eCWmY6q_&tG/F\u0001H!\ti\u0002*\u0003\u0002J=\t9!i\\8mK\u0006t\u0007BB&\u0001A\u0003%q)A\bnkN$8\t[3dWB|\u0017N\u001c;!\u0011\u001di\u0005A1A\u0005\u00029\u000bQ\"\u001b8w%\u0016$WoY3Gk:\u001cW#A(\u0011\u0005A\u0001\u0016BA)\u0003\u0005E!&/\u00198tM>\u0014XNR;oGRLwN\u001c\u0005\u0007'\u0002\u0001\u000b\u0011B(\u0002\u001d%tgOU3ek\u000e,g)\u001e8dA!)Q\u000b\u0001C\u0001-\u0006qq/\u001b8e_^$UO]1uS>tW#A\u001b\t\u000ba\u0003A\u0011\t,\u0002\u001bMd\u0017\u000eZ3EkJ\fG/[8o\u0011\u0015Q\u0006\u0001\"\u0011W\u0003Y\u0001\u0018M]3oiJ+W.Z7cKJ$UO]1uS>t\u0007\"\u0002/\u0001\t\u0003j\u0016aB2p[B,H/\u001a\u000b\u0003=\u001e\u00042!H0b\u0013\t\u0001gD\u0001\u0004PaRLwN\u001c\t\u0004E\u0016dR\"A2\u000b\u0005\u0011D\u0011a\u0001:eI&\u0011am\u0019\u0002\u0004%\u0012#\u0005\"\u00025\\\u0001\u0004I\u0017!\u0003<bY&$G+[7f!\t1$.\u0003\u0002l\r\t!A+[7f\u0001")
public class PythonReducedWindowedDStream
extends PythonDStream {
    private final DStream<byte[]> parent;
    private final transient PythonTransformFunction pinvReduceFunc;
    private final Duration _windowDuration;
    private final Duration _slideDuration;
    private final boolean mustCheckpoint;
    private final TransformFunction invReduceFunc;

    private PythonTransformFunction pinvReduceFunc() {
        return this.pinvReduceFunc;
    }

    @Override
    public boolean mustCheckpoint() {
        return this.mustCheckpoint;
    }

    public TransformFunction invReduceFunc() {
        return this.invReduceFunc;
    }

    public Duration windowDuration() {
        return this._windowDuration;
    }

    @Override
    public Duration slideDuration() {
        return this._slideDuration;
    }

    @Override
    public Duration parentRememberDuration() {
        return this.rememberDuration().$plus(this.windowDuration());
    }

    @Override
    public Option<RDD<byte[]>> compute(Time validTime) {
        Object object;
        Time currentTime = validTime;
        Interval current = new Interval(currentTime.$minus(this.windowDuration()), currentTime);
        Interval previous = current.$minus(this.slideDuration());
        Option previousRDD = this.getOrCompute(previous.endTime());
        if (this.pinvReduceFunc() != null && previousRDD.isDefined() && this.windowDuration().$greater$eq(this.slideDuration().$times(5))) {
            Seq<RDD<byte[]>> oldRDDs = this.parent.slice(previous.beginTime().$plus(this.parent.slideDuration()), current.beginTime());
            Option subtracted = oldRDDs.size() > 0 ? this.invReduceFunc().apply(previousRDD, (Option<RDD<?>>)new Some((Object)this.ssc().sc().union(oldRDDs, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)))), validTime) : previousRDD;
            Seq<RDD<byte[]>> newRDDs = this.parent.slice(previous.endTime().$plus(this.parent.slideDuration()), current.endTime());
            object = newRDDs.size() > 0 ? this.func().apply(subtracted, (Option<RDD<?>>)new Some((Object)this.ssc().sc().union(newRDDs, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)))), validTime) : subtracted;
        } else {
            Seq<RDD<byte[]>> currentRDDs = this.parent.slice(current.beginTime().$plus(this.parent.slideDuration()), current.endTime());
            object = currentRDDs.size() > 0 ? this.func().apply((Option<RDD<?>>)None$.MODULE$, (Option<RDD<?>>)new Some((Object)this.ssc().sc().union(currentRDDs, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)))), validTime) : None$.MODULE$;
        }
        return object;
    }

    public PythonReducedWindowedDStream(DStream<byte[]> parent, PythonTransformFunction preduceFunc, PythonTransformFunction pinvReduceFunc, Duration _windowDuration, Duration _slideDuration) {
        this.parent = parent;
        this.pinvReduceFunc = pinvReduceFunc;
        this._windowDuration = _windowDuration;
        this._slideDuration = _slideDuration;
        super(parent, preduceFunc);
        super.persist(StorageLevel$.MODULE$.MEMORY_ONLY());
        this.mustCheckpoint = true;
        this.invReduceFunc = new TransformFunction(pinvReduceFunc);
    }
}

