/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming;

import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.streaming.Checkpoint;
import org.apache.spark.streaming.Checkpoint$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;

public final class CheckpointReader$
implements Logging {
    public static final CheckpointReader$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new CheckpointReader$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public Option<Checkpoint> read(String checkpointDir) {
        return this.read(checkpointDir, new SparkConf(), SparkHadoopUtil$.MODULE$.get().conf(), true);
    }

    /*
     * WARNING - void declaration
     */
    public Option<Checkpoint> read(String checkpointDir, SparkConf conf, Configuration hadoopConf, boolean ignoreReadError) {
        NonLocalReturnControl nonLocalReturnControl2;
        block4: {
            Option option;
            Object object = new Object();
            try {
                Path checkpointPath = new Path(checkpointDir);
                FileSystem fs = checkpointPath.getFileSystem(hadoopConf);
                Seq checkpointFiles = (Seq)Checkpoint$.MODULE$.getCheckpointFiles(checkpointDir, (Option<FileSystem>)new Some((Object)fs)).reverse();
                if (checkpointFiles.isEmpty()) {
                    return None$.MODULE$;
                }
                this.logInfo((Function0<String>)new Serializable(checkpointFiles){
                    public static final long serialVersionUID = 0L;
                    private final Seq checkpointFiles$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Checkpoint files found: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.checkpointFiles$1.mkString(",")}));
                    }
                    {
                        this.checkpointFiles$1 = checkpointFiles$1;
                    }
                });
                ObjectRef readError = ObjectRef.create(null);
                checkpointFiles.foreach((Function1)new Serializable(conf, fs, readError, object){
                    public static final long serialVersionUID = 0L;
                    private final SparkConf conf$1;
                    private final FileSystem fs$1;
                    private final ObjectRef readError$1;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(Path file) {
                        CheckpointReader$.MODULE$.logInfo((Function0<String>)new Serializable(this, file){
                            public static final long serialVersionUID = 0L;
                            private final Path file$2;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempting to load checkpoint from file ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$2}));
                            }
                            {
                                this.file$2 = file$2;
                            }
                        });
                        try {
                            FSDataInputStream fis = this.fs$1.open(file);
                            Checkpoint cp = Checkpoint$.MODULE$.deserialize((InputStream)fis, this.conf$1);
                            CheckpointReader$.MODULE$.logInfo((Function0<String>)new Serializable(this, file){
                                public static final long serialVersionUID = 0L;
                                private final Path file$2;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Checkpoint successfully loaded from file ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$2}));
                                }
                                {
                                    this.file$2 = file$2;
                                }
                            });
                            CheckpointReader$.MODULE$.logInfo((Function0<String>)new Serializable(this, cp){
                                public static final long serialVersionUID = 0L;
                                private final Checkpoint cp$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Checkpoint was generated at time ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cp$1.checkpointTime()}));
                                }
                                {
                                    this.cp$1 = cp$1;
                                }
                            });
                            throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)new Some((Object)cp));
                        }
                        catch (Exception exception) {
                            this.readError$1.elem = exception;
                            CheckpointReader$.MODULE$.logWarning((Function0<String>)new Serializable(this, file){
                                public static final long serialVersionUID = 0L;
                                private final Path file$2;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error reading checkpoint from file ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$2}));
                                }
                                {
                                    this.file$2 = file$2;
                                }
                            }, exception);
                            return;
                        }
                    }
                    {
                        this.conf$1 = conf$1;
                        this.fs$1 = fs$1;
                        this.readError$1 = readError$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                if (!ignoreReadError) {
                    void var10_9;
                    void var7_6;
                    throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to read checkpoint from directory ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var7_6})), (Throwable)((Exception)var10_9.elem));
                }
                option = None$.MODULE$;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block4;
                option = (Option)nonLocalReturnControl2.value();
            }
            return option;
        }
        throw nonLocalReturnControl2;
    }

    public boolean read$default$4() {
        return false;
    }

    private CheckpointReader$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

