/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.scheduler;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SimpleFutureAction;
import org.apache.spark.SparkContext$;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.TaskContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcCallContext;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.rpc.ThreadSafeRpcEndpoint;
import org.apache.spark.scheduler.ExecutorCacheTaskLocation;
import org.apache.spark.scheduler.TaskLocation;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.apache.spark.streaming.receiver.CleanupOldBlocks;
import org.apache.spark.streaming.receiver.Receiver;
import org.apache.spark.streaming.receiver.ReceiverSupervisorImpl;
import org.apache.spark.streaming.receiver.StopReceiver$;
import org.apache.spark.streaming.receiver.UpdateRateLimit;
import org.apache.spark.streaming.scheduler.AddBlock;
import org.apache.spark.streaming.scheduler.AllReceiverIds$;
import org.apache.spark.streaming.scheduler.DeregisterReceiver;
import org.apache.spark.streaming.scheduler.GetAllReceiverInfo$;
import org.apache.spark.streaming.scheduler.ReceivedBlockInfo;
import org.apache.spark.streaming.scheduler.ReceivedBlockTracker;
import org.apache.spark.streaming.scheduler.ReceiverErrorInfo;
import org.apache.spark.streaming.scheduler.ReceiverSchedulingPolicy;
import org.apache.spark.streaming.scheduler.ReceiverState$;
import org.apache.spark.streaming.scheduler.ReceiverTracker$;
import org.apache.spark.streaming.scheduler.ReceiverTracker$ReceiverTrackerEndpoint$;
import org.apache.spark.streaming.scheduler.ReceiverTracker$ReceiverTrackerEndpoint$$anonfun$org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$;
import org.apache.spark.streaming.scheduler.ReceiverTracker$ReceiverTrackerEndpoint$$anonfun$receive$1$;
import org.apache.spark.streaming.scheduler.ReceiverTracker$ReceiverTrackerEndpoint$$anonfun$receiveAndReply$1$;
import org.apache.spark.streaming.scheduler.ReceiverTracker$TrackerState$;
import org.apache.spark.streaming.scheduler.ReceiverTrackingInfo;
import org.apache.spark.streaming.scheduler.ReceiverTrackingInfo$;
import org.apache.spark.streaming.scheduler.RegisterReceiver;
import org.apache.spark.streaming.scheduler.ReportError;
import org.apache.spark.streaming.scheduler.RestartReceiver;
import org.apache.spark.streaming.scheduler.StartAllReceivers;
import org.apache.spark.streaming.scheduler.StopAllReceivers$;
import org.apache.spark.streaming.scheduler.StreamingListenerBus;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverError;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverStarted;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverStopped;
import org.apache.spark.streaming.scheduler.UpdateReceiverRateLimit;
import org.apache.spark.streaming.util.WriteAheadLogUtils$;
import org.apache.spark.util.CallSite;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\rme!B\u0001\u0003\u0001\u0011a!a\u0004*fG\u0016Lg/\u001a:Ue\u0006\u001c7.\u001a:\u000b\u0005\r!\u0011!C:dQ\u0016$W\u000f\\3s\u0015\t)a!A\u0005tiJ,\u0017-\\5oO*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xmE\u0002\u0001\u001bM\u0001\"AD\t\u000e\u0003=Q\u0011\u0001E\u0001\u0006g\u000e\fG.Y\u0005\u0003%=\u0011a!\u00118z%\u00164\u0007C\u0001\u000b\u0018\u001b\u0005)\"B\u0001\f\u0007\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\r\u0016\u0005\u001daunZ4j]\u001eD\u0001B\u0007\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\u0004gN\u001c7\u0001\u0001\t\u0003;yi\u0011\u0001B\u0005\u0003?\u0011\u0011\u0001c\u0015;sK\u0006l\u0017N\\4D_:$X\r\u001f;\t\u0011\u0005\u0002!\u0011!Q\u0001\n\t\n!c]6jaJ+7-Z5wKJd\u0015-\u001e8dQB\u0011abI\u0005\u0003I=\u0011qAQ8pY\u0016\fg\u000eC\u0003'\u0001\u0011\u0005q%\u0001\u0004=S:LGO\u0010\u000b\u0004Q)Z\u0003CA\u0015\u0001\u001b\u0005\u0011\u0001\"\u0002\u000e&\u0001\u0004a\u0002bB\u0011&!\u0003\u0005\rA\t\u0005\b[\u0001\u0011\r\u0011\"\u0003/\u0003Q\u0011XmY3jm\u0016\u0014\u0018J\u001c9viN#(/Z1ngV\tq\u0006E\u0002\u000faIJ!!M\b\u0003\u000b\u0005\u0013(/Y=1\u0005MZ\u0004c\u0001\u001b8s5\tQG\u0003\u00027\t\u00059Am\u001d;sK\u0006l\u0017B\u0001\u001d6\u0005Q\u0011VmY3jm\u0016\u0014\u0018J\u001c9vi\u0012\u001bFO]3b[B\u0011!h\u000f\u0007\u0001\t%a\u0004!!A\u0001\u0002\u000b\u0005\u0011IA\u0002`I]J!AP \u0002/\u001d,GOU3dK&4XM]%oaV$8\u000b\u001e:fC6\u001c\u0018B\u0001!\u0005\u00051!5\u000b\u001e:fC6<%/\u00199i#\t\u0011U\t\u0005\u0002\u000f\u0007&\u0011Ai\u0004\u0002\b\u001d>$\b.\u001b8h!\tqa)\u0003\u0002H\u001f\t\u0019\u0011I\\=\t\r%\u0003\u0001\u0015!\u00030\u0003U\u0011XmY3jm\u0016\u0014\u0018J\u001c9viN#(/Z1ng\u0002Bqa\u0013\u0001C\u0002\u0013%A*\u0001\fsK\u000e,\u0017N^3s\u0013:\u0004X\u000f^*ue\u0016\fW.\u00133t+\u0005i\u0005c\u0001\b1\u001dB\u0011abT\u0005\u0003!>\u00111!\u00138u\u0011\u0019\u0011\u0006\u0001)A\u0005\u001b\u00069\"/Z2fSZ,'/\u00138qkR\u001cFO]3b[&#7\u000f\t\u0005\b)\u0002\u0011\r\u0011\"\u0003V\u0003Q\u0011XmY3jm\u0016$'\t\\8dWR\u0013\u0018mY6feV\ta\u000b\u0005\u0002*/&\u0011\u0001L\u0001\u0002\u0015%\u0016\u001cW-\u001b<fI\ncwnY6Ue\u0006\u001c7.\u001a:\t\ri\u0003\u0001\u0015!\u0003W\u0003U\u0011XmY3jm\u0016$'\t\\8dWR\u0013\u0018mY6fe\u0002Bq\u0001\u0018\u0001C\u0002\u0013%Q,A\u0006mSN$XM\\3s\u0005V\u001cX#\u00010\u0011\u0005%z\u0016B\u00011\u0003\u0005Q\u0019FO]3b[&tw\rT5ti\u0016tWM\u001d\"vg\"1!\r\u0001Q\u0001\ny\u000bA\u0002\\5ti\u0016tWM\u001d\"vg\u0002:Q\u0001\u001a\u0001\t\u0002\u0015\fA\u0002\u0016:bG.,'o\u0015;bi\u0016\u0004\"AZ4\u000e\u0003\u00011Q\u0001\u001b\u0001\t\u0002%\u0014A\u0002\u0016:bG.,'o\u0015;bi\u0016\u001c\"a\u001a6\u0011\u00059Y\u0017B\u00017\u0010\u0005-)e.^7fe\u0006$\u0018n\u001c8\t\u000b\u0019:G\u0011\u00018\u0015\u0003\u0015,A\u0001[4\u0001aB\u0011\u0011O]\u0007\u0002O&\u00111o\u001b\u0002\u0006-\u0006dW/\u001a\u0005\bk\u001e\u0014\r\u0011\"\u0001w\u0003-Ie.\u001b;jC2L'0\u001a3\u0016\u0003ADa\u0001_4!\u0002\u0013\u0001\u0018\u0001D%oSRL\u0017\r\\5{K\u0012\u0004\u0003b\u0002>h\u0005\u0004%\tA^\u0001\b'R\f'\u000f^3e\u0011\u0019ax\r)A\u0005a\u0006A1\u000b^1si\u0016$\u0007\u0005C\u0004\u007fO\n\u0007I\u0011\u0001<\u0002\u0011M#x\u000e\u001d9j]\u001eDq!!\u0001hA\u0003%\u0001/A\u0005Ti>\u0004\b/\u001b8hA!A\u0011QA4C\u0002\u0013\u0005a/A\u0004Ti>\u0004\b/\u001a3\t\u000f\u0005%q\r)A\u0005a\u0006A1\u000b^8qa\u0016$\u0007\u0005C\u0005\u0002\u000e\u0001\u0001\r\u0011\"\u0003\u0002\u0010\u0005aAO]1dW\u0016\u00148\u000b^1uKV\u0011\u0011\u0011\u0003\t\u0004\u0003'\u0011hB\u00014d\u0011%\t9\u0002\u0001a\u0001\n\u0013\tI\"\u0001\tue\u0006\u001c7.\u001a:Ti\u0006$Xm\u0018\u0013fcR!\u00111DA\u0011!\rq\u0011QD\u0005\u0004\u0003?y!\u0001B+oSRD!\"a\t\u0002\u0016\u0005\u0005\t\u0019AA\t\u0003\rAH%\r\u0005\t\u0003O\u0001\u0001\u0015)\u0003\u0002\u0012\u0005iAO]1dW\u0016\u00148\u000b^1uK\u0002BC!!\n\u0002,A\u0019a\"!\f\n\u0007\u0005=rB\u0001\u0005w_2\fG/\u001b7f\u0011%\t\u0019\u0004\u0001a\u0001\n\u0013\t)$\u0001\u0005f]\u0012\u0004x.\u001b8u+\t\t9\u0004\u0005\u0003\u0002:\u0005}RBAA\u001e\u0015\r\tiDB\u0001\u0004eB\u001c\u0017\u0002BA!\u0003w\u0011aB\u00159d\u000b:$\u0007o\\5oiJ+g\rC\u0005\u0002F\u0001\u0001\r\u0011\"\u0003\u0002H\u0005aQM\u001c3q_&tGo\u0018\u0013fcR!\u00111DA%\u0011)\t\u0019#a\u0011\u0002\u0002\u0003\u0007\u0011q\u0007\u0005\t\u0003\u001b\u0002\u0001\u0015)\u0003\u00028\u0005IQM\u001c3q_&tG\u000f\t\u0005\n\u0003#\u0002!\u0019!C\u0005\u0003'\n\u0001c]2iK\u0012,H.\u001b8h!>d\u0017nY=\u0016\u0005\u0005U\u0003cA\u0015\u0002X%\u0019\u0011\u0011\f\u0002\u00031I+7-Z5wKJ\u001c6\r[3ek2Lgn\u001a)pY&\u001c\u0017\u0010\u0003\u0005\u0002^\u0001\u0001\u000b\u0011BA+\u0003E\u00198\r[3ek2Lgn\u001a)pY&\u001c\u0017\u0010\t\u0005\n\u0003C\u0002!\u0019!C\u0005\u0003G\nAC]3dK&4XM\u001d&pE\u0016C\u0018\u000e\u001e'bi\u000eDWCAA3!\u0011\t9'!\u001e\u000e\u0005\u0005%$\u0002BA6\u0003[\n!bY8oGV\u0014(/\u001a8u\u0015\u0011\ty'!\u001d\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003g\nAA[1wC&!\u0011qOA5\u00059\u0019u.\u001e8u\t><h\u000eT1uG\"D\u0001\"a\u001f\u0001A\u0003%\u0011QM\u0001\u0016e\u0016\u001cW-\u001b<fe*{'-\u0012=ji2\u000bGo\u00195!\u0011%\ty\b\u0001b\u0001\n\u0013\t\t)A\u000bsK\u000e,\u0017N^3s)J\f7m[5oO&sgm\\:\u0016\u0005\u0005\r\u0005cBAC\u0003\u001fs\u00151S\u0007\u0003\u0003\u000fSA!!#\u0002\f\u00069Q.\u001e;bE2,'bAAG\u001f\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005E\u0015q\u0011\u0002\b\u0011\u0006\u001c\b.T1q!\rI\u0013QS\u0005\u0004\u0003/\u0013!\u0001\u0006*fG\u0016Lg/\u001a:Ue\u0006\u001c7.\u001b8h\u0013:4w\u000e\u0003\u0005\u0002\u001c\u0002\u0001\u000b\u0011BAB\u0003Y\u0011XmY3jm\u0016\u0014HK]1dW&tw-\u00138g_N\u0004\u0003\"CAP\u0001\t\u0007I\u0011BAQ\u0003i\u0011XmY3jm\u0016\u0014\bK]3gKJ\u0014X\r\u001a'pG\u0006$\u0018n\u001c8t+\t\t\u0019\u000bE\u0004\u0002\u0006\u0006=e*!*\u0011\u000b9\t9+a+\n\u0007\u0005%vB\u0001\u0004PaRLwN\u001c\t\u0005\u0003[\u000b\u0019LD\u0002\u000f\u0003_K1!!-\u0010\u0003\u0019\u0001&/\u001a3fM&!\u0011QWA\\\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011W\b\t\u0011\u0005m\u0006\u0001)A\u0005\u0003G\u000b1D]3dK&4XM\u001d)sK\u001a,'O]3e\u0019>\u001c\u0017\r^5p]N\u0004\u0003bBA`\u0001\u0011\u0005\u0011\u0011Y\u0001\u0006gR\f'\u000f\u001e\u000b\u0003\u00037Aq!!2\u0001\t\u0003\t9-\u0001\u0003ti>\u0004H\u0003BA\u000e\u0003\u0013Dq!a3\u0002D\u0002\u0007!%\u0001\u0005he\u0006\u001cWMZ;m\u0011\u001d\ty\r\u0001C\u0001\u0003#\fQ#\u00197m_\u000e\fG/\u001a\"m_\u000e\\7\u000fV8CCR\u001c\u0007\u000e\u0006\u0003\u0002\u001c\u0005M\u0007\u0002CAk\u0003\u001b\u0004\r!a6\u0002\u0013\t\fGo\u00195US6,\u0007cA\u000f\u0002Z&\u0019\u00111\u001c\u0003\u0003\tQKW.\u001a\u0005\b\u0003?\u0004A\u0011AAq\u0003A9W\r\u001e\"m_\u000e\\7o\u00144CCR\u001c\u0007\u000e\u0006\u0003\u0002d\n\u001d\u0001cBAW\u0003Kt\u0015\u0011^\u0005\u0005\u0003O\f9LA\u0002NCB\u0004b!a;\u0002|\n\u0005a\u0002BAw\u0003otA!a<\u0002v6\u0011\u0011\u0011\u001f\u0006\u0004\u0003g\\\u0012A\u0002\u001fs_>$h(C\u0001\u0011\u0013\r\tIpD\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti0a@\u0003\u0007M+\u0017OC\u0002\u0002z>\u00012!\u000bB\u0002\u0013\r\u0011)A\u0001\u0002\u0012%\u0016\u001cW-\u001b<fI\ncwnY6J]\u001a|\u0007\u0002CAk\u0003;\u0004\r!a6\t\u000f\t-\u0001\u0001\"\u0001\u0003\u000e\u0005Ir-\u001a;CY>\u001c7n](g\u0005\u0006$8\r[!oIN#(/Z1n)\u0019\tIOa\u0004\u0003\u0012!A\u0011Q\u001bB\u0005\u0001\u0004\t9\u000eC\u0004\u0003\u0014\t%\u0001\u0019\u0001(\u0002\u0011M$(/Z1n\u0013\u0012DqAa\u0006\u0001\t\u0003\u0011I\"\u0001\u000edY\u0016\fg.\u001e9PY\u0012\u0014En\\2lg\u0006sGMQ1uG\",7\u000f\u0006\u0003\u0002\u001c\tm\u0001\u0002\u0003B\u000f\u0005+\u0001\r!a6\u0002#\rdW-\u00198vaRC'/Z:i)&lW\rC\u0004\u0003\"\u0001!\tAa\t\u0002%\u0005dGn\\2bi\u0016$W\t_3dkR|'o\u001d\u000b\u0003\u0005K\u0001r!!,\u0002f:\u000b)\u000bC\u0004\u0003*\u0001!\tAa\u000b\u0002\u00199,XNU3dK&4XM]:\u0015\u00039CqAa\f\u0001\t\u0013\u0011\t$\u0001\tsK\u001eL7\u000f^3s%\u0016\u001cW-\u001b<feRi!Ea\r\u00036\te\"Q\bB!\u0005\u000bBqAa\u0005\u0003.\u0001\u0007a\n\u0003\u0005\u00038\t5\u0002\u0019AAV\u0003\r!\u0018\u0010\u001d\u0005\t\u0005w\u0011i\u00031\u0001\u0002,\u0006!\u0001n\\:u\u0011!\u0011yD!\fA\u0002\u0005-\u0016AC3yK\u000e,Ho\u001c:JI\"A!1\tB\u0017\u0001\u0004\t9$\u0001\tsK\u000e,\u0017N^3s\u000b:$\u0007o\\5oi\"A!q\tB\u0017\u0001\u0004\u0011I%A\u0007tK:$WM]!eIJ,7o\u001d\t\u0005\u0003s\u0011Y%\u0003\u0003\u0003N\u0005m\"A\u0003*qG\u0006#GM]3tg\"9!\u0011\u000b\u0001\u0005\n\tM\u0013A\u00053fe\u0016<\u0017n\u001d;feJ+7-Z5wKJ$\u0002\"a\u0007\u0003V\t]#1\f\u0005\b\u0005'\u0011y\u00051\u0001O\u0011!\u0011IFa\u0014A\u0002\u0005-\u0016aB7fgN\fw-\u001a\u0005\t\u0005;\u0012y\u00051\u0001\u0002,\u0006)QM\u001d:pe\"9!\u0011\r\u0001\u0005\u0002\t\r\u0014AD:f]\u0012\u0014\u0016\r^3Va\u0012\fG/\u001a\u000b\u0007\u00037\u0011)G!\u001b\t\u000f\t\u001d$q\fa\u0001\u001d\u0006I1\u000f\u001e:fC6,\u0016\n\u0012\u0005\t\u0005W\u0012y\u00061\u0001\u0003n\u00059a.Z<SCR,\u0007c\u0001\b\u0003p%\u0019!\u0011O\b\u0003\t1{gn\u001a\u0005\b\u0005k\u0002A\u0011\u0002B<\u0003!\tG\r\u001a\"m_\u000e\\Gc\u0001\u0012\u0003z!A!1\u0010B:\u0001\u0004\u0011\t!A\tsK\u000e,\u0017N^3e\u00052|7m[%oM>DqAa \u0001\t\u0013\u0011\t)A\u0006sKB|'\u000f^#se>\u0014H\u0003CA\u000e\u0005\u0007\u0013)Ia\"\t\u000f\tM!Q\u0010a\u0001\u001d\"A!\u0011\fB?\u0001\u0004\tY\u000b\u0003\u0005\u0003^\tu\u0004\u0019AAV\u0011\u001d\u0011Y\t\u0001C\u0005\u0005\u001b\u000b\u0001c]2iK\u0012,H.\u001a*fG\u0016Lg/\u001a:\u0015\t\t=%1\u0014\t\u0007\u0003W\fYP!%\u0011\t\tM%qS\u0007\u0003\u0005+S!a\u0001\u0004\n\t\te%Q\u0013\u0002\r)\u0006\u001c8\u000eT8dCRLwN\u001c\u0005\b\u0005;\u0013I\t1\u0001O\u0003)\u0011XmY3jm\u0016\u0014\u0018\n\u001a\u0005\b\u0005C\u0003A\u0011\u0002BR\u0003\u0001*\b\u000fZ1uKJ+7-Z5wKJ\u001c6\r[3ek2,G-\u0012=fGV$xN]:\u0015\r\u0005m!Q\u0015BT\u0011\u001d\u0011iJa(A\u00029C\u0001B!+\u0003 \u0002\u0007!qR\u0001\u0013g\u000eDW\rZ;mK\u0012dunY1uS>t7\u000fC\u0004\u0003.\u0002!\tAa,\u0002)!\f7/\u00168bY2|7-\u0019;fI\ncwnY6t+\u0005\u0011\u0003b\u0002BZ\u0001\u0011%!QW\u0001\rO\u0016$X\t_3dkR|'o]\u000b\u0003\u0005o\u0003b!a;\u0002|\ne\u0006\u0003\u0002BJ\u0005wKAA!0\u0003\u0016\nIR\t_3dkR|'oQ1dQ\u0016$\u0016m]6M_\u000e\fG/[8o\u0011\u001d\u0011\t\r\u0001C\u0005\u0003\u0003\f\u0001C];o\tVlW._*qCJ\\'j\u001c2\t\u000f\t\u0015\u0007\u0001\"\u0003\u0002B\u0006yA.Y;oG\"\u0014VmY3jm\u0016\u00148\u000fC\u0004\u0003J\u0002!IAa,\u0002)%\u001cHK]1dW\u0016\u0014\u0018J\\5uS\u0006d\u0017N_3e\u0011\u001d\u0011i\r\u0001C\u0005\u0005_\u000b\u0001#[:Ue\u0006\u001c7.\u001a:Ti\u0006\u0014H/\u001a3\t\u000f\tE\u0007\u0001\"\u0003\u00030\u0006\t\u0012n\u001d+sC\u000e\\WM]*u_B\u0004\u0018N\\4\t\u000f\tU\u0007\u0001\"\u0003\u00030\u0006\u0001\u0012n\u001d+sC\u000e\\WM]*u_B\u0004X\r\u001a\u0004\u0007\u00053\u0004AAa7\u0003/I+7-Z5wKJ$&/Y2lKJ,e\u000e\u001a9pS:$8#\u0002Bl\u001b\tu\u0007\u0003BA\u001d\u0005?LAA!9\u0002<\t)B\u000b\u001b:fC\u0012\u001c\u0016MZ3Sa\u000e,e\u000e\u001a9pS:$\bb\u0003Bs\u0005/\u0014)\u0019!C!\u0005O\faA\u001d9d\u000b:4XC\u0001Bu!\u0011\tIDa;\n\t\t5\u00181\b\u0002\u0007%B\u001cWI\u001c<\t\u0017\tE(q\u001bB\u0001B\u0003%!\u0011^\u0001\beB\u001cWI\u001c<!\u0011\u001d1#q\u001bC\u0001\u0005k$BAa>\u0003zB\u0019aMa6\t\u0011\t\u0015(1\u001fa\u0001\u0005SD!B!@\u0003X\n\u0007I\u0011\u0002B\u0000\u0003U9\u0018\r\u001c\"bi\u000eD\u0017N\\4UQJ,\u0017\r\u001a)p_2,\"a!\u0001\u0011\t\r\r1qA\u0007\u0003\u0007\u000bQ1!a\u001b\u0010\u0013\u0011\u0019Ia!\u0002\u0003?\u0015CXmY;uS>t7i\u001c8uKb$X\t_3dkR|'oU3sm&\u001cW\rC\u0005\u0004\u000e\t]\u0007\u0015!\u0003\u0004\u0002\u00051r/\u00197CCR\u001c\u0007.\u001b8h)\"\u0014X-\u00193Q_>d\u0007\u0005\u0003\u0006\u0004\u0012\t]\u0007\u0019!C\u0005\u0005_\u000ba!Y2uSZ,\u0007BCB\u000b\u0005/\u0004\r\u0011\"\u0003\u0004\u0018\u0005Q\u0011m\u0019;jm\u0016|F%Z9\u0015\t\u0005m1\u0011\u0004\u0005\n\u0003G\u0019\u0019\"!AA\u0002\tB\u0001b!\b\u0003X\u0002\u0006KAI\u0001\bC\u000e$\u0018N^3!Q\u0011\u0019Y\"a\u000b\t\u0011\r\r\"q\u001bC!\u0007K\tqA]3dK&4X-\u0006\u0002\u0004(A1ab!\u000bF\u00037I1aa\u000b\u0010\u0005=\u0001\u0016M\u001d;jC24UO\\2uS>t\u0007\u0002CB\u0018\u0005/$\te!\r\u0002\u001fI,7-Z5wK\u0006sGMU3qYf$Baa\n\u00044!A1QGB\u0017\u0001\u0004\u00199$A\u0004d_:$X\r\u001f;\u0011\t\u0005e2\u0011H\u0005\u0005\u0007w\tYD\u0001\bSa\u000e\u001c\u0015\r\u001c7D_:$X\r\u001f;\t\u0011\r}\"q\u001bC\u0005\u0007\u0003\n1dZ3u'R|'/\u001a3TG\",G-\u001e7fI\u0016CXmY;u_J\u001cH\u0003\u0002BH\u0007\u0007BqA!(\u0004>\u0001\u0007a\n\u0003\u0005\u0004H\t]G\u0011BB%\u00035\u0019H/\u0019:u%\u0016\u001cW-\u001b<feR1\u00111DB&\u0007CB\u0001b!\u0014\u0004F\u0001\u00071qJ\u0001\te\u0016\u001cW-\u001b<feB\"1\u0011KB/!\u0019\u0019\u0019fa\u0016\u0004\\5\u00111Q\u000b\u0006\u0004\u0007\u001b\"\u0011\u0002BB-\u0007+\u0012\u0001BU3dK&4XM\u001d\t\u0004u\ruCaCB0\u0007\u0017\n\t\u0011!A\u0003\u0002\u0005\u00131a\u0018\u00134\u0011!\u0011Ik!\u0012A\u0002\t=\u0005\u0002CB3\u0005/$\t%!1\u0002\r=t7\u000b^8q\u0011!\u0019IGa6\u0005\n\r-\u0014aE8o%\u0016\u001cW-\u001b<fe*{'MR5oSNDG\u0003BA\u000e\u0007[BqA!(\u0004h\u0001\u0007a\n\u0003\u0005\u0004r\t]G\u0011BAa\u00035\u0019Ho\u001c9SK\u000e,\u0017N^3sg\u001eQ1Q\u000f\u0002\u0002\u0002#\u0005Aaa\u001e\u0002\u001fI+7-Z5wKJ$&/Y2lKJ\u00042!KB=\r%\t!!!A\t\u0002\u0011\u0019YhE\u0002\u0004z5AqAJB=\t\u0003\u0019y\b\u0006\u0002\u0004x!Q11QB=#\u0003%\ta!\"\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u00199IK\u0002#\u0007\u0013[#aa#\u0011\t\r55qS\u0007\u0003\u0007\u001fSAa!%\u0004\u0014\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0007+{\u0011AC1o]>$\u0018\r^5p]&!1\u0011TBH\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class ReceiverTracker
implements Logging {
    public final StreamingContext org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc;
    private final boolean skipReceiverLaunch;
    private final ReceiverInputDStream<?>[] receiverInputStreams;
    private final int[] receiverInputStreamIds;
    private final ReceivedBlockTracker receivedBlockTracker;
    private final StreamingListenerBus listenerBus;
    private volatile Enumeration.Value trackerState;
    private RpcEndpointRef endpoint;
    private final ReceiverSchedulingPolicy org$apache$spark$streaming$scheduler$ReceiverTracker$$schedulingPolicy;
    private final CountDownLatch org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverJobExitLatch;
    private final HashMap<Object, ReceiverTrackingInfo> org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos;
    private final HashMap<Object, Option<String>> org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverPreferredLocations;
    private volatile ReceiverTracker$TrackerState$ TrackerState$module;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private transient int org$apache$spark$internal$Logging$$levelFlags;

    public static boolean $lessinit$greater$default$2() {
        return ReceiverTracker$.MODULE$.$lessinit$greater$default$2();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ReceiverTracker$TrackerState$ TrackerState$lzycompute() {
        ReceiverTracker receiverTracker = this;
        synchronized (receiverTracker) {
            if (this.TrackerState$module != null) return this.TrackerState$module;
            this.TrackerState$module = new ReceiverTracker$TrackerState$(this);
            return this.TrackerState$module;
        }
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int org$apache$spark$internal$Logging$$levelFlags() {
        return this.org$apache$spark$internal$Logging$$levelFlags;
    }

    public void org$apache$spark$internal$Logging$$levelFlags_$eq(int x$1) {
        this.org$apache$spark$internal$Logging$$levelFlags = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public final boolean isInfoEnabled() {
        return Logging.class.isInfoEnabled((Logging)this);
    }

    public final boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public final boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    private ReceiverInputDStream<?>[] receiverInputStreams() {
        return this.receiverInputStreams;
    }

    private int[] receiverInputStreamIds() {
        return this.receiverInputStreamIds;
    }

    private ReceivedBlockTracker receivedBlockTracker() {
        return this.receivedBlockTracker;
    }

    private StreamingListenerBus listenerBus() {
        return this.listenerBus;
    }

    public ReceiverTracker$TrackerState$ TrackerState() {
        return this.TrackerState$module == null ? this.TrackerState$lzycompute() : this.TrackerState$module;
    }

    private Enumeration.Value trackerState() {
        return this.trackerState;
    }

    private void trackerState_$eq(Enumeration.Value x$1) {
        this.trackerState = x$1;
    }

    private RpcEndpointRef endpoint() {
        return this.endpoint;
    }

    private void endpoint_$eq(RpcEndpointRef x$1) {
        this.endpoint = x$1;
    }

    public ReceiverSchedulingPolicy org$apache$spark$streaming$scheduler$ReceiverTracker$$schedulingPolicy() {
        return this.org$apache$spark$streaming$scheduler$ReceiverTracker$$schedulingPolicy;
    }

    public CountDownLatch org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverJobExitLatch() {
        return this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverJobExitLatch;
    }

    public HashMap<Object, ReceiverTrackingInfo> org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos() {
        return this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos;
    }

    public HashMap<Object, Option<String>> org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverPreferredLocations() {
        return this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverPreferredLocations;
    }

    public synchronized void start() {
        if (this.isTrackerStarted()) {
            throw new SparkException("ReceiverTracker already started");
        }
        if (!Predef$.MODULE$.refArrayOps((Object[])this.receiverInputStreams()).isEmpty()) {
            this.endpoint_$eq(this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.env().rpcEnv().setupEndpoint("ReceiverTracker", (RpcEndpoint)new ReceiverTrackerEndpoint(this, this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.env().rpcEnv())));
            if (!this.skipReceiverLaunch) {
                this.launchReceivers();
            }
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "ReceiverTracker started";
                }
            });
            this.trackerState_$eq(this.TrackerState().Started());
        }
    }

    public synchronized void stop(boolean graceful) {
        if (this.isTrackerStarted()) {
            this.trackerState_$eq(this.TrackerState().Stopping());
            if (!this.skipReceiverLaunch) {
                Seq receivers;
                this.endpoint().askWithRetry((Object)StopAllReceivers$.MODULE$, ClassTag$.MODULE$.Boolean());
                this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverJobExitLatch().await(10L, TimeUnit.SECONDS);
                if (graceful) {
                    this.logInfo((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Waiting for receiver job to terminate gracefully";
                        }
                    });
                    this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverJobExitLatch().await();
                    this.logInfo((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Waited for receiver job to terminate gracefully";
                        }
                    });
                }
                if ((receivers = (Seq)this.endpoint().askWithRetry((Object)AllReceiverIds$.MODULE$, ClassTag$.MODULE$.apply(Seq.class))).nonEmpty()) {
                    this.logWarning((Function0<String>)new Serializable(this, receivers){
                        public static final long serialVersionUID = 0L;
                        private final Seq receivers$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Not all of the receivers have deregistered, ").append((Object)this.receivers$1).toString();
                        }
                        {
                            this.receivers$1 = receivers$1;
                        }
                    });
                } else {
                    this.logInfo((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "All of the receivers have deregistered successfully";
                        }
                    });
                }
            }
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.env().rpcEnv().stop(this.endpoint());
            this.endpoint_$eq(null);
            this.receivedBlockTracker().stop();
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "ReceiverTracker stopped";
                }
            });
            this.trackerState_$eq(this.TrackerState().Stopped());
        } else if (this.isTrackerInitialized()) {
            this.trackerState_$eq(this.TrackerState().Stopping());
            this.receivedBlockTracker().stop();
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "ReceiverTracker stopped";
                }
            });
            this.trackerState_$eq(this.TrackerState().Stopped());
        }
    }

    public void allocateBlocksToBatch(Time batchTime) {
        if (Predef$.MODULE$.refArrayOps((Object[])this.receiverInputStreams()).nonEmpty()) {
            this.receivedBlockTracker().allocateBlocksToBatch(batchTime);
        }
    }

    public scala.collection.immutable.Map<Object, Seq<ReceivedBlockInfo>> getBlocksOfBatch(Time batchTime) {
        return this.receivedBlockTracker().getBlocksOfBatch(batchTime);
    }

    public Seq<ReceivedBlockInfo> getBlocksOfBatchAndStream(Time batchTime, int streamId) {
        return this.receivedBlockTracker().getBlocksOfBatchAndStream(batchTime, streamId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void cleanupOldBlocksAndBatches(Time cleanupThreshTime) {
        this.receivedBlockTracker().cleanupOldBatches(cleanupThreshTime, false);
        if (!WriteAheadLogUtils$.MODULE$.enableReceiverLog(this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.conf())) return;
        this.logInfo((Function0<String>)new Serializable(this, cleanupThreshTime){
            public static final long serialVersionUID = 0L;
            private final Time cleanupThreshTime$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cleanup old received batch data: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cleanupThreshTime$1}));
            }
            {
                this.cleanupThreshTime$1 = cleanupThreshTime$1;
            }
        });
        ReceiverTracker receiverTracker = this;
        synchronized (receiverTracker) {
            BoxedUnit boxedUnit;
            if (this.isTrackerStarted()) {
                this.endpoint().send((Object)new CleanupOldBlocks(cleanupThreshTime));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public synchronized scala.collection.immutable.Map<Object, Option<String>> allocatedExecutors() {
        return this.isTrackerStarted() ? ((scala.collection.immutable.MapLike)this.endpoint().askWithRetry((Object)GetAllReceiverInfo$.MODULE$, ClassTag$.MODULE$.apply(scala.collection.immutable.Map.class))).mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply(ReceiverTrackingInfo x$2) {
                return x$2.runningExecutor().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(ExecutorCacheTaskLocation x$3) {
                        return x$3.executorId();
                    }
                });
            }
        }) : Predef$.MODULE$.Map().empty();
    }

    public int numReceivers() {
        return Predef$.MODULE$.refArrayOps((Object[])this.receiverInputStreams()).size();
    }

    public boolean org$apache$spark$streaming$scheduler$ReceiverTracker$$registerReceiver(int streamId, String typ, String host, String executorId, RpcEndpointRef receiverEndpoint, RpcAddress senderAddress) {
        if (Predef$.MODULE$.intArrayOps(this.receiverInputStreamIds()).contains((Object)BoxesRunTime.boxToInteger((int)streamId))) {
            boolean bl;
            Seq<TaskLocation> acceptableExecutors;
            if (this.org$apache$spark$streaming$scheduler$ReceiverTracker$$isTrackerStopping() || this.org$apache$spark$streaming$scheduler$ReceiverTracker$$isTrackerStopped()) {
                return false;
            }
            Option<Seq<TaskLocation>> scheduledLocations = ((ReceiverTrackingInfo)this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().apply((Object)BoxesRunTime.boxToInteger((int)streamId))).scheduledLocations();
            Seq<TaskLocation> seq = acceptableExecutors = scheduledLocations.nonEmpty() ? (Seq<TaskLocation>)scheduledLocations.get() : this.scheduleReceiver(streamId);
            if (this.isAcceptable$1(host, executorId, acceptableExecutors)) {
                String name = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typ, BoxesRunTime.boxToInteger((int)streamId)}));
                ReceiverTrackingInfo receiverTrackingInfo = new ReceiverTrackingInfo(streamId, ReceiverState$.MODULE$.ACTIVE(), (Option<Seq<TaskLocation>>)None$.MODULE$, (Option<ExecutorCacheTaskLocation>)new Some((Object)new ExecutorCacheTaskLocation(host, executorId)), (Option<String>)new Some((Object)name), (Option<RpcEndpointRef>)new Some((Object)receiverEndpoint), ReceiverTrackingInfo$.MODULE$.apply$default$7());
                this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().put((Object)BoxesRunTime.boxToInteger((int)streamId), (Object)receiverTrackingInfo);
                this.listenerBus().post(new StreamingListenerReceiverStarted(receiverTrackingInfo.toReceiverInfo()));
                this.logInfo((Function0<String>)new Serializable(this, streamId, senderAddress){
                    public static final long serialVersionUID = 0L;
                    private final int streamId$1;
                    private final RpcAddress senderAddress$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Registered receiver for stream ").append((Object)BoxesRunTime.boxToInteger((int)this.streamId$1)).append((Object)" from ").append((Object)this.senderAddress$1).toString();
                    }
                    {
                        this.streamId$1 = streamId$1;
                        this.senderAddress$1 = senderAddress$1;
                    }
                });
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }
        throw new SparkException(new StringBuilder().append((Object)"Register received for unexpected id ").append((Object)BoxesRunTime.boxToInteger((int)streamId)).toString());
    }

    /*
     * Unable to fully structure code
     */
    public void org$apache$spark$streaming$scheduler$ReceiverTracker$$deregisterReceiver(int streamId, String message, String error) {
        block7: {
            block6: {
                block5: {
                    if (error == null) ** GOTO lbl-1000
                    v0 = error;
                    var6_4 = "";
                    if (!(v0 != null ? v0.equals(var6_4) == false : var6_4 != null)) lbl-1000:
                    // 2 sources

                    {
                        v1 = -1L;
                    } else {
                        v1 = this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.scheduler().clock().getTimeMillis();
                    }
                    lastErrorTime = v1;
                    errorInfo = new ReceiverErrorInfo(message, error, lastErrorTime);
                    var9_7 = this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().get((Object)BoxesRunTime.boxToInteger((int)streamId));
                    if (!(var9_7 instanceof Some)) break block5;
                    var10_8 = (Some)var9_7;
                    oldInfo = (ReceiverTrackingInfo)var10_8.x();
                    x$15 = ReceiverState$.MODULE$.INACTIVE();
                    x$16 = new Some((Object)errorInfo);
                    x$17 = oldInfo.copy$default$1();
                    x$18 = oldInfo.copy$default$3();
                    x$19 = oldInfo.copy$default$4();
                    x$20 = oldInfo.copy$default$5();
                    x$21 = oldInfo.copy$default$6();
                    var12_17 = oldInfo.copy(x$17, x$15, x$18, x$19, x$20, x$21, (Option<ReceiverErrorInfo>)x$16);
                    break block6;
                }
                if (!None$.MODULE$.equals(var9_7)) break block7;
                this.logWarning((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "No prior receiver info";
                    }
                });
                var12_17 = new ReceiverTrackingInfo(streamId, ReceiverState$.MODULE$.INACTIVE(), (Option<Seq<TaskLocation>>)None$.MODULE$, (Option<ExecutorCacheTaskLocation>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<RpcEndpointRef>)None$.MODULE$, (Option<ReceiverErrorInfo>)new Some((Object)errorInfo));
            }
            newReceiverTrackingInfo = var12_17;
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().update((Object)BoxesRunTime.boxToInteger((int)streamId), (Object)newReceiverTrackingInfo);
            this.listenerBus().post(new StreamingListenerReceiverStopped(newReceiverTrackingInfo.toReceiverInfo()));
            messageWithError = error == null || error.isEmpty() != false ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " - ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message, error}));
            this.logError((Function0<String>)new Serializable(this, streamId, messageWithError){
                public static final long serialVersionUID = 0L;
                private final int streamId$2;
                private final String messageWithError$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deregistered receiver for stream ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.streamId$2), this.messageWithError$1}));
                }
                {
                    this.streamId$2 = streamId$2;
                    this.messageWithError$1 = messageWithError$1;
                }
            });
            return;
        }
        throw new MatchError((Object)var9_7);
    }

    public synchronized void sendRateUpdate(int streamUID, long newRate) {
        if (this.isTrackerStarted()) {
            this.endpoint().send((Object)new UpdateReceiverRateLimit(streamUID, newRate));
        }
    }

    public boolean org$apache$spark$streaming$scheduler$ReceiverTracker$$addBlock(ReceivedBlockInfo receivedBlockInfo) {
        return this.receivedBlockTracker().addBlock(receivedBlockInfo);
    }

    public void org$apache$spark$streaming$scheduler$ReceiverTracker$$reportError(int streamId, String message, String error) {
        Option option;
        block4: {
            ReceiverTrackingInfo receiverTrackingInfo;
            block3: {
                block2: {
                    option = this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().get((Object)BoxesRunTime.boxToInteger((int)streamId));
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    ReceiverTrackingInfo oldInfo = (ReceiverTrackingInfo)some.x();
                    ReceiverErrorInfo errorInfo = new ReceiverErrorInfo(message, error, BoxesRunTime.unboxToLong((Object)oldInfo.errorInfo().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(ReceiverErrorInfo x$4) {
                            return x$4.lastErrorTime();
                        }
                    }).getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply() {
                            return this.apply$mcJ$sp();
                        }

                        public long apply$mcJ$sp() {
                            return -1L;
                        }
                    })));
                    Some x$22 = new Some((Object)errorInfo);
                    int x$23 = oldInfo.copy$default$1();
                    Enumeration.Value x$24 = oldInfo.copy$default$2();
                    Option<Seq<TaskLocation>> x$25 = oldInfo.copy$default$3();
                    Option<ExecutorCacheTaskLocation> x$26 = oldInfo.copy$default$4();
                    Option<String> x$27 = oldInfo.copy$default$5();
                    Option<RpcEndpointRef> x$28 = oldInfo.copy$default$6();
                    receiverTrackingInfo = oldInfo.copy(x$23, x$24, x$25, x$26, x$27, x$28, (Option<ReceiverErrorInfo>)x$22);
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                this.logWarning((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "No prior receiver info";
                    }
                });
                ReceiverErrorInfo errorInfo = new ReceiverErrorInfo(message, error, this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.scheduler().clock().getTimeMillis());
                receiverTrackingInfo = new ReceiverTrackingInfo(streamId, ReceiverState$.MODULE$.INACTIVE(), (Option<Seq<TaskLocation>>)None$.MODULE$, (Option<ExecutorCacheTaskLocation>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<RpcEndpointRef>)None$.MODULE$, (Option<ReceiverErrorInfo>)new Some((Object)errorInfo));
            }
            ReceiverTrackingInfo newReceiverTrackingInfo = receiverTrackingInfo;
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().update((Object)BoxesRunTime.boxToInteger((int)streamId), (Object)newReceiverTrackingInfo);
            this.listenerBus().post(new StreamingListenerReceiverError(newReceiverTrackingInfo.toReceiverInfo()));
            String messageWithError = error == null || error.isEmpty() ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " - ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message, error}));
            this.logWarning((Function0<String>)new Serializable(this, streamId, messageWithError){
                public static final long serialVersionUID = 0L;
                private final int streamId$3;
                private final String messageWithError$2;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error reported by receiver for stream ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.streamId$3), this.messageWithError$2}));
                }
                {
                    this.streamId$3 = streamId$3;
                    this.messageWithError$2 = messageWithError$2;
                }
            });
            return;
        }
        throw new MatchError((Object)option);
    }

    /*
     * WARNING - void declaration
     */
    private Seq<TaskLocation> scheduleReceiver(int receiverId) {
        void var3_3;
        Option preferredLocation = (Option)this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverPreferredLocations().getOrElse((Object)BoxesRunTime.boxToInteger((int)receiverId), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final None$ apply() {
                return None$.MODULE$;
            }
        });
        Seq<TaskLocation> scheduledLocations = this.org$apache$spark$streaming$scheduler$ReceiverTracker$$schedulingPolicy().rescheduleReceiver(receiverId, (Option<String>)preferredLocation, (Map<Object, ReceiverTrackingInfo>)this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos(), this.org$apache$spark$streaming$scheduler$ReceiverTracker$$getExecutors());
        this.org$apache$spark$streaming$scheduler$ReceiverTracker$$updateReceiverScheduledExecutors(receiverId, scheduledLocations);
        return var3_3;
    }

    public void org$apache$spark$streaming$scheduler$ReceiverTracker$$updateReceiverScheduledExecutors(int receiverId, Seq<TaskLocation> scheduledLocations) {
        Option option;
        block4: {
            ReceiverTrackingInfo receiverTrackingInfo;
            block3: {
                block2: {
                    option = this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().get((Object)BoxesRunTime.boxToInteger((int)receiverId));
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    ReceiverTrackingInfo oldInfo = (ReceiverTrackingInfo)some.x();
                    Enumeration.Value x$29 = ReceiverState$.MODULE$.SCHEDULED();
                    Some x$30 = new Some(scheduledLocations);
                    int x$31 = oldInfo.copy$default$1();
                    Option<ExecutorCacheTaskLocation> x$32 = oldInfo.copy$default$4();
                    Option<String> x$33 = oldInfo.copy$default$5();
                    Option<RpcEndpointRef> x$34 = oldInfo.copy$default$6();
                    Option<ReceiverErrorInfo> x$35 = oldInfo.copy$default$7();
                    receiverTrackingInfo = oldInfo.copy(x$31, x$29, (Option<Seq<TaskLocation>>)x$30, x$32, x$33, x$34, x$35);
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                receiverTrackingInfo = new ReceiverTrackingInfo(receiverId, ReceiverState$.MODULE$.SCHEDULED(), (Option<Seq<TaskLocation>>)new Some(scheduledLocations), (Option<ExecutorCacheTaskLocation>)None$.MODULE$, ReceiverTrackingInfo$.MODULE$.apply$default$5(), ReceiverTrackingInfo$.MODULE$.apply$default$6(), ReceiverTrackingInfo$.MODULE$.apply$default$7());
            }
            ReceiverTrackingInfo newReceiverTrackingInfo = receiverTrackingInfo;
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().put((Object)BoxesRunTime.boxToInteger((int)receiverId), (Object)newReceiverTrackingInfo);
            return;
        }
        throw new MatchError((Object)option);
    }

    public boolean hasUnallocatedBlocks() {
        return this.receivedBlockTracker().hasUnallocatedReceivedBlocks();
    }

    public Seq<ExecutorCacheTaskLocation> org$apache$spark$streaming$scheduler$ReceiverTracker$$getExecutors() {
        Seq seq;
        if (this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sc().isLocal()) {
            BlockManagerId blockManagerId = this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().env().blockManager().blockManagerId();
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExecutorCacheTaskLocation[]{new ExecutorCacheTaskLocation(blockManagerId.host(), blockManagerId.executorId())}));
        } else {
            seq = ((TraversableOnce)((TraversableLike)this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().env().blockManager().master().getMemoryStatus().filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<BlockManagerId, Tuple2<Object, Object>> x0$2) {
                    Tuple2<BlockManagerId, Tuple2<Object, Object>> tuple2 = x0$2;
                    if (tuple2 != null) {
                        BlockManagerId blockManagerId = (BlockManagerId)tuple2._1();
                        String string = blockManagerId.executorId();
                        String string2 = SparkContext$.MODULE$.DRIVER_IDENTIFIER();
                        boolean bl = string != null ? !string.equals(string2) : string2 != null;
                        return bl;
                    }
                    throw new MatchError(tuple2);
                }
            })).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ExecutorCacheTaskLocation apply(Tuple2<BlockManagerId, Tuple2<Object, Object>> x0$3) {
                    Tuple2<BlockManagerId, Tuple2<Object, Object>> tuple2 = x0$3;
                    if (tuple2 != null) {
                        BlockManagerId blockManagerId = (BlockManagerId)tuple2._1();
                        ExecutorCacheTaskLocation executorCacheTaskLocation = new ExecutorCacheTaskLocation(blockManagerId.host(), blockManagerId.executorId());
                        return executorCacheTaskLocation;
                    }
                    throw new MatchError(tuple2);
                }
            }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        }
        return seq;
    }

    private void runDummySparkJob() {
        Object object = this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().isLocal() ? BoxedUnit.UNIT : RDD$.MODULE$.rddToPairRDDFunctions(this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().makeRDD((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 50), 50, ClassTag$.MODULE$.Int()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(int x) {
                return new Tuple2.mcII.sp(x, 1);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).reduceByKey((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(int x$5, int x$6) {
                return this.apply$mcIII$sp(x$5, x$6);
            }

            public int apply$mcIII$sp(int x$5, int x$6) {
                return x$5 + x$6;
            }
        }, 20).collect();
        Predef$.MODULE$.assert(this.org$apache$spark$streaming$scheduler$ReceiverTracker$$getExecutors().nonEmpty());
    }

    private void launchReceivers() {
        Receiver[] receivers = (Receiver[])Predef$.MODULE$.refArrayOps((Object[])this.receiverInputStreams()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             */
            public final Receiver<?> apply(ReceiverInputDStream<?> nis) {
                void var2_2;
                Receiver<?> rcvr = nis.getReceiver();
                rcvr.setReceiverId(nis.id());
                return var2_2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Receiver.class)));
        this.runDummySparkJob();
        this.logInfo((Function0<String>)new Serializable(this, receivers){
            public static final long serialVersionUID = 0L;
            private final Receiver[] receivers$2;

            public final String apply() {
                return new StringBuilder().append((Object)"Starting ").append((Object)BoxesRunTime.boxToInteger((int)this.receivers$2.length)).append((Object)" receivers").toString();
            }
            {
                this.receivers$2 = receivers$2;
            }
        });
        this.endpoint().send((Object)new StartAllReceivers((Seq<Receiver<?>>)Predef$.MODULE$.wrapRefArray((Object[])receivers)));
    }

    private boolean isTrackerInitialized() {
        Enumeration.Value value = this.trackerState();
        Enumeration.Value value2 = this.TrackerState().Initialized();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    private boolean isTrackerStarted() {
        Enumeration.Value value = this.trackerState();
        Enumeration.Value value2 = this.TrackerState().Started();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public boolean org$apache$spark$streaming$scheduler$ReceiverTracker$$isTrackerStopping() {
        Enumeration.Value value = this.trackerState();
        Enumeration.Value value2 = this.TrackerState().Stopping();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public boolean org$apache$spark$streaming$scheduler$ReceiverTracker$$isTrackerStopped() {
        Enumeration.Value value = this.trackerState();
        Enumeration.Value value2 = this.TrackerState().Stopped();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    private final boolean isAcceptable$1(String host$1, String executorId$1, Seq acceptableExecutors$1) {
        return acceptableExecutors$1.exists((Function1)new Serializable(this, host$1, executorId$1){
            public static final long serialVersionUID = 0L;
            private final String host$1;
            private final String executorId$1;

            public final boolean apply(TaskLocation x0$1) {
                TaskLocation taskLocation;
                block4: {
                    boolean bl;
                    block3: {
                        block2: {
                            taskLocation = x0$1;
                            if (!(taskLocation instanceof ExecutorCacheTaskLocation)) break block2;
                            ExecutorCacheTaskLocation executorCacheTaskLocation = (ExecutorCacheTaskLocation)taskLocation;
                            String string = executorCacheTaskLocation.executorId();
                            String string2 = this.executorId$1;
                            bl = !(string != null ? !string.equals(string2) : string2 != null);
                            break block3;
                        }
                        if (taskLocation == null) break block4;
                        TaskLocation taskLocation2 = taskLocation;
                        String string = taskLocation2.host();
                        String string3 = this.host$1;
                        bl = !(string != null ? !string.equals(string3) : string3 != null);
                    }
                    return bl;
                }
                throw new MatchError((Object)taskLocation);
            }
            {
                this.host$1 = host$1;
                this.executorId$1 = executorId$1;
            }
        });
    }

    public ReceiverTracker(StreamingContext ssc, boolean skipReceiverLaunch) {
        this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc = ssc;
        this.skipReceiverLaunch = skipReceiverLaunch;
        Logging.class.$init$((Logging)this);
        this.receiverInputStreams = ssc.graph().getReceiverInputStreams();
        this.receiverInputStreamIds = (int[])Predef$.MODULE$.refArrayOps((Object[])this.receiverInputStreams()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(ReceiverInputDStream<?> x$1) {
                return x$1.id();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        this.receivedBlockTracker = new ReceivedBlockTracker(ssc.sparkContext().conf(), ssc.sparkContext().hadoopConfiguration(), (Seq<Object>)Predef$.MODULE$.wrapIntArray(this.receiverInputStreamIds()), ssc.scheduler().clock(), ssc.isCheckpointPresent(), (Option<String>)Option$.MODULE$.apply((Object)ssc.checkpointDir()));
        this.listenerBus = ssc.scheduler().listenerBus();
        this.trackerState = this.TrackerState().Initialized();
        this.endpoint = null;
        this.org$apache$spark$streaming$scheduler$ReceiverTracker$$schedulingPolicy = new ReceiverSchedulingPolicy();
        this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverJobExitLatch = new CountDownLatch(this.receiverInputStreams().length);
        this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos = new HashMap();
        this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverPreferredLocations = new HashMap();
    }

    public class ReceiverTrackerEndpoint
    implements ThreadSafeRpcEndpoint {
        private final RpcEnv rpcEnv;
        private final ExecutionContextExecutorService org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$walBatchingThreadPool;
        private volatile boolean org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$active;
        public final /* synthetic */ ReceiverTracker $outer;

        public final RpcEndpointRef self() {
            return RpcEndpoint.class.self((RpcEndpoint)this);
        }

        public void onError(Throwable cause) {
            RpcEndpoint.class.onError((RpcEndpoint)this, (Throwable)cause);
        }

        public void onConnected(RpcAddress remoteAddress) {
            RpcEndpoint.class.onConnected((RpcEndpoint)this, (RpcAddress)remoteAddress);
        }

        public void onDisconnected(RpcAddress remoteAddress) {
            RpcEndpoint.class.onDisconnected((RpcEndpoint)this, (RpcAddress)remoteAddress);
        }

        public void onNetworkError(Throwable cause, RpcAddress remoteAddress) {
            RpcEndpoint.class.onNetworkError((RpcEndpoint)this, (Throwable)cause, (RpcAddress)remoteAddress);
        }

        public void onStart() {
            RpcEndpoint.class.onStart((RpcEndpoint)this);
        }

        public final void stop() {
            RpcEndpoint.class.stop((RpcEndpoint)this);
        }

        public RpcEnv rpcEnv() {
            return this.rpcEnv;
        }

        public ExecutionContextExecutorService org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$walBatchingThreadPool() {
            return this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$walBatchingThreadPool;
        }

        public boolean org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$active() {
            return this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$active;
        }

        private void org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$active_$eq(boolean x$1) {
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$active = x$1;
        }

        public PartialFunction<Object, BoxedUnit> receive() {
            return new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReceiverTrackerEndpoint $outer;

                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof StartAllReceivers) {
                        StartAllReceivers startAllReceivers = (StartAllReceivers)A1;
                        Seq<Receiver<?>> receivers = startAllReceivers.receiver();
                        Map<Object, Seq<TaskLocation>> scheduledLocations = this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$schedulingPolicy().scheduleReceivers(receivers, this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$getExecutors());
                        receivers.foreach((Function1)new Serializable(this, scheduledLocations){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ ReceiverTrackerEndpoint$$anonfun$receive$1 $outer;
                            private final Map scheduledLocations$1;

                            public final void apply(Receiver<?> receiver) {
                                Seq executors = (Seq)this.scheduledLocations$1.apply((Object)BoxesRunTime.boxToInteger((int)receiver.streamId()));
                                this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$anonfun$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$updateReceiverScheduledExecutors(receiver.streamId(), (Seq<TaskLocation>)executors);
                                this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$anonfun$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverPreferredLocations().update((Object)BoxesRunTime.boxToInteger((int)receiver.streamId()), receiver.preferredLocation());
                                this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$anonfun$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$startReceiver(receiver, (Seq<TaskLocation>)executors);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.scheduledLocations$1 = scheduledLocations$1;
                            }
                        });
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof RestartReceiver) {
                        Seq<TaskLocation> seq;
                        RestartReceiver restartReceiver2 = (RestartReceiver)A1;
                        Receiver<?> receiver = restartReceiver2.receiver();
                        Seq<TaskLocation> oldScheduledExecutors = this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$getStoredScheduledExecutors(receiver.streamId());
                        if (oldScheduledExecutors.nonEmpty()) {
                            seq = oldScheduledExecutors;
                        } else {
                            ReceiverTrackingInfo oldReceiverInfo = (ReceiverTrackingInfo)this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().apply((Object)BoxesRunTime.boxToInteger((int)receiver.streamId()));
                            Enumeration.Value x$36 = ReceiverState$.MODULE$.INACTIVE();
                            None$ x$37 = None$.MODULE$;
                            int x$38 = oldReceiverInfo.copy$default$1();
                            Option<ExecutorCacheTaskLocation> x$39 = oldReceiverInfo.copy$default$4();
                            Option<String> x$40 = oldReceiverInfo.copy$default$5();
                            Option<RpcEndpointRef> x$41 = oldReceiverInfo.copy$default$6();
                            Option<ReceiverErrorInfo> x$42 = oldReceiverInfo.copy$default$7();
                            ReceiverTrackingInfo newReceiverInfo = oldReceiverInfo.copy(x$38, x$36, (Option<Seq<TaskLocation>>)x$37, x$39, x$40, x$41, x$42);
                            this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().update((Object)BoxesRunTime.boxToInteger((int)receiver.streamId()), (Object)newReceiverInfo);
                            seq = this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$schedulingPolicy().rescheduleReceiver(receiver.streamId(), receiver.preferredLocation(), (Map<Object, ReceiverTrackingInfo>)this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos(), this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$getExecutors());
                        }
                        Seq<TaskLocation> scheduledLocations = seq;
                        this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$startReceiver(receiver, scheduledLocations);
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof CleanupOldBlocks) {
                        CleanupOldBlocks cleanupOldBlocks2 = (CleanupOldBlocks)A1;
                        ((IterableLike)this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().values().flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Iterable<RpcEndpointRef> apply(ReceiverTrackingInfo x$7) {
                                return Option$.MODULE$.option2Iterable(x$7.endpoint());
                            }
                        }, scala.collection.Iterable$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, cleanupOldBlocks2){
                            public static final long serialVersionUID = 0L;
                            private final CleanupOldBlocks x6$1;

                            public final void apply(RpcEndpointRef x$8) {
                                x$8.send((Object)this.x6$1);
                            }
                            {
                                this.x6$1 = x6$1;
                            }
                        });
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof UpdateReceiverRateLimit) {
                        UpdateReceiverRateLimit updateReceiverRateLimit = (UpdateReceiverRateLimit)A1;
                        int streamUID = updateReceiverRateLimit.streamUID();
                        long newRate = updateReceiverRateLimit.newRate();
                        this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().get((Object)BoxesRunTime.boxToInteger((int)streamUID)).foreach((Function1)new Serializable(this, newRate){
                            public static final long serialVersionUID = 0L;
                            public final long newRate$1;

                            public final void apply(ReceiverTrackingInfo info) {
                                info.endpoint().foreach((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ ReceiverTrackerEndpoint$$anonfun$receive$1$$anonfun$applyOrElse$4 $outer;

                                    public final void apply(RpcEndpointRef eP) {
                                        eP.send((Object)new UpdateRateLimit(this.$outer.newRate$1));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                            }
                            {
                                this.newRate$1 = newRate$1;
                            }
                        });
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof ReportError) {
                        ReportError reportError2 = (ReportError)A1;
                        int streamId = reportError2.streamId();
                        String message = reportError2.message();
                        String error = reportError2.error();
                        this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$reportError(streamId, message, error);
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Object x1) {
                    Object object = x1;
                    boolean bl = object instanceof StartAllReceivers ? true : (object instanceof RestartReceiver ? true : (object instanceof CleanupOldBlocks ? true : (object instanceof UpdateReceiverRateLimit ? true : object instanceof ReportError)));
                    return bl;
                }

                public /* synthetic */ ReceiverTrackerEndpoint org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
        }

        public PartialFunction<Object, BoxedUnit> receiveAndReply(RpcCallContext context) {
            return new Serializable(this, context){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReceiverTrackerEndpoint $outer;
                public final RpcCallContext context$1;

                public final <A1, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x2;
                    if (A1 instanceof RegisterReceiver) {
                        RegisterReceiver registerReceiver2 = (RegisterReceiver)A1;
                        int streamId = registerReceiver2.streamId();
                        String typ = registerReceiver2.typ();
                        String host = registerReceiver2.host();
                        String executorId = registerReceiver2.executorId();
                        RpcEndpointRef receiverEndpoint = registerReceiver2.receiverEndpoint();
                        boolean successful = this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$registerReceiver(streamId, typ, host, executorId, receiverEndpoint, this.context$1.senderAddress());
                        this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)successful));
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof AddBlock) {
                        BoxedUnit boxedUnit;
                        AddBlock addBlock2 = (AddBlock)A1;
                        ReceivedBlockInfo receivedBlockInfo = addBlock2.receivedBlockInfo();
                        if (WriteAheadLogUtils$.MODULE$.isBatchingEnabled(this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.conf(), true)) {
                            this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$walBatchingThreadPool().execute(new Runnable(this, receivedBlockInfo){
                                private final /* synthetic */ ReceiverTrackerEndpoint$$anonfun$receiveAndReply$1 $outer;
                                public final ReceivedBlockInfo receivedBlockInfo$1;

                                public void run() {
                                    Utils$.MODULE$.tryLogNonFatalError((Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ ReceiverTrackerEndpoint$$anonfun$receiveAndReply$1$$anon$1 $outer;

                                        public final void apply() {
                                            this.apply$mcV$sp();
                                        }

                                        public void apply$mcV$sp() {
                                            if (this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$anonfun$$anon$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$anonfun$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$active()) {
                                                this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$anonfun$$anon$$$outer().context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$anonfun$$anon$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$anonfun$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$addBlock(this.$outer.receivedBlockInfo$1)));
                                                return;
                                            }
                                            throw new IllegalStateException("ReceiverTracker RpcEndpoint shut down.");
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                }

                                public /* synthetic */ ReceiverTrackerEndpoint$$anonfun$receiveAndReply$1 org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$anonfun$$anon$$$outer() {
                                    return this.$outer;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.receivedBlockInfo$1 = receivedBlockInfo$1;
                                }
                            });
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$addBlock(receivedBlockInfo)));
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        object = boxedUnit;
                    } else if (A1 instanceof DeregisterReceiver) {
                        DeregisterReceiver deregisterReceiver2 = (DeregisterReceiver)A1;
                        int streamId = deregisterReceiver2.streamId();
                        String message = deregisterReceiver2.msg();
                        String error = deregisterReceiver2.error();
                        this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$deregisterReceiver(streamId, message, error);
                        this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)true));
                        object = BoxedUnit.UNIT;
                    } else if (AllReceiverIds$.MODULE$.equals(A1)) {
                        this.context$1.reply((Object)((MapLike)this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Tuple2<Object, ReceiverTrackingInfo> x$9) {
                                Enumeration.Value value = ((ReceiverTrackingInfo)x$9._2()).state();
                                Enumeration.Value value2 = ReceiverState$.MODULE$.INACTIVE();
                                return value != null ? !value.equals(value2) : value2 != null;
                            }
                        })).keys().toSeq());
                        object = BoxedUnit.UNIT;
                    } else if (GetAllReceiverInfo$.MODULE$.equals(A1)) {
                        this.context$1.reply((Object)this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().toMap(Predef$.MODULE$.$conforms()));
                        object = BoxedUnit.UNIT;
                    } else if (StopAllReceivers$.MODULE$.equals(A1)) {
                        Predef$.MODULE$.assert(this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$isTrackerStopping() || this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$isTrackerStopped());
                        this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$stopReceivers();
                        this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)true));
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x2);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Object x2) {
                    Object object = x2;
                    boolean bl = object instanceof RegisterReceiver ? true : (object instanceof AddBlock ? true : (object instanceof DeregisterReceiver ? true : (AllReceiverIds$.MODULE$.equals(object) ? true : (GetAllReceiverInfo$.MODULE$.equals(object) ? true : StopAllReceivers$.MODULE$.equals(object)))));
                    return bl;
                }

                public /* synthetic */ ReceiverTrackerEndpoint org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.context$1 = context$1;
                }
            };
        }

        public Seq<TaskLocation> org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$getStoredScheduledExecutors(int receiverId) {
            Nil$ nil$;
            if (this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().contains((Object)BoxesRunTime.boxToInteger((int)receiverId))) {
                Option<Seq<TaskLocation>> scheduledLocations = ((ReceiverTrackingInfo)this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().apply((Object)BoxesRunTime.boxToInteger((int)receiverId))).scheduledLocations();
                if (scheduledLocations.nonEmpty()) {
                    Set executors = this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$getExecutors().toSet();
                    nil$ = (Seq)((TraversableLike)scheduledLocations.get()).filter((Function1)new Serializable(this, executors){
                        public static final long serialVersionUID = 0L;
                        private final Set executors$1;

                        public final boolean apply(TaskLocation x0$4) {
                            TaskLocation taskLocation;
                            block4: {
                                boolean bl;
                                block3: {
                                    block2: {
                                        taskLocation = x0$4;
                                        if (!(taskLocation instanceof ExecutorCacheTaskLocation)) break block2;
                                        ExecutorCacheTaskLocation executorCacheTaskLocation = (ExecutorCacheTaskLocation)taskLocation;
                                        bl = this.executors$1.apply((Object)executorCacheTaskLocation);
                                        break block3;
                                    }
                                    if (taskLocation == null) break block4;
                                    bl = true;
                                }
                                return bl;
                            }
                            throw new MatchError((Object)taskLocation);
                        }
                        {
                            this.executors$1 = executors$1;
                        }
                    });
                } else {
                    nil$ = Nil$.MODULE$;
                }
            } else {
                nil$ = Nil$.MODULE$;
            }
            return nil$;
        }

        /*
         * WARNING - void declaration
         */
        public void org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$startReceiver(Receiver<?> receiver, Seq<TaskLocation> scheduledLocations) {
            void var3_3;
            int receiverId = receiver.streamId();
            if (this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$shouldStartReceiver$1()) {
                RDD rDD;
                Option checkpointDirOption = Option$.MODULE$.apply((Object)this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.checkpointDir());
                SerializableConfiguration serializableHadoopConf = new SerializableConfiguration(this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().hadoopConfiguration());
                Serializable startReceiverFunc = new Serializable(this, checkpointDirOption, serializableHadoopConf){
                    public static final long serialVersionUID = 0L;
                    private final Option checkpointDirOption$1;
                    private final SerializableConfiguration serializableHadoopConf$1;

                    public final void apply(Iterator<Receiver<?>> iterator) {
                        if (iterator.hasNext()) {
                            if (TaskContext$.MODULE$.get().attemptNumber() == 0) {
                                Receiver receiver = (Receiver)iterator.next();
                                Predef$.MODULE$.assert(!iterator.hasNext());
                                ReceiverSupervisorImpl supervisor2 = new ReceiverSupervisorImpl(receiver, SparkEnv$.MODULE$.get(), this.serializableHadoopConf$1.value(), (Option<String>)this.checkpointDirOption$1);
                                supervisor2.start();
                                supervisor2.awaitTermination();
                            }
                            return;
                        }
                        throw new SparkException("Could not start receiver as object not found.");
                    }
                    {
                        this.checkpointDirOption$1 = checkpointDirOption$1;
                        this.serializableHadoopConf$1 = serializableHadoopConf$1;
                    }
                };
                if (scheduledLocations.isEmpty()) {
                    rDD = this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sc().makeRDD((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Receiver[]{receiver})), 1, ClassTag$.MODULE$.apply(Receiver.class));
                } else {
                    Seq preferredLocations = (Seq)((SeqLike)scheduledLocations.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(TaskLocation x$10) {
                            return x$10.toString();
                        }
                    }, Seq$.MODULE$.canBuildFrom())).distinct();
                    rDD = this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sc().makeRDD((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(receiver), (Object)preferredLocations)})), ClassTag$.MODULE$.apply(Receiver.class));
                }
                RDD receiverRDD = rDD;
                receiverRDD.setName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Receiver ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)receiverId)})));
                this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().setJobDescription(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Streaming job running receiver ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)receiverId)})));
                this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().setCallSite((CallSite)Option$.MODULE$.apply((Object)this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.getStartSite()).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CallSite apply() {
                        return Utils$.MODULE$.getCallSite(Utils$.MODULE$.getCallSite$default$1());
                    }
                }));
                SimpleFutureAction future = this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().submitJob(receiverRDD, (Function1)startReceiverFunc, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(int x$11, BoxedUnit x$12) {
                    }
                }, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                    }
                });
                future.onComplete((Function1)new Serializable(this, receiver, receiverId){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ReceiverTrackerEndpoint $outer;
                    private final Receiver receiver$1;
                    public final int receiverId$1;

                    public final void apply(Try<BoxedUnit> x0$5) {
                        Try<BoxedUnit> try_;
                        block9: {
                            block8: {
                                BoxedUnit boxedUnit;
                                block7: {
                                    BoxedUnit boxedUnit2;
                                    try_ = x0$5;
                                    if (!(try_ instanceof Success)) break block7;
                                    if (this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$shouldStartReceiver$1()) {
                                        this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().logInfo((Function0<String>)new Serializable(this){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ ReceiverTrackerEndpoint$$anonfun$org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$startReceiver$2 $outer;

                                            public final String apply() {
                                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Restarting Receiver ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.receiverId$1)}));
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                            }
                                        });
                                        this.$outer.self().send((Object)new RestartReceiver(this.receiver$1));
                                        boxedUnit2 = BoxedUnit.UNIT;
                                    } else {
                                        this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$onReceiverJobFinish(this.receiverId$1);
                                        boxedUnit2 = BoxedUnit.UNIT;
                                    }
                                    BoxedUnit boxedUnit3 = boxedUnit2;
                                    break block8;
                                }
                                if (!(try_ instanceof Failure)) break block9;
                                Failure failure = (Failure)try_;
                                Throwable e = failure.exception();
                                if (this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$shouldStartReceiver$1()) {
                                    this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().logError((Function0<String>)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "Receiver has been stopped. Try to restart it.";
                                        }
                                    }, e);
                                    this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().logInfo((Function0<String>)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ ReceiverTrackerEndpoint$$anonfun$org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$startReceiver$2 $outer;

                                        public final String apply() {
                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Restarting Receiver ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.receiverId$1)}));
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                    this.$outer.self().send((Object)new RestartReceiver(this.receiver$1));
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$onReceiverJobFinish(this.receiverId$1);
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                BoxedUnit boxedUnit4 = boxedUnit;
                            }
                            return;
                        }
                        throw new MatchError(try_);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.receiver$1 = receiver$1;
                        this.receiverId$1 = receiverId$1;
                    }
                }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
                this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().logInfo((Function0<String>)new Serializable(this, receiver){
                    public static final long serialVersionUID = 0L;
                    private final Receiver receiver$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Receiver ", " started"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.receiver$1.streamId())}));
                    }
                    {
                        this.receiver$1 = receiver$1;
                    }
                });
                return;
            }
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$onReceiverJobFinish((int)var3_3);
        }

        public void onStop() {
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$active_$eq(false);
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$walBatchingThreadPool().shutdown();
        }

        public void org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$onReceiverJobFinish(int receiverId) {
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverJobExitLatch().countDown();
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().remove((Object)BoxesRunTime.boxToInteger((int)receiverId)).foreach((Function1)new Serializable(this, receiverId){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReceiverTrackerEndpoint $outer;
                public final int receiverId$2;

                public final void apply(ReceiverTrackingInfo receiverTrackingInfo) {
                    Enumeration.Value value = receiverTrackingInfo.state();
                    Enumeration.Value value2 = ReceiverState$.MODULE$.ACTIVE();
                    if (!(value != null ? !value.equals(value2) : value2 != null)) {
                        this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().logWarning((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ ReceiverTrackerEndpoint$$anonfun$org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$onReceiverJobFinish$1 $outer;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Receiver ", " exited but didn't deregister"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.receiverId$2)}));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.receiverId$2 = receiverId$2;
                }
            });
        }

        public void org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$stopReceivers() {
            ((IterableLike)this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().values().flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Iterable<RpcEndpointRef> apply(ReceiverTrackingInfo x$13) {
                    return Option$.MODULE$.option2Iterable(x$13.endpoint());
                }
            }, scala.collection.Iterable$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(RpcEndpointRef x$14) {
                    x$14.send((Object)StopReceiver$.MODULE$);
                }
            });
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReceiverTrackerEndpoint $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"Sent stop signal to all ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().size())).append((Object)" receivers").toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }

        public /* synthetic */ ReceiverTracker org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer() {
            return this.$outer;
        }

        public final boolean org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$shouldStartReceiver$1() {
            return !this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$isTrackerStopping() && !this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$isTrackerStopped();
        }

        public ReceiverTrackerEndpoint(ReceiverTracker $outer, RpcEnv rpcEnv) {
            this.rpcEnv = rpcEnv;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            RpcEndpoint.class.$init$((RpcEndpoint)this);
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$walBatchingThreadPool = ExecutionContext$.MODULE$.fromExecutorService((ExecutorService)ThreadUtils$.MODULE$.newDaemonCachedThreadPool("wal-batching-thread-pool"));
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$active = true;
        }
    }
}

