/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.io.CompressionCodec$;
import org.apache.spark.streaming.Checkpoint;
import org.apache.spark.streaming.ObjectInputStreamWithLoader;
import org.apache.spark.streaming.Time;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;

public final class Checkpoint$
implements Logging,
Serializable {
    public static final Checkpoint$ MODULE$;
    private final String PREFIX;
    private final Regex REGEX;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private transient int org$apache$spark$internal$Logging$$levelFlags;

    static {
        new Checkpoint$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int org$apache$spark$internal$Logging$$levelFlags() {
        return this.org$apache$spark$internal$Logging$$levelFlags;
    }

    public void org$apache$spark$internal$Logging$$levelFlags_$eq(int x$1) {
        this.org$apache$spark$internal$Logging$$levelFlags = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public final boolean isInfoEnabled() {
        return Logging.class.isInfoEnabled((Logging)this);
    }

    public final boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public final boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public String PREFIX() {
        return this.PREFIX;
    }

    public Regex REGEX() {
        return this.REGEX;
    }

    public Path checkpointFile(String checkpointDir, Time checkpointTime) {
        return new Path(checkpointDir, new StringBuilder().append((Object)this.PREFIX()).append((Object)BoxesRunTime.boxToLong((long)checkpointTime.milliseconds())).toString());
    }

    public Path checkpointBackupFile(String checkpointDir, Time checkpointTime) {
        return new Path(checkpointDir, new StringBuilder().append((Object)this.PREFIX()).append((Object)BoxesRunTime.boxToLong((long)checkpointTime.milliseconds())).append((Object)".bk").toString());
    }

    public Seq<Path> getCheckpointFiles(String checkpointDir, Option<FileSystem> fsOption) {
        Seq seq;
        Path path = new Path(checkpointDir);
        FileSystem fs = (FileSystem)fsOption.getOrElse((Function0)new Serializable(path){
            public static final long serialVersionUID = 0L;
            private final Path path$1;

            public final FileSystem apply() {
                return this.path$1.getFileSystem(SparkHadoopUtil$.MODULE$.get().conf());
            }
            {
                this.path$1 = path$1;
            }
        });
        try {
            FileStatus[] statuses = fs.listStatus(path);
            if (statuses != null) {
                Path[] paths = (Path[])Predef$.MODULE$.refArrayOps((Object[])statuses).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Path apply(FileStatus x$3) {
                        return x$3.getPath();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class)));
                Path[] filtered = (Path[])Predef$.MODULE$.refArrayOps((Object[])paths).filter((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Path p) {
                        return Checkpoint$.MODULE$.REGEX().findFirstIn((CharSequence)p.toString()).nonEmpty();
                    }
                });
                seq = Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])filtered).sortWith((Function2)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Path path1, Path path2) {
                        return Checkpoint$.MODULE$.org$apache$spark$streaming$Checkpoint$$sortFunc$1(path1, path2);
                    }
                }));
            } else {
                this.logWarning((Function0<String>)new Serializable(path){
                    public static final long serialVersionUID = 0L;
                    private final Path path$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Listing ", " returned null"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$1}));
                    }
                    {
                        this.path$1 = path$1;
                    }
                });
                seq = (Seq)Seq$.MODULE$.empty();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.logWarning((Function0<String>)new Serializable(path){
                public static final long serialVersionUID = 0L;
                private final Path path$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Checkpoint directory ", " does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$1}));
                }
                {
                    this.path$1 = path$1;
                }
            });
            seq = (Seq)Seq$.MODULE$.empty();
        }
        return seq;
    }

    public Option<FileSystem> getCheckpointFiles$default$2() {
        return None$.MODULE$;
    }

    public byte[] serialize(Checkpoint checkpoint, SparkConf conf) {
        CompressionCodec compressionCodec = CompressionCodec$.MODULE$.createCodec(conf);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        OutputStream zos = compressionCodec.compressedOutputStream((OutputStream)bos);
        ObjectOutputStream oos = new ObjectOutputStream(zos);
        Utils$.MODULE$.tryWithSafeFinally((Function0)new Serializable(checkpoint, oos){
            public static final long serialVersionUID = 0L;
            private final Checkpoint checkpoint$1;
            private final ObjectOutputStream oos$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.oos$1.writeObject(this.checkpoint$1);
            }
            {
                this.checkpoint$1 = checkpoint$1;
                this.oos$1 = oos$1;
            }
        }, (Function0)new Serializable(oos){
            public static final long serialVersionUID = 0L;
            private final ObjectOutputStream oos$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.oos$1.close();
            }
            {
                this.oos$1 = oos$1;
            }
        });
        return bos.toByteArray();
    }

    public Checkpoint deserialize(InputStream inputStream, SparkConf conf) {
        CompressionCodec compressionCodec = CompressionCodec$.MODULE$.createCodec(conf);
        ObjectRef ois = ObjectRef.create(null);
        return (Checkpoint)Utils$.MODULE$.tryWithSafeFinally((Function0)new Serializable(inputStream, compressionCodec, ois){
            public static final long serialVersionUID = 0L;
            private final InputStream inputStream$1;
            private final CompressionCodec compressionCodec$1;
            private final ObjectRef ois$1;

            /*
             * WARNING - void declaration
             */
            public final Checkpoint apply() {
                void var2_2;
                InputStream zis = this.compressionCodec$1.compressedInputStream(this.inputStream$1);
                this.ois$1.elem = new ObjectInputStreamWithLoader(zis, Thread.currentThread().getContextClassLoader());
                Checkpoint cp = (Checkpoint)((ObjectInputStreamWithLoader)this.ois$1.elem).readObject();
                cp.validate();
                return var2_2;
            }
            {
                this.inputStream$1 = inputStream$1;
                this.compressionCodec$1 = compressionCodec$1;
                this.ois$1 = ois$1;
            }
        }, (Function0)new Serializable(ois){
            public static final long serialVersionUID = 0L;
            private final ObjectRef ois$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                if ((ObjectInputStreamWithLoader)this.ois$1.elem != null) {
                    ((ObjectInputStreamWithLoader)this.ois$1.elem).close();
                }
            }
            {
                this.ois$1 = ois$1;
            }
        });
    }

    private Object readResolve() {
        return MODULE$;
    }

    public final boolean org$apache$spark$streaming$Checkpoint$$sortFunc$1(Path path1, Path path2) {
        String string = path1.getName();
        Option option = this.REGEX().unapplySeq((CharSequence)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
            String x = (String)((LinearSeqOptimized)option.get()).apply(0);
            String y = (String)((LinearSeqOptimized)option.get()).apply(1);
            Tuple2.mcJZ.sp sp2 = new Tuple2.mcJZ.sp(new StringOps(Predef$.MODULE$.augmentString(x)).toLong(), !y.isEmpty());
            Tuple2.mcJZ.sp sp3 = sp2;
            if (sp3 != null) {
                Tuple2.mcJZ.sp sp4;
                long time1 = sp3._1$mcJ$sp();
                boolean bk1 = sp3._2$mcZ$sp();
                Tuple2.mcJZ.sp sp5 = sp4 = new Tuple2.mcJZ.sp(time1, bk1);
                long time12 = sp5._1$mcJ$sp();
                boolean bk12 = sp5._2$mcZ$sp();
                String string2 = path2.getName();
                Option option2 = this.REGEX().unapplySeq((CharSequence)string2);
                if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(2) == 0) {
                    String x2 = (String)((LinearSeqOptimized)option2.get()).apply(0);
                    String y2 = (String)((LinearSeqOptimized)option2.get()).apply(1);
                    Tuple2.mcJZ.sp sp6 = new Tuple2.mcJZ.sp(new StringOps(Predef$.MODULE$.augmentString(x2)).toLong(), !y2.isEmpty());
                    Tuple2.mcJZ.sp sp7 = sp6;
                    if (sp7 != null) {
                        Tuple2.mcJZ.sp sp8;
                        long time2 = sp7._1$mcJ$sp();
                        boolean bk2 = sp7._2$mcZ$sp();
                        Tuple2.mcJZ.sp sp9 = sp8 = new Tuple2.mcJZ.sp(time2, bk2);
                        long time22 = sp9._1$mcJ$sp();
                        boolean bk22 = sp9._2$mcZ$sp();
                        return time12 < time22 || time12 == time22 && bk12;
                    }
                    throw new MatchError((Object)sp7);
                }
                throw new MatchError((Object)string2);
            }
            throw new MatchError((Object)sp3);
        }
        throw new MatchError((Object)string);
    }

    private Checkpoint$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.PREFIX = "checkpoint-";
        this.REGEX = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder().append((Object)this.PREFIX()).append((Object)"([\\d]+)([\\w\\.]*)").toString())).r();
    }
}

