/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.serializer.KryoSerializer;
import org.apache.spark.serializer.SerializationStream;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.streaming.util.RateLimitedOutputStream;
import org.apache.spark.util.IntParam$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Serializable;
import scala.Tuple4;
import scala.collection.SeqLike;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class RawTextSender$
implements Logging {
    public static final RawTextSender$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private transient int org$apache$spark$internal$Logging$$levelFlags;

    static {
        new RawTextSender$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int org$apache$spark$internal$Logging$$levelFlags() {
        return this.org$apache$spark$internal$Logging$$levelFlags;
    }

    public void org$apache$spark$internal$Logging$$levelFlags_$eq(int x$1) {
        this.org$apache$spark$internal$Logging$$levelFlags = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public final boolean isInfoEnabled() {
        return Logging.class.isInfoEnabled((Logging)this);
    }

    public final boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public final boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void main(String[] args) {
        Tuple4 tuple4;
        String[] stringArray;
        Option option;
        if (args.length != 4) {
            System.err.println("Usage: RawTextSender <port> <file> <blockSize> <bytesPerSec>");
            System.exit(1);
        }
        if ((option = Array$.MODULE$.unapplySeq((Object)(stringArray = args))).isEmpty()) throw new MatchError((Object)stringArray);
        if (option.get() == null) throw new MatchError((Object)stringArray);
        if (((SeqLike)option.get()).lengthCompare(4) != 0) throw new MatchError((Object)stringArray);
        String string = (String)((SeqLike)option.get()).apply(0);
        String file = (String)((SeqLike)option.get()).apply(1);
        String string2 = (String)((SeqLike)option.get()).apply(2);
        String string3 = (String)((SeqLike)option.get()).apply(3);
        Option option2 = IntParam$.MODULE$.unapply(string);
        if (option2.isEmpty()) throw new MatchError((Object)stringArray);
        int port = BoxesRunTime.unboxToInt((Object)option2.get());
        Option option3 = IntParam$.MODULE$.unapply(string2);
        if (option3.isEmpty()) throw new MatchError((Object)stringArray);
        int blockSize = BoxesRunTime.unboxToInt((Object)option3.get());
        Option option4 = IntParam$.MODULE$.unapply(string3);
        if (option4.isEmpty()) throw new MatchError((Object)stringArray);
        int bytesPerSec = BoxesRunTime.unboxToInt((Object)option4.get());
        Tuple4 tuple42 = tuple4 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)port), (Object)file, (Object)BoxesRunTime.boxToInteger((int)blockSize), (Object)BoxesRunTime.boxToInteger((int)bytesPerSec));
        int port2 = BoxesRunTime.unboxToInt((Object)tuple42._1());
        String file2 = (String)tuple42._2();
        int blockSize2 = BoxesRunTime.unboxToInt((Object)tuple42._3());
        int bytesPerSec2 = BoxesRunTime.unboxToInt((Object)tuple42._4());
        String[] lines = (String[])Source$.MODULE$.fromFile(file2, Codec$.MODULE$.fallbackSystemCodec()).getLines().toArray(ClassTag$.MODULE$.apply(String.class));
        ByteArrayOutputStream bufferStream = new ByteArrayOutputStream(blockSize2 + 1000);
        SerializerInstance ser = new KryoSerializer(new SparkConf()).newInstance();
        SerializationStream serStream = ser.serializeStream((OutputStream)bufferStream);
        int i = 0;
        while (bufferStream.size() < blockSize2) {
            serStream.writeObject((Object)lines[i], ClassTag$.MODULE$.apply(String.class));
            i = (i + 1) % lines.length;
        }
        byte[] array = bufferStream.toByteArray();
        ByteBuffer countBuf = ByteBuffer.wrap(new byte[4]);
        countBuf.putInt(array.length);
        countBuf.flip();
        ServerSocket serverSocket = new ServerSocket(port2);
        this.logInfo((Function0<String>)new Serializable(port2){
            public static final long serialVersionUID = 0L;
            private final int port$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Listening on port ").append((Object)BoxesRunTime.boxToInteger((int)this.port$1)).toString();
            }
            {
                this.port$1 = port$1;
            }
        });
        Socket socket = serverSocket.accept();
        this.logInfo((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Got a new connection";
            }
        });
        RateLimitedOutputStream out = new RateLimitedOutputStream(socket.getOutputStream(), bytesPerSec2);
        try {
            while (true) {
                out.write(countBuf.array());
                out.write(array);
            }
        }
        catch (Throwable throwable) {
            socket.close();
            throw throwable;
        }
    }

    private RawTextSender$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

