/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.Logging;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.streaming.Checkpoint;
import org.apache.spark.streaming.CheckpointReader$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.DStream$;
import org.apache.spark.streaming.dstream.PairDStreamFunctions;
import org.apache.spark.util.ShutdownHookManager$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;

public final class StreamingContext$
implements Logging {
    public static final StreamingContext$ MODULE$;
    private final Object org$apache$spark$streaming$StreamingContext$$ACTIVATION_LOCK;
    private final int org$apache$spark$streaming$StreamingContext$$SHUTDOWN_HOOK_PRIORITY;
    private final AtomicReference<StreamingContext> activeContext;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new StreamingContext$();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public Object org$apache$spark$streaming$StreamingContext$$ACTIVATION_LOCK() {
        return this.org$apache$spark$streaming$StreamingContext$$ACTIVATION_LOCK;
    }

    public int org$apache$spark$streaming$StreamingContext$$SHUTDOWN_HOOK_PRIORITY() {
        return this.org$apache$spark$streaming$StreamingContext$$SHUTDOWN_HOOK_PRIORITY;
    }

    private AtomicReference<StreamingContext> activeContext() {
        return this.activeContext;
    }

    public void org$apache$spark$streaming$StreamingContext$$assertNoOtherContextIsActive() {
        Object object = this.org$apache$spark$streaming$StreamingContext$$ACTIVATION_LOCK();
        synchronized (object) {
            if (this.activeContext().get() == null) {
                return;
            }
            throw new IllegalStateException(new StringBuilder().append((Object)"Only one StreamingContext may be started in this JVM. Currently running StreamingContext was started at").append((Object)this.activeContext().get().getStartSite().longForm()).toString());
        }
    }

    public void org$apache$spark$streaming$StreamingContext$$setActiveContext(StreamingContext ssc) {
        Object object = this.org$apache$spark$streaming$StreamingContext$$ACTIVATION_LOCK();
        synchronized (object) {
            this.activeContext().set(ssc);
            return;
        }
    }

    @Experimental
    public Option<StreamingContext> getActive() {
        Object object = this.org$apache$spark$streaming$StreamingContext$$ACTIVATION_LOCK();
        synchronized (object) {
            Option option = Option$.MODULE$.apply((Object)this.activeContext().get());
            return option;
        }
    }

    public <K, V> PairDStreamFunctions<K, V> toPairDStreamFunctions(DStream<Tuple2<K, V>> stream, ClassTag<K> kt, ClassTag<V> vt, Ordering<K> ord) {
        return DStream$.MODULE$.toPairDStreamFunctions(stream, kt, vt, ord);
    }

    public <K, V> Null$ toPairDStreamFunctions$default$4(DStream<Tuple2<K, V>> stream) {
        return null;
    }

    @Experimental
    public StreamingContext getActiveOrCreate(Function0<StreamingContext> creatingFunc) {
        Object object = this.org$apache$spark$streaming$StreamingContext$$ACTIVATION_LOCK();
        synchronized (object) {
            Object object2 = this.getActive().getOrElse(creatingFunc);
            return (StreamingContext)object2;
        }
    }

    @Experimental
    public StreamingContext getActiveOrCreate(String checkpointPath, Function0<StreamingContext> creatingFunc, Configuration hadoopConf, boolean createOnError) {
        Object object = this.org$apache$spark$streaming$StreamingContext$$ACTIVATION_LOCK();
        synchronized (object) {
            Object object2 = this.getActive().getOrElse((Function0)new Serializable(checkpointPath, creatingFunc, hadoopConf, createOnError){
                public static final long serialVersionUID = 0L;
                private final String checkpointPath$1;
                private final Function0 creatingFunc$1;
                private final Configuration hadoopConf$1;
                private final boolean createOnError$1;

                public final StreamingContext apply() {
                    return StreamingContext$.MODULE$.getOrCreate(this.checkpointPath$1, (Function0<StreamingContext>)this.creatingFunc$1, this.hadoopConf$1, this.createOnError$1);
                }
                {
                    this.checkpointPath$1 = checkpointPath$1;
                    this.creatingFunc$1 = creatingFunc$1;
                    this.hadoopConf$1 = hadoopConf$1;
                    this.createOnError$1 = createOnError$1;
                }
            });
            return (StreamingContext)object2;
        }
    }

    public Configuration getActiveOrCreate$default$3() {
        return SparkHadoopUtil$.MODULE$.get().conf();
    }

    public boolean getActiveOrCreate$default$4() {
        return false;
    }

    public StreamingContext getOrCreate(String checkpointPath, Function0<StreamingContext> creatingFunc, Configuration hadoopConf, boolean createOnError) {
        Option<Checkpoint> checkpointOption = CheckpointReader$.MODULE$.read(checkpointPath, new SparkConf(), hadoopConf, createOnError);
        return (StreamingContext)checkpointOption.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final StreamingContext apply(Checkpoint x$4) {
                return new StreamingContext(null, x$4, null);
            }
        }).getOrElse(creatingFunc);
    }

    public Configuration getOrCreate$default$3() {
        return SparkHadoopUtil$.MODULE$.get().conf();
    }

    public boolean getOrCreate$default$4() {
        return false;
    }

    public Option<String> jarOfClass(Class<?> cls) {
        return SparkContext$.MODULE$.jarOfClass(cls);
    }

    public SparkContext createNewSparkContext(SparkConf conf) {
        return new SparkContext(conf);
    }

    public SparkContext createNewSparkContext(String master, String appName, String sparkHome, Seq<String> jars, Map<String, String> environment) {
        SparkConf conf = SparkContext$.MODULE$.updatedConf(new SparkConf(), master, appName, sparkHome, jars, environment);
        return new SparkContext(conf);
    }

    public <T> String rddToFileName(String prefix, String suffix, Time time) {
        String result = ((Object)BoxesRunTime.boxToLong((long)time.milliseconds())).toString();
        if (prefix != null && prefix.length() > 0) {
            result = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prefix, result}));
        }
        if (suffix != null && suffix.length() > 0) {
            result = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{result, suffix}));
        }
        return result;
    }

    public String $lessinit$greater$default$4() {
        return null;
    }

    public Seq<String> $lessinit$greater$default$5() {
        return Nil$.MODULE$;
    }

    public Map<String, String> $lessinit$greater$default$6() {
        return (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    private StreamingContext$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.org$apache$spark$streaming$StreamingContext$$ACTIVATION_LOCK = new Object();
        this.org$apache$spark$streaming$StreamingContext$$SHUTDOWN_HOOK_PRIORITY = ShutdownHookManager$.MODULE$.SPARK_CONTEXT_SHUTDOWN_PRIORITY() + 1;
        this.activeContext = new AtomicReference<Object>(null);
    }
}

