/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming;

import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.Interval$;
import org.apache.spark.streaming.Time;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00194A!\u0001\u0002\u0001\u0017\tA\u0011J\u001c;feZ\fGN\u0003\u0002\u0004\t\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u000b\u0019\tQa\u001d9be.T!a\u0002\u0005\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0011aA8sO\u000e\u00011C\u0001\u0001\r!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fM\"A1\u0003\u0001BC\u0002\u0013\u0005A#A\u0005cK\u001eLg\u000eV5nKV\tQ\u0003\u0005\u0002\u0017/5\t!!\u0003\u0002\u0019\u0005\t!A+[7f\u0011!Q\u0002A!A!\u0002\u0013)\u0012A\u00032fO&tG+[7fA!AA\u0004\u0001BC\u0002\u0013\u0005A#A\u0004f]\u0012$\u0016.\\3\t\u0011y\u0001!\u0011!Q\u0001\nU\t\u0001\"\u001a8e)&lW\r\t\u0005\u0006A\u0001!\t!I\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\t\u001aC\u0005\u0005\u0002\u0017\u0001!)1c\ba\u0001+!)Ad\ba\u0001+!)\u0001\u0005\u0001C\u0001MQ\u0019!e\n\u0017\t\u000b!*\u0003\u0019A\u0015\u0002\u000f\t,w-\u001b8NgB\u0011QBK\u0005\u0003W9\u0011A\u0001T8oO\")Q&\na\u0001S\u0005)QM\u001c3Ng\")q\u0006\u0001C\u0001a\u0005AA-\u001e:bi&|g\u000eF\u00012!\t1\"'\u0003\u00024\u0005\tAA)\u001e:bi&|g\u000eC\u00036\u0001\u0011\u0005a'A\u0003%a2,8\u000f\u0006\u0002#o!)\u0001\b\u000ea\u0001c\u0005!A/[7f\u0011\u0015Q\u0004\u0001\"\u0001<\u0003\u0019!S.\u001b8vgR\u0011!\u0005\u0010\u0005\u0006qe\u0002\r!\r\u0005\u0006}\u0001!\taP\u0001\u0006I1,7o\u001d\u000b\u0003\u0001\u000e\u0003\"!D!\n\u0005\ts!a\u0002\"p_2,\u0017M\u001c\u0005\u0006\tv\u0002\rAI\u0001\u0005i\"\fG\u000fC\u0003G\u0001\u0011\u0005q)\u0001\u0005%Y\u0016\u001c8\u000fJ3r)\t\u0001\u0005\nC\u0003E\u000b\u0002\u0007!\u0005C\u0003K\u0001\u0011\u00051*\u0001\u0005%OJ,\u0017\r^3s)\t\u0001E\nC\u0003E\u0013\u0002\u0007!\u0005C\u0003O\u0001\u0011\u0005q*A\u0006%OJ,\u0017\r^3sI\u0015\fHC\u0001!Q\u0011\u0015!U\n1\u0001#\u0011\u0015\u0011\u0006\u0001\"\u0011T\u0003!!xn\u0015;sS:<G#\u0001+\u0011\u0005UCfBA\u0007W\u0013\t9f\"\u0001\u0004Qe\u0016$WMZ\u0005\u00033j\u0013aa\u0015;sS:<'BA,\u000f\u000f\u0019a&\u0001#\u0001\u0003;\u0006A\u0011J\u001c;feZ\fG\u000e\u0005\u0002\u0017=\u001a1\u0011A\u0001E\u0001\u0005}\u001b\"A\u0018\u0007\t\u000b\u0001rF\u0011A1\u0015\u0003uCQa\u00190\u0005\u0002\u0011\fqbY;se\u0016tG/\u00138uKJ4\u0018\r\u001c\u000b\u0003E\u0015DQa\f2A\u0002E\u0002")
public class Interval {
    private final Time beginTime;
    private final Time endTime;

    public static Interval currentInterval(Duration duration2) {
        return Interval$.MODULE$.currentInterval(duration2);
    }

    public Time beginTime() {
        return this.beginTime;
    }

    public Time endTime() {
        return this.endTime;
    }

    public Duration duration() {
        return this.endTime().$minus(this.beginTime());
    }

    public Interval $plus(Duration time) {
        return new Interval(this.beginTime().$plus(time), this.endTime().$plus(time));
    }

    public Interval $minus(Duration time) {
        return new Interval(this.beginTime().$minus(time), this.endTime().$minus(time));
    }

    public boolean $less(Interval that) {
        Duration duration2 = this.duration();
        Duration duration3 = that.duration();
        if (!(duration2 != null ? !((Object)duration2).equals(duration3) : duration3 != null)) {
            return this.endTime().$less(that.endTime());
        }
        throw new Exception(new StringBuilder().append((Object)"Comparing two intervals with different durations [").append((Object)this).append((Object)", ").append((Object)that).append((Object)"]").toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean $less$eq(Interval that) {
        if (this.$less(that)) return true;
        Interval interval = this;
        Interval interval2 = that;
        if (interval != null) {
            if (!interval.equals(interval2)) return false;
            return true;
        }
        if (interval2 == null) return true;
        return false;
    }

    public boolean $greater(Interval that) {
        return !this.$less$eq(that);
    }

    public boolean $greater$eq(Interval that) {
        return !this.$less(that);
    }

    public String toString() {
        return new StringBuilder().append((Object)"[").append((Object)this.beginTime()).append((Object)", ").append((Object)this.endTime()).append((Object)"]").toString();
    }

    public Interval(Time beginTime, Time endTime) {
        this.beginTime = beginTime;
        this.endTime = endTime;
    }

    public Interval(long beginMs, long endMs) {
        this(new Time(beginMs), new Time(endMs));
    }
}

