/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.scheduler;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.spark.Logging;
import org.apache.spark.SimpleFutureAction;
import org.apache.spark.SparkContext$;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.TaskContext$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcCallContext;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.rpc.ThreadSafeRpcEndpoint;
import org.apache.spark.scheduler.ExecutorCacheTaskLocation;
import org.apache.spark.scheduler.TaskLocation;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.apache.spark.streaming.receiver.CleanupOldBlocks;
import org.apache.spark.streaming.receiver.Receiver;
import org.apache.spark.streaming.receiver.ReceiverSupervisorImpl;
import org.apache.spark.streaming.receiver.StopReceiver$;
import org.apache.spark.streaming.receiver.UpdateRateLimit;
import org.apache.spark.streaming.scheduler.AddBlock;
import org.apache.spark.streaming.scheduler.AllReceiverIds$;
import org.apache.spark.streaming.scheduler.DeregisterReceiver;
import org.apache.spark.streaming.scheduler.ReceivedBlockInfo;
import org.apache.spark.streaming.scheduler.ReceivedBlockTracker;
import org.apache.spark.streaming.scheduler.ReceiverErrorInfo;
import org.apache.spark.streaming.scheduler.ReceiverSchedulingPolicy;
import org.apache.spark.streaming.scheduler.ReceiverState$;
import org.apache.spark.streaming.scheduler.ReceiverTracker$;
import org.apache.spark.streaming.scheduler.ReceiverTracker$ReceiverTrackerEndpoint$;
import org.apache.spark.streaming.scheduler.ReceiverTracker$ReceiverTrackerEndpoint$$anonfun$org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$;
import org.apache.spark.streaming.scheduler.ReceiverTracker$ReceiverTrackerEndpoint$$anonfun$receive$1$;
import org.apache.spark.streaming.scheduler.ReceiverTracker$ReceiverTrackerEndpoint$$anonfun$receiveAndReply$1$;
import org.apache.spark.streaming.scheduler.ReceiverTracker$TrackerState$;
import org.apache.spark.streaming.scheduler.ReceiverTrackingInfo;
import org.apache.spark.streaming.scheduler.ReceiverTrackingInfo$;
import org.apache.spark.streaming.scheduler.RegisterReceiver;
import org.apache.spark.streaming.scheduler.ReportError;
import org.apache.spark.streaming.scheduler.RestartReceiver;
import org.apache.spark.streaming.scheduler.StartAllReceivers;
import org.apache.spark.streaming.scheduler.StopAllReceivers$;
import org.apache.spark.streaming.scheduler.StreamingListenerBus;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverError;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverStarted;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverStopped;
import org.apache.spark.streaming.scheduler.UpdateReceiverRateLimit;
import org.apache.spark.streaming.util.WriteAheadLogUtils$;
import org.apache.spark.util.CallSite;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\r5e!B\u0001\u0003\u0001\u0011a!a\u0004*fG\u0016Lg/\u001a:Ue\u0006\u001c7.\u001a:\u000b\u0005\r!\u0011!C:dQ\u0016$W\u000f\\3s\u0015\t)a!A\u0005tiJ,\u0017-\\5oO*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xmE\u0002\u0001\u001bM\u0001\"AD\t\u000e\u0003=Q\u0011\u0001E\u0001\u0006g\u000e\fG.Y\u0005\u0003%=\u0011a!\u00118z%\u00164\u0007C\u0001\u000b\u0016\u001b\u00051\u0011B\u0001\f\u0007\u0005\u001daunZ4j]\u001eD\u0001\u0002\u0007\u0001\u0003\u0002\u0003\u0006IAG\u0001\u0004gN\u001c7\u0001\u0001\t\u00037qi\u0011\u0001B\u0005\u0003;\u0011\u0011\u0001c\u0015;sK\u0006l\u0017N\\4D_:$X\r\u001f;\t\u0011}\u0001!\u0011!Q\u0001\n\u0001\n!c]6jaJ+7-Z5wKJd\u0015-\u001e8dQB\u0011a\"I\u0005\u0003E=\u0011qAQ8pY\u0016\fg\u000eC\u0003%\u0001\u0011\u0005Q%\u0001\u0004=S:LGO\u0010\u000b\u0004M!J\u0003CA\u0014\u0001\u001b\u0005\u0011\u0001\"\u0002\r$\u0001\u0004Q\u0002bB\u0010$!\u0003\u0005\r\u0001\t\u0005\bW\u0001\u0011\r\u0011\"\u0003-\u0003Q\u0011XmY3jm\u0016\u0014\u0018J\u001c9viN#(/Z1ngV\tQ\u0006E\u0002\u000f]AJ!aL\b\u0003\u000b\u0005\u0013(/Y=1\u0005EJ\u0004c\u0001\u001a6o5\t1G\u0003\u00025\t\u00059Am\u001d;sK\u0006l\u0017B\u0001\u001c4\u0005Q\u0011VmY3jm\u0016\u0014\u0018J\u001c9vi\u0012\u001bFO]3b[B\u0011\u0001(\u000f\u0007\u0001\t%Q\u0004!!A\u0001\u0002\u000b\u0005qHA\u0002`I]J!\u0001P\u001f\u0002/\u001d,GOU3dK&4XM]%oaV$8\u000b\u001e:fC6\u001c\u0018B\u0001 \u0005\u00051!5\u000b\u001e:fC6<%/\u00199i#\t\u00015\t\u0005\u0002\u000f\u0003&\u0011!i\u0004\u0002\b\u001d>$\b.\u001b8h!\tqA)\u0003\u0002F\u001f\t\u0019\u0011I\\=\t\r\u001d\u0003\u0001\u0015!\u0003.\u0003U\u0011XmY3jm\u0016\u0014\u0018J\u001c9viN#(/Z1ng\u0002Bq!\u0013\u0001C\u0002\u0013%!*\u0001\fsK\u000e,\u0017N^3s\u0013:\u0004X\u000f^*ue\u0016\fW.\u00133t+\u0005Y\u0005c\u0001\b/\u0019B\u0011a\"T\u0005\u0003\u001d>\u00111!\u00138u\u0011\u0019\u0001\u0006\u0001)A\u0005\u0017\u00069\"/Z2fSZ,'/\u00138qkR\u001cFO]3b[&#7\u000f\t\u0005\b%\u0002\u0011\r\u0011\"\u0003T\u0003Q\u0011XmY3jm\u0016$'\t\\8dWR\u0013\u0018mY6feV\tA\u000b\u0005\u0002(+&\u0011aK\u0001\u0002\u0015%\u0016\u001cW-\u001b<fI\ncwnY6Ue\u0006\u001c7.\u001a:\t\ra\u0003\u0001\u0015!\u0003U\u0003U\u0011XmY3jm\u0016$'\t\\8dWR\u0013\u0018mY6fe\u0002BqA\u0017\u0001C\u0002\u0013%1,A\u0006mSN$XM\\3s\u0005V\u001cX#\u0001/\u0011\u0005\u001dj\u0016B\u00010\u0003\u0005Q\u0019FO]3b[&tw\rT5ti\u0016tWM\u001d\"vg\"1\u0001\r\u0001Q\u0001\nq\u000bA\u0002\\5ti\u0016tWM\u001d\"vg\u0002:QA\u0019\u0001\t\u0002\r\fA\u0002\u0016:bG.,'o\u0015;bi\u0016\u0004\"\u0001Z3\u000e\u0003\u00011QA\u001a\u0001\t\u0002\u001d\u0014A\u0002\u0016:bG.,'o\u0015;bi\u0016\u001c\"!\u001a5\u0011\u00059I\u0017B\u00016\u0010\u0005-)e.^7fe\u0006$\u0018n\u001c8\t\u000b\u0011*G\u0011\u00017\u0015\u0003\r,AAZ3\u0001]B\u0011q\u000e]\u0007\u0002K&\u0011\u0011/\u001b\u0002\u0006-\u0006dW/\u001a\u0005\bg\u0016\u0014\r\u0011\"\u0001u\u0003-Ie.\u001b;jC2L'0\u001a3\u0016\u00039DaA^3!\u0002\u0013q\u0017\u0001D%oSRL\u0017\r\\5{K\u0012\u0004\u0003b\u0002=f\u0005\u0004%\t\u0001^\u0001\b'R\f'\u000f^3e\u0011\u0019QX\r)A\u0005]\u0006A1\u000b^1si\u0016$\u0007\u0005C\u0004}K\n\u0007I\u0011\u0001;\u0002\u0011M#x\u000e\u001d9j]\u001eDaA`3!\u0002\u0013q\u0017!C*u_B\u0004\u0018N\\4!\u0011!\t\t!\u001ab\u0001\n\u0003!\u0018aB*u_B\u0004X\r\u001a\u0005\b\u0003\u000b)\u0007\u0015!\u0003o\u0003!\u0019Fo\u001c9qK\u0012\u0004\u0003\"CA\u0005\u0001\u0001\u0007I\u0011BA\u0006\u00031!(/Y2lKJ\u001cF/\u0019;f+\t\ti\u0001E\u0002\u0002\u0010At!\u0001Z1\t\u0013\u0005M\u0001\u00011A\u0005\n\u0005U\u0011\u0001\u0005;sC\u000e\\WM]*uCR,w\fJ3r)\u0011\t9\"!\b\u0011\u00079\tI\"C\u0002\u0002\u001c=\u0011A!\u00168ji\"Q\u0011qDA\t\u0003\u0003\u0005\r!!\u0004\u0002\u0007a$\u0013\u0007\u0003\u0005\u0002$\u0001\u0001\u000b\u0015BA\u0007\u00035!(/Y2lKJ\u001cF/\u0019;fA!\"\u0011\u0011EA\u0014!\rq\u0011\u0011F\u0005\u0004\u0003Wy!\u0001\u0003<pY\u0006$\u0018\u000e\\3\t\u0013\u0005=\u0002\u00011A\u0005\n\u0005E\u0012\u0001C3oIB|\u0017N\u001c;\u0016\u0005\u0005M\u0002\u0003BA\u001b\u0003wi!!a\u000e\u000b\u0007\u0005eb!A\u0002sa\u000eLA!!\u0010\u00028\tq!\u000b]2F]\u0012\u0004x.\u001b8u%\u00164\u0007\"CA!\u0001\u0001\u0007I\u0011BA\"\u00031)g\u000e\u001a9pS:$x\fJ3r)\u0011\t9\"!\u0012\t\u0015\u0005}\u0011qHA\u0001\u0002\u0004\t\u0019\u0004\u0003\u0005\u0002J\u0001\u0001\u000b\u0015BA\u001a\u0003%)g\u000e\u001a9pS:$\b\u0005C\u0005\u0002N\u0001\u0011\r\u0011\"\u0003\u0002P\u0005\u00012o\u00195fIVd\u0017N\\4Q_2L7-_\u000b\u0003\u0003#\u00022aJA*\u0013\r\t)F\u0001\u0002\u0019%\u0016\u001cW-\u001b<feN\u001b\u0007.\u001a3vY&tw\rU8mS\u000eL\b\u0002CA-\u0001\u0001\u0006I!!\u0015\u0002#M\u001c\u0007.\u001a3vY&tw\rU8mS\u000eL\b\u0005C\u0005\u0002^\u0001\u0011\r\u0011\"\u0003\u0002`\u0005!\"/Z2fSZ,'OS8c\u000bbLG\u000fT1uG\",\"!!\u0019\u0011\t\u0005\r\u0014\u0011O\u0007\u0003\u0003KRA!a\u001a\u0002j\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005-\u0014QN\u0001\u0005kRLGN\u0003\u0002\u0002p\u0005!!.\u0019<b\u0013\u0011\t\u0019(!\u001a\u0003\u001d\r{WO\u001c;E_^tG*\u0019;dQ\"A\u0011q\u000f\u0001!\u0002\u0013\t\t'A\u000bsK\u000e,\u0017N^3s\u0015>\u0014W\t_5u\u0019\u0006$8\r\u001b\u0011\t\u0013\u0005m\u0004A1A\u0005\n\u0005u\u0014!\u0006:fG\u0016Lg/\u001a:Ue\u0006\u001c7.\u001b8h\u0013:4wn]\u000b\u0003\u0003\u007f\u0002r!!!\u0002\f2\u000by)\u0004\u0002\u0002\u0004*!\u0011QQAD\u0003\u001diW\u000f^1cY\u0016T1!!#\u0010\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u001b\u000b\u0019IA\u0004ICNDW*\u00199\u0011\u0007\u001d\n\t*C\u0002\u0002\u0014\n\u0011ACU3dK&4XM\u001d+sC\u000e\\\u0017N\\4J]\u001a|\u0007\u0002CAL\u0001\u0001\u0006I!a \u0002-I,7-Z5wKJ$&/Y2lS:<\u0017J\u001c4pg\u0002B\u0011\"a'\u0001\u0005\u0004%I!!(\u00025I,7-Z5wKJ\u0004&/\u001a4feJ,G\rT8dCRLwN\\:\u0016\u0005\u0005}\u0005cBAA\u0003\u0017c\u0015\u0011\u0015\t\u0006\u001d\u0005\r\u0016qU\u0005\u0004\u0003K{!AB(qi&|g\u000e\u0005\u0003\u0002*\u0006=fb\u0001\b\u0002,&\u0019\u0011QV\b\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t,a-\u0003\rM#(/\u001b8h\u0015\r\tik\u0004\u0005\t\u0003o\u0003\u0001\u0015!\u0003\u0002 \u0006Y\"/Z2fSZ,'\u000f\u0015:fM\u0016\u0014(/\u001a3M_\u000e\fG/[8og\u0002Bq!a/\u0001\t\u0003\ti,A\u0003ti\u0006\u0014H\u000f\u0006\u0002\u0002\u0018!9\u0011\u0011\u0019\u0001\u0005\u0002\u0005\r\u0017\u0001B:u_B$B!a\u0006\u0002F\"9\u0011qYA`\u0001\u0004\u0001\u0013\u0001C4sC\u000e,g-\u001e7\t\u000f\u0005-\u0007\u0001\"\u0001\u0002N\u0006)\u0012\r\u001c7pG\u0006$XM\u00117pG.\u001cHk\u001c\"bi\u000eDG\u0003BA\f\u0003\u001fD\u0001\"!5\u0002J\u0002\u0007\u00111[\u0001\nE\u0006$8\r\u001b+j[\u0016\u00042aGAk\u0013\r\t9\u000e\u0002\u0002\u0005)&lW\rC\u0004\u0002\\\u0002!\t!!8\u0002!\u001d,GO\u00117pG.\u001cxJ\u001a\"bi\u000eDG\u0003BAp\u0005\u0007\u0001r!!+\u0002b2\u000b)/\u0003\u0003\u0002d\u0006M&aA'baB1\u0011q]A|\u0003{tA!!;\u0002t:!\u00111^Ay\u001b\t\tiOC\u0002\u0002pf\ta\u0001\u0010:p_Rt\u0014\"\u0001\t\n\u0007\u0005Ux\"A\u0004qC\u000e\\\u0017mZ3\n\t\u0005e\u00181 \u0002\u0004'\u0016\f(bAA{\u001fA\u0019q%a@\n\u0007\t\u0005!AA\tSK\u000e,\u0017N^3e\u00052|7m[%oM>D\u0001\"!5\u0002Z\u0002\u0007\u00111\u001b\u0005\b\u0005\u000f\u0001A\u0011\u0001B\u0005\u0003e9W\r\u001e\"m_\u000e\\7o\u00144CCR\u001c\u0007.\u00118e'R\u0014X-Y7\u0015\r\u0005\u0015(1\u0002B\u0007\u0011!\t\tN!\u0002A\u0002\u0005M\u0007b\u0002B\b\u0005\u000b\u0001\r\u0001T\u0001\tgR\u0014X-Y7JI\"9!1\u0003\u0001\u0005\u0002\tU\u0011AG2mK\u0006tW\u000f](mI\ncwnY6t\u0003:$')\u0019;dQ\u0016\u001cH\u0003BA\f\u0005/A\u0001B!\u0007\u0003\u0012\u0001\u0007\u00111[\u0001\u0012G2,\u0017M\\;q)\"\u0014Xm\u001d5US6,\u0007b\u0002B\u000f\u0001\u0011%!qD\u0001\u0011e\u0016<\u0017n\u001d;feJ+7-Z5wKJ$R\u0002\tB\u0011\u0005G\u00119Ca\u000b\u00030\tM\u0002b\u0002B\b\u00057\u0001\r\u0001\u0014\u0005\t\u0005K\u0011Y\u00021\u0001\u0002(\u0006\u0019A/\u001f9\t\u0011\t%\"1\u0004a\u0001\u0003O\u000bA\u0001[8ti\"A!Q\u0006B\u000e\u0001\u0004\t9+\u0001\u0006fq\u0016\u001cW\u000f^8s\u0013\u0012D\u0001B!\r\u0003\u001c\u0001\u0007\u00111G\u0001\u0011e\u0016\u001cW-\u001b<fe\u0016sG\r]8j]RD\u0001B!\u000e\u0003\u001c\u0001\u0007!qG\u0001\u000eg\u0016tG-\u001a:BI\u0012\u0014Xm]:\u0011\t\u0005U\"\u0011H\u0005\u0005\u0005w\t9D\u0001\u0006Sa\u000e\fE\r\u001a:fgNDqAa\u0010\u0001\t\u0013\u0011\t%\u0001\neKJ,w-[:uKJ\u0014VmY3jm\u0016\u0014H\u0003CA\f\u0005\u0007\u0012)E!\u0013\t\u000f\t=!Q\ba\u0001\u0019\"A!q\tB\u001f\u0001\u0004\t9+A\u0004nKN\u001c\u0018mZ3\t\u0011\t-#Q\ba\u0001\u0003O\u000bQ!\u001a:s_JDqAa\u0014\u0001\t\u0003\u0011\t&\u0001\btK:$'+\u0019;f+B$\u0017\r^3\u0015\r\u0005]!1\u000bB,\u0011\u001d\u0011)F!\u0014A\u00021\u000b\u0011b\u001d;sK\u0006lW+\u0013#\t\u0011\te#Q\na\u0001\u00057\nqA\\3x%\u0006$X\rE\u0002\u000f\u0005;J1Aa\u0018\u0010\u0005\u0011auN\\4\t\u000f\t\r\u0004\u0001\"\u0003\u0003f\u0005A\u0011\r\u001a3CY>\u001c7\u000eF\u0002!\u0005OB\u0001B!\u001b\u0003b\u0001\u0007\u0011Q`\u0001\u0012e\u0016\u001cW-\u001b<fI\ncwnY6J]\u001a|\u0007b\u0002B7\u0001\u0011%!qN\u0001\fe\u0016\u0004xN\u001d;FeJ|'\u000f\u0006\u0005\u0002\u0018\tE$1\u000fB;\u0011\u001d\u0011yAa\u001bA\u00021C\u0001Ba\u0012\u0003l\u0001\u0007\u0011q\u0015\u0005\t\u0005\u0017\u0012Y\u00071\u0001\u0002(\"9!\u0011\u0010\u0001\u0005\n\tm\u0014\u0001E:dQ\u0016$W\u000f\\3SK\u000e,\u0017N^3s)\u0011\u0011iH!#\u0011\r\u0005\u001d\u0018q\u001fB@!\u0011\u0011\tI!\"\u000e\u0005\t\r%BA\u0002\u0007\u0013\u0011\u00119Ia!\u0003\u0019Q\u000b7o\u001b'pG\u0006$\u0018n\u001c8\t\u000f\t-%q\u000fa\u0001\u0019\u0006Q!/Z2fSZ,'/\u00133\t\u000f\t=\u0005\u0001\"\u0003\u0003\u0012\u0006\u0001S\u000f\u001d3bi\u0016\u0014VmY3jm\u0016\u00148k\u00195fIVdW\rZ#yK\u000e,Ho\u001c:t)\u0019\t9Ba%\u0003\u0016\"9!1\u0012BG\u0001\u0004a\u0005\u0002\u0003BL\u0005\u001b\u0003\rA! \u0002%M\u001c\u0007.\u001a3vY\u0016$Gj\\2bi&|gn\u001d\u0005\b\u00057\u0003A\u0011\u0001BO\u0003QA\u0017m]+oC2dwnY1uK\u0012\u0014En\\2lgV\t\u0001\u0005C\u0004\u0003\"\u0002!IAa)\u0002\u0019\u001d,G/\u0012=fGV$xN]:\u0016\u0005\t\u0015\u0006CBAt\u0003o\u00149\u000b\u0005\u0003\u0003\u0002\n%\u0016\u0002\u0002BV\u0005\u0007\u0013\u0011$\u0012=fGV$xN]\"bG\",G+Y:l\u0019>\u001c\u0017\r^5p]\"9!q\u0016\u0001\u0005\n\u0005u\u0016\u0001\u0005:v]\u0012+X.\\=Ta\u0006\u00148NS8c\u0011\u001d\u0011\u0019\f\u0001C\u0005\u0003{\u000bq\u0002\\1v]\u000eD'+Z2fSZ,'o\u001d\u0005\b\u0005o\u0003A\u0011\u0002BO\u0003AI7\u000f\u0016:bG.,'o\u0015;beR,G\rC\u0004\u0003<\u0002!IA!(\u0002#%\u001cHK]1dW\u0016\u00148\u000b^8qa&tw\rC\u0004\u0003@\u0002!IA!(\u0002!%\u001cHK]1dW\u0016\u00148\u000b^8qa\u0016$gA\u0002Bb\u0001\u0011\u0011)MA\fSK\u000e,\u0017N^3s)J\f7m[3s\u000b:$\u0007o\\5oiN)!\u0011Y\u0007\u0003HB!\u0011Q\u0007Be\u0013\u0011\u0011Y-a\u000e\u0003+QC'/Z1e'\u00064WM\u00159d\u000b:$\u0007o\\5oi\"Y!q\u001aBa\u0005\u000b\u0007I\u0011\tBi\u0003\u0019\u0011\boY#omV\u0011!1\u001b\t\u0005\u0003k\u0011).\u0003\u0003\u0003X\u0006]\"A\u0002*qG\u0016sg\u000fC\u0006\u0003\\\n\u0005'\u0011!Q\u0001\n\tM\u0017a\u0002:qG\u0016sg\u000f\t\u0005\bI\t\u0005G\u0011\u0001Bp)\u0011\u0011\tOa9\u0011\u0007\u0011\u0014\t\r\u0003\u0005\u0003P\nu\u0007\u0019\u0001Bj\u0011)\u00119O!1C\u0002\u0013%!\u0011^\u0001\u0014gV\u0014W.\u001b;K_\n$\u0006N]3bIB{w\u000e\\\u000b\u0003\u0005W\u0004BA!<\u0003r6\u0011!q\u001e\u0006\u0004\u0003Oz\u0011\u0002\u0002Bz\u0005_\u0014q$\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;Fq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0011%\u00119P!1!\u0002\u0013\u0011Y/\u0001\u000btk\nl\u0017\u000e\u001e&pERC'/Z1e!>|G\u000e\t\u0005\u000b\u0005w\u0014\tM1A\u0005\n\t%\u0018!F<bY\n\u000bGo\u00195j]\u001e$\u0006N]3bIB{w\u000e\u001c\u0005\n\u0005\u007f\u0014\t\r)A\u0005\u0005W\fac^1m\u0005\u0006$8\r[5oORC'/Z1e!>|G\u000e\t\u0005\u000b\u0007\u0007\u0011\t\r1A\u0005\n\tu\u0015AB1di&4X\r\u0003\u0006\u0004\b\t\u0005\u0007\u0019!C\u0005\u0007\u0013\t!\"Y2uSZ,w\fJ3r)\u0011\t9ba\u0003\t\u0013\u0005}1QAA\u0001\u0002\u0004\u0001\u0003\u0002CB\b\u0005\u0003\u0004\u000b\u0015\u0002\u0011\u0002\u000f\u0005\u001cG/\u001b<fA!\"1QBA\u0014\u0011!\u0019)B!1\u0005B\r]\u0011a\u0002:fG\u0016Lg/Z\u000b\u0003\u00073\u0001bADB\u000e\u0007\u0006]\u0011bAB\u000f\u001f\ty\u0001+\u0019:uS\u0006dg)\u001e8di&|g\u000e\u0003\u0005\u0004\"\t\u0005G\u0011IB\u0012\u0003=\u0011XmY3jm\u0016\fe\u000e\u001a*fa2LH\u0003BB\r\u0007KA\u0001ba\n\u0004 \u0001\u00071\u0011F\u0001\bG>tG/\u001a=u!\u0011\t)da\u000b\n\t\r5\u0012q\u0007\u0002\u000f%B\u001c7)\u00197m\u0007>tG/\u001a=u\u0011!\u0019\tD!1\u0005\n\rM\u0012aG4fiN#xN]3e'\u000eDW\rZ;mK\u0012,\u00050Z2vi>\u00148\u000f\u0006\u0003\u0003~\rU\u0002b\u0002BF\u0007_\u0001\r\u0001\u0014\u0005\t\u0007s\u0011\t\r\"\u0003\u0004<\u0005i1\u000f^1siJ+7-Z5wKJ$b!a\u0006\u0004>\rM\u0003\u0002CB \u0007o\u0001\ra!\u0011\u0002\u0011I,7-Z5wKJ\u0004Daa\u0011\u0004PA11QIB%\u0007\u001bj!aa\u0012\u000b\u0007\r}B!\u0003\u0003\u0004L\r\u001d#\u0001\u0003*fG\u0016Lg/\u001a:\u0011\u0007a\u001ay\u0005B\u0006\u0004R\ru\u0012\u0011!A\u0001\u0006\u0003y$aA0%g!A!qSB\u001c\u0001\u0004\u0011i\b\u0003\u0005\u0004X\t\u0005G\u0011IA_\u0003\u0019ygn\u0015;pa\"A11\fBa\t\u0013\u0019i&A\np]J+7-Z5wKJTuN\u0019$j]&\u001c\b\u000e\u0006\u0003\u0002\u0018\r}\u0003b\u0002BF\u00073\u0002\r\u0001\u0014\u0005\t\u0007G\u0012\t\r\"\u0003\u0002>\u0006i1\u000f^8q%\u0016\u001cW-\u001b<feN<!ba\u001a\u0003\u0003\u0003E\t\u0001BB5\u0003=\u0011VmY3jm\u0016\u0014HK]1dW\u0016\u0014\bcA\u0014\u0004l\u0019I\u0011AAA\u0001\u0012\u0003!1QN\n\u0004\u0007Wj\u0001b\u0002\u0013\u0004l\u0011\u00051\u0011\u000f\u000b\u0003\u0007SB!b!\u001e\u0004lE\u0005I\u0011AB<\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u00111\u0011\u0010\u0016\u0004A\rm4FAB?!\u0011\u0019yh!#\u000e\u0005\r\u0005%\u0002BBB\u0007\u000b\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\r\u001du\"\u0001\u0006b]:|G/\u0019;j_:LAaa#\u0004\u0002\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class ReceiverTracker
implements Logging {
    public final StreamingContext org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc;
    private final boolean skipReceiverLaunch;
    private final ReceiverInputDStream<?>[] receiverInputStreams;
    private final int[] receiverInputStreamIds;
    private final ReceivedBlockTracker receivedBlockTracker;
    private final StreamingListenerBus listenerBus;
    private volatile Enumeration.Value trackerState;
    private RpcEndpointRef endpoint;
    private final ReceiverSchedulingPolicy org$apache$spark$streaming$scheduler$ReceiverTracker$$schedulingPolicy;
    private final CountDownLatch org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverJobExitLatch;
    private final HashMap<Object, ReceiverTrackingInfo> org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos;
    private final HashMap<Object, Option<String>> org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverPreferredLocations;
    private volatile ReceiverTracker$TrackerState$ TrackerState$module;
    private transient Logger org$apache$spark$Logging$$log_;

    public static boolean $lessinit$greater$default$2() {
        return ReceiverTracker$.MODULE$.$lessinit$greater$default$2();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ReceiverTracker$TrackerState$ TrackerState$lzycompute() {
        ReceiverTracker receiverTracker = this;
        synchronized (receiverTracker) {
            if (this.TrackerState$module != null) return this.TrackerState$module;
            this.TrackerState$module = new ReceiverTracker$TrackerState$(this);
            return this.TrackerState$module;
        }
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    private ReceiverInputDStream<?>[] receiverInputStreams() {
        return this.receiverInputStreams;
    }

    private int[] receiverInputStreamIds() {
        return this.receiverInputStreamIds;
    }

    private ReceivedBlockTracker receivedBlockTracker() {
        return this.receivedBlockTracker;
    }

    private StreamingListenerBus listenerBus() {
        return this.listenerBus;
    }

    public ReceiverTracker$TrackerState$ TrackerState() {
        return this.TrackerState$module == null ? this.TrackerState$lzycompute() : this.TrackerState$module;
    }

    private Enumeration.Value trackerState() {
        return this.trackerState;
    }

    private void trackerState_$eq(Enumeration.Value x$1) {
        this.trackerState = x$1;
    }

    private RpcEndpointRef endpoint() {
        return this.endpoint;
    }

    private void endpoint_$eq(RpcEndpointRef x$1) {
        this.endpoint = x$1;
    }

    public ReceiverSchedulingPolicy org$apache$spark$streaming$scheduler$ReceiverTracker$$schedulingPolicy() {
        return this.org$apache$spark$streaming$scheduler$ReceiverTracker$$schedulingPolicy;
    }

    public CountDownLatch org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverJobExitLatch() {
        return this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverJobExitLatch;
    }

    public HashMap<Object, ReceiverTrackingInfo> org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos() {
        return this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos;
    }

    public HashMap<Object, Option<String>> org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverPreferredLocations() {
        return this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverPreferredLocations;
    }

    public synchronized void start() {
        if (this.isTrackerStarted()) {
            throw new SparkException("ReceiverTracker already started");
        }
        if (!Predef$.MODULE$.refArrayOps((Object[])this.receiverInputStreams()).isEmpty()) {
            this.endpoint_$eq(this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.env().rpcEnv().setupEndpoint("ReceiverTracker", (RpcEndpoint)new ReceiverTrackerEndpoint(this, this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.env().rpcEnv())));
            if (!this.skipReceiverLaunch) {
                this.launchReceivers();
            }
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "ReceiverTracker started";
                }
            });
            this.trackerState_$eq(this.TrackerState().Started());
        }
    }

    public synchronized void stop(boolean graceful) {
        if (this.isTrackerStarted()) {
            this.trackerState_$eq(this.TrackerState().Stopping());
            if (!this.skipReceiverLaunch) {
                Seq receivers;
                this.endpoint().askWithRetry((Object)StopAllReceivers$.MODULE$, ClassTag$.MODULE$.Boolean());
                this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverJobExitLatch().await(10L, TimeUnit.SECONDS);
                if (graceful) {
                    this.logInfo((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Waiting for receiver job to terminate gracefully";
                        }
                    });
                    this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverJobExitLatch().await();
                    this.logInfo((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Waited for receiver job to terminate gracefully";
                        }
                    });
                }
                if ((receivers = (Seq)this.endpoint().askWithRetry((Object)AllReceiverIds$.MODULE$, ClassTag$.MODULE$.apply(Seq.class))).nonEmpty()) {
                    this.logWarning((Function0<String>)new Serializable(this, receivers){
                        public static final long serialVersionUID = 0L;
                        private final Seq receivers$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Not all of the receivers have deregistered, ").append((Object)this.receivers$1).toString();
                        }
                        {
                            this.receivers$1 = receivers$1;
                        }
                    });
                } else {
                    this.logInfo((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "All of the receivers have deregistered successfully";
                        }
                    });
                }
            }
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.env().rpcEnv().stop(this.endpoint());
            this.endpoint_$eq(null);
            this.receivedBlockTracker().stop();
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "ReceiverTracker stopped";
                }
            });
            this.trackerState_$eq(this.TrackerState().Stopped());
        }
    }

    public void allocateBlocksToBatch(Time batchTime) {
        if (Predef$.MODULE$.refArrayOps((Object[])this.receiverInputStreams()).nonEmpty()) {
            this.receivedBlockTracker().allocateBlocksToBatch(batchTime);
        }
    }

    public scala.collection.immutable.Map<Object, Seq<ReceivedBlockInfo>> getBlocksOfBatch(Time batchTime) {
        return this.receivedBlockTracker().getBlocksOfBatch(batchTime);
    }

    public Seq<ReceivedBlockInfo> getBlocksOfBatchAndStream(Time batchTime, int streamId) {
        return this.receivedBlockTracker().getBlocksOfBatchAndStream(batchTime, streamId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void cleanupOldBlocksAndBatches(Time cleanupThreshTime) {
        this.receivedBlockTracker().cleanupOldBatches(cleanupThreshTime, false);
        if (!WriteAheadLogUtils$.MODULE$.enableReceiverLog(this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.conf())) return;
        this.logInfo((Function0<String>)new Serializable(this, cleanupThreshTime){
            public static final long serialVersionUID = 0L;
            private final Time cleanupThreshTime$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cleanup old received batch data: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cleanupThreshTime$1}));
            }
            {
                this.cleanupThreshTime$1 = cleanupThreshTime$1;
            }
        });
        ReceiverTracker receiverTracker = this;
        synchronized (receiverTracker) {
            BoxedUnit boxedUnit;
            if (this.isTrackerStarted()) {
                this.endpoint().send((Object)new CleanupOldBlocks(cleanupThreshTime));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public boolean org$apache$spark$streaming$scheduler$ReceiverTracker$$registerReceiver(int streamId, String typ, String host, String executorId, RpcEndpointRef receiverEndpoint, RpcAddress senderAddress) {
        if (Predef$.MODULE$.intArrayOps(this.receiverInputStreamIds()).contains((Object)BoxesRunTime.boxToInteger((int)streamId))) {
            boolean bl;
            Seq<TaskLocation> acceptableExecutors;
            if (this.org$apache$spark$streaming$scheduler$ReceiverTracker$$isTrackerStopping() || this.org$apache$spark$streaming$scheduler$ReceiverTracker$$isTrackerStopped()) {
                return false;
            }
            Option<Seq<TaskLocation>> scheduledLocations = ((ReceiverTrackingInfo)this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().apply((Object)BoxesRunTime.boxToInteger((int)streamId))).scheduledLocations();
            Seq<TaskLocation> seq = acceptableExecutors = scheduledLocations.nonEmpty() ? (Seq<TaskLocation>)scheduledLocations.get() : this.scheduleReceiver(streamId);
            if (this.isAcceptable$1(host, executorId, acceptableExecutors)) {
                String name = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{typ, BoxesRunTime.boxToInteger((int)streamId)}));
                ReceiverTrackingInfo receiverTrackingInfo = new ReceiverTrackingInfo(streamId, ReceiverState$.MODULE$.ACTIVE(), (Option<Seq<TaskLocation>>)None$.MODULE$, (Option<ExecutorCacheTaskLocation>)new Some((Object)new ExecutorCacheTaskLocation(host, executorId)), (Option<String>)new Some((Object)name), (Option<RpcEndpointRef>)new Some((Object)receiverEndpoint), ReceiverTrackingInfo$.MODULE$.apply$default$7());
                this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().put((Object)BoxesRunTime.boxToInteger((int)streamId), (Object)receiverTrackingInfo);
                this.listenerBus().post(new StreamingListenerReceiverStarted(receiverTrackingInfo.toReceiverInfo()));
                this.logInfo((Function0<String>)new Serializable(this, streamId, senderAddress){
                    public static final long serialVersionUID = 0L;
                    private final int streamId$1;
                    private final RpcAddress senderAddress$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Registered receiver for stream ").append((Object)BoxesRunTime.boxToInteger((int)this.streamId$1)).append((Object)" from ").append((Object)this.senderAddress$1).toString();
                    }
                    {
                        this.streamId$1 = streamId$1;
                        this.senderAddress$1 = senderAddress$1;
                    }
                });
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }
        throw new SparkException(new StringBuilder().append((Object)"Register received for unexpected id ").append((Object)BoxesRunTime.boxToInteger((int)streamId)).toString());
    }

    /*
     * Unable to fully structure code
     */
    public void org$apache$spark$streaming$scheduler$ReceiverTracker$$deregisterReceiver(int streamId, String message, String error) {
        block7: {
            block6: {
                block5: {
                    if (error == null) ** GOTO lbl-1000
                    v0 = error;
                    var6_4 = "";
                    if (!(v0 != null ? v0.equals(var6_4) == false : var6_4 != null)) lbl-1000:
                    // 2 sources

                    {
                        v1 = -1L;
                    } else {
                        v1 = this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.scheduler().clock().getTimeMillis();
                    }
                    lastErrorTime = v1;
                    errorInfo = new ReceiverErrorInfo(message, error, lastErrorTime);
                    var9_7 = this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().get((Object)BoxesRunTime.boxToInteger((int)streamId));
                    if (!(var9_7 instanceof Some)) break block5;
                    var10_8 = (Some)var9_7;
                    oldInfo = (ReceiverTrackingInfo)var10_8.x();
                    x$13 = ReceiverState$.MODULE$.INACTIVE();
                    x$14 = new Some((Object)errorInfo);
                    x$15 = oldInfo.copy$default$1();
                    x$16 = oldInfo.copy$default$3();
                    x$17 = oldInfo.copy$default$4();
                    x$18 = oldInfo.copy$default$5();
                    x$19 = oldInfo.copy$default$6();
                    var12_17 = oldInfo.copy(x$15, x$13, x$16, x$17, x$18, x$19, (Option<ReceiverErrorInfo>)x$14);
                    break block6;
                }
                v2 = None$.MODULE$;
                var20_18 = var9_7;
                if (v2 != null ? v2.equals(var20_18) == false : var20_18 != null) break block7;
                this.logWarning((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "No prior receiver info";
                    }
                });
                var12_17 = new ReceiverTrackingInfo(streamId, ReceiverState$.MODULE$.INACTIVE(), (Option<Seq<TaskLocation>>)None$.MODULE$, (Option<ExecutorCacheTaskLocation>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<RpcEndpointRef>)None$.MODULE$, (Option<ReceiverErrorInfo>)new Some((Object)errorInfo));
            }
            newReceiverTrackingInfo = var12_17;
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().update((Object)BoxesRunTime.boxToInteger((int)streamId), (Object)newReceiverTrackingInfo);
            this.listenerBus().post(new StreamingListenerReceiverStopped(newReceiverTrackingInfo.toReceiverInfo()));
            messageWithError = error == null || error.isEmpty() != false ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " - ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message, error}));
            this.logError((Function0<String>)new Serializable(this, streamId, messageWithError){
                public static final long serialVersionUID = 0L;
                private final int streamId$2;
                private final String messageWithError$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deregistered receiver for stream ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.streamId$2), this.messageWithError$1}));
                }
                {
                    this.streamId$2 = streamId$2;
                    this.messageWithError$1 = messageWithError$1;
                }
            });
            return;
        }
        throw new MatchError((Object)var9_7);
    }

    public synchronized void sendRateUpdate(int streamUID, long newRate) {
        if (this.isTrackerStarted()) {
            this.endpoint().send((Object)new UpdateReceiverRateLimit(streamUID, newRate));
        }
    }

    public boolean org$apache$spark$streaming$scheduler$ReceiverTracker$$addBlock(ReceivedBlockInfo receivedBlockInfo) {
        return this.receivedBlockTracker().addBlock(receivedBlockInfo);
    }

    public void org$apache$spark$streaming$scheduler$ReceiverTracker$$reportError(int streamId, String message, String error) {
        Option option;
        block4: {
            ReceiverTrackingInfo receiverTrackingInfo;
            block3: {
                block2: {
                    option = this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().get((Object)BoxesRunTime.boxToInteger((int)streamId));
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    ReceiverTrackingInfo oldInfo = (ReceiverTrackingInfo)some.x();
                    ReceiverErrorInfo errorInfo = new ReceiverErrorInfo(message, error, BoxesRunTime.unboxToLong((Object)oldInfo.errorInfo().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(ReceiverErrorInfo x$2) {
                            return x$2.lastErrorTime();
                        }
                    }).getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply() {
                            return this.apply$mcJ$sp();
                        }

                        public long apply$mcJ$sp() {
                            return -1L;
                        }
                    })));
                    Some x$20 = new Some((Object)errorInfo);
                    int x$21 = oldInfo.copy$default$1();
                    Enumeration.Value x$22 = oldInfo.copy$default$2();
                    Option<Seq<TaskLocation>> x$23 = oldInfo.copy$default$3();
                    Option<ExecutorCacheTaskLocation> x$24 = oldInfo.copy$default$4();
                    Option<String> x$25 = oldInfo.copy$default$5();
                    Option<RpcEndpointRef> x$26 = oldInfo.copy$default$6();
                    receiverTrackingInfo = oldInfo.copy(x$21, x$22, x$23, x$24, x$25, x$26, (Option<ReceiverErrorInfo>)x$20);
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                this.logWarning((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "No prior receiver info";
                    }
                });
                ReceiverErrorInfo errorInfo = new ReceiverErrorInfo(message, error, this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.scheduler().clock().getTimeMillis());
                receiverTrackingInfo = new ReceiverTrackingInfo(streamId, ReceiverState$.MODULE$.INACTIVE(), (Option<Seq<TaskLocation>>)None$.MODULE$, (Option<ExecutorCacheTaskLocation>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<RpcEndpointRef>)None$.MODULE$, (Option<ReceiverErrorInfo>)new Some((Object)errorInfo));
            }
            ReceiverTrackingInfo newReceiverTrackingInfo = receiverTrackingInfo;
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().update((Object)BoxesRunTime.boxToInteger((int)streamId), (Object)newReceiverTrackingInfo);
            this.listenerBus().post(new StreamingListenerReceiverError(newReceiverTrackingInfo.toReceiverInfo()));
            String messageWithError = error == null || error.isEmpty() ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " - ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message, error}));
            this.logWarning((Function0<String>)new Serializable(this, streamId, messageWithError){
                public static final long serialVersionUID = 0L;
                private final int streamId$3;
                private final String messageWithError$2;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error reported by receiver for stream ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.streamId$3), this.messageWithError$2}));
                }
                {
                    this.streamId$3 = streamId$3;
                    this.messageWithError$2 = messageWithError$2;
                }
            });
            return;
        }
        throw new MatchError((Object)option);
    }

    /*
     * WARNING - void declaration
     */
    private Seq<TaskLocation> scheduleReceiver(int receiverId) {
        void var3_3;
        Option preferredLocation = (Option)this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverPreferredLocations().getOrElse((Object)BoxesRunTime.boxToInteger((int)receiverId), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final None$ apply() {
                return None$.MODULE$;
            }
        });
        Seq<TaskLocation> scheduledLocations = this.org$apache$spark$streaming$scheduler$ReceiverTracker$$schedulingPolicy().rescheduleReceiver(receiverId, (Option<String>)preferredLocation, (Map<Object, ReceiverTrackingInfo>)this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos(), this.org$apache$spark$streaming$scheduler$ReceiverTracker$$getExecutors());
        this.org$apache$spark$streaming$scheduler$ReceiverTracker$$updateReceiverScheduledExecutors(receiverId, scheduledLocations);
        return var3_3;
    }

    public void org$apache$spark$streaming$scheduler$ReceiverTracker$$updateReceiverScheduledExecutors(int receiverId, Seq<TaskLocation> scheduledLocations) {
        Option option;
        block4: {
            ReceiverTrackingInfo receiverTrackingInfo;
            block3: {
                block2: {
                    option = this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().get((Object)BoxesRunTime.boxToInteger((int)receiverId));
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    ReceiverTrackingInfo oldInfo = (ReceiverTrackingInfo)some.x();
                    Enumeration.Value x$27 = ReceiverState$.MODULE$.SCHEDULED();
                    Some x$28 = new Some(scheduledLocations);
                    int x$29 = oldInfo.copy$default$1();
                    Option<ExecutorCacheTaskLocation> x$30 = oldInfo.copy$default$4();
                    Option<String> x$31 = oldInfo.copy$default$5();
                    Option<RpcEndpointRef> x$32 = oldInfo.copy$default$6();
                    Option<ReceiverErrorInfo> x$33 = oldInfo.copy$default$7();
                    receiverTrackingInfo = oldInfo.copy(x$29, x$27, (Option<Seq<TaskLocation>>)x$28, x$30, x$31, x$32, x$33);
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                receiverTrackingInfo = new ReceiverTrackingInfo(receiverId, ReceiverState$.MODULE$.SCHEDULED(), (Option<Seq<TaskLocation>>)new Some(scheduledLocations), (Option<ExecutorCacheTaskLocation>)None$.MODULE$, ReceiverTrackingInfo$.MODULE$.apply$default$5(), ReceiverTrackingInfo$.MODULE$.apply$default$6(), ReceiverTrackingInfo$.MODULE$.apply$default$7());
            }
            ReceiverTrackingInfo newReceiverTrackingInfo = receiverTrackingInfo;
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().put((Object)BoxesRunTime.boxToInteger((int)receiverId), (Object)newReceiverTrackingInfo);
            return;
        }
        throw new MatchError((Object)option);
    }

    public boolean hasUnallocatedBlocks() {
        return this.receivedBlockTracker().hasUnallocatedReceivedBlocks();
    }

    public Seq<ExecutorCacheTaskLocation> org$apache$spark$streaming$scheduler$ReceiverTracker$$getExecutors() {
        Seq seq;
        if (this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sc().isLocal()) {
            BlockManagerId blockManagerId = this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().env().blockManager().blockManagerId();
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExecutorCacheTaskLocation[]{new ExecutorCacheTaskLocation(blockManagerId.host(), blockManagerId.executorId())}));
        } else {
            seq = ((TraversableOnce)((TraversableLike)this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().env().blockManager().master().getMemoryStatus().filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<BlockManagerId, Tuple2<Object, Object>> x0$2) {
                    Tuple2<BlockManagerId, Tuple2<Object, Object>> tuple2 = x0$2;
                    if (tuple2 != null) {
                        BlockManagerId blockManagerId = (BlockManagerId)tuple2._1();
                        String string = blockManagerId.executorId();
                        String string2 = SparkContext$.MODULE$.DRIVER_IDENTIFIER();
                        boolean bl = string != null ? !string.equals(string2) : string2 != null;
                        return bl;
                    }
                    throw new MatchError(tuple2);
                }
            })).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ExecutorCacheTaskLocation apply(Tuple2<BlockManagerId, Tuple2<Object, Object>> x0$3) {
                    Tuple2<BlockManagerId, Tuple2<Object, Object>> tuple2 = x0$3;
                    if (tuple2 != null) {
                        BlockManagerId blockManagerId = (BlockManagerId)tuple2._1();
                        ExecutorCacheTaskLocation executorCacheTaskLocation = new ExecutorCacheTaskLocation(blockManagerId.host(), blockManagerId.executorId());
                        return executorCacheTaskLocation;
                    }
                    throw new MatchError(tuple2);
                }
            }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        }
        return seq;
    }

    private void runDummySparkJob() {
        Object object = this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().isLocal() ? BoxedUnit.UNIT : RDD$.MODULE$.rddToPairRDDFunctions(this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().makeRDD((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 50), 50, ClassTag$.MODULE$.Int()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(int x) {
                return new Tuple2.mcII.sp(x, 1);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).reduceByKey((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(int x$3, int x$4) {
                return this.apply$mcIII$sp(x$3, x$4);
            }

            public int apply$mcIII$sp(int x$3, int x$4) {
                return x$3 + x$4;
            }
        }, 20).collect();
        Predef$.MODULE$.assert(this.org$apache$spark$streaming$scheduler$ReceiverTracker$$getExecutors().nonEmpty());
    }

    private void launchReceivers() {
        Receiver[] receivers = (Receiver[])Predef$.MODULE$.refArrayOps((Object[])this.receiverInputStreams()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             */
            public final Receiver<?> apply(ReceiverInputDStream<?> nis) {
                void var2_2;
                Receiver<?> rcvr = nis.getReceiver();
                rcvr.setReceiverId(nis.id());
                return var2_2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Receiver.class)));
        this.runDummySparkJob();
        this.logInfo((Function0<String>)new Serializable(this, receivers){
            public static final long serialVersionUID = 0L;
            private final Receiver[] receivers$2;

            public final String apply() {
                return new StringBuilder().append((Object)"Starting ").append((Object)BoxesRunTime.boxToInteger((int)this.receivers$2.length)).append((Object)" receivers").toString();
            }
            {
                this.receivers$2 = receivers$2;
            }
        });
        this.endpoint().send((Object)new StartAllReceivers((Seq<Receiver<?>>)Predef$.MODULE$.wrapRefArray((Object[])receivers)));
    }

    private boolean isTrackerStarted() {
        Enumeration.Value value = this.trackerState();
        Enumeration.Value value2 = this.TrackerState().Started();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public boolean org$apache$spark$streaming$scheduler$ReceiverTracker$$isTrackerStopping() {
        Enumeration.Value value = this.trackerState();
        Enumeration.Value value2 = this.TrackerState().Stopping();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public boolean org$apache$spark$streaming$scheduler$ReceiverTracker$$isTrackerStopped() {
        Enumeration.Value value = this.trackerState();
        Enumeration.Value value2 = this.TrackerState().Stopped();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    private final boolean isAcceptable$1(String host$1, String executorId$1, Seq acceptableExecutors$1) {
        return acceptableExecutors$1.exists((Function1)new Serializable(this, host$1, executorId$1){
            public static final long serialVersionUID = 0L;
            private final String host$1;
            private final String executorId$1;

            public final boolean apply(TaskLocation x0$1) {
                TaskLocation taskLocation;
                block4: {
                    boolean bl;
                    block3: {
                        block2: {
                            taskLocation = x0$1;
                            if (!(taskLocation instanceof ExecutorCacheTaskLocation)) break block2;
                            ExecutorCacheTaskLocation executorCacheTaskLocation = (ExecutorCacheTaskLocation)taskLocation;
                            String string = executorCacheTaskLocation.executorId();
                            String string2 = this.executorId$1;
                            bl = !(string != null ? !string.equals(string2) : string2 != null);
                            break block3;
                        }
                        if (taskLocation == null) break block4;
                        TaskLocation taskLocation2 = taskLocation;
                        String string = taskLocation2.host();
                        String string3 = this.host$1;
                        bl = !(string != null ? !string.equals(string3) : string3 != null);
                    }
                    return bl;
                }
                throw new MatchError((Object)taskLocation);
            }
            {
                this.host$1 = host$1;
                this.executorId$1 = executorId$1;
            }
        });
    }

    public ReceiverTracker(StreamingContext ssc, boolean skipReceiverLaunch) {
        this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc = ssc;
        this.skipReceiverLaunch = skipReceiverLaunch;
        Logging.class.$init$((Logging)this);
        this.receiverInputStreams = ssc.graph().getReceiverInputStreams();
        this.receiverInputStreamIds = (int[])Predef$.MODULE$.refArrayOps((Object[])this.receiverInputStreams()).map((Function1)new $anonfun$3(this), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        this.receivedBlockTracker = new ReceivedBlockTracker(ssc.sparkContext().conf(), ssc.sparkContext().hadoopConfiguration(), (Seq<Object>)Predef$.MODULE$.wrapIntArray(this.receiverInputStreamIds()), ssc.scheduler().clock(), ssc.isCheckpointPresent(), (Option<String>)Option$.MODULE$.apply((Object)ssc.checkpointDir()));
        this.listenerBus = ssc.scheduler().listenerBus();
        this.trackerState = this.TrackerState().Initialized();
        this.endpoint = null;
        this.org$apache$spark$streaming$scheduler$ReceiverTracker$$schedulingPolicy = new ReceiverSchedulingPolicy();
        this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverJobExitLatch = new CountDownLatch(Predef$.MODULE$.refArrayOps((Object[])this.receiverInputStreams()).size());
        this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos = new HashMap();
        this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverPreferredLocations = new HashMap();
    }

    public class ReceiverTrackerEndpoint
    implements ThreadSafeRpcEndpoint {
        private final RpcEnv rpcEnv;
        private final ExecutionContextExecutorService submitJobThreadPool;
        private final ExecutionContextExecutorService org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$walBatchingThreadPool;
        private volatile boolean org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$active;
        public final /* synthetic */ ReceiverTracker $outer;

        public final RpcEndpointRef self() {
            return RpcEndpoint.class.self((RpcEndpoint)this);
        }

        public void onError(Throwable cause) {
            RpcEndpoint.class.onError((RpcEndpoint)this, (Throwable)cause);
        }

        public void onConnected(RpcAddress remoteAddress) {
            RpcEndpoint.class.onConnected((RpcEndpoint)this, (RpcAddress)remoteAddress);
        }

        public void onDisconnected(RpcAddress remoteAddress) {
            RpcEndpoint.class.onDisconnected((RpcEndpoint)this, (RpcAddress)remoteAddress);
        }

        public void onNetworkError(Throwable cause, RpcAddress remoteAddress) {
            RpcEndpoint.class.onNetworkError((RpcEndpoint)this, (Throwable)cause, (RpcAddress)remoteAddress);
        }

        public void onStart() {
            RpcEndpoint.class.onStart((RpcEndpoint)this);
        }

        public final void stop() {
            RpcEndpoint.class.stop((RpcEndpoint)this);
        }

        public RpcEnv rpcEnv() {
            return this.rpcEnv;
        }

        private ExecutionContextExecutorService submitJobThreadPool() {
            return this.submitJobThreadPool;
        }

        public ExecutionContextExecutorService org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$walBatchingThreadPool() {
            return this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$walBatchingThreadPool;
        }

        public boolean org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$active() {
            return this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$active;
        }

        private void org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$active_$eq(boolean x$1) {
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$active = x$1;
        }

        public PartialFunction<Object, BoxedUnit> receive() {
            return new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReceiverTrackerEndpoint $outer;

                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof StartAllReceivers) {
                        StartAllReceivers startAllReceivers = (StartAllReceivers)A1;
                        Seq<Receiver<?>> receivers = startAllReceivers.receiver();
                        Map<Object, Seq<TaskLocation>> scheduledLocations = this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$schedulingPolicy().scheduleReceivers(receivers, this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$getExecutors());
                        receivers.foreach((Function1)new Serializable(this, scheduledLocations){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ ReceiverTrackerEndpoint$$anonfun$receive$1 $outer;
                            private final Map scheduledLocations$1;

                            public final void apply(Receiver<?> receiver) {
                                Seq executors = (Seq)this.scheduledLocations$1.apply((Object)BoxesRunTime.boxToInteger((int)receiver.streamId()));
                                this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$anonfun$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$updateReceiverScheduledExecutors(receiver.streamId(), (Seq<TaskLocation>)executors);
                                this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$anonfun$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverPreferredLocations().update((Object)BoxesRunTime.boxToInteger((int)receiver.streamId()), receiver.preferredLocation());
                                this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$anonfun$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$startReceiver(receiver, (Seq<TaskLocation>)executors);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.scheduledLocations$1 = scheduledLocations$1;
                            }
                        });
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof RestartReceiver) {
                        Seq<TaskLocation> seq;
                        RestartReceiver restartReceiver2 = (RestartReceiver)A1;
                        Receiver<?> receiver = restartReceiver2.receiver();
                        Seq<TaskLocation> oldScheduledExecutors = this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$getStoredScheduledExecutors(receiver.streamId());
                        if (oldScheduledExecutors.nonEmpty()) {
                            seq = oldScheduledExecutors;
                        } else {
                            ReceiverTrackingInfo oldReceiverInfo = (ReceiverTrackingInfo)this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().apply((Object)BoxesRunTime.boxToInteger((int)receiver.streamId()));
                            Enumeration.Value x$34 = ReceiverState$.MODULE$.INACTIVE();
                            None$ x$35 = None$.MODULE$;
                            int x$36 = oldReceiverInfo.copy$default$1();
                            Option<ExecutorCacheTaskLocation> x$37 = oldReceiverInfo.copy$default$4();
                            Option<String> x$38 = oldReceiverInfo.copy$default$5();
                            Option<RpcEndpointRef> x$39 = oldReceiverInfo.copy$default$6();
                            Option<ReceiverErrorInfo> x$40 = oldReceiverInfo.copy$default$7();
                            ReceiverTrackingInfo newReceiverInfo = oldReceiverInfo.copy(x$36, x$34, (Option<Seq<TaskLocation>>)x$35, x$37, x$38, x$39, x$40);
                            this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().update((Object)BoxesRunTime.boxToInteger((int)receiver.streamId()), (Object)newReceiverInfo);
                            seq = this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$schedulingPolicy().rescheduleReceiver(receiver.streamId(), receiver.preferredLocation(), (Map<Object, ReceiverTrackingInfo>)this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos(), this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$getExecutors());
                        }
                        Seq<TaskLocation> scheduledLocations = seq;
                        this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$startReceiver(receiver, scheduledLocations);
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof CleanupOldBlocks) {
                        CleanupOldBlocks cleanupOldBlocks2 = (CleanupOldBlocks)A1;
                        ((IterableLike)this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().values().flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Iterable<RpcEndpointRef> apply(ReceiverTrackingInfo x$5) {
                                return Option$.MODULE$.option2Iterable(x$5.endpoint());
                            }
                        }, scala.collection.Iterable$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, cleanupOldBlocks2){
                            public static final long serialVersionUID = 0L;
                            private final CleanupOldBlocks x6$1;

                            public final void apply(RpcEndpointRef x$6) {
                                x$6.send((Object)this.x6$1);
                            }
                            {
                                this.x6$1 = x6$1;
                            }
                        });
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof UpdateReceiverRateLimit) {
                        UpdateReceiverRateLimit updateReceiverRateLimit = (UpdateReceiverRateLimit)A1;
                        int streamUID = updateReceiverRateLimit.streamUID();
                        long newRate = updateReceiverRateLimit.newRate();
                        this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().get((Object)BoxesRunTime.boxToInteger((int)streamUID)).foreach((Function1)new Serializable(this, newRate){
                            public static final long serialVersionUID = 0L;
                            public final long newRate$1;

                            public final void apply(ReceiverTrackingInfo info) {
                                info.endpoint().foreach((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ ReceiverTrackerEndpoint$$anonfun$receive$1$$anonfun$applyOrElse$4 $outer;

                                    public final void apply(RpcEndpointRef eP) {
                                        eP.send((Object)new UpdateRateLimit(this.$outer.newRate$1));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                            }
                            {
                                this.newRate$1 = newRate$1;
                            }
                        });
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof ReportError) {
                        ReportError reportError2 = (ReportError)A1;
                        int streamId = reportError2.streamId();
                        String message = reportError2.message();
                        String error = reportError2.error();
                        this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$reportError(streamId, message, error);
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Object x1) {
                    Object object = x1;
                    boolean bl = object instanceof StartAllReceivers ? true : (object instanceof RestartReceiver ? true : (object instanceof CleanupOldBlocks ? true : (object instanceof UpdateReceiverRateLimit ? true : object instanceof ReportError)));
                    return bl;
                }

                public /* synthetic */ ReceiverTrackerEndpoint org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            };
        }

        public PartialFunction<Object, BoxedUnit> receiveAndReply(RpcCallContext context) {
            return new Serializable(this, context){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReceiverTrackerEndpoint $outer;
                public final RpcCallContext context$1;

                public final <A1, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x2;
                    if (A1 instanceof RegisterReceiver) {
                        RegisterReceiver registerReceiver2 = (RegisterReceiver)A1;
                        int streamId = registerReceiver2.streamId();
                        String typ = registerReceiver2.typ();
                        String host = registerReceiver2.host();
                        String executorId = registerReceiver2.executorId();
                        RpcEndpointRef receiverEndpoint = registerReceiver2.receiverEndpoint();
                        boolean successful = this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$registerReceiver(streamId, typ, host, executorId, receiverEndpoint, this.context$1.senderAddress());
                        this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)successful));
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof AddBlock) {
                        BoxedUnit boxedUnit;
                        AddBlock addBlock2 = (AddBlock)A1;
                        ReceivedBlockInfo receivedBlockInfo = addBlock2.receivedBlockInfo();
                        if (WriteAheadLogUtils$.MODULE$.isBatchingEnabled(this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.conf(), true)) {
                            this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$walBatchingThreadPool().execute(new Runnable(this, receivedBlockInfo){
                                private final /* synthetic */ ReceiverTrackerEndpoint$$anonfun$receiveAndReply$1 $outer;
                                public final ReceivedBlockInfo receivedBlockInfo$1;

                                public void run() {
                                    Utils$.MODULE$.tryLogNonFatalError((Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ ReceiverTrackerEndpoint$$anonfun$receiveAndReply$1$$anon$1 $outer;

                                        public final void apply() {
                                            this.apply$mcV$sp();
                                        }

                                        public void apply$mcV$sp() {
                                            if (this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$anonfun$$anon$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$anonfun$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$active()) {
                                                this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$anonfun$$anon$$$outer().context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$anonfun$$anon$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$anonfun$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$addBlock(this.$outer.receivedBlockInfo$1)));
                                                return;
                                            }
                                            throw new IllegalStateException("ReceiverTracker RpcEndpoint shut down.");
                                        }
                                        {
                                            if ($outer == null) {
                                                throw new NullPointerException();
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                }

                                public /* synthetic */ ReceiverTrackerEndpoint$$anonfun$receiveAndReply$1 org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$anonfun$$anon$$$outer() {
                                    return this.$outer;
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.receivedBlockInfo$1 = receivedBlockInfo$1;
                                }
                            });
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$addBlock(receivedBlockInfo)));
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        object = boxedUnit;
                    } else if (A1 instanceof DeregisterReceiver) {
                        DeregisterReceiver deregisterReceiver2 = (DeregisterReceiver)A1;
                        int streamId = deregisterReceiver2.streamId();
                        String message = deregisterReceiver2.msg();
                        String error = deregisterReceiver2.error();
                        this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$deregisterReceiver(streamId, message, error);
                        this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)true));
                        object = BoxedUnit.UNIT;
                    } else {
                        AllReceiverIds$ allReceiverIds$ = AllReceiverIds$.MODULE$;
                        A1 A12 = A1;
                        if (!(allReceiverIds$ != null ? !allReceiverIds$.equals(A12) : A12 != null)) {
                            this.context$1.reply((Object)((MapLike)this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().filter((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(Tuple2<Object, ReceiverTrackingInfo> x$7) {
                                    Enumeration.Value value = ((ReceiverTrackingInfo)x$7._2()).state();
                                    Enumeration.Value value2 = ReceiverState$.MODULE$.INACTIVE();
                                    return value != null ? !value.equals(value2) : value2 != null;
                                }
                            })).keys().toSeq());
                            object = BoxedUnit.UNIT;
                        } else {
                            StopAllReceivers$ stopAllReceivers$ = StopAllReceivers$.MODULE$;
                            A1 A13 = A1;
                            if (!(stopAllReceivers$ != null ? !stopAllReceivers$.equals(A13) : A13 != null)) {
                                Predef$.MODULE$.assert(this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$isTrackerStopping() || this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$isTrackerStopped());
                                this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$stopReceivers();
                                this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)true));
                                object = BoxedUnit.UNIT;
                            } else {
                                object = function1.apply(x2);
                            }
                        }
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Object x2) {
                    boolean bl;
                    Object object = x2;
                    if (object instanceof RegisterReceiver) {
                        bl = true;
                    } else if (object instanceof AddBlock) {
                        bl = true;
                    } else if (object instanceof DeregisterReceiver) {
                        bl = true;
                    } else {
                        AllReceiverIds$ allReceiverIds$ = AllReceiverIds$.MODULE$;
                        Object object2 = object;
                        if (!(allReceiverIds$ != null ? !allReceiverIds$.equals(object2) : object2 != null)) {
                            bl = true;
                        } else {
                            StopAllReceivers$ stopAllReceivers$ = StopAllReceivers$.MODULE$;
                            Object object3 = object;
                            bl = !(stopAllReceivers$ != null ? !stopAllReceivers$.equals(object3) : object3 != null);
                        }
                    }
                    return bl;
                }

                public /* synthetic */ ReceiverTrackerEndpoint org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.context$1 = context$1;
                }
            };
        }

        public Seq<TaskLocation> org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$getStoredScheduledExecutors(int receiverId) {
            Nil$ nil$;
            if (this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().contains((Object)BoxesRunTime.boxToInteger((int)receiverId))) {
                Option<Seq<TaskLocation>> scheduledLocations = ((ReceiverTrackingInfo)this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().apply((Object)BoxesRunTime.boxToInteger((int)receiverId))).scheduledLocations();
                if (scheduledLocations.nonEmpty()) {
                    Set executors = this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$getExecutors().toSet();
                    nil$ = (Seq)((TraversableLike)scheduledLocations.get()).filter((Function1)new Serializable(this, executors){
                        public static final long serialVersionUID = 0L;
                        private final Set executors$1;

                        public final boolean apply(TaskLocation x0$4) {
                            TaskLocation taskLocation;
                            block4: {
                                boolean bl;
                                block3: {
                                    block2: {
                                        taskLocation = x0$4;
                                        if (!(taskLocation instanceof ExecutorCacheTaskLocation)) break block2;
                                        ExecutorCacheTaskLocation executorCacheTaskLocation = (ExecutorCacheTaskLocation)taskLocation;
                                        bl = this.executors$1.apply((Object)executorCacheTaskLocation);
                                        break block3;
                                    }
                                    if (taskLocation == null) break block4;
                                    bl = true;
                                }
                                return bl;
                            }
                            throw new MatchError((Object)taskLocation);
                        }
                        {
                            this.executors$1 = executors$1;
                        }
                    });
                } else {
                    nil$ = Nil$.MODULE$;
                }
            } else {
                nil$ = Nil$.MODULE$;
            }
            return nil$;
        }

        /*
         * WARNING - void declaration
         */
        public void org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$startReceiver(Receiver<?> receiver, Seq<TaskLocation> scheduledLocations) {
            void var3_3;
            int receiverId = receiver.streamId();
            if (this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$shouldStartReceiver$1()) {
                RDD rDD;
                Option checkpointDirOption = Option$.MODULE$.apply((Object)this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.checkpointDir());
                SerializableConfiguration serializableHadoopConf = new SerializableConfiguration(this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().hadoopConfiguration());
                Serializable startReceiverFunc = new Serializable(this, checkpointDirOption, serializableHadoopConf){
                    public static final long serialVersionUID = 0L;
                    private final Option checkpointDirOption$1;
                    private final SerializableConfiguration serializableHadoopConf$1;

                    public final void apply(Iterator<Receiver<?>> iterator) {
                        if (iterator.hasNext()) {
                            if (TaskContext$.MODULE$.get().attemptNumber() == 0) {
                                Receiver receiver = (Receiver)iterator.next();
                                Predef$.MODULE$.assert(!iterator.hasNext());
                                ReceiverSupervisorImpl supervisor2 = new ReceiverSupervisorImpl(receiver, SparkEnv$.MODULE$.get(), this.serializableHadoopConf$1.value(), (Option<String>)this.checkpointDirOption$1);
                                supervisor2.start();
                                supervisor2.awaitTermination();
                            }
                            return;
                        }
                        throw new SparkException("Could not start receiver as object not found.");
                    }
                    {
                        this.checkpointDirOption$1 = checkpointDirOption$1;
                        this.serializableHadoopConf$1 = serializableHadoopConf$1;
                    }
                };
                if (scheduledLocations.isEmpty()) {
                    rDD = this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sc().makeRDD((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Receiver[]{receiver})), 1, ClassTag$.MODULE$.apply(Receiver.class));
                } else {
                    Seq preferredLocations = (Seq)((SeqLike)scheduledLocations.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(TaskLocation x$8) {
                            return x$8.toString();
                        }
                    }, Seq$.MODULE$.canBuildFrom())).distinct();
                    rDD = this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sc().makeRDD((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(receiver), (Object)preferredLocations)})), ClassTag$.MODULE$.apply(Receiver.class));
                }
                RDD receiverRDD = rDD;
                receiverRDD.setName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Receiver ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)receiverId)})));
                this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().setJobDescription(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Streaming job running receiver ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)receiverId)})));
                this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().setCallSite((CallSite)Option$.MODULE$.apply((Object)this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.getStartSite()).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CallSite apply() {
                        return Utils$.MODULE$.getCallSite(Utils$.MODULE$.getCallSite$default$1());
                    }
                }));
                SimpleFutureAction future = this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().submitJob(receiverRDD, (Function1)startReceiverFunc, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(int x$9, BoxedUnit x$10) {
                    }
                }, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                    }
                });
                future.onComplete((Function1)new Serializable(this, receiver, receiverId){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ReceiverTrackerEndpoint $outer;
                    private final Receiver receiver$1;
                    public final int receiverId$1;

                    public final void apply(Try<BoxedUnit> x0$5) {
                        Try<BoxedUnit> try_;
                        block9: {
                            block8: {
                                BoxedUnit boxedUnit;
                                block7: {
                                    BoxedUnit boxedUnit2;
                                    try_ = x0$5;
                                    if (!(try_ instanceof Success)) break block7;
                                    if (this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$shouldStartReceiver$1()) {
                                        this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().logInfo((Function0<String>)new Serializable(this){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ ReceiverTrackerEndpoint$$anonfun$org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$startReceiver$2 $outer;

                                            public final String apply() {
                                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Restarting Receiver ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.receiverId$1)}));
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw new NullPointerException();
                                                }
                                                this.$outer = $outer;
                                            }
                                        });
                                        this.$outer.self().send((Object)new RestartReceiver(this.receiver$1));
                                        boxedUnit2 = BoxedUnit.UNIT;
                                    } else {
                                        this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$onReceiverJobFinish(this.receiverId$1);
                                        boxedUnit2 = BoxedUnit.UNIT;
                                    }
                                    BoxedUnit boxedUnit3 = boxedUnit2;
                                    break block8;
                                }
                                if (!(try_ instanceof Failure)) break block9;
                                Failure failure = (Failure)try_;
                                Throwable e = failure.exception();
                                if (this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$shouldStartReceiver$1()) {
                                    this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().logError((Function0<String>)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "Receiver has been stopped. Try to restart it.";
                                        }
                                    }, e);
                                    this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().logInfo((Function0<String>)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ ReceiverTrackerEndpoint$$anonfun$org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$startReceiver$2 $outer;

                                        public final String apply() {
                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Restarting Receiver ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.receiverId$1)}));
                                        }
                                        {
                                            if ($outer == null) {
                                                throw new NullPointerException();
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                    this.$outer.self().send((Object)new RestartReceiver(this.receiver$1));
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$onReceiverJobFinish(this.receiverId$1);
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                BoxedUnit boxedUnit4 = boxedUnit;
                            }
                            return;
                        }
                        throw new MatchError(try_);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.receiver$1 = receiver$1;
                        this.receiverId$1 = receiverId$1;
                    }
                }, (ExecutionContext)this.submitJobThreadPool());
                this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().logInfo((Function0<String>)new Serializable(this, receiver){
                    public static final long serialVersionUID = 0L;
                    private final Receiver receiver$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Receiver ", " started"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.receiver$1.streamId())}));
                    }
                    {
                        this.receiver$1 = receiver$1;
                    }
                });
                return;
            }
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$onReceiverJobFinish((int)var3_3);
        }

        public void onStop() {
            this.submitJobThreadPool().shutdownNow();
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$active_$eq(false);
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$walBatchingThreadPool().shutdown();
        }

        public void org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$onReceiverJobFinish(int receiverId) {
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverJobExitLatch().countDown();
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().remove((Object)BoxesRunTime.boxToInteger((int)receiverId)).foreach((Function1)new Serializable(this, receiverId){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReceiverTrackerEndpoint $outer;
                public final int receiverId$2;

                public final void apply(ReceiverTrackingInfo receiverTrackingInfo) {
                    Enumeration.Value value = receiverTrackingInfo.state();
                    Enumeration.Value value2 = ReceiverState$.MODULE$.ACTIVE();
                    if (!(value != null ? !value.equals(value2) : value2 != null)) {
                        this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().logWarning((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ ReceiverTrackerEndpoint$$anonfun$org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$onReceiverJobFinish$1 $outer;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Receiver ", " exited but didn't deregister"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.receiverId$2)}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.receiverId$2 = receiverId$2;
                }
            });
        }

        public void org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$stopReceivers() {
            ((IterableLike)this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().values().flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Iterable<RpcEndpointRef> apply(ReceiverTrackingInfo x$11) {
                    return Option$.MODULE$.option2Iterable(x$11.endpoint());
                }
            }, scala.collection.Iterable$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(RpcEndpointRef x$12) {
                    x$12.send((Object)StopReceiver$.MODULE$);
                }
            });
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReceiverTrackerEndpoint $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"Sent stop signal to all ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().size())).append((Object)" receivers").toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }

        public /* synthetic */ ReceiverTracker org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer() {
            return this.$outer;
        }

        public final boolean org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$shouldStartReceiver$1() {
            return !this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$isTrackerStopping() && !this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$isTrackerStopped();
        }

        public ReceiverTrackerEndpoint(ReceiverTracker $outer, RpcEnv rpcEnv) {
            this.rpcEnv = rpcEnv;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            RpcEndpoint.class.$init$((RpcEndpoint)this);
            this.submitJobThreadPool = ExecutionContext$.MODULE$.fromExecutorService((ExecutorService)ThreadUtils$.MODULE$.newDaemonCachedThreadPool("submit-job-thread-pool"));
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$walBatchingThreadPool = ExecutionContext$.MODULE$.fromExecutorService((ExecutorService)ThreadUtils$.MODULE$.newDaemonCachedThreadPool("wal-batching-thread-pool"));
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$active = true;
        }
    }
}

