/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kafka;

import java.io.File;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import kafka.admin.AdminUtils$;
import kafka.api.LeaderAndIsr;
import kafka.api.PartitionStateInfo;
import kafka.api.Request$;
import kafka.producer.KeyedMessage;
import kafka.producer.Producer;
import kafka.producer.ProducerConfig;
import kafka.serializer.StringEncoder;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.commons.lang3.RandomUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.kafka.KafkaTestUtils$$anonfun$org$apache$spark$streaming$kafka$KafkaTestUtils$;
import org.apache.spark.util.Utils$;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tue!B\u0001\u0003\u0001\ta!AD&bM.\fG+Z:u+RLGn\u001d\u0006\u0003\u0007\u0011\tQa[1gW\u0006T!!\u0002\u0004\u0002\u0013M$(/Z1nS:<'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0014\u0007\u0001i1\u0003\u0005\u0002\u000f#5\tqBC\u0001\u0011\u0003\u0015\u00198-\u00197b\u0013\t\u0011rB\u0001\u0004B]f\u0014VM\u001a\t\u0003)]i\u0011!\u0006\u0006\u0003-\u0019\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u00031U\u0011q\u0001T8hO&tw\rC\u0003\u001b\u0001\u0011\u0005A$\u0001\u0004=S:LGOP\u0002\u0001)\u0005i\u0002C\u0001\u0010\u0001\u001b\u0005\u0011\u0001b\u0002\u0011\u0001\u0005\u0004%I!I\u0001\u0007u.Dun\u001d;\u0016\u0003\t\u0002\"a\t\u0015\u000e\u0003\u0011R!!\n\u0014\u0002\t1\fgn\u001a\u0006\u0002O\u0005!!.\u0019<b\u0013\tICE\u0001\u0004TiJLgn\u001a\u0005\u0007W\u0001\u0001\u000b\u0011\u0002\u0012\u0002\u000fi\\\u0007j\\:uA!9Q\u0006\u0001a\u0001\n\u0013q\u0013A\u0002>l!>\u0014H/F\u00010!\tq\u0001'\u0003\u00022\u001f\t\u0019\u0011J\u001c;\t\u000fM\u0002\u0001\u0019!C\u0005i\u0005Q!p\u001b)peR|F%Z9\u0015\u0005UB\u0004C\u0001\b7\u0013\t9tB\u0001\u0003V]&$\bbB\u001d3\u0003\u0003\u0005\raL\u0001\u0004q\u0012\n\u0004BB\u001e\u0001A\u0003&q&A\u0004{WB{'\u000f\u001e\u0011\t\u000fu\u0002!\u0019!C\u0005]\u0005\u0019\"p[\"p]:,7\r^5p]RKW.Z8vi\"1q\b\u0001Q\u0001\n=\nAC_6D_:tWm\u0019;j_:$\u0016.\\3pkR\u0004\u0003bB!\u0001\u0005\u0004%IAL\u0001\u0011u.\u001cVm]:j_:$\u0016.\\3pkRDaa\u0011\u0001!\u0002\u0013y\u0013!\u0005>l'\u0016\u001c8/[8o)&lWm\\;uA!IQ\t\u0001a\u0001\u0002\u0004%IAR\u0001\nu>|7.Z3qKJ,\u0012a\u0012\t\u0003\u0011&k\u0011\u0001\u0001\u0004\u0005\u0015\u0002!1JA\tF[\n,G\rZ3e5>|7.Z3qKJ\u001c\"!S\u0007\t\u00115K%Q1A\u0005\u00029\u000b\u0011B_6D_:tWm\u0019;\u0016\u0003=\u0003\"\u0001U*\u000f\u00059\t\u0016B\u0001*\u0010\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011\u0006\u0016\u0006\u0003%>A\u0001BV%\u0003\u0002\u0003\u0006IaT\u0001\u000bu.\u001cuN\u001c8fGR\u0004\u0003\"\u0002\u000eJ\t\u0003AFCA$Z\u0011\u0015iu\u000b1\u0001P\u0011\u001dY\u0016J1A\u0005\u0002q\u000b1b\u001d8baNDw\u000e\u001e#jeV\tQ\f\u0005\u0002_C6\tqL\u0003\u0002aM\u0005\u0011\u0011n\\\u0005\u0003E~\u0013AAR5mK\"1A-\u0013Q\u0001\nu\u000bAb\u001d8baNDw\u000e\u001e#je\u0002BqAZ%C\u0002\u0013\u0005A,\u0001\u0004m_\u001e$\u0015N\u001d\u0005\u0007Q&\u0003\u000b\u0011B/\u0002\u000f1|w\rR5sA!9Q)\u0013b\u0001\n\u0003QW#A6\u0011\u00051\u0004X\"A7\u000b\u00059|\u0017AB:feZ,'O\u0003\u0002F\u0011%\u0011\u0011/\u001c\u0002\u00105>|7*Z3qKJ\u001cVM\u001d<fe\"11/\u0013Q\u0001\n-\f!B_8pW\u0016,\u0007/\u001a:!\u0011))\u0018\n%A\u0001\u0004\u0003\u0006IA^\u0001\u0004q\u0012\u001a\u0004\u0003\u0002\bxE=J!\u0001_\b\u0003\rQ+\b\u000f\\33\u0011\u001dQ\u0018J1A\u0005\u0002\u0005\n!!\u001b9\t\rqL\u0005\u0015!\u0003#\u0003\rI\u0007\u000f\t\u0005\b}&\u0013\r\u0011\"\u0001/\u0003\u0011\u0001xN\u001d;\t\u000f\u0005\u0005\u0011\n)A\u0005_\u0005)\u0001o\u001c:uA!I\u0011QA%C\u0002\u0013\u0005\u0011qA\u0001\bM\u0006\u001cGo\u001c:z+\t\tI\u0001E\u0002m\u0003\u0017I1!!\u0004n\u0005Qq\u0015jT*feZ,'o\u00118y]\u001a\u000b7\r^8ss\"A\u0011\u0011C%!\u0002\u0013\tI!\u0001\u0005gC\u000e$xN]=!\u0011!\t)\"\u0013b\u0001\n\u0003q\u0013AC1diV\fG\u000eU8si\"9\u0011\u0011D%!\u0002\u0013y\u0013aC1diV\fG\u000eU8si\u0002Bq!!\bJ\t\u0003\ty\"\u0001\u0005tQV$Hm\\<o)\u0005)\u0004bCA\u0012\u0001\u0001\u0007\t\u0019!C\u0005\u0003K\tQB_8pW\u0016,\u0007/\u001a:`I\u0015\fHcA\u001b\u0002(!A\u0011(!\t\u0002\u0002\u0003\u0007q\t\u0003\u0004t\u0001\u0001\u0006Ka\u0012\u0005\f\u0003[\u0001\u0001\u0019!a\u0001\n\u0013\ty#\u0001\u0005{W\u000ec\u0017.\u001a8u+\t\t\t\u0004\u0005\u0003\u00024\u0005uRBAA\u001b\u0015\u0011\t9$!\u000f\u0002\u0011i\\7\r\\5f]RT1!a\u000f\u000b\u0003\u0019I\u0005'\u0013;fG&!\u0011qHA\u001b\u0005!Q6n\u00117jK:$\bbCA\"\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u000b\nAB_6DY&,g\u000e^0%KF$2!NA$\u0011%I\u0014\u0011IA\u0001\u0002\u0004\t\t\u0004\u0003\u0005\u0002L\u0001\u0001\u000b\u0015BA\u0019\u0003%Q8n\u00117jK:$\b\u0005\u0003\u0005\u0002P\u0001\u0011\r\u0011\"\u0003\"\u0003)\u0011'o\\6fe\"{7\u000f\u001e\u0005\b\u0003'\u0002\u0001\u0015!\u0003#\u0003-\u0011'o\\6fe\"{7\u000f\u001e\u0011\t\u0011\u0005]\u0003\u00011A\u0005\n9\n!B\u0019:pW\u0016\u0014\bk\u001c:u\u0011%\tY\u0006\u0001a\u0001\n\u0013\ti&\u0001\bce>\\WM\u001d)peR|F%Z9\u0015\u0007U\ny\u0006\u0003\u0005:\u00033\n\t\u00111\u00010\u0011\u001d\t\u0019\u0007\u0001Q!\n=\n1B\u0019:pW\u0016\u0014\bk\u001c:uA!Y\u0011q\r\u0001A\u0002\u0003\u0007I\u0011BA5\u0003)\u0011'o\\6fe\u000e{gNZ\u000b\u0003\u0003W\u0002B!!\u001c\u0002t5\u0011\u0011q\u000e\u0006\u0004]\u0006E$\"A\u0002\n\t\u0005U\u0014q\u000e\u0002\f\u0017\u000647.Y\"p]\u001aLw\rC\u0006\u0002z\u0001\u0001\r\u00111A\u0005\n\u0005m\u0014A\u00042s_.,'oQ8oM~#S-\u001d\u000b\u0004k\u0005u\u0004\"C\u001d\u0002x\u0005\u0005\t\u0019AA6\u0011!\t\t\t\u0001Q!\n\u0005-\u0014a\u00032s_.,'oQ8oM\u0002B!B\u001c\u0001A\u0002\u0003\u0007I\u0011BAC+\t\t9\t\u0005\u0003\u0002n\u0005%\u0015\u0002BAF\u0003_\u00121bS1gW\u0006\u001cVM\u001d<fe\"Y\u0011q\u0012\u0001A\u0002\u0003\u0007I\u0011BAI\u0003)\u0019XM\u001d<fe~#S-\u001d\u000b\u0004k\u0005M\u0005\"C\u001d\u0002\u000e\u0006\u0005\t\u0019AAD\u0011!\t9\n\u0001Q!\n\u0005\u001d\u0015aB:feZ,'\u000f\t\u0005\f\u00037\u0003\u0001\u0019!a\u0001\n\u0013\ti*\u0001\u0005qe>$WoY3s+\t\ty\n\u0005\u0004\u0002\"\u0006\u0015vjT\u0007\u0003\u0003GSA!a'\u0002r%!\u0011qUAR\u0005!\u0001&o\u001c3vG\u0016\u0014\bbCAV\u0001\u0001\u0007\t\u0019!C\u0005\u0003[\u000bA\u0002\u001d:pIV\u001cWM]0%KF$2!NAX\u0011%I\u0014\u0011VA\u0001\u0002\u0004\ty\n\u0003\u0005\u00024\u0002\u0001\u000b\u0015BAP\u0003%\u0001(o\u001c3vG\u0016\u0014\b\u0005C\u0005\u00028\u0002\u0001\r\u0011\"\u0003\u0002:\u00069!p\u001b*fC\u0012LXCAA^!\rq\u0011QX\u0005\u0004\u0003\u007f{!a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003\u0007\u0004\u0001\u0019!C\u0005\u0003\u000b\f1B_6SK\u0006$\u0017p\u0018\u0013fcR\u0019Q'a2\t\u0013e\n\t-!AA\u0002\u0005m\u0006\u0002CAf\u0001\u0001\u0006K!a/\u0002\u0011i\\'+Z1es\u0002B\u0011\"a4\u0001\u0001\u0004%I!!/\u0002\u0017\t\u0014xn[3s%\u0016\fG-\u001f\u0005\n\u0003'\u0004\u0001\u0019!C\u0005\u0003+\fqB\u0019:pW\u0016\u0014(+Z1es~#S-\u001d\u000b\u0004k\u0005]\u0007\"C\u001d\u0002R\u0006\u0005\t\u0019AA^\u0011!\tY\u000e\u0001Q!\n\u0005m\u0016\u0001\u00042s_.,'OU3bIf\u0004\u0003BBAp\u0001\u0011\u0005a*A\u0005{W\u0006#GM]3tg\"1\u00111\u001d\u0001\u0005\u00029\u000bQB\u0019:pW\u0016\u0014\u0018\t\u001a3sKN\u001c\bbBAt\u0001\u0011\u0005\u0011qF\u0001\u0010u>|7.Z3qKJ\u001cE.[3oi\"9\u00111\u001e\u0001\u0005\n\u0005}\u0011AF:fiV\u0004X)\u001c2fI\u0012,GMW8pW\u0016,\u0007/\u001a:\t\u000f\u0005=\b\u0001\"\u0003\u0002 \u0005A2/\u001a;va\u0016k'-\u001a3eK\u0012\\\u0015MZ6b'\u0016\u0014h/\u001a:\t\u000f\u0005M\b\u0001\"\u0001\u0002 \u0005)1/\u001a;va\"9\u0011q\u001f\u0001\u0005\u0002\u0005}\u0011\u0001\u0003;fCJ$wn\u001e8\t\u000f\u0005m\b\u0001\"\u0001\u0002~\u0006Y1M]3bi\u0016$v\u000e]5d)\u0015)\u0014q B\u0002\u0011\u001d\u0011\t!!?A\u0002=\u000bQ\u0001^8qS\u000eDqA!\u0002\u0002z\u0002\u0007q&\u0001\u0006qCJ$\u0018\u000e^5p]NDq!a?\u0001\t\u0003\u0011I\u0001F\u00026\u0005\u0017AqA!\u0001\u0003\b\u0001\u0007q\nC\u0004\u0003\u0010\u0001!\tA!\u0005\u0002\u0019M,g\u000eZ'fgN\fw-Z:\u0015\u000bU\u0012\u0019B!\u0006\t\u000f\t\u0005!Q\u0002a\u0001\u001f\"A!q\u0003B\u0007\u0001\u0004\u0011I\"A\u0007nKN\u001c\u0018mZ3U_\u001a\u0013X-\u001d\t\b\u00057\u0011\tc\u0014B\u0013\u001b\t\u0011iBC\u0002\u0003 \u0019\nA!\u001e;jY&!!1\u0005B\u000f\u0005\ri\u0015\r\u001d\t\u0004G\t\u001d\u0012b\u0001B\u0015I\t9\u0011J\u001c;fO\u0016\u0014\bb\u0002B\b\u0001\u0011\u0005!Q\u0006\u000b\u0006k\t=\"\u0011\u0007\u0005\b\u0005\u0003\u0011Y\u00031\u0001P\u0011!\u00119Ba\u000bA\u0002\tM\u0002#\u0002)\u00036={\u0013b\u0001B\u0012)\"9!q\u0002\u0001\u0005\u0002\teB#B\u001b\u0003<\tu\u0002b\u0002B\u0001\u0005o\u0001\ra\u0014\u0005\t\u0005\u007f\u00119\u00041\u0001\u0003B\u0005AQ.Z:tC\u001e,7\u000f\u0005\u0003\u000f\u0005\u0007z\u0015b\u0001B#\u001f\t)\u0011I\u001d:bs\"9!\u0011\n\u0001\u0005\n\t-\u0013a\u00052s_.,'oQ8oM&<WO]1uS>tWC\u0001B'!\u0011\u0011YBa\u0014\n\t\tE#Q\u0004\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bb\u0002B+\u0001\u0011%!1J\u0001\u0016aJ|G-^2fe\u000e{gNZ5hkJ\fG/[8o\u0011\u001d\u0011I\u0006\u0001C\u0001\u00057\n!\"\u001a<f]R,\u0018\r\u001c7z+\u0011\u0011iF!\u001a\u0015\r\t}#\u0011\u0011BG)\u0011\u0011\tGa\u001e\u0011\t\t\r$Q\r\u0007\u0001\t!\u00119Ga\u0016C\u0002\t%$!\u0001+\u0012\t\t-$\u0011\u000f\t\u0004\u001d\t5\u0014b\u0001B8\u001f\t9aj\u001c;iS:<\u0007c\u0001\b\u0003t%\u0019!QO\b\u0003\u0007\u0005s\u0017\u0010C\u0005\u0003z\t]C\u00111\u0001\u0003|\u0005!a-\u001e8d!\u0015q!Q\u0010B1\u0013\r\u0011yh\u0004\u0002\ty\tLh.Y7f}!A!1\u0011B,\u0001\u0004\u0011))A\u0004uS6,w.\u001e;\u0011\t\t\u001d%\u0011R\u0007\u0002\t%\u0019!1\u0012\u0003\u0003\tQKW.\u001a\u0005\t\u0005\u001f\u00139\u00061\u0001\u0003\u0006\u0006A\u0011N\u001c;feZ\fG\u000eC\u0004\u0003\u0014\u0002!IA!&\u0002;]\f\u0017\u000e^+oi&dW*\u001a;bI\u0006$\u0018-S:Qe>\u0004\u0018mZ1uK\u0012$R!\u000eBL\u00053CqA!\u0001\u0003\u0012\u0002\u0007q\nC\u0004\u0003\u001c\nE\u0005\u0019A\u0018\u0002\u0013A\f'\u000f^5uS>t\u0007")
public class KafkaTestUtils
implements Logging {
    private final String zkHost;
    private int zkPort;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private EmbeddedZookeeper zookeeper;
    private ZkClient zkClient;
    private final String brokerHost;
    private int org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort;
    private KafkaConfig org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerConf;
    private KafkaServer org$apache$spark$streaming$kafka$KafkaTestUtils$$server;
    private Producer<String, String> producer;
    private boolean zkReady;
    private boolean brokerReady;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private transient int org$apache$spark$internal$Logging$$levelFlags;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int org$apache$spark$internal$Logging$$levelFlags() {
        return this.org$apache$spark$internal$Logging$$levelFlags;
    }

    public void org$apache$spark$internal$Logging$$levelFlags_$eq(int x$1) {
        this.org$apache$spark$internal$Logging$$levelFlags = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public final boolean isInfoEnabled() {
        return Logging.class.isInfoEnabled((Logging)this);
    }

    public final boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public final boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    private String zkHost() {
        return this.zkHost;
    }

    private int zkPort() {
        return this.zkPort;
    }

    private void zkPort_$eq(int x$1) {
        this.zkPort = x$1;
    }

    private int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    private int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    private EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    private void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    private ZkClient zkClient() {
        return this.zkClient;
    }

    private void zkClient_$eq(ZkClient x$1) {
        this.zkClient = x$1;
    }

    private String brokerHost() {
        return this.brokerHost;
    }

    public int org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort() {
        return this.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort;
    }

    public void org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort_$eq(int x$1) {
        this.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort = x$1;
    }

    public KafkaConfig org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerConf() {
        return this.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerConf;
    }

    public void org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerConf_$eq(KafkaConfig x$1) {
        this.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerConf = x$1;
    }

    public KafkaServer org$apache$spark$streaming$kafka$KafkaTestUtils$$server() {
        return this.org$apache$spark$streaming$kafka$KafkaTestUtils$$server;
    }

    public void org$apache$spark$streaming$kafka$KafkaTestUtils$$server_$eq(KafkaServer x$1) {
        this.org$apache$spark$streaming$kafka$KafkaTestUtils$$server = x$1;
    }

    private Producer<String, String> producer() {
        return this.producer;
    }

    private void producer_$eq(Producer<String, String> x$1) {
        this.producer = x$1;
    }

    private boolean zkReady() {
        return this.zkReady;
    }

    private void zkReady_$eq(boolean x$1) {
        this.zkReady = x$1;
    }

    private boolean brokerReady() {
        return this.brokerReady;
    }

    private void brokerReady_$eq(boolean x$1) {
        this.brokerReady = x$1;
    }

    public String zkAddress() {
        Predef$.MODULE$.assert(this.zkReady(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Zookeeper not setup yet or already torn down, cannot get zookeeper address";
            }
        });
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkHost(), BoxesRunTime.boxToInteger((int)this.zkPort())}));
    }

    public String brokerAddress() {
        Predef$.MODULE$.assert(this.brokerReady(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Kafka not setup yet or already torn down, cannot get broker address";
            }
        });
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.brokerHost(), BoxesRunTime.boxToInteger((int)this.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort())}));
    }

    public ZkClient zookeeperClient() {
        Predef$.MODULE$.assert(this.zkReady(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Zookeeper not setup yet or already torn down, cannot get zookeeper client";
            }
        });
        return (ZkClient)Option$.MODULE$.apply((Object)this.zkClient()).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new IllegalStateException("Zookeeper client is not yet initialized");
            }
        });
    }

    private void setupEmbeddedZookeeper() {
        this.zookeeper_$eq(new EmbeddedZookeeper(this, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkHost(), BoxesRunTime.boxToInteger((int)this.zkPort())}))));
        this.zkPort_$eq(this.zookeeper().actualPort());
        this.zkClient_$eq(new ZkClient(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkHost(), BoxesRunTime.boxToInteger((int)this.zkPort())})), this.zkSessionTimeout(), this.zkConnectionTimeout(), (ZkSerializer)ZKStringSerializer$.MODULE$));
        this.zkReady_$eq(true);
    }

    private void setupEmbeddedKafkaServer() {
        Predef$.MODULE$.assert(this.zkReady(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Zookeeper should be set up beforehand";
            }
        });
        Utils$.MODULE$.startServiceOnPort(this.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort(), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaTestUtils $outer;

            public final Tuple2<KafkaServer, Object> apply(int port) {
                this.$outer.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort_$eq(port);
                this.$outer.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerConf_$eq(new KafkaConfig(this.$outer.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerConfiguration()));
                this.$outer.org$apache$spark$streaming$kafka$KafkaTestUtils$$server_$eq(new KafkaServer(this.$outer.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerConf(), KafkaServer$.MODULE$.$lessinit$greater$default$2()));
                this.$outer.org$apache$spark$streaming$kafka$KafkaTestUtils$$server().startup();
                return new Tuple2((Object)this.$outer.org$apache$spark$streaming$kafka$KafkaTestUtils$$server(), (Object)BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new SparkConf(), "KafkaBroker");
        this.brokerReady_$eq(true);
    }

    public void setup() {
        this.setupEmbeddedZookeeper();
        this.setupEmbeddedKafkaServer();
    }

    public void teardown() {
        this.brokerReady_$eq(false);
        this.zkReady_$eq(false);
        if (this.producer() != null) {
            this.producer().close();
            this.producer_$eq(null);
        }
        if (this.org$apache$spark$streaming$kafka$KafkaTestUtils$$server() != null) {
            this.org$apache$spark$streaming$kafka$KafkaTestUtils$$server().shutdown();
            this.org$apache$spark$streaming$kafka$KafkaTestUtils$$server_$eq(null);
        }
        this.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerConf().logDirs().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(String f) {
                Utils$.MODULE$.deleteRecursively(new File(f));
            }
        });
        if (this.zkClient() != null) {
            this.zkClient().close();
            this.zkClient_$eq(null);
        }
        if (this.zookeeper() != null) {
            this.zookeeper().shutdown();
            this.zookeeper_$eq(null);
        }
    }

    public void createTopic(String topic, int partitions) {
        AdminUtils$.MODULE$.createTopic(this.zkClient(), topic, partitions, 1, AdminUtils$.MODULE$.createTopic$default$5());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitions).foreach$mVc$sp((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaTestUtils $outer;
            private final String topic$1;

            public final void apply(int p) {
                this.apply$mcVI$sp(p);
            }

            public void apply$mcVI$sp(int p) {
                this.$outer.org$apache$spark$streaming$kafka$KafkaTestUtils$$waitUntilMetadataIsPropagated(this.topic$1, p);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$1 = topic$1;
            }
        });
    }

    public void createTopic(String topic) {
        this.createTopic(topic, 1);
    }

    public void sendMessages(String topic, Map<String, Integer> messageToFreq) {
        this.sendMessages(topic, (scala.collection.immutable.Map<String, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply(((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(messageToFreq).asScala()).mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Integer x$1) {
                return x$1;
            }
        }).toSeq())));
    }

    public void sendMessages(String topic, scala.collection.immutable.Map<String, Object> messageToFreq) {
        String[] messages = (String[])((TraversableOnce)messageToFreq.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(Tuple2<String, Object> x0$1) {
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    String s = (String)tuple2._1();
                    int freq = tuple2._2$mcI$sp();
                    Seq seq = (Seq)Seq$.MODULE$.fill(freq, (Function0)new Serializable(this, s){
                        public static final long serialVersionUID = 0L;
                        private final String s$1;

                        public final String apply() {
                            return this.s$1;
                        }
                        {
                            this.s$1 = s$1;
                        }
                    });
                    return seq;
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
        this.sendMessages(topic, messages);
    }

    public void sendMessages(String topic, String[] messages) {
        this.producer_$eq((Producer<String, String>)new Producer(new ProducerConfig(this.producerConfiguration())));
        this.producer().send((Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])messages).map((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$3;

            public final KeyedMessage<String, String> apply(String x$2) {
                return new KeyedMessage(this.topic$3, (Object)x$2);
            }
            {
                this.topic$3 = topic$3;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(KeyedMessage.class)))));
        this.producer().close();
        this.producer_$eq(null);
    }

    /*
     * WARNING - void declaration
     */
    public Properties org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerConfiguration() {
        void var1_1;
        Properties props = new Properties();
        props.put("broker.id", "0");
        props.put("host.name", "localhost");
        props.put("port", ((Object)BoxesRunTime.boxToInteger((int)this.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort())).toString());
        props.put("log.dir", Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).getAbsolutePath());
        props.put("zookeeper.connect", this.zkAddress());
        props.put("log.flush.interval.messages", "1");
        props.put("replica.socket.timeout.ms", "1500");
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Properties producerConfiguration() {
        void var1_1;
        Properties props = new Properties();
        props.put("metadata.broker.list", this.brokerAddress());
        props.put("serializer.class", StringEncoder.class.getName());
        props.put("request.required.acks", "-1");
        return var1_1;
    }

    public <T> T eventually(Time timeout, Time interval, Function0<T> func) {
        long startTime = System.currentTimeMillis();
        return (T)this.tryAgain$1(1, timeout, interval, func, startTime);
    }

    public void org$apache$spark$streaming$kafka$KafkaTestUtils$$waitUntilMetadataIsPropagated(String topic, int partition) {
        this.eventually(new Time(10000L), new Time(100L), (Function0)new Serializable(this, topic, partition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaTestUtils $outer;
            public final String topic$2;
            public final int partition$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Predef$.MODULE$.assert(this.$outer.org$apache$spark$streaming$kafka$KafkaTestUtils$$isPropagated$1(this.topic$2, this.partition$1), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$org$apache$spark$streaming$kafka$KafkaTestUtils$$waitUntilMetadataIsPropagated$1 $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition [", ", ", "] metadata not propagated after timeout"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topic$2, BoxesRunTime.boxToInteger((int)this.$outer.partition$1)}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$2 = topic$2;
                this.partition$1 = partition$1;
            }
        });
    }

    private final Either makeAttempt$1(Function0 func$1) {
        Throwable throwable2;
        block2: {
            Right right;
            try {
                right = package$.MODULE$.Right().apply(func$1.apply());
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                if (!NonFatal$.MODULE$.apply(throwable3)) break block2;
                Left left = package$.MODULE$.Left().apply((Object)throwable3);
                right = left;
            }
            return right;
        }
        throw throwable2;
    }

    private final Object tryAgain$1(int attempt, Time timeout$1, Time interval$1, Function0 func$1, long startTime$1) {
        Either either;
        block2: {
            Throwable e;
            while (true) {
                if ((either = this.makeAttempt$1(func$1)) instanceof Right) {
                    Object result;
                    Right right = (Right)either;
                    Object object = result = right.b();
                    return object;
                }
                if (!(either instanceof Left)) break block2;
                Left left = (Left)either;
                e = (Throwable)left.a();
                long duration = System.currentTimeMillis() - startTime$1;
                if (duration >= timeout$1.milliseconds()) break;
                Thread.sleep(interval$1.milliseconds());
                ++attempt;
            }
            throw new TimeoutException(e.getMessage());
        }
        throw new MatchError((Object)either);
    }

    public final boolean org$apache$spark$streaming$kafka$KafkaTestUtils$$isPropagated$1(String topic$2, int partition$1) {
        boolean bl;
        Option option = this.org$apache$spark$streaming$kafka$KafkaTestUtils$$server().apis().metadataCache().getPartitionInfo(topic$2, partition$1);
        if (option instanceof Some) {
            Some some = (Some)option;
            PartitionStateInfo partitionState = (PartitionStateInfo)some.x();
            LeaderAndIsr leaderAndInSyncReplicas = partitionState.leaderIsrAndControllerEpoch().leaderAndIsr();
            bl = ZkUtils$.MODULE$.getLeaderForPartition(this.zkClient(), topic$2, partition$1).isDefined() && Request$.MODULE$.isValidBrokerId(leaderAndInSyncReplicas.leader()) && leaderAndInSyncReplicas.isr().size() >= 1;
        } else {
            bl = false;
        }
        return bl;
    }

    public KafkaTestUtils() {
        Logging.class.$init$((Logging)this);
        this.zkHost = "localhost";
        this.zkPort = 0;
        this.zkConnectionTimeout = 60000;
        this.zkSessionTimeout = 6000;
        this.brokerHost = "localhost";
        this.org$apache$spark$streaming$kafka$KafkaTestUtils$$brokerPort = RandomUtils.nextInt((int)1024, (int)65536);
        this.zkReady = false;
        this.brokerReady = false;
    }

    public class EmbeddedZookeeper {
        private final String zkConnect;
        private final File snapshotDir;
        private final File logDir;
        private final ZooKeeperServer zookeeper;
        private final /* synthetic */ Tuple2 x$3;
        private final String ip;
        private final int port;
        private final NIOServerCnxnFactory factory;
        private final int actualPort;
        public final /* synthetic */ KafkaTestUtils $outer;

        public String zkConnect() {
            return this.zkConnect;
        }

        public File snapshotDir() {
            return this.snapshotDir;
        }

        public File logDir() {
            return this.logDir;
        }

        public ZooKeeperServer zookeeper() {
            return this.zookeeper;
        }

        public String ip() {
            return this.ip;
        }

        public int port() {
            return this.port;
        }

        public NIOServerCnxnFactory factory() {
            return this.factory;
        }

        public int actualPort() {
            return this.actualPort;
        }

        public void shutdown() {
            this.factory().shutdown();
            Utils$.MODULE$.deleteRecursively(this.snapshotDir());
            Utils$.MODULE$.deleteRecursively(this.logDir());
        }

        public /* synthetic */ KafkaTestUtils org$apache$spark$streaming$kafka$KafkaTestUtils$EmbeddedZookeeper$$$outer() {
            return this.$outer;
        }

        public EmbeddedZookeeper(KafkaTestUtils $outer, String zkConnect) {
            this.zkConnect = zkConnect;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.snapshotDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            this.logDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            this.zookeeper = new ZooKeeperServer(this.snapshotDir(), this.logDir(), 500);
            String[] splits = zkConnect.split(":");
            Tuple2 tuple2 = new Tuple2((Object)splits[0], (Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(splits[1])).toInt()));
            if (tuple2 != null) {
                Tuple2 tuple22;
                String ip = (String)tuple2._1();
                int port = tuple2._2$mcI$sp();
                this.x$3 = tuple22 = new Tuple2((Object)ip, (Object)BoxesRunTime.boxToInteger((int)port));
                this.ip = (String)this.x$3._1();
                this.port = this.x$3._2$mcI$sp();
                this.factory = new NIOServerCnxnFactory();
                this.factory().configure(new InetSocketAddress(this.ip(), this.port()), 16);
                this.factory().startup(this.zookeeper());
                this.actualPort = this.factory().getLocalPort();
                return;
            }
            throw new MatchError((Object)tuple2);
        }
    }
}

