/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kafka010;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.Time$;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.DStreamCheckpointData;
import org.apache.spark.streaming.dstream.InputDStream;
import org.apache.spark.streaming.kafka010.CanCommitOffsets;
import org.apache.spark.streaming.kafka010.ConsumerStrategy;
import org.apache.spark.streaming.kafka010.DirectKafkaInputDStream$;
import org.apache.spark.streaming.kafka010.KafkaRDD;
import org.apache.spark.streaming.kafka010.KafkaUtils$;
import org.apache.spark.streaming.kafka010.LocationStrategy;
import org.apache.spark.streaming.kafka010.OffsetRange;
import org.apache.spark.streaming.kafka010.OffsetRange$;
import org.apache.spark.streaming.kafka010.PerPartitionConfig;
import org.apache.spark.streaming.kafka010.PreferBrokers$;
import org.apache.spark.streaming.kafka010.PreferConsistent$;
import org.apache.spark.streaming.kafka010.PreferFixed;
import org.apache.spark.streaming.scheduler.RateController;
import org.apache.spark.streaming.scheduler.RateController$;
import org.apache.spark.streaming.scheduler.StreamInputInfo;
import org.apache.spark.streaming.scheduler.StreamInputInfo$;
import org.apache.spark.streaming.scheduler.rate.RateEstimator;
import org.apache.spark.streaming.scheduler.rate.RateEstimator$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tUf!B\u0001\u0003\u0001\u0019a!a\u0006#je\u0016\u001cGoS1gW\u0006Le\u000e];u\tN#(/Z1n\u0015\t\u0019A!\u0001\u0005lC\u001a\\\u0017\rM\u00191\u0015\t)a!A\u0005tiJ,\u0017-\\5oO*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014x-F\u0002\u000eA9\u001aB\u0001\u0001\b1mA\u0019qB\u0005\u000b\u000e\u0003AQ!!\u0005\u0003\u0002\u000f\u0011\u001cHO]3b[&\u00111\u0003\u0005\u0002\r\u0013:\u0004X\u000f\u001e#TiJ,\u0017-\u001c\t\u0005+qqR&D\u0001\u0017\u0015\t9\u0002$\u0001\u0005d_:\u001cX/\\3s\u0015\tI\"$A\u0004dY&,g\u000e^:\u000b\u0005mA\u0011!B6bM.\f\u0017BA\u000f\u0017\u00059\u0019uN\\:v[\u0016\u0014(+Z2pe\u0012\u0004\"a\b\u0011\r\u0001\u0011)\u0011\u0005\u0001b\u0001G\t\t1j\u0001\u0001\u0012\u0005\u0011R\u0003CA\u0013)\u001b\u00051#\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%2#a\u0002(pi\"Lgn\u001a\t\u0003K-J!\u0001\f\u0014\u0003\u0007\u0005s\u0017\u0010\u0005\u0002 ]\u0011)q\u0006\u0001b\u0001G\t\ta\u000b\u0005\u00022i5\t!G\u0003\u00024\r\u0005A\u0011N\u001c;fe:\fG.\u0003\u00026e\t9Aj\\4hS:<\u0007CA\u001c9\u001b\u0005\u0011\u0011BA\u001d\u0003\u0005A\u0019\u0015M\\\"p[6LGo\u00144gg\u0016$8\u000f\u0003\u0005<\u0001\t\u0005\t\u0015!\u0003=\u0003\u0011y6o]2\u0011\u0005urT\"\u0001\u0003\n\u0005}\"!\u0001E*ue\u0016\fW.\u001b8h\u0007>tG/\u001a=u\u0011!\t\u0005A!A!\u0002\u0013\u0011\u0015\u0001\u00057pG\u0006$\u0018n\u001c8TiJ\fG/Z4z!\t94)\u0003\u0002E\u0005\t\u0001Bj\\2bi&|gn\u0015;sCR,w-\u001f\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\u0006\u00012m\u001c8tk6,'o\u0015;sCR,w-\u001f\t\u0005o!sR&\u0003\u0002J\u0005\t\u00012i\u001c8tk6,'o\u0015;sCR,w-\u001f\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u0019\u0006\u0019\u0001\u000f]2\u0011\u0005]j\u0015B\u0001(\u0003\u0005I\u0001VM\u001d)beRLG/[8o\u0007>tg-[4\t\u000bA\u0003A\u0011A)\u0002\rqJg.\u001b;?)\u0015\u00116\u000bV+W!\u00119\u0004AH\u0017\t\u000bmz\u0005\u0019\u0001\u001f\t\u000b\u0005{\u0005\u0019\u0001\"\t\u000b\u0019{\u0005\u0019A$\t\u000b-{\u0005\u0019\u0001'\t\u000fa\u0003!\u0019!C\u00013\u0006\u0019R\r_3dkR|'oS1gW\u0006\u0004\u0016M]1ngV\t!\f\u0005\u0003\\A\nLW\"\u0001/\u000b\u0005us\u0016\u0001B;uS2T\u0011aX\u0001\u0005U\u00064\u0018-\u0003\u0002b9\n9\u0001*Y:i\u001b\u0006\u0004\bCA2g\u001d\t)C-\u0003\u0002fM\u00051\u0001K]3eK\u001aL!a\u001a5\u0003\rM#(/\u001b8h\u0015\t)g\u0005\u0005\u0002k[6\t1N\u0003\u0002m=\u0006!A.\u00198h\u0013\tq7N\u0001\u0004PE*,7\r\u001e\u0005\u0007a\u0002\u0001\u000b\u0011\u0002.\u0002)\u0015DXmY;u_J\\\u0015MZ6b!\u0006\u0014\u0018-\\:!\u0011\u001d\u0011\b\u00011A\u0005\u0012M\fabY;se\u0016tGo\u00144gg\u0016$8/F\u0001u!\u0015)(\u0010`A\u0003\u001b\u00051(BA<y\u0003%IW.\\;uC\ndWM\u0003\u0002zM\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005m4(aA'baB\u0019Q0!\u0001\u000e\u0003yT!a \u000e\u0002\r\r|W.\\8o\u0013\r\t\u0019A \u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o!\r)\u0013qA\u0005\u0004\u0003\u00131#\u0001\u0002'p]\u001eD\u0011\"!\u0004\u0001\u0001\u0004%\t\"a\u0004\u0002%\r,(O]3oi>3gm]3ug~#S-\u001d\u000b\u0005\u0003#\t9\u0002E\u0002&\u0003'I1!!\u0006'\u0005\u0011)f.\u001b;\t\u0013\u0005e\u00111BA\u0001\u0002\u0004!\u0018a\u0001=%c!9\u0011Q\u0004\u0001!B\u0013!\u0018aD2veJ,g\u000e^(gMN,Go\u001d\u0011\t\u0013\u0005\u0005\u0002\u00011A\u0005\n\u0005\r\u0012AA6d+\t\t)\u0003E\u0003\u0016\u0003OqR&C\u0002\u0002*Y\u0011\u0001bQ8ogVlWM\u001d\u0005\n\u0003[\u0001\u0001\u0019!C\u0005\u0003_\taa[2`I\u0015\fH\u0003BA\t\u0003cA!\"!\u0007\u0002,\u0005\u0005\t\u0019AA\u0013\u0011!\t)\u0004\u0001Q!\n\u0005\u0015\u0012aA6dA!\"\u00111GA\u001d!\r)\u00131H\u0005\u0004\u0003{1#!\u0003;sC:\u001c\u0018.\u001a8u\u0011\u00199\u0002\u0001\"\u0001\u0002BQ\u0011\u0011Q\u0005\u0005\b\u0003\u000b\u0002A\u0011IA$\u0003\u001d\u0001XM]:jgR$B!!\u0013\u0002PA!q\"a\u0013\u0015\u0013\r\ti\u0005\u0005\u0002\b\tN#(/Z1n\u0011!\t\t&a\u0011A\u0002\u0005M\u0013\u0001\u00038fo2+g/\u001a7\u0011\t\u0005U\u00131L\u0007\u0003\u0003/R1!!\u0017\u0007\u0003\u001d\u0019Ho\u001c:bO\u0016LA!!\u0018\u0002X\ta1\u000b^8sC\u001e,G*\u001a<fY\"9\u0011\u0011\r\u0001\u0005\u0012\u0005\r\u0014AC4fi\n\u0013xn[3sgV\u0011\u0011Q\r\t\u00057\u0002d(\rC\u0004\u0002j\u0001!\t\"a\u001b\u0002#\u001d,G\u000f\u0015:fM\u0016\u0014(/\u001a3I_N$8/\u0006\u0002\u0002nA)1,a\u001c}E&\u00111\u0010\u0018\u0005\t\u0003g\u0002A\u0011\t\u0003\u0002v\u0005!a.Y7f+\u0005\u0011\u0007BCA=\u0001\t\u0007I\u0011\u000b\u0003\u0002|\u0005q1\r[3dWB|\u0017N\u001c;ECR\fWCAA?!\u0011\ty(!!\u000e\u0003\u00011q!a!\u0001\u0001\u0011\t)IA\u0013ESJ,7\r^&bM.\f\u0017J\u001c9vi\u0012\u001bFO]3b[\u000eCWmY6q_&tG\u000fR1uCN!\u0011\u0011QAD!\u0011y\u0011\u0011\u0012\u000b\n\u0007\u0005-\u0005CA\u000bE'R\u0014X-Y7DQ\u0016\u001c7\u000e]8j]R$\u0015\r^1\t\u000fA\u000b\t\t\"\u0001\u0002\u0010R\u0011\u0011Q\u0010\u0005\t\u0003'\u000b\t\t\"\u0001\u0002\u0016\u0006a!-\u0019;dQ\u001a{'\u000fV5nKV\u0011\u0011q\u0013\t\t\u00033\u000by*!)\u0002(6\u0011\u00111\u0014\u0006\u0004\u0003;C\u0018aB7vi\u0006\u0014G.Z\u0005\u0004C\u0006m\u0005cA\u001f\u0002$&\u0019\u0011Q\u0015\u0003\u0003\tQKW.\u001a\t\u0006K\u0005%\u0016QV\u0005\u0004\u0003W3#!B!se\u0006L\bCC\u0013\u00020\n\f\u0019,!\u0002\u0002\u0006%\u0019\u0011\u0011\u0017\u0014\u0003\rQ+\b\u000f\\35!\r)\u0013QW\u0005\u0004\u0003o3#aA%oi\"A\u00111XAA\t\u0003\ni,\u0001\u0004va\u0012\fG/\u001a\u000b\u0005\u0003#\ty\f\u0003\u0005\u0002B\u0006e\u0006\u0019AAQ\u0003\u0011!\u0018.\\3\t\u0011\u0005\u0015\u0017\u0011\u0011C!\u0003\u000f\fqa\u00197fC:,\b\u000f\u0006\u0003\u0002\u0012\u0005%\u0007\u0002CAa\u0003\u0007\u0004\r!!)\t\u0011\u00055\u0017\u0011\u0011C!\u0003\u001f\fqA]3ti>\u0014X\r\u0006\u0002\u0002\u0012!A\u00111\u001b\u0001!\u0002\u0013\ti(A\bdQ\u0016\u001c7\u000e]8j]R$\u0015\r^1!\u0011)\t9\u000e\u0001b\u0001\n#\"\u0011\u0011\\\u0001\u000fe\u0006$XmQ8oiJ|G\u000e\\3s+\t\tY\u000eE\u0003&\u0003;\f\t/C\u0002\u0002`\u001a\u0012aa\u00149uS>t\u0007\u0003BAr\u0003Sl!!!:\u000b\u0007\u0005\u001dH!A\u0005tG\",G-\u001e7fe&!\u00111^As\u00059\u0011\u0016\r^3D_:$(o\u001c7mKJD\u0001\"a<\u0001A\u0003%\u00111\\\u0001\u0010e\u0006$XmQ8oiJ|G\u000e\\3sA!A\u00111\u001f\u0001\u0005\u0012\u0011\t)0A\fnCblUm]:bO\u0016\u001c\b+\u001a:QCJ$\u0018\u000e^5p]R!\u0011q_A\u007f!\u0015)\u0013Q\\A}!\u0019\u0019\u00171 ?\u0002\u0006%\u00111\u0010\u001b\u0005\t\u0003\u007f\f\t\u00101\u0001\u0002z\u00069qN\u001a4tKR\u001c\bb\u0002B\u0002\u0001\u0011%!QA\u0001\ra\u0006\u0014\u0018M\\8jIB{G\u000e\u001c\u000b\u0005\u0003#\u00119\u0001\u0003\u0005\u0003\n\t\u0005\u0001\u0019AA\u0013\u0003\u0005\u0019\u0007b\u0002B\u0007\u0001\u0011E!qB\u0001\u000eY\u0006$Xm\u001d;PM\u001a\u001cX\r^:\u0015\u0005\u0005e\bb\u0002B\n\u0001\u0011E!QC\u0001\u0006G2\fW\u000e\u001d\u000b\u0005\u0003s\u00149\u0002\u0003\u0005\u0002\u0000\nE\u0001\u0019AA}\u0011\u001d\u0011Y\u0002\u0001C!\u0005;\tqaY8naV$X\r\u0006\u0003\u0003 \t\u001d\u0002#B\u0013\u0002^\n\u0005\u0002#B\u001c\u0003$yi\u0013b\u0001B\u0013\u0005\tA1*\u00194lCJ#E\t\u0003\u0005\u0003*\te\u0001\u0019AAQ\u0003%1\u0018\r\\5e)&lW\rC\u0004\u0003.\u0001!\t%a4\u0002\u000bM$\u0018M\u001d;\t\u000f\tE\u0002\u0001\"\u0011\u0002P\u0006!1\u000f^8q\u0011%\u0011)\u0004\u0001b\u0001\n#\u00119$A\u0006d_6l\u0017\u000e^)vKV,WC\u0001B\u001d!\u0019\u0011YD!\u0011\u0003F5\u0011!Q\b\u0006\u0004\u0005\u007fa\u0016AC2p]\u000e,(O]3oi&!!1\tB\u001f\u0005U\u0019uN\\2veJ,g\u000e\u001e'j].,G-U;fk\u0016\u00042a\u000eB$\u0013\r\u0011IE\u0001\u0002\f\u001f\u001a47/\u001a;SC:<W\r\u0003\u0005\u0003N\u0001\u0001\u000b\u0011\u0002B\u001d\u00031\u0019w.\\7jiF+X-^3!\u0011%\u0011\t\u0006\u0001b\u0001\n#\u0011\u0019&\u0001\bd_6l\u0017\u000e^\"bY2\u0014\u0017mY6\u0016\u0005\tU\u0003C\u0002B,\u0005;\u0012\t'\u0004\u0002\u0003Z)!!1\fB\u001f\u0003\u0019\tGo\\7jG&!!q\fB-\u0005=\tEo\\7jGJ+g-\u001a:f]\u000e,\u0007cA\u000b\u0003d%\u0019!Q\r\f\u0003)=3gm]3u\u0007>lW.\u001b;DC2d'-Y2l\u0011!\u0011I\u0007\u0001Q\u0001\n\tU\u0013aD2p[6LGoQ1mY\n\f7m\u001b\u0011\t\u000f\t5\u0004\u0001\"\u0001\u0003p\u0005Y1m\\7nSR\f5/\u001f8d)\u0011\t\tB!\u001d\t\u0011\tM$1\u000ea\u0001\u0005k\nAb\u001c4gg\u0016$(+\u00198hKN\u0004R!JAU\u0005\u000bBqA!\u001c\u0001\t\u0003\u0011I\b\u0006\u0004\u0002\u0012\tm$Q\u0010\u0005\t\u0005g\u00129\b1\u0001\u0003v!A!q\u0010B<\u0001\u0004\u0011\t'\u0001\u0005dC2d'-Y2l\u0011\u001d\u0011\u0019\t\u0001C\t\u0003\u001f\f\u0011bY8n[&$\u0018\t\u001c7\u0007\u000f\t\u001d\u0005\u0001\u0001\u0003\u0003\n\nIB)\u001b:fGR\\\u0015MZ6b%\u0006$XmQ8oiJ|G\u000e\\3s'\u0011\u0011))!9\t\u001b\t5%Q\u0011B\u0001B\u0003%\u00111\u0017BH\u0003\tIG-\u0003\u0003\u0003\u0012\u0006%\u0018!C:ue\u0016\fW.V%E\u0011-\u0011)J!\"\u0003\u0002\u0003\u0006IAa&\u0002\u0013\u0015\u001cH/[7bi>\u0014\b\u0003\u0002BM\u0005?k!Aa'\u000b\t\tu\u0015Q]\u0001\u0005e\u0006$X-\u0003\u0003\u0003\"\nm%!\u0004*bi\u0016,5\u000f^5nCR|'\u000fC\u0004Q\u0005\u000b#\tA!*\u0015\r\t\u001d&\u0011\u0016BV!\u0011\tyH!\"\t\u0011\t5%1\u0015a\u0001\u0003gC\u0001B!&\u0003$\u0002\u0007!q\u0013\u0005\t\u0005_\u0013)\t\"\u0011\u00032\u00069\u0001/\u001e2mSNDG\u0003BA\t\u0005gC\u0001B!(\u0003.\u0002\u0007\u0011Q\u0001")
public class DirectKafkaInputDStream<K, V>
extends InputDStream<ConsumerRecord<K, V>>
implements CanCommitOffsets {
    private final LocationStrategy locationStrategy;
    private final ConsumerStrategy<K, V> consumerStrategy;
    public final PerPartitionConfig org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$$ppc;
    private final HashMap<String, Object> executorKafkaParams;
    private scala.collection.immutable.Map<TopicPartition, Object> currentOffsets;
    private transient Consumer<K, V> kc;
    private final DirectKafkaInputDStreamCheckpointData checkpointData;
    private final Option<RateController> rateController;
    private final ConcurrentLinkedQueue<OffsetRange> commitQueue;
    private final AtomicReference<OffsetCommitCallback> commitCallback;

    public HashMap<String, Object> executorKafkaParams() {
        return this.executorKafkaParams;
    }

    public scala.collection.immutable.Map<TopicPartition, Object> currentOffsets() {
        return this.currentOffsets;
    }

    public void currentOffsets_$eq(scala.collection.immutable.Map<TopicPartition, Object> x$1) {
        this.currentOffsets = x$1;
    }

    private Consumer<K, V> kc() {
        return this.kc;
    }

    private void kc_$eq(Consumer<K, V> x$1) {
        this.kc = x$1;
    }

    public synchronized Consumer<K, V> consumer() {
        if (this.kc() == null) {
            this.kc_$eq(this.consumerStrategy.onStart((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)this.currentOffsets().mapValues((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Long apply(long l) {
                    return new Long(l);
                }
            })).asJava()));
        }
        return this.kc();
    }

    public DStream<ConsumerRecord<K, V>> persist(StorageLevel newLevel) {
        this.logError((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Kafka ConsumerRecord is not serializable. Use .map to extract fields before calling .persist or .window";
            }
        });
        return super.persist(newLevel);
    }

    /*
     * WARNING - void declaration
     */
    public HashMap<TopicPartition, String> getBrokers() {
        void var2_2;
        Consumer<K, V> c = this.consumer();
        HashMap result = new HashMap();
        HashMap<TopicPartition, String> hosts = new HashMap<TopicPartition, String>();
        for (TopicPartition tp : c.assignment()) {
            if (hosts.get(tp) == null) {
                for (PartitionInfo i : c.partitionsFor(tp.topic())) {
                    hosts.put(new TopicPartition(i.topic(), i.partition()), i.leader().host());
                }
            }
            result.put(tp, hosts.get(tp));
        }
        return var2_2;
    }

    public java.util.Map<TopicPartition, String> getPreferredHosts() {
        LocationStrategy locationStrategy;
        block5: {
            java.util.Map<Object, String> map;
            block3: {
                block4: {
                    block2: {
                        locationStrategy = this.locationStrategy;
                        if (!PreferBrokers$.MODULE$.equals(locationStrategy)) break block2;
                        map = this.getBrokers();
                        break block3;
                    }
                    if (!PreferConsistent$.MODULE$.equals(locationStrategy)) break block4;
                    map = Collections.emptyMap();
                    break block3;
                }
                if (!(locationStrategy instanceof PreferFixed)) break block5;
                PreferFixed preferFixed = (PreferFixed)locationStrategy;
                java.util.Map<TopicPartition, String> hostMap = preferFixed.hostMap();
                map = hostMap;
            }
            return map;
        }
        throw new MatchError((Object)locationStrategy);
    }

    public String name() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Kafka 0.10 direct stream [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.id())}));
    }

    public DirectKafkaInputDStreamCheckpointData checkpointData() {
        return this.checkpointData;
    }

    public Option<RateController> rateController() {
        return this.rateController;
    }

    public Option<scala.collection.immutable.Map<TopicPartition, Object>> maxMessagesPerPartition(scala.collection.immutable.Map<TopicPartition, Object> offsets) {
        Option option;
        block7: {
            None$ none$;
            scala.collection.immutable.Map map;
            block6: {
                block5: {
                    Option estimatedRateLimit = this.rateController().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(RateController x$1) {
                            return x$1.getLatestRate();
                        }
                    });
                    option = estimatedRateLimit.filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(long x$2) {
                            return this.apply$mcZJ$sp(x$2);
                        }

                        public boolean apply$mcZJ$sp(long x$2) {
                            return x$2 > 0L;
                        }
                    });
                    if (!(option instanceof Some)) break block5;
                    Some some = (Some)option;
                    long rate = BoxesRunTime.unboxToLong((Object)some.x());
                    scala.collection.immutable.Map lagPerPartition = (scala.collection.immutable.Map)offsets.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ DirectKafkaInputDStream $outer;

                        public final Tuple2<TopicPartition, Object> apply(Tuple2<TopicPartition, Object> x0$1) {
                            Tuple2<TopicPartition, Object> tuple2 = x0$1;
                            if (tuple2 != null) {
                                TopicPartition tp = (TopicPartition)tuple2._1();
                                long offset = tuple2._2$mcJ$sp();
                                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)Math.max(offset - BoxesRunTime.unboxToLong((Object)this.$outer.currentOffsets().apply((Object)tp)), 0L)));
                                return tuple22;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, Map$.MODULE$.canBuildFrom());
                    long totalLag = BoxesRunTime.unboxToLong((Object)lagPerPartition.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                    map = (scala.collection.immutable.Map)lagPerPartition.map((Function1)new Serializable(this, rate, totalLag){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ DirectKafkaInputDStream $outer;
                        private final long rate$1;
                        private final long totalLag$1;

                        public final Tuple2<TopicPartition, Object> apply(Tuple2<TopicPartition, Object> x0$2) {
                            Tuple2<TopicPartition, Object> tuple2 = x0$2;
                            if (tuple2 != null) {
                                TopicPartition tp = (TopicPartition)tuple2._1();
                                long lag = tuple2._2$mcJ$sp();
                                long maxRateLimitPerPartition = this.$outer.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$$ppc.maxRatePerPartition(tp);
                                int backpressureRate = Math.round((float)((double)lag / (double)this.totalLag$1) * (float)this.rate$1);
                                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)(maxRateLimitPerPartition > 0L ? BoxesRunTime.boxToLong((long)Math.min((long)backpressureRate, maxRateLimitPerPartition)) : BoxesRunTime.boxToLong((long)backpressureRate)));
                                return tuple22;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.rate$1 = rate$1;
                            this.totalLag$1 = totalLag$1;
                        }
                    }, Map$.MODULE$.canBuildFrom());
                    break block6;
                }
                if (!None$.MODULE$.equals(option)) break block7;
                map = (scala.collection.immutable.Map)offsets.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ DirectKafkaInputDStream $outer;

                    public final Tuple2<TopicPartition, Object> apply(Tuple2<TopicPartition, Object> x0$3) {
                        Tuple2<TopicPartition, Object> tuple2 = x0$3;
                        if (tuple2 != null) {
                            TopicPartition tp = (TopicPartition)tuple2._1();
                            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$$ppc.maxRatePerPartition(tp)));
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Map$.MODULE$.canBuildFrom());
            }
            scala.collection.immutable.Map effectiveRateLimitPerPartition = map;
            if (BoxesRunTime.unboxToLong((Object)effectiveRateLimitPerPartition.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) > 0L) {
                double secsPerBatch = (double)this.context().graph().batchDuration().milliseconds() / (double)1000;
                none$ = new Some(effectiveRateLimitPerPartition.map((Function1)new Serializable(this, secsPerBatch){
                    public static final long serialVersionUID = 0L;
                    private final double secsPerBatch$1;

                    public final Tuple2<TopicPartition, Object> apply(Tuple2<TopicPartition, Object> x0$4) {
                        Tuple2<TopicPartition, Object> tuple2 = x0$4;
                        if (tuple2 != null) {
                            TopicPartition tp = (TopicPartition)tuple2._1();
                            long limit = tuple2._2$mcJ$sp();
                            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)((long)(this.secsPerBatch$1 * (double)limit))));
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.secsPerBatch$1 = secsPerBatch$1;
                    }
                }, Map$.MODULE$.canBuildFrom()));
            } else {
                none$ = None$.MODULE$;
            }
            return none$;
        }
        throw new MatchError((Object)option);
    }

    private void paranoidPoll(Consumer<K, V> c) {
        ConsumerRecords msgs = c.poll(0L);
        if (!msgs.isEmpty()) {
            ((IterableLike)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)msgs).asScala()).foldLeft((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final scala.collection.immutable.Map<TopicPartition, Object> apply(scala.collection.immutable.Map<TopicPartition, Object> acc, ConsumerRecord<K, V> m) {
                    TopicPartition tp = new TopicPartition(m.topic(), m.partition());
                    long off = BoxesRunTime.unboxToLong((Object)acc.get((Object)tp).map((Function1)new Serializable(this, m){
                        public static final long serialVersionUID = 0L;
                        private final ConsumerRecord m$1;

                        public final long apply(long o) {
                            return this.apply$mcJJ$sp(o);
                        }

                        public long apply$mcJJ$sp(long o) {
                            return Math.min(o, this.m$1.offset());
                        }
                        {
                            this.m$1 = m$1;
                        }
                    }).getOrElse((Function0)new Serializable(this, m){
                        public static final long serialVersionUID = 0L;
                        private final ConsumerRecord m$1;

                        public final long apply() {
                            return this.apply$mcJ$sp();
                        }

                        public long apply$mcJ$sp() {
                            return this.m$1.offset();
                        }
                        {
                            this.m$1 = m$1;
                        }
                    }));
                    return acc.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)off)));
                }
            })).foreach((Function1)new Serializable(this, c){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DirectKafkaInputDStream $outer;
                private final Consumer c$1;

                public final void apply(Tuple2<TopicPartition, Object> x0$5) {
                    Tuple2<TopicPartition, Object> tuple2 = x0$5;
                    if (tuple2 != null) {
                        TopicPartition tp = (TopicPartition)tuple2._1();
                        long off = tuple2._2$mcJ$sp();
                        this.$outer.logInfo((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final TopicPartition tp$1;
                            private final long off$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"poll(0) returned messages, seeking ", " to ", " to compensate"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tp$1, BoxesRunTime.boxToLong((long)this.off$1)}));
                            }
                            {
                                this.tp$1 = tp$1;
                                this.off$1 = off$1;
                            }
                        });
                        this.c$1.seek(tp, off);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.c$1 = c$1;
                }
            });
        }
    }

    public scala.collection.immutable.Map<TopicPartition, Object> latestOffsets() {
        Consumer<K, V> c = this.consumer();
        this.paranoidPoll(c);
        scala.collection.mutable.Set parts = (scala.collection.mutable.Set)JavaConverters$.MODULE$.asScalaSetConverter(c.assignment()).asScala();
        scala.collection.mutable.Set newPartitions = (scala.collection.mutable.Set)parts.diff((GenSet)this.currentOffsets().keySet());
        this.currentOffsets_$eq((scala.collection.immutable.Map<TopicPartition, Object>)this.currentOffsets().$plus$plus((GenTraversableOnce)((TraversableOnce)newPartitions.map((Function1)new Serializable(this, c){
            public static final long serialVersionUID = 0L;
            private final Consumer c$2;

            public final Tuple2<TopicPartition, Object> apply(TopicPartition tp) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)this.c$2.position(tp)));
            }
            {
                this.c$2 = c$2;
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())));
        c.pause((Collection)JavaConverters$.MODULE$.mutableSetAsJavaSetConverter(newPartitions).asJava());
        c.seekToEnd((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.currentOffsets().keySet()).asJava());
        return ((TraversableOnce)parts.map((Function1)new Serializable(this, c){
            public static final long serialVersionUID = 0L;
            private final Consumer c$2;

            public final Tuple2<TopicPartition, Object> apply(TopicPartition tp) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)this.c$2.position(tp)));
            }
            {
                this.c$2 = c$2;
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<TopicPartition, Object> clamp(scala.collection.immutable.Map<TopicPartition, Object> offsets) {
        return (scala.collection.immutable.Map)this.maxMessagesPerPartition(offsets).map((Function1)new Serializable(this, offsets){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DirectKafkaInputDStream $outer;
            public final scala.collection.immutable.Map offsets$1;

            public final scala.collection.immutable.Map<TopicPartition, Object> apply(scala.collection.immutable.Map<TopicPartition, Object> mmp) {
                return (scala.collection.immutable.Map)mmp.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$clamp$1 $outer;

                    public final Tuple2<TopicPartition, Object> apply(Tuple2<TopicPartition, Object> x0$6) {
                        Tuple2<TopicPartition, Object> tuple2 = x0$6;
                        if (tuple2 != null) {
                            TopicPartition tp = (TopicPartition)tuple2._1();
                            long messages = tuple2._2$mcJ$sp();
                            long uo = BoxesRunTime.unboxToLong((Object)this.$outer.offsets$1.apply((Object)tp));
                            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)Math.min(BoxesRunTime.unboxToLong((Object)this.$outer.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$$anonfun$$$outer().currentOffsets().apply((Object)tp)) + messages, uo)));
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Map$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ DirectKafkaInputDStream org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offsets$1 = offsets$1;
            }
        }).getOrElse((Function0)new Serializable(this, offsets){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map offsets$1;

            public final scala.collection.immutable.Map<TopicPartition, Object> apply() {
                return this.offsets$1;
            }
            {
                this.offsets$1 = offsets$1;
            }
        });
    }

    public Option<KafkaRDD<K, V>> compute(Time validTime) {
        scala.collection.immutable.Map<TopicPartition, Object> untilOffsets = this.clamp(this.latestOffsets());
        Iterable offsetRanges = (Iterable)untilOffsets.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DirectKafkaInputDStream $outer;

            public final OffsetRange apply(Tuple2<TopicPartition, Object> x0$7) {
                Tuple2<TopicPartition, Object> tuple2 = x0$7;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    long uo = tuple2._2$mcJ$sp();
                    long fo = BoxesRunTime.unboxToLong((Object)this.$outer.currentOffsets().apply((Object)tp));
                    OffsetRange offsetRange = OffsetRange$.MODULE$.apply(tp.topic(), tp.partition(), fo, uo);
                    return offsetRange;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        KafkaRDD rdd = new KafkaRDD(this.context().sparkContext(), this.executorKafkaParams(), (OffsetRange[])offsetRanges.toArray(ClassTag$.MODULE$.apply(OffsetRange.class)), this.getPreferredHosts(), true);
        String description = ((TraversableOnce)((TraversableLike)offsetRanges.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(OffsetRange offsetRange) {
                return offsetRange.fromOffset() != offsetRange.untilOffset();
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(OffsetRange offsetRange) {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic: ", "\\tpartition: ", "\\t"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{offsetRange.topic(), BoxesRunTime.boxToInteger((int)offsetRange.partition())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"offsets: ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)offsetRange.fromOffset()), BoxesRunTime.boxToLong((long)offsetRange.untilOffset())}))).toString();
            }
        }, Iterable$.MODULE$.canBuildFrom())).mkString("\n");
        scala.collection.immutable.Map metadata = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"offsets"), (Object)offsetRanges.toList()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StreamInputInfo$.MODULE$.METADATA_KEY_DESCRIPTION()), (Object)description)}));
        StreamInputInfo inputInfo = new StreamInputInfo(this.id(), rdd.count(), metadata);
        this.ssc().scheduler().inputInfoTracker().reportInfo(validTime, inputInfo);
        this.currentOffsets_$eq(untilOffsets);
        this.commitAll();
        return new Some(rdd);
    }

    public void start() {
        Consumer<K, V> c = this.consumer();
        this.paranoidPoll(c);
        if (this.currentOffsets().isEmpty()) {
            this.currentOffsets_$eq((scala.collection.immutable.Map<TopicPartition, Object>)((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(c.assignment()).asScala()).map((Function1)new Serializable(this, c){
                public static final long serialVersionUID = 0L;
                private final Consumer c$3;

                public final Tuple2<TopicPartition, Object> apply(TopicPartition tp) {
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)this.c$3.position(tp)));
                }
                {
                    this.c$3 = c$3;
                }
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        }
        c.pause((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.currentOffsets().keySet()).asJava());
    }

    public synchronized void stop() {
        if (this.kc() != null) {
            this.kc().close();
        }
    }

    public ConcurrentLinkedQueue<OffsetRange> commitQueue() {
        return this.commitQueue;
    }

    public AtomicReference<OffsetCommitCallback> commitCallback() {
        return this.commitCallback;
    }

    @Override
    public void commitAsync(OffsetRange[] offsetRanges) {
        this.commitAsync(offsetRanges, null);
    }

    @Override
    public void commitAsync(OffsetRange[] offsetRanges, OffsetCommitCallback callback) {
        this.commitCallback().set(callback);
        this.commitQueue().addAll(Arrays.asList((Object[])offsetRanges));
    }

    public void commitAll() {
        HashMap<TopicPartition, OffsetAndMetadata> m = new HashMap<TopicPartition, OffsetAndMetadata>();
        OffsetRange osr = this.commitQueue().poll();
        while (true) {
            if (osr == null) {
                if (!m.isEmpty()) {
                    this.consumer().commitAsync(m, this.commitCallback().get());
                }
                return;
            }
            TopicPartition tp = osr.topicPartition();
            OffsetAndMetadata x = (OffsetAndMetadata)m.get(tp);
            long offset = x == null ? osr.untilOffset() : Math.max(x.offset(), osr.untilOffset());
            m.put(tp, new OffsetAndMetadata(offset));
            osr = this.commitQueue().poll();
        }
    }

    public DirectKafkaInputDStream(StreamingContext _ssc, LocationStrategy locationStrategy, ConsumerStrategy<K, V> consumerStrategy, PerPartitionConfig ppc) {
        this.locationStrategy = locationStrategy;
        this.consumerStrategy = consumerStrategy;
        this.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$$ppc = ppc;
        super(_ssc, ClassTag$.MODULE$.apply(ConsumerRecord.class));
        HashMap<String, Object> ekp = new HashMap<String, Object>(consumerStrategy.executorKafkaParams());
        KafkaUtils$.MODULE$.fixKafkaParams(ekp);
        this.executorKafkaParams = ekp;
        this.currentOffsets = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        this.kc = null;
        this.checkpointData = new DirectKafkaInputDStreamCheckpointData();
        this.rateController = RateController$.MODULE$.isBackPressureEnabled(this.ssc().conf()) ? new Some((Object)new DirectKafkaRateController(this.id(), RateEstimator$.MODULE$.create(this.ssc().conf(), this.context().graph().batchDuration()))) : None$.MODULE$;
        this.commitQueue = new ConcurrentLinkedQueue();
        this.commitCallback = new AtomicReference();
    }

    public class DirectKafkaRateController
    extends RateController {
        public void publish(long rate) {
        }

        public /* synthetic */ DirectKafkaInputDStream org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaRateController$$$outer() {
            return DirectKafkaInputDStream.this;
        }

        public DirectKafkaRateController(int id, RateEstimator estimator) {
            if (DirectKafkaInputDStream.this == null) {
                throw null;
            }
            super(id, estimator);
        }
    }

    public class DirectKafkaInputDStreamCheckpointData
    extends DStreamCheckpointData<ConsumerRecord<K, V>> {
        public scala.collection.mutable.HashMap<Time, Tuple4<String, Object, Object, Object>[]> batchForTime() {
            return this.data();
        }

        public void update(Time time) {
            this.batchForTime().clear();
            this.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().generatedRDDs().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DirectKafkaInputDStreamCheckpointData $outer;

                public final scala.collection.mutable.HashMap<Time, Tuple4<String, Object, Object, Object>[]> apply(Tuple2<Time, RDD<ConsumerRecord<K, V>>> kv) {
                    Tuple4[] a = (Tuple4[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])((KafkaRDD)kv._2()).offsetRanges()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple4<String, Object, Object, Object> apply(OffsetRange x$3) {
                            return x$3.toTuple();
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple4.class)))).toArray(ClassTag$.MODULE$.apply(Tuple4.class));
                    return this.$outer.batchForTime().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(kv._1()), (Object)a));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }

        public void cleanup(Time time) {
        }

        public void restore() {
            ((IterableLike)this.batchForTime().toSeq().sortBy((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Time apply(Tuple2<Time, Tuple4<String, Object, Object, Object>[]> x$4) {
                    return (Time)x$4._1();
                }
            }, Time$.MODULE$.ordering())).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DirectKafkaInputDStreamCheckpointData $outer;

                public final scala.collection.mutable.Map<Time, RDD<ConsumerRecord<K, V>>> apply(Tuple2<Time, Tuple4<String, Object, Object, Object>[]> x0$8) {
                    Tuple2<Time, Tuple4<String, Object, Object, Object>[]> tuple2 = x0$8;
                    if (tuple2 != null) {
                        Time t = (Time)tuple2._1();
                        Tuple4[] b = (Tuple4[])tuple2._2();
                        this.$outer.logInfo((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final Time t$1;
                            private final Tuple4[] b$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Restoring KafkaRDD for time ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.t$1, Predef$.MODULE$.refArrayOps((Object[])this.b$1).mkString("[", ", ", "]")}));
                            }
                            {
                                this.t$1 = t$1;
                                this.b$1 = b$1;
                            }
                        });
                        scala.collection.mutable.Map map = (scala.collection.mutable.Map)this.$outer.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().generatedRDDs().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t), new KafkaRDD<K, V>(this.$outer.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().context().sparkContext(), this.$outer.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().executorKafkaParams(), (OffsetRange[])Predef$.MODULE$.refArrayOps((Object[])b).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final OffsetRange apply(Tuple4<String, Object, Object, Object> x$5) {
                                return OffsetRange$.MODULE$.apply(x$5);
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(OffsetRange.class))), this.$outer.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().getPreferredHosts(), false)));
                        return map;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }

        public /* synthetic */ DirectKafkaInputDStream org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer() {
            return DirectKafkaInputDStream.this;
        }

        public DirectKafkaInputDStreamCheckpointData() {
            if (DirectKafkaInputDStream.this == null) {
                throw null;
            }
            super(DirectKafkaInputDStream.this, ClassTag$.MODULE$.apply(ConsumerRecord.class));
        }
    }
}

