/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kafka010;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.kafka.common.KafkaException;
import org.apache.spark.internal.Logging;
import org.apache.spark.streaming.kafka010.CachedKafkaConsumer;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class CachedKafkaConsumer$
implements Logging {
    public static final CachedKafkaConsumer$ MODULE$;
    private LinkedHashMap<CachedKafkaConsumer.CacheKey, CachedKafkaConsumer<?, ?>> org$apache$spark$streaming$kafka010$CachedKafkaConsumer$$cache;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private transient int org$apache$spark$internal$Logging$$levelFlags;

    static {
        new CachedKafkaConsumer$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int org$apache$spark$internal$Logging$$levelFlags() {
        return this.org$apache$spark$internal$Logging$$levelFlags;
    }

    public void org$apache$spark$internal$Logging$$levelFlags_$eq(int x$1) {
        this.org$apache$spark$internal$Logging$$levelFlags = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public final boolean isInfoEnabled() {
        return Logging.class.isInfoEnabled((Logging)this);
    }

    public final boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public final boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public LinkedHashMap<CachedKafkaConsumer.CacheKey, CachedKafkaConsumer<?, ?>> org$apache$spark$streaming$kafka010$CachedKafkaConsumer$$cache() {
        return this.org$apache$spark$streaming$kafka010$CachedKafkaConsumer$$cache;
    }

    private void org$apache$spark$streaming$kafka010$CachedKafkaConsumer$$cache_$eq(LinkedHashMap<CachedKafkaConsumer.CacheKey, CachedKafkaConsumer<?, ?>> x$1) {
        this.org$apache$spark$streaming$kafka010$CachedKafkaConsumer$$cache = x$1;
    }

    public void init(int initialCapacity, int maxCapacity, float loadFactor) {
        CachedKafkaConsumer$ cachedKafkaConsumer$ = this;
        synchronized (cachedKafkaConsumer$) {
            BoxedUnit boxedUnit;
            if (this.org$apache$spark$streaming$kafka010$CachedKafkaConsumer$$cache() == null) {
                this.logInfo((Function0<String>)new Serializable(initialCapacity, maxCapacity, loadFactor){
                    public static final long serialVersionUID = 0L;
                    private final int initialCapacity$1;
                    private final int maxCapacity$1;
                    private final float loadFactor$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initializing cache ", " ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.initialCapacity$1), BoxesRunTime.boxToInteger((int)this.maxCapacity$1), BoxesRunTime.boxToFloat((float)this.loadFactor$1)}));
                    }
                    {
                        this.initialCapacity$1 = initialCapacity$1;
                        this.maxCapacity$1 = maxCapacity$1;
                        this.loadFactor$1 = loadFactor$1;
                    }
                });
                this.org$apache$spark$streaming$kafka010$CachedKafkaConsumer$$cache_$eq(new LinkedHashMap<CachedKafkaConsumer.CacheKey, CachedKafkaConsumer<?, ?>>(initialCapacity, maxCapacity, loadFactor){
                    private final int maxCapacity$1;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public boolean removeEldestEntry(Map.Entry<CachedKafkaConsumer.CacheKey, CachedKafkaConsumer<?, ?>> entry) {
                        if (this.size() <= this.maxCapacity$1) return false;
                        try {
                            entry.getValue().consumer().close();
                            return true;
                        }
                        catch (KafkaException kafkaException) {
                            CachedKafkaConsumer$.MODULE$.logError((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Error closing oldest Kafka consumer";
                                }
                            }, kafkaException);
                        }
                        return true;
                    }
                    {
                        this.maxCapacity$1 = maxCapacity$1;
                        super(initialCapacity$1, loadFactor$1, true);
                    }
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public <K, V> CachedKafkaConsumer<K, V> get(String groupId, String topic, int partition, Map<String, Object> kafkaParams) {
        CachedKafkaConsumer$ cachedKafkaConsumer$ = this;
        synchronized (cachedKafkaConsumer$) {
            CachedKafkaConsumer<Object, Object> cachedKafkaConsumer;
            CachedKafkaConsumer.CacheKey k = new CachedKafkaConsumer.CacheKey(groupId, topic, partition);
            CachedKafkaConsumer<?, ?> v = this.org$apache$spark$streaming$kafka010$CachedKafkaConsumer$$cache().get(k);
            if (v == null) {
                this.logInfo((Function0<String>)new Serializable(k){
                    public static final long serialVersionUID = 0L;
                    private final CachedKafkaConsumer.CacheKey k$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cache miss for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.k$1}));
                    }
                    {
                        this.k$1 = k$1;
                    }
                });
                this.logDebug((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return CachedKafkaConsumer$.MODULE$.org$apache$spark$streaming$kafka010$CachedKafkaConsumer$$cache().keySet().toString();
                    }
                });
                CachedKafkaConsumer c = new CachedKafkaConsumer(groupId, topic, partition, kafkaParams);
                this.org$apache$spark$streaming$kafka010$CachedKafkaConsumer$$cache().put(k, c);
                cachedKafkaConsumer = c;
            } else {
                cachedKafkaConsumer = v;
            }
            CachedKafkaConsumer<?, ?> cachedKafkaConsumer2 = cachedKafkaConsumer;
            return cachedKafkaConsumer2;
        }
    }

    public <K, V> CachedKafkaConsumer<K, V> getUncached(String groupId, String topic, int partition, Map<String, Object> kafkaParams) {
        return new CachedKafkaConsumer(groupId, topic, partition, kafkaParams);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(String groupId, String topic, int partition) {
        Object v;
        CachedKafkaConsumer.CacheKey k = new CachedKafkaConsumer.CacheKey(groupId, topic, partition);
        this.logInfo((Function0<String>)new Serializable(k){
            public static final long serialVersionUID = 0L;
            private final CachedKafkaConsumer.CacheKey k$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removing ", " from cache"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.k$2}));
            }
            {
                this.k$2 = k$2;
            }
        });
        CachedKafkaConsumer$ cachedKafkaConsumer$ = this;
        synchronized (cachedKafkaConsumer$) {
            v = this.org$apache$spark$streaming$kafka010$CachedKafkaConsumer$$cache().remove(k);
        }
        CachedKafkaConsumer v2 = (CachedKafkaConsumer)v;
        if (v2 != null) {
            v2.close();
            this.logInfo((Function0<String>)new Serializable(k){
                public static final long serialVersionUID = 0L;
                private final CachedKafkaConsumer.CacheKey k$2;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removed ", " from cache"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.k$2}));
                }
                {
                    this.k$2 = k$2;
                }
            });
        }
    }

    private CachedKafkaConsumer$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.org$apache$spark$streaming$kafka010$CachedKafkaConsumer$$cache = null;
    }
}

