/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kafka010;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.Time$;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.DStreamCheckpointData;
import org.apache.spark.streaming.dstream.InputDStream;
import org.apache.spark.streaming.kafka010.CanCommitOffsets;
import org.apache.spark.streaming.kafka010.ConsumerStrategy;
import org.apache.spark.streaming.kafka010.DirectKafkaInputDStream$;
import org.apache.spark.streaming.kafka010.KafkaRDD;
import org.apache.spark.streaming.kafka010.KafkaUtils$;
import org.apache.spark.streaming.kafka010.LocationStrategy;
import org.apache.spark.streaming.kafka010.OffsetRange;
import org.apache.spark.streaming.kafka010.OffsetRange$;
import org.apache.spark.streaming.kafka010.PreferBrokers$;
import org.apache.spark.streaming.kafka010.PreferConsistent$;
import org.apache.spark.streaming.kafka010.PreferFixed;
import org.apache.spark.streaming.scheduler.RateController;
import org.apache.spark.streaming.scheduler.RateController$;
import org.apache.spark.streaming.scheduler.StreamInputInfo;
import org.apache.spark.streaming.scheduler.StreamInputInfo$;
import org.apache.spark.streaming.scheduler.rate.RateEstimator;
import org.apache.spark.streaming.scheduler.rate.RateEstimator$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t%f!B\u0001\u0003\u0001\u0019a!a\u0006#je\u0016\u001cGoS1gW\u0006Le\u000e];u\tN#(/Z1n\u0015\t\u0019A!\u0001\u0005lC\u001a\\\u0017\rM\u00191\u0015\t)a!A\u0005tiJ,\u0017-\\5oO*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014x-F\u0002\u000eA9\u001aB\u0001\u0001\b1mA\u0019qB\u0005\u000b\u000e\u0003AQ!!\u0005\u0003\u0002\u000f\u0011\u001cHO]3b[&\u00111\u0003\u0005\u0002\r\u0013:\u0004X\u000f\u001e#TiJ,\u0017-\u001c\t\u0005+qqR&D\u0001\u0017\u0015\t9\u0002$\u0001\u0005d_:\u001cX/\\3s\u0015\tI\"$A\u0004dY&,g\u000e^:\u000b\u0005mA\u0011!B6bM.\f\u0017BA\u000f\u0017\u00059\u0019uN\\:v[\u0016\u0014(+Z2pe\u0012\u0004\"a\b\u0011\r\u0001\u0011)\u0011\u0005\u0001b\u0001G\t\t1j\u0001\u0001\u0012\u0005\u0011R\u0003CA\u0013)\u001b\u00051#\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%2#a\u0002(pi\"Lgn\u001a\t\u0003K-J!\u0001\f\u0014\u0003\u0007\u0005s\u0017\u0010\u0005\u0002 ]\u0011)q\u0006\u0001b\u0001G\t\ta\u000b\u0005\u00022i5\t!G\u0003\u00024\r\u0005A\u0011N\u001c;fe:\fG.\u0003\u00026e\t9Aj\\4hS:<\u0007CA\u001c9\u001b\u0005\u0011\u0011BA\u001d\u0003\u0005A\u0019\u0015M\\\"p[6LGo\u00144gg\u0016$8\u000f\u0003\u0005<\u0001\t\u0005\t\u0015!\u0003=\u0003\u0011y6o]2\u0011\u0005urT\"\u0001\u0003\n\u0005}\"!\u0001E*ue\u0016\fW.\u001b8h\u0007>tG/\u001a=u\u0011!\t\u0005A!A!\u0002\u0013\u0011\u0015\u0001\u00057pG\u0006$\u0018n\u001c8TiJ\fG/Z4z!\t94)\u0003\u0002E\u0005\t\u0001Bj\\2bi&|gn\u0015;sCR,w-\u001f\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\u0006\u00012m\u001c8tk6,'o\u0015;sCR,w-\u001f\t\u0005o!sR&\u0003\u0002J\u0005\t\u00012i\u001c8tk6,'o\u0015;sCR,w-\u001f\u0005\u0006\u0017\u0002!\t\u0001T\u0001\u0007y%t\u0017\u000e\u001e \u0015\t5su\n\u0015\t\u0005o\u0001qR\u0006C\u0003<\u0015\u0002\u0007A\bC\u0003B\u0015\u0002\u0007!\tC\u0003G\u0015\u0002\u0007q\tC\u0004S\u0001\t\u0007I\u0011A*\u0002'\u0015DXmY;u_J\\\u0015MZ6b!\u0006\u0014\u0018-\\:\u0016\u0003Q\u0003B!\u0016.]G6\taK\u0003\u0002X1\u0006!Q\u000f^5m\u0015\u0005I\u0016\u0001\u00026bm\u0006L!a\u0017,\u0003\u000f!\u000b7\u000f['baB\u0011Q\f\u0019\b\u0003KyK!a\u0018\u0014\u0002\rA\u0013X\rZ3g\u0013\t\t'M\u0001\u0004TiJLgn\u001a\u0006\u0003?\u001a\u0002\"\u0001Z4\u000e\u0003\u0015T!A\u001a-\u0002\t1\fgnZ\u0005\u0003Q\u0016\u0014aa\u00142kK\u000e$\bB\u00026\u0001A\u0003%A+\u0001\u000bfq\u0016\u001cW\u000f^8s\u0017\u000647.\u0019)be\u0006l7\u000f\t\u0005\bY\u0002\u0001\r\u0011\"\u0005n\u00039\u0019WO\u001d:f]R|eMZ:fiN,\u0012A\u001c\t\u0005_R4H0D\u0001q\u0015\t\t(/A\u0005j[6,H/\u00192mK*\u00111OJ\u0001\u000bG>dG.Z2uS>t\u0017BA;q\u0005\ri\u0015\r\u001d\t\u0003ojl\u0011\u0001\u001f\u0006\u0003sj\taaY8n[>t\u0017BA>y\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\"!J?\n\u0005y4#\u0001\u0002'p]\u001eD\u0011\"!\u0001\u0001\u0001\u0004%\t\"a\u0001\u0002%\r,(O]3oi>3gm]3ug~#S-\u001d\u000b\u0005\u0003\u000b\tY\u0001E\u0002&\u0003\u000fI1!!\u0003'\u0005\u0011)f.\u001b;\t\u0011\u00055q0!AA\u00029\f1\u0001\u001f\u00132\u0011\u001d\t\t\u0002\u0001Q!\n9\fqbY;se\u0016tGo\u00144gg\u0016$8\u000f\t\u0005\n\u0003+\u0001\u0001\u0019!C\u0005\u0003/\t!a[2\u0016\u0005\u0005e\u0001#B\u000b\u0002\u001cyi\u0013bAA\u000f-\tA1i\u001c8tk6,'\u000fC\u0005\u0002\"\u0001\u0001\r\u0011\"\u0003\u0002$\u000511nY0%KF$B!!\u0002\u0002&!Q\u0011QBA\u0010\u0003\u0003\u0005\r!!\u0007\t\u0011\u0005%\u0002\u0001)Q\u0005\u00033\t1a[2!Q\u0011\t9#!\f\u0011\u0007\u0015\ny#C\u0002\u00022\u0019\u0012\u0011\u0002\u001e:b]NLWM\u001c;\t\r]\u0001A\u0011AA\u001b)\t\tI\u0002C\u0004\u0002:\u0001!\t%a\u000f\u0002\u000fA,'o]5tiR!\u0011QHA\"!\u0011y\u0011q\b\u000b\n\u0007\u0005\u0005\u0003CA\u0004E'R\u0014X-Y7\t\u0011\u0005\u0015\u0013q\u0007a\u0001\u0003\u000f\n\u0001B\\3x\u0019\u00164X\r\u001c\t\u0005\u0003\u0013\ny%\u0004\u0002\u0002L)\u0019\u0011Q\n\u0004\u0002\u000fM$xN]1hK&!\u0011\u0011KA&\u00051\u0019Fo\u001c:bO\u0016dUM^3m\u0011\u001d\t)\u0006\u0001C\t\u0003/\n!bZ3u\u0005J|7.\u001a:t+\t\tI\u0006\u0005\u0003V5Zd\u0006bBA/\u0001\u0011E\u0011qL\u0001\u0012O\u0016$\bK]3gKJ\u0014X\r\u001a%pgR\u001cXCAA1!\u0015)\u00161\r<]\u0013\t)h\u000b\u0003\u0005\u0002h\u0001!\t\u0005BA5\u0003\u0011q\u0017-\\3\u0016\u0003qC!\"!\u001c\u0001\u0005\u0004%\t\u0006BA8\u00039\u0019\u0007.Z2la>Lg\u000e\u001e#bi\u0006,\"!!\u001d\u0011\t\u0005M\u0014QO\u0007\u0002\u0001\u00199\u0011q\u000f\u0001\u0001\t\u0005e$!\n#je\u0016\u001cGoS1gW\u0006Le\u000e];u\tN#(/Z1n\u0007\",7m\u001b9pS:$H)\u0019;b'\u0011\t)(a\u001f\u0011\t=\ti\bF\u0005\u0004\u0003\u007f\u0002\"!\u0006#TiJ,\u0017-\\\"iK\u000e\\\u0007o\\5oi\u0012\u000bG/\u0019\u0005\b\u0017\u0006UD\u0011AAB)\t\t\t\b\u0003\u0005\u0002\b\u0006UD\u0011AAE\u00031\u0011\u0017\r^2i\r>\u0014H+[7f+\t\tY\t\u0005\u0005\u0002\u000e\u0006M\u0015QSAN\u001b\t\tyIC\u0002\u0002\u0012J\fq!\\;uC\ndW-C\u0002\\\u0003\u001f\u00032!PAL\u0013\r\tI\n\u0002\u0002\u0005)&lW\rE\u0003&\u0003;\u000b\t+C\u0002\u0002 \u001a\u0012Q!\u0011:sCf\u0004\u0002\"JAR9\u0006\u001dF\u0010`\u0005\u0004\u0003K3#A\u0002+va2,G\u0007E\u0002&\u0003SK1!a+'\u0005\rIe\u000e\u001e\u0005\t\u0003_\u000b)\b\"\u0011\u00022\u00061Q\u000f\u001d3bi\u0016$B!!\u0002\u00024\"A\u0011QWAW\u0001\u0004\t)*\u0001\u0003uS6,\u0007\u0002CA]\u0003k\"\t%a/\u0002\u000f\rdW-\u00198vaR!\u0011QAA_\u0011!\t),a.A\u0002\u0005U\u0005\u0002CAa\u0003k\"\t%a1\u0002\u000fI,7\u000f^8sKR\u0011\u0011Q\u0001\u0005\t\u0003\u000f\u0004\u0001\u0015!\u0003\u0002r\u0005y1\r[3dWB|\u0017N\u001c;ECR\f\u0007\u0005\u0003\u0006\u0002L\u0002\u0011\r\u0011\"\u0015\u0005\u0003\u001b\faB]1uK\u000e{g\u000e\u001e:pY2,'/\u0006\u0002\u0002PB)Q%!5\u0002V&\u0019\u00111\u001b\u0014\u0003\r=\u0003H/[8o!\u0011\t9.!8\u000e\u0005\u0005e'bAAn\t\u0005I1o\u00195fIVdWM]\u0005\u0005\u0003?\fIN\u0001\bSCR,7i\u001c8ue>dG.\u001a:\t\u0011\u0005\r\b\u0001)A\u0005\u0003\u001f\fqB]1uK\u000e{g\u000e\u001e:pY2,'\u000f\t\u0005\n\u0003O\u0004!\u0019!C\u0005\u0003S\f\u0001$\\1y%\u0006$X\rT5nSR\u0004VM\u001d)beRLG/[8o+\t\t9\u000b\u0003\u0005\u0002n\u0002\u0001\u000b\u0011BAT\u0003ei\u0017\r\u001f*bi\u0016d\u0015.\\5u!\u0016\u0014\b+\u0019:uSRLwN\u001c\u0011\t\u0011\u0005E\b\u0001\"\u0005\u0005\u0003g\fq#\\1y\u001b\u0016\u001c8/Y4fgB+'\u000fU1si&$\u0018n\u001c8\u0015\t\u0005U\u00181 \t\u0006K\u0005E\u0017q\u001f\t\u0006;\u0006eh\u000f`\u0005\u0003k\nD\u0001\"!@\u0002p\u0002\u0007\u0011q_\u0001\b_\u001a47/\u001a;t\u0011\u001d\u0011\t\u0001\u0001C\t\u0005\u0007\tQ\u0002\\1uKN$xJ\u001a4tKR\u001cHCAA|\u0011\u001d\u00119\u0001\u0001C\t\u0005\u0013\tQa\u00197b[B$B!a>\u0003\f!A\u0011Q B\u0003\u0001\u0004\t9\u0010C\u0004\u0003\u0010\u0001!\tE!\u0005\u0002\u000f\r|W\u000e];uKR!!1\u0003B\u000e!\u0015)\u0013\u0011\u001bB\u000b!\u00159$q\u0003\u0010.\u0013\r\u0011IB\u0001\u0002\t\u0017\u000647.\u0019*E\t\"A!Q\u0004B\u0007\u0001\u0004\t)*A\u0005wC2LG\rV5nK\"9!\u0011\u0005\u0001\u0005B\u0005\r\u0017!B:uCJ$\bb\u0002B\u0013\u0001\u0011\u0005\u00131Y\u0001\u0005gR|\u0007\u000fC\u0005\u0003*\u0001\u0011\r\u0011\"\u0005\u0003,\u0005Y1m\\7nSR\fV/Z;f+\t\u0011i\u0003\u0005\u0004\u00030\tU\"\u0011H\u0007\u0003\u0005cQ1Aa\rW\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0005o\u0011\tDA\u000bD_:\u001cWO\u001d:f]Rd\u0015N\\6fIF+X-^3\u0011\u0007]\u0012Y$C\u0002\u0003>\t\u00111b\u00144gg\u0016$(+\u00198hK\"A!\u0011\t\u0001!\u0002\u0013\u0011i#\u0001\u0007d_6l\u0017\u000e^)vKV,\u0007\u0005C\u0005\u0003F\u0001\u0011\r\u0011\"\u0005\u0003H\u0005q1m\\7nSR\u001c\u0015\r\u001c7cC\u000e\\WC\u0001B%!\u0019\u0011YE!\u0015\u0003V5\u0011!Q\n\u0006\u0005\u0005\u001f\u0012\t$\u0001\u0004bi>l\u0017nY\u0005\u0005\u0005'\u0012iEA\bBi>l\u0017n\u0019*fM\u0016\u0014XM\\2f!\r)\"qK\u0005\u0004\u000532\"\u0001F(gMN,GoQ8n[&$8)\u00197mE\u0006\u001c7\u000e\u0003\u0005\u0003^\u0001\u0001\u000b\u0011\u0002B%\u0003=\u0019w.\\7ji\u000e\u000bG\u000e\u001c2bG.\u0004\u0003b\u0002B1\u0001\u0011\u0005!1M\u0001\fG>lW.\u001b;Bgft7\r\u0006\u0003\u0002\u0006\t\u0015\u0004\u0002\u0003B4\u0005?\u0002\rA!\u001b\u0002\u0019=4gm]3u%\u0006tw-Z:\u0011\u000b\u0015\niJ!\u000f\t\u000f\t\u0005\u0004\u0001\"\u0001\u0003nQ1\u0011Q\u0001B8\u0005cB\u0001Ba\u001a\u0003l\u0001\u0007!\u0011\u000e\u0005\t\u0005g\u0012Y\u00071\u0001\u0003V\u0005A1-\u00197mE\u0006\u001c7\u000eC\u0004\u0003x\u0001!\t\"a1\u0002\u0013\r|W.\\5u\u00032dga\u0002B>\u0001\u0001!!Q\u0010\u0002\u001a\t&\u0014Xm\u0019;LC\u001a\\\u0017MU1uK\u000e{g\u000e\u001e:pY2,'o\u0005\u0003\u0003z\u0005U\u0007\"\u0004BA\u0005s\u0012\t\u0011)A\u0005\u0003O\u0013\u0019)\u0001\u0002jI&!!QQAo\u0003%\u0019HO]3b[VKE\tC\u0006\u0003\n\ne$\u0011!Q\u0001\n\t-\u0015!C3ti&l\u0017\r^8s!\u0011\u0011iIa%\u000e\u0005\t=%\u0002\u0002BI\u00033\fAA]1uK&!!Q\u0013BH\u00055\u0011\u0016\r^3FgRLW.\u0019;pe\"91J!\u001f\u0005\u0002\teEC\u0002BN\u0005;\u0013y\n\u0005\u0003\u0002t\te\u0004\u0002\u0003BA\u0005/\u0003\r!a*\t\u0011\t%%q\u0013a\u0001\u0005\u0017C\u0001Ba)\u0003z\u0011\u0005#QU\u0001\baV\u0014G.[:i)\u0011\t)Aa*\t\u000f\tE%\u0011\u0015a\u0001y\u0002")
public class DirectKafkaInputDStream<K, V>
extends InputDStream<ConsumerRecord<K, V>>
implements CanCommitOffsets {
    private final LocationStrategy locationStrategy;
    private final ConsumerStrategy<K, V> consumerStrategy;
    private final HashMap<String, Object> executorKafkaParams;
    private scala.collection.immutable.Map<TopicPartition, Object> currentOffsets;
    private transient Consumer<K, V> kc;
    private final DirectKafkaInputDStreamCheckpointData checkpointData;
    private final Option<RateController> rateController;
    private final int org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$$maxRateLimitPerPartition;
    private final ConcurrentLinkedQueue<OffsetRange> commitQueue;
    private final AtomicReference<OffsetCommitCallback> commitCallback;

    public HashMap<String, Object> executorKafkaParams() {
        return this.executorKafkaParams;
    }

    public scala.collection.immutable.Map<TopicPartition, Object> currentOffsets() {
        return this.currentOffsets;
    }

    public void currentOffsets_$eq(scala.collection.immutable.Map<TopicPartition, Object> x$1) {
        this.currentOffsets = x$1;
    }

    private Consumer<K, V> kc() {
        return this.kc;
    }

    private void kc_$eq(Consumer<K, V> x$1) {
        this.kc = x$1;
    }

    public synchronized Consumer<K, V> consumer() {
        if (this.kc() == null) {
            this.kc_$eq(this.consumerStrategy.onStart((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)this.currentOffsets().mapValues((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Long apply(long l) {
                    return new Long(l);
                }
            })).asJava()));
        }
        return this.kc();
    }

    public DStream<ConsumerRecord<K, V>> persist(StorageLevel newLevel) {
        this.logError((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Kafka ConsumerRecord is not serializable. Use .map to extract fields before calling .persist or .window";
            }
        });
        return super.persist(newLevel);
    }

    /*
     * WARNING - void declaration
     */
    public HashMap<TopicPartition, String> getBrokers() {
        void var2_2;
        Consumer<K, V> c = this.consumer();
        HashMap result = new HashMap();
        HashMap<TopicPartition, String> hosts = new HashMap<TopicPartition, String>();
        for (TopicPartition tp : c.assignment()) {
            if (hosts.get(tp) == null) {
                for (PartitionInfo i : c.partitionsFor(tp.topic())) {
                    hosts.put(new TopicPartition(i.topic(), i.partition()), i.leader().host());
                }
            }
            result.put(tp, hosts.get(tp));
        }
        return var2_2;
    }

    public java.util.Map<TopicPartition, String> getPreferredHosts() {
        LocationStrategy locationStrategy;
        block5: {
            java.util.Map<Object, String> map;
            block3: {
                block4: {
                    block2: {
                        locationStrategy = this.locationStrategy;
                        if (!PreferBrokers$.MODULE$.equals(locationStrategy)) break block2;
                        map = this.getBrokers();
                        break block3;
                    }
                    if (!PreferConsistent$.MODULE$.equals(locationStrategy)) break block4;
                    map = Collections.emptyMap();
                    break block3;
                }
                if (!(locationStrategy instanceof PreferFixed)) break block5;
                PreferFixed preferFixed = (PreferFixed)locationStrategy;
                java.util.Map<TopicPartition, String> hostMap = preferFixed.hostMap();
                map = hostMap;
            }
            return map;
        }
        throw new MatchError((Object)locationStrategy);
    }

    public String name() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Kafka 0.10 direct stream [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.id())}));
    }

    public DirectKafkaInputDStreamCheckpointData checkpointData() {
        return this.checkpointData;
    }

    public Option<RateController> rateController() {
        return this.rateController;
    }

    public int org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$$maxRateLimitPerPartition() {
        return this.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$$maxRateLimitPerPartition;
    }

    public Option<scala.collection.immutable.Map<TopicPartition, Object>> maxMessagesPerPartition(scala.collection.immutable.Map<TopicPartition, Object> offsets) {
        Option option;
        block7: {
            None$ none$;
            scala.collection.immutable.Map map;
            block6: {
                block5: {
                    Option estimatedRateLimit = this.rateController().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(RateController x$1) {
                            return (int)x$1.getLatestRate();
                        }
                    });
                    option = estimatedRateLimit.filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(int x$2) {
                            return this.apply$mcZI$sp(x$2);
                        }

                        public boolean apply$mcZI$sp(int x$2) {
                            return x$2 > 0;
                        }
                    });
                    if (!(option instanceof Some)) break block5;
                    Some some = (Some)option;
                    int rate = BoxesRunTime.unboxToInt((Object)some.x());
                    scala.collection.immutable.Map lagPerPartition = (scala.collection.immutable.Map)offsets.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ DirectKafkaInputDStream $outer;

                        public final Tuple2<TopicPartition, Object> apply(Tuple2<TopicPartition, Object> x0$1) {
                            Tuple2<TopicPartition, Object> tuple2 = x0$1;
                            if (tuple2 != null) {
                                TopicPartition tp = (TopicPartition)tuple2._1();
                                long offset = tuple2._2$mcJ$sp();
                                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)Math.max(offset - BoxesRunTime.unboxToLong((Object)this.$outer.currentOffsets().apply((Object)tp)), 0L)));
                                return tuple22;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, Map$.MODULE$.canBuildFrom());
                    long totalLag = BoxesRunTime.unboxToLong((Object)lagPerPartition.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                    map = (scala.collection.immutable.Map)lagPerPartition.map((Function1)new Serializable(this, rate, totalLag){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ DirectKafkaInputDStream $outer;
                        private final int rate$1;
                        private final long totalLag$1;

                        public final Tuple2<TopicPartition, Object> apply(Tuple2<TopicPartition, Object> x0$2) {
                            Tuple2<TopicPartition, Object> tuple2 = x0$2;
                            if (tuple2 != null) {
                                TopicPartition tp = (TopicPartition)tuple2._1();
                                long lag = tuple2._2$mcJ$sp();
                                int backpressureRate = Math.round((float)((double)lag / (double)this.totalLag$1) * (float)this.rate$1);
                                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)(this.$outer.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$$maxRateLimitPerPartition() > 0 ? BoxesRunTime.boxToInteger((int)Math.min(backpressureRate, this.$outer.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$$maxRateLimitPerPartition())) : BoxesRunTime.boxToInteger((int)backpressureRate)));
                                return tuple22;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.rate$1 = rate$1;
                            this.totalLag$1 = totalLag$1;
                        }
                    }, Map$.MODULE$.canBuildFrom());
                    break block6;
                }
                if (!None$.MODULE$.equals(option)) break block7;
                map = (scala.collection.immutable.Map)offsets.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ DirectKafkaInputDStream $outer;

                    public final Tuple2<TopicPartition, Object> apply(Tuple2<TopicPartition, Object> x0$3) {
                        Tuple2<TopicPartition, Object> tuple2 = x0$3;
                        if (tuple2 != null) {
                            TopicPartition tp = (TopicPartition)tuple2._1();
                            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$$maxRateLimitPerPartition()));
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Map$.MODULE$.canBuildFrom());
            }
            scala.collection.immutable.Map effectiveRateLimitPerPartition = map;
            if (BoxesRunTime.unboxToInt((Object)effectiveRateLimitPerPartition.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) > 0) {
                double secsPerBatch = (double)this.context().graph().batchDuration().milliseconds() / (double)1000;
                none$ = new Some(effectiveRateLimitPerPartition.map((Function1)new Serializable(this, secsPerBatch){
                    public static final long serialVersionUID = 0L;
                    private final double secsPerBatch$1;

                    public final Tuple2<TopicPartition, Object> apply(Tuple2<TopicPartition, Object> x0$4) {
                        Tuple2<TopicPartition, Object> tuple2 = x0$4;
                        if (tuple2 != null) {
                            TopicPartition tp = (TopicPartition)tuple2._1();
                            int limit = tuple2._2$mcI$sp();
                            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)((long)(this.secsPerBatch$1 * (double)limit))));
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.secsPerBatch$1 = secsPerBatch$1;
                    }
                }, Map$.MODULE$.canBuildFrom()));
            } else {
                none$ = None$.MODULE$;
            }
            return none$;
        }
        throw new MatchError((Object)option);
    }

    public scala.collection.immutable.Map<TopicPartition, Object> latestOffsets() {
        Consumer<K, V> c = this.consumer();
        c.poll(0L);
        scala.collection.mutable.Set parts = (scala.collection.mutable.Set)JavaConverters$.MODULE$.asScalaSetConverter(c.assignment()).asScala();
        scala.collection.mutable.Set newPartitions = (scala.collection.mutable.Set)parts.diff((GenSet)this.currentOffsets().keySet());
        this.currentOffsets_$eq((scala.collection.immutable.Map<TopicPartition, Object>)this.currentOffsets().$plus$plus((GenTraversableOnce)((TraversableOnce)newPartitions.map((Function1)new Serializable(this, c){
            public static final long serialVersionUID = 0L;
            private final Consumer c$1;

            public final Tuple2<TopicPartition, Object> apply(TopicPartition tp) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)this.c$1.position(tp)));
            }
            {
                this.c$1 = c$1;
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())));
        c.pause((Collection)JavaConverters$.MODULE$.mutableSetAsJavaSetConverter(newPartitions).asJava());
        c.seekToEnd((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.currentOffsets().keySet()).asJava());
        return ((TraversableOnce)parts.map((Function1)new Serializable(this, c){
            public static final long serialVersionUID = 0L;
            private final Consumer c$1;

            public final Tuple2<TopicPartition, Object> apply(TopicPartition tp) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)this.c$1.position(tp)));
            }
            {
                this.c$1 = c$1;
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<TopicPartition, Object> clamp(scala.collection.immutable.Map<TopicPartition, Object> offsets) {
        return (scala.collection.immutable.Map)this.maxMessagesPerPartition(offsets).map((Function1)new Serializable(this, offsets){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DirectKafkaInputDStream $outer;
            public final scala.collection.immutable.Map offsets$1;

            public final scala.collection.immutable.Map<TopicPartition, Object> apply(scala.collection.immutable.Map<TopicPartition, Object> mmp) {
                return (scala.collection.immutable.Map)mmp.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$clamp$1 $outer;

                    public final Tuple2<TopicPartition, Object> apply(Tuple2<TopicPartition, Object> x0$5) {
                        Tuple2<TopicPartition, Object> tuple2 = x0$5;
                        if (tuple2 != null) {
                            TopicPartition tp = (TopicPartition)tuple2._1();
                            long messages = tuple2._2$mcJ$sp();
                            long uo = BoxesRunTime.unboxToLong((Object)this.$outer.offsets$1.apply((Object)tp));
                            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)Math.min(BoxesRunTime.unboxToLong((Object)this.$outer.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$$anonfun$$$outer().currentOffsets().apply((Object)tp)) + messages, uo)));
                            return tuple22;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Map$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ DirectKafkaInputDStream org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offsets$1 = offsets$1;
            }
        }).getOrElse((Function0)new Serializable(this, offsets){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map offsets$1;

            public final scala.collection.immutable.Map<TopicPartition, Object> apply() {
                return this.offsets$1;
            }
            {
                this.offsets$1 = offsets$1;
            }
        });
    }

    public Option<KafkaRDD<K, V>> compute(Time validTime) {
        scala.collection.immutable.Map<TopicPartition, Object> untilOffsets = this.clamp(this.latestOffsets());
        Iterable offsetRanges = (Iterable)untilOffsets.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DirectKafkaInputDStream $outer;

            public final OffsetRange apply(Tuple2<TopicPartition, Object> x0$6) {
                Tuple2<TopicPartition, Object> tuple2 = x0$6;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    long uo = tuple2._2$mcJ$sp();
                    long fo = BoxesRunTime.unboxToLong((Object)this.$outer.currentOffsets().apply((Object)tp));
                    OffsetRange offsetRange = OffsetRange$.MODULE$.apply(tp.topic(), tp.partition(), fo, uo);
                    return offsetRange;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Iterable$.MODULE$.canBuildFrom());
        KafkaRDD rdd = new KafkaRDD(this.context().sparkContext(), this.executorKafkaParams(), (OffsetRange[])offsetRanges.toArray(ClassTag$.MODULE$.apply(OffsetRange.class)), this.getPreferredHosts(), true);
        String description = ((TraversableOnce)((TraversableLike)offsetRanges.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(OffsetRange offsetRange) {
                return offsetRange.fromOffset() != offsetRange.untilOffset();
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(OffsetRange offsetRange) {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic: ", "\\tpartition: ", "\\t"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{offsetRange.topic(), BoxesRunTime.boxToInteger((int)offsetRange.partition())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"offsets: ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)offsetRange.fromOffset()), BoxesRunTime.boxToLong((long)offsetRange.untilOffset())}))).toString();
            }
        }, Iterable$.MODULE$.canBuildFrom())).mkString("\n");
        scala.collection.immutable.Map metadata = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"offsets"), (Object)offsetRanges.toList()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StreamInputInfo$.MODULE$.METADATA_KEY_DESCRIPTION()), (Object)description)}));
        StreamInputInfo inputInfo = new StreamInputInfo(this.id(), rdd.count(), metadata);
        this.ssc().scheduler().inputInfoTracker().reportInfo(validTime, inputInfo);
        this.currentOffsets_$eq(untilOffsets);
        this.commitAll();
        return new Some(rdd);
    }

    public void start() {
        Consumer<K, V> c = this.consumer();
        c.poll(0L);
        if (this.currentOffsets().isEmpty()) {
            this.currentOffsets_$eq((scala.collection.immutable.Map<TopicPartition, Object>)((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(c.assignment()).asScala()).map((Function1)new Serializable(this, c){
                public static final long serialVersionUID = 0L;
                private final Consumer c$2;

                public final Tuple2<TopicPartition, Object> apply(TopicPartition tp) {
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)BoxesRunTime.boxToLong((long)this.c$2.position(tp)));
                }
                {
                    this.c$2 = c$2;
                }
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        }
        c.pause((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.currentOffsets().keySet()).asJava());
    }

    public synchronized void stop() {
        if (this.kc() != null) {
            this.kc().close();
        }
    }

    public ConcurrentLinkedQueue<OffsetRange> commitQueue() {
        return this.commitQueue;
    }

    public AtomicReference<OffsetCommitCallback> commitCallback() {
        return this.commitCallback;
    }

    @Override
    public void commitAsync(OffsetRange[] offsetRanges) {
        this.commitAsync(offsetRanges, null);
    }

    @Override
    public void commitAsync(OffsetRange[] offsetRanges, OffsetCommitCallback callback) {
        this.commitCallback().set(callback);
        this.commitQueue().addAll(Arrays.asList((Object[])offsetRanges));
    }

    public void commitAll() {
        HashMap<TopicPartition, OffsetAndMetadata> m = new HashMap<TopicPartition, OffsetAndMetadata>();
        for (OffsetRange osr : this.commitQueue()) {
            TopicPartition tp = osr.topicPartition();
            OffsetAndMetadata x = (OffsetAndMetadata)m.get(tp);
            long offset = x == null ? osr.untilOffset() : Math.max(x.offset(), osr.untilOffset());
            m.put(tp, new OffsetAndMetadata(offset));
        }
        if (!m.isEmpty()) {
            this.consumer().commitAsync(m, this.commitCallback().get());
        }
    }

    public DirectKafkaInputDStream(StreamingContext _ssc, LocationStrategy locationStrategy, ConsumerStrategy<K, V> consumerStrategy) {
        this.locationStrategy = locationStrategy;
        this.consumerStrategy = consumerStrategy;
        super(_ssc, ClassTag$.MODULE$.apply(ConsumerRecord.class));
        HashMap<String, Object> ekp = new HashMap<String, Object>(consumerStrategy.executorKafkaParams());
        KafkaUtils$.MODULE$.fixKafkaParams(ekp);
        this.executorKafkaParams = ekp;
        this.currentOffsets = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        this.kc = null;
        this.checkpointData = new DirectKafkaInputDStreamCheckpointData();
        this.rateController = RateController$.MODULE$.isBackPressureEnabled(this.ssc().conf()) ? new Some((Object)new DirectKafkaRateController(this.id(), RateEstimator$.MODULE$.create(this.ssc().conf(), this.context().graph().batchDuration()))) : None$.MODULE$;
        this.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$$maxRateLimitPerPartition = this.context().sparkContext().getConf().getInt("spark.streaming.kafka.maxRatePerPartition", 0);
        this.commitQueue = new ConcurrentLinkedQueue();
        this.commitCallback = new AtomicReference();
    }

    public class DirectKafkaRateController
    extends RateController {
        public void publish(long rate) {
        }

        public /* synthetic */ DirectKafkaInputDStream org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaRateController$$$outer() {
            return DirectKafkaInputDStream.this;
        }

        public DirectKafkaRateController(int id, RateEstimator estimator) {
            if (DirectKafkaInputDStream.this == null) {
                throw null;
            }
            super(id, estimator);
        }
    }

    public class DirectKafkaInputDStreamCheckpointData
    extends DStreamCheckpointData<ConsumerRecord<K, V>> {
        public scala.collection.mutable.HashMap<Time, Tuple4<String, Object, Object, Object>[]> batchForTime() {
            return this.data();
        }

        public void update(Time time) {
            this.batchForTime().clear();
            this.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().generatedRDDs().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DirectKafkaInputDStreamCheckpointData $outer;

                public final scala.collection.mutable.HashMap<Time, Tuple4<String, Object, Object, Object>[]> apply(Tuple2<Time, RDD<ConsumerRecord<K, V>>> kv) {
                    Tuple4[] a = (Tuple4[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])((KafkaRDD)kv._2()).offsetRanges()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple4<String, Object, Object, Object> apply(OffsetRange x$3) {
                            return x$3.toTuple();
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple4.class)))).toArray(ClassTag$.MODULE$.apply(Tuple4.class));
                    return this.$outer.batchForTime().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(kv._1()), (Object)a));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }

        public void cleanup(Time time) {
        }

        public void restore() {
            ((IterableLike)this.batchForTime().toSeq().sortBy((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Time apply(Tuple2<Time, Tuple4<String, Object, Object, Object>[]> x$4) {
                    return (Time)x$4._1();
                }
            }, Time$.MODULE$.ordering())).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DirectKafkaInputDStreamCheckpointData $outer;

                public final scala.collection.mutable.Map<Time, RDD<ConsumerRecord<K, V>>> apply(Tuple2<Time, Tuple4<String, Object, Object, Object>[]> x0$7) {
                    Tuple2<Time, Tuple4<String, Object, Object, Object>[]> tuple2 = x0$7;
                    if (tuple2 != null) {
                        Time t = (Time)tuple2._1();
                        Tuple4[] b = (Tuple4[])tuple2._2();
                        this.$outer.logInfo((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final Time t$1;
                            private final Tuple4[] b$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Restoring KafkaRDD for time ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.t$1, Predef$.MODULE$.refArrayOps((Object[])this.b$1).mkString("[", ", ", "]")}));
                            }
                            {
                                this.t$1 = t$1;
                                this.b$1 = b$1;
                            }
                        });
                        scala.collection.mutable.Map map = (scala.collection.mutable.Map)this.$outer.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().generatedRDDs().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t), new KafkaRDD<K, V>(this.$outer.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().context().sparkContext(), this.$outer.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().executorKafkaParams(), (OffsetRange[])Predef$.MODULE$.refArrayOps((Object[])b).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final OffsetRange apply(Tuple4<String, Object, Object, Object> x$5) {
                                return OffsetRange$.MODULE$.apply(x$5);
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(OffsetRange.class))), this.$outer.org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer().getPreferredHosts(), false)));
                        return map;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }

        public /* synthetic */ DirectKafkaInputDStream org$apache$spark$streaming$kafka010$DirectKafkaInputDStream$DirectKafkaInputDStreamCheckpointData$$$outer() {
            return DirectKafkaInputDStream.this;
        }

        public DirectKafkaInputDStreamCheckpointData() {
            if (DirectKafkaInputDStream.this == null) {
                throw null;
            }
            super(DirectKafkaInputDStream.this, ClassTag$.MODULE$.apply(ConsumerRecord.class));
        }
    }
}

