/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.commons.collections.buffer.CircularFifoBuffer;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.streaming.SinkProgress;
import org.apache.spark.sql.streaming.SourceProgress;
import org.apache.spark.sql.streaming.StateOperatorProgress;
import org.apache.spark.sql.streaming.StreamingQueryProgress;
import org.apache.spark.ui.UIUtils$;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0001\t%d\u0001B\u0001\u0003\u00015\u0011\u0001d\u0015;sK\u0006l\u0017N\\4Rk\u0016\u0014\u0018p\u0015;bi&\u001cH/[2t\u0015\t\u0019A!A\u0005tiJ,\u0017-\\5oO*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\t\u0011U\u0001!\u0011!Q\u0001\nY\t1!]%e!\t9B$D\u0001\u0019\u0015\tI\"$\u0001\u0003vi&d'\"A\u000e\u0002\t)\fg/Y\u0005\u0003;a\u0011A!V+J\t\"Aq\u0004\u0001B\u0001B\u0003%\u0001%A\u0003r\u001d\u0006lW\r\u0005\u0002\"I9\u0011qBI\u0005\u0003GA\ta\u0001\u0015:fI\u00164\u0017BA\u0013'\u0005\u0019\u0019FO]5oO*\u00111\u0005\u0005\u0005\tQ\u0001\u0011\t\u0011)A\u0005-\u0005)!/\u001e8JI\"A!\u0006\u0001B\u0001B\u0003%1&A\u0005ti\u0006\u0014H\u000fV5nKB\u0011q\u0002L\u0005\u0003[A\u0011A\u0001T8oO\"Aq\u0006\u0001B\u0001B\u0003%1&A\bue&<w-\u001a:J]R,'O^1m\u0011\u0015\t\u0004\u0001\"\u00013\u0003\u0019a\u0014N\\5u}Q11'\u000e\u001c8qe\u0002\"\u0001\u000e\u0001\u000e\u0003\tAQ!\u0006\u0019A\u0002YAQa\b\u0019A\u0002\u0001BQ\u0001\u000b\u0019A\u0002YAQA\u000b\u0019A\u0002-BQa\f\u0019A\u0002-Bqa\u000f\u0001C\u0002\u0013%A(A\bN\u0003b{6+Q'Q\u0019\u0016{6+\u0013.F+\u0005i\u0004CA\b?\u0013\ty\u0004CA\u0002J]RDa!\u0011\u0001!\u0002\u0013i\u0014\u0001E'B1~\u001b\u0016)\u0014)M\u000b~\u001b\u0016JW#!\u0011\u001d\u0019\u0005A1A\u0005\n\u0011\u000b\u0001c]5na2,G)\u0019;f\r>\u0014X.\u0019;\u0016\u0003\u0015\u0003\"AR%\u000e\u0003\u001dS!\u0001\u0013\u000e\u0002\tQ,\u0007\u0010^\u0005\u0003\u0015\u001e\u0013\u0001cU5na2,G)\u0019;f\r>\u0014X.\u0019;\t\r1\u0003\u0001\u0015!\u0003F\u0003E\u0019\u0018.\u001c9mK\u0012\u000bG/\u001a$pe6\fG\u000f\t\u0005\b\u001d\u0002\u0011\r\u0011\"\u0003E\u0003=!\u0018.\\3ti\u0006l\u0007OR8s[\u0006$\bB\u0002)\u0001A\u0003%Q)\u0001\tuS6,7\u000f^1na\u001a{'/\\1uA!9!\u000b\u0001b\u0001\n\u0003\u0019\u0016!C9vKJLX+V%E+\u00051\u0002BB+\u0001A\u0003%a#\u0001\u0006rk\u0016\u0014\u00180V+J\t\u0002Bqa\u0016\u0001C\u0002\u0013\u0005\u0001,A\u0005rk\u0016\u0014\u0018PT1nKV\t\u0001\u0005\u0003\u0004[\u0001\u0001\u0006I\u0001I\u0001\u000bcV,'/\u001f(b[\u0016\u0004\u0003b\u0002/\u0001\u0005\u0004%\t!X\u0001\u000fcV,'/_*uCJ$H+[7f+\u0005Y\u0003BB0\u0001A\u0003%1&A\brk\u0016\u0014\u0018p\u0015;beR$\u0016.\\3!\u0011\u001d\t\u0007A1A\u0005\u0002a\u000b!#];fef\u001cF/\u0019:u)&lW\rV3yi\"11\r\u0001Q\u0001\n\u0001\n1#];fef\u001cF/\u0019:u)&lW\rV3yi\u0002Bq!\u001a\u0001A\u0002\u0013\u0005Q,A\u0006rk\u0016\u0014\u00180\u00169uS6,\u0007bB4\u0001\u0001\u0004%\t\u0001[\u0001\u0010cV,'/_+qi&lWm\u0018\u0013fcR\u0011\u0011\u000e\u001c\t\u0003\u001f)L!a\u001b\t\u0003\tUs\u0017\u000e\u001e\u0005\b[\u001a\f\t\u00111\u0001,\u0003\rAH%\r\u0005\u0007_\u0002\u0001\u000b\u0015B\u0016\u0002\u0019E,XM]=VaRLW.\u001a\u0011\t\u000fE\u0004\u0001\u0019!C\u00011\u0006y\u0011/^3ssV\u0003H/[7f)\u0016DH\u000fC\u0004t\u0001\u0001\u0007I\u0011\u0001;\u0002'E,XM]=VaRLW.\u001a+fqR|F%Z9\u0015\u0005%,\bbB7s\u0003\u0003\u0005\r\u0001\t\u0005\u0007o\u0002\u0001\u000b\u0015\u0002\u0011\u0002!E,XM]=VaRLW.\u001a+fqR\u0004\u0003bB=\u0001\u0001\u0004%\taU\u0001\beVtW+V%E\u0011\u001dY\b\u00011A\u0005\u0002q\f1B];o+VKEi\u0018\u0013fcR\u0011\u0011. \u0005\b[j\f\t\u00111\u0001\u0017\u0011\u0019y\b\u0001)Q\u0005-\u0005A!/\u001e8V+&#\u0005\u0005\u0003\u0005\u0002\u0004\u0001\u0011\r\u0011\"\u0001^\u0003M!(/\u001a8e\u000bZ,g\u000e^:J]R,'O^1m\u0011\u001d\t9\u0001\u0001Q\u0001\n-\nA\u0003\u001e:f]\u0012,e/\u001a8ug&sG/\u001a:wC2\u0004\u0003\"CA\u0006\u0001\u0001\u0007I\u0011AA\u0007\u0003!I7/Q2uSZ,WCAA\b!\ry\u0011\u0011C\u0005\u0004\u0003'\u0001\"a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003/\u0001\u0001\u0019!C\u0001\u00033\tA\"[:BGRLg/Z0%KF$2![A\u000e\u0011%i\u0017QCA\u0001\u0002\u0004\ty\u0001\u0003\u0005\u0002 \u0001\u0001\u000b\u0015BA\b\u0003%I7/Q2uSZ,\u0007\u0005\u0003\u0005\u0002$\u0001\u0001\r\u0011\"\u0001^\u00039\u0019WO\u001d:f]R\u0014\u0015\r^2i\u0013\u0012D\u0011\"a\n\u0001\u0001\u0004%\t!!\u000b\u0002%\r,(O]3oi\n\u000bGo\u00195JI~#S-\u001d\u000b\u0004S\u0006-\u0002\u0002C7\u0002&\u0005\u0005\t\u0019A\u0016\t\u000f\u0005=\u0002\u0001)Q\u0005W\u0005y1-\u001e:sK:$()\u0019;dQ&#\u0007\u0005C\u0005\u00024\u0001\u0001\r\u0011\"\u0001\u00026\u000591o\\;sG\u0016\u001cXCAA\u001c!\u0015y\u0011\u0011HA\u001f\u0013\r\tY\u0004\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004i\u0005}\u0012bAA!\u0005\tq1k\\;sG\u0016\u0004&o\\4sKN\u001c\b\"CA#\u0001\u0001\u0007I\u0011AA$\u0003-\u0019x.\u001e:dKN|F%Z9\u0015\u0007%\fI\u0005C\u0005n\u0003\u0007\n\t\u00111\u0001\u00028!A\u0011Q\n\u0001!B\u0013\t9$\u0001\u0005t_V\u00148-Z:!\u0011%\t\t\u0006\u0001a\u0001\n\u0003\t\u0019&\u0001\u0003tS:\\WCAA+!\r!\u0014qK\u0005\u0004\u00033\u0012!\u0001D*j].\u0004&o\\4sKN\u001c\b\"CA/\u0001\u0001\u0007I\u0011AA0\u0003!\u0019\u0018N\\6`I\u0015\fHcA5\u0002b!IQ.a\u0017\u0002\u0002\u0003\u0007\u0011Q\u000b\u0005\t\u0003K\u0002\u0001\u0015)\u0003\u0002V\u0005)1/\u001b8lA!A\u0011\u0011\u000e\u0001A\u0002\u0013\u0005Q,\u0001\bu_R\fG.\u00138qkR\u0014vn^:\t\u0013\u00055\u0004\u00011A\u0005\u0002\u0005=\u0014A\u0005;pi\u0006d\u0017J\u001c9viJ{wo]0%KF$2![A9\u0011!i\u00171NA\u0001\u0002\u0004Y\u0003bBA;\u0001\u0001\u0006KaK\u0001\u0010i>$\u0018\r\\%oaV$(k\\<tA!I\u0011\u0011\u0010\u0001A\u0002\u0013\u0005\u00111P\u0001\u0013CZ<\u0017J\u001c9viJ{wo\u001d)feN+7-\u0006\u0002\u0002~A\u0019q\"a \n\u0007\u0005\u0005\u0005C\u0001\u0004E_V\u0014G.\u001a\u0005\n\u0003\u000b\u0003\u0001\u0019!C\u0001\u0003\u000f\u000ba#\u0019<h\u0013:\u0004X\u000f\u001e*poN\u0004VM]*fG~#S-\u001d\u000b\u0004S\u0006%\u0005\"C7\u0002\u0004\u0006\u0005\t\u0019AA?\u0011!\ti\t\u0001Q!\n\u0005u\u0014aE1wO&s\u0007/\u001e;S_^\u001c\b+\u001a:TK\u000e\u0004\u0003\"CAI\u0001\u0001\u0007I\u0011AA>\u0003Y\tgo\u001a)s_\u000e,7o]3e%><8\u000fU3s'\u0016\u001c\u0007\"CAK\u0001\u0001\u0007I\u0011AAL\u0003i\tgo\u001a)s_\u000e,7o]3e%><8\u000fU3s'\u0016\u001cw\fJ3r)\rI\u0017\u0011\u0014\u0005\n[\u0006M\u0015\u0011!a\u0001\u0003{B\u0001\"!(\u0001A\u0003&\u0011QP\u0001\u0018CZ<\u0007K]8dKN\u001cX\r\u001a*poN\u0004VM]*fG\u0002B\u0001\"!)\u0001\u0001\u0004%\t!X\u0001\u0014i>$\u0018\r\u001c)s_\u000e,7o]5oORKW.\u001a\u0005\n\u0003K\u0003\u0001\u0019!C\u0001\u0003O\u000bq\u0003^8uC2\u0004&o\\2fgNLgn\u001a+j[\u0016|F%Z9\u0015\u0007%\fI\u000b\u0003\u0005n\u0003G\u000b\t\u00111\u0001,\u0011\u001d\ti\u000b\u0001Q!\n-\nA\u0003^8uC2\u0004&o\\2fgNLgn\u001a+j[\u0016\u0004\u0003\"CAY\u0001\u0001\u0007I\u0011AA>\u0003E\tgo\u001a)s_\u000e,7o]5oORKW.\u001a\u0005\n\u0003k\u0003\u0001\u0019!C\u0001\u0003o\u000bQ#\u0019<h!J|7-Z:tS:<G+[7f?\u0012*\u0017\u000fF\u0002j\u0003sC\u0011\"\\AZ\u0003\u0003\u0005\r!! \t\u0011\u0005u\u0006\u0001)Q\u0005\u0003{\n!#\u0019<h!J|7-Z:tS:<G+[7fA!A\u0011\u0011\u0019\u0001A\u0002\u0013\u0005Q,A\nok6\u0014\u0015\r^2iKN\u0004&o\\2fgN,G\rC\u0005\u0002F\u0002\u0001\r\u0011\"\u0001\u0002H\u00069b.^7CCR\u001c\u0007.Z:Qe>\u001cWm]:fI~#S-\u001d\u000b\u0004S\u0006%\u0007\u0002C7\u0002D\u0006\u0005\t\u0019A\u0016\t\u000f\u00055\u0007\u0001)Q\u0005W\u0005!b.^7CCR\u001c\u0007.Z:Qe>\u001cWm]:fI\u0002B\u0011\"!5\u0001\u0005\u0004%\t!a5\u0002\u0011QLW.\u001a'j]\u0016,\"!!6\u0011\t\u0005]\u0017Q]\u0007\u0003\u00033TA!a7\u0002^\u00061!-\u001e4gKJTA!a8\u0002b\u0006Y1m\u001c7mK\u000e$\u0018n\u001c8t\u0015\r\t\u0019\u000fC\u0001\bG>lWn\u001c8t\u0013\u0011\t9/!7\u0003%\rK'oY;mCJ4\u0015NZ8Ck\u001a4WM\u001d\u0005\t\u0003W\u0004\u0001\u0015!\u0003\u0002V\u0006IA/[7f\u0019&tW\r\t\u0005\n\u0003_\u0004!\u0019!C\u0001\u0003'\f\u0011C\\;n\u0013:\u0004X\u000f\u001e*poN$&/\u001a8e\u0011!\t\u0019\u0010\u0001Q\u0001\n\u0005U\u0017A\u00058v[&s\u0007/\u001e;S_^\u001cHK]3oI\u0002B\u0011\"a>\u0001\u0005\u0004%\t!a5\u0002/%t\u0007/\u001e;S_^\u001c\b+\u001a:TK\u000e|g\u000e\u001a+sK:$\u0007\u0002CA~\u0001\u0001\u0006I!!6\u00021%t\u0007/\u001e;S_^\u001c\b+\u001a:TK\u000e|g\u000e\u001a+sK:$\u0007\u0005C\u0005\u0002\u0000\u0002\u0011\r\u0011\"\u0001\u0002T\u0006Y\u0002O]8dKN\u001cX\r\u001a*poN\u0004VM]*fG>tG\r\u0016:f]\u0012D\u0001Ba\u0001\u0001A\u0003%\u0011Q[\u0001\u001daJ|7-Z:tK\u0012\u0014vn^:QKJ\u001cVmY8oIR\u0013XM\u001c3!\u0011%\u00119\u0001\u0001b\u0001\n\u0003\t\u0019.A\nqe>\u001cWm]:j]\u001e$\u0016.\\3Ue\u0016tG\r\u0003\u0005\u0003\f\u0001\u0001\u000b\u0011BAk\u0003Q\u0001(o\\2fgNLgn\u001a+j[\u0016$&/\u001a8eA!I!q\u0002\u0001C\u0002\u0013\u0005\u00111[\u0001\tE\u0006$8\r[%eg\"A!1\u0003\u0001!\u0002\u0013\t).A\u0005cCR\u001c\u0007.\u00133tA!A!q\u0003\u0001A\u0002\u0013\u0005Q,A\fdkJ\u00148\u000b^1uK>\u0003h*^7S_^\u001cHk\u001c;bY\"I!1\u0004\u0001A\u0002\u0013\u0005!QD\u0001\u001cGV\u0014(o\u0015;bi\u0016|\u0005OT;n%><8\u000fV8uC2|F%Z9\u0015\u0007%\u0014y\u0002\u0003\u0005n\u00053\t\t\u00111\u0001,\u0011\u001d\u0011\u0019\u0003\u0001Q!\n-\n\u0001dY;seN#\u0018\r^3Pa:+XNU8xgR{G/\u00197!\u0011!\u00119\u0003\u0001a\u0001\n\u0003i\u0016!G2veJ\u001cF/\u0019;f\u001fBtU/\u001c*poN,\u0006\u000fZ1uK\u0012D\u0011Ba\u000b\u0001\u0001\u0004%\tA!\f\u0002;\r,(O]*uCR,w\n\u001d(v[J{wo]+qI\u0006$X\rZ0%KF$2!\u001bB\u0018\u0011!i'\u0011FA\u0001\u0002\u0004Y\u0003b\u0002B\u001a\u0001\u0001\u0006KaK\u0001\u001bGV\u0014(o\u0015;bi\u0016|\u0005OT;n%><8/\u00169eCR,G\r\t\u0005\n\u0005o\u0001!\u0019!C\u0001\u0003'\f\u0001d\u001d;bi\u0016|\u0005OT;n%><8\u000fV8uC2$&/\u001a8e\u0011!\u0011Y\u0004\u0001Q\u0001\n\u0005U\u0017!G:uCR,w\n\u001d(v[J{wo\u001d+pi\u0006dGK]3oI\u0002B\u0011Ba\u0010\u0001\u0005\u0004%\t!a5\u00025M$\u0018\r^3Pa:+XNU8xgV\u0003H-\u0019;fIR\u0013XM\u001c3\t\u0011\t\r\u0003\u0001)A\u0005\u0003+\f1d\u001d;bi\u0016|\u0005OT;n%><8/\u00169eCR,G\r\u0016:f]\u0012\u0004\u0003b\u0002B$\u0001\u0011\u0005!\u0011J\u0001\u0016kB$\u0017\r^3Rk\u0016\u0014\u0018p\u0015;bi&\u001cH/[2t)\rI'1\n\u0005\t\u0005\u001b\u0012)\u00051\u0001\u0003P\u0005A\u0001O]8he\u0016\u001c8\u000fE\u00025\u0005#J1Aa\u0015\u0003\u0005Y\u0019FO]3b[&tw-U;fef\u0004&o\\4sKN\u001c\bb\u0002B,\u0001\u0011\u0005!\u0011L\u0001\u0014G\u0006d7-\u0011<h\u001f\u001a<\u0015N^3o)J,g\u000e\u001a\u000b\u0005\u0003{\u0012Y\u0006\u0003\u0005\u0003^\tU\u0003\u0019AAk\u0003\u0015!(/\u001a8e\u0011\u001d\u0011\t\u0007\u0001C\u0001\u0005G\n\u0011b]3u'R\fG/^:\u0015\u0007%\u0014)\u0007\u0003\u0005\u0003h\t}\u0003\u0019AA\b\u0003\u0019\u0019H/\u0019;vg\u0002")
public class StreamingQueryStatistics {
    private final int MAX_SAMPLE_SIZE = ((SparkSession)SparkSession$.MODULE$.getActiveSession().get()).sqlContext().conf().streamingUITrendsMaxSampleSize();
    private final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-YYYY hh:mm:ss");
    private final SimpleDateFormat timestampFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private final UUID queryUUID;
    private final String queryName;
    private final long queryStartTime;
    private final String queryStartTimeText;
    private long queryUptime;
    private String queryUptimeText;
    private UUID runUUID;
    private final long trendEventsInterval;
    private boolean isActive;
    private long currentBatchId;
    private SourceProgress[] sources;
    private SinkProgress sink;
    private long totalInputRows;
    private double avgInputRowsPerSec;
    private double avgProcessedRowsPerSec;
    private long totalProcessingTime;
    private double avgProcessingTime;
    private long numBatchesProcessed;
    private final CircularFifoBuffer timeLine;
    private final CircularFifoBuffer numInputRowsTrend;
    private final CircularFifoBuffer inputRowsPerSecondTrend;
    private final CircularFifoBuffer processedRowsPerSecondTrend;
    private final CircularFifoBuffer processingTimeTrend;
    private final CircularFifoBuffer batchIds;
    private long currStateOpNumRowsTotal;
    private long currStateOpNumRowsUpdated;
    private final CircularFifoBuffer stateOpNumRowsTotalTrend;
    private final CircularFifoBuffer stateOpNumRowsUpdatedTrend;

    private int MAX_SAMPLE_SIZE() {
        return this.MAX_SAMPLE_SIZE;
    }

    private SimpleDateFormat simpleDateFormat() {
        return this.simpleDateFormat;
    }

    private SimpleDateFormat timestampFormat() {
        return this.timestampFormat;
    }

    public UUID queryUUID() {
        return this.queryUUID;
    }

    public String queryName() {
        return this.queryName;
    }

    public long queryStartTime() {
        return this.queryStartTime;
    }

    public String queryStartTimeText() {
        return this.queryStartTimeText;
    }

    public long queryUptime() {
        return this.queryUptime;
    }

    public void queryUptime_$eq(long x$1) {
        this.queryUptime = x$1;
    }

    public String queryUptimeText() {
        return this.queryUptimeText;
    }

    public void queryUptimeText_$eq(String x$1) {
        this.queryUptimeText = x$1;
    }

    public UUID runUUID() {
        return this.runUUID;
    }

    public void runUUID_$eq(UUID x$1) {
        this.runUUID = x$1;
    }

    public long trendEventsInterval() {
        return this.trendEventsInterval;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void isActive_$eq(boolean x$1) {
        this.isActive = x$1;
    }

    public long currentBatchId() {
        return this.currentBatchId;
    }

    public void currentBatchId_$eq(long x$1) {
        this.currentBatchId = x$1;
    }

    public SourceProgress[] sources() {
        return this.sources;
    }

    public void sources_$eq(SourceProgress[] x$1) {
        this.sources = x$1;
    }

    public SinkProgress sink() {
        return this.sink;
    }

    public void sink_$eq(SinkProgress x$1) {
        this.sink = x$1;
    }

    public long totalInputRows() {
        return this.totalInputRows;
    }

    public void totalInputRows_$eq(long x$1) {
        this.totalInputRows = x$1;
    }

    public double avgInputRowsPerSec() {
        return this.avgInputRowsPerSec;
    }

    public void avgInputRowsPerSec_$eq(double x$1) {
        this.avgInputRowsPerSec = x$1;
    }

    public double avgProcessedRowsPerSec() {
        return this.avgProcessedRowsPerSec;
    }

    public void avgProcessedRowsPerSec_$eq(double x$1) {
        this.avgProcessedRowsPerSec = x$1;
    }

    public long totalProcessingTime() {
        return this.totalProcessingTime;
    }

    public void totalProcessingTime_$eq(long x$1) {
        this.totalProcessingTime = x$1;
    }

    public double avgProcessingTime() {
        return this.avgProcessingTime;
    }

    public void avgProcessingTime_$eq(double x$1) {
        this.avgProcessingTime = x$1;
    }

    public long numBatchesProcessed() {
        return this.numBatchesProcessed;
    }

    public void numBatchesProcessed_$eq(long x$1) {
        this.numBatchesProcessed = x$1;
    }

    public CircularFifoBuffer timeLine() {
        return this.timeLine;
    }

    public CircularFifoBuffer numInputRowsTrend() {
        return this.numInputRowsTrend;
    }

    public CircularFifoBuffer inputRowsPerSecondTrend() {
        return this.inputRowsPerSecondTrend;
    }

    public CircularFifoBuffer processedRowsPerSecondTrend() {
        return this.processedRowsPerSecondTrend;
    }

    public CircularFifoBuffer processingTimeTrend() {
        return this.processingTimeTrend;
    }

    public CircularFifoBuffer batchIds() {
        return this.batchIds;
    }

    public long currStateOpNumRowsTotal() {
        return this.currStateOpNumRowsTotal;
    }

    public void currStateOpNumRowsTotal_$eq(long x$1) {
        this.currStateOpNumRowsTotal = x$1;
    }

    public long currStateOpNumRowsUpdated() {
        return this.currStateOpNumRowsUpdated;
    }

    public void currStateOpNumRowsUpdated_$eq(long x$1) {
        this.currStateOpNumRowsUpdated = x$1;
    }

    public CircularFifoBuffer stateOpNumRowsTotalTrend() {
        return this.stateOpNumRowsTotalTrend;
    }

    public CircularFifoBuffer stateOpNumRowsUpdatedTrend() {
        return this.stateOpNumRowsUpdatedTrend;
    }

    public void updateQueryStatistics(StreamingQueryProgress progress) {
        if (this.currentBatchId() < progress.batchId()) {
            this.numBatchesProcessed_$eq(this.numBatchesProcessed() + 1L);
        }
        this.currentBatchId_$eq(progress.batchId());
        this.batchIds().add((Object)BoxesRunTime.boxToLong((long)progress.batchId()));
        Date currDateTime = this.timestampFormat().parse(progress.timestamp());
        this.queryUptime_$eq(currDateTime.getTime() - this.queryStartTime());
        this.queryUptimeText_$eq(UIUtils$.MODULE$.formatDurationVerbose(this.queryUptime()));
        this.timeLine().add((Object)BoxesRunTime.boxToLong((long)currDateTime.getTime()));
        long tmpNumInpRows = Predef$.MODULE$.float2Float((float)progress.numInputRows()).isNaN() ? 0L : progress.numInputRows();
        this.numInputRowsTrend().add((Object)BoxesRunTime.boxToLong((long)tmpNumInpRows));
        this.totalInputRows_$eq(this.totalInputRows() + tmpNumInpRows);
        double tmpInputRowsPerSec = Predef$.MODULE$.double2Double(progress.inputRowsPerSecond()).isNaN() ? 0.0 : progress.inputRowsPerSecond();
        this.inputRowsPerSecondTrend().add((Object)BoxesRunTime.boxToDouble((double)tmpInputRowsPerSec));
        this.avgInputRowsPerSec_$eq(this.calcAvgOfGivenTrend(this.inputRowsPerSecondTrend()));
        double tmpProcessedRowsPerSec = Predef$.MODULE$.double2Double(progress.processedRowsPerSecond()).isNaN() ? 0.0 : progress.processedRowsPerSecond();
        this.processedRowsPerSecondTrend().add((Object)BoxesRunTime.boxToDouble((double)tmpProcessedRowsPerSec));
        this.avgProcessedRowsPerSec_$eq(this.calcAvgOfGivenTrend(this.processedRowsPerSecondTrend()));
        Long tmpProcessingTime = progress.durationMs().get("triggerExecution");
        this.processingTimeTrend().add((Object)tmpProcessingTime);
        this.totalProcessingTime_$eq(this.totalProcessingTime() + Predef$.MODULE$.Long2long(tmpProcessingTime));
        this.avgProcessingTime_$eq(this.totalProcessingTime() / this.numBatchesProcessed());
        this.sources_$eq(progress.sources());
        this.sink_$eq(progress.sink());
        StateOperatorProgress[] stateOperators = progress.stateOperators();
        if (Predef$.MODULE$.refArrayOps((Object[])stateOperators).size() > 0) {
            LongRef sumAllSTNumRowsTotal = LongRef.create((long)0L);
            LongRef sumAllSTNumRowsUpdated = LongRef.create((long)0L);
            Predef$.MODULE$.refArrayOps((Object[])stateOperators).foreach((Function1)new Serializable(this, sumAllSTNumRowsTotal, sumAllSTNumRowsUpdated){
                public static final long serialVersionUID = 0L;
                private final LongRef sumAllSTNumRowsTotal$1;
                private final LongRef sumAllSTNumRowsUpdated$1;

                public final void apply(StateOperatorProgress so) {
                    this.sumAllSTNumRowsTotal$1.elem += so.numRowsTotal();
                    this.sumAllSTNumRowsUpdated$1.elem += so.numRowsUpdated();
                }
                {
                    this.sumAllSTNumRowsTotal$1 = sumAllSTNumRowsTotal$1;
                    this.sumAllSTNumRowsUpdated$1 = sumAllSTNumRowsUpdated$1;
                }
            });
            if (this.currStateOpNumRowsTotal() < sumAllSTNumRowsTotal.elem) {
                this.currStateOpNumRowsTotal_$eq(sumAllSTNumRowsTotal.elem);
            }
            this.stateOpNumRowsTotalTrend().add((Object)BoxesRunTime.boxToLong((long)sumAllSTNumRowsTotal.elem));
            if (this.currStateOpNumRowsUpdated() < sumAllSTNumRowsUpdated.elem) {
                this.currStateOpNumRowsUpdated_$eq(sumAllSTNumRowsUpdated.elem);
            }
            this.stateOpNumRowsUpdatedTrend().add((Object)BoxesRunTime.boxToLong((long)sumAllSTNumRowsUpdated.elem));
        }
    }

    public double calcAvgOfGivenTrend(CircularFifoBuffer trend) {
        Object[] arrValues = trend.toArray();
        DoubleRef sumOfElements = DoubleRef.create((double)0.0);
        Predef$.MODULE$.refArrayOps(arrValues).foreach((Function1)new Serializable(this, sumOfElements){
            public static final long serialVersionUID = 0L;
            private final DoubleRef sumOfElements$1;

            public final void apply(Object value) {
                this.sumOfElements$1.elem += BoxesRunTime.unboxToDouble((Object)value);
            }
            {
                this.sumOfElements$1 = sumOfElements$1;
            }
        });
        double avgValue = sumOfElements.elem / (double)Predef$.MODULE$.refArrayOps(arrValues).size();
        return avgValue;
    }

    public void setStatus(boolean status) {
        this.isActive_$eq(status);
    }

    public StreamingQueryStatistics(UUID qId, String qName, UUID runId, long startTime, long triggerInterval) {
        this.timestampFormat().setTimeZone(TimeZone.getTimeZone("UTC"));
        this.queryUUID = qId;
        this.queryName = qName;
        this.queryStartTime = startTime;
        this.queryStartTimeText = this.simpleDateFormat().format(BoxesRunTime.boxToLong((long)startTime));
        this.queryUptime = 0L;
        this.queryUptimeText = "";
        this.runUUID = runId;
        this.trendEventsInterval = triggerInterval;
        this.isActive = true;
        this.currentBatchId = -1L;
        this.sources = (SourceProgress[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(SourceProgress.class));
        this.sink = null;
        this.totalInputRows = 0L;
        this.avgInputRowsPerSec = 0.0;
        this.avgProcessedRowsPerSec = 0.0;
        this.totalProcessingTime = 0L;
        this.avgProcessingTime = 0.0;
        this.numBatchesProcessed = 0L;
        this.timeLine = new CircularFifoBuffer(this.MAX_SAMPLE_SIZE());
        this.numInputRowsTrend = new CircularFifoBuffer(this.MAX_SAMPLE_SIZE());
        this.inputRowsPerSecondTrend = new CircularFifoBuffer(this.MAX_SAMPLE_SIZE());
        this.processedRowsPerSecondTrend = new CircularFifoBuffer(this.MAX_SAMPLE_SIZE());
        this.processingTimeTrend = new CircularFifoBuffer(this.MAX_SAMPLE_SIZE());
        this.batchIds = new CircularFifoBuffer(this.MAX_SAMPLE_SIZE());
        this.currStateOpNumRowsTotal = 0L;
        this.currStateOpNumRowsUpdated = 0L;
        this.stateOpNumRowsTotalTrend = new CircularFifoBuffer(this.MAX_SAMPLE_SIZE());
        this.stateOpNumRowsUpdatedTrend = new CircularFifoBuffer(this.MAX_SAMPLE_SIZE());
    }
}

