/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.LiveListenerBus;
import org.apache.spark.scheduler.LiveListenerBus$;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.sql.streaming.StreamingQueryListener;
import org.apache.spark.util.ListenerBus;
import org.slf4j.Logger;
import scala.Function0;
import scala.collection.Seq;
import scala.collection.mutable.HashSet;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r4A!\u0001\u0002\u0001\u001f\tI2\u000b\u001e:fC6LgnZ)vKJLH*[:uK:,'OQ;t\u0015\t\u0019A!A\u0005tiJ,\u0017-\\5oO*\u0011QAB\u0001\nKb,7-\u001e;j_:T!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\t\u0017!\t\tB#D\u0001\u0013\u0015\t\u0019\u0002\"A\u0005tG\",G-\u001e7fe&\u0011QC\u0005\u0002\u000e'B\f'o\u001b'jgR,g.\u001a:\u0011\t]QB$I\u0007\u00021)\u0011\u0011\u0004C\u0001\u0005kRLG.\u0003\u0002\u001c1\tYA*[:uK:,'OQ;t!\tir$D\u0001\u001f\u0015\t\u0019a!\u0003\u0002!=\t12\u000b\u001e:fC6LgnZ)vKJLH*[:uK:,'\u000f\u0005\u0002#K9\u0011QdI\u0005\u0003Iy\tac\u0015;sK\u0006l\u0017N\\4Rk\u0016\u0014\u0018\u0010T5ti\u0016tWM]\u0005\u0003M\u001d\u0012Q!\u0012<f]RT!\u0001\n\u0010\t\u0011%\u0002!\u0011!Q\u0001\n)\n\u0001c\u001d9be.d\u0015n\u001d;f]\u0016\u0014()^:\u0011\u0005EY\u0013B\u0001\u0017\u0013\u0005=a\u0015N^3MSN$XM\\3s\u0005V\u001c\b\"\u0002\u0018\u0001\t\u0003y\u0013A\u0002\u001fj]&$h\b\u0006\u00021eA\u0011\u0011\u0007A\u0007\u0002\u0005!)\u0011&\fa\u0001U!9A\u0007\u0001b\u0001\n\u0013)\u0014!E1di&4X-U;fef\u0014VO\\%egV\ta\u0007E\u00028}\u0001k\u0011\u0001\u000f\u0006\u0003si\nq!\\;uC\ndWM\u0003\u0002<y\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003u\nQa]2bY\u0006L!a\u0010\u001d\u0003\u000f!\u000b7\u000f[*fiB\u0011\u0011)R\u0007\u0002\u0005*\u0011\u0011d\u0011\u0006\u0002\t\u0006!!.\u0019<b\u0013\t1%I\u0001\u0003V+&#\u0005B\u0002%\u0001A\u0003%a'\u0001\nbGRLg/Z)vKJL(+\u001e8JIN\u0004\u0003\"\u0002&\u0001\t\u0003Y\u0015\u0001\u00029pgR$\"\u0001\u0014)\u0011\u00055sU\"\u0001\u001f\n\u0005=c$\u0001B+oSRDQ!U%A\u0002\u0005\nQ!\u001a<f]RDQa\u0015\u0001\u0005BQ\u000b\u0011\u0002]8tiR{\u0017\t\u001c7\u0015\u00051+\u0006\"B)S\u0001\u0004\t\u0003\"B,\u0001\t\u0003B\u0016\u0001D8o\u001fRDWM]#wK:$HC\u0001'Z\u0011\u0015\tf\u000b1\u0001[!\t\t2,\u0003\u0002]%\t\u00112\u000b]1sW2K7\u000f^3oKJ,e/\u001a8u\u0011\u0015q\u0006\u0001\"\u0015`\u0003-!w\u000eU8ti\u00163XM\u001c;\u0015\u00071\u0003'\rC\u0003b;\u0002\u0007A$\u0001\u0005mSN$XM\\3s\u0011\u0015\tV\f1\u0001\"\u0001")
public class StreamingQueryListenerBus
extends SparkListener
implements ListenerBus<StreamingQueryListener, StreamingQueryListener.Event> {
    private final LiveListenerBus sparkListenerBus;
    private final HashSet<UUID> activeQueryRunIds;
    private final CopyOnWriteArrayList<Object> listeners;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public CopyOnWriteArrayList<StreamingQueryListener> listeners() {
        return this.listeners;
    }

    public void org$apache$spark$util$ListenerBus$_setter_$listeners_$eq(CopyOnWriteArrayList x$1) {
        this.listeners = x$1;
    }

    public final void addListener(Object listener) {
        ListenerBus.class.addListener((ListenerBus)this, (Object)listener);
    }

    public final void removeListener(Object listener) {
        ListenerBus.class.removeListener((ListenerBus)this, (Object)listener);
    }

    public <T extends StreamingQueryListener> Seq<T> findListenersByClass(ClassTag<T> evidence$1) {
        return ListenerBus.class.findListenersByClass((ListenerBus)this, evidence$1);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    private HashSet<UUID> activeQueryRunIds() {
        return this.activeQueryRunIds;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void post(StreamingQueryListener.Event event) {
        StreamingQueryListener.Event event2 = event;
        if (!(event2 instanceof StreamingQueryListener.QueryStartedEvent)) {
            this.sparkListenerBus.post((SparkListenerEvent)event);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        StreamingQueryListener.QueryStartedEvent queryStartedEvent = (StreamingQueryListener.QueryStartedEvent)event2;
        HashSet<UUID> hashSet = this.activeQueryRunIds();
        synchronized (hashSet) {
            this.activeQueryRunIds().$plus$eq((Object)queryStartedEvent.runId());
        }
        this.sparkListenerBus.post((SparkListenerEvent)queryStartedEvent);
        this.postToAll(queryStartedEvent);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void postToAll(StreamingQueryListener.Event event) {
        ListenerBus.class.postToAll((ListenerBus)this, (Object)event);
        StreamingQueryListener.Event event2 = event;
        if (!(event2 instanceof StreamingQueryListener.QueryTerminatedEvent)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        StreamingQueryListener.QueryTerminatedEvent queryTerminatedEvent = (StreamingQueryListener.QueryTerminatedEvent)event2;
        HashSet<UUID> hashSet = this.activeQueryRunIds();
        synchronized (hashSet) {
            this.activeQueryRunIds().$minus$eq((Object)queryTerminatedEvent.runId());
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl12 : MonitorExitStatement: MONITOREXIT : hashSet
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
    }

    public void onOtherEvent(SparkListenerEvent event) {
        SparkListenerEvent sparkListenerEvent = event;
        if (sparkListenerEvent instanceof StreamingQueryListener.Event) {
            BoxedUnit boxedUnit;
            StreamingQueryListener.Event event2 = (StreamingQueryListener.Event)sparkListenerEvent;
            if (BoxesRunTime.unboxToBoolean((Object)LiveListenerBus$.MODULE$.withinListenerThread().value()) && event2 instanceof StreamingQueryListener.QueryStartedEvent) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.postToAll(event2);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void doPostEvent(StreamingQueryListener listener, StreamingQueryListener.Event event) {
        StreamingQueryListener.Event event2 = event;
        if (event2 instanceof StreamingQueryListener.QueryStartedEvent) {
            BoxedUnit boxedUnit;
            StreamingQueryListener.QueryStartedEvent queryStartedEvent = (StreamingQueryListener.QueryStartedEvent)event2;
            if (this.shouldReport$1(queryStartedEvent.runId())) {
                listener.onQueryStarted(queryStartedEvent);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (event2 instanceof StreamingQueryListener.QueryProgressEvent) {
            BoxedUnit boxedUnit;
            StreamingQueryListener.QueryProgressEvent queryProgressEvent = (StreamingQueryListener.QueryProgressEvent)event2;
            if (this.shouldReport$1(queryProgressEvent.progress().runId())) {
                listener.onQueryProgress(queryProgressEvent);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        } else if (event2 instanceof StreamingQueryListener.QueryTerminatedEvent) {
            BoxedUnit boxedUnit;
            StreamingQueryListener.QueryTerminatedEvent queryTerminatedEvent = (StreamingQueryListener.QueryTerminatedEvent)event2;
            if (this.shouldReport$1(queryTerminatedEvent.runId())) {
                listener.onQueryTerminated(queryTerminatedEvent);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit4 = boxedUnit;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private final boolean shouldReport$1(UUID runId) {
        HashSet<UUID> hashSet = this.activeQueryRunIds();
        synchronized (hashSet) {
            Boolean bl = BoxesRunTime.boxToBoolean((boolean)this.activeQueryRunIds().contains((Object)runId));
            return BoxesRunTime.unboxToBoolean((Object)bl);
        }
    }

    public StreamingQueryListenerBus(LiveListenerBus sparkListenerBus) {
        this.sparkListenerBus = sparkListenerBus;
        Logging.class.$init$((Logging)this);
        ListenerBus.class.$init$((ListenerBus)this);
        sparkListenerBus.addListener((Object)this);
        this.activeQueryRunIds = new HashSet();
    }
}

