/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.cache.Weigher;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.execution.datasources.FileStatusCache;
import org.apache.spark.sql.execution.datasources.SharedInMemoryCache$;
import org.apache.spark.util.SizeEstimator$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001%4A!\u0001\u0002\u0005\u001f\t\u00192\u000b[1sK\u0012Le.T3n_JL8)Y2iK*\u00111\u0001B\u0001\fI\u0006$\u0018m]8ve\u000e,7O\u0003\u0002\u0006\r\u0005IQ\r_3dkRLwN\u001c\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0004\u0001A1\u0002CA\t\u0015\u001b\u0005\u0011\"\"A\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0011\"AB!osJ+g\r\u0005\u0002\u001855\t\u0001D\u0003\u0002\u001a\u0011\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002\u001c1\t9Aj\\4hS:<\u0007\u0002C\u000f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0010\u0002\u001d5\f\u0007pU5{K&s')\u001f;fgB\u0011\u0011cH\u0005\u0003AI\u0011A\u0001T8oO\")!\u0005\u0001C\u0001G\u00051A(\u001b8jiz\"\"\u0001\n\u0014\u0011\u0005\u0015\u0002Q\"\u0001\u0002\t\u000bu\t\u0003\u0019\u0001\u0010\u0006\t!\u0002A!\u000b\u0002\t\u00072LWM\u001c;JIB\u0011!fL\u0007\u0002W)\u0011A&L\u0001\u0005Y\u0006twMC\u0001/\u0003\u0011Q\u0017M^1\n\u0005AZ#AB(cU\u0016\u001cG\u000fC\u00043\u0001\t\u0007I\u0011B\u001a\u0002']\f'O\\3e\u0003\n|W\u000f^#wS\u000e$\u0018n\u001c8\u0016\u0003Q\u0002\"!\u000e\u001f\u000e\u0003YR!a\u000e\u001d\u0002\r\u0005$x.\\5d\u0015\tI$(\u0001\u0006d_:\u001cWO\u001d:f]RT!aO\u0017\u0002\tU$\u0018\u000e\\\u0005\u0003{Y\u0012Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0007BB \u0001A\u0003%A'\u0001\u000bxCJtW\rZ!c_V$XI^5di&|g\u000e\t\u0005\b\u0003\u0002\u0011\r\u0011\"\u0003C\u0003\u0015\u0019\u0017m\u00195f+\u0005\u0019\u0005\u0003\u0002#M\u001dnk\u0011!\u0012\u0006\u0003\u0003\u001aS!a\u0012%\u0002\r\r|W.\\8o\u0015\tI%*\u0001\u0004h_><G.\u001a\u0006\u0002\u0017\u0006\u00191m\\7\n\u00055+%!B\"bG\",\u0007\u0003B\tP#NK!\u0001\u0015\n\u0003\rQ+\b\u000f\\33!\t\u0011v%D\u0001\u0001!\t!\u0016,D\u0001V\u0015\t1v+\u0001\u0002gg*\u0011\u0001LC\u0001\u0007Q\u0006$wn\u001c9\n\u0005i+&\u0001\u0002)bi\"\u00042!\u0005/_\u0013\ti&CA\u0003BeJ\f\u0017\u0010\u0005\u0002U?&\u0011\u0001-\u0016\u0002\u000b\r&dWm\u0015;biV\u001c\bB\u00022\u0001A\u0003%1)\u0001\u0004dC\u000eDW\r\t\u0005\u0006I\u0002!\t!Z\u0001\u0013GJ,\u0017\r^3G_JtUm^\"mS\u0016tG\u000fF\u0001g!\t)s-\u0003\u0002i\u0005\tya)\u001b7f'R\fG/^:DC\u000eDW\r")
public class SharedInMemoryCache
implements Logging {
    public final long org$apache$spark$sql$execution$datasources$SharedInMemoryCache$$maxSizeInBytes;
    private final AtomicBoolean org$apache$spark$sql$execution$datasources$SharedInMemoryCache$$warnedAboutEviction;
    private final Cache<Tuple2<Object, Path>, FileStatus[]> org$apache$spark$sql$execution$datasources$SharedInMemoryCache$$cache;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public AtomicBoolean org$apache$spark$sql$execution$datasources$SharedInMemoryCache$$warnedAboutEviction() {
        return this.org$apache$spark$sql$execution$datasources$SharedInMemoryCache$$warnedAboutEviction;
    }

    public Cache<Tuple2<Object, Path>, FileStatus[]> org$apache$spark$sql$execution$datasources$SharedInMemoryCache$$cache() {
        return this.org$apache$spark$sql$execution$datasources$SharedInMemoryCache$$cache;
    }

    public FileStatusCache createForNewClient() {
        return new FileStatusCache(this){
            private final Object org$apache$spark$sql$execution$datasources$SharedInMemoryCache$$anon$$clientId;
            private final /* synthetic */ SharedInMemoryCache $outer;

            public Object org$apache$spark$sql$execution$datasources$SharedInMemoryCache$$anon$$clientId() {
                return this.org$apache$spark$sql$execution$datasources$SharedInMemoryCache$$anon$$clientId;
            }

            public Option<FileStatus[]> getLeafFiles(Path path) {
                return Option$.MODULE$.apply(this.$outer.org$apache$spark$sql$execution$datasources$SharedInMemoryCache$$cache().getIfPresent((Object)new Tuple2(this.org$apache$spark$sql$execution$datasources$SharedInMemoryCache$$anon$$clientId(), (Object)path)));
            }

            public void putLeafFiles(Path path, FileStatus[] leafFiles) {
                this.$outer.org$apache$spark$sql$execution$datasources$SharedInMemoryCache$$cache().put((Object)new Tuple2(this.org$apache$spark$sql$execution$datasources$SharedInMemoryCache$$anon$$clientId(), (Object)path), (Object)leafFiles);
            }

            public void invalidateAll() {
                ((IterableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.$outer.org$apache$spark$sql$execution$datasources$SharedInMemoryCache$$cache().asMap()).asScala()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$3 $outer;

                    public final void apply(Tuple2<Tuple2<Object, Path>, FileStatus[]> x0$1) {
                        Tuple2<Tuple2<Object, Path>, FileStatus[]> tuple2 = x0$1;
                        if (tuple2 != null) {
                            BoxedUnit boxedUnit;
                            Tuple2 key = (Tuple2)tuple2._1();
                            if (BoxesRunTime.equals((Object)key._1(), (Object)this.$outer.org$apache$spark$sql$execution$datasources$SharedInMemoryCache$$anon$$clientId())) {
                                this.$outer.org$apache$spark$sql$execution$datasources$SharedInMemoryCache$$anon$$$outer().org$apache$spark$sql$execution$datasources$SharedInMemoryCache$$cache().invalidate((Object)key);
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit2 = boxedUnit;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ SharedInMemoryCache org$apache$spark$sql$execution$datasources$SharedInMemoryCache$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.org$apache$spark$sql$execution$datasources$SharedInMemoryCache$$anon$$clientId = new Object();
            }
        };
    }

    public SharedInMemoryCache(long maxSizeInBytes) {
        this.org$apache$spark$sql$execution$datasources$SharedInMemoryCache$$maxSizeInBytes = maxSizeInBytes;
        Logging.class.$init$((Logging)this);
        this.org$apache$spark$sql$execution$datasources$SharedInMemoryCache$$warnedAboutEviction = new AtomicBoolean(false);
        int weightScale = 32;
        Weigher<Tuple2<Object, Path>, FileStatus[]> weigher = new Weigher<Tuple2<Object, Path>, FileStatus[]>(this, weightScale){
            private final /* synthetic */ SharedInMemoryCache $outer;
            public final int weightScale$1;

            public int weigh(Tuple2<Object, Path> key, FileStatus[] value) {
                int n;
                long estimate = (SizeEstimator$.MODULE$.estimate(key) + SizeEstimator$.MODULE$.estimate((Object)value)) / (long)this.weightScale$1;
                if (estimate > Integer.MAX_VALUE) {
                    this.$outer.logWarning((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anon$1 $outer;

                        public final String apply() {
                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cached table partition metadata size is too big. Approximating to "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)((long)Integer.MAX_VALUE * (long)this.$outer.weightScale$1))}))).toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    n = Integer.MAX_VALUE;
                } else {
                    n = (int)estimate;
                }
                return n;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.weightScale$1 = weightScale$1;
            }
        };
        RemovalListener<Tuple2<Object, Path>, FileStatus[]> removalListener = new RemovalListener<Tuple2<Object, Path>, FileStatus[]>(this){
            private final /* synthetic */ SharedInMemoryCache $outer;

            public void onRemoval(RemovalNotification<Tuple2<Object, Path>, FileStatus[]> removed) {
                RemovalCause removalCause = removed.getCause();
                RemovalCause removalCause2 = RemovalCause.SIZE;
                if (!(removalCause != null ? !removalCause.equals(removalCause2) : removalCause2 != null) && this.$outer.org$apache$spark$sql$execution$datasources$SharedInMemoryCache$$warnedAboutEviction().compareAndSet(false, true)) {
                    this.$outer.logWarning((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anon$2 $outer;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Evicting cached table partition metadata from memory due to size constraints (spark.sql.hive.filesourcePartitionFileCacheSize = ").append((Object)BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$sql$execution$datasources$SharedInMemoryCache$$anon$$$outer().org$apache$spark$sql$execution$datasources$SharedInMemoryCache$$maxSizeInBytes)).append((Object)" bytes). This may impact query planning performance.").toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
            }

            public /* synthetic */ SharedInMemoryCache org$apache$spark$sql$execution$datasources$SharedInMemoryCache$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.org$apache$spark$sql$execution$datasources$SharedInMemoryCache$$cache = CacheBuilder.newBuilder().weigher((Weigher)weigher).removalListener((RemovalListener)removalListener).maximumWeight(maxSizeInBytes / (long)weightScale).build();
    }
}

