/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.ReflectionUtils;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.Some;

public final class CodecStreams$ {
    public static final CodecStreams$ MODULE$;

    static {
        new CodecStreams$();
    }

    private Option<CompressionCodec> getDecompressionCodec(Configuration config2, Path file) {
        CompressionCodecFactory compressionCodecs = new CompressionCodecFactory(config2);
        return Option$.MODULE$.apply((Object)compressionCodecs.getCodec(file));
    }

    public InputStream createInputStream(Configuration config2, Path file) {
        FileSystem fs = file.getFileSystem(config2);
        FSDataInputStream inputStream = fs.open(file);
        return (InputStream)this.getDecompressionCodec(config2, file).map((Function1)new Serializable((InputStream)inputStream){
            public static final long serialVersionUID = 0L;
            private final InputStream inputStream$1;

            public final CompressionInputStream apply(CompressionCodec codec) {
                return codec.createInputStream(this.inputStream$1);
            }
            {
                this.inputStream$1 = inputStream$1;
            }
        }).getOrElse((Function0)new Serializable((InputStream)inputStream){
            public static final long serialVersionUID = 0L;
            private final InputStream inputStream$1;

            public final InputStream apply() {
                return this.inputStream$1;
            }
            {
                this.inputStream$1 = inputStream$1;
            }
        });
    }

    private Option<CompressionCodec> getCompressionCodec(JobContext context, Option<Path> file) {
        Some some;
        if (FileOutputFormat.getCompressOutput((JobContext)context)) {
            Class compressorClass = FileOutputFormat.getOutputCompressorClass((JobContext)context, GzipCodec.class);
            some = new Some(ReflectionUtils.newInstance((Class)compressorClass, (Configuration)context.getConfiguration()));
        } else {
            some = file.flatMap((Function1)new Serializable(context){
                public static final long serialVersionUID = 0L;
                private final JobContext context$1;

                public final Option<CompressionCodec> apply(Path path) {
                    CompressionCodecFactory compressionCodecs = new CompressionCodecFactory(this.context$1.getConfiguration());
                    return Option$.MODULE$.apply((Object)compressionCodecs.getCodec(path));
                }
                {
                    this.context$1 = context$1;
                }
            });
        }
        return some;
    }

    private Option<Path> getCompressionCodec$default$2() {
        return None$.MODULE$;
    }

    public OutputStream createOutputStream(JobContext context, Path file) {
        FileSystem fs = file.getFileSystem(context.getConfiguration());
        FSDataOutputStream outputStream = fs.create(file, false);
        return (OutputStream)this.getCompressionCodec(context, (Option<Path>)new Some((Object)file)).map((Function1)new Serializable((OutputStream)outputStream){
            public static final long serialVersionUID = 0L;
            private final OutputStream outputStream$1;

            public final CompressionOutputStream apply(CompressionCodec codec) {
                return codec.createOutputStream(this.outputStream$1);
            }
            {
                this.outputStream$1 = outputStream$1;
            }
        }).getOrElse((Function0)new Serializable((OutputStream)outputStream){
            public static final long serialVersionUID = 0L;
            private final OutputStream outputStream$1;

            public final OutputStream apply() {
                return this.outputStream$1;
            }
            {
                this.outputStream$1 = outputStream$1;
            }
        });
    }

    public OutputStreamWriter createOutputStreamWriter(JobContext context, Path file, Charset charset) {
        return new OutputStreamWriter(this.createOutputStream(context, file), charset);
    }

    public Charset createOutputStreamWriter$default$3() {
        return StandardCharsets.UTF_8;
    }

    public String getCompressionExtension(JobContext context) {
        return (String)this.getCompressionCodec(context, this.getCompressionCodec$default$2()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(CompressionCodec x$1) {
                return x$1.getDefaultExtension();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
    }

    private CodecStreams$() {
        MODULE$ = this;
    }
}

