/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import java.util.Properties;
import org.apache.spark.Partition;
import org.apache.spark.annotation.InterfaceStability;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.DataFrameReader$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JacksonParser;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.LogicalRDD;
import org.apache.spark.sql.execution.LogicalRDD$;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCPartition;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRelation;
import org.apache.spark.sql.execution.datasources.json.InferSchema$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@InterfaceStability.Stable
@ScalaSignature(bytes="\u0006\u0001\tEc\u0001B\u0001\u0003\u0001-\u0011q\u0002R1uC\u001a\u0013\u0018-\\3SK\u0006$WM\u001d\u0006\u0003\u0007\u0011\t1a]9m\u0015\t)a!A\u0003ta\u0006\u00148N\u0003\u0002\b\u0011\u00051\u0011\r]1dQ\u0016T\u0011!C\u0001\u0004_J<7\u0001A\n\u0004\u00011\u0011\u0002CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\t\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002\u0018)\t9Aj\\4hS:<\u0007\u0002C\r\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000e\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005maR\"\u0001\u0002\n\u0005u\u0011!\u0001D*qCJ\\7+Z:tS>t\u0007BB\u0010\u0001\t\u0003\u0011\u0001%\u0001\u0004=S:LGO\u0010\u000b\u0003C\t\u0002\"a\u0007\u0001\t\u000beq\u0002\u0019\u0001\u000e\t\u000b\u0011\u0002A\u0011A\u0013\u0002\r\u0019|'/\\1u)\t\tc\u0005C\u0003(G\u0001\u0007\u0001&\u0001\u0004t_V\u00148-\u001a\t\u0003S1r!!\u0004\u0016\n\u0005-r\u0011A\u0002)sK\u0012,g-\u0003\u0002.]\t11\u000b\u001e:j]\u001eT!a\u000b\b\t\u000bA\u0002A\u0011A\u0019\u0002\rM\u001c\u0007.Z7b)\t\t#\u0007C\u00031_\u0001\u00071\u0007\u0005\u00025o5\tQG\u0003\u00027\u0005\u0005)A/\u001f9fg&\u0011\u0001(\u000e\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007\"\u0002\u001e\u0001\t\u0003Y\u0014AB8qi&|g\u000eF\u0002\"yyBQ!P\u001dA\u0002!\n1a[3z\u0011\u0015y\u0014\b1\u0001)\u0003\u00151\u0018\r\\;f\u0011\u0015Q\u0004\u0001\"\u0001B)\r\t#i\u0011\u0005\u0006{\u0001\u0003\r\u0001\u000b\u0005\u0006\u007f\u0001\u0003\r\u0001\u0012\t\u0003\u001b\u0015K!A\u0012\b\u0003\u000f\t{w\u000e\\3b]\")!\b\u0001C\u0001\u0011R\u0019\u0011%\u0013&\t\u000bu:\u0005\u0019\u0001\u0015\t\u000b}:\u0005\u0019A&\u0011\u00055a\u0015BA'\u000f\u0005\u0011auN\\4\t\u000bi\u0002A\u0011A(\u0015\u0007\u0005\u0002\u0016\u000bC\u0003>\u001d\u0002\u0007\u0001\u0006C\u0003@\u001d\u0002\u0007!\u000b\u0005\u0002\u000e'&\u0011AK\u0004\u0002\u0007\t>,(\r\\3\t\u000bY\u0003A\u0011A,\u0002\u000f=\u0004H/[8ogR\u0011\u0011\u0005\u0017\u0005\u0006-V\u0003\r!\u0017\t\u00055vC\u0003&D\u0001\\\u0015\taf\"\u0001\u0006d_2dWm\u0019;j_:L!AX.\u0003\u00075\u000b\u0007\u000fC\u0003W\u0001\u0011\u0005\u0001\r\u0006\u0002\"C\")ak\u0018a\u0001EB!1\r\u001b\u0015)\u001b\u0005!'BA3g\u0003\u0011)H/\u001b7\u000b\u0003\u001d\fAA[1wC&\u0011a\f\u001a\u0005\u0006U\u0002!\ta[\u0001\u0005Y>\fG\rF\u0001m!\ti\u0007O\u0004\u0002\u001c]&\u0011qNA\u0001\ba\u0006\u001c7.Y4f\u0013\t\t(OA\u0005ECR\fgI]1nK*\u0011qN\u0001\u0005\u0006U\u0002!\t\u0001\u001e\u000b\u0003YVDQA^:A\u0002!\nA\u0001]1uQ\")!\u000e\u0001C\u0001qR\u0011A.\u001f\u0005\u0006u^\u0004\ra_\u0001\u0006a\u0006$\bn\u001d\t\u0004\u001bqD\u0013BA?\u000f\u0005)a$/\u001a9fCR,GM\u0010\u0015\u0003o~\u0004B!!\u0001\u0002\b5\u0011\u00111\u0001\u0006\u0004\u0003\u000bq\u0011AC1o]>$\u0018\r^5p]&!\u0011\u0011BA\u0002\u0005\u001d1\u0018M]1sONDq!!\u0004\u0001\t\u0003\ty!\u0001\u0003kI\n\u001cGc\u00027\u0002\u0012\u0005U\u0011\u0011\u0004\u0005\b\u0003'\tY\u00011\u0001)\u0003\r)(\u000f\u001c\u0005\b\u0003/\tY\u00011\u0001)\u0003\u0015!\u0018M\u00197f\u0011!\tY\"a\u0003A\u0002\u0005u\u0011A\u00039s_B,'\u000f^5fgB\u00191-a\b\n\u0007\u0005\u0005BM\u0001\u0006Qe>\u0004XM\u001d;jKNDq!!\u0004\u0001\t\u0003\t)\u0003F\bm\u0003O\tI#a\u000b\u00020\u0005M\u0012qGA!\u0011\u001d\t\u0019\"a\tA\u0002!Bq!a\u0006\u0002$\u0001\u0007\u0001\u0006C\u0004\u0002.\u0005\r\u0002\u0019\u0001\u0015\u0002\u0015\r|G.^7o\u001d\u0006lW\rC\u0004\u00022\u0005\r\u0002\u0019A&\u0002\u00151|w/\u001a:C_VtG\rC\u0004\u00026\u0005\r\u0002\u0019A&\u0002\u0015U\u0004\b/\u001a:C_VtG\r\u0003\u0005\u0002:\u0005\r\u0002\u0019AA\u001e\u00035qW/\u001c)beRLG/[8ogB\u0019Q\"!\u0010\n\u0007\u0005}bBA\u0002J]RD\u0001\"a\u0011\u0002$\u0001\u0007\u0011QD\u0001\u0015G>tg.Z2uS>t\u0007K]8qKJ$\u0018.Z:\t\u000f\u00055\u0001\u0001\"\u0001\u0002HQIA.!\u0013\u0002L\u00055\u0013q\u000b\u0005\b\u0003'\t)\u00051\u0001)\u0011\u001d\t9\"!\u0012A\u0002!B\u0001\"a\u0014\u0002F\u0001\u0007\u0011\u0011K\u0001\u000baJ,G-[2bi\u0016\u001c\b\u0003B\u0007\u0002T!J1!!\u0016\u000f\u0005\u0015\t%O]1z\u0011!\t\u0019%!\u0012A\u0002\u0005u\u0001bBA.\u0001\u0011\u0005\u0011QL\u0001\u0005UN|g\u000eF\u0002m\u0003?BaA^A-\u0001\u0004A\u0003bBA.\u0001\u0011\u0005\u00111\r\u000b\u0004Y\u0006\u0015\u0004B\u0002>\u0002b\u0001\u00071\u0010K\u0002\u0002b}Dq!a\u0017\u0001\t\u0003\tY\u0007F\u0002m\u0003[B\u0001\"a\u001c\u0002j\u0001\u0007\u0011\u0011O\u0001\bUN|gN\u0015#E!\u0015\t\u0019(a\u001f)\u001b\t\t)HC\u0002h\u0003oR1!!\u001f\u0005\u0003\r\t\u0007/[\u0005\u0005\u0003{\n)HA\u0004KCZ\f'\u000b\u0012#\t\u000f\u0005m\u0003\u0001\"\u0001\u0002\u0002R\u0019A.a!\t\u0011\u0005=\u0014q\u0010a\u0001\u0003\u000b\u0003R!a\"\u0002\u000e\"j!!!#\u000b\u0007\u0005-E!A\u0002sI\u0012LA!a$\u0002\n\n\u0019!\u000b\u0012#\t\u000f\u0005M\u0005\u0001\"\u0001\u0002\u0016\u0006\u00191m\u001d<\u0015\u00071\f9\n\u0003\u0004w\u0003#\u0003\r\u0001\u000b\u0005\b\u0003'\u0003A\u0011AAN)\ra\u0017Q\u0014\u0005\u0007u\u0006e\u0005\u0019A>)\u0007\u0005eu\u0010C\u0004\u0002$\u0002!\t!!*\u0002\u000fA\f'/];fiR\u0019A.a*\t\rY\f\t\u000b1\u0001)\u0011\u001d\t\u0019\u000b\u0001C\u0001\u0003W#2\u0001\\AW\u0011\u0019Q\u0018\u0011\u0016a\u0001w\"\u001a\u0011\u0011V@\t\u000f\u0005M\u0006\u0001\"\u0001\u00026\u0006\u0019qN]2\u0015\u00071\f9\f\u0003\u0004w\u0003c\u0003\r\u0001\u000b\u0005\b\u0003g\u0003A\u0011AA^)\ra\u0017Q\u0018\u0005\u0007u\u0006e\u0006\u0019A>)\u0007\u0005ev\u0010C\u0004\u0002\u0018\u0001!\t!a1\u0015\u00071\f)\rC\u0004\u0002H\u0006\u0005\u0007\u0019\u0001\u0015\u0002\u0013Q\f'\r\\3OC6,\u0007bBAf\u0001\u0011\u0005\u0011QZ\u0001\u0005i\u0016DH\u000fF\u0002m\u0003\u001fDaA^Ae\u0001\u0004A\u0003bBAf\u0001\u0011\u0005\u00111\u001b\u000b\u0004Y\u0006U\u0007B\u0002>\u0002R\u0002\u00071\u0010K\u0002\u0002R~Dq!a7\u0001\t\u0003\ti.\u0001\u0005uKb$h)\u001b7f)\u0011\ty.!:\u0011\tm\t\t\u000fK\u0005\u0004\u0003G\u0014!a\u0002#bi\u0006\u001cX\r\u001e\u0005\u0007m\u0006e\u0007\u0019\u0001\u0015\t\u000f\u0005m\u0007\u0001\"\u0001\u0002jR!\u0011q\\Av\u0011\u0019Q\u0018q\u001da\u0001w\"\u001a\u0011q]@\t\u0011\u001d\u0002\u0001\u0019!C\u0005\u0003c,\u0012\u0001\u000b\u0005\n\u0003k\u0004\u0001\u0019!C\u0005\u0003o\f!b]8ve\u000e,w\fJ3r)\u0011\tI0a@\u0011\u00075\tY0C\u0002\u0002~:\u0011A!\u00168ji\"I!\u0011AAz\u0003\u0003\u0005\r\u0001K\u0001\u0004q\u0012\n\u0004b\u0002B\u0003\u0001\u0001\u0006K\u0001K\u0001\bg>,(oY3!\u0011%\u0011I\u0001\u0001a\u0001\n\u0013\u0011Y!A\nvg\u0016\u00148\u000b]3dS\u001aLW\rZ*dQ\u0016l\u0017-\u0006\u0002\u0003\u000eA!QBa\u00044\u0013\r\u0011\tB\u0004\u0002\u0007\u001fB$\u0018n\u001c8\t\u0013\tU\u0001\u00011A\u0005\n\t]\u0011aF;tKJ\u001c\u0006/Z2jM&,GmU2iK6\fw\fJ3r)\u0011\tIP!\u0007\t\u0015\t\u0005!1CA\u0001\u0002\u0004\u0011i\u0001\u0003\u0005\u0003\u001e\u0001\u0001\u000b\u0015\u0002B\u0007\u0003Q)8/\u001a:Ta\u0016\u001c\u0017NZ5fIN\u001b\u0007.Z7bA!I!\u0011\u0005\u0001A\u0002\u0013%!1E\u0001\rKb$(/Y(qi&|gn]\u000b\u0003\u0005K\u0001bAa\n\u0003.!BSB\u0001B\u0015\u0015\r\u0011YcW\u0001\b[V$\u0018M\u00197f\u0013\u0011\u0011yC!\u000b\u0003\u000f!\u000b7\u000f['ba\"I!1\u0007\u0001A\u0002\u0013%!QG\u0001\u0011Kb$(/Y(qi&|gn]0%KF$B!!?\u00038!Q!\u0011\u0001B\u0019\u0003\u0003\u0005\rA!\n\t\u0011\tm\u0002\u0001)Q\u0005\u0005K\tQ\"\u001a=ue\u0006|\u0005\u000f^5p]N\u0004\u0003f\u0001\u0001\u0003@A!!\u0011\tB&\u001d\u0011\u0011\u0019Ea\u0012\u000e\u0005\t\u0015#bAA\u0003\t%!!\u0011\nB#\u0003IIe\u000e^3sM\u0006\u001cWm\u0015;bE&d\u0017\u000e^=\n\t\t5#q\n\u0002\u0007'R\f'\r\\3\u000b\t\t%#Q\t")
public class DataFrameReader
implements Logging {
    private final SparkSession sparkSession;
    private String source;
    private Option<StructType> userSpecifiedSchema;
    private HashMap<String, String> extraOptions;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public Dataset<Row> load(String ... paths) {
        return this.load((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> json(String ... paths) {
        return this.json((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> csv(String ... paths) {
        return this.csv((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> parquet(String ... paths) {
        return this.parquet((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> orc(String ... paths) {
        return this.orc((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> text(String ... paths) {
        return this.text((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<String> textFile(String ... paths) {
        return this.textFile((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public DataFrameReader format(String source) {
        this.source_$eq(source);
        return this;
    }

    public DataFrameReader schema(StructType schema) {
        this.userSpecifiedSchema_$eq((Option<StructType>)Option$.MODULE$.apply((Object)schema));
        return this;
    }

    public DataFrameReader option(String key, String value) {
        this.extraOptions().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value));
        return this;
    }

    public DataFrameReader option(String key, boolean value) {
        return this.option(key, ((Object)BoxesRunTime.boxToBoolean((boolean)value)).toString());
    }

    public DataFrameReader option(String key, long value) {
        return this.option(key, ((Object)BoxesRunTime.boxToLong((long)value)).toString());
    }

    public DataFrameReader option(String key, double value) {
        return this.option(key, ((Object)BoxesRunTime.boxToDouble((double)value)).toString());
    }

    public DataFrameReader options(Map<String, String> options) {
        this.extraOptions().$plus$plus$eq(options);
        return this;
    }

    public DataFrameReader options(java.util.Map<String, String> options) {
        this.options((Map<String, String>)((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala()));
        return this;
    }

    public Dataset<Row> load() {
        return this.load((Seq<String>)((Seq)Seq$.MODULE$.empty()));
    }

    public Dataset<Row> load(String path) {
        return this.option("path", path).load((Seq<String>)((Seq)Seq$.MODULE$.empty()));
    }

    public Dataset<Row> load(Seq<String> paths) {
        SparkSession x$2 = this.sparkSession;
        Seq<String> x$3 = paths;
        Option<StructType> x$4 = this.userSpecifiedSchema();
        String x$5 = this.source();
        scala.collection.immutable.Map x$6 = this.extraOptions().toMap(Predef$.MODULE$.$conforms());
        Seq<String> x$7 = DataSource$.MODULE$.apply$default$5();
        Option<BucketSpec> x$8 = DataSource$.MODULE$.apply$default$6();
        Option<CatalogTable> x$9 = DataSource$.MODULE$.apply$default$8();
        DataSource qual$1 = new DataSource(x$2, x$5, x$3, x$4, x$7, x$8, (scala.collection.immutable.Map<String, String>)x$6, x$9);
        boolean x$10 = qual$1.resolveRelation$default$1();
        return this.sparkSession.baseRelationToDataFrame(qual$1.resolveRelation(x$10));
    }

    public Dataset<Row> jdbc(String url, String table, Properties properties) {
        this.extraOptions_$eq((HashMap<String, String>)((HashMap)this.extraOptions().$plus$plus((GenTraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(properties).asScala(), HashMap$.MODULE$.canBuildFrom())));
        this.extraOptions().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_URL()), (Object)url), (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_TABLE_NAME()), (Object)table), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        return this.format("jdbc").load();
    }

    public Dataset<Row> jdbc(String url, String table, String columnName, long lowerBound, long upperBound, int numPartitions, Properties connectionProperties) {
        this.extraOptions().$plus$plus$eq((TraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_PARTITION_COLUMN()), (Object)columnName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_LOWER_BOUND()), (Object)((Object)BoxesRunTime.boxToLong((long)lowerBound)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_UPPER_BOUND()), (Object)((Object)BoxesRunTime.boxToLong((long)upperBound)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_NUM_PARTITIONS()), (Object)((Object)BoxesRunTime.boxToInteger((int)numPartitions)).toString())})));
        return this.jdbc(url, table, connectionProperties);
    }

    public Dataset<Row> jdbc(String url, String table, String[] predicates, Properties connectionProperties) {
        scala.collection.immutable.Map params = this.extraOptions().toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(connectionProperties).asScala()).toMap(Predef$.MODULE$.$conforms()));
        JDBCOptions options = new JDBCOptions(url, table, (scala.collection.immutable.Map<String, String>)params);
        Partition[] parts = (Partition[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])predicates).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Partition apply(Tuple2<String, Object> x0$1) {
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    String part = (String)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    JDBCPartition jDBCPartition = new JDBCPartition(part, i);
                    return jDBCPartition;
                }
                throw new MatchError(tuple2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Partition.class)));
        JDBCRelation relation = new JDBCRelation(parts, options, this.sparkSession);
        return this.sparkSession.baseRelationToDataFrame(relation);
    }

    public Dataset<Row> json(String path) {
        return this.json((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<Row> json(Seq<String> paths) {
        return this.format("json").load(paths);
    }

    public Dataset<Row> json(JavaRDD<String> jsonRDD) {
        return this.json((RDD<String>)jsonRDD.rdd());
    }

    public Dataset<Row> json(RDD<String> jsonRDD) {
        JSONOptions parsedOptions = new JSONOptions(this.extraOptions().toMap(Predef$.MODULE$.$conforms()), this.sparkSession.sessionState().conf().columnNameOfCorruptRecord());
        Serializable createParser = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final JsonParser apply(JsonFactory jsonFactory, String record) {
                return CreateJacksonParser$.MODULE$.string(jsonFactory, record);
            }
        };
        StructType schema = (StructType)this.userSpecifiedSchema().getOrElse((Function0)new Serializable(this, jsonRDD, parsedOptions, (Function2)createParser){
            public static final long serialVersionUID = 0L;
            private final RDD jsonRDD$1;
            private final JSONOptions parsedOptions$1;
            private final Function2 createParser$1;

            public final StructType apply() {
                return InferSchema$.MODULE$.infer(this.jsonRDD$1, this.parsedOptions$1, this.createParser$1);
            }
            {
                this.jsonRDD$1 = jsonRDD$1;
                this.parsedOptions$1 = parsedOptions$1;
                this.createParser$1 = createParser$1;
            }
        });
        RDD parsed = jsonRDD.mapPartitions((Function1)new Serializable(this, parsedOptions, (Function2)createParser, schema){
            public static final long serialVersionUID = 0L;
            private final JSONOptions parsedOptions$1;
            public final Function2 createParser$1;
            private final StructType schema$1;

            public final Iterator<InternalRow> apply(Iterator<String> iter) {
                JacksonParser parser = new JacksonParser(this.schema$1, this.parsedOptions$1);
                return iter.flatMap((Function1)new Serializable(this, parser){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;
                    private final JacksonParser parser$1;

                    public final Seq<InternalRow> apply(String x$1) {
                        return this.parser$1.parse((Object)x$1, this.$outer.createParser$1, (Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final UTF8String apply(String x$1) {
                                return UTF8String.fromString((String)x$1);
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.parser$1 = parser$1;
                    }
                });
            }
            {
                this.parsedOptions$1 = parsedOptions$1;
                this.createParser$1 = createParser$1;
                this.schema$1 = schema$1;
            }
        }, jsonRDD.mapPartitions$default$2(), ClassTag$.MODULE$.apply(InternalRow.class));
        return Dataset$.MODULE$.ofRows(this.sparkSession, (LogicalPlan)new LogicalRDD((Seq<Attribute>)schema.toAttributes(), (RDD<InternalRow>)parsed, LogicalRDD$.MODULE$.apply$default$3(), LogicalRDD$.MODULE$.apply$default$4(), this.sparkSession));
    }

    public Dataset<Row> csv(String path) {
        return this.csv((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<Row> csv(Seq<String> paths) {
        return this.format("csv").load(paths);
    }

    public Dataset<Row> parquet(String path) {
        return this.parquet((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<Row> parquet(Seq<String> paths) {
        return this.format("parquet").load(paths);
    }

    public Dataset<Row> orc(String path) {
        return this.orc((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<Row> orc(Seq<String> paths) {
        return this.format("orc").load(paths);
    }

    public Dataset<Row> table(String tableName) {
        return Dataset$.MODULE$.ofRows(this.sparkSession, this.sparkSession.sessionState().catalog().lookupRelation(this.sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName), this.sparkSession.sessionState().catalog().lookupRelation$default$2()));
    }

    public Dataset<Row> text(String path) {
        return this.text((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<Row> text(Seq<String> paths) {
        return this.format("text").load(paths);
    }

    public Dataset<String> textFile(String path) {
        return this.textFile((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<String> textFile(Seq<String> paths) {
        if (this.userSpecifiedSchema().nonEmpty()) {
            throw new AnalysisException("User specified schema not supported with `textFile`", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        return this.text(paths).select("value", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).as(this.sparkSession.implicits().newStringEncoder());
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private Option<StructType> userSpecifiedSchema() {
        return this.userSpecifiedSchema;
    }

    private void userSpecifiedSchema_$eq(Option<StructType> x$1) {
        this.userSpecifiedSchema = x$1;
    }

    private HashMap<String, String> extraOptions() {
        return this.extraOptions;
    }

    private void extraOptions_$eq(HashMap<String, String> x$1) {
        this.extraOptions = x$1;
    }

    public DataFrameReader(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
        Logging.class.$init$((Logging)this);
        this.source = sparkSession.sessionState().conf().defaultDataSourceName();
        this.userSpecifiedSchema = None$.MODULE$;
        this.extraOptions = new HashMap();
    }
}

