/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.exchange;

import org.apache.spark.SparkException;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.plans.physical.BroadcastMode;
import org.apache.spark.sql.catalyst.plans.physical.BroadcastPartitioning;
import org.apache.spark.sql.catalyst.plans.physical.Partitioning;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.exchange.BroadcastExchangeExec$;
import org.apache.spark.sql.execution.exchange.Exchange;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.metric.SQLMetrics$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.util.ThreadUtils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\tua\u0001B\u0001\u0003\u0001>\u0011QC\u0011:pC\u0012\u001c\u0017m\u001d;Fq\u000eD\u0017M\\4f\u000bb,7M\u0003\u0002\u0004\t\u0005AQ\r_2iC:<WM\u0003\u0002\u0006\r\u0005IQ\r_3dkRLwN\u001c\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0005\u0001A!\"\u0004\u0005\u0002\u0012%5\t!!\u0003\u0002\u0014\u0005\tAQ\t_2iC:<W\r\u0005\u0002\u001615\taCC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIbCA\u0004Qe>$Wo\u0019;\u0011\u0005UY\u0012B\u0001\u000f\u0017\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!q\u0002A!f\u0001\n\u0003y\u0012\u0001B7pI\u0016,\u0012\u0001\t\t\u0003C!j\u0011A\t\u0006\u0003G\u0011\n\u0001\u0002\u001d5zg&\u001c\u0017\r\u001c\u0006\u0003K\u0019\nQ\u0001\u001d7b]NT!a\n\u0004\u0002\u0011\r\fG/\u00197zgRL!!\u000b\u0012\u0003\u001b\t\u0013x.\u00193dCN$Xj\u001c3f\u0011!Y\u0003A!E!\u0002\u0013\u0001\u0013!B7pI\u0016\u0004\u0003\u0002C\u0017\u0001\u0005+\u0007I\u0011\u0001\u0018\u0002\u000b\rD\u0017\u000e\u001c3\u0016\u0003=\u0002\"\u0001M\u0019\u000e\u0003\u0011I!A\r\u0003\u0003\u0013M\u0003\u0018M]6QY\u0006t\u0007\u0002\u0003\u001b\u0001\u0005#\u0005\u000b\u0011B\u0018\u0002\r\rD\u0017\u000e\u001c3!\u0011\u00151\u0004\u0001\"\u00018\u0003\u0019a\u0014N\\5u}Q\u0019\u0001(\u000f\u001e\u0011\u0005E\u0001\u0001\"\u0002\u00106\u0001\u0004\u0001\u0003\"B\u00176\u0001\u0004y\u0003\u0002\u0003\u001f\u0001\u0011\u000b\u0007I\u0011I\u001f\u0002\u000f5,GO]5dgV\ta\b\u0005\u0003@\t\u001asU\"\u0001!\u000b\u0005\u0005\u0013\u0015!C5n[V$\u0018M\u00197f\u0015\t\u0019e#\u0001\u0006d_2dWm\u0019;j_:L!!\u0012!\u0003\u00075\u000b\u0007\u000f\u0005\u0002H\u00196\t\u0001J\u0003\u0002J\u0015\u0006!A.\u00198h\u0015\u0005Y\u0015\u0001\u00026bm\u0006L!!\u0014%\u0003\rM#(/\u001b8h!\ty%+D\u0001Q\u0015\t\tF!\u0001\u0004nKR\u0014\u0018nY\u0005\u0003'B\u0013\u0011bU)M\u001b\u0016$(/[2\t\u0011U\u0003\u0001\u0012!Q!\ny\n\u0001\"\\3ue&\u001c7\u000f\t\u0005\u0006/\u0002!\t\u0005W\u0001\u0013_V$\b/\u001e;QCJ$\u0018\u000e^5p]&tw-F\u0001Z!\t\t#,\u0003\u0002\\E\ta\u0001+\u0019:uSRLwN\\5oO\")Q\f\u0001C!=\u0006Q1/Y7f%\u0016\u001cX\u000f\u001c;\u0015\u0005}\u0013\u0007CA\u000ba\u0013\t\tgCA\u0004C_>dW-\u00198\t\u000b\rd\u0006\u0019A\u0018\u0002\tAd\u0017M\u001c\u0005\bK\u0002\u0011\r\u0011\"\u0003g\u0003\u001d!\u0018.\\3pkR,\u0012a\u001a\t\u0003Q6l\u0011!\u001b\u0006\u0003U.\f\u0001\u0002Z;sCRLwN\u001c\u0006\u0003YZ\t!bY8oGV\u0014(/\u001a8u\u0013\tq\u0017N\u0001\u0005EkJ\fG/[8o\u0011\u0019\u0001\b\u0001)A\u0005O\u0006AA/[7f_V$\b\u0005\u000b\u0002peB\u0011Qc]\u0005\u0003iZ\u0011\u0011\u0002\u001e:b]NLWM\u001c;\t\u0011Y\u0004\u0001\u0019!C\u0001\r]\f\u0011C]3mCRLwN\u001c\"s_\u0006$7-Y:u+\u0005A\bcA\u000bzw&\u0011!P\u0006\u0002\u0007\u001fB$\u0018n\u001c8\u0011\tq|\u00181A\u0007\u0002{*\u0011a\u0010C\u0001\nEJ|\u0017\rZ2bgRL1!!\u0001~\u0005%\u0011%o\\1eG\u0006\u001cH\u000fE\u0002\u0016\u0003\u000bI1!a\u0002\u0017\u0005\r\te.\u001f\u0005\u000b\u0003\u0017\u0001\u0001\u0019!C\u0001\r\u00055\u0011!\u0006:fY\u0006$\u0018n\u001c8Ce>\fGmY1ti~#S-\u001d\u000b\u0005\u0003\u001f\t)\u0002E\u0002\u0016\u0003#I1!a\u0005\u0017\u0005\u0011)f.\u001b;\t\u0013\u0005]\u0011\u0011BA\u0001\u0002\u0004A\u0018a\u0001=%c!9\u00111\u0004\u0001!B\u0013A\u0018A\u0005:fY\u0006$\u0018n\u001c8Ce>\fGmY1ti\u0002B3!!\u0007s\u0011)\t\t\u0003\u0001EC\u0002\u0013%\u00111E\u0001\u000fe\u0016d\u0017\r^5p]\u001a+H/\u001e:f+\t\t)\u0003E\u0003\u0002(\u0005%20D\u0001l\u0013\r\tYc\u001b\u0002\u0007\rV$XO]3\t\u0015\u0005=\u0002\u0001#A!B\u0013\t)#A\bsK2\fG/[8o\rV$XO]3!Q\r\tiC\u001d\u0005\b\u0003k\u0001A\u0011KA\u001c\u0003%!w\u000e\u0015:fa\u0006\u0014X\r\u0006\u0002\u0002\u0010!9\u00111\b\u0001\u0005R\u0005u\u0012!\u00033p\u000bb,7-\u001e;f)\t\ty\u0004\u0005\u0004\u0002B\u0005\u001d\u00131J\u0007\u0003\u0003\u0007R1!!\u0012\t\u0003\r\u0011H\rZ\u0005\u0005\u0003\u0013\n\u0019EA\u0002S\t\u0012\u0003B!!\u0014\u0002P5\ta%C\u0002\u0002R\u0019\u00121\"\u00138uKJt\u0017\r\u001c*po\"A\u0011Q\u000b\u0001\u0005R\u0019\t9&\u0001\ne_\u0016CXmY;uK\n\u0013x.\u00193dCN$X\u0003BA-\u0003C\"\"!a\u0017\u0011\tq|\u0018Q\f\t\u0005\u0003?\n\t\u0007\u0004\u0001\u0005\u0011\u0005\r\u00141\u000bb\u0001\u0003K\u0012\u0011\u0001V\t\u0005\u0003O\n\u0019\u0001E\u0002\u0016\u0003SJ1!a\u001b\u0017\u0005\u001dqu\u000e\u001e5j]\u001eD\u0011\"a\u001c\u0001\u0003\u0003%\t!!\u001d\u0002\t\r|\u0007/\u001f\u000b\u0006q\u0005M\u0014Q\u000f\u0005\t=\u00055\u0004\u0013!a\u0001A!AQ&!\u001c\u0011\u0002\u0003\u0007q\u0006C\u0005\u0002z\u0001\t\n\u0011\"\u0001\u0002|\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA?U\r\u0001\u0013qP\u0016\u0003\u0003\u0003\u0003B!a!\u0002\u000e6\u0011\u0011Q\u0011\u0006\u0005\u0003\u000f\u000bI)A\u0005v]\u000eDWmY6fI*\u0019\u00111\u0012\f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0010\u0006\u0015%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u00111\u0013\u0001\u0012\u0002\u0013\u0005\u0011QS\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t9JK\u00020\u0003\u007fB\u0011\"a'\u0001\u0003\u0003%\t%!(\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\u00051\u0005\"CAQ\u0001\u0005\u0005I\u0011AAR\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t)\u000bE\u0002\u0016\u0003OK1!!+\u0017\u0005\rIe\u000e\u001e\u0005\n\u0003[\u0003\u0011\u0011!C\u0001\u0003_\u000ba\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u0004\u0005E\u0006BCA\f\u0003W\u000b\t\u00111\u0001\u0002&\"I\u0011Q\u0017\u0001\u0002\u0002\u0013\u0005\u0013qW\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011\u0011\u0018\t\u0007\u0003w\u000bi,a\u0001\u000e\u0003\tK1!a0C\u0005!IE/\u001a:bi>\u0014\b\"CAb\u0001\u0005\u0005I\u0011AAc\u0003!\u0019\u0017M\\#rk\u0006dGcA0\u0002H\"Q\u0011qCAa\u0003\u0003\u0005\r!a\u0001\t\u0013\u0005-\u0007!!A\u0005B\u00055\u0017AB3rk\u0006d7\u000fF\u0002`\u0003\u001fD!\"a\u0006\u0002J\u0006\u0005\t\u0019AA\u0002\u000f\u001d\t\u0019N\u0001E\u0001\u0003+\fQC\u0011:pC\u0012\u001c\u0017m\u001d;Fq\u000eD\u0017M\\4f\u000bb,7\rE\u0002\u0012\u0003/4a!\u0001\u0002\t\u0002\u0005e7#BAl\u00037T\u0002cA\u000b\u0002^&\u0019\u0011q\u001c\f\u0003\r\u0005s\u0017PU3g\u0011\u001d1\u0014q\u001bC\u0001\u0003G$\"!!6\t\u0017\u0005\u001d\u0018q\u001bb\u0001\n\u0003!\u0011\u0011^\u0001\u0011Kb,7-\u001e;j_:\u001cuN\u001c;fqR,\"!a;\u0011\t\u0005\u001d\u0012Q^\u0005\u0004\u0003_\\'aH#yK\u000e,H/[8o\u0007>tG/\u001a=u\u000bb,7-\u001e;peN+'O^5dK\"I\u00111_AlA\u0003%\u00111^\u0001\u0012Kb,7-\u001e;j_:\u001cuN\u001c;fqR\u0004\u0003BCA|\u0003/\f\t\u0011\"!\u0002z\u0006)\u0011\r\u001d9msR)\u0001(a?\u0002~\"1a$!>A\u0002\u0001Ba!LA{\u0001\u0004y\u0003B\u0003B\u0001\u0003/\f\t\u0011\"!\u0003\u0004\u00059QO\\1qa2LH\u0003\u0002B\u0003\u0005\u001b\u0001B!F=\u0003\bA)QC!\u0003!_%\u0019!1\u0002\f\u0003\rQ+\b\u000f\\33\u0011%\u0011y!a@\u0002\u0002\u0003\u0007\u0001(A\u0002yIAB!Ba\u0005\u0002X\u0006\u0005I\u0011\u0002B\u000b\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t]\u0001cA$\u0003\u001a%\u0019!1\u0004%\u0003\r=\u0013'.Z2u\u0001")
public class BroadcastExchangeExec
extends Exchange {
    private final BroadcastMode mode;
    private final SparkPlan child;
    private Map<String, SQLMetric> metrics;
    private final transient Duration timeout;
    private transient Option<Broadcast<Object>> relationBroadcast;
    private transient Future<Broadcast<Object>> relationFuture;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple2<BroadcastMode, SparkPlan>> unapply(BroadcastExchangeExec broadcastExchangeExec) {
        return BroadcastExchangeExec$.MODULE$.unapply(broadcastExchangeExec);
    }

    private Map metrics$lzycompute() {
        BroadcastExchangeExec broadcastExchangeExec = this;
        synchronized (broadcastExchangeExec) {
            if (!this.bitmap$0) {
                this.metrics = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataSize"), (Object)SQLMetrics$.MODULE$.createMetric(this.sparkContext(), "data size (bytes)")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"collectTime"), (Object)SQLMetrics$.MODULE$.createMetric(this.sparkContext(), "time to collect (ms)")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"buildTime"), (Object)SQLMetrics$.MODULE$.createMetric(this.sparkContext(), "time to build (ms)")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"broadcastTime"), (Object)SQLMetrics$.MODULE$.createMetric(this.sparkContext(), "time to broadcast (ms)"))}));
                this.bitmap$0 = true;
            }
            return this.metrics;
        }
    }

    private Future relationFuture$lzycompute() {
        BroadcastExchangeExec broadcastExchangeExec = this;
        synchronized (broadcastExchangeExec) {
            if (!this.bitmap$trans$0) {
                String executionId = this.sparkContext().getLocalProperty(SQLExecution$.MODULE$.EXECUTION_ID_KEY());
                this.relationFuture = Future$.MODULE$.apply((Function0)new Serializable(this, executionId){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ BroadcastExchangeExec $outer;
                    public final String executionId$1;

                    public final Broadcast<Object> apply() {
                        return (Broadcast)SQLExecution$.MODULE$.withExecutionId(this.$outer.sparkContext(), this.executionId$1, new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$relationFuture$1 $outer;

                            public final Broadcast<Object> apply() {
                                try {
                                    long beforeCollect = System.nanoTime();
                                    InternalRow[] input = this.$outer.org$apache$spark$sql$execution$exchange$BroadcastExchangeExec$$anonfun$$$outer().child().executeCollect();
                                    if (input.length >= 512000000) {
                                        throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot broadcast the table with more than 512 millions rows: ", " rows"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)input.length)})));
                                    }
                                    long beforeBuild = System.nanoTime();
                                    this.$outer.org$apache$spark$sql$execution$exchange$BroadcastExchangeExec$$anonfun$$$outer().longMetric("collectTime").$plus$eq((beforeBuild - beforeCollect) / 1000000L);
                                    long dataSize = BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])input).map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final long apply(InternalRow x$1) {
                                            return ((UnsafeRow)x$1).getSizeInBytes();
                                        }
                                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                                    this.$outer.org$apache$spark$sql$execution$exchange$BroadcastExchangeExec$$anonfun$$$outer().longMetric("dataSize").$plus$eq(dataSize);
                                    if (dataSize >= 0x200000000L) {
                                        throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot broadcast the table that is larger than 8GB: ", " GB"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(dataSize >> 30))})));
                                    }
                                    Object relation = this.$outer.org$apache$spark$sql$execution$exchange$BroadcastExchangeExec$$anonfun$$$outer().mode().transform(input);
                                    long beforeBroadcast = System.nanoTime();
                                    this.$outer.org$apache$spark$sql$execution$exchange$BroadcastExchangeExec$$anonfun$$$outer().longMetric("buildTime").$plus$eq((beforeBroadcast - beforeBuild) / 1000000L);
                                    Broadcast broadcasted = this.$outer.org$apache$spark$sql$execution$exchange$BroadcastExchangeExec$$anonfun$$$outer().sparkContext().broadcast(relation, ClassTag$.MODULE$.Any());
                                    this.$outer.org$apache$spark$sql$execution$exchange$BroadcastExchangeExec$$anonfun$$$outer().longMetric("broadcastTime").$plus$eq((System.nanoTime() - beforeBroadcast) / 1000000L);
                                    SQLMetrics$.MODULE$.postDriverMetricUpdates(this.$outer.org$apache$spark$sql$execution$exchange$BroadcastExchangeExec$$anonfun$$$outer().sparkContext(), this.$outer.executionId$1, (Seq<SQLMetric>)this.$outer.org$apache$spark$sql$execution$exchange$BroadcastExchangeExec$$anonfun$$$outer().metrics().values().toSeq());
                                    this.$outer.org$apache$spark$sql$execution$exchange$BroadcastExchangeExec$$anonfun$$$outer().relationBroadcast_$eq((Option<Broadcast<Object>>)new Some((Object)broadcasted));
                                    return broadcasted;
                                }
                                catch (OutOfMemoryError outOfMemoryError) {
                                    throw new OutOfMemoryError(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Not enough memory to build and broadcast the table to "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"all worker nodes. As a workaround, you can either disable broadcast by setting "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " to -1 or increase the spark driver "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SQLConf$.MODULE$.AUTO_BROADCASTJOIN_THRESHOLD().key()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"memory by setting ", " to a higher value"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"spark.driver.memory"}))).toString()).initCause(outOfMemoryError.getCause());
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public /* synthetic */ BroadcastExchangeExec org$apache$spark$sql$execution$exchange$BroadcastExchangeExec$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executionId$1 = executionId$1;
                    }
                }, (ExecutionContext)BroadcastExchangeExec$.MODULE$.executionContext());
                this.bitmap$trans$0 = true;
            }
            return this.relationFuture;
        }
    }

    public BroadcastMode mode() {
        return this.mode;
    }

    @Override
    public SparkPlan child() {
        return this.child;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return this.bitmap$0 ? this.metrics : this.metrics$lzycompute();
    }

    @Override
    public Partitioning outputPartitioning() {
        return new BroadcastPartitioning(this.mode());
    }

    public boolean sameResult(SparkPlan plan) {
        boolean bl;
        SparkPlan sparkPlan = plan;
        if (sparkPlan instanceof BroadcastExchangeExec) {
            BroadcastExchangeExec broadcastExchangeExec = (BroadcastExchangeExec)sparkPlan;
            bl = this.mode().compatibleWith(broadcastExchangeExec.mode()) && this.child().sameResult(broadcastExchangeExec.child());
        } else {
            bl = false;
        }
        return bl;
    }

    private Duration timeout() {
        return this.timeout;
    }

    public Option<Broadcast<Object>> relationBroadcast() {
        return this.relationBroadcast;
    }

    public void relationBroadcast_$eq(Option<Broadcast<Object>> x$1) {
        this.relationBroadcast = x$1;
    }

    private Future<Broadcast<Object>> relationFuture() {
        return this.bitmap$trans$0 ? this.relationFuture : this.relationFuture$lzycompute();
    }

    @Override
    public void doPrepare() {
        this.relationFuture();
    }

    @Override
    public RDD<InternalRow> doExecute() {
        throw new UnsupportedOperationException("BroadcastExchange does not support the execute() code path.");
    }

    @Override
    public <T> Broadcast<T> doExecuteBroadcast() {
        return (Broadcast)ThreadUtils$.MODULE$.awaitResult(this.relationFuture(), this.timeout());
    }

    public BroadcastExchangeExec copy(BroadcastMode mode, SparkPlan child) {
        return new BroadcastExchangeExec(mode, child);
    }

    public BroadcastMode copy$default$1() {
        return this.mode();
    }

    public SparkPlan copy$default$2() {
        return this.child();
    }

    public String productPrefix() {
        return "BroadcastExchangeExec";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        SparkPlan sparkPlan;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                sparkPlan = this.child();
                break;
            }
            case 0: {
                sparkPlan = this.mode();
            }
        }
        return sparkPlan;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BroadcastExchangeExec;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof BroadcastExchangeExec)) return false;
        boolean bl = true;
        if (!bl) return false;
        BroadcastExchangeExec broadcastExchangeExec = (BroadcastExchangeExec)x$1;
        BroadcastMode broadcastMode = this.mode();
        BroadcastMode broadcastMode2 = broadcastExchangeExec.mode();
        if (broadcastMode == null) {
            if (broadcastMode2 != null) {
                return false;
            }
        } else if (!broadcastMode.equals(broadcastMode2)) return false;
        SparkPlan sparkPlan = this.child();
        SparkPlan sparkPlan2 = broadcastExchangeExec.child();
        if (sparkPlan == null) {
            if (sparkPlan2 != null) {
                return false;
            }
        } else if (!((Object)((Object)sparkPlan)).equals((Object)sparkPlan2)) return false;
        if (!broadcastExchangeExec.canEqual(this)) return false;
        return true;
    }

    public BroadcastExchangeExec(BroadcastMode mode, SparkPlan child) {
        this.mode = mode;
        this.child = child;
        int timeoutValue = this.sqlContext().conf().broadcastTimeout();
        this.timeout = timeoutValue < 0 ? Duration$.MODULE$.Inf() : new package.DurationInt(package$.MODULE$.DurationInt(timeoutValue)).seconds();
        this.relationBroadcast = None$.MODULE$;
    }
}

