/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex$;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation$;
import org.apache.spark.sql.execution.streaming.FileStreamOptions;
import org.apache.spark.sql.execution.streaming.FileStreamSourceLog;
import org.apache.spark.sql.execution.streaming.FileStreamSourceLog$;
import org.apache.spark.sql.execution.streaming.FileStreamSourceOffset;
import org.apache.spark.sql.execution.streaming.FileStreamSourceOffset$;
import org.apache.spark.sql.execution.streaming.Offset;
import org.apache.spark.sql.execution.streaming.Source;
import org.apache.spark.sql.execution.streaming.Source$class;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\r\u001de\u0001B\u0001\u0003\u0001=\u0011\u0001CR5mKN#(/Z1n'>,(oY3\u000b\u0005\r!\u0011!C:ue\u0016\fW.\u001b8h\u0015\t)a!A\u0005fq\u0016\u001cW\u000f^5p]*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u0005\f\u001b!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fMB\u0011q\u0003G\u0007\u0002\u0005%\u0011\u0011D\u0001\u0002\u0007'>,(oY3\u0011\u0005mqR\"\u0001\u000f\u000b\u0005uA\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005}a\"a\u0002'pO\u001eLgn\u001a\u0005\tC\u0001\u0011\t\u0011)A\u0005E\u0005a1\u000f]1sWN+7o]5p]B\u00111\u0005J\u0007\u0002\r%\u0011QE\u0002\u0002\r'B\f'o[*fgNLwN\u001c\u0005\tO\u0001\u0011\t\u0011)A\u0005Q\u0005!\u0001/\u0019;i!\tICF\u0004\u0002\u0012U%\u00111FE\u0001\u0007!J,G-\u001a4\n\u00055r#AB*ue&twM\u0003\u0002,%!A\u0001\u0007\u0001B\u0001B\u0003%\u0001&A\ngS2,gi\u001c:nCR\u001cE.Y:t\u001d\u0006lW\r\u0003\u00053\u0001\t\u0015\r\u0011\"\u00114\u0003\u0019\u00198\r[3nCV\tA\u0007\u0005\u00026q5\taG\u0003\u00028\r\u0005)A/\u001f9fg&\u0011\u0011H\u000e\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\u0002\u000fM\u001c\u0007.Z7bA!AQ\b\u0001B\u0001B\u0003%a(\u0001\tqCJ$\u0018\u000e^5p]\u000e{G.^7ogB\u0019qh\u0012\u0015\u000f\u0005\u0001+eBA!E\u001b\u0005\u0011%BA\"\u000f\u0003\u0019a$o\\8u}%\t1#\u0003\u0002G%\u00059\u0001/Y2lC\u001e,\u0017B\u0001%J\u0005\r\u0019V-\u001d\u0006\u0003\rJA\u0001b\u0013\u0001\u0003\u0002\u0003\u0006I\u0001K\u0001\r[\u0016$\u0018\rZ1uCB\u000bG\u000f\u001b\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u001d\u00069q\u000e\u001d;j_:\u001c\b\u0003B\u0015PQ!J!\u0001\u0015\u0018\u0003\u00075\u000b\u0007\u000fC\u0003S\u0001\u0011\u00051+\u0001\u0004=S:LGO\u0010\u000b\t)V3v\u000bW-[7B\u0011q\u0003\u0001\u0005\u0006CE\u0003\rA\t\u0005\u0006OE\u0003\r\u0001\u000b\u0005\u0006aE\u0003\r\u0001\u000b\u0005\u0006eE\u0003\r\u0001\u000e\u0005\u0006{E\u0003\rA\u0010\u0005\u0006\u0017F\u0003\r\u0001\u000b\u0005\u0006\u001bF\u0003\rA\u0014\u0005\b;\u0002\u0011\r\u0011\"\u0003_\u00035\u0019x.\u001e:dK>\u0003H/[8ogV\tq\f\u0005\u0002\u0018A&\u0011\u0011M\u0001\u0002\u0012\r&dWm\u0015;sK\u0006lw\n\u001d;j_:\u001c\bBB2\u0001A\u0003%q,\u0001\bt_V\u00148-Z(qi&|gn\u001d\u0011\t\u000f\u0015\u0004!\u0019!C\u0005M\u0006\t\u0012/^1mS\u001aLW\r\u001a\"bg\u0016\u0004\u0016\r\u001e5\u0016\u0003\u001d\u0004\"\u0001[7\u000e\u0003%T!A[6\u0002\u0005\u0019\u001c(B\u00017\u000b\u0003\u0019A\u0017\rZ8pa&\u0011a.\u001b\u0002\u0005!\u0006$\b\u000e\u0003\u0004q\u0001\u0001\u0006IaZ\u0001\u0013cV\fG.\u001b4jK\u0012\u0014\u0015m]3QCRD\u0007\u0005C\u0004s\u0001\t\u0007I\u0011B:\u00029=\u0004H/[8og^KG\u000f\u001b)beRLG/[8o\u0005\u0006\u001cX\rU1uQV\tA\u000f\u0005\u0003vu\"BS\"\u0001<\u000b\u0005]D\u0018!C5n[V$\u0018M\u00197f\u0015\tI(#\u0001\u0006d_2dWm\u0019;j_:L!\u0001\u0015<\t\rq\u0004\u0001\u0015!\u0003u\u0003uy\u0007\u000f^5p]N<\u0016\u000e\u001e5QCJ$\u0018\u000e^5p]\n\u000b7/\u001a)bi\"\u0004\u0003b\u0002@\u0001\u0005\u0004%Ia`\u0001\f[\u0016$\u0018\rZ1uC2{w-\u0006\u0002\u0002\u0002A\u0019q#a\u0001\n\u0007\u0005\u0015!AA\nGS2,7\u000b\u001e:fC6\u001cv.\u001e:dK2{w\r\u0003\u0005\u0002\n\u0001\u0001\u000b\u0011BA\u0001\u00031iW\r^1eCR\fGj\\4!\u0011%\ti\u0001\u0001a\u0001\n\u0013\ty!\u0001\rnKR\fG-\u0019;b\u0019><7)\u001e:sK:$xJ\u001a4tKR,\"!!\u0005\u0011\u0007E\t\u0019\"C\u0002\u0002\u0016I\u0011A\u0001T8oO\"I\u0011\u0011\u0004\u0001A\u0002\u0013%\u00111D\u0001\u001d[\u0016$\u0018\rZ1uC2{wmQ;se\u0016tGo\u00144gg\u0016$x\fJ3r)\u0011\ti\"a\t\u0011\u0007E\ty\"C\u0002\u0002\"I\u0011A!\u00168ji\"Q\u0011QEA\f\u0003\u0003\u0005\r!!\u0005\u0002\u0007a$\u0013\u0007\u0003\u0005\u0002*\u0001\u0001\u000b\u0015BA\t\u0003eiW\r^1eCR\fGj\\4DkJ\u0014XM\u001c;PM\u001a\u001cX\r\u001e\u0011\t\u0013\u00055\u0002A1A\u0005\n\u0005=\u0012\u0001E7bq\u001aKG.Z:QKJ\u0014\u0015\r^2i+\t\t\t\u0004E\u0003\u0012\u0003g\t9$C\u0002\u00026I\u0011aa\u00149uS>t\u0007cA\t\u0002:%\u0019\u00111\b\n\u0003\u0007%sG\u000f\u0003\u0005\u0002@\u0001\u0001\u000b\u0011BA\u0019\u0003Ei\u0017\r\u001f$jY\u0016\u001c\b+\u001a:CCR\u001c\u0007\u000e\t\u0005\n\u0003\u0007\u0002!\u0019!C\u0005\u0003\u000b\nQBZ5mKN{'\u000f^(sI\u0016\u0014XCAA$!\u0019\tI%a\u0014\u0002\u00125\u0011\u00111\n\u0006\u0004\u0003\u001b\u0012\u0012\u0001B7bi\"LA!!\u0015\u0002L\tAqJ\u001d3fe&tw\r\u0003\u0005\u0002V\u0001\u0001\u000b\u0011BA$\u000391\u0017\u000e\\3T_J$xJ\u001d3fe\u0002B\u0011\"!\u0017\u0001\u0005\u0004%I!a\u0004\u0002\u00195\f\u0007PR5mK\u0006;W-T:\t\u0011\u0005u\u0003\u0001)A\u0005\u0003#\tQ\"\\1y\r&dW-Q4f\u001bN\u0004\u0003\"CA1\u0001\t\u0007I\u0011AA2\u0003%\u0019X-\u001a8GS2,7/\u0006\u0002\u0002fA!\u0011q\rBF\u001d\r9\u0012\u0011N\u0004\b\u0003W\u0012\u0001\u0012AA7\u0003A1\u0015\u000e\\3TiJ,\u0017-\\*pkJ\u001cW\rE\u0002\u0018\u0003_2a!\u0001\u0002\t\u0002\u0005E4cAA8!!9!+a\u001c\u0005\u0002\u0005UDCAA7\u000b\u001d\tI(a\u001c\u0001\u0003#\u0011\u0011\u0002V5nKN$\u0018-\u001c9\u0007\u000f\u0005u\u0014q\u000e!\u0002\u0000\tIa)\u001b7f\u000b:$(/_\n\b\u0003w\u0002\u0012\u0011QAD!\r\t\u00121Q\u0005\u0004\u0003\u000b\u0013\"\u0001D*fe&\fG.\u001b>bE2,\u0007cA\t\u0002\n&\u0019\u00111\u0012\n\u0003\u000fA\u0013x\u000eZ;di\"Qq%a\u001f\u0003\u0016\u0004%\t!a$\u0016\u0003!B!\"a%\u0002|\tE\t\u0015!\u0003)\u0003\u0015\u0001\u0018\r\u001e5!\u0011-\t9*a\u001f\u0003\u0016\u0004%\t!!'\u0002\u0013QLW.Z:uC6\u0004XCAAN!\u0011\ti*a\u001e\u000e\u0005\u0005=\u0004bCAQ\u0003w\u0012\t\u0012)A\u0005\u00037\u000b!\u0002^5nKN$\u0018-\u001c9!\u0011-\t)+a\u001f\u0003\u0016\u0004%\t!a\u0004\u0002\u000f\t\fGo\u00195JI\"Y\u0011\u0011VA>\u0005#\u0005\u000b\u0011BA\t\u0003!\u0011\u0017\r^2i\u0013\u0012\u0004\u0003b\u0002*\u0002|\u0011\u0005\u0011Q\u0016\u000b\t\u0003_\u000b\t,a-\u00026B!\u0011QTA>\u0011\u00199\u00131\u0016a\u0001Q!A\u0011qSAV\u0001\u0004\tY\n\u0003\u0005\u0002&\u0006-\u0006\u0019AA\t\u0011)\tI,a\u001f\u0002\u0002\u0013\u0005\u00111X\u0001\u0005G>\u0004\u0018\u0010\u0006\u0005\u00020\u0006u\u0016qXAa\u0011!9\u0013q\u0017I\u0001\u0002\u0004A\u0003BCAL\u0003o\u0003\n\u00111\u0001\u0002\u001c\"Q\u0011QUA\\!\u0003\u0005\r!!\u0005\t\u0015\u0005\u0015\u00171PI\u0001\n\u0003\t9-\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005%'f\u0001\u0015\u0002L.\u0012\u0011Q\u001a\t\u0005\u0003\u001f\fI.\u0004\u0002\u0002R*!\u00111[Ak\u0003%)hn\u00195fG.,GMC\u0002\u0002XJ\t!\"\u00198o_R\fG/[8o\u0013\u0011\tY.!5\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0003\u0006\u0002`\u0006m\u0014\u0013!C\u0001\u0003C\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002d*\"\u00111TAf\u0011)\t9/a\u001f\u0012\u0002\u0013\u0005\u0011\u0011^\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\tYO\u000b\u0003\u0002\u0012\u0005-\u0007BCAx\u0003w\n\t\u0011\"\u0011\u0002r\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!a=\u0011\t\u0005U\u0018q`\u0007\u0003\u0003oTA!!?\u0002|\u0006!A.\u00198h\u0015\t\ti0\u0001\u0003kCZ\f\u0017bA\u0017\u0002x\"Q!1AA>\u0003\u0003%\tA!\u0002\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005]\u0002B\u0003B\u0005\u0003w\n\t\u0011\"\u0001\u0003\f\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002B\u0007\u0005'\u00012!\u0005B\b\u0013\r\u0011\tB\u0005\u0002\u0004\u0003:L\bBCA\u0013\u0005\u000f\t\t\u00111\u0001\u00028!Q!qCA>\u0003\u0003%\tE!\u0007\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa\u0007\u0011\r\tu!q\u0004B\u0007\u001b\u0005A\u0018b\u0001B\u0011q\nA\u0011\n^3sCR|'\u000f\u0003\u0006\u0003&\u0005m\u0014\u0011!C\u0001\u0005O\t\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005S\u0011y\u0003E\u0002\u0012\u0005WI1A!\f\u0013\u0005\u001d\u0011un\u001c7fC:D!\"!\n\u0003$\u0005\u0005\t\u0019\u0001B\u0007\u0011)\u0011\u0019$a\u001f\u0002\u0002\u0013\u0005#QG\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011q\u0007\u0005\u000b\u0005s\tY(!A\u0005B\tm\u0012\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005M\bB\u0003B \u0003w\n\t\u0011\"\u0011\u0003B\u00051Q-];bYN$BA!\u000b\u0003D!Q\u0011Q\u0005B\u001f\u0003\u0003\u0005\rA!\u0004\b\u0015\t\u001d\u0013qNA\u0001\u0012\u0003\u0011I%A\u0005GS2,WI\u001c;ssB!\u0011Q\u0014B&\r)\ti(a\u001c\u0002\u0002#\u0005!QJ\n\u0007\u0005\u0017\u0012y%!!\u0011\u0017\tE#q\u000b\u0015\u0002\u001c\u0006E\u0011qV\u0007\u0003\u0005'R1A!\u0016\u0013\u0003\u001d\u0011XO\u001c;j[\u0016LAA!\u0017\u0003T\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\t\u000fI\u0013Y\u0005\"\u0001\u0003^Q\u0011!\u0011\n\u0005\u000b\u0005s\u0011Y%!A\u0005F\tm\u0002B\u0003B2\u0005\u0017\n\t\u0011\"!\u0003f\u0005)\u0011\r\u001d9msRA\u0011q\u0016B4\u0005S\u0012Y\u0007\u0003\u0004(\u0005C\u0002\r\u0001\u000b\u0005\t\u0003/\u0013\t\u00071\u0001\u0002\u001c\"A\u0011Q\u0015B1\u0001\u0004\t\t\u0002\u0003\u0006\u0003p\t-\u0013\u0011!CA\u0005c\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003t\tm\u0004#B\t\u00024\tU\u0004\u0003C\t\u0003x!\nY*!\u0005\n\u0007\te$C\u0001\u0004UkBdWm\r\u0005\u000b\u0005{\u0012i'!AA\u0002\u0005=\u0016a\u0001=%a!Q!\u0011\u0011B&\u0003\u0003%IAa!\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005\u000b\u0003B!!>\u0003\b&!!\u0011RA|\u0005\u0019y%M[3di\u001a9!QRA8\u0001\t=%\u0001D*fK:4\u0015\u000e\\3t\u001b\u0006\u00048c\u0001BF!!Y!1\u0013BF\u0005\u0003\u0005\u000b\u0011BA\t\u0003!i\u0017\r_!hK6\u001b\bb\u0002*\u0003\f\u0012\u0005!q\u0013\u000b\u0005\u00053\u0013Y\n\u0005\u0003\u0002\u001e\n-\u0005\u0002\u0003BJ\u0005+\u0003\r!!\u0005\t\u0015\t}%1\u0012b\u0001\n\u0013\u0011\t+A\u0002nCB,\"Aa)\u0011\u000f\t\u0015&1\u0016\u0015\u0002\u001c6\u0011!q\u0015\u0006\u0005\u0005S\u000bY0\u0001\u0003vi&d\u0017\u0002\u0002BW\u0005O\u0013q\u0001S1tQ6\u000b\u0007\u000fC\u0005\u00032\n-\u0005\u0015!\u0003\u0003$\u0006!Q.\u00199!\u0011)\u0011)La#A\u0002\u0013%\u0011\u0011T\u0001\u0010Y\u0006$Xm\u001d;US6,7\u000f^1na\"Q!\u0011\u0018BF\u0001\u0004%IAa/\u0002'1\fG/Z:u)&lWm\u001d;b[B|F%Z9\u0015\t\u0005u!Q\u0018\u0005\u000b\u0003K\u00119,!AA\u0002\u0005m\u0005\"\u0003Ba\u0005\u0017\u0003\u000b\u0015BAN\u0003Aa\u0017\r^3tiRKW.Z:uC6\u0004\b\u0005\u0003\u0006\u0003F\n-\u0005\u0019!C\u0005\u00033\u000b!\u0003\\1tiB+(oZ3US6,7\u000f^1na\"Q!\u0011\u001aBF\u0001\u0004%IAa3\u0002-1\f7\u000f\u001e)ve\u001e,G+[7fgR\fW\u000e]0%KF$B!!\b\u0003N\"Q\u0011Q\u0005Bd\u0003\u0003\u0005\r!a'\t\u0013\tE'1\u0012Q!\n\u0005m\u0015a\u00057bgR\u0004VO]4f)&lWm\u001d;b[B\u0004\u0003\u0002\u0003Bk\u0005\u0017#\tAa6\u0002\u0007\u0005$G\r\u0006\u0004\u0002\u001e\te'1\u001c\u0005\u0007O\tM\u0007\u0019\u0001\u0015\t\u0011\u0005]%1\u001ba\u0001\u00037C\u0001Ba8\u0003\f\u0012\u0005!\u0011]\u0001\nSNtUm\u001e$jY\u0016$bA!\u000b\u0003d\n\u0015\bBB\u0014\u0003^\u0002\u0007\u0001\u0006\u0003\u0005\u0002\u0018\nu\u0007\u0019AAN\u0011!\u0011IOa#\u0005\u0002\tU\u0012!\u00029ve\u001e,\u0007\u0002\u0003Bw\u0005\u0017#\tA!\u0002\u0002\tML'0\u001a\u0005\t\u0005c\u0014Y\t\"\u0001\u0003t\u0006Q\u0011\r\u001c7F]R\u0014\u0018.Z:\u0016\u0005\tU\b\u0003B H\u0005o\u0004b!\u0005B}Q\u0005m\u0015b\u0001B~%\t1A+\u001e9mKJB\u0001Ba@\u0001A\u0003%\u0011QM\u0001\u000bg\u0016,gNR5mKN\u0004\u0003bBB\u0002\u0001\u0011%1QA\u0001\u000fM\u0016$8\r['bq>3gm]3u)\t\u00199\u0001E\u0002\u0018\u0007\u0013I1aa\u0003\u0003\u0005Y1\u0015\u000e\\3TiJ,\u0017-\\*pkJ\u001cWm\u00144gg\u0016$\bbBB\b\u0001\u0011\u00051\u0011C\u0001\u0013o&$\bNQ1uG\"Lgn\u001a'pG.,G-\u0006\u0003\u0004\u0014\reA\u0003BB\u000b\u0007K\u0001Baa\u0006\u0004\u001a1\u0001A\u0001CB\u000e\u0007\u001b\u0011\ra!\b\u0003\u0003Q\u000bBaa\b\u0003\u000eA\u0019\u0011c!\t\n\u0007\r\r\"CA\u0004O_RD\u0017N\\4\t\u0013\r\u001d2Q\u0002CA\u0002\r%\u0012\u0001\u00024v]\u000e\u0004R!EB\u0016\u0007+I1a!\f\u0013\u0005!a$-\u001f8b[\u0016t\u0004bBB\u0019\u0001\u0011\u0005\u0011qB\u0001\u0011GV\u0014(/\u001a8u\u0019><wJ\u001a4tKRDqa!\u000e\u0001\t\u0003\u001a9$\u0001\u0005hKR\u0014\u0015\r^2i)\u0019\u0019Id!\u0016\u0004bA!11HB(\u001d\u0011\u0019id!\u0014\u000f\t\r}21\n\b\u0005\u0007\u0003\u001aIE\u0004\u0003\u0004D\r\u001dcbA!\u0004F%\tQ\"\u0003\u0002\f\u0019%\u0011\u0011BC\u0005\u0003\u000f!I!A\u0012\u0004\n\t\rE31\u000b\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T!A\u0012\u0004\t\u0011\r]31\u0007a\u0001\u00073\nQa\u001d;beR\u0004R!EA\u001a\u00077\u00022aFB/\u0013\r\u0019yF\u0001\u0002\u0007\u001f\u001a47/\u001a;\t\u0011\r\r41\u0007a\u0001\u00077\n1!\u001a8e\u0011\u001d\u00199\u0007\u0001C\u0005\u0007S\nQBZ3uG\"\fE\u000e\u001c$jY\u0016\u001cHCAB6!\u0011yti!\u001c\u0011\rE\u0011I\u0010KA\t\u0011\u001d\u0019\t\b\u0001C!\u0007g\n\u0011bZ3u\u001f\u001a47/\u001a;\u0016\u0005\re\u0003b\u0002B\u001d\u0001\u0011\u00053q\u000f\u000b\u0002Q!911\u0010\u0001\u0005B\ru\u0014AB2p[6LG\u000f\u0006\u0003\u0002\u001e\r}\u0004\u0002CB2\u0007s\u0002\raa\u0017\t\u000f\r\r\u0005\u0001\"\u0011\u0004\u0006\u0006!1\u000f^8q)\t\ti\u0002")
public class FileStreamSource
implements Source,
Logging {
    private final SparkSession sparkSession;
    private final String fileFormatClassName;
    private final StructType schema;
    private final Seq<String> partitionColumns;
    private final Map<String, String> options;
    private final FileStreamOptions sourceOptions;
    private final Path qualifiedBasePath;
    private final Map<String, String> optionsWithPartitionBasePath;
    private final FileStreamSourceLog metadataLog;
    private long org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset;
    private final Option<Object> org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFilesPerBatch;
    private final Ordering<Object> fileSortOrder;
    private final long org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFileAgeMs;
    private final SeenFilesMap seenFiles;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private transient int org$apache$spark$internal$Logging$$levelFlags;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int org$apache$spark$internal$Logging$$levelFlags() {
        return this.org$apache$spark$internal$Logging$$levelFlags;
    }

    public void org$apache$spark$internal$Logging$$levelFlags_$eq(int x$1) {
        this.org$apache$spark$internal$Logging$$levelFlags = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public final boolean isInfoEnabled() {
        return Logging.class.isInfoEnabled((Logging)this);
    }

    public final boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public final boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    @Override
    public StructType schema() {
        return this.schema;
    }

    private FileStreamOptions sourceOptions() {
        return this.sourceOptions;
    }

    private Path qualifiedBasePath() {
        return this.qualifiedBasePath;
    }

    private Map<String, String> optionsWithPartitionBasePath() {
        return this.optionsWithPartitionBasePath;
    }

    private FileStreamSourceLog metadataLog() {
        return this.metadataLog;
    }

    public long org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset() {
        return this.org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset;
    }

    private void org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset_$eq(long x$1) {
        this.org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset = x$1;
    }

    public Option<Object> org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFilesPerBatch() {
        return this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFilesPerBatch;
    }

    private Ordering<Object> fileSortOrder() {
        return this.fileSortOrder;
    }

    public long org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFileAgeMs() {
        return this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFileAgeMs;
    }

    public SeenFilesMap seenFiles() {
        return this.seenFiles;
    }

    private synchronized FileStreamSourceOffset fetchMaxOffset() {
        Seq newFiles = (Seq)this.fetchAllFiles().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileStreamSource $outer;

            public final boolean apply(Tuple2<String, Object> x0$1) {
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    String path = (String)tuple2._1();
                    long timestamp = tuple2._2$mcJ$sp();
                    boolean bl = this.$outer.seenFiles().isNewFile(path, timestamp);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Seq batchFiles = this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFilesPerBatch().nonEmpty() ? (Seq)newFiles.take(BoxesRunTime.unboxToInt((Object)this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFilesPerBatch().get())) : newFiles;
        batchFiles.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileStreamSource $outer;

            public final void apply(Tuple2<String, Object> file) {
                this.$outer.seenFiles().add((String)file._1(), file._2$mcJ$sp());
                this.$outer.logDebug((Function0<String>)new Serializable(this, file){
                    public static final long serialVersionUID = 0L;
                    private final Tuple2 file$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"New file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1}));
                    }
                    {
                        this.file$1 = file$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        int numPurged = this.seenFiles().purge();
        this.logTrace((Function0<String>)new Serializable(this, newFiles, batchFiles, numPurged){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileStreamSource $outer;
            private final Seq newFiles$1;
            private final Seq batchFiles$1;
            private final int numPurged$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |Number of new files = ", "\n         |Number of files selected for batch = ", "\n         |Number of seen files = ", "\n         |Number of files purged from tracking map = ", "\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.newFiles$1.size()), BoxesRunTime.boxToInteger((int)this.batchFiles$1.size()), BoxesRunTime.boxToInteger((int)this.$outer.seenFiles().size()), BoxesRunTime.boxToInteger((int)this.numPurged$1)})))).stripMargin();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newFiles$1 = newFiles$1;
                this.batchFiles$1 = batchFiles$1;
                this.numPurged$1 = numPurged$1;
            }
        });
        if (batchFiles.nonEmpty()) {
            this.org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset_$eq(this.org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset() + 1L);
            this.metadataLog().add(this.org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset(), (FileEntry[])((TraversableOnce)batchFiles.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FileStreamSource $outer;

                public final FileEntry apply(Tuple2<String, Object> x0$2) {
                    Tuple2<String, Object> tuple2 = x0$2;
                    if (tuple2 != null) {
                        String p = (String)tuple2._1();
                        long timestamp = tuple2._2$mcJ$sp();
                        FileEntry fileEntry = new FileEntry(p, timestamp, this.$outer.org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset());
                        return fileEntry;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(FileEntry.class)));
            this.logInfo((Function0<String>)new Serializable(this, batchFiles){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FileStreamSource $outer;
                private final Seq batchFiles$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log offset set to ", " with ", " new files"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset()), BoxesRunTime.boxToInteger((int)this.batchFiles$1.size())}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.batchFiles$1 = batchFiles$1;
                }
            });
        }
        return new FileStreamSourceOffset(this.org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset());
    }

    public synchronized <T> T withBatchingLocked(Function0<T> func) {
        return (T)func.apply();
    }

    public synchronized long currentLogOffset() {
        return this.org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset();
    }

    @Override
    public Dataset<Row> getBatch(Option<Offset> start2, Offset end) {
        long endOffset;
        long startOffset = BoxesRunTime.unboxToLong((Object)start2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Offset x$2) {
                return FileStreamSourceOffset$.MODULE$.apply(x$2).logOffset();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return -1L;
            }
        }));
        Predef$.MODULE$.assert(startOffset <= (endOffset = FileStreamSourceOffset$.MODULE$.apply(end).logOffset()));
        FileEntry[] files = (FileEntry[])Predef$.MODULE$.refArrayOps((Object[])this.metadataLog().get((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)(startOffset + 1L))), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)))).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<FileEntry> apply(Tuple2<Object, FileEntry[]> x$3) {
                return Predef$.MODULE$.refArrayOps((Object[])x$3._2());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileEntry.class)));
        this.logInfo((Function0<String>)new Serializable(this, startOffset, endOffset, files){
            public static final long serialVersionUID = 0L;
            private final long startOffset$1;
            private final long endOffset$1;
            private final FileEntry[] files$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processing ", " files from ", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.files$1.length), BoxesRunTime.boxToLong((long)(this.startOffset$1 + 1L)), BoxesRunTime.boxToLong((long)this.endOffset$1)}));
            }
            {
                this.startOffset$1 = startOffset$1;
                this.endOffset$1 = endOffset$1;
                this.files$1 = files$1;
            }
        });
        this.logTrace((Function0<String>)new Serializable(this, files){
            public static final long serialVersionUID = 0L;
            private final FileEntry[] files$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Files are:\\n\\t"})).s((Seq)Nil$.MODULE$)).append((Object)Predef$.MODULE$.refArrayOps((Object[])this.files$1).mkString("\n\t")).toString();
            }
            {
                this.files$1 = files$1;
            }
        });
        SparkSession x$7 = this.sparkSession;
        Seq x$8 = (Seq)Predef$.MODULE$.refArrayOps((Object[])files).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(FileEntry x$4) {
                return x$4.path();
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        Some x$9 = new Some((Object)this.schema());
        Seq<String> x$10 = this.partitionColumns;
        String x$11 = this.fileFormatClassName;
        Map<String, String> x$12 = this.optionsWithPartitionBasePath();
        Option<BucketSpec> x$13 = DataSource$.MODULE$.apply$default$6();
        Option<CatalogTable> x$14 = DataSource$.MODULE$.apply$default$8();
        DataSource newDataSource = new DataSource(x$7, x$11, (Seq<String>)x$8, (Option<StructType>)x$9, x$10, x$13, x$12, x$14);
        return Dataset$.MODULE$.ofRows(this.sparkSession, (LogicalPlan)new LogicalRelation(newDataSource.resolveRelation(false), LogicalRelation$.MODULE$.apply$default$2(), LogicalRelation$.MODULE$.apply$default$3()));
    }

    private Seq<Tuple2<String, Object>> fetchAllFiles() {
        long startTime = System.nanoTime();
        Seq globbedPaths = SparkHadoopUtil$.MODULE$.get().globPathIfNecessary(this.qualifiedBasePath());
        InMemoryFileIndex catalog = new InMemoryFileIndex(this.sparkSession, (Seq<Path>)globbedPaths, this.options, (Option<StructType>)new Some((Object)new StructType()), InMemoryFileIndex$.MODULE$.$lessinit$greater$default$5());
        Seq files = (Seq)((TraversableLike)catalog.allFiles().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(FileStatus x$5) {
                return x$5.getModificationTime();
            }
        }, this.fileSortOrder())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(FileStatus status) {
                return new Tuple2((Object)status.getPath().toUri().toString(), (Object)BoxesRunTime.boxToLong((long)status.getModificationTime()));
            }
        }, Seq$.MODULE$.canBuildFrom());
        long endTime = System.nanoTime();
        double listingTimeMs = ((double)endTime - (double)startTime) / (double)1000000;
        if (listingTimeMs > (double)2000) {
            this.logWarning((Function0<String>)new Serializable(this, files, listingTimeMs){
                public static final long serialVersionUID = 0L;
                private final Seq files$2;
                private final double listingTimeMs$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Listed ", " file(s) in ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.files$2.size()), BoxesRunTime.boxToDouble((double)this.listingTimeMs$1)}));
                }
                {
                    this.files$2 = files$2;
                    this.listingTimeMs$1 = listingTimeMs$1;
                }
            });
        } else {
            this.logTrace((Function0<String>)new Serializable(this, files, listingTimeMs){
                public static final long serialVersionUID = 0L;
                private final Seq files$2;
                private final double listingTimeMs$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Listed ", " file(s) in ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.files$2.size()), BoxesRunTime.boxToDouble((double)this.listingTimeMs$1)}));
                }
                {
                    this.files$2 = files$2;
                    this.listingTimeMs$1 = listingTimeMs$1;
                }
            });
        }
        this.logTrace((Function0<String>)new Serializable(this, files){
            public static final long serialVersionUID = 0L;
            private final Seq files$2;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Files are:\\n\\t"})).s((Seq)Nil$.MODULE$)).append((Object)this.files$2.mkString("\n\t")).toString();
            }
            {
                this.files$2 = files$2;
            }
        });
        return files;
    }

    @Override
    public Option<Offset> getOffset() {
        return new Some((Object)this.fetchMaxOffset()).filterNot((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileStreamSourceOffset x$6) {
                return x$6.logOffset() == -1L;
            }
        });
    }

    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FileStreamSource[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.qualifiedBasePath()}));
    }

    @Override
    public void commit(Offset end) {
    }

    @Override
    public void stop() {
    }

    public FileStreamSource(SparkSession sparkSession, String path, String fileFormatClassName, StructType schema, Seq<String> partitionColumns, String metadataPath, Map<String, String> options) {
        Ordering ordering;
        this.sparkSession = sparkSession;
        this.fileFormatClassName = fileFormatClassName;
        this.schema = schema;
        this.partitionColumns = partitionColumns;
        this.options = options;
        Source$class.$init$(this);
        Logging.class.$init$((Logging)this);
        this.sourceOptions = new FileStreamOptions(options);
        FileSystem fs = new Path(path).getFileSystem(sparkSession.sessionState().newHadoopConf());
        this.qualifiedBasePath = fs.makeQualified(new Path(path));
        this.optionsWithPartitionBasePath = this.sourceOptions().optionMapWithoutPath().$plus$plus((GenTraversableOnce)(!SparkHadoopUtil$.MODULE$.get().isGlobPath(new Path(path)) && options.contains((Object)"path") ? Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"basePath"), (Object)path)})) : Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        this.metadataLog = new FileStreamSourceLog(FileStreamSourceLog$.MODULE$.VERSION(), sparkSession, metadataPath);
        this.org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset = BoxesRunTime.unboxToLong((Object)this.metadataLog().getLatest().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple2<Object, FileEntry[]> x$1) {
                return x$1._1$mcJ$sp();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return -1L;
            }
        }));
        this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFilesPerBatch = this.sourceOptions().maxFilesPerTrigger();
        if (this.sourceOptions().latestFirst()) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("'latestFirst' is true. New files will be processed first, which may affect the watermark\n          |value. In addition, 'maxFileAge' will be ignored.")).stripMargin();
                }
            });
            ordering = ((Ordering)Predef$.MODULE$.implicitly((Object)Ordering.Long$.MODULE$)).reverse();
        } else {
            ordering = (Ordering)Predef$.MODULE$.implicitly((Object)Ordering.Long$.MODULE$);
        }
        this.fileSortOrder = ordering;
        this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFileAgeMs = this.sourceOptions().latestFirst() && this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFilesPerBatch().isDefined() ? Long.MAX_VALUE : this.sourceOptions().maxFileAgeMs();
        this.seenFiles = new SeenFilesMap(this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFileAgeMs());
        Predef$.MODULE$.refArrayOps((Object[])this.metadataLog().allFiles()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileStreamSource $outer;

            public final void apply(FileEntry entry2) {
                this.$outer.seenFiles().add(entry2.path(), entry2.timestamp());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.seenFiles().purge();
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileStreamSource $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"maxFilesPerBatch = ", ", maxFileAgeMs = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFilesPerBatch(), BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFileAgeMs())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static class FileEntry
    implements Serializable,
    Product {
        private final String path;
        private final long timestamp;
        private final long batchId;

        public String path() {
            return this.path;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public long batchId() {
            return this.batchId;
        }

        public FileEntry copy(String path, long timestamp, long batchId) {
            return new FileEntry(path, timestamp, batchId);
        }

        public String copy$default$1() {
            return this.path();
        }

        public long copy$default$2() {
            return this.timestamp();
        }

        public long copy$default$3() {
            return this.batchId();
        }

        public String productPrefix() {
            return "FileEntry";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 2: {
                    object = BoxesRunTime.boxToLong((long)this.batchId());
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToLong((long)this.timestamp());
                    break;
                }
                case 0: {
                    object = this.path();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FileEntry;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.path()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.timestamp()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.batchId()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof FileEntry)) return false;
            boolean bl = true;
            if (!bl) return false;
            FileEntry fileEntry = (FileEntry)x$1;
            String string = this.path();
            String string2 = fileEntry.path();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.timestamp() != fileEntry.timestamp()) return false;
            if (this.batchId() != fileEntry.batchId()) return false;
            if (!fileEntry.canEqual(this)) return false;
            return true;
        }

        public FileEntry(String path, long timestamp, long batchId) {
            this.path = path;
            this.timestamp = timestamp;
            this.batchId = batchId;
            Product.class.$init$((Product)this);
        }
    }

    public static class SeenFilesMap {
        private final long maxAgeMs;
        private final HashMap<String, Object> map;
        private long latestTimestamp;
        private long lastPurgeTimestamp;

        private HashMap<String, Object> map() {
            return this.map;
        }

        private long latestTimestamp() {
            return this.latestTimestamp;
        }

        private void latestTimestamp_$eq(long x$1) {
            this.latestTimestamp = x$1;
        }

        private long lastPurgeTimestamp() {
            return this.lastPurgeTimestamp;
        }

        private void lastPurgeTimestamp_$eq(long x$1) {
            this.lastPurgeTimestamp = x$1;
        }

        public void add(String path, long timestamp) {
            this.map().put(path, BoxesRunTime.boxToLong((long)timestamp));
            if (timestamp > this.latestTimestamp()) {
                this.latestTimestamp_$eq(timestamp);
            }
        }

        public boolean isNewFile(String path, long timestamp) {
            return timestamp >= this.lastPurgeTimestamp() && !this.map().containsKey(path);
        }

        /*
         * WARNING - void declaration
         */
        public int purge() {
            void var2_2;
            this.lastPurgeTimestamp_$eq(this.latestTimestamp() - this.maxAgeMs);
            java.util.Iterator<Map.Entry<String, Object>> iter = this.map().entrySet().iterator();
            int count2 = 0;
            while (iter.hasNext()) {
                Map.Entry<String, Object> entry2 = iter.next();
                if (BoxesRunTime.unboxToLong((Object)entry2.getValue()) >= this.lastPurgeTimestamp()) continue;
                ++count2;
                iter.remove();
            }
            return (int)var2_2;
        }

        public int size() {
            return this.map().size();
        }

        public Seq<Tuple2<String, Object>> allEntries() {
            return ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.map()).asScala()).toSeq();
        }

        public SeenFilesMap(long maxAgeMs) {
            this.maxAgeMs = maxAgeMs;
            Predef$.MODULE$.require(maxAgeMs >= 0L);
            this.map = new HashMap();
            this.latestTimestamp = 0L;
            this.lastPurgeTimestamp = 0L;
        }
    }
}

