/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.Footer;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.parser.LegacyTypeStringParser$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat$$anonfun$10$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat$$anonfun$org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaConverter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.StringBuilder;
import scala.collection.parallel.ForkJoinTaskSupport;
import scala.collection.parallel.ParIterableLike;
import scala.collection.parallel.ParSeq;
import scala.collection.parallel.ParSeq$;
import scala.collection.parallel.TaskSupport;
import scala.concurrent.forkjoin.ForkJoinPool;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Try$;

public final class ParquetFileFormat$
implements Logging,
Serializable {
    public static final ParquetFileFormat$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private transient int org$apache$spark$internal$Logging$$levelFlags;

    static {
        new ParquetFileFormat$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int org$apache$spark$internal$Logging$$levelFlags() {
        return this.org$apache$spark$internal$Logging$$levelFlags;
    }

    public void org$apache$spark$internal$Logging$$levelFlags_$eq(int x$1) {
        this.org$apache$spark$internal$Logging$$levelFlags = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public final boolean isInfoEnabled() {
        return Logging.class.isInfoEnabled((Logging)this);
    }

    public final boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public final boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public Option<StructType> readSchema(Seq<Footer> footers, SparkSession sparkSession) {
        HashSet seen = (HashSet)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$);
        Seq finalSchemas = (Seq)footers.flatMap((Function1)new Serializable(sparkSession, seen){
            public static final long serialVersionUID = 0L;
            public final SparkSession sparkSession$1;
            private final HashSet seen$1;

            public final Iterable<StructType> apply(Footer footer) {
                Iterable iterable;
                FileMetaData metadata = footer.getParquetMetadata().getFileMetaData();
                Option serializedSchema = ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(metadata.getKeyValueMetaData()).asScala()).toMap(Predef$.MODULE$.$conforms()).get((Object)ParquetReadSupport$.MODULE$.SPARK_METADATA_KEY());
                if (serializedSchema.isEmpty()) {
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)ParquetFileFormat$.MODULE$.org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$$parseParquetSchema$1(metadata.getSchema(), this.sparkSession$1)));
                } else if (this.seen$1.contains(serializedSchema.get())) {
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                } else {
                    this.seen$1.$plus$eq(serializedSchema.get());
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some(Try$.MODULE$.apply((Function0)new Serializable(this, serializedSchema){
                        public static final long serialVersionUID = 0L;
                        private final Option serializedSchema$1;

                        public final DataType apply() {
                            return DataType$.MODULE$.fromJson((String)this.serializedSchema$1.get());
                        }
                        {
                            this.serializedSchema$1 = serializedSchema$1;
                        }
                    }).recover((PartialFunction)new Serializable(this, serializedSchema){
                        public static final long serialVersionUID = 0L;
                        private final Option serializedSchema$1;

                        public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            Object object;
                            A1 A1 = x1;
                            if (A1 != null) {
                                ParquetFileFormat$.MODULE$.logInfo((Function0<String>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "Serialized Spark schema in Parquet key-value metadata is not in JSON format, falling back to the deprecated DataType.fromCaseClassString parser.";
                                    }
                                });
                                object = LegacyTypeStringParser$.MODULE$.parse((String)this.serializedSchema$1.get());
                            } else {
                                object = function1.apply(x1);
                            }
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Throwable x1) {
                            Throwable throwable = x1;
                            boolean bl = throwable != null;
                            return bl;
                        }
                        {
                            this.serializedSchema$1 = serializedSchema$1;
                        }
                    }).recover((PartialFunction)new Serializable(this, serializedSchema){
                        public static final long serialVersionUID = 0L;
                        public final Option serializedSchema$1;

                        public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                            Object object;
                            A1 A1 = x2;
                            if (A1 != null) {
                                A1 A12 = A1;
                                ParquetFileFormat$.MODULE$.logWarning((Function0<String>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun$10$$anonfun$apply$2 $outer;

                                    public final String apply() {
                                        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to parse serialized Spark schema in Parquet key-value metadata:\n                 |\\t", "\n               "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.serializedSchema$1})))).stripMargin();
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                }, A12);
                                object = BoxedUnit.UNIT;
                            } else {
                                object = function1.apply(x2);
                            }
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Throwable x2) {
                            Throwable throwable = x2;
                            boolean bl = throwable != null;
                            return bl;
                        }
                        {
                            this.serializedSchema$1 = serializedSchema$1;
                        }
                    }).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final StructType apply(Object x$9) {
                            return (StructType)x$9;
                        }
                    }).getOrElse((Function0)new Serializable(this, metadata){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.10 $outer;
                        private final FileMetaData metadata$1;

                        public final StructType apply() {
                            return ParquetFileFormat$.MODULE$.org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$$parseParquetSchema$1(this.metadata$1.getSchema(), this.$outer.sparkSession$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.metadata$1 = metadata$1;
                        }
                    })));
                }
                return iterable;
            }
            {
                this.sparkSession$1 = sparkSession$1;
                this.seen$1 = seen$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return finalSchemas.reduceOption((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final StructType apply(StructType left, StructType right) {
                try {
                    return left.merge(right);
                }
                catch (Throwable throwable) {
                    throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to merge incompatible schemas ", " and ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{left, right})), throwable);
                }
            }
        });
    }

    public Seq<Footer> readParquetFootersInParallel(Configuration conf, Seq<FileStatus> partFiles, boolean ignoreCorruptFiles) {
        ParSeq parFiles = (ParSeq)partFiles.par();
        parFiles.tasksupport_$eq((TaskSupport)new ForkJoinTaskSupport(new ForkJoinPool(8)));
        return (Seq)((ParIterableLike)parFiles.flatMap((Function1)new Serializable(conf, ignoreCorruptFiles){
            public static final long serialVersionUID = 0L;
            private final Configuration conf$1;
            private final boolean ignoreCorruptFiles$1;

            public final Iterable<Footer> apply(FileStatus currentFile) {
                RuntimeException runtimeException2;
                block2: {
                    Iterable iterable;
                    try {
                        iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)new Footer(currentFile.getPath(), ParquetFileReader.readFooter((Configuration)this.conf$1, (FileStatus)currentFile, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.SKIP_ROW_GROUPS))));
                    }
                    catch (RuntimeException runtimeException2) {
                        if (!this.ignoreCorruptFiles$1) break block2;
                        ParquetFileFormat$.MODULE$.logWarning((Function0<String>)new Serializable(this, currentFile){
                            public static final long serialVersionUID = 0L;
                            private final FileStatus currentFile$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Skipped the footer in the corrupted file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.currentFile$1}));
                            }
                            {
                                this.currentFile$1 = currentFile$1;
                            }
                        }, runtimeException2);
                        iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    }
                    return iterable;
                }
                throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not read footer for file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{currentFile})), runtimeException2);
            }
            {
                this.conf$1 = conf$1;
                this.ignoreCorruptFiles$1 = ignoreCorruptFiles$1;
            }
        }, (CanBuildFrom)ParSeq$.MODULE$.canBuildFrom())).seq();
    }

    public Option<StructType> mergeSchemasInParallel(Seq<FileStatus> filesToTouch, SparkSession sparkSession) {
        None$ none$;
        boolean x$11;
        Serializable x$10;
        boolean assumeBinaryIsString = sparkSession.sessionState().conf().isParquetBinaryAsString();
        boolean assumeInt96IsTimestamp = sparkSession.sessionState().conf().isParquetINT96AsTimestamp();
        boolean writeLegacyParquetFormat = sparkSession.sessionState().conf().writeLegacyParquetFormat();
        SerializableConfiguration serializedConf = new SerializableConfiguration(sparkSession.sessionState().newHadoopConf());
        Seq partialFileStatusInfo = (Seq)filesToTouch.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(FileStatus f) {
                return new Tuple2((Object)f.getPath().toString(), (Object)BoxesRunTime.boxToLong((long)f.getLen()));
            }
        }, Seq$.MODULE$.canBuildFrom());
        int numParallelism = Math.min(Math.max(partialFileStatusInfo.size(), 1), sparkSession.sparkContext().defaultParallelism());
        boolean ignoreCorruptFiles = sparkSession.sessionState().conf().ignoreCorruptFiles();
        RDD qual$1 = sparkSession.sparkContext().parallelize(partialFileStatusInfo, numParallelism, ClassTag$.MODULE$.apply(Tuple2.class));
        StructType[] partiallyMergedSchemas = (StructType[])qual$1.mapPartitions((Function1)(x$10 = new Serializable(assumeBinaryIsString, assumeInt96IsTimestamp, writeLegacyParquetFormat, serializedConf, ignoreCorruptFiles){
            public static final long serialVersionUID = 0L;
            private final boolean assumeBinaryIsString$1;
            private final boolean assumeInt96IsTimestamp$1;
            private final boolean writeLegacyParquetFormat$1;
            private final SerializableConfiguration serializedConf$1;
            private final boolean ignoreCorruptFiles$2;

            public final Iterator<StructType> apply(Iterator<Tuple2<String, Object>> iterator2) {
                Iterator iterator3;
                Seq fakeFileStatuses = iterator2.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final FileStatus apply(Tuple2<String, Object> x0$1) {
                        Tuple2<String, Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            String path = (String)tuple2._1();
                            long length = tuple2._2$mcJ$sp();
                            FileStatus fileStatus = new FileStatus(length, false, 0, 0L, 0L, 0L, null, null, null, new Path(path));
                            return fileStatus;
                        }
                        throw new MatchError(tuple2);
                    }
                }).toSeq();
                Seq<Footer> footers = ParquetFileFormat$.MODULE$.readParquetFootersInParallel(this.serializedConf$1.value(), (Seq<FileStatus>)fakeFileStatuses, this.ignoreCorruptFiles$2);
                ParquetSchemaConverter converter = new ParquetSchemaConverter(this.assumeBinaryIsString$1, this.assumeInt96IsTimestamp$1, this.writeLegacyParquetFormat$1);
                if (footers.isEmpty()) {
                    iterator3 = package$.MODULE$.Iterator().empty();
                } else {
                    ObjectRef mergedSchema = ObjectRef.create((Object)ParquetFileFormat$.MODULE$.readSchemaFromFooter((Footer)footers.head(), converter));
                    ((IterableLike)footers.tail()).foreach((Function1)new Serializable(this, converter, mergedSchema){
                        public static final long serialVersionUID = 0L;
                        private final ParquetSchemaConverter converter$1;
                        private final ObjectRef mergedSchema$1;

                        public final void apply(Footer footer) {
                            StructType schema = ParquetFileFormat$.MODULE$.readSchemaFromFooter(footer, this.converter$1);
                            try {
                                this.mergedSchema$1.elem = ((StructType)this.mergedSchema$1.elem).merge(schema);
                                return;
                            }
                            catch (SparkException sparkException) {
                                throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed merging schema of file ", ":\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{footer.getFile(), schema.treeString()})), (Throwable)sparkException);
                            }
                        }
                        {
                            this.converter$1 = converter$1;
                            this.mergedSchema$1 = mergedSchema$1;
                        }
                    });
                    iterator3 = package$.MODULE$.Iterator().single((Object)((StructType)mergedSchema.elem));
                }
                return iterator3;
            }
            {
                this.assumeBinaryIsString$1 = assumeBinaryIsString$1;
                this.assumeInt96IsTimestamp$1 = assumeInt96IsTimestamp$1;
                this.writeLegacyParquetFormat$1 = writeLegacyParquetFormat$1;
                this.serializedConf$1 = serializedConf$1;
                this.ignoreCorruptFiles$2 = ignoreCorruptFiles$2;
            }
        }), x$11 = qual$1.mapPartitions$default$2(), ClassTag$.MODULE$.apply(StructType.class)).collect();
        if (Predef$.MODULE$.refArrayOps((Object[])partiallyMergedSchemas).isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            ObjectRef finalSchema = ObjectRef.create((Object)((StructType)Predef$.MODULE$.refArrayOps((Object[])partiallyMergedSchemas).head()));
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])partiallyMergedSchemas).tail()).foreach((Function1)new Serializable(finalSchema){
                public static final long serialVersionUID = 0L;
                private final ObjectRef finalSchema$1;

                public final void apply(StructType schema) {
                    try {
                        this.finalSchema$1.elem = ((StructType)this.finalSchema$1.elem).merge(schema);
                        return;
                    }
                    catch (SparkException sparkException) {
                        throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed merging schema:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{schema.treeString()})), (Throwable)sparkException);
                    }
                }
                {
                    this.finalSchema$1 = finalSchema$1;
                }
            });
            none$ = new Some((Object)((StructType)finalSchema.elem));
        }
        return none$;
    }

    public StructType readSchemaFromFooter(Footer footer, ParquetSchemaConverter converter) {
        FileMetaData fileMetaData = footer.getParquetMetadata().getFileMetaData();
        return (StructType)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(fileMetaData.getKeyValueMetaData()).asScala()).toMap(Predef$.MODULE$.$conforms()).get((Object)ParquetReadSupport$.MODULE$.SPARK_METADATA_KEY()).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<StructType> apply(String schemaString2) {
                return ParquetFileFormat$.MODULE$.org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$$deserializeSchemaString(schemaString2);
            }
        }).getOrElse((Function0)new Serializable(converter, fileMetaData){
            public static final long serialVersionUID = 0L;
            private final ParquetSchemaConverter converter$2;
            private final FileMetaData fileMetaData$1;

            public final StructType apply() {
                return this.converter$2.convert(this.fileMetaData$1.getSchema());
            }
            {
                this.converter$2 = converter$2;
                this.fileMetaData$1 = fileMetaData$1;
            }
        });
    }

    public Option<StructType> org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$$deserializeSchemaString(String schemaString2) {
        return Try$.MODULE$.apply((Function0)new Serializable(schemaString2){
            public static final long serialVersionUID = 0L;
            private final String schemaString$1;

            public final StructType apply() {
                return (StructType)DataType$.MODULE$.fromJson(this.schemaString$1);
            }
            {
                this.schemaString$1 = schemaString$1;
            }
        }).recover((PartialFunction)new Serializable(schemaString2){
            public static final long serialVersionUID = 0L;
            private final String schemaString$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x3;
                if (A1 != null) {
                    ParquetFileFormat$.MODULE$.logInfo((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Serialized Spark schema in Parquet key-value metadata is not in JSON format, falling back to the deprecated DataType.fromCaseClassString parser.";
                        }
                    });
                    object = (StructType)LegacyTypeStringParser$.MODULE$.parse(this.schemaString$1);
                } else {
                    object = function1.apply(x3);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x3) {
                Throwable throwable = x3;
                boolean bl = throwable != null;
                return bl;
            }
            {
                this.schemaString$1 = schemaString$1;
            }
        }).recoverWith((PartialFunction)new Serializable(schemaString2){
            public static final long serialVersionUID = 0L;
            public final String schemaString$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x4;
                if (A1 != null) {
                    A1 A12 = A1;
                    ParquetFileFormat$.MODULE$.logWarning((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun$org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$$deserializeSchemaString$2 $outer;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Failed to parse and ignored serialized Spark schema in ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Parquet key-value metadata:\\n\\t", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.schemaString$1}))).toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, A12);
                    object = new Failure(A12);
                } else {
                    object = function1.apply(x4);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x4) {
                Throwable throwable = x4;
                boolean bl = throwable != null;
                return bl;
            }
            {
                this.schemaString$1 = schemaString$1;
            }
        }).toOption();
    }

    private Object readResolve() {
        return MODULE$;
    }

    public final StructType org$apache$spark$sql$execution$datasources$parquet$ParquetFileFormat$$parseParquetSchema$1(MessageType schema, SparkSession sparkSession$1) {
        ParquetSchemaConverter converter = new ParquetSchemaConverter(sparkSession$1.sessionState().conf().isParquetBinaryAsString(), sparkSession$1.sessionState().conf().isParquetBinaryAsString(), sparkSession$1.sessionState().conf().writeLegacyParquetFormat());
        return converter.convert(schema);
    }

    private ParquetFileFormat$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

