/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.jdbc;

import org.apache.spark.Partition;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCPartition;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCPartitioningInfo;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRelation;
import org.slf4j.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class JDBCRelation$
implements Logging,
Serializable {
    public static final JDBCRelation$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private transient int org$apache$spark$internal$Logging$$levelFlags;

    static {
        new JDBCRelation$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int org$apache$spark$internal$Logging$$levelFlags() {
        return this.org$apache$spark$internal$Logging$$levelFlags;
    }

    public void org$apache$spark$internal$Logging$$levelFlags_$eq(int x$1) {
        this.org$apache$spark$internal$Logging$$levelFlags = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public final boolean isInfoEnabled() {
        return Logging.class.isInfoEnabled((Logging)this);
    }

    public final boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public final boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public Partition[] columnPartition(JDBCPartitioningInfo partitioning) {
        long l;
        long upperBound;
        if (partitioning == null || partitioning.numPartitions() <= 1 || partitioning.lowerBound() == partitioning.upperBound()) {
            return (Partition[])((Object[])new Partition[]{new JDBCPartition(null, 0)});
        }
        long lowerBound = partitioning.lowerBound();
        Predef$.MODULE$.require(lowerBound <= (upperBound = partitioning.upperBound()), (Function0)new Serializable(lowerBound, upperBound){
            public static final long serialVersionUID = 0L;
            private final long lowerBound$1;
            private final long upperBound$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Operation not allowed: the lower bound of partitioning column is larger than the upper ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bound. Lower bound: ", "; Upper bound: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.lowerBound$1), BoxesRunTime.boxToLong((long)this.upperBound$1)}))).toString();
            }
            {
                this.lowerBound$1 = lowerBound$1;
                this.upperBound$1 = upperBound$1;
            }
        });
        if (upperBound - lowerBound >= (long)partitioning.numPartitions()) {
            l = partitioning.numPartitions();
        } else {
            this.logWarning((Function0<String>)new Serializable(partitioning, lowerBound, upperBound){
                public static final long serialVersionUID = 0L;
                private final JDBCPartitioningInfo partitioning$1;
                private final long lowerBound$1;
                private final long upperBound$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"The number of partitions is reduced because the specified number of partitions is less than the difference between upper bound and lower bound. ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updated number of partitions: ", "; Input number of "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(this.upperBound$1 - this.lowerBound$1))}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partitions: ", "; Lower bound: ", "; "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.partitioning$1.numPartitions()), BoxesRunTime.boxToLong((long)this.lowerBound$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Upper bound: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.upperBound$1)}))).toString();
                }
                {
                    this.partitioning$1 = partitioning$1;
                    this.lowerBound$1 = lowerBound$1;
                    this.upperBound$1 = upperBound$1;
                }
            });
            l = upperBound - lowerBound;
        }
        long numPartitions = l;
        long stride = upperBound / numPartitions - lowerBound / numPartitions;
        String column = partitioning.column();
        int i = 0;
        long currentValue = lowerBound;
        ArrayBuffer ans = new ArrayBuffer();
        while ((long)i < numPartitions) {
            String uBound;
            String lBound = i != 0 ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " >= ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{column, BoxesRunTime.boxToLong((long)currentValue)})) : null;
            String string = uBound = (long)i != numPartitions - 1L ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " < ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{column, BoxesRunTime.boxToLong((long)(currentValue += stride))})) : null;
            String whereClause = uBound == null ? lBound : (lBound == null ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " or ", " is null"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uBound, column})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " AND ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{lBound, uBound})));
            ans.$plus$eq((Object)new JDBCPartition(whereClause, i));
            ++i;
        }
        return (Partition[])ans.toArray(ClassTag$.MODULE$.apply(Partition.class));
    }

    public JDBCRelation apply(Partition[] parts, JDBCOptions jdbcOptions, SparkSession sparkSession) {
        return new JDBCRelation(parts, jdbcOptions, sparkSession);
    }

    public Option<Tuple2<Partition[], JDBCOptions>> unapply(JDBCRelation x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)x$0.parts(), (Object)x$0.jdbcOptions()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private JDBCRelation$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

