/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.util.Date;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.spark.SparkException;
import org.apache.spark.SparkHadoopWriter$;
import org.apache.spark.TaskContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.io.FileCommitProtocol;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.AttributeSet$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileFormatWriter;
import org.apache.spark.sql.execution.datasources.FileFormatWriter$;
import org.apache.spark.sql.execution.datasources.FileFormatWriter$$anonfun$org$apache$spark$sql$execution$datasources$FileFormatWriter$;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitioningUtils$;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class FileFormatWriter$
implements Logging {
    public static final FileFormatWriter$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private transient int org$apache$spark$internal$Logging$$levelFlags;

    static {
        new FileFormatWriter$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int org$apache$spark$internal$Logging$$levelFlags() {
        return this.org$apache$spark$internal$Logging$$levelFlags;
    }

    public void org$apache$spark$internal$Logging$$levelFlags_$eq(int x$1) {
        this.org$apache$spark$internal$Logging$$levelFlags = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public final boolean isInfoEnabled() {
        return Logging.class.isInfoEnabled((Logging)this);
    }

    public final boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public final boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public void write(SparkSession sparkSession, QueryExecution queryExecution, FileFormat fileFormat, FileCommitProtocol committer, FileFormatWriter.OutputSpec outputSpec, Configuration hadoopConf, Seq<Attribute> partitionColumns, Option<BucketSpec> bucketSpec, Function1<Seq<Map<String, String>>, BoxedUnit> refreshFunction, Map<String, String> options) {
        Job job = Job.getInstance((Configuration)hadoopConf);
        job.setOutputKeyClass(Void.class);
        job.setOutputValueClass(InternalRow.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(outputSpec.outputPath()));
        AttributeSet partitionSet = AttributeSet$.MODULE$.apply(partitionColumns);
        Seq dataColumns = (Seq)queryExecution.logical().output().filterNot((Function1)new Serializable(partitionSet){
            public static final long serialVersionUID = 0L;
            private final AttributeSet partitionSet$1;

            public final boolean apply(NamedExpression elem) {
                return this.partitionSet$1.contains(elem);
            }
            {
                this.partitionSet$1 = partitionSet$1;
            }
        });
        OutputWriterFactory outputWriterFactory = fileFormat.prepareWrite(sparkSession, job, options, package$.MODULE$.AttributeSeq(dataColumns).toStructType());
        FileFormatWriter.WriteJobDescription description = new FileFormatWriter.WriteJobDescription(UUID.randomUUID().toString(), new SerializableConfiguration(job.getConfiguration()), outputWriterFactory, (Seq<Attribute>)queryExecution.logical().output(), partitionColumns, (Seq<Attribute>)dataColumns, bucketSpec, outputSpec.outputPath(), outputSpec.customPartitionLocations());
        SQLExecution$.MODULE$.withNewExecutionId(sparkSession, queryExecution, new Serializable(sparkSession, queryExecution, committer, refreshFunction, job, description){
            public static final long serialVersionUID = 0L;
            private final SparkSession sparkSession$1;
            private final QueryExecution queryExecution$1;
            public final FileCommitProtocol committer$1;
            private final Function1 refreshFunction$1;
            public final Job job$1;
            public final FileFormatWriter.WriteJobDescription description$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.committer$1.setupJob((JobContext)this.job$1);
                try {
                    Tuple2[] ret = (Tuple2[])this.sparkSession$1.sparkContext().runJob(this.queryExecution$1.toRdd(), (Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.write.1 $outer;

                        public final Tuple2<FileCommitProtocol.TaskCommitMessage, Set<String>> apply(TaskContext taskContext, Iterator<InternalRow> iter) {
                            return FileFormatWriter$.MODULE$.org$apache$spark$sql$execution$datasources$FileFormatWriter$$executeTask(this.$outer.description$1, taskContext.stageId(), taskContext.partitionId(), taskContext.attemptNumber(), this.$outer.committer$1, iter);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, ClassTag$.MODULE$.apply(Tuple2.class));
                    FileCommitProtocol.TaskCommitMessage[] commitMsgs = (FileCommitProtocol.TaskCommitMessage[])Predef$.MODULE$.refArrayOps((Object[])ret).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final FileCommitProtocol.TaskCommitMessage apply(Tuple2<FileCommitProtocol.TaskCommitMessage, Set<String>> x$1) {
                            return (FileCommitProtocol.TaskCommitMessage)x$1._1();
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileCommitProtocol.TaskCommitMessage.class)));
                    Map[] updatedPartitions = (Map[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])ret).flatMap((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Set<String> apply(Tuple2<FileCommitProtocol.TaskCommitMessage, Set<String>> x$2) {
                            return (Set)x$2._2();
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).distinct()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Map<String, String> apply(String pathFragment) {
                            return PartitioningUtils$.MODULE$.parsePathFragment(pathFragment);
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Map.class)));
                    this.committer$1.commitJob((JobContext)this.job$1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])commitMsgs));
                    FileFormatWriter$.MODULE$.logInfo((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.write.1 $outer;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Job ", " committed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.job$1.getJobID()}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    this.refreshFunction$1.apply((Object)Predef$.MODULE$.wrapRefArray((Object[])updatedPartitions));
                    return;
                }
                catch (Throwable throwable) {
                    FileFormatWriter$.MODULE$.logError((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.write.1 $outer;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Aborting job ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.job$1.getJobID()}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, throwable);
                    this.committer$1.abortJob((JobContext)this.job$1);
                    throw new SparkException("Job aborted.", throwable);
                }
            }
            {
                this.sparkSession$1 = sparkSession$1;
                this.queryExecution$1 = queryExecution$1;
                this.committer$1 = committer$1;
                this.refreshFunction$1 = refreshFunction$1;
                this.job$1 = job$1;
                this.description$1 = description$1;
            }
        });
    }

    public Tuple2<FileCommitProtocol.TaskCommitMessage, Set<String>> org$apache$spark$sql$execution$datasources$FileFormatWriter$$executeTask(FileFormatWriter.WriteJobDescription description, int sparkStageId, int sparkPartitionId, int sparkAttemptNumber, FileCommitProtocol committer, Iterator<InternalRow> iterator2) {
        JobID jobId = SparkHadoopWriter$.MODULE$.createJobID(new Date(), sparkStageId);
        TaskID taskId = new TaskID((org.apache.hadoop.mapreduce.JobID)jobId, TaskType.MAP, sparkPartitionId);
        TaskAttemptID taskAttemptId = new TaskAttemptID(taskId, sparkAttemptNumber);
        Configuration hadoopConf = description.serializableHadoopConf().value();
        hadoopConf.set("mapred.job.id", jobId.toString());
        hadoopConf.set("mapred.tip.id", taskAttemptId.getTaskID().toString());
        hadoopConf.set("mapred.task.id", taskAttemptId.toString());
        hadoopConf.setBoolean("mapred.task.is.map", true);
        hadoopConf.setInt("mapred.task.partition", 0);
        TaskAttemptContextImpl taskAttemptContext = new TaskAttemptContextImpl(hadoopConf, taskAttemptId);
        committer.setupTask((TaskAttemptContext)taskAttemptContext);
        FileFormatWriter.ExecuteWriteTask writeTask = description.partitionColumns().isEmpty() && description.bucketSpec().isEmpty() ? new FileFormatWriter.SingleDirectoryWriteTask(description, (TaskAttemptContext)taskAttemptContext, committer) : new FileFormatWriter.DynamicPartitionWriteTask(description, (TaskAttemptContext)taskAttemptContext, committer);
        try {
            Serializable x$5 = new Serializable(committer, iterator2, (TaskAttemptContext)taskAttemptContext, writeTask){
                public static final long serialVersionUID = 0L;
                private final FileCommitProtocol committer$2;
                private final Iterator iterator$1;
                private final TaskAttemptContext taskAttemptContext$1;
                private final FileFormatWriter.ExecuteWriteTask writeTask$1;

                public final Tuple2<FileCommitProtocol.TaskCommitMessage, Set<String>> apply() {
                    Set<String> outputPartitions = this.writeTask$1.execute((Iterator<InternalRow>)this.iterator$1);
                    this.writeTask$1.releaseResources();
                    return new Tuple2((Object)this.committer$2.commitTask(this.taskAttemptContext$1), outputPartitions);
                }
                {
                    this.committer$2 = committer$2;
                    this.iterator$1 = iterator$1;
                    this.taskAttemptContext$1 = taskAttemptContext$1;
                    this.writeTask$1 = writeTask$1;
                }
            };
            Serializable x$6 = new Serializable(committer, jobId, (TaskAttemptContext)taskAttemptContext, writeTask){
                public static final long serialVersionUID = 0L;
                private final FileCommitProtocol committer$2;
                public final JobID jobId$1;
                private final TaskAttemptContext taskAttemptContext$1;
                private final FileFormatWriter.ExecuteWriteTask writeTask$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    try {
                        this.writeTask$1.releaseResources();
                    }
                    catch (Throwable throwable) {
                        this.committer$2.abortTask(this.taskAttemptContext$1);
                        FileFormatWriter$.MODULE$.logError((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$org$apache$spark$sql$execution$datasources$FileFormatWriter$$executeTask$1 $outer;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Job ", " aborted."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.jobId$1}));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        throw throwable;
                    }
                    this.committer$2.abortTask(this.taskAttemptContext$1);
                    FileFormatWriter$.MODULE$.logError((Function0<String>)new /* invalid duplicate definition of identical inner class */);
                }
                {
                    this.committer$2 = committer$2;
                    this.jobId$1 = jobId$1;
                    this.taskAttemptContext$1 = taskAttemptContext$1;
                    this.writeTask$1 = writeTask$1;
                }
            };
            Serializable x$7 = new Serializable((Function0)x$5){
                public static final long serialVersionUID = 0L;
                private final Function0 x$5$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    Utils$.MODULE$.tryWithSafeFinallyAndFailureCallbacks$default$3(this.x$5$1);
                }
                {
                    this.x$5$1 = x$5$1;
                }
            };
            return (Tuple2)Utils$.MODULE$.tryWithSafeFinallyAndFailureCallbacks((Function0)x$5, (Function0)x$6, (Function0)x$7);
        }
        catch (Throwable throwable) {
            throw new SparkException("Task failed while writing rows", throwable);
        }
    }

    private FileFormatWriter$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

