/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.csv;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.execution.datasources.csv.CSVOptions;
import org.apache.spark.sql.execution.datasources.csv.CSVOptions$;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

public final class CSVTypeCast$ {
    public static final CSVTypeCast$ MODULE$;

    static {
        new CSVTypeCast$();
    }

    public Object castTo(String datum, DataType castType, boolean nullable, CSVOptions options) {
        while (true) {
            DataType dataType;
            block25: {
                Byte by;
                block13: {
                    Object object;
                    block15: {
                        block24: {
                            block23: {
                                block22: {
                                    block21: {
                                        block20: {
                                            Object object2;
                                            block19: {
                                                Object object3;
                                                block18: {
                                                    block17: {
                                                        block16: {
                                                            block14: {
                                                                block12: {
                                                                    if (!nullable) break block12;
                                                                    String string = datum;
                                                                    String string2 = options.nullValue();
                                                                    if (string != null ? !string.equals(string2) : string2 != null) break block12;
                                                                    by = null;
                                                                    break block13;
                                                                }
                                                                if (!((dataType = castType) instanceof ByteType)) break block14;
                                                                object = BoxesRunTime.boxToByte((byte)new StringOps(Predef$.MODULE$.augmentString(datum)).toByte());
                                                                break block15;
                                                            }
                                                            if (!(dataType instanceof ShortType)) break block16;
                                                            object = BoxesRunTime.boxToShort((short)new StringOps(Predef$.MODULE$.augmentString(datum)).toShort());
                                                            break block15;
                                                        }
                                                        if (!(dataType instanceof IntegerType)) break block17;
                                                        object = BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(datum)).toInt());
                                                        break block15;
                                                    }
                                                    if (!(dataType instanceof LongType)) break block18;
                                                    object = BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(datum)).toLong());
                                                    break block15;
                                                }
                                                if (!(dataType instanceof FloatType)) break block19;
                                                String string = datum;
                                                String string3 = options.nanValue();
                                                String string4 = string;
                                                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                                                    object3 = BoxesRunTime.boxToFloat((float)Float.NaN);
                                                } else {
                                                    String string5 = options.negativeInf();
                                                    String string6 = string;
                                                    if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                                                        object3 = BoxesRunTime.boxToFloat((float)Float.NEGATIVE_INFINITY);
                                                    } else {
                                                        String string7 = options.positiveInf();
                                                        String string8 = string;
                                                        object3 = !(string7 != null ? !string7.equals(string8) : string8 != null) ? BoxesRunTime.boxToFloat((float)Float.POSITIVE_INFINITY) : Try$.MODULE$.apply((Function0)new Serializable(datum){
                                                            public static final long serialVersionUID = 0L;
                                                            private final String datum$1;

                                                            public final float apply() {
                                                                return this.apply$mcF$sp();
                                                            }

                                                            public float apply$mcF$sp() {
                                                                return new StringOps(Predef$.MODULE$.augmentString(this.datum$1)).toFloat();
                                                            }
                                                            {
                                                                this.datum$1 = datum$1;
                                                            }
                                                        }).getOrElse((Function0)new Serializable(datum){
                                                            public static final long serialVersionUID = 0L;
                                                            private final String datum$1;

                                                            public final float apply() {
                                                                return this.apply$mcF$sp();
                                                            }

                                                            public float apply$mcF$sp() {
                                                                return NumberFormat.getInstance(Locale.getDefault()).parse(this.datum$1).floatValue();
                                                            }
                                                            {
                                                                this.datum$1 = datum$1;
                                                            }
                                                        });
                                                    }
                                                }
                                                object = object3;
                                                break block15;
                                            }
                                            if (!(dataType instanceof DoubleType)) break block20;
                                            String string = datum;
                                            String string9 = options.nanValue();
                                            String string10 = string;
                                            if (!(string9 != null ? !string9.equals(string10) : string10 != null)) {
                                                object2 = BoxesRunTime.boxToDouble((double)Double.NaN);
                                            } else {
                                                String string11 = options.negativeInf();
                                                String string12 = string;
                                                if (!(string11 != null ? !string11.equals(string12) : string12 != null)) {
                                                    object2 = BoxesRunTime.boxToDouble((double)Double.NEGATIVE_INFINITY);
                                                } else {
                                                    String string13 = options.positiveInf();
                                                    String string14 = string;
                                                    object2 = !(string13 != null ? !string13.equals(string14) : string14 != null) ? BoxesRunTime.boxToDouble((double)Double.POSITIVE_INFINITY) : Try$.MODULE$.apply((Function0)new Serializable(datum){
                                                        public static final long serialVersionUID = 0L;
                                                        private final String datum$1;

                                                        public final double apply() {
                                                            return this.apply$mcD$sp();
                                                        }

                                                        public double apply$mcD$sp() {
                                                            return new StringOps(Predef$.MODULE$.augmentString(this.datum$1)).toDouble();
                                                        }
                                                        {
                                                            this.datum$1 = datum$1;
                                                        }
                                                    }).getOrElse((Function0)new Serializable(datum){
                                                        public static final long serialVersionUID = 0L;
                                                        private final String datum$1;

                                                        public final double apply() {
                                                            return this.apply$mcD$sp();
                                                        }

                                                        public double apply$mcD$sp() {
                                                            return NumberFormat.getInstance(Locale.getDefault()).parse(this.datum$1).doubleValue();
                                                        }
                                                        {
                                                            this.datum$1 = datum$1;
                                                        }
                                                    });
                                                }
                                            }
                                            object = object2;
                                            break block15;
                                        }
                                        if (!(dataType instanceof BooleanType)) break block21;
                                        object = BoxesRunTime.boxToBoolean((boolean)new StringOps(Predef$.MODULE$.augmentString(datum)).toBoolean());
                                        break block15;
                                    }
                                    if (!(dataType instanceof DecimalType)) break block22;
                                    DecimalType decimalType = (DecimalType)dataType;
                                    BigDecimal value = new BigDecimal(datum.replaceAll(",", ""));
                                    object = Decimal$.MODULE$.apply(value, decimalType.precision(), decimalType.scale());
                                    break block15;
                                }
                                if (!(dataType instanceof TimestampType)) break block23;
                                object = Try$.MODULE$.apply((Function0)new Serializable(datum, options){
                                    public static final long serialVersionUID = 0L;
                                    private final String datum$1;
                                    private final CSVOptions options$4;

                                    public final long apply() {
                                        return this.apply$mcJ$sp();
                                    }

                                    public long apply$mcJ$sp() {
                                        return this.options$4.timestampFormat().parse(this.datum$1).getTime() * 1000L;
                                    }
                                    {
                                        this.datum$1 = datum$1;
                                        this.options$4 = options$4;
                                    }
                                }).getOrElse((Function0)new Serializable(datum){
                                    public static final long serialVersionUID = 0L;
                                    private final String datum$1;

                                    public final long apply() {
                                        return this.apply$mcJ$sp();
                                    }

                                    public long apply$mcJ$sp() {
                                        return DateTimeUtils$.MODULE$.stringToTime(this.datum$1).getTime() * 1000L;
                                    }
                                    {
                                        this.datum$1 = datum$1;
                                    }
                                });
                                break block15;
                            }
                            if (!(dataType instanceof DateType)) break block24;
                            object = Try$.MODULE$.apply((Function0)new Serializable(datum, options){
                                public static final long serialVersionUID = 0L;
                                private final String datum$1;
                                private final CSVOptions options$4;

                                public final int apply() {
                                    return this.apply$mcI$sp();
                                }

                                public int apply$mcI$sp() {
                                    return DateTimeUtils$.MODULE$.millisToDays(this.options$4.dateFormat().parse(this.datum$1).getTime());
                                }
                                {
                                    this.datum$1 = datum$1;
                                    this.options$4 = options$4;
                                }
                            }).getOrElse((Function0)new Serializable(datum){
                                public static final long serialVersionUID = 0L;
                                private final String datum$1;

                                public final int apply() {
                                    return this.apply$mcI$sp();
                                }

                                public int apply$mcI$sp() {
                                    return DateTimeUtils$.MODULE$.millisToDays(DateTimeUtils$.MODULE$.stringToTime(this.datum$1).getTime());
                                }
                                {
                                    this.datum$1 = datum$1;
                                }
                            });
                            break block15;
                        }
                        if (!(dataType instanceof StringType)) break block25;
                        object = UTF8String.fromString((String)datum);
                    }
                    by = object;
                }
                return by;
            }
            if (!(dataType instanceof UserDefinedType)) break;
            UserDefinedType userDefinedType = (UserDefinedType)dataType;
            castType = userDefinedType.sqlType();
        }
        throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{castType.typeName()})));
    }

    public boolean castTo$default$3() {
        return true;
    }

    public CSVOptions castTo$default$4() {
        return CSVOptions$.MODULE$.apply();
    }

    public char toChar(String str2) throws IllegalArgumentException {
        block15: {
            char c;
            block14: {
                block13: {
                    if (str2.charAt(0) != '\\') break block13;
                    char c2 = str2.charAt(1);
                    switch (c2) {
                        case 'u': {
                            String string = str2;
                            String string2 = "\u0000";
                            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                                c = '\u0000';
                                break;
                            }
                        }
                        default: {
                            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported special character for delimiter: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str2})));
                        }
                        case '\'': {
                            c = '\'';
                            break;
                        }
                        case '\"': {
                            c = '\"';
                            break;
                        }
                        case 'f': {
                            c = '\f';
                            break;
                        }
                        case 'b': {
                            c = '\b';
                            break;
                        }
                        case 'r': {
                            c = '\r';
                            break;
                        }
                        case 't': {
                            c = '\t';
                            break;
                        }
                    }
                    break block14;
                }
                if (str2.length() != 1) break block15;
                c = str2.charAt(0);
            }
            return c;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Delimiter cannot be more than one character: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str2})));
    }

    private CSVTypeCast$() {
        MODULE$ = this;
    }
}

