/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.internal.SQLConf;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001}2A!\u0001\u0002\u0001\u001b\t!b+\u0019:jC\ndWmU;cgRLG/\u001e;j_:T!a\u0001\u0003\u0002\u0011%tG/\u001a:oC2T!!\u0002\u0004\u0002\u0007M\fHN\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g\u0011!)\u0002A!A!\u0002\u00131\u0012\u0001B2p]\u001a\u0004\"a\u0006\r\u000e\u0003\tI!!\u0007\u0002\u0003\u000fM\u000bFjQ8oM\")1\u0004\u0001C\u00019\u00051A(\u001b8jiz\"\"!\b\u0010\u0011\u0005]\u0001\u0001\"B\u000b\u001b\u0001\u00041\u0002b\u0002\u0011\u0001\u0005\u0004%I!I\u0001\ba\u0006$H/\u001a:o+\u0005\u0011\u0003CA\u0012+\u001b\u0005!#BA\u0013'\u0003\u0015\u0011XmZ3y\u0015\t9\u0003&\u0001\u0003vi&d'\"A\u0015\u0002\t)\fg/Y\u0005\u0003W\u0011\u0012q\u0001U1ui\u0016\u0014h\u000e\u0003\u0004.\u0001\u0001\u0006IAI\u0001\ta\u0006$H/\u001a:oA!)q\u0006\u0001C\u0001a\u0005Q1/\u001e2ti&$X\u000f^3\u0015\u0005EB\u0004C\u0001\u001a6\u001d\ty1'\u0003\u00025!\u00051\u0001K]3eK\u001aL!AN\u001c\u0003\rM#(/\u001b8h\u0015\t!\u0004\u0003C\u0003:]\u0001\u0007\u0011'A\u0003j]B,H\u000fC\u0003<\u0001\u0011%A(\u0001\ntk\n\u001cH/\u001b;vi\u00164\u0016M]5bE2,GCA\u0019>\u0011\u0015q$\b1\u00012\u0003!1\u0018M]5bE2,\u0007")
public class VariableSubstitution {
    private final SQLConf conf;
    private final Pattern pattern;

    private Pattern pattern() {
        return this.pattern;
    }

    public String substitute(String input) {
        if (input == null) {
            return null;
        }
        if (this.conf.variableSubstituteEnabled()) {
            int s;
            String eval2 = input;
            int depth = this.conf.variableSubstituteDepth();
            StringBuilder builder2 = new StringBuilder();
            Matcher m = this.pattern().matcher("");
            for (s = 0; s <= depth; ++s) {
                m.reset(eval2);
                builder2.setLength(0);
                int prev = 0;
                boolean found = false;
                while (m.find(prev)) {
                    String group = m.group();
                    String substitute = this.substituteVariable(group.substring(2, group.length() - 1));
                    if (substitute.isEmpty()) {
                        substitute = group;
                    } else {
                        found = true;
                    }
                    builder2.append(eval2.substring(prev, m.start())).append(substitute);
                    prev = m.end();
                }
                if (found) {
                    builder2.append(eval2.substring(prev));
                    eval2 = builder2.toString();
                    continue;
                }
                return eval2;
            }
            if (s > depth) {
                throw new AnalysisException(new StringBuilder().append((Object)"Variable substitution depth is deeper than ").append((Object)BoxesRunTime.boxToInteger((int)depth)).append((Object)" for input ").append((Object)input).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            return eval2;
        }
        return input;
    }

    /*
     * WARNING - void declaration
     */
    private String substituteVariable(String variable) {
        void var2_2;
        String value = null;
        if (variable.startsWith("system:")) {
            value = System.getProperty(variable.substring("system:".length()));
        }
        if (value == null && variable.startsWith("env:")) {
            value = System.getenv(variable.substring("env:".length()));
        }
        if (value == null && this.conf != null && variable.startsWith("hiveconf:")) {
            value = this.conf.getConfString(variable.substring("hiveconf:".length()), "");
        }
        if (value == null && this.conf != null && variable.startsWith("sparkconf:")) {
            value = this.conf.getConfString(variable.substring("sparkconf:".length()), "");
        }
        if (value == null && this.conf != null && variable.startsWith("spark:")) {
            value = this.conf.getConfString(variable.substring("spark:".length()), "");
        }
        if (value == null && this.conf != null) {
            value = this.conf.getConfString(variable, "");
        }
        return var2_2;
    }

    public VariableSubstitution(SQLConf conf) {
        this.conf = conf;
        this.pattern = Pattern.compile("\\$\\{[^\\}\\$ ]+\\}");
    }
}

