/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.stat;

import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.execution.stat.StatFunctions$;
import org.apache.spark.sql.execution.stat.StatFunctions$QuantileSummaries$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\r\u0015t!B\u0001\u0003\u0011\u0003y\u0011!D*uCR4UO\\2uS>t7O\u0003\u0002\u0004\t\u0005!1\u000f^1u\u0015\t)a!A\u0005fq\u0016\u001cW\u000f^5p]*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001A\u0011\u0001#E\u0007\u0002\u0005\u0019)!C\u0001E\u0001'\ti1\u000b^1u\rVt7\r^5p]N\u001c2!\u0005\u000b\u001b!\t)\u0002$D\u0001\u0017\u0015\u00059\u0012!B:dC2\f\u0017BA\r\u0017\u0005\u0019\te.\u001f*fMB\u00111DH\u0007\u00029)\u0011Q\u0004C\u0001\tS:$XM\u001d8bY&\u0011q\u0004\b\u0002\b\u0019><w-\u001b8h\u0011\u0015\t\u0013\u0003\"\u0001#\u0003\u0019a\u0014N\\5u}Q\tq\u0002C\u0003%#\u0011\u0005Q%A\fnk2$\u0018\u000e\u001d7f\u0003B\u0004(o\u001c=Rk\u0006tG/\u001b7fgR)aE\u000e$Q%B\u0019qe\f\u001a\u000f\u0005!jcBA\u0015-\u001b\u0005Q#BA\u0016\u000f\u0003\u0019a$o\\8u}%\tq#\u0003\u0002/-\u00059\u0001/Y2lC\u001e,\u0017B\u0001\u00192\u0005\r\u0019V-\u001d\u0006\u0003]Y\u00012aJ\u00184!\t)B'\u0003\u00026-\t1Ai\\;cY\u0016DQaN\u0012A\u0002a\n!\u0001\u001a4\u0011\u0005e\u001aeB\u0001\u001eC\u001d\tY\u0014I\u0004\u0002=\u0001:\u0011Qh\u0010\b\u0003SyJ\u0011!D\u0005\u0003\u00171I!!\u0003\u0006\n\u0005\u001dA\u0011B\u0001\u0018\u0007\u0013\t!UIA\u0005ECR\fgI]1nK*\u0011aF\u0002\u0005\u0006\u000f\u000e\u0002\r\u0001S\u0001\u0005G>d7\u000fE\u0002(_%\u0003\"AS'\u000f\u0005UY\u0015B\u0001'\u0017\u0003\u0019\u0001&/\u001a3fM&\u0011aj\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u000513\u0002\"B)$\u0001\u0004\u0011\u0014!\u00049s_\n\f'-\u001b7ji&,7\u000fC\u0003TG\u0001\u00071'A\u0007sK2\fG/\u001b<f\u000bJ\u0014xN\u001d\u0004\u0005+F\u0001aKA\tRk\u0006tG/\u001b7f'VlW.\u0019:jKN\u001c2\u0001\u0016\u000bX!\t)\u0002,\u0003\u0002Z-\ta1+\u001a:jC2L'0\u00192mK\"A1\f\u0016BC\u0002\u0013\u0005A,A\td_6\u0004(/Z:t)\"\u0014Xm\u001d5pY\u0012,\u0012!\u0018\t\u0003+yK!a\u0018\f\u0003\u0007%sG\u000f\u0003\u0005b)\n\u0005\t\u0015!\u0003^\u0003I\u0019w.\u001c9sKN\u001cH\u000b\u001b:fg\"|G\u000e\u001a\u0011\t\u0011M#&Q1A\u0005\u0002\r,\u0012a\r\u0005\tKR\u0013\t\u0011)A\u0005g\u0005q!/\u001a7bi&4X-\u0012:s_J\u0004\u0003\u0002C4U\u0005\u000b\u0007I\u0011\u00015\u0002\u000fM\fW\u000e\u001d7fIV\t\u0011\u000eE\u0002\u0016U2L!a\u001b\f\u0003\u000b\u0005\u0013(/Y=\u0011\u00075\f)A\u0004\u0002o_6\t\u0011cB\u0003q#!\u0005\u0011/A\tRk\u0006tG/\u001b7f'VlW.\u0019:jKN\u0004\"A\u001c:\u0007\u000bU\u000b\u0002\u0012A:\u0014\u0007I$r\u000bC\u0003\"e\u0012\u0005Q\u000fF\u0001r\u0011\u001d9(O1A\u0005\u0002q\u000b\u0001\u0004Z3gCVdGoQ8naJ,7o\u001d+ie\u0016\u001c\bn\u001c7e\u0011\u0019I(\u000f)A\u0005;\u0006IB-\u001a4bk2$8i\\7qe\u0016\u001c8\u000f\u00165sKNDw\u000e\u001c3!\u0011\u001dY(O1A\u0005\u0002q\u000bq\u0002Z3gCVdG\u000fS3bINK'0\u001a\u0005\u0007{J\u0004\u000b\u0011B/\u0002!\u0011,g-Y;mi\"+\u0017\rZ*ju\u0016\u0004\u0003bB@s\u0005\u0004%\taY\u0001\u0015I\u00164\u0017-\u001e7u%\u0016d\u0017\r^5wK\u0016\u0013(o\u001c:\t\u000f\u0005\r!\u000f)A\u0005g\u0005)B-\u001a4bk2$(+\u001a7bi&4X-\u0012:s_J\u0004cABA\u0004e\u0002\u000bIAA\u0003Ti\u0006$8o\u0005\u0004\u0002\u0006Q\tYa\u0016\t\u0004+\u00055\u0011bAA\b-\t9\u0001K]8ek\u000e$\bBCA\n\u0003\u000b\u0011)\u001a!C\u0001G\u0006)a/\u00197vK\"Q\u0011qCA\u0003\u0005#\u0005\u000b\u0011B\u001a\u0002\rY\fG.^3!\u0011)\tY\"!\u0002\u0003\u0016\u0004%\t\u0001X\u0001\u0002O\"Q\u0011qDA\u0003\u0005#\u0005\u000b\u0011B/\u0002\u0005\u001d\u0004\u0003BCA\u0012\u0003\u000b\u0011)\u001a!C\u00019\u0006)A-\u001a7uC\"Q\u0011qEA\u0003\u0005#\u0005\u000b\u0011B/\u0002\r\u0011,G\u000e^1!\u0011\u001d\t\u0013Q\u0001C\u0001\u0003W!\u0002\"!\f\u00022\u0005M\u0012Q\u0007\t\u0005\u0003_\t)!D\u0001s\u0011\u001d\t\u0019\"!\u000bA\u0002MBq!a\u0007\u0002*\u0001\u0007Q\fC\u0004\u0002$\u0005%\u0002\u0019A/\t\u0015\u0005e\u0012QAA\u0001\n\u0003\tY$\u0001\u0003d_BLH\u0003CA\u0017\u0003{\ty$!\u0011\t\u0013\u0005M\u0011q\u0007I\u0001\u0002\u0004\u0019\u0004\"CA\u000e\u0003o\u0001\n\u00111\u0001^\u0011%\t\u0019#a\u000e\u0011\u0002\u0003\u0007Q\f\u0003\u0006\u0002F\u0005\u0015\u0011\u0013!C\u0001\u0003\u000f\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002J)\u001a1'a\u0013,\u0005\u00055\u0003\u0003BA(\u00033j!!!\u0015\u000b\t\u0005M\u0013QK\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0016\u0017\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00037\n\tFA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D!\"a\u0018\u0002\u0006E\u0005I\u0011AA1\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a\u0019+\u0007u\u000bY\u0005\u0003\u0006\u0002h\u0005\u0015\u0011\u0013!C\u0001\u0003C\nabY8qs\u0012\"WMZ1vYR$3\u0007\u0003\u0006\u0002l\u0005\u0015\u0011\u0011!C!\u0003[\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA8!\u0011\t\t(a\u001f\u000e\u0005\u0005M$\u0002BA;\u0003o\nA\u0001\\1oO*\u0011\u0011\u0011P\u0001\u0005U\u00064\u0018-C\u0002O\u0003gB\u0011\"a \u0002\u0006\u0005\u0005I\u0011\u0001/\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\t\u0015\u0005\r\u0015QAA\u0001\n\u0003\t))\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u001d\u0015Q\u0012\t\u0004+\u0005%\u0015bAAF-\t\u0019\u0011I\\=\t\u0013\u0005=\u0015\u0011QA\u0001\u0002\u0004i\u0016a\u0001=%c!Q\u00111SA\u0003\u0003\u0003%\t%!&\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a&\u0011\r\u0005e\u0015qTAD\u001b\t\tYJC\u0002\u0002\u001eZ\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t+a'\u0003\u0011%#XM]1u_JD!\"!*\u0002\u0006\u0005\u0005I\u0011AAT\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAU\u0003_\u00032!FAV\u0013\r\tiK\u0006\u0002\b\u0005>|G.Z1o\u0011)\ty)a)\u0002\u0002\u0003\u0007\u0011q\u0011\u0005\u000b\u0003g\u000b)!!A\u0005B\u0005U\u0016\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003uC!\"!/\u0002\u0006\u0005\u0005I\u0011IA^\u0003!!xn\u0015;sS:<GCAA8\u0011)\ty,!\u0002\u0002\u0002\u0013\u0005\u0013\u0011Y\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005%\u00161\u0019\u0005\u000b\u0003\u001f\u000bi,!AA\u0002\u0005\u001du!CAde\u0006\u0005\t\u0012AAe\u0003\u0015\u0019F/\u0019;t!\u0011\ty#a3\u0007\u0013\u0005\u001d!/!A\t\u0002\u000557#BAf\u0003\u001f<\u0006#CAi\u0003/\u001cT,XA\u0017\u001b\t\t\u0019NC\u0002\u0002VZ\tqA];oi&lW-\u0003\u0003\u0002Z\u0006M'!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8og!9\u0011%a3\u0005\u0002\u0005uGCAAe\u0011)\tI,a3\u0002\u0002\u0013\u0015\u00131\u0018\u0005\u000b\u0003G\fY-!A\u0005\u0002\u0006\u0015\u0018!B1qa2LH\u0003CA\u0017\u0003O\fI/a;\t\u000f\u0005M\u0011\u0011\u001da\u0001g!9\u00111DAq\u0001\u0004i\u0006bBA\u0012\u0003C\u0004\r!\u0018\u0005\u000b\u0003_\fY-!A\u0005\u0002\u0006E\u0018aB;oCB\u0004H.\u001f\u000b\u0005\u0003g\fy\u0010E\u0003\u0016\u0003k\fI0C\u0002\u0002xZ\u0011aa\u00149uS>t\u0007CB\u000b\u0002|NjV,C\u0002\u0002~Z\u0011a\u0001V;qY\u0016\u001c\u0004B\u0003B\u0001\u0003[\f\t\u00111\u0001\u0002.\u0005\u0019\u0001\u0010\n\u0019\t\u0015\t\u0015\u00111ZA\u0001\n\u0013\u00119!A\u0006sK\u0006$'+Z:pYZ,GC\u0001B\u0005!\u0011\t\tHa\u0003\n\t\t5\u00111\u000f\u0002\u0007\u001f\nTWm\u0019;\t\u000f\tE!\u000f\"\u0003\u0003\u0014\u0005i1m\\7qe\u0016\u001c8/S7nkR$bA!\u0006\u0003\u0018\t\u0005\u0002\u0003B\u000bk\u0003[A\u0001B!\u0007\u0003\u0010\u0001\u0007!1D\u0001\u000fGV\u0014(/\u001a8u'\u0006l\u0007\u000f\\3t!\u00159#QDA\u0017\u0013\r\u0011y\"\r\u0002\u000b\u0013:$W\r_3e'\u0016\f\bb\u0002B\u0012\u0005\u001f\u0001\raM\u0001\u000f[\u0016\u0014x-\u001a+ie\u0016\u001c\bn\u001c7e\u0011%\u00119C]I\u0001\n\u0003\u0011I#A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u000b\u0003\u0005WQCA!\u0006\u0002L!I!q\u0006:\u0012\u0002\u0013\u0005!\u0011G\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\tM\"\u0006\u0002B\u001b\u0003\u0017\u00022!\u0006B\u001c\u0013\r\u0011ID\u0006\u0002\u0005\u0019>tw\rC\u0005\u0003>I\f\n\u0011\"\u0001\u0003@\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIU*\"A!\u0011+\t\t\r\u00131\n\t\u0006\u0005\u000b\u0012YeM\u0007\u0003\u0005\u000fRAA!\u0013\u0002\u001c\u00069Q.\u001e;bE2,\u0017\u0002\u0002B'\u0005\u000f\u00121\"\u0011:sCf\u0014UO\u001a4fe\"I!Q\u0001:\u0002\u0002\u0013%!q\u0001\u0005\n\u0005'\"&\u0011!Q\u0001\n%\f\u0001b]1na2,G\r\t\u0005\f\u0005/\"&\u00111A\u0005\u0002\t\u0011I&A\u0003d_VtG/\u0006\u0002\u00036!Y!Q\f+\u0003\u0002\u0004%\tA\u0001B0\u0003%\u0019w.\u001e8u?\u0012*\u0017\u000f\u0006\u0003\u0003b\t\u001d\u0004cA\u000b\u0003d%\u0019!Q\r\f\u0003\tUs\u0017\u000e\u001e\u0005\u000b\u0003\u001f\u0013Y&!AA\u0002\tU\u0002B\u0003B6)\n\u0005\t\u0015)\u0003\u00036\u000511m\\;oi\u0002B!Ba\u001cU\u0005\u000b\u0007I\u0011\u0001B9\u0003-AW-\u00193TC6\u0004H.\u001a3\u0016\u0005\t\r\u0003B\u0003B;)\n\u0005\t\u0015!\u0003\u0003D\u0005a\u0001.Z1e'\u0006l\u0007\u000f\\3eA!1\u0011\u0005\u0016C\u0001\u0005s\"BBa\u001f\u0003~\t}$\u0011\u0011BB\u0005\u000b\u0003\"A\u001c+\t\rm\u00139\b1\u0001^\u0011\u0019\u0019&q\u000fa\u0001g!AqMa\u001e\u0011\u0002\u0003\u0007\u0011\u000e\u0003\u0006\u0003X\t]\u0004\u0013!a\u0001\u0005kA!Ba\u001c\u0003xA\u0005\t\u0019\u0001B\"\u0011\u001d\u0011I\t\u0016C\u0001\u0005\u0017\u000ba!\u001b8tKJ$H\u0003\u0002B>\u0005\u001bCqAa$\u0003\b\u0002\u00071'A\u0001y\u0011\u001d\u0011\u0019\n\u0016C\u0005\u0005+\u000bac^5uQ\"+\u0017\r\u001a\"vM\u001a,'/\u00138tKJ$X\rZ\u000b\u0003\u0005wBqA!'U\t\u0003\u0011Y*\u0001\u0005d_6\u0004(/Z:t)\t\u0011Y\bC\u0004\u0003 R#IA!&\u0002\u0017MD\u0017\r\u001c7po\u000e{\u0007/\u001f\u0005\b\u0005G#F\u0011\u0001BS\u0003\u0015iWM]4f)\u0011\u0011YHa*\t\u0011\t%&\u0011\u0015a\u0001\u0005w\nQa\u001c;iKJDqA!,U\t\u0003\u0011y+A\u0003rk\u0016\u0014\u0018\u0010F\u00024\u0005cCqAa-\u0003,\u0002\u00071'\u0001\u0005rk\u0006tG/\u001b7f\u0011\u001d\u00119,\u0005C\u0001\u0005s\u000b!\u0003]3beN|gnQ8se\u0016d\u0017\r^5p]R)1Ga/\u0003>\"1qG!.A\u0002aBaa\u0012B[\u0001\u0004AeA\u0002Ba#\u0011\u0011\u0019MA\tD_Z\f'/[1oG\u0016\u001cu.\u001e8uKJ\u001cBAa0\u0015/\"9\u0011Ea0\u0005\u0002\t\u001dGC\u0001Be!\rq'q\u0018\u0005\n\u0005\u001b\u0014y\f1A\u0005\u0002\r\fA\u0001_!wO\"Q!\u0011\u001bB`\u0001\u0004%\tAa5\u0002\u0011a\feoZ0%KF$BA!\u0019\u0003V\"I\u0011q\u0012Bh\u0003\u0003\u0005\ra\r\u0005\t\u00053\u0014y\f)Q\u0005g\u0005)\u00010\u0011<hA!I!Q\u001cB`\u0001\u0004%\taY\u0001\u0005s\u00063x\r\u0003\u0006\u0003b\n}\u0006\u0019!C\u0001\u0005G\f\u0001\"_!wO~#S-\u001d\u000b\u0005\u0005C\u0012)\u000fC\u0005\u0002\u0010\n}\u0017\u0011!a\u0001g!A!\u0011\u001eB`A\u0003&1'A\u0003z\u0003Z<\u0007\u0005C\u0005\u0003n\n}\u0006\u0019!C\u0001G\u0006\u00111i\u001b\u0005\u000b\u0005c\u0014y\f1A\u0005\u0002\tM\u0018AB\"l?\u0012*\u0017\u000f\u0006\u0003\u0003b\tU\b\"CAH\u0005_\f\t\u00111\u00014\u0011!\u0011IPa0!B\u0013\u0019\u0014aA\"lA!I!Q B`\u0001\u0004%\taY\u0001\u0004\u001b.D\u0006BCB\u0001\u0005\u007f\u0003\r\u0011\"\u0001\u0004\u0004\u00059Qj\u001b-`I\u0015\fH\u0003\u0002B1\u0007\u000bA\u0011\"a$\u0003\u0000\u0006\u0005\t\u0019A\u001a\t\u0011\r%!q\u0018Q!\nM\nA!T6YA!I1Q\u0002B`\u0001\u0004%\taY\u0001\u0004\u001b.L\u0006BCB\t\u0005\u007f\u0003\r\u0011\"\u0001\u0004\u0014\u00059Qj[-`I\u0015\fH\u0003\u0002B1\u0007+A\u0011\"a$\u0004\u0010\u0005\u0005\t\u0019A\u001a\t\u0011\re!q\u0018Q!\nM\nA!T6ZA!Q!q\u000bB`\u0001\u0004%\tA!\u0017\t\u0015\tu#q\u0018a\u0001\n\u0003\u0019y\u0002\u0006\u0003\u0003b\r\u0005\u0002BCAH\u0007;\t\t\u00111\u0001\u00036!I!1\u000eB`A\u0003&!Q\u0007\u0005\t\u0007O\u0011y\f\"\u0001\u0004*\u0005\u0019\u0011\r\u001a3\u0015\r\r-2QFB\u0018\u001b\t\u0011y\fC\u0004\u0003\u0010\u000e\u0015\u0002\u0019A\u001a\t\u000f\rE2Q\u0005a\u0001g\u0005\t\u0011\u0010\u0003\u0005\u0003$\n}F\u0011AB\u001b)\u0011\u0019Yca\u000e\t\u0011\t%61\u0007a\u0001\u0005\u0013Dqaa\u000f\u0003@\u0012\u00051-A\u0002d_ZDqaa\u0010\u0012\t\u0013\u0019\t%\u0001\fd_2dWm\u0019;Ti\u0006$\u0018n\u001d;jG\u0006dG)\u0019;b)!\u0011Ima\u0011\u0004F\r\u001d\u0003BB\u001c\u0004>\u0001\u0007\u0001\b\u0003\u0004H\u0007{\u0001\r\u0001\u0013\u0005\b\u0007\u0013\u001ai\u00041\u0001J\u000311WO\\2uS>tg*Y7f\u0011\u001d\u0019i%\u0005C\u0001\u0007\u001f\nAbY1mGVd\u0017\r^3D_Z$RaMB)\u0007'BaaNB&\u0001\u0004A\u0004BB$\u0004L\u0001\u0007\u0001\nC\u0004\u0004XE!\ta!\u0017\u0002\u001b\r\u0014xn]:UC\n,H.\u0019;f)\u001dA41LB/\u0007CBaaNB+\u0001\u0004A\u0004bBB0\u0007+\u0002\r!S\u0001\u0005G>d\u0017\u0007C\u0004\u0004d\rU\u0003\u0019A%\u0002\t\r|GN\r")
public final class StatFunctions {
    public static void initializeLogIfNecessary(boolean bl) {
        StatFunctions$.MODULE$.initializeLogIfNecessary(bl);
    }

    public static void logError(Function0<String> function0, Throwable throwable) {
        StatFunctions$.MODULE$.logError(function0, throwable);
    }

    public static void logWarning(Function0<String> function0, Throwable throwable) {
        StatFunctions$.MODULE$.logWarning(function0, throwable);
    }

    public static void logTrace(Function0<String> function0, Throwable throwable) {
        StatFunctions$.MODULE$.logTrace(function0, throwable);
    }

    public static void logDebug(Function0<String> function0, Throwable throwable) {
        StatFunctions$.MODULE$.logDebug(function0, throwable);
    }

    public static void logInfo(Function0<String> function0, Throwable throwable) {
        StatFunctions$.MODULE$.logInfo(function0, throwable);
    }

    public static void logError(Function0<String> function0) {
        StatFunctions$.MODULE$.logError(function0);
    }

    public static void logWarning(Function0<String> function0) {
        StatFunctions$.MODULE$.logWarning(function0);
    }

    public static void logTrace(Function0<String> function0) {
        StatFunctions$.MODULE$.logTrace(function0);
    }

    public static void logDebug(Function0<String> function0) {
        StatFunctions$.MODULE$.logDebug(function0);
    }

    public static void logInfo(Function0<String> function0) {
        StatFunctions$.MODULE$.logInfo(function0);
    }

    public static boolean isTraceEnabled() {
        return StatFunctions$.MODULE$.isTraceEnabled();
    }

    public static boolean isDebugEnabled() {
        return StatFunctions$.MODULE$.isDebugEnabled();
    }

    public static boolean isInfoEnabled() {
        return StatFunctions$.MODULE$.isInfoEnabled();
    }

    public static Logger log() {
        return StatFunctions$.MODULE$.log();
    }

    public static String logName() {
        return StatFunctions$.MODULE$.logName();
    }

    public static Dataset<Row> crossTabulate(Dataset<Row> dataset, String string, String string2) {
        return StatFunctions$.MODULE$.crossTabulate(dataset, string, string2);
    }

    public static double calculateCov(Dataset<Row> dataset, Seq<String> seq) {
        return StatFunctions$.MODULE$.calculateCov(dataset, seq);
    }

    public static double pearsonCorrelation(Dataset<Row> dataset, Seq<String> seq) {
        return StatFunctions$.MODULE$.pearsonCorrelation(dataset, seq);
    }

    public static Seq<Seq<Object>> multipleApproxQuantiles(Dataset<Row> dataset, Seq<String> seq, Seq<Object> seq2, double d) {
        return StatFunctions$.MODULE$.multipleApproxQuantiles(dataset, seq, seq2, d);
    }

    public static class QuantileSummaries
    implements Serializable {
        private final int compressThreshold;
        private final double relativeError;
        private final Stats[] sampled;
        private long count;
        private final ArrayBuffer<Object> headSampled;

        public int compressThreshold() {
            return this.compressThreshold;
        }

        public double relativeError() {
            return this.relativeError;
        }

        public Stats[] sampled() {
            return this.sampled;
        }

        public long count() {
            return this.count;
        }

        public void count_$eq(long x$1) {
            this.count = x$1;
        }

        public ArrayBuffer<Object> headSampled() {
            return this.headSampled;
        }

        public QuantileSummaries insert(double x) {
            QuantileSummaries result;
            this.headSampled().append((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{x}));
            return this.headSampled().size() >= StatFunctions$QuantileSummaries$.MODULE$.defaultHeadSize() ? ((result = this.withHeadBufferInserted()).sampled().length >= this.compressThreshold() ? result.compress() : result) : this;
        }

        private QuantileSummaries withHeadBufferInserted() {
            if (this.headSampled().isEmpty()) {
                return this;
            }
            long currentCount = this.count();
            double[] sorted = (double[])Predef$.MODULE$.doubleArrayOps((double[])this.headSampled().toArray(ClassTag$.MODULE$.Double())).sorted((Ordering)Ordering.Double$.MODULE$);
            ArrayBuffer newSamples = new ArrayBuffer();
            int sampleIdx = 0;
            for (int opsIdx = 0; opsIdx < sorted.length; ++opsIdx) {
                double currentSample = sorted[opsIdx];
                while (sampleIdx < Predef$.MODULE$.refArrayOps((Object[])this.sampled()).size() && this.sampled()[sampleIdx].value() <= currentSample) {
                    newSamples.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Stats[]{this.sampled()[sampleIdx]}));
                    ++sampleIdx;
                }
                int delta = newSamples.isEmpty() || sampleIdx == Predef$.MODULE$.refArrayOps((Object[])this.sampled()).size() && opsIdx == sorted.length - 1 ? 0 : (int)package$.MODULE$.floor((double)2 * this.relativeError() * (double)(++currentCount));
                Stats tuple = new Stats(currentSample, 1, delta);
                newSamples.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Stats[]{tuple}));
            }
            while (sampleIdx < Predef$.MODULE$.refArrayOps((Object[])this.sampled()).size()) {
                newSamples.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Stats[]{this.sampled()[sampleIdx]}));
                ++sampleIdx;
            }
            return new QuantileSummaries(this.compressThreshold(), this.relativeError(), (Stats[])newSamples.toArray(ClassTag$.MODULE$.apply(Stats.class)), currentCount, StatFunctions$QuantileSummaries$.MODULE$.$lessinit$greater$default$5());
        }

        public QuantileSummaries compress() {
            QuantileSummaries inserted = this.withHeadBufferInserted();
            Predef$.MODULE$.assert(inserted.headSampled().isEmpty());
            Predef$.MODULE$.assert(inserted.count() == this.count() + (long)this.headSampled().size());
            Stats[] compressed = StatFunctions$QuantileSummaries$.MODULE$.org$apache$spark$sql$execution$stat$StatFunctions$QuantileSummaries$$compressImmut((IndexedSeq<Stats>)Predef$.MODULE$.wrapRefArray((Object[])inserted.sampled()), (double)2 * this.relativeError() * (double)inserted.count());
            return new QuantileSummaries(this.compressThreshold(), this.relativeError(), compressed, inserted.count(), StatFunctions$QuantileSummaries$.MODULE$.$lessinit$greater$default$5());
        }

        private QuantileSummaries shallowCopy() {
            return new QuantileSummaries(this.compressThreshold(), this.relativeError(), this.sampled(), this.count(), this.headSampled());
        }

        public QuantileSummaries merge(QuantileSummaries other) {
            QuantileSummaries quantileSummaries;
            Predef$.MODULE$.require(this.headSampled().isEmpty(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Current buffer needs to be compressed before merge";
                }
            });
            Predef$.MODULE$.require(other.headSampled().isEmpty(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Other buffer needs to be compressed before merge";
                }
            });
            if (other.count() == 0L) {
                quantileSummaries = this.shallowCopy();
            } else if (this.count() == 0L) {
                quantileSummaries = other.shallowCopy();
            } else {
                Stats[] res = (Stats[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.sampled()).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])other.sampled()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Stats.class)))).sortBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(Stats x$1) {
                        return x$1.value();
                    }
                }, (Ordering)Ordering.Double$.MODULE$);
                Stats[] comp = StatFunctions$QuantileSummaries$.MODULE$.org$apache$spark$sql$execution$stat$StatFunctions$QuantileSummaries$$compressImmut((IndexedSeq<Stats>)Predef$.MODULE$.wrapRefArray((Object[])res), (double)2 * this.relativeError() * (double)this.count());
                quantileSummaries = new QuantileSummaries(other.compressThreshold(), other.relativeError(), comp, other.count() + this.count(), StatFunctions$QuantileSummaries$.MODULE$.$lessinit$greater$default$5());
            }
            return quantileSummaries;
        }

        public double query(double quantile) {
            Predef$.MODULE$.require(quantile >= 0.0 && quantile <= 1.0, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "quantile should be in the range [0.0, 1.0]";
                }
            });
            Predef$.MODULE$.require(this.headSampled().isEmpty(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Cannot operate on an uncompressed summary, call compress() first";
                }
            });
            if (quantile <= this.relativeError()) {
                return ((Stats)Predef$.MODULE$.refArrayOps((Object[])this.sampled()).head()).value();
            }
            if (quantile >= 1.0 - this.relativeError()) {
                return ((Stats)Predef$.MODULE$.refArrayOps((Object[])this.sampled()).last()).value();
            }
            int rank = (int)package$.MODULE$.ceil(quantile * (double)this.count());
            double targetError = package$.MODULE$.ceil(this.relativeError() * (double)this.count());
            int minRank = 0;
            for (int i = 1; i < Predef$.MODULE$.refArrayOps((Object[])this.sampled()).size() - 1; ++i) {
                Stats curSample = this.sampled()[i];
                int maxRank = (minRank += curSample.g()) + curSample.delta();
                if (!((double)maxRank - targetError <= (double)rank) || !((double)rank <= (double)minRank + targetError)) continue;
                return curSample.value();
            }
            return ((Stats)Predef$.MODULE$.refArrayOps((Object[])this.sampled()).last()).value();
        }

        public QuantileSummaries(int compressThreshold, double relativeError, Stats[] sampled, long count2, ArrayBuffer<Object> headSampled) {
            this.compressThreshold = compressThreshold;
            this.relativeError = relativeError;
            this.sampled = sampled;
            this.count = count2;
            this.headSampled = headSampled;
        }

        public static class Stats
        implements Product,
        Serializable {
            private final double value;
            private final int g;
            private final int delta;

            public double value() {
                return this.value;
            }

            public int g() {
                return this.g;
            }

            public int delta() {
                return this.delta;
            }

            public Stats copy(double value, int g, int delta) {
                return new Stats(value, g, delta);
            }

            public double copy$default$1() {
                return this.value();
            }

            public int copy$default$2() {
                return this.g();
            }

            public int copy$default$3() {
                return this.delta();
            }

            public String productPrefix() {
                return "Stats";
            }

            public int productArity() {
                return 3;
            }

            public Object productElement(int x$1) {
                Number number;
                int n = x$1;
                switch (n) {
                    default: {
                        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                    }
                    case 2: {
                        number = BoxesRunTime.boxToInteger((int)this.delta());
                        break;
                    }
                    case 1: {
                        number = BoxesRunTime.boxToInteger((int)this.g());
                        break;
                    }
                    case 0: {
                        number = BoxesRunTime.boxToDouble((double)this.value());
                    }
                }
                return number;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Stats;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.value()));
                n = Statics.mix((int)n, (int)this.g());
                n = Statics.mix((int)n, (int)this.delta());
                return Statics.finalizeHash((int)n, (int)3);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Stats)) return false;
                boolean bl = true;
                if (!bl) return false;
                Stats stats = (Stats)x$1;
                if (this.value() != stats.value()) return false;
                if (this.g() != stats.g()) return false;
                if (this.delta() != stats.delta()) return false;
                if (!stats.canEqual(this)) return false;
                return true;
            }

            public Stats(double value, int g, int delta) {
                this.value = value;
                this.g = g;
                this.delta = delta;
                Product.class.$init$((Product)this);
            }
        }
    }

    public static class CovarianceCounter
    implements Serializable {
        private double xAvg = 0.0;
        private double yAvg = 0.0;
        private double Ck = 0.0;
        private double MkX = 0.0;
        private double MkY = 0.0;
        private long count = 0L;

        public double xAvg() {
            return this.xAvg;
        }

        public void xAvg_$eq(double x$1) {
            this.xAvg = x$1;
        }

        public double yAvg() {
            return this.yAvg;
        }

        public void yAvg_$eq(double x$1) {
            this.yAvg = x$1;
        }

        public double Ck() {
            return this.Ck;
        }

        public void Ck_$eq(double x$1) {
            this.Ck = x$1;
        }

        public double MkX() {
            return this.MkX;
        }

        public void MkX_$eq(double x$1) {
            this.MkX = x$1;
        }

        public double MkY() {
            return this.MkY;
        }

        public void MkY_$eq(double x$1) {
            this.MkY = x$1;
        }

        public long count() {
            return this.count;
        }

        public void count_$eq(long x$1) {
            this.count = x$1;
        }

        public CovarianceCounter add(double x, double y) {
            double deltaX = x - this.xAvg();
            double deltaY = y - this.yAvg();
            this.count_$eq(this.count() + 1L);
            this.xAvg_$eq(this.xAvg() + deltaX / (double)this.count());
            this.yAvg_$eq(this.yAvg() + deltaY / (double)this.count());
            this.Ck_$eq(this.Ck() + deltaX * (y - this.yAvg()));
            this.MkX_$eq(this.MkX() + deltaX * (x - this.xAvg()));
            this.MkY_$eq(this.MkY() + deltaY * (y - this.yAvg()));
            return this;
        }

        public CovarianceCounter merge(CovarianceCounter other) {
            if (other.count() > 0L) {
                long totalCount = this.count() + other.count();
                double deltaX = this.xAvg() - other.xAvg();
                double deltaY = this.yAvg() - other.yAvg();
                this.Ck_$eq(this.Ck() + (other.Ck() + deltaX * deltaY * (double)this.count() / (double)totalCount * (double)other.count()));
                this.xAvg_$eq((this.xAvg() * (double)this.count() + other.xAvg() * (double)other.count()) / (double)totalCount);
                this.yAvg_$eq((this.yAvg() * (double)this.count() + other.yAvg() * (double)other.count()) / (double)totalCount);
                this.MkX_$eq(this.MkX() + (other.MkX() + deltaX * deltaX * (double)this.count() / (double)totalCount * (double)other.count()));
                this.MkY_$eq(this.MkY() + (other.MkY() + deltaY * deltaY * (double)this.count() / (double)totalCount * (double)other.count()));
                this.count_$eq(totalCount);
            }
            return this;
        }

        public double cov() {
            return this.Ck() / (double)(this.count() - 1L);
        }
    }
}

