/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.internal;

import java.net.URL;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalog;
import org.apache.spark.sql.catalyst.catalog.InMemoryCatalog;
import org.apache.spark.sql.execution.CacheManager;
import org.apache.spark.sql.execution.ui.SQLListener;
import org.apache.spark.sql.execution.ui.SQLTab;
import org.apache.spark.sql.internal.NonClosableMutableURLClassLoader;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.ui.SparkUI;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001a3Q!\u0001\u0002\u0001\t1\u00111b\u00155be\u0016$7\u000b^1uK*\u00111\u0001B\u0001\tS:$XM\u001d8bY*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0014\u0007\u0001i1\u0003\u0005\u0002\u000f#5\tqBC\u0001\u0011\u0003\u0015\u00198-\u00197b\u0013\t\u0011rB\u0001\u0004B]f\u0014VM\u001a\t\u0003)Yi\u0011!\u0006\u0006\u0003\u0007\u0019I!aF\u000b\u0003\u000f1{wmZ5oO\"A\u0011\u0004\u0001BC\u0002\u0013\u00051$\u0001\u0007ta\u0006\u00148nQ8oi\u0016DHo\u0001\u0001\u0016\u0003q\u0001\"!\b\u0010\u000e\u0003\u0019I!a\b\u0004\u0003\u0019M\u0003\u0018M]6D_:$X\r\u001f;\t\u0011\u0005\u0002!\u0011!Q\u0001\nq\tQb\u001d9be.\u001cuN\u001c;fqR\u0004\u0003\"B\u0012\u0001\t\u0003!\u0013A\u0002\u001fj]&$h\b\u0006\u0002&OA\u0011a\u0005A\u0007\u0002\u0005!)\u0011D\ta\u00019!9\u0011\u0006\u0001b\u0001\n\u0003Q\u0013\u0001D2bG\",W*\u00198bO\u0016\u0014X#A\u0016\u0011\u00051zS\"A\u0017\u000b\u00059\"\u0011!C3yK\u000e,H/[8o\u0013\t\u0001TF\u0001\u0007DC\u000eDW-T1oC\u001e,'\u000f\u0003\u00043\u0001\u0001\u0006IaK\u0001\u000eG\u0006\u001c\u0007.Z'b]\u0006<WM\u001d\u0011\t\u000fQ\u0002!\u0019!C\u0001k\u0005AA.[:uK:,'/F\u00017!\t9$(D\u00019\u0015\tIT&\u0001\u0002vS&\u00111\b\u000f\u0002\f'FcE*[:uK:,'\u000f\u0003\u0004>\u0001\u0001\u0006IAN\u0001\nY&\u001cH/\u001a8fe\u0002B\u0001b\u0010\u0001\t\u0006\u0004%\t\u0001Q\u0001\u0010Kb$XM\u001d8bY\u000e\u000bG/\u00197pOV\t\u0011\t\u0005\u0002C\u000f6\t1I\u0003\u0002E\u000b\u000691-\u0019;bY><'B\u0001$\u0005\u0003!\u0019\u0017\r^1msN$\u0018B\u0001%D\u0005=)\u0005\u0010^3s]\u0006d7)\u0019;bY><\u0007\u0002\u0003&\u0001\u0011\u0003\u0005\u000b\u0015B!\u0002!\u0015DH/\u001a:oC2\u001c\u0015\r^1m_\u001e\u0004\u0003b\u0002'\u0001\u0005\u0004%\t!T\u0001\u000fU\u0006\u00148\t\\1tg2{\u0017\rZ3s+\u0005q\u0005C\u0001\u0014P\u0013\t\u0001&A\u0001\u0011O_:\u001cEn\\:bE2,W*\u001e;bE2,WK\u0015'DY\u0006\u001c8\u000fT8bI\u0016\u0014\bB\u0002*\u0001A\u0003%a*A\bkCJ\u001cE.Y:t\u0019>\fG-\u001a:!\u0011\u0015!\u0006\u0001\"\u0003V\u0003M\u0019'/Z1uK2K7\u000f^3oKJ\fe\u000eZ+J)\t1d\u000bC\u0003X'\u0002\u0007A$\u0001\u0002tG\u0002")
public class SharedState
implements Logging {
    private final SparkContext sparkContext;
    private final CacheManager cacheManager;
    private final SQLListener listener;
    private ExternalCatalog externalCatalog;
    private final NonClosableMutableURLClassLoader jarClassLoader;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    private ExternalCatalog externalCatalog$lzycompute() {
        SharedState sharedState2 = this;
        synchronized (sharedState2) {
            if (!this.bitmap$0) {
                this.externalCatalog = new InMemoryCatalog(this.sparkContext().hadoopConfiguration());
                this.bitmap$0 = true;
            }
            return this.externalCatalog;
        }
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public SparkContext sparkContext() {
        return this.sparkContext;
    }

    public CacheManager cacheManager() {
        return this.cacheManager;
    }

    public SQLListener listener() {
        return this.listener;
    }

    public ExternalCatalog externalCatalog() {
        return this.bitmap$0 ? this.externalCatalog : this.externalCatalog$lzycompute();
    }

    public NonClosableMutableURLClassLoader jarClassLoader() {
        return this.jarClassLoader;
    }

    private SQLListener createListenerAndUI(SparkContext sc) {
        if (SparkSession$.MODULE$.sqlListener().get() == null) {
            SQLListener listener = new SQLListener(sc.conf());
            if (SparkSession$.MODULE$.sqlListener().compareAndSet(null, listener)) {
                sc.addSparkListener((SparkListenerInterface)listener);
                sc.ui().foreach((Function1)new Serializable(this, listener){
                    public static final long serialVersionUID = 0L;
                    private final SQLListener listener$1;

                    public final SQLTab apply(SparkUI x$1) {
                        return new SQLTab(this.listener$1, x$1);
                    }
                    {
                        this.listener$1 = listener$1;
                    }
                });
            }
        }
        return SparkSession$.MODULE$.sqlListener().get();
    }

    public SharedState(SparkContext sparkContext) {
        SparkConf sparkConf;
        this.sparkContext = sparkContext;
        Logging.class.$init$((Logging)this);
        this.cacheManager = new CacheManager();
        this.listener = this.createListenerAndUI(sparkContext);
        URL configFile = Utils$.MODULE$.getContextOrSparkClassLoader().getResource("hive-site.xml");
        if (configFile != null) {
            sparkContext.hadoopConfiguration().addResource(configFile);
        }
        this.jarClassLoader = new NonClosableMutableURLClassLoader(Utils$.MODULE$.getContextOrSparkClassLoader());
        SQLConf tempConf = new SQLConf();
        Predef$.MODULE$.refArrayOps((Object[])sparkContext.conf().getAll()).foreach((Function1)new Serializable(this, tempConf){
            public static final long serialVersionUID = 0L;
            private final SQLConf tempConf$1;

            public final void apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    this.tempConf$1.setConfString(k, v);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.tempConf$1 = tempConf$1;
            }
        });
        String hiveWarehouseDir = sparkContext.hadoopConfiguration().get("hive.metastore.warehouse.dir");
        if (hiveWarehouseDir == null || tempConf.contains(SQLConf$.MODULE$.WAREHOUSE_PATH().key())) {
            sparkConf = sparkContext.conf().set("hive.metastore.warehouse.dir", tempConf.warehousePath());
        } else {
            tempConf.setConfString(SQLConf$.MODULE$.WAREHOUSE_PATH().key(), hiveWarehouseDir);
            sparkContext.conf().set(SQLConf$.MODULE$.WAREHOUSE_PATH().key(), hiveWarehouseDir);
            this.logInfo((Function0<String>)new Serializable(this, hiveWarehouseDir){
                public static final long serialVersionUID = 0L;
                private final String hiveWarehouseDir$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not set, but hive.metastore.warehouse.dir "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SQLConf$.MODULE$.WAREHOUSE_PATH().key()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"is set. Setting ", " to the value of "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SQLConf$.MODULE$.WAREHOUSE_PATH().key()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hive.metastore.warehouse.dir ('", "')."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hiveWarehouseDir$1}))).toString();
                }
                {
                    this.hiveWarehouseDir$1 = hiveWarehouseDir$1;
                }
            });
            sparkConf = BoxedUnit.UNIT;
        }
        this.logInfo((Function0<String>)new Serializable(this, tempConf){
            public static final long serialVersionUID = 0L;
            private final SQLConf tempConf$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Warehouse path is '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tempConf$1.warehousePath()}));
            }
            {
                this.tempConf$1 = tempConf$1;
            }
        });
    }
}

