/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.parquet.io.api.Binary;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class ParquetRowConverter$ {
    public static final ParquetRowConverter$ MODULE$;

    static {
        new ParquetRowConverter$();
    }

    public long binaryToUnscaledLong(Binary binary) {
        ByteBuffer buffer = binary.toByteBuffer();
        byte[] bytes = buffer.array();
        int start = buffer.arrayOffset() + buffer.position();
        int end = buffer.arrayOffset() + buffer.limit();
        long unscaled = 0L;
        for (int i = start; i < end; ++i) {
            unscaled = unscaled << 8 | (long)(bytes[i] & 0xFF);
        }
        int bits = 8 * (end - start);
        unscaled = unscaled << 64 - bits >> 64 - bits;
        return unscaled;
    }

    public long binaryToSQLTimestamp(Binary binary) {
        Predef$.MODULE$.assert(binary.length() == 12, (Function0)new Serializable(binary){
            public static final long serialVersionUID = 0L;
            private final Binary binary$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Timestamps (with nanoseconds) are expected to be stored in"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" 12-byte long binaries. Found a ", "-byte binary instead."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.binary$1.length())}))).toString();
            }
            {
                this.binary$1 = binary$1;
            }
        });
        ByteBuffer buffer = binary.toByteBuffer().order(ByteOrder.LITTLE_ENDIAN);
        long timeOfDayNanos = buffer.getLong();
        int julianDay = buffer.getInt();
        return DateTimeUtils$.MODULE$.fromJulianDay(julianDay, timeOfDayNanos);
    }

    private ParquetRowConverter$() {
        MODULE$ = this;
    }
}

