/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.sql.Timestamp;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.kafka010.EarliestOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeLimit;
import org.apache.spark.sql.kafka010.KafkaOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.KafkaOffsetReader;
import org.apache.spark.sql.kafka010.KafkaOffsetReader$;
import org.apache.spark.sql.kafka010.KafkaSourceRDD;
import org.apache.spark.sql.kafka010.KafkaSourceRDDOffsetRange;
import org.apache.spark.sql.kafka010.LatestOffsetRangeLimit$;
import org.apache.spark.sql.kafka010.SpecificOffsetRangeLimit;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.TableScan;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0005ea!B\u0001\u0003\u0001\ta!!D&bM.\f'+\u001a7bi&|gN\u0003\u0002\u0004\t\u0005A1.\u00194lCB\n\u0004G\u0003\u0002\u0006\r\u0005\u00191/\u001d7\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001cB\u0001A\u0007\u0014-A\u0011a\"E\u0007\u0002\u001f)\u0011\u0001\u0003B\u0001\bg>,(oY3t\u0013\t\u0011rB\u0001\u0007CCN,'+\u001a7bi&|g\u000e\u0005\u0002\u000f)%\u0011Qc\u0004\u0002\n)\u0006\u0014G.Z*dC:\u0004\"a\u0006\u000e\u000e\u0003aQ!!\u0007\u0004\u0002\u0011%tG/\u001a:oC2L!a\u0007\r\u0003\u000f1{wmZ5oO\"AQ\u0004\u0001BC\u0002\u0013\u0005s$\u0001\u0006tc2\u001cuN\u001c;fqR\u001c\u0001!F\u0001!!\t\t#%D\u0001\u0005\u0013\t\u0019CA\u0001\u0006T#2\u001buN\u001c;fqRD\u0001\"\n\u0001\u0003\u0002\u0003\u0006I\u0001I\u0001\fgFd7i\u001c8uKb$\b\u0005\u0003\u0005(\u0001\t\u0005\t\u0015!\u0003)\u0003-Y\u0017MZ6b%\u0016\fG-\u001a:\u0011\u0005%RS\"\u0001\u0002\n\u0005-\u0012!!E&bM.\fwJ\u001a4tKR\u0014V-\u00193fe\"AQ\u0006\u0001B\u0001B\u0003%a&A\nfq\u0016\u001cW\u000f^8s\u0017\u000647.\u0019)be\u0006l7\u000f\u0005\u00030iY\u0002U\"\u0001\u0019\u000b\u0005E\u0012\u0014\u0001B;uS2T\u0011aM\u0001\u0005U\u00064\u0018-\u0003\u00026a\t\u0019Q*\u00199\u0011\u0005]jdB\u0001\u001d<\u001b\u0005I$\"\u0001\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qJ\u0014A\u0002)sK\u0012,g-\u0003\u0002?\u007f\t11\u000b\u001e:j]\u001eT!\u0001P\u001d\u0011\u0005\u0005#U\"\u0001\"\u000b\u0005\r\u0013\u0014\u0001\u00027b]\u001eL!!\u0012\"\u0003\r=\u0013'.Z2u\u0011!9\u0005A!A!\u0002\u0013A\u0015!D:pkJ\u001cWm\u00149uS>t7\u000f\u0005\u00038\u0013Z2\u0014BA\u001b@\u0011!Y\u0005A!A!\u0002\u0013a\u0015A\u00044bS2|e\u000eR1uC2{7o\u001d\t\u0003q5K!AT\u001d\u0003\u000f\t{w\u000e\\3b]\"A\u0001\u000b\u0001B\u0001B\u0003%\u0011+A\bti\u0006\u0014H/\u001b8h\u001f\u001a47/\u001a;t!\tI#+\u0003\u0002T\u0005\t)2*\u00194lC>3gm]3u%\u0006tw-\u001a'j[&$\b\u0002C+\u0001\u0005\u0003\u0005\u000b\u0011B)\u0002\u001b\u0015tG-\u001b8h\u001f\u001a47/\u001a;t\u0011\u00159\u0006\u0001\"\u0001Y\u0003\u0019a\u0014N\\5u}QA\u0011LW.];z{\u0006\r\u0005\u0002*\u0001!)QD\u0016a\u0001A!)qE\u0016a\u0001Q!)QF\u0016a\u0001]!)qI\u0016a\u0001\u0011\")1J\u0016a\u0001\u0019\")\u0001K\u0016a\u0001#\")QK\u0016a\u0001#\"9!\r\u0001b\u0001\n\u0013\u0019\u0017!\u00049pY2$\u0016.\\3pkRl5/F\u0001e!\tAT-\u0003\u0002gs\t!Aj\u001c8h\u0011\u0019A\u0007\u0001)A\u0005I\u0006q\u0001o\u001c7m)&lWm\\;u\u001bN\u0004\u0003\"\u00026\u0001\t\u0003Z\u0017AB:dQ\u0016l\u0017-F\u0001m!\ti\u0007/D\u0001o\u0015\tyG!A\u0003usB,7/\u0003\u0002r]\nQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000bM\u0004A\u0011\t;\u0002\u0013\t,\u0018\u000e\u001c3TG\u0006tG#A;\u0011\u0007YL80D\u0001x\u0015\tAh!A\u0002sI\u0012L!A_<\u0003\u0007I#E\t\u0005\u0002\"y&\u0011Q\u0010\u0002\u0002\u0004%><\bBB@\u0001\t\u0013\t\t!A\nhKR\u0004\u0016M\u001d;ji&|gn\u00144gg\u0016$8\u000f\u0006\u0003\u0002\u0004\u0005U\u0001#B\u001cJ\u0003\u000b!\u0007\u0003BA\u0004\u0003#i!!!\u0003\u000b\t\u0005-\u0011QB\u0001\u0007G>lWn\u001c8\u000b\u0007\u0005=\u0001\"A\u0003lC\u001a\\\u0017-\u0003\u0003\u0002\u0014\u0005%!A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u0007\u0003/q\b\u0019A)\u0002\u0019-\fgm[1PM\u001a\u001cX\r^:")
public class KafkaRelation
extends BaseRelation
implements TableScan,
Logging {
    private final SQLContext sqlContext;
    private final KafkaOffsetReader kafkaReader;
    private final Map<String, Object> executorKafkaParams;
    private final boolean failOnDataLoss;
    private final KafkaOffsetRangeLimit startingOffsets;
    private final KafkaOffsetRangeLimit endingOffsets;
    private final long pollTimeoutMs;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    private long pollTimeoutMs() {
        return this.pollTimeoutMs;
    }

    public StructType schema() {
        return KafkaOffsetReader$.MODULE$.kafkaSchema();
    }

    /*
     * WARNING - void declaration
     */
    public RDD<Row> buildScan() {
        void var2_2;
        void var1_1;
        scala.collection.immutable.Map<TopicPartition, Object> fromPartitionOffsets = this.getPartitionOffsets(this.startingOffsets);
        scala.collection.immutable.Map<TopicPartition, Object> untilPartitionOffsets = this.getPartitionOffsets(this.endingOffsets);
        Set set2 = fromPartitionOffsets.keySet();
        Set set3 = untilPartitionOffsets.keySet();
        if (!(set2 != null ? !set2.equals(set3) : set3 != null)) {
            KafkaSourceRDDOffsetRange[] offsetRanges = (KafkaSourceRDDOffsetRange[])((TraversableOnce)untilPartitionOffsets.keySet().map((Function1)new Serializable(this, fromPartitionOffsets, untilPartitionOffsets){
                public static final long serialVersionUID = 0L;
                private final scala.collection.immutable.Map fromPartitionOffsets$1;
                private final scala.collection.immutable.Map untilPartitionOffsets$1;

                public final KafkaSourceRDDOffsetRange apply(TopicPartition tp) {
                    long fromOffset = BoxesRunTime.unboxToLong((Object)this.fromPartitionOffsets$1.get((Object)tp).getOrElse((Function0)new Serializable(this, tp){
                        public static final long serialVersionUID = 0L;
                        private final TopicPartition tp$1;

                        public final Nothing$ apply() {
                            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " doesn't have a from offset"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tp$1})));
                        }
                        {
                            this.tp$1 = tp$1;
                        }
                    }));
                    long untilOffset = BoxesRunTime.unboxToLong((Object)this.untilPartitionOffsets$1.apply((Object)tp));
                    return new KafkaSourceRDDOffsetRange(tp, fromOffset, untilOffset, (Option<String>)None$.MODULE$);
                }
                {
                    this.fromPartitionOffsets$1 = fromPartitionOffsets$1;
                    this.untilPartitionOffsets$1 = untilPartitionOffsets$1;
                }
            }, Set$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(KafkaSourceRDDOffsetRange.class));
            this.logInfo((Function0<String>)new Serializable(this, offsetRanges){
                public static final long serialVersionUID = 0L;
                private final KafkaSourceRDDOffsetRange[] offsetRanges$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"GetBatch generating RDD of offset range: ").append((Object)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.offsetRanges$1).sortBy((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(KafkaSourceRDDOffsetRange x$1) {
                            return x$1.topicPartition().toString();
                        }
                    }, (Ordering)Ordering.String$.MODULE$)).mkString(", ")).toString();
                }
                {
                    this.offsetRanges$1 = offsetRanges$1;
                }
            });
            RDD rdd = new KafkaSourceRDD(this.sqlContext().sparkContext(), this.executorKafkaParams, (Seq<KafkaSourceRDDOffsetRange>)Predef$.MODULE$.wrapRefArray((Object[])offsetRanges), this.pollTimeoutMs(), this.failOnDataLoss, false).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final InternalRow apply(ConsumerRecord<byte[], byte[]> cr) {
                    return InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cr.key(), cr.value(), UTF8String.fromString((String)cr.topic()), BoxesRunTime.boxToInteger((int)cr.partition()), BoxesRunTime.boxToLong((long)cr.offset()), BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.fromJavaTimestamp(new Timestamp(cr.timestamp()))), BoxesRunTime.boxToInteger((int)cr.timestampType().id)}));
                }
            }, ClassTag$.MODULE$.apply(InternalRow.class));
            return this.sqlContext().internalCreateDataFrame(rdd, this.schema()).rdd();
        }
        Ordering topicOrdering = package$.MODULE$.Ordering().by((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(TopicPartition t) {
                return t.topic();
            }
        }, (Ordering)Ordering.String$.MODULE$);
        String fromTopics = ((TraversableOnce)var1_1.keySet().toList().sorted(topicOrdering)).mkString(",");
        String untilTopics = ((TraversableOnce)var2_2.keySet().toList().sorted(topicOrdering)).mkString(",");
        throw new IllegalStateException(new StringBuilder().append((Object)"different topic partitions ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"for starting offsets topics[", "] and "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fromTopics}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ending offsets topics[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{untilTopics}))).toString());
    }

    private scala.collection.immutable.Map<TopicPartition, Object> getPartitionOffsets(KafkaOffsetRangeLimit kafkaOffsets) {
        KafkaOffsetRangeLimit kafkaOffsetRangeLimit;
        block5: {
            scala.collection.immutable.Map map;
            block3: {
                Set<TopicPartition> partitions2;
                block4: {
                    block2: {
                        partitions2 = this.kafkaReader.fetchTopicPartitions();
                        kafkaOffsetRangeLimit = kafkaOffsets;
                        if (!EarliestOffsetRangeLimit$.MODULE$.equals(kafkaOffsetRangeLimit)) break block2;
                        map = ((TraversableOnce)partitions2.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<TopicPartition, Object> apply(TopicPartition x0$1) {
                                TopicPartition topicPartition = x0$1;
                                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)BoxesRunTime.boxToLong((long)KafkaOffsetRangeLimit$.MODULE$.EARLIEST()));
                                return tuple2;
                            }
                        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                        break block3;
                    }
                    if (!LatestOffsetRangeLimit$.MODULE$.equals(kafkaOffsetRangeLimit)) break block4;
                    map = ((TraversableOnce)partitions2.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<TopicPartition, Object> apply(TopicPartition x0$2) {
                            TopicPartition topicPartition = x0$2;
                            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)BoxesRunTime.boxToLong((long)KafkaOffsetRangeLimit$.MODULE$.LATEST()));
                            return tuple2;
                        }
                    }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                    break block3;
                }
                if (!(kafkaOffsetRangeLimit instanceof SpecificOffsetRangeLimit)) break block5;
                SpecificOffsetRangeLimit specificOffsetRangeLimit = (SpecificOffsetRangeLimit)kafkaOffsetRangeLimit;
                scala.collection.immutable.Map<TopicPartition, Object> partitionOffsets2 = specificOffsetRangeLimit.partitionOffsets();
                map = this.validateTopicPartitions$1(partitions2, partitionOffsets2);
            }
            return map;
        }
        throw new MatchError((Object)kafkaOffsetRangeLimit);
    }

    private final scala.collection.immutable.Map validateTopicPartitions$1(Set partitions2, scala.collection.immutable.Map partitionOffsets2) {
        Set set2 = partitions2;
        Set set3 = partitionOffsets2.keySet();
        Predef$.MODULE$.assert(!(set2 != null ? !set2.equals(set3) : set3 != null), (Function0)new Serializable(this, partitions2, partitionOffsets2){
            public static final long serialVersionUID = 0L;
            private final Set partitions$1;
            private final scala.collection.immutable.Map partitionOffsets$1;

            public final String apply() {
                return new StringBuilder().append((Object)"If startingOffsets contains specific offsets, you must specify all TopicPartitions.\nUse -1 for latest, -2 for earliest, if you don't care.\n").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Specified: ", " Assigned: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionOffsets$1.keySet(), this.partitions$1}))).toString();
            }
            {
                this.partitions$1 = partitions$1;
                this.partitionOffsets$1 = partitionOffsets$1;
            }
        });
        this.logDebug((Function0<String>)new Serializable(this, partitions2, partitionOffsets2){
            public static final long serialVersionUID = 0L;
            private final Set partitions$1;
            private final scala.collection.immutable.Map partitionOffsets$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partitions assigned to consumer: ", ". Seeking to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitions$1, this.partitionOffsets$1}));
            }
            {
                this.partitions$1 = partitions$1;
                this.partitionOffsets$1 = partitionOffsets$1;
            }
        });
        return partitionOffsets2;
    }

    public KafkaRelation(SQLContext sqlContext, KafkaOffsetReader kafkaReader, Map<String, Object> executorKafkaParams, scala.collection.immutable.Map<String, String> sourceOptions, boolean failOnDataLoss2, KafkaOffsetRangeLimit startingOffsets, KafkaOffsetRangeLimit endingOffsets) {
        this.sqlContext = sqlContext;
        this.kafkaReader = kafkaReader;
        this.executorKafkaParams = executorKafkaParams;
        this.failOnDataLoss = failOnDataLoss2;
        this.startingOffsets = startingOffsets;
        this.endingOffsets = endingOffsets;
        Logging.class.$init$((Logging)this);
        KafkaOffsetRangeLimit kafkaOffsetRangeLimit = startingOffsets;
        LatestOffsetRangeLimit$ latestOffsetRangeLimit$ = LatestOffsetRangeLimit$.MODULE$;
        Predef$.MODULE$.assert(kafkaOffsetRangeLimit != null ? !kafkaOffsetRangeLimit.equals(latestOffsetRangeLimit$) : latestOffsetRangeLimit$ != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Starting offset not allowed to be set to latest offsets.";
            }
        });
        KafkaOffsetRangeLimit kafkaOffsetRangeLimit2 = endingOffsets;
        EarliestOffsetRangeLimit$ earliestOffsetRangeLimit$ = EarliestOffsetRangeLimit$.MODULE$;
        Predef$.MODULE$.assert(kafkaOffsetRangeLimit2 != null ? !kafkaOffsetRangeLimit2.equals(earliestOffsetRangeLimit$) : earliestOffsetRangeLimit$ != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Ending offset not allowed to be set to earliest offsets.";
            }
        });
        this.pollTimeoutMs = new StringOps(Predef$.MODULE$.augmentString((String)sourceOptions.getOrElse((Object)"kafkaConsumer.pollTimeoutMs", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaRelation $outer;

            public final String apply() {
                return ((Object)BoxesRunTime.boxToLong((long)this.$outer.sqlContext().sparkContext().conf().getTimeAsMs("spark.network.timeout", "120s"))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }))).toLong();
    }
}

