/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.yarn;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.server.api.ApplicationInitializationContext;
import org.apache.hadoop.yarn.server.api.ApplicationTerminationContext;
import org.apache.hadoop.yarn.server.api.AuxiliaryService;
import org.apache.hadoop.yarn.server.api.ContainerInitializationContext;
import org.apache.hadoop.yarn.server.api.ContainerTerminationContext;
import org.apache.spark.network.TransportContext;
import org.apache.spark.network.sasl.SaslServerBootstrap;
import org.apache.spark.network.sasl.SecretKeyHolder;
import org.apache.spark.network.sasl.ShuffleSecretManager;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.TransportServer;
import org.apache.spark.network.shuffle.ExternalShuffleBlockHandler;
import org.apache.spark.network.util.ConfigProvider;
import org.apache.spark.network.util.TransportConf;
import org.apache.spark.network.yarn.util.HadoopConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YarnShuffleService
extends AuxiliaryService {
    private final Logger logger = LoggerFactory.getLogger(YarnShuffleService.class);
    private static final String SPARK_SHUFFLE_SERVICE_PORT_KEY = "spark.shuffle.service.port";
    private static final int DEFAULT_SPARK_SHUFFLE_SERVICE_PORT = 7337;
    private static final String SPARK_AUTHENTICATE_KEY = "spark.authenticate";
    private static final boolean DEFAULT_SPARK_AUTHENTICATE = false;
    private ShuffleSecretManager secretManager;
    private TransportServer shuffleServer = null;
    @VisibleForTesting
    ExternalShuffleBlockHandler blockHandler;
    @VisibleForTesting
    File registeredExecutorFile;
    @VisibleForTesting
    static int boundPort = -1;
    @VisibleForTesting
    static YarnShuffleService instance;

    public YarnShuffleService() {
        super("spark_shuffle");
        this.logger.info("Initializing YARN shuffle service for Spark");
        instance = this;
    }

    private boolean isAuthenticationEnabled() {
        return this.secretManager != null;
    }

    protected void serviceInit(Configuration conf) {
        this.registeredExecutorFile = this.findRegisteredExecutorFile(conf.getStrings("yarn.nodemanager.local-dirs"));
        TransportConf transportConf = new TransportConf((ConfigProvider)new HadoopConfigProvider(conf));
        boolean authEnabled = conf.getBoolean(SPARK_AUTHENTICATE_KEY, false);
        try {
            this.blockHandler = new ExternalShuffleBlockHandler(transportConf, this.registeredExecutorFile);
        }
        catch (Exception e) {
            this.logger.error("Failed to initialize external shuffle service", (Throwable)e);
        }
        ArrayList bootstraps = Lists.newArrayList();
        if (authEnabled) {
            this.secretManager = new ShuffleSecretManager();
            bootstraps.add(new SaslServerBootstrap(transportConf, (SecretKeyHolder)this.secretManager));
        }
        int port = conf.getInt(SPARK_SHUFFLE_SERVICE_PORT_KEY, 7337);
        TransportContext transportContext = new TransportContext(transportConf, (RpcHandler)this.blockHandler);
        this.shuffleServer = transportContext.createServer(port, (List)bootstraps);
        boundPort = port = this.shuffleServer.getPort();
        String authEnabledString = authEnabled ? "enabled" : "not enabled";
        this.logger.info("Started YARN shuffle service for Spark on port {}. Authentication is {}.  Registered executor file is {}", new Object[]{port, authEnabledString, this.registeredExecutorFile});
    }

    public void initializeApplication(ApplicationInitializationContext context) {
        String appId = context.getApplicationId().toString();
        try {
            ByteBuffer shuffleSecret = context.getApplicationDataForService();
            this.logger.info("Initializing application {}", (Object)appId);
            if (this.isAuthenticationEnabled()) {
                this.secretManager.registerApp(appId, shuffleSecret);
            }
        }
        catch (Exception e) {
            this.logger.error("Exception when initializing application {}", (Object)appId, (Object)e);
        }
    }

    public void stopApplication(ApplicationTerminationContext context) {
        String appId = context.getApplicationId().toString();
        try {
            this.logger.info("Stopping application {}", (Object)appId);
            if (this.isAuthenticationEnabled()) {
                this.secretManager.unregisterApp(appId);
            }
            this.blockHandler.applicationRemoved(appId, false);
        }
        catch (Exception e) {
            this.logger.error("Exception when stopping application {}", (Object)appId, (Object)e);
        }
    }

    public void initializeContainer(ContainerInitializationContext context) {
        ContainerId containerId = context.getContainerId();
        this.logger.info("Initializing container {}", (Object)containerId);
    }

    public void stopContainer(ContainerTerminationContext context) {
        ContainerId containerId = context.getContainerId();
        this.logger.info("Stopping container {}", (Object)containerId);
    }

    private File findRegisteredExecutorFile(String[] localDirs) {
        for (String dir : localDirs) {
            File f = new File(dir, "registeredExecutors.ldb");
            if (!f.exists()) continue;
            return f;
        }
        return new File(localDirs[0], "registeredExecutors.ldb");
    }

    protected void serviceStop() {
        try {
            if (this.shuffleServer != null) {
                this.shuffleServer.close();
            }
            if (this.blockHandler != null) {
                this.blockHandler.close();
            }
        }
        catch (Exception e) {
            this.logger.error("Exception when stopping service", (Throwable)e);
        }
    }

    public ByteBuffer getMetaData() {
        return ByteBuffer.allocate(0);
    }
}

