/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle.protocol.mesos;

import com.google.common.base.Objects;
import io.netty.buffer.ByteBuf;
import org.apache.spark.network.protocol.Encoders;
import org.apache.spark.network.shuffle.protocol.BlockTransferMessage;

public class RegisterDriver
extends BlockTransferMessage {
    private final String appId;
    private final long heartbeatTimeoutMs;

    public RegisterDriver(String appId, long heartbeatTimeoutMs) {
        this.appId = appId;
        this.heartbeatTimeoutMs = heartbeatTimeoutMs;
    }

    public String getAppId() {
        return this.appId;
    }

    public long getHeartbeatTimeoutMs() {
        return this.heartbeatTimeoutMs;
    }

    @Override
    protected BlockTransferMessage.Type type() {
        return BlockTransferMessage.Type.REGISTER_DRIVER;
    }

    public int encodedLength() {
        return Encoders.Strings.encodedLength((String)this.appId) + 8;
    }

    public void encode(ByteBuf buf) {
        Encoders.Strings.encode((ByteBuf)buf, (String)this.appId);
        buf.writeLong(this.heartbeatTimeoutMs);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.appId, this.heartbeatTimeoutMs});
    }

    public boolean equals(Object o) {
        if (!(o instanceof RegisterDriver)) {
            return false;
        }
        return Objects.equal((Object)this.appId, (Object)((RegisterDriver)o).appId);
    }

    public static RegisterDriver decode(ByteBuf buf) {
        String appId = Encoders.Strings.decode((ByteBuf)buf);
        long heartbeatTimeout = buf.readLong();
        return new RegisterDriver(appId, heartbeatTimeout);
    }
}

