/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle.mesos;

import java.io.IOException;
import org.apache.spark.network.client.RpcResponseCallback;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.sasl.SecretKeyHolder;
import org.apache.spark.network.shuffle.ExternalShuffleClient;
import org.apache.spark.network.shuffle.protocol.mesos.RegisterDriver;
import org.apache.spark.network.util.TransportConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MesosExternalShuffleClient
extends ExternalShuffleClient {
    private final Logger logger = LoggerFactory.getLogger(MesosExternalShuffleClient.class);

    public MesosExternalShuffleClient(TransportConf conf, SecretKeyHolder secretKeyHolder, boolean saslEnabled, boolean saslEncryptionEnabled) {
        super(conf, secretKeyHolder, saslEnabled, saslEncryptionEnabled);
    }

    public void registerDriverWithShuffleService(String host, int port) throws IOException {
        this.checkInit();
        byte[] registerDriver = new RegisterDriver(this.appId).toByteArray();
        TransportClient client = this.clientFactory.createClient(host, port);
        client.sendRpc(registerDriver, new RpcResponseCallback(){

            public void onSuccess(byte[] response) {
                MesosExternalShuffleClient.this.logger.info("Successfully registered app " + MesosExternalShuffleClient.this.appId + " with external shuffle service.");
            }

            public void onFailure(Throwable e) {
                MesosExternalShuffleClient.this.logger.warn("Unable to register app " + MesosExternalShuffleClient.this.appId + " with external shuffle service. " + "Please manually remove shuffle data after driver exit. Error: " + e);
            }
        });
    }
}

