/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;
import org.apache.spark.network.protocol.ChunkFetchFailure;
import org.apache.spark.network.protocol.ChunkFetchRequest;
import org.apache.spark.network.protocol.ChunkFetchSuccess;
import org.apache.spark.network.protocol.Message;
import org.apache.spark.network.protocol.OneWayMessage;
import org.apache.spark.network.protocol.RpcFailure;
import org.apache.spark.network.protocol.RpcRequest;
import org.apache.spark.network.protocol.RpcResponse;
import org.apache.spark.network.protocol.StreamFailure;
import org.apache.spark.network.protocol.StreamRequest;
import org.apache.spark.network.protocol.StreamResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public final class MessageDecoder
extends MessageToMessageDecoder<ByteBuf> {
    private final Logger logger = LoggerFactory.getLogger(MessageDecoder.class);

    public void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        Message.Type msgType = Message.Type.decode(in);
        Message decoded = this.decode(msgType, in);
        assert (decoded.type() == msgType);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Received message {}: {}", (Object)msgType, (Object)decoded);
        }
        out.add(decoded);
    }

    private Message decode(Message.Type msgType, ByteBuf in) {
        switch (msgType) {
            case ChunkFetchRequest: {
                return ChunkFetchRequest.decode(in);
            }
            case ChunkFetchSuccess: {
                return ChunkFetchSuccess.decode(in);
            }
            case ChunkFetchFailure: {
                return ChunkFetchFailure.decode(in);
            }
            case RpcRequest: {
                return RpcRequest.decode(in);
            }
            case RpcResponse: {
                return RpcResponse.decode(in);
            }
            case RpcFailure: {
                return RpcFailure.decode(in);
            }
            case OneWayMessage: {
                return OneWayMessage.decode(in);
            }
            case StreamRequest: {
                return StreamRequest.decode(in);
            }
            case StreamResponse: {
                return StreamResponse.decode(in);
            }
            case StreamFailure: {
                return StreamFailure.decode(in);
            }
        }
        throw new IllegalArgumentException("Unexpected message type: " + msgType);
    }
}

