/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.server;

import com.google.common.base.Throwables;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.ByteBuffer;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.buffer.NioManagedBuffer;
import org.apache.spark.network.client.RpcResponseCallback;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.protocol.ChunkFetchFailure;
import org.apache.spark.network.protocol.ChunkFetchRequest;
import org.apache.spark.network.protocol.ChunkFetchSuccess;
import org.apache.spark.network.protocol.Encodable;
import org.apache.spark.network.protocol.OneWayMessage;
import org.apache.spark.network.protocol.RequestMessage;
import org.apache.spark.network.protocol.RpcFailure;
import org.apache.spark.network.protocol.RpcRequest;
import org.apache.spark.network.protocol.RpcResponse;
import org.apache.spark.network.protocol.StreamFailure;
import org.apache.spark.network.protocol.StreamRequest;
import org.apache.spark.network.protocol.StreamResponse;
import org.apache.spark.network.server.MessageHandler;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.StreamManager;
import org.apache.spark.network.util.NettyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportRequestHandler
extends MessageHandler<RequestMessage> {
    private final Logger logger = LoggerFactory.getLogger(TransportRequestHandler.class);
    private final Channel channel;
    private final TransportClient reverseClient;
    private final RpcHandler rpcHandler;
    private final StreamManager streamManager;

    public TransportRequestHandler(Channel channel, TransportClient reverseClient, RpcHandler rpcHandler) {
        this.channel = channel;
        this.reverseClient = reverseClient;
        this.rpcHandler = rpcHandler;
        this.streamManager = rpcHandler.getStreamManager();
    }

    @Override
    public void exceptionCaught(Throwable cause) {
        this.rpcHandler.exceptionCaught(cause, this.reverseClient);
    }

    @Override
    public void channelActive() {
        this.rpcHandler.channelActive(this.reverseClient);
    }

    @Override
    public void channelInactive() {
        if (this.streamManager != null) {
            try {
                this.streamManager.connectionTerminated(this.channel);
            }
            catch (RuntimeException e) {
                this.logger.error("StreamManager connectionTerminated() callback failed.", (Throwable)e);
            }
        }
        this.rpcHandler.channelInactive(this.reverseClient);
    }

    @Override
    public void handle(RequestMessage request) {
        if (request instanceof ChunkFetchRequest) {
            this.processFetchRequest((ChunkFetchRequest)request);
        } else if (request instanceof RpcRequest) {
            this.processRpcRequest((RpcRequest)request);
        } else if (request instanceof OneWayMessage) {
            this.processOneWayMessage((OneWayMessage)request);
        } else if (request instanceof StreamRequest) {
            this.processStreamRequest((StreamRequest)request);
        } else {
            throw new IllegalArgumentException("Unknown request type: " + request);
        }
    }

    private void processFetchRequest(ChunkFetchRequest req) {
        ManagedBuffer buf;
        String client = NettyUtils.getRemoteAddress(this.channel);
        this.logger.trace("Received req from {} to fetch block {}", (Object)client, (Object)req.streamChunkId);
        try {
            this.streamManager.checkAuthorization(this.reverseClient, req.streamChunkId.streamId);
            this.streamManager.registerChannel(this.channel, req.streamChunkId.streamId);
            buf = this.streamManager.getChunk(req.streamChunkId.streamId, req.streamChunkId.chunkIndex);
        }
        catch (Exception e) {
            this.logger.error(String.format("Error opening block %s for request from %s", req.streamChunkId, client), (Throwable)e);
            this.respond(new ChunkFetchFailure(req.streamChunkId, Throwables.getStackTraceAsString((Throwable)e)));
            return;
        }
        this.respond(new ChunkFetchSuccess(req.streamChunkId, buf));
    }

    private void processStreamRequest(StreamRequest req) {
        ManagedBuffer buf;
        String client = NettyUtils.getRemoteAddress(this.channel);
        try {
            buf = this.streamManager.openStream(req.streamId);
        }
        catch (Exception e) {
            this.logger.error(String.format("Error opening stream %s for request from %s", req.streamId, client), (Throwable)e);
            this.respond(new StreamFailure(req.streamId, Throwables.getStackTraceAsString((Throwable)e)));
            return;
        }
        if (buf != null) {
            this.respond(new StreamResponse(req.streamId, buf.size(), buf));
        } else {
            this.respond(new StreamFailure(req.streamId, String.format("Stream '%s' was not found.", req.streamId)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRpcRequest(final RpcRequest req) {
        try {
            this.rpcHandler.receive(this.reverseClient, req.body().nioByteBuffer(), new RpcResponseCallback(){

                @Override
                public void onSuccess(ByteBuffer response) {
                    TransportRequestHandler.this.respond(new RpcResponse(req.requestId, new NioManagedBuffer(response)));
                }

                @Override
                public void onFailure(Throwable e) {
                    TransportRequestHandler.this.respond(new RpcFailure(req.requestId, Throwables.getStackTraceAsString((Throwable)e)));
                }
            });
        }
        catch (Exception e) {
            this.logger.error("Error while invoking RpcHandler#receive() on RPC id " + req.requestId, (Throwable)e);
            this.respond(new RpcFailure(req.requestId, Throwables.getStackTraceAsString((Throwable)e)));
        }
        finally {
            req.body().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processOneWayMessage(OneWayMessage req) {
        try {
            this.rpcHandler.receive(this.reverseClient, req.body().nioByteBuffer());
        }
        catch (Exception e) {
            this.logger.error("Error while invoking RpcHandler#receive() for one-way message.", (Throwable)e);
        }
        finally {
            req.body().release();
        }
    }

    private void respond(final Encodable result) {
        final String remoteAddress = this.channel.remoteAddress().toString();
        this.channel.writeAndFlush((Object)result).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    TransportRequestHandler.this.logger.trace(String.format("Sent result %s to client %s", result, remoteAddress));
                } else {
                    TransportRequestHandler.this.logger.error(String.format("Error sending result %s to %s; closing connection", result, remoteAddress), future.cause());
                    TransportRequestHandler.this.channel.close();
                }
            }
        });
    }
}

