/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.protocol;

import com.google.common.base.Objects;
import io.netty.buffer.ByteBuf;
import org.apache.spark.network.protocol.AbstractMessage;
import org.apache.spark.network.protocol.Encoders;
import org.apache.spark.network.protocol.Message;
import org.apache.spark.network.protocol.ResponseMessage;

public final class RpcFailure
extends AbstractMessage
implements ResponseMessage {
    public final long requestId;
    public final String errorString;

    public RpcFailure(long requestId, String errorString) {
        this.requestId = requestId;
        this.errorString = errorString;
    }

    @Override
    public Message.Type type() {
        return Message.Type.RpcFailure;
    }

    @Override
    public int encodedLength() {
        return 8 + Encoders.Strings.encodedLength(this.errorString);
    }

    @Override
    public void encode(ByteBuf buf) {
        buf.writeLong(this.requestId);
        Encoders.Strings.encode(buf, this.errorString);
    }

    public static RpcFailure decode(ByteBuf buf) {
        long requestId = buf.readLong();
        String errorString = Encoders.Strings.decode(buf);
        return new RpcFailure(requestId, errorString);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.requestId, this.errorString});
    }

    public boolean equals(Object other) {
        if (other instanceof RpcFailure) {
            RpcFailure o = (RpcFailure)other;
            return this.requestId == o.requestId && this.errorString.equals(o.errorString);
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("requestId", this.requestId).add("errorString", (Object)this.errorString).toString();
    }
}

