/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree;

import org.apache.spark.Logging;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.DecisionTree;
import org.apache.spark.mllib.tree.DecisionTree$;
import org.apache.spark.mllib.tree.RandomForest;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.FeatureType$;
import org.apache.spark.mllib.tree.configuration.QuantileStrategy$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.configuration.Strategy$;
import org.apache.spark.mllib.tree.impl.BaggedPoint;
import org.apache.spark.mllib.tree.impl.DTStatsAggregator;
import org.apache.spark.mllib.tree.impl.DecisionTreeMetadata;
import org.apache.spark.mllib.tree.impl.NodeIdCache;
import org.apache.spark.mllib.tree.impl.NodeIndexUpdater;
import org.apache.spark.mllib.tree.impl.TimeTracker;
import org.apache.spark.mllib.tree.impl.TreePoint;
import org.apache.spark.mllib.tree.impurity.Impurities$;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.impurity.ImpurityCalculator;
import org.apache.spark.mllib.tree.model.Bin;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.DummyHighSplit;
import org.apache.spark.mllib.tree.model.DummyLowSplit;
import org.apache.spark.mllib.tree.model.InformationGainStats;
import org.apache.spark.mllib.tree.model.InformationGainStats$;
import org.apache.spark.mllib.tree.model.Node;
import org.apache.spark.mllib.tree.model.Node$;
import org.apache.spark.mllib.tree.model.Predict;
import org.apache.spark.mllib.tree.model.Split;
import org.apache.spark.rdd.EmptyRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.util.random.XORShiftRandom;
import org.slf4j.Logger;
import scala.Array$;
import scala.Double$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.TraversableViewLike;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.IndexedSeqView$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

public final class DecisionTree$
implements Serializable,
Logging {
    public static final DecisionTree$ MODULE$;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new DecisionTree$();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public DecisionTreeModel train(RDD<LabeledPoint> input, Strategy strategy) {
        return new DecisionTree(strategy).run(input);
    }

    public DecisionTreeModel train(RDD<LabeledPoint> input, Enumeration.Value algo, Impurity impurity, int maxDepth) {
        Strategy strategy = new Strategy(algo, impurity, maxDepth, Strategy$.MODULE$.$lessinit$greater$default$4(), Strategy$.MODULE$.$lessinit$greater$default$5(), Strategy$.MODULE$.$lessinit$greater$default$6(), Strategy$.MODULE$.$lessinit$greater$default$7(), Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13());
        return new DecisionTree(strategy).run(input);
    }

    public DecisionTreeModel train(RDD<LabeledPoint> input, Enumeration.Value algo, Impurity impurity, int maxDepth, int numClasses) {
        Strategy strategy = new Strategy(algo, impurity, maxDepth, numClasses, Strategy$.MODULE$.$lessinit$greater$default$5(), Strategy$.MODULE$.$lessinit$greater$default$6(), Strategy$.MODULE$.$lessinit$greater$default$7(), Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13());
        return new DecisionTree(strategy).run(input);
    }

    public DecisionTreeModel train(RDD<LabeledPoint> input, Enumeration.Value algo, Impurity impurity, int maxDepth, int numClasses, int maxBins, Enumeration.Value quantileCalculationStrategy, scala.collection.immutable.Map<Object, Object> categoricalFeaturesInfo) {
        Strategy strategy = new Strategy(algo, impurity, maxDepth, numClasses, maxBins, quantileCalculationStrategy, categoricalFeaturesInfo, Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13());
        return new DecisionTree(strategy).run(input);
    }

    public DecisionTreeModel trainClassifier(RDD<LabeledPoint> input, int numClasses, scala.collection.immutable.Map<Object, Object> categoricalFeaturesInfo, String impurity, int maxDepth, int maxBins) {
        Impurity impurityType = Impurities$.MODULE$.fromString(impurity);
        return this.train(input, Algo$.MODULE$.Classification(), impurityType, maxDepth, numClasses, maxBins, QuantileStrategy$.MODULE$.Sort(), categoricalFeaturesInfo);
    }

    public DecisionTreeModel trainClassifier(JavaRDD<LabeledPoint> input, int numClasses, java.util.Map<Integer, Integer> categoricalFeaturesInfo, String impurity, int maxDepth, int maxBins) {
        return this.trainClassifier((RDD<LabeledPoint>)input.rdd(), numClasses, (scala.collection.immutable.Map<Object, Object>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(categoricalFeaturesInfo).asScala()).toMap(Predef$.MODULE$.conforms()), impurity, maxDepth, maxBins);
    }

    public DecisionTreeModel trainRegressor(RDD<LabeledPoint> input, scala.collection.immutable.Map<Object, Object> categoricalFeaturesInfo, String impurity, int maxDepth, int maxBins) {
        Impurity impurityType = Impurities$.MODULE$.fromString(impurity);
        return this.train(input, Algo$.MODULE$.Regression(), impurityType, maxDepth, 0, maxBins, QuantileStrategy$.MODULE$.Sort(), categoricalFeaturesInfo);
    }

    public DecisionTreeModel trainRegressor(JavaRDD<LabeledPoint> input, java.util.Map<Integer, Integer> categoricalFeaturesInfo, String impurity, int maxDepth, int maxBins) {
        return this.trainRegressor((RDD<LabeledPoint>)input.rdd(), (scala.collection.immutable.Map<Object, Object>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(categoricalFeaturesInfo).asScala()).toMap(Predef$.MODULE$.conforms()), impurity, maxDepth, maxBins);
    }

    public int org$apache$spark$mllib$tree$DecisionTree$$predictNodeIndex(Node node, int[] binnedFeatures, Bin[][] bins, Set<Object> unorderedFeatures) {
        while (true) {
            boolean splitLeft;
            block9: {
                int n;
                block8: {
                    boolean bl;
                    block7: {
                        if (!node.isLeaf() && !node.split().isEmpty()) break block7;
                        n = node.id();
                        break block8;
                    }
                    int featureIndex = ((Split)node.split().get()).feature();
                    Enumeration.Value value = ((Split)node.split().get()).featureType();
                    Enumeration.Value value2 = FeatureType$.MODULE$.Continuous();
                    Enumeration.Value value3 = value;
                    if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                        int binIndex = binnedFeatures[featureIndex];
                        double featureValueUpperBound = bins[featureIndex][binIndex].highSplit().threshold();
                        bl = featureValueUpperBound <= ((Split)node.split().get()).threshold();
                    } else {
                        Enumeration.Value value4 = FeatureType$.MODULE$.Categorical();
                        Enumeration.Value value5 = value;
                        if (value4 != null ? !value4.equals(value5) : value5 != null) break;
                        int featureValue = binnedFeatures[featureIndex];
                        bl = ((Split)node.split().get()).categories().contains((Object)BoxesRunTime.boxToInteger((int)featureValue));
                    }
                    splitLeft = bl;
                    if (!node.leftNode().isEmpty() && !node.rightNode().isEmpty()) break block9;
                    n = splitLeft ? Node$.MODULE$.leftChildIndex(node.id()) : Node$.MODULE$.rightChildIndex(node.id());
                }
                return n;
            }
            if (splitLeft) {
                node = (Node)node.leftNode().get();
                continue;
            }
            node = (Node)node.rightNode().get();
        }
        throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"predictNodeIndex failed for unknown reason."})).s((Seq)Nil$.MODULE$));
    }

    private void mixedBinSeqOp(DTStatsAggregator agg, TreePoint treePoint, Split[][] splits, Set<Object> unorderedFeatures, double instanceWeight, Option<int[]> featuresForNode) {
        int numFeaturesPerNode = featuresForNode.nonEmpty() ? Predef$.MODULE$.intArrayOps((int[])featuresForNode.get()).size() : agg.metadata().numFeatures();
        for (int featureIndexIdx = 0; featureIndexIdx < numFeaturesPerNode; ++featureIndexIdx) {
            int featureIndex;
            int n = featureIndex = featuresForNode.nonEmpty() ? ((int[])featuresForNode.get())[featureIndexIdx] : featureIndexIdx;
            if (unorderedFeatures.contains((Object)BoxesRunTime.boxToInteger((int)featureIndex))) {
                int featureValue = treePoint.binnedFeatures()[featureIndex];
                Tuple2<Object, Object> tuple2 = agg.getLeftRightFeatureOffsets(featureIndexIdx);
                if (tuple2 != null) {
                    Tuple2.mcII.sp sp2;
                    int leftNodeFeatureOffset = tuple2._1$mcI$sp();
                    int rightNodeFeatureOffset = tuple2._2$mcI$sp();
                    Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(leftNodeFeatureOffset, rightNodeFeatureOffset);
                    int leftNodeFeatureOffset2 = sp3._1$mcI$sp();
                    int rightNodeFeatureOffset2 = sp3._2$mcI$sp();
                    int numSplits = agg.metadata().numSplits(featureIndex);
                    for (int splitIndex = 0; splitIndex < numSplits; ++splitIndex) {
                        if (splits[featureIndex][splitIndex].categories().contains((Object)BoxesRunTime.boxToInteger((int)featureValue))) {
                            agg.featureUpdate(leftNodeFeatureOffset2, splitIndex, treePoint.label(), instanceWeight);
                            continue;
                        }
                        agg.featureUpdate(rightNodeFeatureOffset2, splitIndex, treePoint.label(), instanceWeight);
                    }
                    continue;
                }
                throw new MatchError(tuple2);
            }
            int binIndex = treePoint.binnedFeatures()[featureIndex];
            agg.update(featureIndexIdx, binIndex, treePoint.label(), instanceWeight);
        }
    }

    private void orderedBinSeqOp(DTStatsAggregator agg, TreePoint treePoint, double instanceWeight, Option<int[]> featuresForNode) {
        double label = treePoint.label();
        if (featuresForNode.nonEmpty()) {
            for (int featureIndexIdx = 0; featureIndexIdx < Predef$.MODULE$.intArrayOps((int[])featuresForNode.get()).size(); ++featureIndexIdx) {
                int binIndex = treePoint.binnedFeatures()[((int[])featuresForNode.get())[featureIndexIdx]];
                agg.update(featureIndexIdx, binIndex, label, instanceWeight);
            }
        } else {
            int numFeatures = agg.metadata().numFeatures();
            for (int featureIndex = 0; featureIndex < numFeatures; ++featureIndex) {
                int binIndex = treePoint.binnedFeatures()[featureIndex];
                agg.update(featureIndex, binIndex, label, instanceWeight);
            }
        }
    }

    public void findBestSplits(RDD<BaggedPoint<TreePoint>> input, DecisionTreeMetadata metadata, Node[] topNodes, scala.collection.immutable.Map<Object, Node[]> nodesForGroup, scala.collection.immutable.Map<Object, scala.collection.immutable.Map<Object, RandomForest.NodeIndexInfo>> treeToNodeToIndexInfo, Split[][] splits, Bin[][] bins, Queue<Tuple2<Object, Node>> nodeQueue, TimeTracker timer, Option<NodeIdCache> nodeIdCache) {
        RDD rDD;
        int numNodes = BoxesRunTime.unboxToInt((Object)((TraversableOnce)nodesForGroup.values().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Node[] x$2) {
                return Predef$.MODULE$.refArrayOps((Object[])x$2).size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        this.logDebug((Function0<String>)new Serializable(numNodes){
            public static final long serialVersionUID = 0L;
            private final int numNodes$1;

            public final String apply() {
                return new StringBuilder().append((Object)"numNodes = ").append((Object)BoxesRunTime.boxToInteger((int)this.numNodes$1)).toString();
            }
            {
                this.numNodes$1 = numNodes$1;
            }
        });
        this.logDebug((Function0<String>)new Serializable(metadata){
            public static final long serialVersionUID = 0L;
            private final DecisionTreeMetadata metadata$1;

            public final String apply() {
                return new StringBuilder().append((Object)"numFeatures = ").append((Object)BoxesRunTime.boxToInteger((int)this.metadata$1.numFeatures())).toString();
            }
            {
                this.metadata$1 = metadata$1;
            }
        });
        this.logDebug((Function0<String>)new Serializable(metadata){
            public static final long serialVersionUID = 0L;
            private final DecisionTreeMetadata metadata$1;

            public final String apply() {
                return new StringBuilder().append((Object)"numClasses = ").append((Object)BoxesRunTime.boxToInteger((int)this.metadata$1.numClasses())).toString();
            }
            {
                this.metadata$1 = metadata$1;
            }
        });
        this.logDebug((Function0<String>)new Serializable(metadata){
            public static final long serialVersionUID = 0L;
            private final DecisionTreeMetadata metadata$1;

            public final String apply() {
                return new StringBuilder().append((Object)"isMulticlass = ").append((Object)BoxesRunTime.boxToBoolean((boolean)this.metadata$1.isMulticlass())).toString();
            }
            {
                this.metadata$1 = metadata$1;
            }
        });
        this.logDebug((Function0<String>)new Serializable(metadata){
            public static final long serialVersionUID = 0L;
            private final DecisionTreeMetadata metadata$1;

            public final String apply() {
                return new StringBuilder().append((Object)"isMulticlassWithCategoricalFeatures = ").append((Object)BoxesRunTime.boxToBoolean((boolean)this.metadata$1.isMulticlassWithCategoricalFeatures())).toString();
            }
            {
                this.metadata$1 = metadata$1;
            }
        });
        this.logDebug((Function0<String>)new Serializable(nodeIdCache){
            public static final long serialVersionUID = 0L;
            private final Option nodeIdCache$1;

            public final String apply() {
                return new StringBuilder().append((Object)"using nodeIdCache = ").append((Object)((Object)BoxesRunTime.boxToBoolean((boolean)this.nodeIdCache$1.nonEmpty())).toString()).toString();
            }
            {
                this.nodeIdCache$1 = nodeIdCache$1;
            }
        });
        Node[] nodes = new Node[numNodes];
        nodesForGroup.foreach((Function1)new Serializable(treeToNodeToIndexInfo, nodes){
            public static final long serialVersionUID = 0L;
            public final scala.collection.immutable.Map treeToNodeToIndexInfo$1;
            public final Node[] nodes$1;

            public final void apply(Tuple2<Object, Node[]> x0$3) {
                Tuple2<Object, Node[]> tuple2 = x0$3;
                if (tuple2 != null) {
                    int treeIndex = tuple2._1$mcI$sp();
                    Node[] nodesForTree = (Node[])tuple2._2();
                    Predef$.MODULE$.refArrayOps((Object[])nodesForTree).foreach((Function1)new Serializable(this, treeIndex){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.findBestSplits.7 $outer;
                        private final int treeIndex$1;

                        public final void apply(Node node) {
                            this.$outer.nodes$1[((RandomForest.NodeIndexInfo)((MapLike)this.$outer.treeToNodeToIndexInfo$1.apply((Object)BoxesRunTime.boxToInteger((int)this.treeIndex$1))).apply((Object)BoxesRunTime.boxToInteger((int)node.id()))).nodeIndexInGroup()] = node;
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.treeIndex$1 = treeIndex$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.treeToNodeToIndexInfo$1 = treeToNodeToIndexInfo$1;
                this.nodes$1 = nodes$1;
            }
        });
        timer.start("chooseSplits");
        Option nodeToFeatures = this.getNodeToFeatures$1(treeToNodeToIndexInfo, metadata);
        Broadcast nodeToFeaturesBc = input.sparkContext().broadcast((Object)nodeToFeatures, ClassTag$.MODULE$.apply(Option.class));
        if (nodeIdCache.nonEmpty()) {
            RDD qual$1 = input.zip(((NodeIdCache)nodeIdCache.get()).nodeIdsForInstances(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)));
            Serializable x$26 = new Serializable(metadata, treeToNodeToIndexInfo, splits, numNodes, nodeToFeaturesBc){
                public static final long serialVersionUID = 0L;
                public final DecisionTreeMetadata metadata$1;
                public final scala.collection.immutable.Map treeToNodeToIndexInfo$1;
                public final Split[][] splits$1;
                private final int numNodes$1;
                public final Broadcast nodeToFeaturesBc$1;

                public final Iterator<Tuple2<Object, DTStatsAggregator>> apply(Iterator<Tuple2<BaggedPoint<TreePoint>, int[]>> points) {
                    DTStatsAggregator[] nodeStatsAggregators = (DTStatsAggregator[])Array$.MODULE$.tabulate(this.numNodes$1, (Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.3 $outer;

                        public final DTStatsAggregator apply(int nodeIndex) {
                            Option featuresForNode = ((Option)this.$outer.nodeToFeaturesBc$1.value()).flatMap((Function1)new Serializable(this, nodeIndex){
                                public static final long serialVersionUID = 0L;
                                private final int nodeIndex$1;

                                public final Some<int[]> apply(scala.collection.immutable.Map<Object, int[]> nodeToFeatures) {
                                    return new Some(nodeToFeatures.apply((Object)BoxesRunTime.boxToInteger((int)this.nodeIndex$1)));
                                }
                                {
                                    this.nodeIndex$1 = nodeIndex$1;
                                }
                            });
                            return new DTStatsAggregator(this.$outer.metadata$1, (Option<int[]>)featuresForNode);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }, ClassTag$.MODULE$.apply(DTStatsAggregator.class));
                    points.foreach((Function1)new Serializable(this, nodeStatsAggregators){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.3 $outer;
                        private final DTStatsAggregator[] nodeStatsAggregators$1;

                        public final DTStatsAggregator[] apply(Tuple2<BaggedPoint<TreePoint>, int[]> x$3) {
                            return DecisionTree$.MODULE$.org$apache$spark$mllib$tree$DecisionTree$$binSeqOpWithNodeIdCache$1(this.nodeStatsAggregators$1, x$3, this.$outer.metadata$1, this.$outer.treeToNodeToIndexInfo$1, this.$outer.splits$1);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.nodeStatsAggregators$1 = nodeStatsAggregators$1;
                        }
                    });
                    return ((IterableLike)((TraversableViewLike)Predef$.MODULE$.refArrayOps((Object[])nodeStatsAggregators).view().zipWithIndex(IndexedSeqView$.MODULE$.arrCanBuildFrom())).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<Object, DTStatsAggregator> apply(Tuple2<DTStatsAggregator, Object> x$4) {
                            return x$4.swap();
                        }
                    }, Seq$.MODULE$.canBuildFrom())).iterator();
                }
                {
                    this.metadata$1 = metadata$1;
                    this.treeToNodeToIndexInfo$1 = treeToNodeToIndexInfo$1;
                    this.splits$1 = splits$1;
                    this.numNodes$1 = numNodes$1;
                    this.nodeToFeaturesBc$1 = nodeToFeaturesBc$1;
                }
            };
            boolean x$27 = qual$1.mapPartitions$default$2();
            rDD = qual$1.mapPartitions((Function1)x$26, x$27, ClassTag$.MODULE$.apply(Tuple2.class));
        } else {
            rDD = input.mapPartitions((Function1)new Serializable(metadata, topNodes, treeToNodeToIndexInfo, splits, bins, numNodes, nodeToFeaturesBc){
                public static final long serialVersionUID = 0L;
                public final DecisionTreeMetadata metadata$1;
                public final Node[] topNodes$1;
                public final scala.collection.immutable.Map treeToNodeToIndexInfo$1;
                public final Split[][] splits$1;
                public final Bin[][] bins$1;
                private final int numNodes$1;
                public final Broadcast nodeToFeaturesBc$1;

                public final Iterator<Tuple2<Object, DTStatsAggregator>> apply(Iterator<BaggedPoint<TreePoint>> points) {
                    DTStatsAggregator[] nodeStatsAggregators = (DTStatsAggregator[])Array$.MODULE$.tabulate(this.numNodes$1, (Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.6 $outer;

                        public final DTStatsAggregator apply(int nodeIndex) {
                            Option featuresForNode = ((Option)this.$outer.nodeToFeaturesBc$1.value()).flatMap((Function1)new Serializable(this, nodeIndex){
                                public static final long serialVersionUID = 0L;
                                private final int nodeIndex$2;

                                public final Some<int[]> apply(scala.collection.immutable.Map<Object, int[]> nodeToFeatures) {
                                    return new Some(nodeToFeatures.apply((Object)BoxesRunTime.boxToInteger((int)this.nodeIndex$2)));
                                }
                                {
                                    this.nodeIndex$2 = nodeIndex$2;
                                }
                            });
                            return new DTStatsAggregator(this.$outer.metadata$1, (Option<int[]>)featuresForNode);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }, ClassTag$.MODULE$.apply(DTStatsAggregator.class));
                    points.foreach((Function1)new Serializable(this, nodeStatsAggregators){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.6 $outer;
                        private final DTStatsAggregator[] nodeStatsAggregators$2;

                        public final DTStatsAggregator[] apply(BaggedPoint<TreePoint> x$5) {
                            return DecisionTree$.MODULE$.org$apache$spark$mllib$tree$DecisionTree$$binSeqOp$1(this.nodeStatsAggregators$2, x$5, this.$outer.metadata$1, this.$outer.topNodes$1, this.$outer.treeToNodeToIndexInfo$1, this.$outer.splits$1, this.$outer.bins$1);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.nodeStatsAggregators$2 = nodeStatsAggregators$2;
                        }
                    });
                    return ((IterableLike)((TraversableViewLike)Predef$.MODULE$.refArrayOps((Object[])nodeStatsAggregators).view().zipWithIndex(IndexedSeqView$.MODULE$.arrCanBuildFrom())).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<Object, DTStatsAggregator> apply(Tuple2<DTStatsAggregator, Object> x$6) {
                            return x$6.swap();
                        }
                    }, Seq$.MODULE$.canBuildFrom())).iterator();
                }
                {
                    this.metadata$1 = metadata$1;
                    this.topNodes$1 = topNodes$1;
                    this.treeToNodeToIndexInfo$1 = treeToNodeToIndexInfo$1;
                    this.splits$1 = splits$1;
                    this.bins$1 = bins$1;
                    this.numNodes$1 = numNodes$1;
                    this.nodeToFeaturesBc$1 = nodeToFeaturesBc$1;
                }
            }, input.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
        }
        RDD partitionAggregates = rDD;
        Map nodeToBestSplits = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(partitionAggregates, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(DTStatsAggregator.class), (Ordering)Ordering.Int$.MODULE$).reduceByKey((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DTStatsAggregator apply(DTStatsAggregator a, DTStatsAggregator b) {
                return a.merge(b);
            }
        }).map((Function1)new Serializable(splits, nodes, nodeToFeaturesBc){
            public static final long serialVersionUID = 0L;
            private final Split[][] splits$1;
            private final Node[] nodes$1;
            private final Broadcast nodeToFeaturesBc$1;

            public final Tuple2<Object, Tuple3<Split, InformationGainStats, Predict>> apply(Tuple2<Object, DTStatsAggregator> x0$4) {
                Tuple2<Object, DTStatsAggregator> tuple2 = x0$4;
                if (tuple2 != null) {
                    Option featuresForNode;
                    int nodeIndex = tuple2._1$mcI$sp();
                    DTStatsAggregator aggStats = (DTStatsAggregator)tuple2._2();
                    Tuple3<Split, InformationGainStats, Predict> tuple3 = DecisionTree$.MODULE$.binsToBestSplit(aggStats, this.splits$1, (Option<int[]>)(featuresForNode = ((Option)this.nodeToFeaturesBc$1.value()).map((Function1)new Serializable(this, nodeIndex){
                        public static final long serialVersionUID = 0L;
                        private final int nodeIndex$3;

                        public final int[] apply(scala.collection.immutable.Map<Object, int[]> nodeToFeatures) {
                            return (int[])nodeToFeatures.apply((Object)BoxesRunTime.boxToInteger((int)this.nodeIndex$3));
                        }
                        {
                            this.nodeIndex$3 = nodeIndex$3;
                        }
                    })), this.nodes$1[nodeIndex]);
                    if (tuple3 != null) {
                        Split split = (Split)tuple3._1();
                        InformationGainStats stats = (InformationGainStats)tuple3._2();
                        Predict predict2 = (Predict)tuple3._3();
                        if (split != null) {
                            Split split2 = split;
                            if (stats != null) {
                                InformationGainStats informationGainStats = stats;
                                if (predict2 != null) {
                                    Tuple3 tuple32;
                                    Predict predict3 = predict2;
                                    Tuple3 tuple33 = tuple32 = new Tuple3((Object)split2, (Object)informationGainStats, (Object)predict3);
                                    Split split3 = (Split)tuple33._1();
                                    InformationGainStats stats2 = (InformationGainStats)tuple33._2();
                                    Predict predict4 = (Predict)tuple33._3();
                                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)nodeIndex), (Object)new Tuple3((Object)split3, (Object)stats2, (Object)predict4));
                                    return tuple22;
                                }
                            }
                        }
                    }
                    throw new MatchError(tuple3);
                }
                throw new MatchError(tuple2);
            }
            {
                this.splits$1 = splits$1;
                this.nodes$1 = nodes$1;
                this.nodeToFeaturesBc$1 = nodeToFeaturesBc$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple3.class), (Ordering)Ordering.Int$.MODULE$).collectAsMap();
        timer.stop("chooseSplits");
        scala.collection.mutable.Map[] nodeIdUpdaters = nodeIdCache.nonEmpty() ? (scala.collection.mutable.Map[])Array$.MODULE$.fill(metadata.numTrees(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final scala.collection.mutable.Map<Object, NodeIndexUpdater> apply() {
                return (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            }
        }, ClassTag$.MODULE$.apply(scala.collection.mutable.Map.class)) : null;
        nodesForGroup.foreach((Function1)new Serializable(metadata, treeToNodeToIndexInfo, nodeQueue, nodeIdCache, nodeToBestSplits, nodeIdUpdaters){
            public static final long serialVersionUID = 0L;
            public final DecisionTreeMetadata metadata$1;
            public final scala.collection.immutable.Map treeToNodeToIndexInfo$1;
            public final Queue nodeQueue$1;
            public final Option nodeIdCache$1;
            public final Map nodeToBestSplits$1;
            public final scala.collection.mutable.Map[] nodeIdUpdaters$1;

            public final void apply(Tuple2<Object, Node[]> x0$5) {
                Tuple2<Object, Node[]> tuple2 = x0$5;
                if (tuple2 != null) {
                    int treeIndex = tuple2._1$mcI$sp();
                    Node[] nodesForTree = (Node[])tuple2._2();
                    Predef$.MODULE$.refArrayOps((Object[])nodesForTree).foreach((Function1)new Serializable(this, treeIndex){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.findBestSplits.8 $outer;
                        private final int treeIndex$2;

                        public final void apply(Node node) {
                            int nodeIndex = node.id();
                            RandomForest.NodeIndexInfo nodeInfo = (RandomForest.NodeIndexInfo)((MapLike)this.$outer.treeToNodeToIndexInfo$1.apply((Object)BoxesRunTime.boxToInteger((int)this.treeIndex$2))).apply((Object)BoxesRunTime.boxToInteger((int)nodeIndex));
                            int aggNodeIndex = nodeInfo.nodeIndexInGroup();
                            Tuple3 tuple3 = (Tuple3)this.$outer.nodeToBestSplits$1.apply((Object)BoxesRunTime.boxToInteger((int)aggNodeIndex));
                            if (tuple3 != null) {
                                Split split = (Split)tuple3._1();
                                InformationGainStats stats = (InformationGainStats)tuple3._2();
                                Predict predict2 = (Predict)tuple3._3();
                                if (split != null) {
                                    Split split2 = split;
                                    if (stats != null) {
                                        InformationGainStats informationGainStats = stats;
                                        if (predict2 != null) {
                                            Tuple3 tuple32;
                                            Predict predict3 = predict2;
                                            Tuple3 tuple33 = tuple32 = new Tuple3((Object)split2, (Object)informationGainStats, (Object)predict3);
                                            Split split3 = (Split)tuple33._1();
                                            InformationGainStats stats2 = (InformationGainStats)tuple33._2();
                                            Predict predict4 = (Predict)tuple33._3();
                                            DecisionTree$.MODULE$.logDebug((Function0<String>)new Serializable(this, split3){
                                                public static final long serialVersionUID = 0L;
                                                private final Split split$1;

                                                public final String apply() {
                                                    return new StringBuilder().append((Object)"best split = ").append((Object)this.split$1).toString();
                                                }
                                                {
                                                    this.split$1 = split$1;
                                                }
                                            });
                                            boolean isLeaf = stats2.gain() <= 0.0 || Node$.MODULE$.indexToLevel(nodeIndex) == this.$outer.metadata$1.maxDepth();
                                            Predef$.MODULE$.assert(node.id() == nodeIndex);
                                            node.predict_$eq(predict4);
                                            node.isLeaf_$eq(isLeaf);
                                            node.stats_$eq((Option<InformationGainStats>)new Some((Object)stats2));
                                            node.impurity_$eq(stats2.impurity());
                                            DecisionTree$.MODULE$.logDebug((Function0<String>)new Serializable(this, node){
                                                public static final long serialVersionUID = 0L;
                                                private final Node node$1;

                                                public final String apply() {
                                                    return new StringBuilder().append((Object)"Node = ").append((Object)this.node$1).toString();
                                                }
                                                {
                                                    this.node$1 = node$1;
                                                }
                                            });
                                            if (!isLeaf) {
                                                BoxedUnit boxedUnit;
                                                node.split_$eq((Option<Split>)new Some((Object)split3));
                                                boolean childIsLeaf = Node$.MODULE$.indexToLevel(nodeIndex) + 1 == this.$outer.metadata$1.maxDepth();
                                                boolean leftChildIsLeaf = childIsLeaf || stats2.leftImpurity() == 0.0;
                                                boolean rightChildIsLeaf = childIsLeaf || stats2.rightImpurity() == 0.0;
                                                node.leftNode_$eq((Option<Node>)new Some((Object)Node$.MODULE$.apply(Node$.MODULE$.leftChildIndex(nodeIndex), stats2.leftPredict(), stats2.leftImpurity(), leftChildIsLeaf)));
                                                node.rightNode_$eq((Option<Node>)new Some((Object)Node$.MODULE$.apply(Node$.MODULE$.rightChildIndex(nodeIndex), stats2.rightPredict(), stats2.rightImpurity(), rightChildIsLeaf)));
                                                if (this.$outer.nodeIdCache$1.nonEmpty()) {
                                                    NodeIndexUpdater nodeIndexUpdater = new NodeIndexUpdater(split3, nodeIndex);
                                                    boxedUnit = this.$outer.nodeIdUpdaters$1[this.treeIndex$2].put((Object)BoxesRunTime.boxToInteger((int)nodeIndex), (Object)nodeIndexUpdater);
                                                } else {
                                                    boxedUnit = BoxedUnit.UNIT;
                                                }
                                                if (!leftChildIsLeaf) {
                                                    this.$outer.nodeQueue$1.enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)this.treeIndex$2), node.leftNode().get())}));
                                                }
                                                if (!rightChildIsLeaf) {
                                                    this.$outer.nodeQueue$1.enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)this.treeIndex$2), node.rightNode().get())}));
                                                }
                                                DecisionTree$.MODULE$.logDebug((Function0<String>)new Serializable(this, node, stats2){
                                                    public static final long serialVersionUID = 0L;
                                                    private final Node node$1;
                                                    private final InformationGainStats stats$1;

                                                    public final String apply() {
                                                        return new StringBuilder().append((Object)"leftChildIndex = ").append((Object)BoxesRunTime.boxToInteger((int)((Node)this.node$1.leftNode().get()).id())).append((Object)", impurity = ").append((Object)BoxesRunTime.boxToDouble((double)this.stats$1.leftImpurity())).toString();
                                                    }
                                                    {
                                                        this.node$1 = node$1;
                                                        this.stats$1 = stats$1;
                                                    }
                                                });
                                                DecisionTree$.MODULE$.logDebug((Function0<String>)new Serializable(this, node, stats2){
                                                    public static final long serialVersionUID = 0L;
                                                    private final Node node$1;
                                                    private final InformationGainStats stats$1;

                                                    public final String apply() {
                                                        return new StringBuilder().append((Object)"rightChildIndex = ").append((Object)BoxesRunTime.boxToInteger((int)((Node)this.node$1.rightNode().get()).id())).append((Object)", impurity = ").append((Object)BoxesRunTime.boxToDouble((double)this.stats$1.rightImpurity())).toString();
                                                    }
                                                    {
                                                        this.node$1 = node$1;
                                                        this.stats$1 = stats$1;
                                                    }
                                                });
                                            }
                                            return;
                                        }
                                    }
                                }
                            }
                            throw new MatchError((Object)tuple3);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.treeIndex$2 = treeIndex$2;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.metadata$1 = metadata$1;
                this.treeToNodeToIndexInfo$1 = treeToNodeToIndexInfo$1;
                this.nodeQueue$1 = nodeQueue$1;
                this.nodeIdCache$1 = nodeIdCache$1;
                this.nodeToBestSplits$1 = nodeToBestSplits$1;
                this.nodeIdUpdaters$1 = nodeIdUpdaters$1;
            }
        });
        if (nodeIdCache.nonEmpty()) {
            ((NodeIdCache)nodeIdCache.get()).updateNodeIndices(input, nodeIdUpdaters, bins);
        }
    }

    public TimeTracker findBestSplits$default$9() {
        return new TimeTracker();
    }

    public Option<NodeIdCache> findBestSplits$default$10() {
        return None$.MODULE$;
    }

    public InformationGainStats org$apache$spark$mllib$tree$DecisionTree$$calculateGainForSplit(ImpurityCalculator leftImpurityCalculator, ImpurityCalculator rightImpurityCalculator, DecisionTreeMetadata metadata, double impurity) {
        double rightImpurity;
        double rightWeight;
        long leftCount = leftImpurityCalculator.count();
        long rightCount = rightImpurityCalculator.count();
        if (leftCount < (long)metadata.minInstancesPerNode() || rightCount < (long)metadata.minInstancesPerNode()) {
            return InformationGainStats$.MODULE$.invalidInformationGainStats();
        }
        long totalCount = leftCount + rightCount;
        double leftWeight = (double)leftCount / (double)totalCount;
        double leftImpurity = leftImpurityCalculator.calculate();
        double gain = impurity - leftWeight * leftImpurity - (rightWeight = (double)rightCount / (double)totalCount) * (rightImpurity = rightImpurityCalculator.calculate());
        if (gain < metadata.minInfoGain()) {
            return InformationGainStats$.MODULE$.invalidInformationGainStats();
        }
        Predict leftPredict = this.calculatePredict(leftImpurityCalculator);
        Predict rightPredict = this.calculatePredict(rightImpurityCalculator);
        return new InformationGainStats(gain, impurity, leftImpurity, rightImpurity, leftPredict, rightPredict);
    }

    private Predict calculatePredict(ImpurityCalculator impurityCalculator) {
        double predict2 = impurityCalculator.predict();
        double prob2 = impurityCalculator.prob(predict2);
        return new Predict(predict2, prob2);
    }

    public Tuple2<Predict, Object> org$apache$spark$mllib$tree$DecisionTree$$calculatePredictImpurity(ImpurityCalculator leftImpurityCalculator, ImpurityCalculator rightImpurityCalculator) {
        ImpurityCalculator parentNodeAgg = leftImpurityCalculator.copy();
        parentNodeAgg.add(rightImpurityCalculator);
        Predict predict2 = this.calculatePredict(parentNodeAgg);
        double impurity = parentNodeAgg.calculate();
        return new Tuple2((Object)predict2, (Object)BoxesRunTime.boxToDouble((double)impurity));
    }

    public Tuple3<Split, InformationGainStats, Predict> binsToBestSplit(DTStatsAggregator binAggregates, Split[][] splits, Option<int[]> featuresForNode, Node node) {
        int level = Node$.MODULE$.indexToLevel(node.id());
        ObjectRef predictWithImpurity = level == 0 ? new ObjectRef((Object)None$.MODULE$) : new ObjectRef((Object)new Some((Object)new Tuple2((Object)node.predict(), (Object)BoxesRunTime.boxToDouble((double)node.impurity()))));
        Tuple2 tuple2 = (Tuple2)((TraversableOnce)scala.package$.MODULE$.Range().apply(0, binAggregates.metadata().numFeaturesPerNode()).map((Function1)new anonfun.13(binAggregates, splits, featuresForNode, predictWithImpurity), IndexedSeq$.MODULE$.canBuildFrom())).maxBy((Function1)new anonfun.23(), (Ordering)Ordering.Double$.MODULE$);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Split bestSplit = (Split)tuple2._1();
            InformationGainStats bestSplitStats = (InformationGainStats)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)bestSplit, (Object)bestSplitStats);
            Split bestSplit2 = (Split)tuple23._1();
            InformationGainStats bestSplitStats2 = (InformationGainStats)tuple23._2();
            return new Tuple3((Object)bestSplit2, (Object)bestSplitStats2, ((Tuple2)((Option)predictWithImpurity.elem).get())._1());
        }
        throw new MatchError((Object)tuple2);
    }

    public Tuple2<Split[][], Bin[][]> findSplitsBins(RDD<LabeledPoint> input, DecisionTreeMetadata metadata) {
        EmptyRDD emptyRDD;
        this.logDebug((Function0<String>)new Serializable(metadata){
            public static final long serialVersionUID = 0L;
            private final DecisionTreeMetadata metadata$2;

            public final String apply() {
                return new StringBuilder().append((Object)"isMulticlass = ").append((Object)BoxesRunTime.boxToBoolean((boolean)this.metadata$2.isMulticlass())).toString();
            }
            {
                this.metadata$2 = metadata$2;
            }
        });
        int numFeatures = metadata.numFeatures();
        scala.collection.immutable.IndexedSeq continuousFeatures = (scala.collection.immutable.IndexedSeq)scala.package$.MODULE$.Range().apply(0, numFeatures).filter((Function1)new Serializable(metadata){
            public static final long serialVersionUID = 0L;
            private final DecisionTreeMetadata metadata$2;

            public final boolean apply(int featureIndex) {
                return this.apply$mcZI$sp(featureIndex);
            }

            public boolean apply$mcZI$sp(int featureIndex) {
                return this.metadata$2.isContinuous(featureIndex);
            }
            {
                this.metadata$2 = metadata$2;
            }
        });
        if (continuousFeatures.nonEmpty()) {
            int requiredSamples = package$.MODULE$.max(metadata.maxBins() * metadata.maxBins(), 10000);
            double fraction = (long)requiredSamples < metadata.numExamples() ? (double)requiredSamples / (double)metadata.numExamples() : 1.0;
            this.logDebug((Function0<String>)new Serializable(fraction){
                public static final long serialVersionUID = 0L;
                private final double fraction$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"fraction of data used for calculating quantiles = ").append((Object)BoxesRunTime.boxToDouble((double)this.fraction$1)).toString();
                }
                {
                    this.fraction$1 = fraction$1;
                }
            });
            emptyRDD = input.sample(false, fraction, (long)new XORShiftRandom().nextInt());
        } else {
            emptyRDD = input.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(LabeledPoint.class));
        }
        EmptyRDD sampledInput = emptyRDD;
        Enumeration.Value value = metadata.quantileStrategy();
        Enumeration.Value value2 = QuantileStrategy$.MODULE$.Sort();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            Tuple2<Split[][], Bin[][]> tuple2 = this.findSplitsBinsBySorting((RDD<LabeledPoint>)sampledInput, metadata, (IndexedSeq<Object>)continuousFeatures);
            return tuple2;
        }
        Enumeration.Value value4 = QuantileStrategy$.MODULE$.MinMax();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            throw new UnsupportedOperationException("minmax not supported yet.");
        }
        Enumeration.Value value6 = QuantileStrategy$.MODULE$.ApproxHist();
        Enumeration.Value value7 = value;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            throw new UnsupportedOperationException("approximate histogram not supported yet.");
        }
        throw new MatchError((Object)value);
    }

    private Tuple2<Split[][], Bin[][]> findSplitsBinsBySorting(RDD<LabeledPoint> input, DecisionTreeMetadata metadata, IndexedSeq<Object> continuousFeatures) {
        int numPartitions = package$.MODULE$.min(continuousFeatures.length(), input.partitions().length);
        Map continuousSplits = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(input.flatMap((Function1)new Serializable(continuousFeatures){
            public static final long serialVersionUID = 0L;
            private final IndexedSeq continuousFeatures$1;

            public final IndexedSeq<Tuple2<Object, Object>> apply(LabeledPoint point) {
                return (IndexedSeq)this.continuousFeatures$1.map((Function1)new Serializable(this, point){
                    public static final long serialVersionUID = 0L;
                    private final LabeledPoint point$1;

                    public final Tuple2<Object, Object> apply(int idx) {
                        return new Tuple2.mcID.sp(idx, this.point$1.features().apply(idx));
                    }
                    {
                        this.point$1 = point$1;
                    }
                }, scala.collection.IndexedSeq$.MODULE$.canBuildFrom());
            }
            {
                this.continuousFeatures$1 = continuousFeatures$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Double(), (Ordering)Ordering.Int$.MODULE$).groupByKey(numPartitions).map((Function1)new Serializable(metadata){
            public static final long serialVersionUID = 0L;
            private final DecisionTreeMetadata metadata$3;

            public final Tuple2<Object, Tuple2<Split[], Bin[]>> apply(Tuple2<Object, Iterable<Object>> x0$9) {
                Tuple2<Object, Iterable<Object>> tuple2 = x0$9;
                if (tuple2 != null) {
                    int k = tuple2._1$mcI$sp();
                    Iterable v = (Iterable)tuple2._2();
                    Tuple2 tuple22 = DecisionTree$.MODULE$.org$apache$spark$mllib$tree$DecisionTree$$findSplits$1(k, v, this.metadata$3);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                this.metadata$3 = metadata$3;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).collectAsMap();
        int numFeatures = metadata.numFeatures();
        Tuple2 tuple2 = scala.package$.MODULE$.Range().apply(0, numFeatures).unzip((Function1)new anonfun.30(metadata, continuousSplits));
        if (tuple2 != null) {
            Tuple2 tuple22;
            scala.collection.immutable.IndexedSeq splits = (scala.collection.immutable.IndexedSeq)tuple2._1();
            scala.collection.immutable.IndexedSeq bins = (scala.collection.immutable.IndexedSeq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)splits, (Object)bins);
            scala.collection.immutable.IndexedSeq splits2 = (scala.collection.immutable.IndexedSeq)tuple23._1();
            scala.collection.immutable.IndexedSeq bins2 = (scala.collection.immutable.IndexedSeq)tuple23._2();
            return new Tuple2(splits2.toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Split.class))), bins2.toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Bin.class))));
        }
        throw new MatchError((Object)tuple2);
    }

    /*
     * WARNING - void declaration
     */
    public List<Object> extractMultiClassCategories(int input, int maxFeatureValue) {
        void var3_3;
        Nil$ categories = Nil$.MODULE$;
        int bitShiftedInput = input;
        for (int j = 0; j < maxFeatureValue; ++j) {
            if (bitShiftedInput % 2 != 0) {
                double d = j;
                categories = categories.$colon$colon((Object)BoxesRunTime.boxToDouble((double)d));
            }
            bitShiftedInput >>= 1;
        }
        return var3_3;
    }

    public double[] findSplitsForContinuousFeature(double[] featureSamples, DecisionTreeMetadata metadata, int featureIndex) {
        double[] dArray;
        Predef$.MODULE$.require(metadata.isContinuous(featureIndex), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "findSplitsForContinuousFeature can only be used to find splits for a continuous feature.";
            }
        });
        int numSplits = metadata.numSplits(featureIndex);
        scala.collection.immutable.Map valueCountMap = (scala.collection.immutable.Map)Predef$.MODULE$.doubleArrayOps(featureSamples).foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Map<Object, Object> apply(scala.collection.immutable.Map<Object, Object> m, double x) {
                return m.$plus((Tuple2)new Tuple2.mcDI.sp(x, BoxesRunTime.unboxToInt((Object)m.getOrElse((Object)BoxesRunTime.boxToDouble((double)x), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return 0;
                    }
                })) + 1));
            }
        });
        Tuple2[] valueCounts = (Tuple2[])((TraversableOnce)valueCountMap.toSeq().sortBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, Object> x$24) {
                return x$24._1$mcD$sp();
            }
        }, (Ordering)Ordering.Double$.MODULE$)).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
        int possibleSplits = valueCounts.length;
        if (possibleSplits <= numSplits) {
            dArray = (double[])Predef$.MODULE$.refArrayOps((Object[])valueCounts).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final double apply(Tuple2<Object, Object> x$25) {
                    return x$25._1$mcD$sp();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        } else {
            double stride = (double)featureSamples.length / (double)(numSplits + 1);
            this.logDebug((Function0<String>)new Serializable(stride){
                public static final long serialVersionUID = 0L;
                private final double stride$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"stride = ").append((Object)BoxesRunTime.boxToDouble((double)this.stride$1)).toString();
                }
                {
                    this.stride$1 = stride$1;
                }
            });
            ArrayBuilder splitsBuilder = Array$.MODULE$.newBuilder(ClassTag$.MODULE$.Double());
            int currentCount = valueCounts[0]._2$mcI$sp();
            double targetCount = stride;
            for (int index2 = 1; index2 < valueCounts.length; ++index2) {
                double currentGap;
                int previousCount = currentCount;
                currentCount += valueCounts[index2]._2$mcI$sp();
                double previousGap = package$.MODULE$.abs((double)previousCount - targetCount);
                if (!(previousGap < (currentGap = package$.MODULE$.abs((double)currentCount - targetCount)))) continue;
                splitsBuilder.$plus$eq((Object)BoxesRunTime.boxToDouble((double)valueCounts[index2 - 1]._1$mcD$sp()));
                targetCount += stride;
            }
            dArray = (double[])splitsBuilder.result();
        }
        double[] splits = dArray;
        Predef$.MODULE$.assert(splits.length > 0, (Function0)new Serializable(featureIndex){
            public static final long serialVersionUID = 0L;
            private final int featureIndex$2;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DecisionTree could not handle feature ", " since it had only 1 unique value."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.featureIndex$2)}))).append((Object)"  Please remove this feature and then try again.").toString();
            }
            {
                this.featureIndex$2 = featureIndex$2;
            }
        });
        return splits;
    }

    private Object readResolve() {
        return MODULE$;
    }

    public final void org$apache$spark$mllib$tree$DecisionTree$$nodeBinSeqOp$1(int treeIndex, RandomForest.NodeIndexInfo nodeInfo, DTStatsAggregator[] agg, BaggedPoint baggedPoint, DecisionTreeMetadata metadata$1, Split[][] splits$1) {
        if (nodeInfo != null) {
            int aggNodeIndex = nodeInfo.nodeIndexInGroup();
            Option<int[]> featuresForNode = nodeInfo.featureSubset();
            double instanceWeight = baggedPoint.subsampleWeights()[treeIndex];
            if (metadata$1.unorderedFeatures().isEmpty()) {
                this.orderedBinSeqOp(agg[aggNodeIndex], (TreePoint)baggedPoint.datum(), instanceWeight, featuresForNode);
            } else {
                this.mixedBinSeqOp(agg[aggNodeIndex], (TreePoint)baggedPoint.datum(), splits$1, metadata$1.unorderedFeatures(), instanceWeight, featuresForNode);
            }
        }
    }

    public final DTStatsAggregator[] org$apache$spark$mllib$tree$DecisionTree$$binSeqOp$1(DTStatsAggregator[] agg, BaggedPoint baggedPoint, DecisionTreeMetadata metadata$1, Node[] topNodes$1, scala.collection.immutable.Map treeToNodeToIndexInfo$1, Split[][] splits$1, Bin[][] bins$1) {
        treeToNodeToIndexInfo$1.foreach((Function1)new Serializable(metadata$1, topNodes$1, splits$1, bins$1, agg, baggedPoint){
            public static final long serialVersionUID = 0L;
            private final DecisionTreeMetadata metadata$1;
            private final Node[] topNodes$1;
            private final Split[][] splits$1;
            private final Bin[][] bins$1;
            private final DTStatsAggregator[] agg$1;
            private final BaggedPoint baggedPoint$1;

            public final void apply(Tuple2<Object, scala.collection.immutable.Map<Object, RandomForest.NodeIndexInfo>> x0$1) {
                Tuple2<Object, scala.collection.immutable.Map<Object, RandomForest.NodeIndexInfo>> tuple2 = x0$1;
                if (tuple2 != null) {
                    int treeIndex = tuple2._1$mcI$sp();
                    scala.collection.immutable.Map nodeIndexToInfo = (scala.collection.immutable.Map)tuple2._2();
                    int nodeIndex = DecisionTree$.MODULE$.org$apache$spark$mllib$tree$DecisionTree$$predictNodeIndex(this.topNodes$1[treeIndex], ((TreePoint)this.baggedPoint$1.datum()).binnedFeatures(), this.bins$1, this.metadata$1.unorderedFeatures());
                    DecisionTree$.MODULE$.org$apache$spark$mllib$tree$DecisionTree$$nodeBinSeqOp$1(treeIndex, (RandomForest.NodeIndexInfo)nodeIndexToInfo.getOrElse((Object)BoxesRunTime.boxToInteger((int)nodeIndex), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Null$ apply() {
                            return null;
                        }
                    }), this.agg$1, this.baggedPoint$1, this.metadata$1, this.splits$1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.metadata$1 = metadata$1;
                this.topNodes$1 = topNodes$1;
                this.splits$1 = splits$1;
                this.bins$1 = bins$1;
                this.agg$1 = agg$1;
                this.baggedPoint$1 = baggedPoint$1;
            }
        });
        return agg;
    }

    public final DTStatsAggregator[] org$apache$spark$mllib$tree$DecisionTree$$binSeqOpWithNodeIdCache$1(DTStatsAggregator[] agg, Tuple2 dataPoint, DecisionTreeMetadata metadata$1, scala.collection.immutable.Map treeToNodeToIndexInfo$1, Split[][] splits$1) {
        treeToNodeToIndexInfo$1.foreach((Function1)new Serializable(metadata$1, splits$1, agg, dataPoint){
            public static final long serialVersionUID = 0L;
            private final DecisionTreeMetadata metadata$1;
            private final Split[][] splits$1;
            private final DTStatsAggregator[] agg$2;
            private final Tuple2 dataPoint$1;

            public final void apply(Tuple2<Object, scala.collection.immutable.Map<Object, RandomForest.NodeIndexInfo>> x0$2) {
                Tuple2<Object, scala.collection.immutable.Map<Object, RandomForest.NodeIndexInfo>> tuple2 = x0$2;
                if (tuple2 != null) {
                    int treeIndex = tuple2._1$mcI$sp();
                    scala.collection.immutable.Map nodeIndexToInfo = (scala.collection.immutable.Map)tuple2._2();
                    BaggedPoint baggedPoint = (BaggedPoint)this.dataPoint$1._1();
                    int[] nodeIdCache = (int[])this.dataPoint$1._2();
                    int nodeIndex = nodeIdCache[treeIndex];
                    DecisionTree$.MODULE$.org$apache$spark$mllib$tree$DecisionTree$$nodeBinSeqOp$1(treeIndex, (RandomForest.NodeIndexInfo)nodeIndexToInfo.getOrElse((Object)BoxesRunTime.boxToInteger((int)nodeIndex), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Null$ apply() {
                            return null;
                        }
                    }), this.agg$2, baggedPoint, this.metadata$1, this.splits$1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.metadata$1 = metadata$1;
                this.splits$1 = splits$1;
                this.agg$2 = agg$2;
                this.dataPoint$1 = dataPoint$1;
            }
        });
        return agg;
    }

    private final Option getNodeToFeatures$1(scala.collection.immutable.Map treeToNodeToIndexInfo, DecisionTreeMetadata metadata$1) {
        None$ none$;
        if (metadata$1.subsamplingFeatures()) {
            HashMap mutableNodeToFeatures = new HashMap();
            treeToNodeToIndexInfo.values().foreach((Function1)new Serializable(mutableNodeToFeatures){
                public static final long serialVersionUID = 0L;
                public final HashMap mutableNodeToFeatures$1;

                public final void apply(scala.collection.immutable.Map<Object, RandomForest.NodeIndexInfo> nodeIdToNodeInfo) {
                    nodeIdToNodeInfo.values().foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.getNodeToFeatures.1.1 $outer;

                        public final void apply(RandomForest.NodeIndexInfo nodeIndexInfo) {
                            Predef$.MODULE$.assert(nodeIndexInfo.featureSubset().isDefined());
                            this.$outer.mutableNodeToFeatures$1.update((Object)BoxesRunTime.boxToInteger((int)nodeIndexInfo.nodeIndexInGroup()), nodeIndexInfo.featureSubset().get());
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    this.mutableNodeToFeatures$1 = mutableNodeToFeatures$1;
                }
            });
            none$ = new Some((Object)mutableNodeToFeatures.toMap(Predef$.MODULE$.conforms()));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public final Tuple2 org$apache$spark$mllib$tree$DecisionTree$$findSplits$1(int featureIndex, Iterable featureSamples, DecisionTreeMetadata metadata$3) {
        double[] featureSplits = this.findSplitsForContinuousFeature((double[])featureSamples.toArray(ClassTag$.MODULE$.Double()), metadata$3, featureIndex);
        this.logDebug((Function0<String>)new Serializable(featureIndex, featureSplits){
            public static final long serialVersionUID = 0L;
            private final int featureIndex$1;
            private final double[] featureSplits$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"featureIndex = ", ", numSplits = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.featureIndex$1), BoxesRunTime.boxToInteger((int)this.featureSplits$1.length)}));
            }
            {
                this.featureIndex$1 = featureIndex$1;
                this.featureSplits$1 = featureSplits$1;
            }
        });
        Split[] splits = (Split[])Predef$.MODULE$.doubleArrayOps(featureSplits).map((Function1)new Serializable(featureIndex){
            public static final long serialVersionUID = 0L;
            private final int featureIndex$1;

            public final Split apply(double threshold) {
                return new Split(this.featureIndex$1, threshold, FeatureType$.MODULE$.Continuous(), (List<Object>)Nil$.MODULE$);
            }
            {
                this.featureIndex$1 = featureIndex$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Split.class)));
        DummyLowSplit lowSplit = new DummyLowSplit(featureIndex, FeatureType$.MODULE$.Continuous());
        DummyHighSplit highSplit = new DummyHighSplit(featureIndex, FeatureType$.MODULE$.Continuous());
        DummyLowSplit dummyLowSplit = lowSplit;
        Seq allSplits = (Seq)((SeqLike)Predef$.MODULE$.refArrayOps((Object[])splits).toSeq().$plus$colon((Object)dummyLowSplit, Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)highSplit, Seq$.MODULE$.canBuildFrom());
        Bin[] bins = (Bin[])allSplits.sliding(2).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Bin apply(Seq<Split> x0$8) {
                Seq<Split> seq = x0$8;
                Some some = Seq$.MODULE$.unapplySeq(seq);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                    Split left = (Split)((SeqLike)some.get()).apply(0);
                    Split right = (Split)((SeqLike)some.get()).apply(1);
                    Bin bin = new Bin(left, right, FeatureType$.MODULE$.Continuous(), Double$.MODULE$.MinValue());
                    return bin;
                }
                throw new MatchError(seq);
            }
        }).toArray(ClassTag$.MODULE$.apply(Bin.class));
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)featureIndex), (Object)new Tuple2((Object)splits, (Object)bins));
    }

    private DecisionTree$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

