/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import org.apache.spark.annotation.Experimental;
import org.apache.spark.mllib.clustering.ClusteringTreeNode$;
import org.apache.spark.mllib.clustering.KMeans$;
import org.apache.spark.mllib.clustering.VectorWithNorm;
import org.apache.spark.mllib.linalg.Vector;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005-b!B\u0001\u0003\u0001\ta!AE\"mkN$XM]5oOR\u0013X-\u001a(pI\u0016T!a\u0001\u0003\u0002\u0015\rdWo\u001d;fe&twM\u0003\u0002\u0006\r\u0005)Q\u000e\u001c7jE*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xmE\u0002\u0001\u001bM\u0001\"AD\t\u000e\u0003=Q\u0011\u0001E\u0001\u0006g\u000e\fG.Y\u0005\u0003%=\u0011a!\u00118z%\u00164\u0007C\u0001\b\u0015\u0013\t)rB\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005\u0018\u0001\t\u0015\r\u0011\"\u0001\u001a\u0003\u0015Ig\u000eZ3y\u0007\u0001)\u0012A\u0007\t\u0003\u001dmI!\u0001H\b\u0003\u0007%sG\u000f\u0003\u0005\u001f\u0001\t\u0005\t\u0015!\u0003\u001b\u0003\u0019Ig\u000eZ3yA!A\u0001\u0005\u0001BC\u0002\u0013\u0005\u0011%\u0001\u0003tSj,W#\u0001\u0012\u0011\u00059\u0019\u0013B\u0001\u0013\u0010\u0005\u0011auN\\4\t\u0011\u0019\u0002!\u0011!Q\u0001\n\t\nQa]5{K\u0002B\u0001\u0002\u000b\u0001\u0003\u0006\u0004%I!K\u0001\u000fG\u0016tG/\u001a:XSRDgj\u001c:n+\u0005Q\u0003CA\u0016-\u001b\u0005\u0011\u0011BA\u0017\u0003\u000591Vm\u0019;pe^KG\u000f\u001b(pe6D\u0001b\f\u0001\u0003\u0002\u0003\u0006IAK\u0001\u0010G\u0016tG/\u001a:XSRDgj\u001c:nA!A\u0011\u0007\u0001BC\u0002\u0013\u0005!'\u0001\u0003d_N$X#A\u001a\u0011\u00059!\u0014BA\u001b\u0010\u0005\u0019!u.\u001e2mK\"Aq\u0007\u0001B\u0001B\u0003%1'A\u0003d_N$\b\u0005\u0003\u0005:\u0001\t\u0015\r\u0011\"\u00013\u0003\u0019AW-[4ii\"A1\b\u0001B\u0001B\u0003%1'A\u0004iK&<\u0007\u000e\u001e\u0011\t\u0011u\u0002!Q1A\u0005\u0002y\n\u0001b\u00195jY\u0012\u0014XM\\\u000b\u0002\u007fA\u0019a\u0002\u0011\"\n\u0005\u0005{!!B!se\u0006L\bCA\u0016\u0001\u0011!!\u0005A!A!\u0002\u0013y\u0014!C2iS2$'/\u001a8!\u0011\u00191\u0005\u0001\"\u0001\u0003\u000f\u00061A(\u001b8jiz\"rA\u0011%J\u0015.cU\nC\u0003\u0018\u000b\u0002\u0007!\u0004C\u0003!\u000b\u0002\u0007!\u0005C\u0003)\u000b\u0002\u0007!\u0006C\u00032\u000b\u0002\u00071\u0007C\u0003:\u000b\u0002\u00071\u0007C\u0003>\u000b\u0002\u0007q\bC\u0004P\u0001\t\u0007I\u0011\u0001)\u0002\r%\u001cH*Z1g+\u0005\t\u0006C\u0001\bS\u0013\t\u0019vBA\u0004C_>dW-\u00198\t\rU\u0003\u0001\u0015!\u0003R\u0003\u001dI7\u000fT3bM\u0002BQa\u0016\u0001\u0005\u0002a\u000baaY3oi\u0016\u0014X#A-\u0011\u0005ikV\"A.\u000b\u0005q#\u0011A\u00027j]\u0006dw-\u0003\u0002_7\n1a+Z2u_JDQ\u0001\u0019\u0001\u0005\u0002\u0005\fq\u0001\u001d:fI&\u001cG\u000f\u0006\u0002\u001bE\")1m\u0018a\u00013\u0006)\u0001o\\5oi\")Q\r\u0001C\u0001M\u0006Y\u0001O]3eS\u000e$\b+\u0019;i)\tyt\rC\u0003dI\u0002\u0007\u0011\fC\u0003f\u0001\u0011%\u0011\u000e\u0006\u0002kmB\u00191n\u001d\"\u000f\u00051\fhBA7q\u001b\u0005q'BA8\u0019\u0003\u0019a$o\\8u}%\t\u0001#\u0003\u0002s\u001f\u00059\u0001/Y2lC\u001e,\u0017B\u0001;v\u0005\u0011a\u0015n\u001d;\u000b\u0005I|\u0001\"B<i\u0001\u0004Q\u0013!\u00049pS:$x+\u001b;i\u001d>\u0014X\u000eC\u0003z\u0001\u0011\u0005!0A\u0006d_6\u0004X\u000f^3D_N$HCA\u001a|\u0011\u0015\u0019\u0007\u00101\u0001Z\u0011\u0015\u0001\u0007\u0001\"\u0003~)\rq\u00181\u0001\t\u0005\u001d}T2'C\u0002\u0002\u0002=\u0011a\u0001V;qY\u0016\u0014\u0004\"B<}\u0001\u0004Q\u0003B\u00021\u0001\t\u0013\t9\u0001F\u0003\u007f\u0003\u0013\tY\u0001\u0003\u0004x\u0003\u000b\u0001\rA\u000b\u0005\u0007c\u0005\u0015\u0001\u0019A\u001a\t\r\u0005=\u0001\u0001\"\u0001?\u0003%aW-\u00194O_\u0012,7\u000fK\u0002\u0001\u0003'\u0001B!!\u0006\u0002\u001c5\u0011\u0011q\u0003\u0006\u0004\u000331\u0011AC1o]>$\u0018\r^5p]&!\u0011QDA\f\u00051)\u0005\u0010]3sS6,g\u000e^1mQ\u0015\u0001\u0011\u0011EA\u0014!\u0011\t)\"a\t\n\t\u0005\u0015\u0012q\u0003\u0002\u0006'&t7-Z\u0011\u0003\u0003S\tQ!\r\u00187]A\u0002")
public class ClusteringTreeNode
implements Serializable {
    private final int index;
    private final long size;
    private final VectorWithNorm org$apache$spark$mllib$clustering$ClusteringTreeNode$$centerWithNorm;
    private final double cost;
    private final double height;
    private final ClusteringTreeNode[] children;
    private final boolean isLeaf;

    public int index() {
        return this.index;
    }

    public long size() {
        return this.size;
    }

    public VectorWithNorm org$apache$spark$mllib$clustering$ClusteringTreeNode$$centerWithNorm() {
        return this.org$apache$spark$mllib$clustering$ClusteringTreeNode$$centerWithNorm;
    }

    public double cost() {
        return this.cost;
    }

    public double height() {
        return this.height;
    }

    public ClusteringTreeNode[] children() {
        return this.children;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public Vector center() {
        return this.org$apache$spark$mllib$clustering$ClusteringTreeNode$$centerWithNorm().vector();
    }

    /*
     * WARNING - void declaration
     */
    public int predict(Vector point) {
        Tuple2<Object, Object> tuple2 = this.predict(new VectorWithNorm(point));
        if (tuple2 != null) {
            void var2_5;
            int index2;
            int n;
            int index3 = n = (index2 = tuple2._1$mcI$sp());
            return (int)var2_5;
        }
        throw new MatchError(tuple2);
    }

    public ClusteringTreeNode[] predictPath(Vector point) {
        return (ClusteringTreeNode[])this.predictPath(new VectorWithNorm(point)).toArray(ClassTag$.MODULE$.apply(ClusteringTreeNode.class));
    }

    private List<ClusteringTreeNode> predictPath(VectorWithNorm pointWithNorm) {
        List list;
        if (this.isLeaf()) {
            ClusteringTreeNode clusteringTreeNode = this;
            list = Nil$.MODULE$.$colon$colon((Object)clusteringTreeNode);
        } else {
            ClusteringTreeNode selected;
            ClusteringTreeNode clusteringTreeNode = selected = (ClusteringTreeNode)Predef$.MODULE$.refArrayOps((Object[])this.children()).minBy((Function1)new Serializable(this, pointWithNorm){
                public static final long serialVersionUID = 0L;
                private final VectorWithNorm pointWithNorm$2;

                public final double apply(ClusteringTreeNode child) {
                    return KMeans$.MODULE$.fastSquaredDistance(child.org$apache$spark$mllib$clustering$ClusteringTreeNode$$centerWithNorm(), this.pointWithNorm$2);
                }
                {
                    this.pointWithNorm$2 = pointWithNorm$2;
                }
            }, (Ordering)Ordering.Double$.MODULE$);
            list = selected.predictPath(pointWithNorm).$colon$colon((Object)clusteringTreeNode);
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public double computeCost(Vector point) {
        Tuple2<Object, Object> tuple2 = this.predict(new VectorWithNorm(point));
        if (tuple2 != null) {
            void var2_5;
            double cost;
            double d;
            double cost2 = d = (cost = tuple2._2$mcD$sp());
            return (double)var2_5;
        }
        throw new MatchError(tuple2);
    }

    private Tuple2<Object, Object> predict(VectorWithNorm pointWithNorm) {
        return this.predict(pointWithNorm, KMeans$.MODULE$.fastSquaredDistance(this.org$apache$spark$mllib$clustering$ClusteringTreeNode$$centerWithNorm(), pointWithNorm));
    }

    private Tuple2<Object, Object> predict(VectorWithNorm pointWithNorm, double cost) {
        Tuple2 tuple2;
        while (true) {
            double minCost;
            Tuple2 tuple22;
            if (this_.isLeaf()) {
                return new Tuple2.mcID.sp(this_.index(), cost);
            }
            tuple2 = (Tuple2)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this_.children()).map((Function1)new $anonfun$12(this_, pointWithNorm), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).minBy((Function1)new $anonfun$13(this_), (Ordering)Ordering.Double$.MODULE$);
            if (tuple2 == null) break;
            ClusteringTreeNode selectedChild = (ClusteringTreeNode)tuple2._1();
            double minCost2 = tuple2._2$mcD$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)selectedChild, (Object)BoxesRunTime.boxToDouble((double)minCost2));
            ClusteringTreeNode selectedChild2 = (ClusteringTreeNode)tuple23._1();
            cost = minCost = tuple23._2$mcD$sp();
            ClusteringTreeNode this_ = selectedChild2;
        }
        throw new MatchError((Object)tuple2);
    }

    public ClusteringTreeNode[] leafNodes() {
        return this.isLeaf() ? (ClusteringTreeNode[])((Object[])new ClusteringTreeNode[]{this}) : (ClusteringTreeNode[])Predef$.MODULE$.refArrayOps((Object[])this.children()).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<ClusteringTreeNode> apply(ClusteringTreeNode x$9) {
                return Predef$.MODULE$.refArrayOps((Object[])x$9.leafNodes());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ClusteringTreeNode.class)));
    }

    public ClusteringTreeNode(int index2, long size, VectorWithNorm centerWithNorm, double cost, double height, ClusteringTreeNode[] children) {
        this.index = index2;
        this.size = size;
        this.org$apache$spark$mllib$clustering$ClusteringTreeNode$$centerWithNorm = centerWithNorm;
        this.cost = cost;
        this.height = height;
        this.children = children;
        this.isLeaf = Predef$.MODULE$.refArrayOps((Object[])children).isEmpty();
        Predef$.MODULE$.require(this.isLeaf() && index2 >= 0 || !this.isLeaf() && index2 < 0);
    }
}

