/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.math.Field;
import breeze.math.MutableEnumeratedCoordinateField;
import breeze.math.MutableInnerProductModule;
import breeze.optimize.CachedDiffFunction;
import breeze.optimize.DiffFunction;
import breeze.optimize.FirstOrderMinimizer;
import breeze.optimize.LBFGS;
import breeze.optimize.OWLQN;
import breeze.optimize.StochasticDiffFunction;
import java.io.IOException;
import org.apache.spark.Logging;
import org.apache.spark.SparkException;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.classification.BinaryLogisticRegressionTrainingSummary;
import org.apache.spark.ml.classification.LogisticCostFun;
import org.apache.spark.ml.classification.LogisticRegression$;
import org.apache.spark.ml.classification.LogisticRegressionModel;
import org.apache.spark.ml.classification.LogisticRegressionParams;
import org.apache.spark.ml.classification.LogisticRegressionParams$class;
import org.apache.spark.ml.classification.MultiClassSummarizer;
import org.apache.spark.ml.classification.ProbabilisticClassifier;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.shared.HasElasticNetParam$class;
import org.apache.spark.ml.param.shared.HasFitIntercept$class;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasRegParam$class;
import org.apache.spark.ml.param.shared.HasStandardization$class;
import org.apache.spark.ml.param.shared.HasThreshold$class;
import org.apache.spark.ml.param.shared.HasTol$class;
import org.apache.spark.ml.param.shared.HasWeightCol$class;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.DefaultParamsWritable$class;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable$class;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.stat.MultivariateOnlineSummarizer;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.functions$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005-f\u0001B\u0001\u0003\u00015\u0011!\u0003T8hSN$\u0018n\u0019*fOJ,7o]5p]*\u00111\u0001B\u0001\u000fG2\f7o]5gS\u000e\fG/[8o\u0015\t)a!\u0001\u0002nY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001qa$I\u0014\u0011\u000b=\u0001\"CG\u000e\u000e\u0003\tI!!\u0005\u0002\u0003/A\u0013xNY1cS2L7\u000f^5d\u00072\f7o]5gS\u0016\u0014\bCA\n\u0019\u001b\u0005!\"BA\u000b\u0017\u0003\u0019a\u0017N\\1mO*\u0011qCB\u0001\u0006[2d\u0017NY\u0005\u00033Q\u0011aAV3di>\u0014\bCA\b\u0001!\tyA$\u0003\u0002\u001e\u0005\t9Bj\\4jgRL7MU3he\u0016\u001c8/[8o\u001b>$W\r\u001c\t\u0003\u001f}I!\u0001\t\u0002\u000311{w-[:uS\u000e\u0014Vm\u001a:fgNLwN\u001c)be\u0006l7\u000f\u0005\u0002#K5\t1E\u0003\u0002%\t\u0005!Q\u000f^5m\u0013\t13EA\u000bEK\u001a\fW\u000f\u001c;QCJ\fWn],sSR\f'\r\\3\u0011\u0005!JS\"\u0001\u0004\n\u0005)2!a\u0002'pO\u001eLgn\u001a\u0005\tY\u0001\u0011)\u0019!C![\u0005\u0019Q/\u001b3\u0016\u00039\u0002\"aL\u001b\u000f\u0005A\u001aT\"A\u0019\u000b\u0003I\nQa]2bY\u0006L!\u0001N\u0019\u0002\rA\u0013X\rZ3g\u0013\t1tG\u0001\u0004TiJLgn\u001a\u0006\u0003iEB3aK\u001d@!\tQT(D\u0001<\u0015\tad!\u0001\u0006b]:|G/\u0019;j_:L!AP\u001e\u0003\u000bMKgnY3\"\u0003\u0001\u000bQ!\r\u00185]AB\u0001B\u0011\u0001\u0003\u0002\u0003\u0006IAL\u0001\u0005k&$\u0007\u0005K\u0002Bs}BQ!\u0012\u0001\u0005\u0002\u0019\u000ba\u0001P5oSRtDC\u0001\u000eH\u0011\u0015aC\t1\u0001/Q\r9\u0015h\u0010\u0015\u0004\tfR\u0015%A&\u0002\u000bEr#G\f\u0019\t\u000b\u0015\u0003A\u0011A'\u0015\u0003iA3\u0001T\u001d@\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0003-\u0019X\r\u001e*fOB\u000b'/Y7\u0015\u0005I\u001bV\"\u0001\u0001\t\u000bQ{\u0005\u0019A+\u0002\u000bY\fG.^3\u0011\u0005A2\u0016BA,2\u0005\u0019!u.\u001e2mK\"\u001aq*\u000f&\t\u000bi\u0003A\u0011A.\u0002%M,G/\u00127bgRL7MT3u!\u0006\u0014\u0018-\u001c\u000b\u0003%rCQ\u0001V-A\u0002UC3!W\u001d@\u0011\u0015y\u0006\u0001\"\u0001a\u0003)\u0019X\r^'bq&#XM\u001d\u000b\u0003%\u0006DQ\u0001\u00160A\u0002\t\u0004\"\u0001M2\n\u0005\u0011\f$aA%oi\"\u001aa,\u000f&\t\u000b\u001d\u0004A\u0011\u00015\u0002\rM,G\u000fV8m)\t\u0011\u0016\u000eC\u0003UM\u0002\u0007Q\u000bK\u0002gs}BQ\u0001\u001c\u0001\u0005\u00025\fqb]3u\r&$\u0018J\u001c;fe\u000e,\u0007\u000f\u001e\u000b\u0003%:DQ\u0001V6A\u0002=\u0004\"\u0001\r9\n\u0005E\f$a\u0002\"p_2,\u0017M\u001c\u0015\u0004Wfz\u0004\"\u0002;\u0001\t\u0003)\u0018AE:fiN#\u0018M\u001c3be\u0012L'0\u0019;j_:$\"A\u0015<\t\u000bQ\u001b\b\u0019A8)\u0007ML\u00040I\u0001z\u0003\u0015\td&\u000e\u00181\u0011\u0015Y\b\u0001\"\u0011}\u00031\u0019X\r\u001e+ie\u0016\u001c\bn\u001c7e)\t\u0011V\u0010C\u0003Uu\u0002\u0007Q\u000bK\u0002{saDq!!\u0001\u0001\t\u0003\n\u0019!\u0001\u0007hKR$\u0006N]3tQ>dG-F\u0001VQ\ry\u0018\b\u001f\u0005\b\u0003\u0013\u0001A\u0011AA\u0006\u00031\u0019X\r^,fS\u001eDGoQ8m)\r\u0011\u0016Q\u0002\u0005\u0007)\u0006\u001d\u0001\u0019\u0001\u0018)\u000b\u0005\u001d\u0011(!\u0005\"\u0005\u0005M\u0011!B\u0019/m9\u0002\u0004bBA\f\u0001\u0011\u0005\u0013\u0011D\u0001\u000eg\u0016$H\u000b\u001b:fg\"|G\u000eZ:\u0015\u0007I\u000bY\u0002C\u0004U\u0003+\u0001\r!!\b\u0011\tA\ny\"V\u0005\u0004\u0003C\t$!B!se\u0006L\b\u0006BA\u000bsaDq!a\n\u0001\t\u0003\nI#A\u0007hKR$\u0006N]3tQ>dGm]\u000b\u0003\u0003;AC!!\n:q\"9\u0011q\u0006\u0001\u0005R\u0005E\u0012!\u0002;sC&tGcA\u000e\u00024!A\u0011QGA\u0017\u0001\u0004\t9$A\u0004eCR\f7/\u001a;\u0011\t\u0005e\u0012qH\u0007\u0003\u0003wQ1!!\u0010\u0007\u0003\r\u0019\u0018\u000f\\\u0005\u0005\u0003\u0003\nYDA\u0005ECR\fgI]1nK\"9\u0011Q\t\u0001\u0005B\u0005\u001d\u0013\u0001B2paf$2AGA%\u0011!\tY%a\u0011A\u0002\u00055\u0013!B3yiJ\f\u0007\u0003BA(\u0003+j!!!\u0015\u000b\u0007\u0005MC!A\u0003qCJ\fW.\u0003\u0003\u0002X\u0005E#\u0001\u0003)be\u0006lW*\u00199)\t\u0005\r\u0013h\u0010\u0015\u0004\u0001\u0005u\u0003c\u0001\u001e\u0002`%\u0019\u0011\u0011M\u001e\u0003\u0019\u0015C\b/\u001a:j[\u0016tG/\u00197)\u0007\u0001I$jB\u0004\u0002h\tA\t!!\u001b\u0002%1{w-[:uS\u000e\u0014Vm\u001a:fgNLwN\u001c\t\u0004\u001f\u0005-dAB\u0001\u0003\u0011\u0003\tig\u0005\u0005\u0002l\u0005=\u0014QOA>!\r\u0001\u0014\u0011O\u0005\u0004\u0003g\n$AB!osJ+g\r\u0005\u0003#\u0003oR\u0012bAA=G\t)B)\u001a4bk2$\b+\u0019:b[N\u0014V-\u00193bE2,\u0007c\u0001\u0019\u0002~%\u0019\u0011qP\u0019\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000f\u0015\u000bY\u0007\"\u0001\u0002\u0004R\u0011\u0011\u0011\u000e\u0005\t\u0003\u000f\u000bY\u0007\"\u0011\u0002\n\u0006!An\\1e)\rQ\u00121\u0012\u0005\b\u0003\u001b\u000b)\t1\u0001/\u0003\u0011\u0001\u0018\r\u001e5)\u000b\u0005\u0015\u0015(!\u0005\t\u0015\u0005M\u00151NA\u0001\n\u0013\t)*A\u0006sK\u0006$'+Z:pYZ,GCAAL!\u0011\tI*a)\u000e\u0005\u0005m%\u0002BAO\u0003?\u000bA\u0001\\1oO*\u0011\u0011\u0011U\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002&\u0006m%AB(cU\u0016\u001cG\u000fK\u0003\u0002le\n\t\u0002K\u0003\u0002fe\n\t\u0002")
public class LogisticRegression
extends ProbabilisticClassifier<Vector, LogisticRegression, LogisticRegressionModel>
implements LogisticRegressionParams,
DefaultParamsWritable,
Logging {
    private final String uid;
    private final DoubleParam threshold;
    private final Param<String> weightCol;
    private final BooleanParam standardization;
    private final DoubleParam tol;
    private final BooleanParam fitIntercept;
    private final IntParam maxIter;
    private final DoubleParam elasticNetParam;
    private final DoubleParam regParam;

    public static MLReader<LogisticRegression> read() {
        return LogisticRegression$.MODULE$.read();
    }

    public static LogisticRegression load(String string) {
        return LogisticRegression$.MODULE$.load(string);
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable$class.write(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable$class.save(this, path);
    }

    @Override
    public void checkThresholdConsistency() {
        LogisticRegressionParams$class.checkThresholdConsistency(this);
    }

    @Override
    public void validateParams() {
        LogisticRegressionParams$class.validateParams(this);
    }

    @Override
    public final DoubleParam threshold() {
        return this.threshold;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasThreshold$_setter_$threshold_$eq(DoubleParam x$1) {
        this.threshold = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol$class.getWeightCol(this);
    }

    @Override
    public final BooleanParam standardization() {
        return this.standardization;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStandardization$_setter_$standardization_$eq(BooleanParam x$1) {
        this.standardization = x$1;
    }

    @Override
    public final boolean getStandardization() {
        return HasStandardization$class.getStandardization(this);
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final double getTol() {
        return HasTol$class.getTol(this);
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept$class.getFitIntercept(this);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public final DoubleParam elasticNetParam() {
        return this.elasticNetParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasElasticNetParam$_setter_$elasticNetParam_$eq(DoubleParam x$1) {
        this.elasticNetParam = x$1;
    }

    @Override
    public final double getElasticNetParam() {
        return HasElasticNetParam$class.getElasticNetParam(this);
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public final double getRegParam() {
        return HasRegParam$class.getRegParam(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public LogisticRegression setRegParam(double value) {
        return (LogisticRegression)this.set(this.regParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public LogisticRegression setElasticNetParam(double value) {
        return (LogisticRegression)this.set(this.elasticNetParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public LogisticRegression setMaxIter(int value) {
        return (LogisticRegression)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public LogisticRegression setTol(double value) {
        return (LogisticRegression)this.set(this.tol(), BoxesRunTime.boxToDouble((double)value));
    }

    public LogisticRegression setFitIntercept(boolean value) {
        return (LogisticRegression)this.set(this.fitIntercept(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public LogisticRegression setStandardization(boolean value) {
        return (LogisticRegression)this.set(this.standardization(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    @Override
    public LogisticRegression setThreshold(double value) {
        return (LogisticRegression)LogisticRegressionParams$class.setThreshold(this, value);
    }

    @Override
    public double getThreshold() {
        return LogisticRegressionParams$class.getThreshold(this);
    }

    public LogisticRegression setWeightCol(String value) {
        return (LogisticRegression)this.set(this.weightCol(), value);
    }

    @Override
    public LogisticRegression setThresholds(double[] value) {
        return (LogisticRegression)LogisticRegressionParams$class.setThresholds(this, value);
    }

    @Override
    public double[] getThresholds() {
        return LogisticRegressionParams$class.getThresholds(this);
    }

    @Override
    public LogisticRegressionModel train(DataFrame dataset) {
        Column w2 = this.$(this.weightCol()).isEmpty() ? functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)1.0)) : functions$.MODULE$.col(this.$(this.weightCol()));
        RDD instances = dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.labelCol())), w2, functions$.MODULE$.col(this.$(this.featuresCol()))})).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Instance apply(Row x0$1) {
                Row row = x0$1;
                Some some = Row$.MODULE$.unapplySeq(row);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(3) == 0) {
                    Object label = ((SeqLike)some.get()).apply(0);
                    Object weight = ((SeqLike)some.get()).apply(1);
                    Object features = ((SeqLike)some.get()).apply(2);
                    if (label instanceof Double) {
                        double d = BoxesRunTime.unboxToDouble((Object)label);
                        if (weight instanceof Double) {
                            double d2 = BoxesRunTime.unboxToDouble((Object)weight);
                            if (features instanceof Vector) {
                                Vector vector = (Vector)features;
                                Instance instance = new Instance(d, d2, vector);
                                return instance;
                            }
                        }
                    }
                }
                throw new MatchError((Object)row);
            }
        }, ClassTag$.MODULE$.apply(Instance.class));
        StorageLevel storageLevel = dataset.rdd().getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        boolean handlePersistence = !(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null);
        Object object = handlePersistence ? instances.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()) : BoxedUnit.UNIT;
        Tuple2 x$6 = new Tuple2((Object)new MultivariateOnlineSummarizer(), (Object)new MultiClassSummarizer());
        Serializable seqOp = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<MultivariateOnlineSummarizer, MultiClassSummarizer> apply(Tuple2<MultivariateOnlineSummarizer, MultiClassSummarizer> c, Instance instance) {
                return new Tuple2((Object)((MultivariateOnlineSummarizer)c._1()).add(instance.features(), instance.weight()), (Object)((MultiClassSummarizer)c._2()).add(instance.label(), instance.weight()));
            }
        };
        Serializable x$7 = seqOp;
        Serializable combOp = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<MultivariateOnlineSummarizer, MultiClassSummarizer> apply(Tuple2<MultivariateOnlineSummarizer, MultiClassSummarizer> c1, Tuple2<MultivariateOnlineSummarizer, MultiClassSummarizer> c2) {
                return new Tuple2((Object)((MultivariateOnlineSummarizer)c1._1()).merge((MultivariateOnlineSummarizer)c2._1()), (Object)((MultiClassSummarizer)c1._2()).merge((MultiClassSummarizer)c2._2()));
            }
        };
        Serializable x$8 = combOp;
        int x$9 = instances.treeAggregate$default$4((Object)x$6);
        Tuple2 tuple2 = (Tuple2)instances.treeAggregate((Object)x$6, (Function2)x$7, (Function2)x$8, x$9, ClassTag$.MODULE$.apply(Tuple2.class));
        if (tuple2 != null) {
            Tuple3 tuple3;
            Tuple2 tuple22;
            MultivariateOnlineSummarizer summarizer = (MultivariateOnlineSummarizer)tuple2._1();
            MultiClassSummarizer labelSummarizer = (MultiClassSummarizer)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)summarizer, (Object)labelSummarizer);
            MultivariateOnlineSummarizer summarizer2 = (MultivariateOnlineSummarizer)tuple23._1();
            MultiClassSummarizer labelSummarizer2 = (MultiClassSummarizer)tuple23._2();
            double[] histogram2 = labelSummarizer2.histogram();
            long numInvalid = labelSummarizer2.countInvalid();
            int numClasses = histogram2.length;
            int numFeatures = summarizer2.mean().size();
            if (numInvalid != 0L) {
                String msg = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Classification labels should be in {0 to ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(numClasses - 1))}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " invalid labels."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)numInvalid)}))).toString();
                this.logError((Function0<String>)new Serializable(this, msg){
                    public static final long serialVersionUID = 0L;
                    private final String msg$1;

                    public final String apply() {
                        return this.msg$1;
                    }
                    {
                        this.msg$1 = msg$1;
                    }
                });
                throw new SparkException(msg);
            }
            if (numClasses > 2) {
                String msg = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Currently, LogisticRegression with ElasticNet in ML package only supports "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"binary classification. Found ", " in the input dataset."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numClasses)}))).toString();
                this.logError((Function0<String>)new Serializable(this, msg){
                    public static final long serialVersionUID = 0L;
                    private final String msg$2;

                    public final String apply() {
                        return this.msg$2;
                    }
                    {
                        this.msg$2 = msg$2;
                    }
                });
                throw new SparkException(msg);
            }
            double[] featuresMean = summarizer2.mean().toArray();
            double[] featuresStd = (double[])Predef$.MODULE$.doubleArrayOps(summarizer2.variance().toArray()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final double apply(double x) {
                    return this.apply$mcDD$sp(x);
                }

                public double apply$mcDD$sp(double x) {
                    return package$.MODULE$.sqrt(x);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            double regParamL1 = BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam())) * BoxesRunTime.unboxToDouble((Object)this.$(this.regParam()));
            double regParamL2 = (1.0 - BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam()))) * BoxesRunTime.unboxToDouble((Object)this.$(this.regParam()));
            LogisticCostFun costFun = new LogisticCostFun((RDD<Instance>)instances, numClasses, BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())), BoxesRunTime.unboxToBoolean((Object)this.$(this.standardization())), featuresStd, featuresMean, regParamL2);
            LBFGS optimizer = BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam())) == 0.0 || BoxesRunTime.unboxToDouble((Object)this.$(this.regParam())) == 0.0 ? new LBFGS(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), (MutableInnerProductModule)DenseVector$.MODULE$.space((Field)Field.fieldDouble$.MODULE$, ClassTag$.MODULE$.Double())) : new OWLQN(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, this.regParamL1Fun$1(numFeatures, featuresStd, regParamL1), BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), (MutableEnumeratedCoordinateField)DenseVector$.MODULE$.space((Field)Field.fieldDouble$.MODULE$, ClassTag$.MODULE$.Double()));
            Vector initialCoefficientsWithIntercept = Vectors$.MODULE$.zeros(BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) ? numFeatures + 1 : numFeatures);
            if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept()))) {
                initialCoefficientsWithIntercept.toArray()[numFeatures] = package$.MODULE$.log(histogram2[1] / histogram2[0]);
            }
            Iterator states = optimizer.iterations((StochasticDiffFunction)new CachedDiffFunction((DiffFunction)costFun, DenseVector$.MODULE$.canCopyDenseVector(ClassTag$.MODULE$.Double())), (Object)initialCoefficientsWithIntercept.toBreeze().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double()));
            ArrayBuilder arrayBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Double());
            FirstOrderMinimizer.State state = null;
            while (states.hasNext()) {
                state = (FirstOrderMinimizer.State)states.next();
                arrayBuilder.$plus$eq((Object)BoxesRunTime.boxToDouble((double)state.adjustedValue()));
            }
            if (state == null) {
                String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " failed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{optimizer.getClass().getName()}));
                this.logError((Function0<String>)new $anonfun$7(this, msg));
                throw new SparkException(msg);
            }
            double[] rawCoefficients = (double[])((DenseVector)state.x()).toArray$mcD$sp(ClassTag$.MODULE$.Double()).clone();
            for (int i = 0; i < numFeatures; ++i) {
                int n = i;
                rawCoefficients[n] = rawCoefficients[n] * (featuresStd[i] != 0.0 ? 1.0 / featuresStd[i] : 0.0);
            }
            Tuple3 tuple32 = tuple3 = BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) ? new Tuple3((Object)Vectors$.MODULE$.dense((double[])Predef$.MODULE$.doubleArrayOps(rawCoefficients).dropRight(1)).compressed(), Predef$.MODULE$.doubleArrayOps(rawCoefficients).last(), arrayBuilder.result()) : new Tuple3((Object)Vectors$.MODULE$.dense(rawCoefficients).compressed(), (Object)BoxesRunTime.boxToDouble((double)0.0), arrayBuilder.result());
            if (tuple3 != null) {
                Tuple3 tuple33;
                Vector coefficients = (Vector)tuple3._1();
                double intercept = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                double[] objectiveHistory = (double[])tuple3._3();
                Tuple3 tuple34 = tuple33 = new Tuple3((Object)coefficients, (Object)BoxesRunTime.boxToDouble((double)intercept), (Object)objectiveHistory);
                Vector coefficients2 = (Vector)tuple34._1();
                double intercept2 = BoxesRunTime.unboxToDouble((Object)tuple34._2());
                double[] objectiveHistory2 = (double[])tuple34._3();
                Object object2 = handlePersistence ? instances.unpersist(instances.unpersist$default$1()) : BoxedUnit.UNIT;
                LogisticRegressionModel model = this.copyValues(new LogisticRegressionModel(this.uid(), coefficients2, intercept2), this.copyValues$default$2());
                BinaryLogisticRegressionTrainingSummary logRegSummary = new BinaryLogisticRegressionTrainingSummary(model.transform(dataset), this.$(this.probabilityCol()), this.$(this.labelCol()), this.$(this.featuresCol()), objectiveHistory2);
                return model.setSummary(logRegSummary);
            }
            throw new MatchError((Object)tuple3);
        }
        throw new MatchError((Object)tuple2);
    }

    @Override
    public LogisticRegression copy(ParamMap extra) {
        return (LogisticRegression)this.defaultCopy(extra);
    }

    private final Function1 regParamL1Fun$1(int numFeatures$1, double[] featuresStd$1, double regParamL1$1) {
        return new Serializable(this, numFeatures$1, featuresStd$1, regParamL1$1){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticRegression $outer;
            private final int numFeatures$1;
            private final double[] featuresStd$1;
            private final double regParamL1$1;

            public final double apply(int index2) {
                return this.apply$mcDI$sp(index2);
            }

            public double apply$mcDI$sp(int index2) {
                return index2 == this.numFeatures$1 ? 0.0 : (BoxesRunTime.unboxToBoolean((Object)this.$outer.$(this.$outer.standardization())) ? this.regParamL1$1 : (this.featuresStd$1[index2] != 0.0 ? this.regParamL1$1 / this.featuresStd$1[index2] : 0.0));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.numFeatures$1 = numFeatures$1;
                this.featuresStd$1 = featuresStd$1;
                this.regParamL1$1 = regParamL1$1;
            }
        };
    }

    public LogisticRegression(String uid) {
        this.uid = uid;
        HasRegParam$class.$init$(this);
        HasElasticNetParam$class.$init$(this);
        HasMaxIter$class.$init$(this);
        HasFitIntercept$class.$init$(this);
        HasTol$class.$init$(this);
        HasStandardization$class.$init$(this);
        HasWeightCol$class.$init$(this);
        HasThreshold$class.$init$(this);
        LogisticRegressionParams$class.$init$(this);
        MLWritable$class.$init$(this);
        DefaultParamsWritable$class.$init$(this);
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.regParam().$minus$greater(BoxesRunTime.boxToDouble((double)0.0))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.elasticNetParam().$minus$greater(BoxesRunTime.boxToDouble((double)0.0))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.maxIter().$minus$greater(BoxesRunTime.boxToInteger((int)100))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.tol().$minus$greater(BoxesRunTime.boxToDouble((double)1.0E-6))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.fitIntercept().$minus$greater(BoxesRunTime.boxToBoolean((boolean)true))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.standardization().$minus$greater(BoxesRunTime.boxToBoolean((boolean)true))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.weightCol().$minus$greater("")}));
    }

    public LogisticRegression() {
        this(Identifiable$.MODULE$.randomUID("logreg"));
    }
}

