/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree.impl;

import org.apache.spark.Logging;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impl.DecisionTreeMetadata;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichDouble$;

public final class DecisionTreeMetadata$
implements Logging,
Serializable {
    public static final DecisionTreeMetadata$ MODULE$;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new DecisionTreeMetadata$();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public DecisionTreeMetadata buildMetadata(RDD<LabeledPoint> input, Strategy strategy, int numTrees, String featureSubsetStrategy) {
        Enumeration.Value value;
        block13: {
            String string;
            block18: {
                int n;
                int[] numBins;
                HashSet unorderedFeatures;
                int numClasses;
                long numExamples;
                int numFeatures;
                block15: {
                    block17: {
                        block16: {
                            block14: {
                                String _featureSubsetStrategy;
                                String string2;
                                String string3;
                                int n2;
                                block12: {
                                    block11: {
                                        numFeatures = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps((int[])input.map((Function1)new Serializable(){
                                            public static final long serialVersionUID = 0L;

                                            public final int apply(LabeledPoint x$1) {
                                                return x$1.features().size();
                                            }
                                        }, ClassTag$.MODULE$.Int()).take(1)).headOption().getOrElse((Function0)new Serializable(){
                                            public static final long serialVersionUID = 0L;

                                            public final Nothing$ apply() {
                                                throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DecisionTree requires size of input RDD > 0, "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but was given by empty one."})).s((Seq)Nil$.MODULE$)).toString());
                                            }
                                        }));
                                        numExamples = input.count();
                                        value = strategy.algo();
                                        Enumeration.Value value2 = Algo$.MODULE$.Classification();
                                        Enumeration.Value value3 = value;
                                        if (value2 != null ? !value2.equals(value3) : value3 != null) break block11;
                                        n2 = strategy.numClasses();
                                        break block12;
                                    }
                                    Enumeration.Value value4 = Algo$.MODULE$.Regression();
                                    Enumeration.Value value5 = value;
                                    if (value4 != null ? !value4.equals(value5) : value5 != null) break block13;
                                    n2 = 0;
                                }
                                numClasses = n2;
                                int maxPossibleBins = (int)package$.MODULE$.min((long)strategy.maxBins(), numExamples);
                                if (maxPossibleBins < strategy.maxBins()) {
                                    this.logWarning((Function0<String>)new Serializable(strategy, maxPossibleBins){
                                        public static final long serialVersionUID = 0L;
                                        private final Strategy strategy$1;
                                        private final int maxPossibleBins$1;

                                        public final String apply() {
                                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DecisionTree reducing maxBins from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.strategy$1.maxBins()), BoxesRunTime.boxToInteger((int)this.maxPossibleBins$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" (= number of training instances)"})).s((Seq)Nil$.MODULE$)).toString();
                                        }
                                        {
                                            this.strategy$1 = strategy$1;
                                            this.maxPossibleBins$1 = maxPossibleBins$1;
                                        }
                                    });
                                }
                                if (strategy.categoricalFeaturesInfo().nonEmpty()) {
                                    int maxCategoriesPerFeature = BoxesRunTime.unboxToInt((Object)strategy.categoricalFeaturesInfo().values().max((Ordering)Ordering.Int$.MODULE$));
                                    int maxCategory = ((Tuple2)strategy.categoricalFeaturesInfo().find((Function1)new Serializable(maxCategoriesPerFeature){
                                        public static final long serialVersionUID = 0L;
                                        private final int maxCategoriesPerFeature$1;

                                        public final boolean apply(Tuple2<Object, Object> x$2) {
                                            return x$2._2$mcI$sp() == this.maxCategoriesPerFeature$1;
                                        }
                                        {
                                            this.maxCategoriesPerFeature$1 = maxCategoriesPerFeature$1;
                                        }
                                    }).get())._1$mcI$sp();
                                    Predef$.MODULE$.require(maxCategoriesPerFeature <= maxPossibleBins, (Function0)new Serializable(maxPossibleBins, maxCategoriesPerFeature, maxCategory){
                                        public static final long serialVersionUID = 0L;
                                        private final int maxPossibleBins$1;
                                        private final int maxCategoriesPerFeature$1;
                                        private final int maxCategory$1;

                                        public final String apply() {
                                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DecisionTree requires maxBins (= ", ") to be at least as large as the "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.maxPossibleBins$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"number of values in each categorical feature, but categorical feature ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.maxCategory$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"has ", " values. Considering remove this and other categorical "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.maxCategoriesPerFeature$1)}))).append((Object)"features with a large number of values, or add more training examples.").toString();
                                        }
                                        {
                                            this.maxPossibleBins$1 = maxPossibleBins$1;
                                            this.maxCategoriesPerFeature$1 = maxCategoriesPerFeature$1;
                                            this.maxCategory$1 = maxCategory$1;
                                        }
                                    });
                                }
                                unorderedFeatures = new HashSet();
                                numBins = (int[])Array$.MODULE$.fill(numFeatures, (Function0)new Serializable(maxPossibleBins){
                                    public static final long serialVersionUID = 0L;
                                    private final int maxPossibleBins$1;

                                    public final int apply() {
                                        return this.apply$mcI$sp();
                                    }

                                    public int apply$mcI$sp() {
                                        return this.maxPossibleBins$1;
                                    }
                                    {
                                        this.maxPossibleBins$1 = maxPossibleBins$1;
                                    }
                                }, ClassTag$.MODULE$.Int());
                                if (numClasses > 2) {
                                    int maxCategoriesForUnorderedFeature = (int)RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper(package$.MODULE$.log((double)(maxPossibleBins / 2 + 1)) / package$.MODULE$.log(2.0) + 1.0));
                                    strategy.categoricalFeaturesInfo().foreach((Function1)new Serializable(unorderedFeatures, numBins, maxCategoriesForUnorderedFeature){
                                        public static final long serialVersionUID = 0L;
                                        private final HashSet unorderedFeatures$1;
                                        private final int[] numBins$1;
                                        private final int maxCategoriesForUnorderedFeature$1;

                                        public final void apply(Tuple2<Object, Object> x0$1) {
                                            Tuple2<Object, Object> tuple2 = x0$1;
                                            if (tuple2 != null) {
                                                BoxedUnit boxedUnit;
                                                int featureIndex = tuple2._1$mcI$sp();
                                                int numCategories = tuple2._2$mcI$sp();
                                                if (numCategories > 1) {
                                                    if (numCategories <= this.maxCategoriesForUnorderedFeature$1) {
                                                        this.unorderedFeatures$1.add((Object)BoxesRunTime.boxToInteger((int)featureIndex));
                                                        this.numBins$1[featureIndex] = DecisionTreeMetadata$.MODULE$.numUnorderedBins(numCategories);
                                                        boxedUnit = BoxedUnit.UNIT;
                                                    } else {
                                                        this.numBins$1[featureIndex] = numCategories;
                                                        boxedUnit = BoxedUnit.UNIT;
                                                    }
                                                } else {
                                                    boxedUnit = BoxedUnit.UNIT;
                                                }
                                                BoxedUnit boxedUnit2 = boxedUnit;
                                                return;
                                            }
                                            throw new MatchError(tuple2);
                                        }
                                        {
                                            this.unorderedFeatures$1 = unorderedFeatures$1;
                                            this.numBins$1 = numBins$1;
                                            this.maxCategoriesForUnorderedFeature$1 = maxCategoriesForUnorderedFeature$1;
                                        }
                                    });
                                } else {
                                    strategy.categoricalFeaturesInfo().foreach((Function1)new Serializable(numBins){
                                        public static final long serialVersionUID = 0L;
                                        private final int[] numBins$1;

                                        public final void apply(Tuple2<Object, Object> x0$2) {
                                            Tuple2<Object, Object> tuple2 = x0$2;
                                            if (tuple2 != null) {
                                                BoxedUnit boxedUnit;
                                                int featureIndex = tuple2._1$mcI$sp();
                                                int numCategories = tuple2._2$mcI$sp();
                                                if (numCategories > 1) {
                                                    this.numBins$1[featureIndex] = numCategories;
                                                    boxedUnit = BoxedUnit.UNIT;
                                                } else {
                                                    boxedUnit = BoxedUnit.UNIT;
                                                }
                                                BoxedUnit boxedUnit2 = boxedUnit;
                                                return;
                                            }
                                            throw new MatchError(tuple2);
                                        }
                                        {
                                            this.numBins$1 = numBins$1;
                                        }
                                    });
                                }
                                String string4 = string3 = featureSubsetStrategy;
                                if (!("auto" != null ? !"auto".equals(string4) : string4 != null)) {
                                    String string5;
                                    if (numTrees == 1) {
                                        string5 = "all";
                                    } else {
                                        Enumeration.Value value6 = strategy.algo();
                                        Enumeration.Value value7 = Algo$.MODULE$.Classification();
                                        string5 = !(value6 != null ? !value6.equals(value7) : value7 != null) ? "sqrt" : "onethird";
                                    }
                                    string2 = string5;
                                } else {
                                    string2 = featureSubsetStrategy;
                                }
                                String string6 = string = (_featureSubsetStrategy = string2);
                                if ("all" != null ? !"all".equals(string6) : string6 != null) break block14;
                                n = numFeatures;
                                break block15;
                            }
                            String string7 = string;
                            if ("sqrt" != null ? !"sqrt".equals(string7) : string7 != null) break block16;
                            n = (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(package$.MODULE$.sqrt((double)numFeatures)));
                            break block15;
                        }
                        String string8 = string;
                        if ("log2" != null ? !"log2".equals(string8) : string8 != null) break block17;
                        n = package$.MODULE$.max(1, (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(package$.MODULE$.log((double)numFeatures) / package$.MODULE$.log(2.0))));
                        break block15;
                    }
                    String string9 = string;
                    if ("onethird" != null ? !"onethird".equals(string9) : string9 != null) break block18;
                    n = (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper((double)numFeatures / 3.0));
                }
                int numFeaturesPerNode = n;
                return new DecisionTreeMetadata(numFeatures, numExamples, numClasses, BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(numBins).max((Ordering)Ordering.Int$.MODULE$)), strategy.categoricalFeaturesInfo(), (Set<Object>)unorderedFeatures.toSet(), numBins, strategy.impurity(), strategy.quantileCalculationStrategy(), strategy.maxDepth(), strategy.minInstancesPerNode(), strategy.minInfoGain(), numTrees, numFeaturesPerNode);
            }
            throw new MatchError((Object)string);
        }
        throw new MatchError((Object)value);
    }

    public DecisionTreeMetadata buildMetadata(RDD<LabeledPoint> input, Strategy strategy) {
        return this.buildMetadata(input, strategy, 1, "all");
    }

    public int numUnorderedBins(int arity) {
        return 2 * ((1 << arity - 1) - 1);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private DecisionTreeMetadata$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

