/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import java.util.Random;
import org.apache.spark.Logging;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.clustering.BisectingKMeans$;
import org.apache.spark.mllib.clustering.BisectingKMeansModel;
import org.apache.spark.mllib.clustering.ClusteringTreeNode;
import org.apache.spark.mllib.clustering.VectorWithNorm;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Seq$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\r\u0005d\u0001B\u0001\u0003\u00015\u0011qBQ5tK\u000e$\u0018N\\4L\u001b\u0016\fgn\u001d\u0006\u0003\u0007\u0011\t!b\u00197vgR,'/\u001b8h\u0015\t)a!A\u0003nY2L'M\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b\u0015!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011QCF\u0007\u0002\r%\u0011qC\u0002\u0002\b\u0019><w-\u001b8h\u0011!I\u0002A!a\u0001\n\u0013Q\u0012!A6\u0016\u0003m\u0001\"a\u0004\u000f\n\u0005u\u0001\"aA%oi\"Aq\u0004\u0001BA\u0002\u0013%\u0001%A\u0003l?\u0012*\u0017\u000f\u0006\u0002\"IA\u0011qBI\u0005\u0003GA\u0011A!\u00168ji\"9QEHA\u0001\u0002\u0004Y\u0012a\u0001=%c!Aq\u0005\u0001B\u0001B\u0003&1$\u0001\u0002lA!A\u0011\u0006\u0001BA\u0002\u0013%!$A\u0007nCbLE/\u001a:bi&|gn\u001d\u0005\tW\u0001\u0011\t\u0019!C\u0005Y\u0005\tR.\u0019=Ji\u0016\u0014\u0018\r^5p]N|F%Z9\u0015\u0005\u0005j\u0003bB\u0013+\u0003\u0003\u0005\ra\u0007\u0005\t_\u0001\u0011\t\u0011)Q\u00057\u0005qQ.\u0019=Ji\u0016\u0014\u0018\r^5p]N\u0004\u0003\u0002C\u0019\u0001\u0005\u0003\u0007I\u0011\u0002\u001a\u0002/5Lg\u000eR5wSNL'\r\\3DYV\u001cH/\u001a:TSj,W#A\u001a\u0011\u0005=!\u0014BA\u001b\u0011\u0005\u0019!u.\u001e2mK\"Aq\u0007\u0001BA\u0002\u0013%\u0001(A\u000enS:$\u0015N^5tS\ndWm\u00117vgR,'oU5{K~#S-\u001d\u000b\u0003CeBq!\n\u001c\u0002\u0002\u0003\u00071\u0007\u0003\u0005<\u0001\t\u0005\t\u0015)\u00034\u0003ai\u0017N\u001c#jm&\u001c\u0018N\u00197f\u00072,8\u000f^3s'&TX\r\t\u0005\t{\u0001\u0011\t\u0019!C\u0005}\u0005!1/Z3e+\u0005y\u0004CA\bA\u0013\t\t\u0005C\u0001\u0003M_:<\u0007\u0002C\"\u0001\u0005\u0003\u0007I\u0011\u0002#\u0002\u0011M,W\rZ0%KF$\"!I#\t\u000f\u0015\u0012\u0015\u0011!a\u0001\u007f!Aq\t\u0001B\u0001B\u0003&q(A\u0003tK\u0016$\u0007\u0005C\u0003J\u0001\u0011%!*\u0001\u0004=S:LGO\u0010\u000b\u0006\u00176su\n\u0015\t\u0003\u0019\u0002i\u0011A\u0001\u0005\u00063!\u0003\ra\u0007\u0005\u0006S!\u0003\ra\u0007\u0005\u0006c!\u0003\ra\r\u0005\u0006{!\u0003\ra\u0010\u0005\u0006\u0013\u0002!\tA\u0015\u000b\u0002\u0017\"\u001a\u0011\u000b\u0016.\u0011\u0005UCV\"\u0001,\u000b\u0005]3\u0011AC1o]>$\u0018\r^5p]&\u0011\u0011L\u0016\u0002\u0006'&t7-Z\u0011\u00027\u0006)\u0011G\f\u001c/a!)Q\f\u0001C\u0001=\u0006!1/\u001a;L)\ty\u0006-D\u0001\u0001\u0011\u0015IB\f1\u0001\u001cQ\raFK\u0017\u0005\u0006G\u0002!\tAG\u0001\u0005O\u0016$8\nK\u0002c)jCQA\u001a\u0001\u0005\u0002\u001d\f\u0001c]3u\u001b\u0006D\u0018\n^3sCRLwN\\:\u0015\u0005}C\u0007\"B\u0015f\u0001\u0004Y\u0002fA3U5\")1\u000e\u0001C\u00015\u0005\u0001r-\u001a;NCbLE/\u001a:bi&|gn\u001d\u0015\u0004URS\u0006\"\u00028\u0001\t\u0003y\u0017AG:fi6Kg\u000eR5wSNL'\r\\3DYV\u001cH/\u001a:TSj,GCA0q\u0011\u0015\tT\u000e1\u00014Q\riGK\u0017\u0005\u0006g\u0002!\tAM\u0001\u001bO\u0016$X*\u001b8ESZL7/\u001b2mK\u000ecWo\u001d;feNK'0\u001a\u0015\u0004eRS\u0006\"\u0002<\u0001\t\u00039\u0018aB:fiN+W\r\u001a\u000b\u0003?bDQ!P;A\u0002}B3!\u001e+[\u0011\u0015Y\b\u0001\"\u0001?\u0003\u001d9W\r^*fK\u0012D3A\u001f+[\u0011\u0015q\b\u0001\"\u0001\u0000\u0003\r\u0011XO\u001c\u000b\u0005\u0003\u0003\t9\u0001E\u0002M\u0003\u0007I1!!\u0002\u0003\u0005Q\u0011\u0015n]3di&twmS'fC:\u001cXj\u001c3fY\"9\u0011\u0011B?A\u0002\u0005-\u0011!B5oaV$\bCBA\u0007\u0003'\t9\"\u0004\u0002\u0002\u0010)\u0019\u0011\u0011\u0003\u0004\u0002\u0007I$G-\u0003\u0003\u0002\u0016\u0005=!a\u0001*E\tB!\u0011\u0011DA\u0010\u001b\t\tYBC\u0002\u0002\u001e\u0011\ta\u0001\\5oC2<\u0017\u0002BA\u0011\u00037\u0011aAV3di>\u0014\bfA?U5\"1a\u0010\u0001C\u0001\u0003O!B!!\u0001\u0002*!A\u00111FA\u0013\u0001\u0004\ti#\u0001\u0003eCR\f\u0007CBA\u0018\u0003s\t9\"\u0004\u0002\u00022)!\u00111GA\u001b\u0003\u0011Q\u0017M^1\u000b\u0007\u0005]b!A\u0002ba&LA!a\u000f\u00022\t9!*\u0019<b%\u0012#\u0005f\u0001\u0001\u0002@A\u0019Q+!\u0011\n\u0007\u0005\rcK\u0001\u0007FqB,'/[7f]R\fG\u000eK\u0002\u0001)j;q!!\u0013\u0003\u0011\u0013\tY%A\bCSN,7\r^5oO.kU-\u00198t!\ra\u0015Q\n\u0004\u0007\u0003\tAI!a\u0014\u0014\u000b\u00055c\"!\u0015\u0011\u0007=\t\u0019&C\u0002\u0002VA\u0011AbU3sS\u0006d\u0017N_1cY\u0016Dq!SA'\t\u0003\tI\u0006\u0006\u0002\u0002L!I\u0011QLA'\u0005\u0004%IAP\u0001\u000b%>{EkX%O\t\u0016C\u0006\u0002CA1\u0003\u001b\u0002\u000b\u0011B \u0002\u0017I{u\nV0J\u001d\u0012+\u0005\f\t\u0005\n\u0003K\niE1A\u0005\ny\n1$T!Y?\u0012Ke+S*J\u00052+ul\u0011'V'R+%kX%O\t\u0016C\u0006\u0002CA5\u0003\u001b\u0002\u000b\u0011B \u000295\u000b\u0005l\u0018#J-&\u001b\u0016J\u0011'F?\u000ecUk\u0015+F%~Ke\nR#YA!I\u0011QNA'\u0005\u0004%IAM\u0001\f\u0019\u00163V\tT0M\u00136KE\u000b\u0003\u0005\u0002r\u00055\u0003\u0015!\u00034\u00031aUIV#M?2KU*\u0013+!\u0011!\t)(!\u0014\u0005\n\u0005]\u0014A\u00047fMR\u001c\u0005.\u001b7e\u0013:$W\r\u001f\u000b\u0004\u007f\u0005e\u0004bBA>\u0003g\u0002\raP\u0001\u0006S:$W\r\u001f\u0005\t\u0003\u007f\ni\u0005\"\u0003\u0002\u0002\u0006y!/[4ii\u000eC\u0017\u000e\u001c3J]\u0012,\u0007\u0010F\u0002@\u0003\u0007Cq!a\u001f\u0002~\u0001\u0007q\b\u0003\u0005\u0002\b\u00065C\u0011BAE\u0003-\u0001\u0018M]3oi&sG-\u001a=\u0015\u0007}\nY\tC\u0004\u0002|\u0005\u0015\u0005\u0019A \t\u0011\u0005=\u0015Q\nC\u0005\u0003#\u000b\u0011b];n[\u0006\u0014\u0018N_3\u0015\r\u0005M%\u0011\u000eB7!\u001d\t)*a'@\u0003Cs1aDAL\u0013\r\tI\nE\u0001\u0007!J,G-\u001a4\n\t\u0005u\u0015q\u0014\u0002\u0004\u001b\u0006\u0004(bAAM!A!\u00111UAS\u001b\t\tiEB\u0004\u0002(\u00065C)!+\u0003\u001d\rcWo\u001d;feN+X.\\1ssN9\u0011Q\u0015\b\u0002,\u0006E\u0003cA\b\u0002.&\u0019\u0011q\u0016\t\u0003\u000fA\u0013x\u000eZ;di\"Q\u00111WAS\u0005+\u0007I\u0011\u0001 \u0002\tML'0\u001a\u0005\u000b\u0003o\u000b)K!E!\u0002\u0013y\u0014!B:ju\u0016\u0004\u0003bCA^\u0003K\u0013)\u001a!C\u0001\u0003{\u000baaY3oi\u0016\u0014XCAA`!\ra\u0015\u0011Y\u0005\u0004\u0003\u0007\u0014!A\u0004,fGR|'oV5uQ:{'/\u001c\u0005\f\u0003\u000f\f)K!E!\u0002\u0013\ty,A\u0004dK:$XM\u001d\u0011\t\u0015\u0005-\u0017Q\u0015BK\u0002\u0013\u0005!'\u0001\u0003d_N$\bBCAh\u0003K\u0013\t\u0012)A\u0005g\u0005)1m\\:uA!9\u0011*!*\u0005\u0002\u0005MG\u0003CAQ\u0003+\f9.!7\t\u000f\u0005M\u0016\u0011\u001ba\u0001\u007f!A\u00111XAi\u0001\u0004\ty\fC\u0004\u0002L\u0006E\u0007\u0019A\u001a\t\u0015\u0005u\u0017QUA\u0001\n\u0003\ty.\u0001\u0003d_BLH\u0003CAQ\u0003C\f\u0019/!:\t\u0013\u0005M\u00161\u001cI\u0001\u0002\u0004y\u0004BCA^\u00037\u0004\n\u00111\u0001\u0002@\"I\u00111ZAn!\u0003\u0005\ra\r\u0005\u000b\u0003S\f)+%A\u0005\u0002\u0005-\u0018AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003[T3aPAxW\t\t\t\u0010\u0005\u0003\u0002t\u0006mXBAA{\u0015\u0011\t90!?\u0002\u0013Ut7\r[3dW\u0016$'BA,\u0011\u0013\u0011\ti0!>\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0003\u0006\u0003\u0002\u0005\u0015\u0016\u0013!C\u0001\u0005\u0007\tabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0003\u0006)\"\u0011qXAx\u0011)\u0011I!!*\u0012\u0002\u0013\u0005!1B\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011iAK\u00024\u0003_D!B!\u0005\u0002&\u0006\u0005I\u0011\tB\n\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!Q\u0003\t\u0005\u0005/\u0011y\"\u0004\u0002\u0003\u001a)!!1\u0004B\u000f\u0003\u0011a\u0017M\\4\u000b\u0005\u0005M\u0012\u0002\u0002B\u0011\u00053\u0011aa\u0015;sS:<\u0007\"\u0003B\u0013\u0003K\u000b\t\u0011\"\u0001\u001b\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u0011)\u0011I#!*\u0002\u0002\u0013\u0005!1F\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011iCa\r\u0011\u0007=\u0011y#C\u0002\u00032A\u00111!\u00118z\u0011!)#qEA\u0001\u0002\u0004Y\u0002B\u0003B\u001c\u0003K\u000b\t\u0011\"\u0011\u0003:\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003<A1!Q\bB\"\u0005[i!Aa\u0010\u000b\u0007\t\u0005\u0003#\u0001\u0006d_2dWm\u0019;j_:LAA!\u0012\u0003@\tA\u0011\n^3sCR|'\u000f\u0003\u0006\u0003J\u0005\u0015\u0016\u0011!C\u0001\u0005\u0017\n\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005\u001b\u0012\u0019\u0006E\u0002\u0010\u0005\u001fJ1A!\u0015\u0011\u0005\u001d\u0011un\u001c7fC:D\u0011\"\nB$\u0003\u0003\u0005\rA!\f\t\u0015\t]\u0013QUA\u0001\n\u0003\u0012I&\u0001\u0005iCND7i\u001c3f)\u0005Y\u0002B\u0003B/\u0003K\u000b\t\u0011\"\u0011\u0003`\u0005AAo\\*ue&tw\r\u0006\u0002\u0003\u0016!Q!1MAS\u0003\u0003%\tE!\u001a\u0002\r\u0015\fX/\u00197t)\u0011\u0011iEa\u001a\t\u0013\u0015\u0012\t'!AA\u0002\t5\u0002b\u0002B6\u0003\u001b\u0003\raG\u0001\u0002I\"A!qNAG\u0001\u0004\u0011\t(A\u0006bgNLwM\\7f]R\u001c\bCBA\u0007\u0003'\u0011\u0019\b\u0005\u0004\u0010\u0005kz\u0014qX\u0005\u0004\u0005o\u0002\"A\u0002+va2,'GB\u0004\u0003|\u00055CA! \u00031\rcWo\u001d;feN+X.\\1ss\u0006;wM]3hCR|'oE\u0003\u0003z9\t\t\u0006\u0003\u0006\u0003l\te$Q1A\u0005\u0002iA!Ba!\u0003z\t\u0005\t\u0015!\u0003\u001c\u0003\t!\u0007\u0005C\u0004J\u0005s\"\tAa\"\u0015\t\t%%1\u0012\t\u0005\u0003G\u0013I\bC\u0004\u0003l\t\u0015\u0005\u0019A\u000e\t\u0013\t=%\u0011\u0010a\u0001\n\u0013q\u0014!\u00018\t\u0015\tM%\u0011\u0010a\u0001\n\u0013\u0011)*A\u0003o?\u0012*\u0017\u000fF\u0002\"\u0005/C\u0001\"\nBI\u0003\u0003\u0005\ra\u0010\u0005\t\u00057\u0013I\b)Q\u0005\u007f\u0005\u0011a\u000e\t\u0005\u000b\u0005?\u0013IH1A\u0005\n\t\u0005\u0016aA:v[V\u0011\u0011q\u0003\u0005\n\u0005K\u0013I\b)A\u0005\u0003/\tAa];nA!I!\u0011\u0016B=\u0001\u0004%IAM\u0001\u0006gVl7+\u001d\u0005\u000b\u0005[\u0013I\b1A\u0005\n\t=\u0016!C:v[N\u000bx\fJ3r)\r\t#\u0011\u0017\u0005\tK\t-\u0016\u0011!a\u0001g!A!Q\u0017B=A\u0003&1'\u0001\u0004tk6\u001c\u0016\u000f\t\u0005\t\u0005s\u0013I\b\"\u0001\u0003<\u0006\u0019\u0011\r\u001a3\u0015\t\tu&qX\u0007\u0003\u0005sB\u0001B!1\u00038\u0002\u0007\u0011qX\u0001\u0002m\"A!Q\u0019B=\t\u0003\u00119-A\u0003nKJ<W\r\u0006\u0003\u0003>\n%\u0007\u0002\u0003Bf\u0005\u0007\u0004\rA!#\u0002\u000b=$\b.\u001a:\t\u0011\t='\u0011\u0010C\u0001\u0005#\fqa];n[\u0006\u0014\u00180\u0006\u0002\u0002\"\"A!Q[A'\t\u0013\u00119.A\u0006ta2LGoQ3oi\u0016\u0014HC\u0002Bm\u00057\u0014i\u000eE\u0004\u0010\u0005k\ny,a0\t\u0011\u0005m&1\u001ba\u0001\u0003\u007fC\u0001Ba8\u0003T\u0002\u0007!\u0011]\u0001\u0007e\u0006tGm\\7\u0011\t\t\r(\u0011^\u0007\u0003\u0005KTAAa:\u0003\u001e\u0005!Q\u000f^5m\u0013\u0011\u0011YO!:\u0003\rI\u000bg\u000eZ8n\u0011!\u0011y/!\u0014\u0005\n\tE\u0018!E;qI\u0006$X-Q:tS\u001etW.\u001a8ugRA!\u0011\u000fBz\u0005k\u0014y\u0010\u0003\u0005\u0003p\t5\b\u0019\u0001B9\u0011!\u00119P!<A\u0002\te\u0018\u0001\u00053jm&\u001c\u0018N\u00197f\u0013:$\u0017nY3t!\u0015\t)Ja?@\u0013\u0011\u0011i0a(\u0003\u0007M+G\u000f\u0003\u0005\u0004\u0002\t5\b\u0019AB\u0002\u0003EqWm^\"mkN$XM]\"f]R,'o\u001d\t\b\u0003+\u000bYjPA`\u0011!\u00199!!\u0014\u0005\n\r%\u0011!\u00032vS2$GK]3f)\u0011\u0019Ya!\u0005\u0011\u00071\u001bi!C\u0002\u0004\u0010\t\u0011!c\u00117vgR,'/\u001b8h)J,WMT8eK\"A11CB\u0003\u0001\u0004\t\u0019*\u0001\u0005dYV\u001cH/\u001a:t\u000f)\u00199\"!\u0014\u0002\u0002#%1\u0011D\u0001\u000f\u00072,8\u000f^3s'VlW.\u0019:z!\u0011\t\u0019ka\u0007\u0007\u0015\u0005\u001d\u0016QJA\u0001\u0012\u0013\u0019ib\u0005\u0004\u0004\u001c\r}\u0011\u0011\u000b\t\u000b\u0007C\u00199cPA`g\u0005\u0005VBAB\u0012\u0015\r\u0019)\u0003E\u0001\beVtG/[7f\u0013\u0011\u0019Ica\t\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007C\u0004J\u00077!\ta!\f\u0015\u0005\re\u0001B\u0003B/\u00077\t\t\u0011\"\u0012\u0003`!Q11GB\u000e\u0003\u0003%\ti!\u000e\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0011\u0005\u00056qGB\u001d\u0007wAq!a-\u00042\u0001\u0007q\b\u0003\u0005\u0002<\u000eE\u0002\u0019AA`\u0011\u001d\tYm!\rA\u0002MB!ba\u0010\u0004\u001c\u0005\u0005I\u0011QB!\u0003\u001d)h.\u00199qYf$Baa\u0011\u0004PA)qb!\u0012\u0004J%\u00191q\t\t\u0003\r=\u0003H/[8o!\u001dy11J \u0002@NJ1a!\u0014\u0011\u0005\u0019!V\u000f\u001d7fg!Q1\u0011KB\u001f\u0003\u0003\u0005\r!!)\u0002\u0007a$\u0003\u0007\u0003\u0006\u0004V\rm\u0011\u0011!C\u0005\u0007/\n1B]3bIJ+7o\u001c7wKR\u00111\u0011\f\t\u0005\u0005/\u0019Y&\u0003\u0003\u0004^\te!AB(cU\u0016\u001cG\u000f\u0003\u0006\u0004V\u00055\u0013\u0011!C\u0005\u0007/\u0002")
public class BisectingKMeans
implements Logging {
    private int k;
    private int maxIterations;
    private double minDivisibleClusterSize;
    private long seed;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    private int k() {
        return this.k;
    }

    private void k_$eq(int x$1) {
        this.k = x$1;
    }

    private int maxIterations() {
        return this.maxIterations;
    }

    private void maxIterations_$eq(int x$1) {
        this.maxIterations = x$1;
    }

    private double minDivisibleClusterSize() {
        return this.minDivisibleClusterSize;
    }

    private void minDivisibleClusterSize_$eq(double x$1) {
        this.minDivisibleClusterSize = x$1;
    }

    private long seed() {
        return this.seed;
    }

    private void seed_$eq(long x$1) {
        this.seed = x$1;
    }

    public BisectingKMeans setK(int k) {
        Predef$.MODULE$.require(k > 0, (Function0)new Serializable(this, k){
            public static final long serialVersionUID = 0L;
            private final int k$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k must be positive but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.k$1)}));
            }
            {
                this.k$1 = k$1;
            }
        });
        this.k_$eq(k);
        return this;
    }

    public int getK() {
        return this.k();
    }

    public BisectingKMeans setMaxIterations(int maxIterations) {
        Predef$.MODULE$.require(maxIterations > 0, (Function0)new Serializable(this, maxIterations){
            public static final long serialVersionUID = 0L;
            private final int maxIterations$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"maxIterations must be positive but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.maxIterations$1)}));
            }
            {
                this.maxIterations$1 = maxIterations$1;
            }
        });
        this.maxIterations_$eq(maxIterations);
        return this;
    }

    public int getMaxIterations() {
        return this.maxIterations();
    }

    public BisectingKMeans setMinDivisibleClusterSize(double minDivisibleClusterSize) {
        Predef$.MODULE$.require(minDivisibleClusterSize > 0.0, (Function0)new Serializable(this, minDivisibleClusterSize){
            public static final long serialVersionUID = 0L;
            private final double minDivisibleClusterSize$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"minDivisibleClusterSize must be positive but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.minDivisibleClusterSize$1)}));
            }
            {
                this.minDivisibleClusterSize$1 = minDivisibleClusterSize$1;
            }
        });
        this.minDivisibleClusterSize_$eq(minDivisibleClusterSize);
        return this;
    }

    public double getMinDivisibleClusterSize() {
        return this.minDivisibleClusterSize();
    }

    public BisectingKMeans setSeed(long seed) {
        this.seed_$eq(seed);
        return this;
    }

    public long getSeed() {
        return this.seed();
    }

    public BisectingKMeansModel run(RDD<Vector> input) {
        StorageLevel storageLevel = input.getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        if (!(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null)) {
            this.logWarning((Function0<String>)new Serializable(this, input){
                public static final long serialVersionUID = 0L;
                private final RDD input$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The input RDD ", " is not directly cached, which may hurt performance if"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.input$1.id())}))).append((Object)" its parent RDDs are also not cached.").toString();
                }
                {
                    this.input$1 = input$1;
                }
            });
        }
        int d = BoxesRunTime.unboxToInt((Object)input.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Vector x$1) {
                return x$1.size();
            }
        }, ClassTag$.MODULE$.Int()).first());
        this.logInfo((Function0<String>)new Serializable(this, d){
            public static final long serialVersionUID = 0L;
            private final int d$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Feature dimension: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.d$1)}));
            }
            {
                this.d$1 = d$1;
            }
        });
        RDD norms = input.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(Vector v) {
                return Vectors$.MODULE$.norm(v, 2.0);
            }
        }, ClassTag$.MODULE$.Double()).persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
        RDD vectors = input.zip(norms, ClassTag$.MODULE$.Double()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final VectorWithNorm apply(Tuple2<Vector, Object> x0$1) {
                Tuple2<Vector, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    Vector x = (Vector)tuple2._1();
                    double norm2 = tuple2._2$mcD$sp();
                    VectorWithNorm vectorWithNorm = new VectorWithNorm(x, norm2);
                    return vectorWithNorm;
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(VectorWithNorm.class));
        ObjectRef assignments = new ObjectRef((Object)vectors.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, VectorWithNorm> apply(VectorWithNorm v) {
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$ROOT_INDEX()), (Object)v);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)));
        Map activeClusters = BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$summarize(d, (RDD<Tuple2<Object, VectorWithNorm>>)((RDD)assignments.elem));
        ClusterSummary rootSummary = (ClusterSummary)activeClusters.apply((Object)BoxesRunTime.boxToLong((long)BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$ROOT_INDEX()));
        long n = rootSummary.size();
        this.logInfo((Function0<String>)new Serializable(this, n){
            public static final long serialVersionUID = 0L;
            private final long n$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Number of points: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.n$1)}));
            }
            {
                this.n$1 = n$1;
            }
        });
        this.logInfo((Function0<String>)new Serializable(this, rootSummary){
            public static final long serialVersionUID = 0L;
            private final ClusterSummary rootSummary$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initial cost: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.rootSummary$1.cost())}));
            }
            {
                this.rootSummary$1 = rootSummary$1;
            }
        });
        long minSize = this.minDivisibleClusterSize() >= 1.0 ? (long)scala.math.package$.MODULE$.ceil(this.minDivisibleClusterSize()) : (long)scala.math.package$.MODULE$.ceil(this.minDivisibleClusterSize() * (double)n);
        this.logInfo((Function0<String>)new Serializable(this, minSize){
            public static final long serialVersionUID = 0L;
            private final long minSize$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The minimum number of points of a divisible cluster is ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.minSize$1)}));
            }
            {
                this.minSize$1 = minSize$1;
            }
        });
        scala.collection.mutable.Seq inactiveClusters = (scala.collection.mutable.Seq)Seq$.MODULE$.empty();
        Random random = new Random(this.seed());
        int numLeafClustersNeeded = this.k() - 1;
        IntRef level = new IntRef(1);
        while (activeClusters.nonEmpty() && numLeafClustersNeeded > 0 && (double)level.elem < BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$LEVEL_LIMIT()) {
            Map divisibleClusters = (Map)activeClusters.filter((Function1)new Serializable(this, minSize){
                public static final long serialVersionUID = 0L;
                private final long minSize$1;

                public final boolean apply(Tuple2<Object, ClusterSummary> x0$2) {
                    Tuple2<Object, ClusterSummary> tuple2 = x0$2;
                    if (tuple2 != null) {
                        ClusterSummary summary = (ClusterSummary)tuple2._2();
                        boolean bl = summary.size() >= this.minSize$1 && summary.cost() > MLUtils$.MODULE$.EPSILON() * (double)summary.size();
                        return bl;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.minSize$1 = minSize$1;
                }
            });
            if (divisibleClusters.size() > numLeafClustersNeeded) {
                divisibleClusters = ((TraversableOnce)((IterableLike)divisibleClusters.toSeq().sortBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(Tuple2<Object, ClusterSummary> x0$3) {
                        Tuple2<Object, ClusterSummary> tuple2 = x0$3;
                        if (tuple2 != null) {
                            ClusterSummary summary = (ClusterSummary)tuple2._2();
                            long l = -summary.size();
                            return l;
                        }
                        throw new MatchError(tuple2);
                    }
                }, (Ordering)Ordering.Long$.MODULE$)).take(numLeafClustersNeeded)).toMap(Predef$.MODULE$.conforms());
            }
            if (divisibleClusters.nonEmpty()) {
                Set divisibleIndices = divisibleClusters.keys().toSet();
                this.logInfo((Function0<String>)new Serializable(this, level, divisibleIndices){
                    public static final long serialVersionUID = 0L;
                    private final IntRef level$1;
                    private final Set divisibleIndices$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dividing ", " clusters on level ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.divisibleIndices$1.size()), BoxesRunTime.boxToInteger((int)this.level$1.elem)}));
                    }
                    {
                        this.level$1 = level$1;
                        this.divisibleIndices$1 = divisibleIndices$1;
                    }
                });
                ObjectRef newClusterCenters = new ObjectRef((Object)((Map)((TraversableLike)divisibleClusters.flatMap((Function1)new Serializable(this, random){
                    public static final long serialVersionUID = 0L;
                    private final Random random$1;

                    public final Iterator<Tuple2<Object, VectorWithNorm>> apply(Tuple2<Object, ClusterSummary> x0$4) {
                        Tuple2<Object, ClusterSummary> tuple2 = x0$4;
                        if (tuple2 != null) {
                            long index2 = tuple2._1$mcJ$sp();
                            ClusterSummary summary = (ClusterSummary)tuple2._2();
                            Tuple2<VectorWithNorm, VectorWithNorm> tuple22 = BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$splitCenter(summary.center(), this.random$1);
                            if (tuple22 != null) {
                                Tuple2 tuple23;
                                VectorWithNorm left = (VectorWithNorm)tuple22._1();
                                VectorWithNorm right = (VectorWithNorm)tuple22._2();
                                Tuple2 tuple24 = tuple23 = new Tuple2((Object)left, (Object)right);
                                VectorWithNorm left2 = (VectorWithNorm)tuple24._1();
                                VectorWithNorm right2 = (VectorWithNorm)tuple24._2();
                                Iterator iterator = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$leftChildIndex(index2)), (Object)left2), new Tuple2((Object)BoxesRunTime.boxToLong((long)BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$rightChildIndex(index2)), (Object)right2)}));
                                return iterator;
                            }
                            throw new MatchError(tuple22);
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.random$1 = random$1;
                    }
                }, Map$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, VectorWithNorm> apply(Tuple2<Object, VectorWithNorm> x) {
                        return (Tuple2)Predef$.MODULE$.identity(x);
                    }
                }, Map$.MODULE$.canBuildFrom())));
                ObjectRef newClusters = new ObjectRef(null);
                ObjectRef newAssignments = new ObjectRef(null);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.maxIterations()).foreach$mVc$sp((Function1)new Serializable(this, d, assignments, divisibleIndices, newClusterCenters, newClusters, newAssignments){
                    public static final long serialVersionUID = 0L;
                    private final int d$1;
                    private final ObjectRef assignments$1;
                    public final Set divisibleIndices$1;
                    private final ObjectRef newClusterCenters$1;
                    private final ObjectRef newClusters$1;
                    private final ObjectRef newAssignments$1;

                    public final void apply(int iter) {
                        this.apply$mcVI$sp(iter);
                    }

                    public void apply$mcVI$sp(int iter) {
                        this.newAssignments$1.elem = BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$updateAssignments((RDD<Tuple2<Object, VectorWithNorm>>)((RDD)this.assignments$1.elem), (Set<Object>)this.divisibleIndices$1, (Map<Object, VectorWithNorm>)((Map)this.newClusterCenters$1.elem)).filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$run$1 $outer;

                            public final boolean apply(Tuple2<Object, VectorWithNorm> x0$5) {
                                Tuple2<Object, VectorWithNorm> tuple2 = x0$5;
                                if (tuple2 != null) {
                                    long index2 = tuple2._1$mcJ$sp();
                                    boolean bl = this.$outer.divisibleIndices$1.contains((Object)BoxesRunTime.boxToLong((long)BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$parentIndex(index2)));
                                    return bl;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                        this.newClusters$1.elem = BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$summarize(this.d$1, (RDD<Tuple2<Object, VectorWithNorm>>)((RDD)this.newAssignments$1.elem));
                        this.newClusterCenters$1.elem = (Map)((Map)this.newClusters$1.elem).mapValues((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final VectorWithNorm apply(ClusterSummary x$3) {
                                return x$3.center();
                            }
                        }).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<Object, VectorWithNorm> apply(Tuple2<Object, VectorWithNorm> x) {
                                return (Tuple2)Predef$.MODULE$.identity(x);
                            }
                        }, Map$.MODULE$.canBuildFrom());
                    }
                    {
                        this.d$1 = d$1;
                        this.assignments$1 = assignments$1;
                        this.divisibleIndices$1 = divisibleIndices$1;
                        this.newClusterCenters$1 = newClusterCenters$1;
                        this.newClusters$1 = newClusters$1;
                        this.newAssignments$1 = newAssignments$1;
                    }
                });
                RDD indices = RDD$.MODULE$.rddToPairRDDFunctions(BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$updateAssignments((RDD<Tuple2<Object, VectorWithNorm>>)((RDD)assignments.elem), (Set<Object>)divisibleIndices, (Map<Object, VectorWithNorm>)((Map)newClusterCenters.elem)), ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(VectorWithNorm.class), (Ordering)Ordering.Long$.MODULE$).keys().persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
                assignments.elem = indices.zip(vectors, ClassTag$.MODULE$.apply(VectorWithNorm.class));
                inactiveClusters = (scala.collection.mutable.Seq)inactiveClusters.$plus$plus((GenTraversableOnce)activeClusters, Seq$.MODULE$.canBuildFrom());
                activeClusters = (Map)newClusters.elem;
                numLeafClustersNeeded -= divisibleClusters.size();
            } else {
                this.logInfo((Function0<String>)new Serializable(this, level){
                    public static final long serialVersionUID = 0L;
                    private final IntRef level$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"None active and divisible clusters left on level ", ". Stop iterations."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.level$1.elem)}));
                    }
                    {
                        this.level$1 = level$1;
                    }
                });
                inactiveClusters = (scala.collection.mutable.Seq)inactiveClusters.$plus$plus(activeClusters, Seq$.MODULE$.canBuildFrom());
                activeClusters = Predef$.MODULE$.Map().empty();
            }
            ++level.elem;
        }
        Map clusters = activeClusters.$plus$plus((GenTraversableOnce)inactiveClusters);
        ClusteringTreeNode root = BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$buildTree((Map<Object, ClusterSummary>)clusters);
        return new BisectingKMeansModel(root);
    }

    public BisectingKMeansModel run(JavaRDD<Vector> data) {
        return this.run((RDD<Vector>)data.rdd());
    }

    private BisectingKMeans(int k, int maxIterations, double minDivisibleClusterSize, long seed) {
        this.k = k;
        this.maxIterations = maxIterations;
        this.minDivisibleClusterSize = minDivisibleClusterSize;
        this.seed = seed;
        Logging.class.$init$((Logging)this);
    }

    public BisectingKMeans() {
        this(4, 20, 1.0, ScalaRunTime$.MODULE$.hash((Object)BisectingKMeans.class.getName()));
    }

    public static class ClusterSummary
    implements Product,
    Serializable {
        private final long size;
        private final VectorWithNorm center;
        private final double cost;

        public long size() {
            return this.size;
        }

        public VectorWithNorm center() {
            return this.center;
        }

        public double cost() {
            return this.cost;
        }

        public ClusterSummary copy(long size, VectorWithNorm center, double cost) {
            return new ClusterSummary(size, center, cost);
        }

        public long copy$default$1() {
            return this.size();
        }

        public VectorWithNorm copy$default$2() {
            return this.center();
        }

        public double copy$default$3() {
            return this.cost();
        }

        public String productPrefix() {
            return "ClusterSummary";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 2: {
                    object = BoxesRunTime.boxToDouble((double)this.cost());
                    break;
                }
                case 1: {
                    object = this.center();
                    break;
                }
                case 0: {
                    object = BoxesRunTime.boxToLong((long)this.size());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ClusterSummary;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.size()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.center()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.cost()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ClusterSummary)) return false;
            boolean bl = true;
            if (!bl) return false;
            ClusterSummary clusterSummary = (ClusterSummary)x$1;
            if (this.size() != clusterSummary.size()) return false;
            VectorWithNorm vectorWithNorm = this.center();
            VectorWithNorm vectorWithNorm2 = clusterSummary.center();
            if (vectorWithNorm == null) {
                if (vectorWithNorm2 != null) {
                    return false;
                }
            } else if (!vectorWithNorm.equals(vectorWithNorm2)) return false;
            if (this.cost() != clusterSummary.cost()) return false;
            if (!clusterSummary.canEqual(this)) return false;
            return true;
        }

        public ClusterSummary(long size, VectorWithNorm center, double cost) {
            this.size = size;
            this.center = center;
            this.cost = cost;
            Product.class.$init$((Product)this);
        }
    }

    public static class ClusterSummaryAggregator
    implements Serializable {
        private final int d;
        private long n;
        private final Vector sum;
        private double sumSq;

        public int d() {
            return this.d;
        }

        private long n() {
            return this.n;
        }

        private void n_$eq(long x$1) {
            this.n = x$1;
        }

        private Vector sum() {
            return this.sum;
        }

        private double sumSq() {
            return this.sumSq;
        }

        private void sumSq_$eq(double x$1) {
            this.sumSq = x$1;
        }

        public ClusterSummaryAggregator add(VectorWithNorm v) {
            this.n_$eq(this.n() + 1L);
            this.sumSq_$eq(this.sumSq() + v.norm() * v.norm());
            BLAS$.MODULE$.axpy(1.0, v.vector(), this.sum());
            return this;
        }

        public ClusterSummaryAggregator merge(ClusterSummaryAggregator other) {
            this.n_$eq(this.n() + other.n());
            this.sumSq_$eq(this.sumSq() + other.sumSq());
            BLAS$.MODULE$.axpy(1.0, other.sum(), this.sum());
            return this;
        }

        public ClusterSummary summary() {
            Vector mean2 = this.sum().copy();
            if (this.n() > 0L) {
                BLAS$.MODULE$.scal(1.0 / (double)this.n(), mean2);
            }
            VectorWithNorm center = new VectorWithNorm(mean2);
            double cost = scala.math.package$.MODULE$.max(this.sumSq() - (double)this.n() * center.norm() * center.norm(), 0.0);
            return new ClusterSummary(this.n(), center, cost);
        }

        public ClusterSummaryAggregator(int d) {
            this.d = d;
            this.n = 0L;
            this.sum = Vectors$.MODULE$.zeros(d);
            this.sumSq = 0.0;
        }
    }
}

