/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleArrayParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasFeaturesCol$class;
import org.apache.spark.ml.param.shared.HasFitIntercept$class;
import org.apache.spark.ml.param.shared.HasLabelCol$class;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasPredictionCol$class;
import org.apache.spark.ml.param.shared.HasTol$class;
import org.apache.spark.ml.regression.AFTSurvivalRegressionModel$;
import org.apache.spark.ml.regression.AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$;
import org.apache.spark.ml.regression.AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$;
import org.apache.spark.ml.regression.AFTSurvivalRegressionParams;
import org.apache.spark.ml.regression.AFTSurvivalRegressionParams$class;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWritable$class;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\t=h\u0001B\u0001\u0003\u00015\u0011!$\u0011$U'V\u0014h/\u001b<bYJ+wM]3tg&|g.T8eK2T!a\u0001\u0003\u0002\u0015I,wM]3tg&|gN\u0003\u0002\u0006\r\u0005\u0011Q\u000e\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u000f)]\u00012a\u0004\t\u0013\u001b\u0005!\u0011BA\t\u0005\u0005\u0015iu\u000eZ3m!\t\u0019\u0002!D\u0001\u0003!\t\u0019R#\u0003\u0002\u0017\u0005\tY\u0012I\u0012+TkJ4\u0018N^1m%\u0016<'/Z:tS>t\u0007+\u0019:b[N\u0004\"\u0001G\u000e\u000e\u0003eQ!A\u0007\u0003\u0002\tU$\u0018\u000e\\\u0005\u00039e\u0011!\"\u0014'Xe&$\u0018M\u00197f\u0011!q\u0002A!b\u0001\n\u0003z\u0012aA;jIV\t\u0001\u0005\u0005\u0002\"O9\u0011!%J\u0007\u0002G)\tA%A\u0003tG\u0006d\u0017-\u0003\u0002'G\u00051\u0001K]3eK\u001aL!\u0001K\u0015\u0003\rM#(/\u001b8h\u0015\t13\u0005K\u0002\u001eWE\u0002\"\u0001L\u0018\u000e\u00035R!A\f\u0004\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u00021[\t)1+\u001b8dK\u0006\n!'A\u00032]Yr\u0003\u0007\u0003\u00055\u0001\t\u0005\t\u0015!\u0003!\u0003\u0011)\u0018\u000e\u001a\u0011)\u0007MZ\u0013\u0007\u0003\u00058\u0001\t\u0015\r\u0011\"\u00019\u00031\u0019w.\u001a4gS\u000eLWM\u001c;t+\u0005I\u0004C\u0001\u001e@\u001b\u0005Y$B\u0001\u001f>\u0003\u0019a\u0017N\\1mO*\u0011aHB\u0001\u0006[2d\u0017NY\u0005\u0003\u0001n\u0012aAV3di>\u0014\bf\u0001\u001c,c!A1\t\u0001B\u0001B\u0003%\u0011(A\u0007d_\u00164g-[2jK:$8\u000f\t\u0015\u0004\u0005.\n\u0004\u0002\u0003$\u0001\u0005\u000b\u0007I\u0011A$\u0002\u0013%tG/\u001a:dKB$X#\u0001%\u0011\u0005\tJ\u0015B\u0001&$\u0005\u0019!u.\u001e2mK\"\u001aQiK\u0019\t\u00115\u0003!\u0011!Q\u0001\n!\u000b!\"\u001b8uKJ\u001cW\r\u001d;!Q\ra5&\r\u0005\t!\u0002\u0011)\u0019!C\u0001\u000f\u0006)1oY1mK\"\u001aqjK\u0019\t\u0011M\u0003!\u0011!Q\u0001\n!\u000baa]2bY\u0016\u0004\u0003f\u0001*,c!1a\u000b\u0001C\u0001\t]\u000ba\u0001P5oSRtD#\u0002\nY5rs\u0006\"\u0002\u0010V\u0001\u0004\u0001\u0003f\u0001-,c!)q'\u0016a\u0001s!\u001a!lK\u0019\t\u000b\u0019+\u0006\u0019\u0001%)\u0007q[\u0013\u0007C\u0003Q+\u0002\u0007\u0001\nK\u0002_WEBQ!\u0019\u0001\u0005\u0002\t\fab]3u\r\u0016\fG/\u001e:fg\u000e{G\u000e\u0006\u0002dI6\t\u0001\u0001C\u0003fA\u0002\u0007\u0001%A\u0003wC2,X\rK\u0002aWEBQ\u0001\u001b\u0001\u0005\u0002%\f\u0001c]3u!J,G-[2uS>t7i\u001c7\u0015\u0005\rT\u0007\"B3h\u0001\u0004\u0001\u0003fA4,c!)Q\u000e\u0001C\u0001]\u0006A2/\u001a;Rk\u0006tG/\u001b7f!J|'-\u00192jY&$\u0018.Z:\u0015\u0005\r|\u0007\"B3m\u0001\u0004\u0001\bc\u0001\u0012r\u0011&\u0011!o\t\u0002\u0006\u0003J\u0014\u0018-\u001f\u0015\u0004Y.\n\u0004\"B;\u0001\t\u00031\u0018aD:fiF+\u0018M\u001c;jY\u0016\u001c8i\u001c7\u0015\u0005\r<\b\"B3u\u0001\u0004\u0001\u0003f\u0001;,c!)!\u0010\u0001C\u0001w\u0006\u0001\u0002O]3eS\u000e$\u0018+^1oi&dWm\u001d\u000b\u0003sqDQ!`=A\u0002e\n\u0001BZ3biV\u0014Xm\u001d\u0015\u0004s.\n\u0004bBA\u0001\u0001\u0011\u0005\u00111A\u0001\baJ,G-[2u)\rA\u0015Q\u0001\u0005\u0006{~\u0004\r!\u000f\u0015\u0004\u007f.\n\u0004bBA\u0006\u0001\u0011\u0005\u0013QB\u0001\niJ\fgn\u001d4pe6$B!a\u0004\u0002\u001cA!\u0011\u0011CA\f\u001b\t\t\u0019BC\u0002\u0002\u0016\u0019\t1a]9m\u0013\u0011\tI\"a\u0005\u0003\u0013\u0011\u000bG/\u0019$sC6,\u0007\u0002CA\u000f\u0003\u0013\u0001\r!a\u0004\u0002\u000f\u0011\fG/Y:fi\"\"\u0011\u0011B\u00162\u0011\u001d\t\u0019\u0003\u0001C!\u0003K\tq\u0002\u001e:b]N4wN]7TG\",W.\u0019\u000b\u0005\u0003O\t\u0019\u0004\u0005\u0003\u0002*\u0005=RBAA\u0016\u0015\u0011\ti#a\u0005\u0002\u000bQL\b/Z:\n\t\u0005E\u00121\u0006\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007\u0002CA\u001b\u0003C\u0001\r!a\n\u0002\rM\u001c\u0007.Z7bQ\u0011\t\tcK\u0019\t\u000f\u0005m\u0002\u0001\"\u0011\u0002>\u0005!1m\u001c9z)\r\u0011\u0012q\b\u0005\t\u0003\u0003\nI\u00041\u0001\u0002D\u0005)Q\r\u001f;sCB!\u0011QIA&\u001b\t\t9EC\u0002\u0002J\u0011\tQ\u0001]1sC6LA!!\u0014\u0002H\tA\u0001+\u0019:b[6\u000b\u0007\u000f\u000b\u0003\u0002:-\n\u0004bBA*\u0001\u0011\u0005\u0013QK\u0001\u0006oJLG/Z\u000b\u0003\u0003/\u00022\u0001GA-\u0013\r\tY&\u0007\u0002\t\u001b2;&/\u001b;fe\"\"\u0011\u0011K\u00162Q\r\u00011&\r\u0015\u0004\u0001\u0005\r\u0004c\u0001\u0017\u0002f%\u0019\u0011qM\u0017\u0003\u0019\u0015C\b/\u001a:j[\u0016tG/\u00197\b\u000f\u0005-$\u0001#\u0001\u0002n\u0005Q\u0012I\u0012+TkJ4\u0018N^1m%\u0016<'/Z:tS>tWj\u001c3fYB\u00191#a\u001c\u0007\r\u0005\u0011\u0001\u0012AA9'!\ty'a\u001d\u0002z\u0005}\u0004c\u0001\u0012\u0002v%\u0019\u0011qO\u0012\u0003\r\u0005s\u0017PU3g!\u0011A\u00121\u0010\n\n\u0007\u0005u\u0014D\u0001\u0006N\u0019J+\u0017\rZ1cY\u0016\u00042AIAA\u0013\r\t\u0019i\t\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\b-\u0006=D\u0011AAD)\t\ti\u0007\u0003\u0005\u0002\f\u0006=D\u0011IAG\u0003\u0011\u0011X-\u00193\u0016\u0005\u0005=\u0005\u0003\u0002\r\u0002\u0012JI1!a%\u001a\u0005!iEJU3bI\u0016\u0014\b\u0006BAEWEB\u0001\"!'\u0002p\u0011\u0005\u00131T\u0001\u0005Y>\fG\rF\u0002\u0013\u0003;Cq!a(\u0002\u0018\u0002\u0007\u0001%\u0001\u0003qCRD\u0007\u0006BALWE2\u0011\"!*\u0002p\u0001\ty'a*\u0003A\u00053EkU;sm&4\u0018\r\u001c*fOJ,7o]5p]6{G-\u001a7Xe&$XM]\n\u0007\u0003G\u000b9&!+\u0011\t\u0005-\u0016QV\u0007\u0002\r%\u0019\u0011q\u0016\u0004\u0003\u000f1{wmZ5oO\"Q\u00111WAR\u0005\u0003\u0005\u000b\u0011\u0002\n\u0002\u0011%t7\u000f^1oG\u0016DqAVAR\t\u0003\t9\f\u0006\u0003\u0002:\u0006u\u0006\u0003BA^\u0003Gk!!a\u001c\t\u000f\u0005M\u0016Q\u0017a\u0001%\u00199\u0011\u0011YAR\t\u0006\r'\u0001\u0002#bi\u0006\u001c\u0002\"a0\u0002t\u0005\u0015\u0017q\u0010\t\u0004E\u0005\u001d\u0017bAAeG\t9\u0001K]8ek\u000e$\b\"C\u001c\u0002@\nU\r\u0011\"\u00019\u0011%\u0019\u0015q\u0018B\tB\u0003%\u0011\bC\u0005G\u0003\u007f\u0013)\u001a!C\u0001\u000f\"IQ*a0\u0003\u0012\u0003\u0006I\u0001\u0013\u0005\n!\u0006}&Q3A\u0005\u0002\u001dC\u0011bUA`\u0005#\u0005\u000b\u0011\u0002%\t\u000fY\u000by\f\"\u0001\u0002ZRA\u00111\\Ap\u0003C\f\u0019\u000f\u0005\u0003\u0002^\u0006}VBAAR\u0011\u00199\u0014q\u001ba\u0001s!1a)a6A\u0002!Ca\u0001UAl\u0001\u0004A\u0005BCA\u001e\u0003\u007f\u000b\t\u0011\"\u0001\u0002hRA\u00111\\Au\u0003W\fi\u000f\u0003\u00058\u0003K\u0004\n\u00111\u0001:\u0011!1\u0015Q\u001dI\u0001\u0002\u0004A\u0005\u0002\u0003)\u0002fB\u0005\t\u0019\u0001%\t\u0015\u0005E\u0018qXI\u0001\n\u0003\t\u00190\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005U(fA\u001d\u0002x.\u0012\u0011\u0011 \t\u0005\u0003w\u0014\u0019!\u0004\u0002\u0002~*!\u0011q B\u0001\u0003%)hn\u00195fG.,GM\u0003\u0002/G%!!QAA\u007f\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\u000b\u0005\u0013\ty,%A\u0005\u0002\t-\u0011AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0005\u001bQ3\u0001SA|\u0011)\u0011\t\"a0\u0012\u0002\u0013\u0005!1B\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0011)\u0011)\"a0\u0002\u0002\u0013\u0005#qC\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\te\u0001\u0003\u0002B\u000e\u0005Ki!A!\b\u000b\t\t}!\u0011E\u0001\u0005Y\u0006twM\u0003\u0002\u0003$\u0005!!.\u0019<b\u0013\rA#Q\u0004\u0005\u000b\u0005S\ty,!A\u0005\u0002\t-\u0012\u0001\u00049s_\u0012,8\r^!sSRLXC\u0001B\u0017!\r\u0011#qF\u0005\u0004\u0005c\u0019#aA%oi\"Q!QGA`\u0003\u0003%\tAa\u000e\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!\u0011\bB !\r\u0011#1H\u0005\u0004\u0005{\u0019#aA!os\"Q!\u0011\tB\u001a\u0003\u0003\u0005\rA!\f\u0002\u0007a$\u0013\u0007\u0003\u0006\u0003F\u0005}\u0016\u0011!C!\u0005\u000f\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005\u0013\u0002bAa\u0013\u0003R\teRB\u0001B'\u0015\r\u0011yeI\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B*\u0005\u001b\u0012\u0001\"\u0013;fe\u0006$xN\u001d\u0005\u000b\u0005/\ny,!A\u0005\u0002\te\u0013\u0001C2b]\u0016\u000bX/\u00197\u0015\t\tm#\u0011\r\t\u0004E\tu\u0013b\u0001B0G\t9!i\\8mK\u0006t\u0007B\u0003B!\u0005+\n\t\u00111\u0001\u0003:!Q!QMA`\u0003\u0003%\tEa\u001a\u0002\u0011!\f7\u000f[\"pI\u0016$\"A!\f\t\u0015\t-\u0014qXA\u0001\n\u0003\u0012i'\u0001\u0005u_N#(/\u001b8h)\t\u0011I\u0002\u0003\u0006\u0003r\u0005}\u0016\u0011!C!\u0005g\na!Z9vC2\u001cH\u0003\u0002B.\u0005kB!B!\u0011\u0003p\u0005\u0005\t\u0019\u0001B\u001d\u000f)\u0011I(a)\u0002\u0002#%!1P\u0001\u0005\t\u0006$\u0018\r\u0005\u0003\u0002^\nudACAa\u0003G\u000b\t\u0011#\u0003\u0003\u0000M1!Q\u0010BA\u0003\u007f\u0002\u0012Ba!\u0003\nfB\u0005*a7\u000e\u0005\t\u0015%b\u0001BDG\u00059!/\u001e8uS6,\u0017\u0002\u0002BF\u0005\u000b\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84\u0011\u001d1&Q\u0010C\u0001\u0005\u001f#\"Aa\u001f\t\u0015\t-$QPA\u0001\n\u000b\u0012i\u0007\u0003\u0006\u0003\u0016\nu\u0014\u0011!CA\u0005/\u000bQ!\u00199qYf$\u0002\"a7\u0003\u001a\nm%Q\u0014\u0005\u0007o\tM\u0005\u0019A\u001d\t\r\u0019\u0013\u0019\n1\u0001I\u0011\u0019\u0001&1\u0013a\u0001\u0011\"Q!\u0011\u0015B?\u0003\u0003%\tIa)\u0002\u000fUt\u0017\r\u001d9msR!!Q\u0015BY!\u0015\u0011#q\u0015BV\u0013\r\u0011Ik\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\r\t\u0012i+\u000f%I\u0013\r\u0011yk\t\u0002\u0007)V\u0004H.Z\u001a\t\u0015\tM&qTA\u0001\u0002\u0004\tY.A\u0002yIAB!Ba.\u0003~\u0005\u0005I\u0011\u0002B]\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\tm\u0006\u0003\u0002B\u000e\u0005{KAAa0\u0003\u001e\t1qJ\u00196fGRD\u0001Ba1\u0002$\u0012E#QY\u0001\tg\u00064X-S7qYR!!q\u0019Bg!\r\u0011#\u0011Z\u0005\u0004\u0005\u0017\u001c#\u0001B+oSRDq!a(\u0003B\u0002\u0007\u0001EB\u0004\u0003R\u0006=DAa5\u0003A\u00053EkU;sm&4\u0018\r\u001c*fOJ,7o]5p]6{G-\u001a7SK\u0006$WM]\n\u0005\u0005\u001f\fy\tC\u0004W\u0005\u001f$\tAa6\u0015\u0005\te\u0007\u0003BA^\u0005\u001fD!B!8\u0003P\n\u0007I\u0011\u0002B\f\u0003%\u0019G.Y:t\u001d\u0006lW\rC\u0005\u0003b\n=\u0007\u0015!\u0003\u0003\u001a\u0005Q1\r\\1tg:\u000bW.\u001a\u0011\t\u0011\u0005e%q\u001aC!\u0005K$2A\u0005Bt\u0011\u001d\tyJa9A\u0002\u0001B!Ba.\u0002p\u0005\u0005I\u0011\u0002B]Q\u0011\tygK\u0019)\t\u0005%4&\r")
public class AFTSurvivalRegressionModel
extends Model<AFTSurvivalRegressionModel>
implements AFTSurvivalRegressionParams,
MLWritable {
    private final String uid;
    private final Vector coefficients;
    private final double intercept;
    private final double scale;
    private final Param<String> censorCol;
    private final DoubleArrayParam quantileProbabilities;
    private final Param<String> quantilesCol;
    private final BooleanParam fitIntercept;
    private final DoubleParam tol;
    private final IntParam maxIter;
    private final Param<String> predictionCol;
    private final Param<String> labelCol;
    private final Param<String> featuresCol;

    public static AFTSurvivalRegressionModel load(String string) {
        return AFTSurvivalRegressionModel$.MODULE$.load(string);
    }

    public static MLReader<AFTSurvivalRegressionModel> read() {
        return AFTSurvivalRegressionModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable$class.save(this, path);
    }

    @Override
    public final Param<String> censorCol() {
        return this.censorCol;
    }

    @Override
    public final DoubleArrayParam quantileProbabilities() {
        return this.quantileProbabilities;
    }

    @Override
    public final Param<String> quantilesCol() {
        return this.quantilesCol;
    }

    @Override
    public final void org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$censorCol_$eq(Param x$1) {
        this.censorCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$quantileProbabilities_$eq(DoubleArrayParam x$1) {
        this.quantileProbabilities = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$quantilesCol_$eq(Param x$1) {
        this.quantilesCol = x$1;
    }

    @Override
    public String getCensorCol() {
        return AFTSurvivalRegressionParams$class.getCensorCol(this);
    }

    @Override
    public double[] getQuantileProbabilities() {
        return AFTSurvivalRegressionParams$class.getQuantileProbabilities(this);
    }

    @Override
    public String getQuantilesCol() {
        return AFTSurvivalRegressionParams$class.getQuantilesCol(this);
    }

    @Override
    public boolean hasQuantilesCol() {
        return AFTSurvivalRegressionParams$class.hasQuantilesCol(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting) {
        return AFTSurvivalRegressionParams$class.validateAndTransformSchema(this, schema, fitting);
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept$class.getFitIntercept(this);
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final double getTol() {
        return HasTol$class.getTol(this);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol$class.getPredictionCol(this);
    }

    @Override
    public final Param<String> labelCol() {
        return this.labelCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasLabelCol$_setter_$labelCol_$eq(Param x$1) {
        this.labelCol = x$1;
    }

    @Override
    public final String getLabelCol() {
        return HasLabelCol$class.getLabelCol(this);
    }

    @Override
    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public final String getFeaturesCol() {
        return HasFeaturesCol$class.getFeaturesCol(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Vector coefficients() {
        return this.coefficients;
    }

    public double intercept() {
        return this.intercept;
    }

    public double scale() {
        return this.scale;
    }

    public AFTSurvivalRegressionModel setFeaturesCol(String value) {
        return (AFTSurvivalRegressionModel)this.set(this.featuresCol(), value);
    }

    public AFTSurvivalRegressionModel setPredictionCol(String value) {
        return (AFTSurvivalRegressionModel)this.set(this.predictionCol(), value);
    }

    public AFTSurvivalRegressionModel setQuantileProbabilities(double[] value) {
        return (AFTSurvivalRegressionModel)this.set(this.quantileProbabilities(), value);
    }

    public AFTSurvivalRegressionModel setQuantilesCol(String value) {
        return (AFTSurvivalRegressionModel)this.set(this.quantilesCol(), value);
    }

    public Vector predictQuantiles(Vector features) {
        double lambda = scala.math.package$.MODULE$.exp(BLAS$.MODULE$.dot(this.coefficients(), features) + this.intercept());
        double k = 1.0 / this.scale();
        double[] quantiles = (double[])Predef$.MODULE$.doubleArrayOps(this.$(this.quantileProbabilities())).map((Function1)new Serializable(this, lambda, k){
            public static final long serialVersionUID = 0L;
            private final double lambda$1;
            private final double k$1;

            public final double apply(double q) {
                return this.apply$mcDD$sp(q);
            }

            public double apply$mcDD$sp(double q) {
                return this.lambda$1 * scala.math.package$.MODULE$.exp(scala.math.package$.MODULE$.log(-scala.math.package$.MODULE$.log(1.0 - q)) / this.k$1);
            }
            {
                this.lambda$1 = lambda$1;
                this.k$1 = k$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        return Vectors$.MODULE$.dense(quantiles);
    }

    public double predict(Vector features) {
        return scala.math.package$.MODULE$.exp(BLAS$.MODULE$.dot(this.coefficients(), features) + this.intercept());
    }

    @Override
    public DataFrame transform(DataFrame dataset) {
        this.transformSchema(dataset.schema());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionModel.class.getClassLoader());
        public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.mllib.linalg.Vector")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator1$1(AFTSurvivalRegressionModel $outer) {
            }
        }
        UserDefinedFunction predictUDF = functions$.MODULE$.udf((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AFTSurvivalRegressionModel $outer;

            public final double apply(Vector features) {
                return this.$outer.predict(features);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator1$1(this)));
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionModel.class.getClassLoader());
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionModel.class.getClassLoader());
        public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.mllib.linalg.Vector")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator2$1(AFTSurvivalRegressionModel $outer) {
            }
        }
        public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.mllib.linalg.Vector")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator3$1(AFTSurvivalRegressionModel $outer) {
            }
        }
        UserDefinedFunction predictQuantilesUDF = functions$.MODULE$.udf((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AFTSurvivalRegressionModel $outer;

            public final Vector apply(Vector features) {
                return this.$outer.predictQuantiles(features);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator2$1(this)), ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator3$1(this)));
        return this.hasQuantilesCol() ? dataset.withColumn(this.$(this.predictionCol()), predictUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))}))).withColumn(this.$(this.quantilesCol()), predictQuantilesUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))}))) : dataset.withColumn(this.$(this.predictionCol()), predictUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})));
    }

    @Override
    public StructType transformSchema(StructType schema) {
        return this.validateAndTransformSchema(schema, false);
    }

    @Override
    public AFTSurvivalRegressionModel copy(ParamMap extra) {
        return (AFTSurvivalRegressionModel)((Model)this.copyValues(new AFTSurvivalRegressionModel(this.uid(), this.coefficients(), this.intercept(), this.scale()), extra)).setParent(this.parent());
    }

    @Override
    public MLWriter write() {
        return new AFTSurvivalRegressionModelWriter(this);
    }

    public AFTSurvivalRegressionModel(String uid, Vector coefficients, double intercept, double scale) {
        this.uid = uid;
        this.coefficients = coefficients;
        this.intercept = intercept;
        this.scale = scale;
        HasFeaturesCol$class.$init$(this);
        HasLabelCol$class.$init$(this);
        HasPredictionCol$class.$init$(this);
        HasMaxIter$class.$init$(this);
        HasTol$class.$init$(this);
        HasFitIntercept$class.$init$(this);
        AFTSurvivalRegressionParams$class.$init$(this);
        MLWritable$class.$init$(this);
    }

    public static class AFTSurvivalRegressionModelWriter
    extends MLWriter {
        private final AFTSurvivalRegressionModel instance;
        private volatile AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$ Data$module;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$ org$apache$spark$ml$regression$AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$$Data$lzycompute() {
            AFTSurvivalRegressionModelWriter aFTSurvivalRegressionModelWriter = this;
            synchronized (aFTSurvivalRegressionModelWriter) {
                if (this.Data$module != null) return this.Data$module;
                this.Data$module = new AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$(this);
                return this.Data$module;
            }
        }

        public AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$ org$apache$spark$ml$regression$AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$$Data() {
            return this.Data$module == null ? this.org$apache$spark$ml$regression$AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$$Data$lzycompute() : this.Data$module;
        }

        @Override
        public void saveImpl(String path) {
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sc(), DefaultParamsWriter$.MODULE$.saveMetadata$default$4(), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
            Data data = new Data(this, this.instance.coefficients(), this.instance.intercept(), this.instance.scale());
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionModelWriter.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$$typecreator4$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.TypeRef().apply($u.ThisType().apply($m.staticClass("org.apache.spark.ml.regression.AFTSurvivalRegressionModel.AFTSurvivalRegressionModelWriter")), $u.build().selectType($m.staticClass("org.apache.spark.ml.regression.AFTSurvivalRegressionModel.AFTSurvivalRegressionModelWriter"), "Data"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$$typecreator4$1(AFTSurvivalRegressionModelWriter $outer) {
                }
            }
            this.sqlContext().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Data[]{data})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$$typecreator4$1(this))).repartition(1).write().parquet(dataPath);
        }

        public AFTSurvivalRegressionModelWriter(AFTSurvivalRegressionModel instance) {
            this.instance = instance;
        }

        public class Data
        implements Product,
        Serializable {
            private final Vector coefficients;
            private final double intercept;
            private final double scale;
            public final /* synthetic */ AFTSurvivalRegressionModelWriter $outer;

            public Vector coefficients() {
                return this.coefficients;
            }

            public double intercept() {
                return this.intercept;
            }

            public double scale() {
                return this.scale;
            }

            public Data copy(Vector coefficients, double intercept, double scale) {
                return new Data(this.org$apache$spark$ml$regression$AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$$$outer(), coefficients, intercept, scale);
            }

            public Vector copy$default$1() {
                return this.coefficients();
            }

            public double copy$default$2() {
                return this.intercept();
            }

            public double copy$default$3() {
                return this.scale();
            }

            public String productPrefix() {
                return "Data";
            }

            public int productArity() {
                return 3;
            }

            public Object productElement(int x$1) {
                Object object;
                int n = x$1;
                switch (n) {
                    default: {
                        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                    }
                    case 2: {
                        object = BoxesRunTime.boxToDouble((double)this.scale());
                        break;
                    }
                    case 1: {
                        object = BoxesRunTime.boxToDouble((double)this.intercept());
                        break;
                    }
                    case 0: {
                        object = this.coefficients();
                    }
                }
                return object;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Data;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.coefficients()));
                n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.intercept()));
                n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.scale()));
                return Statics.finalizeHash((int)n, (int)3);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Data)) return false;
                boolean bl = true;
                if (!bl) return false;
                Data data = (Data)x$1;
                Vector vector = this.coefficients();
                Vector vector2 = data.coefficients();
                if (vector == null) {
                    if (vector2 != null) {
                        return false;
                    }
                } else if (!((Object)vector).equals(vector2)) return false;
                if (this.intercept() != data.intercept()) return false;
                if (this.scale() != data.scale()) return false;
                if (!data.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ AFTSurvivalRegressionModelWriter org$apache$spark$ml$regression$AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$Data$$$outer() {
                return this.$outer;
            }

            public Data(AFTSurvivalRegressionModelWriter $outer, Vector coefficients, double intercept, double scale) {
                this.coefficients = coefficients;
                this.intercept = intercept;
                this.scale = scale;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                Product.class.$init$((Product)this);
            }
        }
    }

    public static class AFTSurvivalRegressionModelReader
    extends MLReader<AFTSurvivalRegressionModel> {
        private final String className = AFTSurvivalRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public AFTSurvivalRegressionModel load(String path) {
            DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
            String dataPath = new Path(path, "data").toString();
            Row data = this.sqlContext().read().parquet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{dataPath})).select("coefficients", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intercept", "scale"})).head();
            Vector coefficients = (Vector)data.getAs(0);
            double intercept = data.getDouble(1);
            double scale = data.getDouble(2);
            AFTSurvivalRegressionModel model = new AFTSurvivalRegressionModel(metadata.uid(), coefficients, intercept, scale);
            DefaultParamsReader$.MODULE$.getAndSetParams(model, metadata);
            return model;
        }
    }
}

