/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.optimization;

import breeze.linalg.DenseVector;
import breeze.linalg.support.CanCopy;
import breeze.optimize.DiffFunction;
import breeze.optimize.StochasticDiffFunction;
import breeze.util.Isomorphism;
import org.apache.spark.Logging;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.optimization.Gradient;
import org.apache.spark.mllib.optimization.LBFGS$;
import org.apache.spark.mllib.optimization.Optimizer;
import org.apache.spark.mllib.optimization.Updater;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0005Eh\u0001B\u0001\u0003\u00015\u0011Q\u0001\u0014\"G\u000fNS!a\u0001\u0003\u0002\u0019=\u0004H/[7ju\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011!B7mY&\u0014'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0004\u000b\u0019!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011QCF\u0007\u0002\u0005%\u0011qC\u0001\u0002\n\u001fB$\u0018.\\5{KJ\u0004\"!\u0007\u000e\u000e\u0003\u0019I!a\u0007\u0004\u0003\u000f1{wmZ5oO\"AQ\u0004\u0001BA\u0002\u0013%a$\u0001\u0005he\u0006$\u0017.\u001a8u+\u0005y\u0002CA\u000b!\u0013\t\t#A\u0001\u0005He\u0006$\u0017.\u001a8u\u0011!\u0019\u0003A!a\u0001\n\u0013!\u0013\u0001D4sC\u0012LWM\u001c;`I\u0015\fHCA\u0013)!\tya%\u0003\u0002(!\t!QK\\5u\u0011\u001dI#%!AA\u0002}\t1\u0001\u001f\u00132\u0011!Y\u0003A!A!B\u0013y\u0012!C4sC\u0012LWM\u001c;!\u0011!i\u0003A!a\u0001\n\u0013q\u0013aB;qI\u0006$XM]\u000b\u0002_A\u0011Q\u0003M\u0005\u0003c\t\u0011q!\u00169eCR,'\u000f\u0003\u00054\u0001\t\u0005\r\u0011\"\u00035\u0003-)\b\u000fZ1uKJ|F%Z9\u0015\u0005\u0015*\u0004bB\u00153\u0003\u0003\u0005\ra\f\u0005\to\u0001\u0011\t\u0011)Q\u0005_\u0005AQ\u000f\u001d3bi\u0016\u0014\b\u0005C\u0003:\u0001\u0011\u0005!(\u0001\u0004=S:LGO\u0010\u000b\u0004wqj\u0004CA\u000b\u0001\u0011\u0015i\u0002\b1\u0001 \u0011\u0015i\u0003\b1\u00010\u0011\u001dy\u0004\u00011A\u0005\n\u0001\u000baB\\;n\u0007>\u0014(/Z2uS>t7/F\u0001B!\ty!)\u0003\u0002D!\t\u0019\u0011J\u001c;\t\u000f\u0015\u0003\u0001\u0019!C\u0005\r\u0006\u0011b.^7D_J\u0014Xm\u0019;j_:\u001cx\fJ3r)\t)s\tC\u0004*\t\u0006\u0005\t\u0019A!\t\r%\u0003\u0001\u0015)\u0003B\u0003=qW/\\\"peJ,7\r^5p]N\u0004\u0003bB&\u0001\u0001\u0004%I\u0001T\u0001\u000fG>tg/\u001a:hK:\u001cW\rV8m+\u0005i\u0005CA\bO\u0013\ty\u0005C\u0001\u0004E_V\u0014G.\u001a\u0005\b#\u0002\u0001\r\u0011\"\u0003S\u0003I\u0019wN\u001c<fe\u001e,gnY3U_2|F%Z9\u0015\u0005\u0015\u001a\u0006bB\u0015Q\u0003\u0003\u0005\r!\u0014\u0005\u0007+\u0002\u0001\u000b\u0015B'\u0002\u001f\r|gN^3sO\u0016t7-\u001a+pY\u0002Bqa\u0016\u0001A\u0002\u0013%\u0001)\u0001\tnCbtU/\\%uKJ\fG/[8og\"9\u0011\f\u0001a\u0001\n\u0013Q\u0016\u0001F7bq:+X.\u0013;fe\u0006$\u0018n\u001c8t?\u0012*\u0017\u000f\u0006\u0002&7\"9\u0011\u0006WA\u0001\u0002\u0004\t\u0005BB/\u0001A\u0003&\u0011)A\tnCbtU/\\%uKJ\fG/[8og\u0002Bqa\u0018\u0001A\u0002\u0013%A*\u0001\u0005sK\u001e\u0004\u0016M]1n\u0011\u001d\t\u0007\u00011A\u0005\n\t\fAB]3h!\u0006\u0014\u0018-\\0%KF$\"!J2\t\u000f%\u0002\u0017\u0011!a\u0001\u001b\"1Q\r\u0001Q!\n5\u000b\u0011B]3h!\u0006\u0014\u0018-\u001c\u0011\t\u000b\u001d\u0004A\u0011\u00015\u0002#M,GOT;n\u0007>\u0014(/Z2uS>t7\u000f\u0006\u0002jU6\t\u0001\u0001C\u0003lM\u0002\u0007\u0011)A\u0006d_J\u0014Xm\u0019;j_:\u001c\b\"B7\u0001\t\u0003q\u0017!E:fi\u000e{gN^3sO\u0016t7-\u001a+pYR\u0011\u0011n\u001c\u0005\u0006a2\u0004\r!T\u0001\ni>dWM]1oG\u0016DQA\u001d\u0001\u0005\u0002M\f1c]3u\u001b\u0006Dh*^7Ji\u0016\u0014\u0018\r^5p]N$\"!\u001b;\t\u000bU\f\b\u0019A!\u0002\u000b%$XM]:)\tE<(\u0010 \t\u0003\u001faL!!\u001f\t\u0003\u0015\u0011,\u0007O]3dCR,G-I\u0001|\u0003q)8/\u001a\u0011tKRtU/\\%uKJ\fG/[8og\u0002Jgn\u001d;fC\u0012\f\u0013!`\u0001\u0006c9\nd\u0006\r\u0005\u0007\u007f\u0002!\t!!\u0001\u0002!M,GOT;n\u0013R,'/\u0019;j_:\u001cHcA5\u0002\u0004!)QO a\u0001\u0003\"9\u0011q\u0001\u0001\u0005\u0002\u0005%\u0011aC:fiJ+w\rU1sC6$2![A\u0006\u0011\u0019y\u0016Q\u0001a\u0001\u001b\"9\u0011q\u0002\u0001\u0005\u0002\u0005E\u0011aC:fi\u001e\u0013\u0018\rZ5f]R$2![A\n\u0011\u0019i\u0012Q\u0002a\u0001?!9\u0011q\u0003\u0001\u0005\u0002\u0005e\u0011AC:fiV\u0003H-\u0019;feR\u0019\u0011.a\u0007\t\r5\n)\u00021\u00010\u0011\u001d\ty\u0002\u0001C!\u0003C\t\u0001b\u001c9uS6L'0\u001a\u000b\u0007\u0003G\ty#!\u0012\u0011\t\u0005\u0015\u00121F\u0007\u0003\u0003OQ1!!\u000b\u0005\u0003\u0019a\u0017N\\1mO&!\u0011QFA\u0014\u0005\u00191Vm\u0019;pe\"A\u0011\u0011GA\u000f\u0001\u0004\t\u0019$\u0001\u0003eCR\f\u0007CBA\u001b\u0003w\ty$\u0004\u0002\u00028)\u0019\u0011\u0011\b\u0004\u0002\u0007I$G-\u0003\u0003\u0002>\u0005]\"a\u0001*E\tB1q\"!\u0011N\u0003GI1!a\u0011\u0011\u0005\u0019!V\u000f\u001d7fe!A\u0011qIA\u000f\u0001\u0004\t\u0019#\u0001\bj]&$\u0018.\u00197XK&<\u0007\u000e^:)\u0007\u0001\tY\u0005\u0005\u0003\u0002N\u0005MSBAA(\u0015\r\t\tFB\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA+\u0003\u001f\u0012A\u0002R3wK2|\u0007/\u001a:Ba&<q!!\u0017\u0003\u0011\u0003\tY&A\u0003M\u0005\u001a;5\u000bE\u0002\u0016\u0003;2a!\u0001\u0002\t\u0002\u0005}3CBA/\u001da\t\t\u0007E\u0002\u0010\u0003GJ1!!\u001a\u0011\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u001dI\u0014Q\fC\u0001\u0003S\"\"!a\u0017\t\u0011\u00055\u0014Q\fC\u0001\u0003_\n\u0001B];o\u0019\n3ui\u0015\u000b\u0013\u0003c\nI(a\u001f\u0002~\u0005}\u0014\u0011QAB\u0003\u000b\u000b9\tE\u0004\u0010\u0003\u0003\n\u0019#a\u001d\u0011\t=\t)(T\u0005\u0004\u0003o\u0002\"!B!se\u0006L\b\u0002CA\u0019\u0003W\u0002\r!a\r\t\ru\tY\u00071\u0001 \u0011\u0019i\u00131\u000ea\u0001_!1q(a\u001bA\u0002\u0005CaaSA6\u0001\u0004i\u0005BB,\u0002l\u0001\u0007\u0011\t\u0003\u0004`\u0003W\u0002\r!\u0014\u0005\t\u0003\u000f\nY\u00071\u0001\u0002$\u00199\u00111RA/\t\u00055%aB\"pgR4UO\\\n\u0006\u0003\u0013s\u0011q\u0012\t\u0007\u0003#\u000bI*!(\u000e\u0005\u0005M%\u0002BA\u0010\u0003+S!!a&\u0002\r\t\u0014X-\u001a>f\u0013\u0011\tY*a%\u0003\u0019\u0011KgM\u001a$v]\u000e$\u0018n\u001c8\u0011\u000b\u0005}\u00151U'\u000e\u0005\u0005\u0005&\u0002BA\u0015\u0003+KA!!*\u0002\"\nYA)\u001a8tKZ+7\r^8s\u0011-\t\t$!#\u0003\u0002\u0003\u0006I!a\r\t\u0013u\tII!A!\u0002\u0013y\u0002\"C\u0017\u0002\n\n\u0005\t\u0015!\u00030\u0011%y\u0016\u0011\u0012B\u0001B\u0003%Q\nC\u0006\u00022\u0006%%\u0011!Q\u0001\n\u0005M\u0016a\u00038v[\u0016C\u0018-\u001c9mKN\u00042aDA[\u0013\r\t9\f\u0005\u0002\u0005\u0019>tw\rC\u0004:\u0003\u0013#\t!a/\u0015\u0019\u0005u\u0016\u0011YAb\u0003\u000b\f9-!3\u0011\t\u0005}\u0016\u0011R\u0007\u0003\u0003;B\u0001\"!\r\u0002:\u0002\u0007\u00111\u0007\u0005\u0007;\u0005e\u0006\u0019A\u0010\t\r5\nI\f1\u00010\u0011\u0019y\u0016\u0011\u0018a\u0001\u001b\"A\u0011\u0011WA]\u0001\u0004\t\u0019\f\u0003\u0005\u0002N\u0006%E\u0011IAh\u0003%\u0019\u0017\r\\2vY\u0006$X\r\u0006\u0003\u0002R\u0006M\u0007CB\b\u0002B5\u000bi\n\u0003\u0005\u0002V\u0006-\u0007\u0019AAO\u0003\u001d9X-[4iiND!\"!7\u0002^\u0005\u0005I\u0011BAn\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005u\u0007\u0003BAp\u0003Sl!!!9\u000b\t\u0005\r\u0018Q]\u0001\u0005Y\u0006twM\u0003\u0002\u0002h\u0006!!.\u0019<b\u0013\u0011\tY/!9\u0003\r=\u0013'.Z2uQ\u0011\ti&a\u0013)\t\u0005]\u00131\n")
public class LBFGS
implements Optimizer,
Logging {
    private Gradient gradient;
    private Updater updater;
    private int numCorrections;
    private double convergenceTol;
    private int maxNumIterations;
    private double regParam;
    private transient Logger org$apache$spark$Logging$$log_;

    public static Tuple2<Vector, double[]> runLBFGS(RDD<Tuple2<Object, Vector>> rDD, Gradient gradient2, Updater updater, int n, double d, int n2, double d2, Vector vector) {
        return LBFGS$.MODULE$.runLBFGS(rDD, gradient2, updater, n, d, n2, d2, vector);
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    private Gradient gradient() {
        return this.gradient;
    }

    private void gradient_$eq(Gradient x$1) {
        this.gradient = x$1;
    }

    private Updater updater() {
        return this.updater;
    }

    private void updater_$eq(Updater x$1) {
        this.updater = x$1;
    }

    private int numCorrections() {
        return this.numCorrections;
    }

    private void numCorrections_$eq(int x$1) {
        this.numCorrections = x$1;
    }

    private double convergenceTol() {
        return this.convergenceTol;
    }

    private void convergenceTol_$eq(double x$1) {
        this.convergenceTol = x$1;
    }

    private int maxNumIterations() {
        return this.maxNumIterations;
    }

    private void maxNumIterations_$eq(int x$1) {
        this.maxNumIterations = x$1;
    }

    private double regParam() {
        return this.regParam;
    }

    private void regParam_$eq(double x$1) {
        this.regParam = x$1;
    }

    public LBFGS setNumCorrections(int corrections) {
        Predef$.MODULE$.assert(corrections > 0);
        this.numCorrections_$eq(corrections);
        return this;
    }

    public LBFGS setConvergenceTol(double tolerance) {
        this.convergenceTol_$eq(tolerance);
        return this;
    }

    public LBFGS setMaxNumIterations(int iters) {
        return this.setNumIterations(iters);
    }

    public LBFGS setNumIterations(int iters) {
        this.maxNumIterations_$eq(iters);
        return this;
    }

    public LBFGS setRegParam(double regParam) {
        this.regParam_$eq(regParam);
        return this;
    }

    public LBFGS setGradient(Gradient gradient2) {
        this.gradient_$eq(gradient2);
        return this;
    }

    public LBFGS setUpdater(Updater updater) {
        this.updater_$eq(updater);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Vector optimize(RDD<Tuple2<Object, Vector>> data, Vector initialWeights) {
        Tuple2<Vector, double[]> tuple2 = LBFGS$.MODULE$.runLBFGS(data, this.gradient(), this.updater(), this.numCorrections(), this.convergenceTol(), this.maxNumIterations(), this.regParam(), initialWeights);
        if (tuple2 != null) {
            void var3_6;
            Vector weights2;
            Vector vector;
            Vector weights3 = vector = (weights2 = (Vector)tuple2._1());
            return var3_6;
        }
        throw new MatchError(tuple2);
    }

    public LBFGS(Gradient gradient2, Updater updater) {
        this.gradient = gradient2;
        this.updater = updater;
        Logging.class.$init$((Logging)this);
        this.numCorrections = 10;
        this.convergenceTol = 1.0E-4;
        this.maxNumIterations = 100;
        this.regParam = 0.0;
    }

    public static class CostFun
    implements DiffFunction<DenseVector<Object>> {
        private final RDD<Tuple2<Object, Vector>> data;
        private final Gradient gradient;
        private final Updater updater;
        private final double regParam;
        private final long numExamples;

        public DiffFunction<DenseVector<Object>> cached(CanCopy<DenseVector<Object>> copy2) {
            return DiffFunction.class.cached((DiffFunction)this, copy2);
        }

        public <U> DiffFunction<U> throughLens(Isomorphism<DenseVector<Object>, U> l) {
            return DiffFunction.class.throughLens((DiffFunction)this, l);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        public Object gradientAt(Object x) {
            return StochasticDiffFunction.class.gradientAt((StochasticDiffFunction)this, (Object)x);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        public double valueAt(Object x) {
            return StochasticDiffFunction.class.valueAt((StochasticDiffFunction)this, (Object)x);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        public final double apply(Object x) {
            return StochasticDiffFunction.class.apply((StochasticDiffFunction)this, (Object)x);
        }

        public boolean apply$mcZD$sp(double v1) {
            return Function1.class.apply$mcZD$sp((Function1)this, (double)v1);
        }

        public double apply$mcDD$sp(double v1) {
            return Function1.class.apply$mcDD$sp((Function1)this, (double)v1);
        }

        public float apply$mcFD$sp(double v1) {
            return Function1.class.apply$mcFD$sp((Function1)this, (double)v1);
        }

        public int apply$mcID$sp(double v1) {
            return Function1.class.apply$mcID$sp((Function1)this, (double)v1);
        }

        public long apply$mcJD$sp(double v1) {
            return Function1.class.apply$mcJD$sp((Function1)this, (double)v1);
        }

        public void apply$mcVD$sp(double v1) {
            Function1.class.apply$mcVD$sp((Function1)this, (double)v1);
        }

        public boolean apply$mcZF$sp(float v1) {
            return Function1.class.apply$mcZF$sp((Function1)this, (float)v1);
        }

        public double apply$mcDF$sp(float v1) {
            return Function1.class.apply$mcDF$sp((Function1)this, (float)v1);
        }

        public float apply$mcFF$sp(float v1) {
            return Function1.class.apply$mcFF$sp((Function1)this, (float)v1);
        }

        public int apply$mcIF$sp(float v1) {
            return Function1.class.apply$mcIF$sp((Function1)this, (float)v1);
        }

        public long apply$mcJF$sp(float v1) {
            return Function1.class.apply$mcJF$sp((Function1)this, (float)v1);
        }

        public void apply$mcVF$sp(float v1) {
            Function1.class.apply$mcVF$sp((Function1)this, (float)v1);
        }

        public boolean apply$mcZI$sp(int v1) {
            return Function1.class.apply$mcZI$sp((Function1)this, (int)v1);
        }

        public double apply$mcDI$sp(int v1) {
            return Function1.class.apply$mcDI$sp((Function1)this, (int)v1);
        }

        public float apply$mcFI$sp(int v1) {
            return Function1.class.apply$mcFI$sp((Function1)this, (int)v1);
        }

        public int apply$mcII$sp(int v1) {
            return Function1.class.apply$mcII$sp((Function1)this, (int)v1);
        }

        public long apply$mcJI$sp(int v1) {
            return Function1.class.apply$mcJI$sp((Function1)this, (int)v1);
        }

        public void apply$mcVI$sp(int v1) {
            Function1.class.apply$mcVI$sp((Function1)this, (int)v1);
        }

        public boolean apply$mcZJ$sp(long v1) {
            return Function1.class.apply$mcZJ$sp((Function1)this, (long)v1);
        }

        public double apply$mcDJ$sp(long v1) {
            return Function1.class.apply$mcDJ$sp((Function1)this, (long)v1);
        }

        public float apply$mcFJ$sp(long v1) {
            return Function1.class.apply$mcFJ$sp((Function1)this, (long)v1);
        }

        public int apply$mcIJ$sp(long v1) {
            return Function1.class.apply$mcIJ$sp((Function1)this, (long)v1);
        }

        public long apply$mcJJ$sp(long v1) {
            return Function1.class.apply$mcJJ$sp((Function1)this, (long)v1);
        }

        public void apply$mcVJ$sp(long v1) {
            Function1.class.apply$mcVJ$sp((Function1)this, (long)v1);
        }

        public <A> Function1<A, Object> compose(Function1<A, DenseVector<Object>> g) {
            return Function1.class.compose((Function1)this, g);
        }

        public <A> Function1<A, Object> compose$mcZD$sp(Function1<A, Object> g) {
            return Function1.class.compose$mcZD$sp((Function1)this, g);
        }

        public <A> Function1<A, Object> compose$mcDD$sp(Function1<A, Object> g) {
            return Function1.class.compose$mcDD$sp((Function1)this, g);
        }

        public <A> Function1<A, Object> compose$mcFD$sp(Function1<A, Object> g) {
            return Function1.class.compose$mcFD$sp((Function1)this, g);
        }

        public <A> Function1<A, Object> compose$mcID$sp(Function1<A, Object> g) {
            return Function1.class.compose$mcID$sp((Function1)this, g);
        }

        public <A> Function1<A, Object> compose$mcJD$sp(Function1<A, Object> g) {
            return Function1.class.compose$mcJD$sp((Function1)this, g);
        }

        public <A> Function1<A, BoxedUnit> compose$mcVD$sp(Function1<A, Object> g) {
            return Function1.class.compose$mcVD$sp((Function1)this, g);
        }

        public <A> Function1<A, Object> compose$mcZF$sp(Function1<A, Object> g) {
            return Function1.class.compose$mcZF$sp((Function1)this, g);
        }

        public <A> Function1<A, Object> compose$mcDF$sp(Function1<A, Object> g) {
            return Function1.class.compose$mcDF$sp((Function1)this, g);
        }

        public <A> Function1<A, Object> compose$mcFF$sp(Function1<A, Object> g) {
            return Function1.class.compose$mcFF$sp((Function1)this, g);
        }

        public <A> Function1<A, Object> compose$mcIF$sp(Function1<A, Object> g) {
            return Function1.class.compose$mcIF$sp((Function1)this, g);
        }

        public <A> Function1<A, Object> compose$mcJF$sp(Function1<A, Object> g) {
            return Function1.class.compose$mcJF$sp((Function1)this, g);
        }

        public <A> Function1<A, BoxedUnit> compose$mcVF$sp(Function1<A, Object> g) {
            return Function1.class.compose$mcVF$sp((Function1)this, g);
        }

        public <A> Function1<A, Object> compose$mcZI$sp(Function1<A, Object> g) {
            return Function1.class.compose$mcZI$sp((Function1)this, g);
        }

        public <A> Function1<A, Object> compose$mcDI$sp(Function1<A, Object> g) {
            return Function1.class.compose$mcDI$sp((Function1)this, g);
        }

        public <A> Function1<A, Object> compose$mcFI$sp(Function1<A, Object> g) {
            return Function1.class.compose$mcFI$sp((Function1)this, g);
        }

        public <A> Function1<A, Object> compose$mcII$sp(Function1<A, Object> g) {
            return Function1.class.compose$mcII$sp((Function1)this, g);
        }

        public <A> Function1<A, Object> compose$mcJI$sp(Function1<A, Object> g) {
            return Function1.class.compose$mcJI$sp((Function1)this, g);
        }

        public <A> Function1<A, BoxedUnit> compose$mcVI$sp(Function1<A, Object> g) {
            return Function1.class.compose$mcVI$sp((Function1)this, g);
        }

        public <A> Function1<A, Object> compose$mcZJ$sp(Function1<A, Object> g) {
            return Function1.class.compose$mcZJ$sp((Function1)this, g);
        }

        public <A> Function1<A, Object> compose$mcDJ$sp(Function1<A, Object> g) {
            return Function1.class.compose$mcDJ$sp((Function1)this, g);
        }

        public <A> Function1<A, Object> compose$mcFJ$sp(Function1<A, Object> g) {
            return Function1.class.compose$mcFJ$sp((Function1)this, g);
        }

        public <A> Function1<A, Object> compose$mcIJ$sp(Function1<A, Object> g) {
            return Function1.class.compose$mcIJ$sp((Function1)this, g);
        }

        public <A> Function1<A, Object> compose$mcJJ$sp(Function1<A, Object> g) {
            return Function1.class.compose$mcJJ$sp((Function1)this, g);
        }

        public <A> Function1<A, BoxedUnit> compose$mcVJ$sp(Function1<A, Object> g) {
            return Function1.class.compose$mcVJ$sp((Function1)this, g);
        }

        public <A> Function1<DenseVector<Object>, A> andThen(Function1<Object, A> g) {
            return Function1.class.andThen((Function1)this, g);
        }

        public <A> Function1<Object, A> andThen$mcZD$sp(Function1<Object, A> g) {
            return Function1.class.andThen$mcZD$sp((Function1)this, g);
        }

        public <A> Function1<Object, A> andThen$mcDD$sp(Function1<Object, A> g) {
            return Function1.class.andThen$mcDD$sp((Function1)this, g);
        }

        public <A> Function1<Object, A> andThen$mcFD$sp(Function1<Object, A> g) {
            return Function1.class.andThen$mcFD$sp((Function1)this, g);
        }

        public <A> Function1<Object, A> andThen$mcID$sp(Function1<Object, A> g) {
            return Function1.class.andThen$mcID$sp((Function1)this, g);
        }

        public <A> Function1<Object, A> andThen$mcJD$sp(Function1<Object, A> g) {
            return Function1.class.andThen$mcJD$sp((Function1)this, g);
        }

        public <A> Function1<Object, A> andThen$mcVD$sp(Function1<BoxedUnit, A> g) {
            return Function1.class.andThen$mcVD$sp((Function1)this, g);
        }

        public <A> Function1<Object, A> andThen$mcZF$sp(Function1<Object, A> g) {
            return Function1.class.andThen$mcZF$sp((Function1)this, g);
        }

        public <A> Function1<Object, A> andThen$mcDF$sp(Function1<Object, A> g) {
            return Function1.class.andThen$mcDF$sp((Function1)this, g);
        }

        public <A> Function1<Object, A> andThen$mcFF$sp(Function1<Object, A> g) {
            return Function1.class.andThen$mcFF$sp((Function1)this, g);
        }

        public <A> Function1<Object, A> andThen$mcIF$sp(Function1<Object, A> g) {
            return Function1.class.andThen$mcIF$sp((Function1)this, g);
        }

        public <A> Function1<Object, A> andThen$mcJF$sp(Function1<Object, A> g) {
            return Function1.class.andThen$mcJF$sp((Function1)this, g);
        }

        public <A> Function1<Object, A> andThen$mcVF$sp(Function1<BoxedUnit, A> g) {
            return Function1.class.andThen$mcVF$sp((Function1)this, g);
        }

        public <A> Function1<Object, A> andThen$mcZI$sp(Function1<Object, A> g) {
            return Function1.class.andThen$mcZI$sp((Function1)this, g);
        }

        public <A> Function1<Object, A> andThen$mcDI$sp(Function1<Object, A> g) {
            return Function1.class.andThen$mcDI$sp((Function1)this, g);
        }

        public <A> Function1<Object, A> andThen$mcFI$sp(Function1<Object, A> g) {
            return Function1.class.andThen$mcFI$sp((Function1)this, g);
        }

        public <A> Function1<Object, A> andThen$mcII$sp(Function1<Object, A> g) {
            return Function1.class.andThen$mcII$sp((Function1)this, g);
        }

        public <A> Function1<Object, A> andThen$mcJI$sp(Function1<Object, A> g) {
            return Function1.class.andThen$mcJI$sp((Function1)this, g);
        }

        public <A> Function1<Object, A> andThen$mcVI$sp(Function1<BoxedUnit, A> g) {
            return Function1.class.andThen$mcVI$sp((Function1)this, g);
        }

        public <A> Function1<Object, A> andThen$mcZJ$sp(Function1<Object, A> g) {
            return Function1.class.andThen$mcZJ$sp((Function1)this, g);
        }

        public <A> Function1<Object, A> andThen$mcDJ$sp(Function1<Object, A> g) {
            return Function1.class.andThen$mcDJ$sp((Function1)this, g);
        }

        public <A> Function1<Object, A> andThen$mcFJ$sp(Function1<Object, A> g) {
            return Function1.class.andThen$mcFJ$sp((Function1)this, g);
        }

        public <A> Function1<Object, A> andThen$mcIJ$sp(Function1<Object, A> g) {
            return Function1.class.andThen$mcIJ$sp((Function1)this, g);
        }

        public <A> Function1<Object, A> andThen$mcJJ$sp(Function1<Object, A> g) {
            return Function1.class.andThen$mcJJ$sp((Function1)this, g);
        }

        public <A> Function1<Object, A> andThen$mcVJ$sp(Function1<BoxedUnit, A> g) {
            return Function1.class.andThen$mcVJ$sp((Function1)this, g);
        }

        public String toString() {
            return Function1.class.toString((Function1)this);
        }

        public Tuple2<Object, DenseVector<Object>> calculate(DenseVector<Object> weights2) {
            int x$5;
            Serializable x$4;
            Serializable x$3;
            Vector w2 = Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector<Object>)weights2);
            int n = w2.size();
            Broadcast bcW = this.data.context().broadcast((Object)w2, ClassTag$.MODULE$.apply(Vector.class));
            Gradient localGradient = this.gradient;
            Tuple2 x$2 = new Tuple2((Object)Vectors$.MODULE$.zeros(n), (Object)BoxesRunTime.boxToDouble((double)0.0));
            Tuple2 tuple2 = (Tuple2)this.data.treeAggregate((Object)x$2, (Function2)(x$3 = new Serializable(this, bcW, localGradient){
                public static final long serialVersionUID = 0L;
                private final Broadcast bcW$1;
                private final Gradient localGradient$1;

                public final Tuple2<Vector, Object> apply(Tuple2<Vector, Object> c, Tuple2<Object, Vector> v) {
                    Tuple2 tuple2 = new Tuple2(c, v);
                    if (tuple2 != null) {
                        Tuple2 tuple22 = (Tuple2)tuple2._1();
                        Tuple2 tuple23 = (Tuple2)tuple2._2();
                        if (tuple22 != null) {
                            Vector grad = (Vector)tuple22._1();
                            double loss2 = tuple22._2$mcD$sp();
                            if (tuple23 != null) {
                                double label = tuple23._1$mcD$sp();
                                Vector features = (Vector)tuple23._2();
                                double l = this.localGradient$1.compute(features, label, (Vector)this.bcW$1.value(), grad);
                                Tuple2 tuple24 = new Tuple2((Object)grad, (Object)BoxesRunTime.boxToDouble((double)(loss2 + l)));
                                return tuple24;
                            }
                        }
                    }
                    throw new MatchError((Object)tuple2);
                }
                {
                    this.bcW$1 = bcW$1;
                    this.localGradient$1 = localGradient$1;
                }
            }), (Function2)(x$4 = new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Vector, Object> apply(Tuple2<Vector, Object> c1, Tuple2<Vector, Object> c2) {
                    Tuple2 tuple2 = new Tuple2(c1, c2);
                    if (tuple2 != null) {
                        Tuple2 tuple22 = (Tuple2)tuple2._1();
                        Tuple2 tuple23 = (Tuple2)tuple2._2();
                        if (tuple22 != null) {
                            Vector grad1 = (Vector)tuple22._1();
                            double loss1 = tuple22._2$mcD$sp();
                            if (tuple23 != null) {
                                Vector grad2 = (Vector)tuple23._1();
                                double loss2 = tuple23._2$mcD$sp();
                                BLAS$.MODULE$.axpy(1.0, grad2, grad1);
                                Tuple2 tuple24 = new Tuple2((Object)grad1, (Object)BoxesRunTime.boxToDouble((double)(loss1 + loss2)));
                                return tuple24;
                            }
                        }
                    }
                    throw new MatchError((Object)tuple2);
                }
            }), x$5 = this.data.treeAggregate$default$4((Object)x$2), ClassTag$.MODULE$.apply(Tuple2.class));
            if (tuple2 != null) {
                Tuple2 tuple22;
                Vector gradientSum = (Vector)tuple2._1();
                double lossSum = tuple2._2$mcD$sp();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)gradientSum, (Object)BoxesRunTime.boxToDouble((double)lossSum));
                Vector gradientSum2 = (Vector)tuple23._1();
                double lossSum2 = tuple23._2$mcD$sp();
                double regVal = this.updater.compute(w2, Vectors$.MODULE$.zeros(n), 0.0, 1, this.regParam)._2$mcD$sp();
                double loss2 = lossSum2 / (double)this.numExamples + regVal;
                Vector gradientTotal = w2.copy();
                BLAS$.MODULE$.axpy(-1.0, (Vector)this.updater.compute(w2, Vectors$.MODULE$.zeros(n), 1.0, 1, this.regParam)._1(), gradientTotal);
                BLAS$.MODULE$.axpy(1.0 / (double)this.numExamples, gradientSum2, gradientTotal);
                return new Tuple2((Object)BoxesRunTime.boxToDouble((double)loss2), (Object)((DenseVector)gradientTotal.toBreeze()));
            }
            throw new MatchError((Object)tuple2);
        }

        public CostFun(RDD<Tuple2<Object, Vector>> data, Gradient gradient2, Updater updater, double regParam, long numExamples) {
            this.data = data;
            this.gradient = gradient2;
            this.updater = updater;
            this.regParam = regParam;
            this.numExamples = numExamples;
            Function1.class.$init$((Function1)this);
            StochasticDiffFunction.class.$init$((StochasticDiffFunction)this);
            DiffFunction.class.$init$((DiffFunction)this);
        }
    }
}

