/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.api.python;

import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import net.razorvine.pickle.IObjectConstructor;
import net.razorvine.pickle.IObjectPickler;
import net.razorvine.pickle.PickleException;
import net.razorvine.pickle.PickleUtils;
import net.razorvine.pickle.Pickler;
import net.razorvine.pickle.Unpickler;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.api.python.SerDe$;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.SparseMatrix;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.recommendation.Rating;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\rwAB\u0001\u0003\u0011\u0003Aa\"A\u0003TKJ$UM\u0003\u0002\u0004\t\u00051\u0001/\u001f;i_:T!!\u0002\u0004\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\b\u0011\u0005)Q\u000e\u001c7jE*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014x\r\u0005\u0002\u0010!5\t!A\u0002\u0004\u0012\u0005!\u0005\u0001B\u0005\u0002\u0006'\u0016\u0014H)Z\n\u0004!MI\u0002C\u0001\u000b\u0018\u001b\u0005)\"\"\u0001\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005a)\"AB!osJ+g\r\u0005\u0002\u00155%\u00111$\u0006\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\u0006;A!\taH\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\ta\u0002C\u0004\"!\t\u0007I\u0011\u0001\u0012\u0002\u001fAK6\u000bU!S\u0017~\u0003\u0016iQ&B\u000f\u0016+\u0012a\t\t\u0003I%j\u0011!\n\u0006\u0003M\u001d\nA\u0001\\1oO*\t\u0001&\u0001\u0003kCZ\f\u0017B\u0001\u0016&\u0005\u0019\u0019FO]5oO\"1A\u0006\u0005Q\u0001\n\r\n\u0001\u0003U-T!\u0006\u00136j\u0018)B\u0007.\u000bu)\u0012\u0011\t\u000f9\u0002\"\u0019!C\u0001E\u00051A*\u0011+J\u001dFBa\u0001\r\t!\u0002\u0013\u0019\u0013a\u0002'B)&s\u0015\u0007\t\u0004\u0007eA\t\tAA\u001a\u0003\u0017\t\u000b7/\u001a)jG.dWM]\u000b\u0003i=\u001bB!M\u001b9\u0005B\u0011AEN\u0005\u0003o\u0015\u0012aa\u00142kK\u000e$\bCA\u001dA\u001b\u0005Q$BA\u001e=\u0003\u0019\u0001\u0018nY6mK*\u0011QHP\u0001\ne\u0006TxN\u001d<j]\u0016T\u0011aP\u0001\u0004]\u0016$\u0018BA!;\u00059IuJ\u00196fGR\u0004\u0016nY6mKJ\u0004\"!O\"\n\u0005\u0011S$AE%PE*,7\r^\"p]N$(/^2u_JD\u0001BR\u0019\u0003\u0004\u0003\u0006YaR\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004c\u0001%L\u001b6\t\u0011J\u0003\u0002K+\u00059!/\u001a4mK\u000e$\u0018B\u0001'J\u0005!\u0019E.Y:t)\u0006<\u0007C\u0001(P\u0019\u0001!Q\u0001U\u0019C\u0002E\u0013\u0011\u0001V\t\u0003%V\u0003\"\u0001F*\n\u0005Q+\"a\u0002(pi\"Lgn\u001a\t\u0003)YK!aV\u000b\u0003\u0007\u0005s\u0017\u0010C\u0003\u001ec\u0011\u0005\u0011\fF\u0001[)\tYV\fE\u0002]c5k\u0011\u0001\u0005\u0005\u0006\rb\u0003\u001da\u0012\u0005\b?F\u0012\r\u0011\"\u0003a\u0003\r\u0019Gn]\u000b\u0002CB\u0012!M\u001a\t\u0004I\r,\u0017B\u00013&\u0005\u0015\u0019E.Y:t!\tqe\rB\u0005hQ\u0006\u0005\t\u0011!B\u0001#\n\u0019q\fJ\u0019\t\r%\f\u0004\u0015!\u0003b\u0003\u0011\u0019Gn\u001d\u0011\t\u000f-\f$\u0019!C\u0005E\u00051Qn\u001c3vY\u0016Da!\\\u0019!\u0002\u0013\u0019\u0013aB7pIVdW\r\t\u0005\b_F\u0012\r\u0011\"\u0003#\u0003\u0011q\u0017-\\3\t\rE\f\u0004\u0015!\u0003$\u0003\u0015q\u0017-\\3!\u0011\u0015\u0019\u0018\u0007\"\u0001u\u0003!\u0011XmZ5ti\u0016\u0014H#A;\u0011\u0005Q1\u0018BA<\u0016\u0005\u0011)f.\u001b;\t\u000bm\nD\u0011A=\u0015\u000bUTH0!\u0003\t\u000bmD\b\u0019A\u001b\u0002\u0007=\u0014'\u000eC\u0003~q\u0002\u0007a0A\u0002pkR\u00042a`A\u0003\u001b\t\t\tAC\u0002\u0002\u0004\u001d\n!![8\n\t\u0005\u001d\u0011\u0011\u0001\u0002\r\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u0005\b\u0003\u0017A\b\u0019AA\u0007\u0003\u001d\u0001\u0018nY6mKJ\u00042!OA\b\u0013\r\t\tB\u000f\u0002\b!&\u001c7\u000e\\3s\u0011!\t)\"\rC\u0001\u0005\u0005]\u0011aC:bm\u0016|%M[3diN$r!^A\r\u00037\ti\u0002\u0003\u0004~\u0003'\u0001\rA \u0005\t\u0003\u0017\t\u0019\u00021\u0001\u0002\u000e!A\u0011qDA\n\u0001\u0004\t\t#A\u0004pE*,7\r^:\u0011\tQ\t\u0019#V\u0005\u0004\u0003K)\"A\u0003\u001fsKB,\u0017\r^3e}!9\u0011\u0011F\u0019\u0005\u0012\u0005-\u0012\u0001C4fi\nKH/Z:\u0015\t\u00055\u0012\u0011\b\t\u0006)\u0005=\u00121G\u0005\u0004\u0003c)\"!B!se\u0006L\bc\u0001\u000b\u00026%\u0019\u0011qG\u000b\u0003\t\tKH/\u001a\u0005\u0007w\u0006\u001d\u0002\u0019A\u001b\t\u0011\u0005u\u0012G\"\u0001\u0003\u0003\u007f\t\u0011b]1wKN#\u0018\r^3\u0015\u000fU\f\t%a\u0011\u0002F!110a\u000fA\u0002UBa!`A\u001e\u0001\u0004q\b\u0002CA\u0006\u0003w\u0001\r!!\u0004\u0007\u000f\u0005%\u0003\u0003\u0001\u0002\u0002L\t\u0011B)\u001a8tKZ+7\r^8s!&\u001c7\u000e\\3s'\u0011\t9%!\u0014\u0011\tq\u000b\u0014q\n\t\u0005\u0003#\n9&\u0004\u0002\u0002T)\u0019\u0011Q\u000b\u0004\u0002\r1Lg.\u00197h\u0013\u0011\tI&a\u0015\u0003\u0017\u0011+gn]3WK\u000e$xN\u001d\u0005\b;\u0005\u001dC\u0011AA/)\t\ty\u0006E\u0002]\u0003\u000fB\u0001\"!\u0010\u0002H\u0011\u0005\u00111\r\u000b\bk\u0006\u0015\u0014qMA5\u0011\u0019Y\u0018\u0011\ra\u0001k!1Q0!\u0019A\u0002yD\u0001\"a\u0003\u0002b\u0001\u0007\u0011Q\u0002\u0005\t\u0003[\n9\u0005\"\u0001\u0002p\u0005I1m\u001c8tiJ,8\r\u001e\u000b\u0004k\u0005E\u0004\u0002CA:\u0003W\u0002\r!!\u001e\u0002\t\u0005\u0014xm\u001d\t\u0005)\u0005=RGB\u0004\u0002zA\u0001!!a\u001f\u0003%\u0011+gn]3NCR\u0014\u0018\u000e\u001f)jG.dWM]\n\u0005\u0003o\ni\b\u0005\u0003]c\u0005}\u0004\u0003BA)\u0003\u0003KA!a!\u0002T\tYA)\u001a8tK6\u000bGO]5y\u0011\u001di\u0012q\u000fC\u0001\u0003\u000f#\"!!#\u0011\u0007q\u000b9\b\u0003\u0005\u0002>\u0005]D\u0011AAG)\u001d)\u0018qRAI\u0003'Caa_AF\u0001\u0004)\u0004BB?\u0002\f\u0002\u0007a\u0010\u0003\u0005\u0002\f\u0005-\u0005\u0019AA\u0007\u0011!\ti'a\u001e\u0005\u0002\u0005]EcA\u001b\u0002\u001a\"A\u00111OAK\u0001\u0004\t)HB\u0004\u0002\u001eB\u0001!!a(\u0003'M\u0003\u0018M]:f\u001b\u0006$(/\u001b=QS\u000e\\G.\u001a:\u0014\t\u0005m\u0015\u0011\u0015\t\u00059F\n\u0019\u000b\u0005\u0003\u0002R\u0005\u0015\u0016\u0002BAT\u0003'\u0012Ab\u00159beN,W*\u0019;sSbDq!HAN\t\u0003\tY\u000b\u0006\u0002\u0002.B\u0019A,a'\t\u0011\u0005u\u00121\u0014C\u0001\u0003c#r!^AZ\u0003k\u000b9\f\u0003\u0004|\u0003_\u0003\r!\u000e\u0005\u0007{\u0006=\u0006\u0019\u0001@\t\u0011\u0005-\u0011q\u0016a\u0001\u0003\u001bA\u0001\"!\u001c\u0002\u001c\u0012\u0005\u00111\u0018\u000b\u0004k\u0005u\u0006\u0002CA:\u0003s\u0003\r!!\u001e\u0007\u000f\u0005\u0005\u0007\u0003\u0001\u0002\u0002D\n\u00192\u000b]1sg\u00164Vm\u0019;peBK7m\u001b7feN!\u0011qXAc!\u0011a\u0016'a2\u0011\t\u0005E\u0013\u0011Z\u0005\u0005\u0003\u0017\f\u0019F\u0001\u0007Ta\u0006\u00148/\u001a,fGR|'\u000fC\u0004\u001e\u0003\u007f#\t!a4\u0015\u0005\u0005E\u0007c\u0001/\u0002@\"A\u0011QHA`\t\u0003\t)\u000eF\u0004v\u0003/\fI.a7\t\rm\f\u0019\u000e1\u00016\u0011\u0019i\u00181\u001ba\u0001}\"A\u00111BAj\u0001\u0004\ti\u0001\u0003\u0005\u0002n\u0005}F\u0011AAp)\r)\u0014\u0011\u001d\u0005\t\u0003g\ni\u000e1\u0001\u0002v\u00199\u0011Q\u001d\t\u0001\u0005\u0005\u001d(a\u0005'bE\u0016dW\r\u001a)pS:$\b+[2lY\u0016\u00148\u0003BAr\u0003S\u0004B\u0001X\u0019\u0002lB!\u0011Q^Az\u001b\t\tyOC\u0002\u0002r\u001a\t!B]3he\u0016\u001c8/[8o\u0013\u0011\t)0a<\u0003\u00191\u000b'-\u001a7fIB{\u0017N\u001c;\t\u000fu\t\u0019\u000f\"\u0001\u0002zR\u0011\u00111 \t\u00049\u0006\r\b\u0002CA\u001f\u0003G$\t!a@\u0015\u000fU\u0014\tAa\u0001\u0003\u0006!110!@A\u0002UBa!`A\u007f\u0001\u0004q\b\u0002CA\u0006\u0003{\u0004\r!!\u0004\t\u0011\u00055\u00141\u001dC\u0001\u0005\u0013!2!\u000eB\u0006\u0011!\t\u0019Ha\u0002A\u0002\u0005Uda\u0002B\b!\u0001\u0011!\u0011\u0003\u0002\u000e%\u0006$\u0018N\\4QS\u000e\\G.\u001a:\u0014\t\t5!1\u0003\t\u00059F\u0012)\u0002\u0005\u0003\u0003\u0018\tuQB\u0001B\r\u0015\r\u0011YBB\u0001\u000fe\u0016\u001cw.\\7f]\u0012\fG/[8o\u0013\u0011\u0011yB!\u0007\u0003\rI\u000bG/\u001b8h\u0011\u001di\"Q\u0002C\u0001\u0005G!\"A!\n\u0011\u0007q\u0013i\u0001\u0003\u0005\u0002>\t5A\u0011\u0001B\u0015)\u001d)(1\u0006B\u0017\u0005_Aaa\u001fB\u0014\u0001\u0004)\u0004BB?\u0003(\u0001\u0007a\u0010\u0003\u0005\u0002\f\t\u001d\u0002\u0019AA\u0007\u0011!\tiG!\u0004\u0005\u0002\tMBcA\u001b\u00036!A\u00111\u000fB\u0019\u0001\u0004\t)\bC\u0005\u0003:A\u0001\r\u0011\"\u0001\u0003<\u0005Y\u0011N\\5uS\u0006d\u0017N_3e+\t\u0011i\u0004E\u0002\u0015\u0005\u007fI1A!\u0011\u0016\u0005\u001d\u0011un\u001c7fC:D\u0011B!\u0012\u0011\u0001\u0004%\tAa\u0012\u0002\u001f%t\u0017\u000e^5bY&TX\rZ0%KF$2!\u001eB%\u0011)\u0011YEa\u0011\u0002\u0002\u0003\u0007!QH\u0001\u0004q\u0012\n\u0004\u0002\u0003B(!\u0001\u0006KA!\u0010\u0002\u0019%t\u0017\u000e^5bY&TX\r\u001a\u0011\t\r\tM\u0003\u0003\"\u0001u\u0003)Ig.\u001b;jC2L'0\u001a\u0005\b\u0005/\u0002B\u0011\u0001B-\u0003\u0015!W/\u001c9t)\u0011\tiCa\u0017\t\rm\u0014)\u00061\u0001\u0014\u0011\u001d\u0011y\u0006\u0005C\u0001\u0005C\nQ\u0001\\8bIN$2a\u0005B2\u0011!\u0011)G!\u0018A\u0002\u00055\u0012!\u00022zi\u0016\u001c\bb\u0002B5!\u0011\u0005!1N\u0001\u000bCN$V\u000f\u001d7f%\u0012#E\u0003\u0002B7\u0005\u000b\u0003bAa\u001c\u0003v\teTB\u0001B9\u0015\r\u0011\u0019\bC\u0001\u0004e\u0012$\u0017\u0002\u0002B<\u0005c\u00121A\u0015#E!\u001d!\"1\u0010B@\u0005\u007fJ1A! \u0016\u0005\u0019!V\u000f\u001d7feA\u0019AC!!\n\u0007\t\rUCA\u0002J]RD\u0001Ba\u001d\u0003h\u0001\u0007!q\u0011\t\u0007\u0005_\u0012)H!#\u0011\tQ\ty#\u0016\u0005\b\u0005\u001b\u0003B\u0011\u0001BH\u000351'o\\7UkBdWM\r*E\tR!!q\u0011BI\u0011!\u0011\u0019Ha#A\u0002\tM\u0005C\u0002B8\u0005k\u0012)\nE\u0003\u0015\u0005w*V\u000bC\u0004\u0003\u001aB!\tAa'\u0002\u0019)\fg/\u0019+p!f$\bn\u001c8\u0015\t\tu%\u0011\u0016\t\u0007\u0005?\u0013)+!\f\u000e\u0005\t\u0005&b\u0001\u0015\u0003$*\u0011Q\u0001C\u0005\u0005\u0005O\u0013\tKA\u0004KCZ\f'\u000b\u0012#\t\u0011\t-&q\u0013a\u0001\u0005[\u000bAA\u001b*E\tB)!q\u0014BS+\"9!\u0011\u0017\t\u0005\u0002\tM\u0016\u0001\u00049zi\"|g\u000eV8KCZ\fGC\u0002BW\u0005k\u0013I\f\u0003\u0005\u00038\n=\u0006\u0019\u0001BO\u0003\u0015\u0001\u0018P\u0015#E\u0011!\u0011YLa,A\u0002\tu\u0012a\u00022bi\u000eDW\r\u001a\u0005\n\u0005\u007f\u0003\u0012\u0011!C\u0005\u0005\u0003\f1B]3bIJ+7o\u001c7wKR\tQ\u0007")
public final class SerDe {
    public static JavaRDD<Object> pythonToJava(JavaRDD<byte[]> javaRDD, boolean bl) {
        return SerDe$.MODULE$.pythonToJava(javaRDD, bl);
    }

    public static JavaRDD<byte[]> javaToPython(JavaRDD<Object> javaRDD) {
        return SerDe$.MODULE$.javaToPython(javaRDD);
    }

    public static RDD<Object[]> fromTuple2RDD(RDD<Tuple2<Object, Object>> rDD) {
        return SerDe$.MODULE$.fromTuple2RDD(rDD);
    }

    public static RDD<Tuple2<Object, Object>> asTupleRDD(RDD<Object[]> rDD) {
        return SerDe$.MODULE$.asTupleRDD(rDD);
    }

    public static Object loads(byte[] byArray) {
        return SerDe$.MODULE$.loads(byArray);
    }

    public static byte[] dumps(Object object) {
        return SerDe$.MODULE$.dumps(object);
    }

    public static void initialize() {
        SerDe$.MODULE$.initialize();
    }

    public static void initialized_$eq(boolean bl) {
        SerDe$.MODULE$.initialized_$eq(bl);
    }

    public static boolean initialized() {
        return SerDe$.MODULE$.initialized();
    }

    public static String LATIN1() {
        return SerDe$.MODULE$.LATIN1();
    }

    public static String PYSPARK_PACKAGE() {
        return SerDe$.MODULE$.PYSPARK_PACKAGE();
    }

    public static abstract class BasePickler<T>
    implements IObjectPickler,
    IObjectConstructor {
        private final Class<?> cls;
        private final String module;
        private final String name;

        private Class<?> cls() {
            return this.cls;
        }

        private String module() {
            return this.module;
        }

        private String name() {
            return this.name;
        }

        public void register() {
            Pickler.registerCustomPickler(this.getClass(), (IObjectPickler)this);
            Pickler.registerCustomPickler(this.cls(), (IObjectPickler)this);
            Unpickler.registerConstructor((String)this.module(), (String)this.name(), (IObjectConstructor)this);
        }

        public void pickle(Object obj, OutputStream out, Pickler pickler) {
            Object object = obj;
            BasePickler basePickler = this;
            if (!(object != null ? !object.equals(basePickler) : basePickler != null)) {
                out.write(99);
                out.write(new StringBuilder().append((Object)this.module()).append((Object)"\n").append((Object)this.name()).append((Object)"\n").toString().getBytes());
            } else {
                pickler.save((Object)this);
                this.saveState(obj, out, pickler);
                out.write(82);
            }
        }

        public void saveObjects(OutputStream out, Pickler pickler, Seq<Object> objects) {
            int n;
            if (objects.length() == 0 || objects.length() > 3) {
                out.write(40);
            }
            objects.foreach((Function1)new Serializable(this, pickler){
                public static final long serialVersionUID = 0L;
                private final Pickler pickler$1;

                public final void apply(Object x$1) {
                    this.pickler$1.save(x$1);
                }
                {
                    this.pickler$1 = pickler$1;
                }
            });
            int n2 = objects.length();
            switch (n2) {
                default: {
                    n = 116;
                    break;
                }
                case 3: {
                    n = 135;
                    break;
                }
                case 2: {
                    n = 134;
                    break;
                }
                case 1: {
                    n = 133;
                }
            }
            int code = n;
            out.write(code);
        }

        public byte[] getBytes(Object obj) {
            return obj.getClass().isArray() ? (byte[])obj : ((String)obj).getBytes(SerDe$.MODULE$.LATIN1());
        }

        public abstract void saveState(Object var1, OutputStream var2, Pickler var3);

        public BasePickler(ClassTag<T> evidence$1) {
            this.cls = ((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass();
            this.module = new StringBuilder().append((Object)SerDe$.MODULE$.PYSPARK_PACKAGE()).append((Object)".").append((Object)new StringOps(Predef$.MODULE$.augmentString(this.cls().getName())).split('.')[4]).toString();
            this.name = this.cls().getSimpleName();
        }
    }

    public static class RatingPickler
    extends BasePickler<Rating> {
        @Override
        public void saveState(Object obj, OutputStream out, Pickler pickler) {
            Rating rating = (Rating)obj;
            this.saveObjects(out, pickler, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)rating.user()), BoxesRunTime.boxToInteger((int)rating.product()), BoxesRunTime.boxToDouble((double)rating.rating())}));
        }

        public Object construct(Object[] args) {
            if (args.length != 3) {
                throw new PickleException("should be 3");
            }
            return new Rating(BoxesRunTime.unboxToInt((Object)args[0]), BoxesRunTime.unboxToInt((Object)args[1]), BoxesRunTime.unboxToDouble((Object)args[2]));
        }

        public RatingPickler() {
            super(ClassTag$.MODULE$.apply(Rating.class));
        }
    }

    public static class DenseVectorPickler
    extends BasePickler<DenseVector> {
        @Override
        public void saveState(Object obj, OutputStream out, Pickler pickler) {
            DenseVector vector = (DenseVector)obj;
            byte[] bytes = new byte[8 * vector.size()];
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            bb.order(ByteOrder.nativeOrder());
            DoubleBuffer db = bb.asDoubleBuffer();
            db.put(vector.values());
            out.write(84);
            out.write(PickleUtils.integer_to_bytes((int)bytes.length));
            out.write(bytes);
            out.write(133);
        }

        public Object construct(Object[] args) {
            Predef$.MODULE$.require(args.length == 1);
            if (args.length != 1) {
                throw new PickleException("should be 1");
            }
            byte[] bytes = this.getBytes(args[0]);
            ByteBuffer bb = ByteBuffer.wrap(bytes, 0, bytes.length);
            bb.order(ByteOrder.nativeOrder());
            DoubleBuffer db = bb.asDoubleBuffer();
            double[] ans = new double[bytes.length / 8];
            db.get(ans);
            return Vectors$.MODULE$.dense(ans);
        }

        public DenseVectorPickler() {
            super(ClassTag$.MODULE$.apply(DenseVector.class));
        }
    }

    public static class DenseMatrixPickler
    extends BasePickler<DenseMatrix> {
        @Override
        public void saveState(Object obj, OutputStream out, Pickler pickler) {
            DenseMatrix m = (DenseMatrix)obj;
            byte[] bytes = new byte[8 * Predef$.MODULE$.doubleArrayOps(m.values()).size()];
            ByteOrder order = ByteOrder.nativeOrder();
            int isTransposed = m.isTransposed() ? 1 : 0;
            ByteBuffer.wrap(bytes).order(order).asDoubleBuffer().put(m.values());
            out.write(40);
            out.write(74);
            out.write(PickleUtils.integer_to_bytes((int)m.numRows()));
            out.write(74);
            out.write(PickleUtils.integer_to_bytes((int)m.numCols()));
            out.write(84);
            out.write(PickleUtils.integer_to_bytes((int)bytes.length));
            out.write(bytes);
            out.write(74);
            out.write(PickleUtils.integer_to_bytes((int)isTransposed));
            out.write(116);
        }

        public Object construct(Object[] args) {
            if (args.length != 4) {
                throw new PickleException("should be 4");
            }
            byte[] bytes = this.getBytes(args[2]);
            int n = bytes.length / 8;
            double[] values = new double[n];
            ByteOrder order = ByteOrder.nativeOrder();
            ByteBuffer.wrap(bytes).order(order).asDoubleBuffer().get(values);
            boolean isTransposed = BoxesRunTime.unboxToInt((Object)args[3]) == 1;
            return new DenseMatrix(BoxesRunTime.unboxToInt((Object)args[0]), BoxesRunTime.unboxToInt((Object)args[1]), values, isTransposed);
        }

        public DenseMatrixPickler() {
            super(ClassTag$.MODULE$.apply(DenseMatrix.class));
        }
    }

    public static class SparseMatrixPickler
    extends BasePickler<SparseMatrix> {
        @Override
        public void saveState(Object obj, OutputStream out, Pickler pickler) {
            SparseMatrix s = (SparseMatrix)obj;
            ByteOrder order = ByteOrder.nativeOrder();
            byte[] colPtrsBytes = new byte[4 * s.colPtrs().length];
            byte[] indicesBytes = new byte[4 * s.rowIndices().length];
            byte[] valuesBytes = new byte[8 * s.values().length];
            int isTransposed = s.isTransposed() ? 1 : 0;
            ByteBuffer.wrap(colPtrsBytes).order(order).asIntBuffer().put(s.colPtrs());
            ByteBuffer.wrap(indicesBytes).order(order).asIntBuffer().put(s.rowIndices());
            ByteBuffer.wrap(valuesBytes).order(order).asDoubleBuffer().put(s.values());
            out.write(40);
            out.write(74);
            out.write(PickleUtils.integer_to_bytes((int)s.numRows()));
            out.write(74);
            out.write(PickleUtils.integer_to_bytes((int)s.numCols()));
            out.write(84);
            out.write(PickleUtils.integer_to_bytes((int)colPtrsBytes.length));
            out.write(colPtrsBytes);
            out.write(84);
            out.write(PickleUtils.integer_to_bytes((int)indicesBytes.length));
            out.write(indicesBytes);
            out.write(84);
            out.write(PickleUtils.integer_to_bytes((int)valuesBytes.length));
            out.write(valuesBytes);
            out.write(74);
            out.write(PickleUtils.integer_to_bytes((int)isTransposed));
            out.write(116);
        }

        public Object construct(Object[] args) {
            if (args.length != 6) {
                throw new PickleException("should be 6");
            }
            ByteOrder order = ByteOrder.nativeOrder();
            byte[] colPtrsBytes = this.getBytes(args[2]);
            byte[] indicesBytes = this.getBytes(args[3]);
            byte[] valuesBytes = this.getBytes(args[4]);
            int[] colPtrs = new int[colPtrsBytes.length / 4];
            int[] rowIndices = new int[indicesBytes.length / 4];
            double[] values = new double[valuesBytes.length / 8];
            ByteBuffer.wrap(colPtrsBytes).order(order).asIntBuffer().get(colPtrs);
            ByteBuffer.wrap(indicesBytes).order(order).asIntBuffer().get(rowIndices);
            ByteBuffer.wrap(valuesBytes).order(order).asDoubleBuffer().get(values);
            boolean isTransposed = BoxesRunTime.unboxToInt((Object)args[5]) == 1;
            return new SparseMatrix(BoxesRunTime.unboxToInt((Object)args[0]), BoxesRunTime.unboxToInt((Object)args[1]), colPtrs, rowIndices, values, isTransposed);
        }

        public SparseMatrixPickler() {
            super(ClassTag$.MODULE$.apply(SparseMatrix.class));
        }
    }

    public static class SparseVectorPickler
    extends BasePickler<SparseVector> {
        @Override
        public void saveState(Object obj, OutputStream out, Pickler pickler) {
            SparseVector v = (SparseVector)obj;
            int n = Predef$.MODULE$.intArrayOps(v.indices()).size();
            byte[] indiceBytes = new byte[4 * n];
            ByteOrder order = ByteOrder.nativeOrder();
            ByteBuffer.wrap(indiceBytes).order(order).asIntBuffer().put(v.indices());
            byte[] valueBytes = new byte[8 * n];
            ByteBuffer.wrap(valueBytes).order(order).asDoubleBuffer().put(v.values());
            out.write(74);
            out.write(PickleUtils.integer_to_bytes((int)v.size()));
            out.write(84);
            out.write(PickleUtils.integer_to_bytes((int)indiceBytes.length));
            out.write(indiceBytes);
            out.write(84);
            out.write(PickleUtils.integer_to_bytes((int)valueBytes.length));
            out.write(valueBytes);
            out.write(135);
        }

        public Object construct(Object[] args) {
            Object object;
            if (args.length != 3) {
                throw new PickleException("should be 3");
            }
            int size = BoxesRunTime.unboxToInt((Object)args[0]);
            byte[] indiceBytes = this.getBytes(args[1]);
            byte[] valueBytes = this.getBytes(args[2]);
            int n = indiceBytes.length / 4;
            int[] indices = new int[n];
            double[] values = new double[n];
            if (n > 0) {
                ByteOrder order = ByteOrder.nativeOrder();
                ByteBuffer.wrap(indiceBytes).order(order).asIntBuffer().get(indices);
                object = ByteBuffer.wrap(valueBytes).order(order).asDoubleBuffer().get(values);
            } else {
                object = BoxedUnit.UNIT;
            }
            return new SparseVector(size, indices, values);
        }

        public SparseVectorPickler() {
            super(ClassTag$.MODULE$.apply(SparseVector.class));
        }
    }

    public static class LabeledPointPickler
    extends BasePickler<LabeledPoint> {
        @Override
        public void saveState(Object obj, OutputStream out, Pickler pickler) {
            LabeledPoint point = (LabeledPoint)obj;
            this.saveObjects(out, pickler, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)point.label()), point.features()}));
        }

        public Object construct(Object[] args) {
            if (args.length != 2) {
                throw new PickleException("should be 2");
            }
            return new LabeledPoint(BoxesRunTime.unboxToDouble((Object)args[0]), (Vector)args[1]);
        }

        public LabeledPointPickler() {
            super(ClassTag$.MODULE$.apply(LabeledPoint.class));
        }
    }
}

