/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.stat.test;

import breeze.linalg.DenseMatrix;
import breeze.linalg.Matrix;
import org.apache.commons.math3.distribution.ChiSquaredDistribution;
import org.apache.spark.Logging;
import org.apache.spark.SparkException;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.stat.test.ChiSqTest;
import org.apache.spark.mllib.stat.test.ChiSqTest$;
import org.apache.spark.mllib.stat.test.ChiSqTest$$anonfun$3$;
import org.apache.spark.mllib.stat.test.ChiSqTest$NullHypothesis$;
import org.apache.spark.mllib.stat.test.ChiSqTestResult;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class ChiSqTest$
implements Logging {
    public static final ChiSqTest$ MODULE$;
    private final ChiSqTest.Method PEARSON;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new ChiSqTest$();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public ChiSqTest.Method PEARSON() {
        return this.PEARSON;
    }

    private ChiSqTest.Method methodFromString(String methodName) {
        String string = methodName;
        String string2 = this.PEARSON().name();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            ChiSqTest.Method method = this.PEARSON();
            return method;
        }
        throw new IllegalArgumentException("Unrecognized method for Chi squared test.");
    }

    public ChiSqTestResult[] chiSquaredFeatures(RDD<LabeledPoint> data, String methodName) {
        int maxCategories = 10000;
        int numCols = ((LabeledPoint)data.first()).features().size();
        ChiSqTestResult[] results = new ChiSqTestResult[numCols];
        ObjectRef labels = new ObjectRef(null);
        int batchSize = 1000;
        int batch = 0;
        while (batch * batchSize < numCols) {
            int startCol = batch * batchSize;
            int endCol = startCol + package$.MODULE$.min(batchSize, numCols - startCol);
            Map pairCounts = data.mapPartitions((Function1)new Serializable(maxCategories, startCol, endCol){
                public static final long serialVersionUID = 0L;
                public final int maxCategories$1;
                public final int startCol$1;
                public final int endCol$1;

                public final Iterator<Tuple3<Object, Object, Object>> apply(Iterator<LabeledPoint> iter) {
                    HashSet distinctLabels = HashSet$.MODULE$.empty();
                    scala.collection.immutable.Map allDistinctFeatures = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.startCol$1), this.endCol$1).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<Object, HashSet<Object>> apply(int col) {
                            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)col), (Object)HashSet$.MODULE$.empty());
                        }
                    }, IndexedSeq$.MODULE$.canBuildFrom()));
                    IntRef i = new IntRef(1);
                    return iter.flatMap((Function1)new Serializable(this, distinctLabels, allDistinctFeatures, i){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.3 $outer;
                        private final HashSet distinctLabels$1;
                        public final scala.collection.immutable.Map allDistinctFeatures$1;
                        private final IntRef i$1;

                        public final IndexedSeq<Tuple3<Object, Object, Object>> apply(LabeledPoint x0$1) {
                            LabeledPoint labeledPoint = x0$1;
                            if (labeledPoint != null) {
                                double label = labeledPoint.label();
                                Vector features = labeledPoint.features();
                                if (this.i$1.elem % 1000 == 0) {
                                    if (this.distinctLabels$1.size() > this.$outer.maxCategories$1) {
                                        throw new SparkException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Chi-square test expect factors (categorical values) but "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"found more than ", " distinct label values."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.maxCategories$1)}))).toString());
                                    }
                                    this.allDistinctFeatures$1.foreach((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ anonfun$3$$anonfun$apply$1 $outer;

                                        public final void apply(Tuple2<Object, HashSet<Object>> x0$2) {
                                            Tuple2<Object, HashSet<Object>> tuple2 = x0$2;
                                            if (tuple2 != null) {
                                                int col = tuple2._1$mcI$sp();
                                                HashSet distinctFeatures = (HashSet)tuple2._2();
                                                if (distinctFeatures.size() > this.$outer.org$apache$spark$mllib$stat$test$ChiSqTest$$anonfun$$anonfun$$$outer().maxCategories$1) {
                                                    throw new SparkException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Chi-square test expect factors (categorical values) but "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"found more than ", " distinct values in column ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$mllib$stat$test$ChiSqTest$$anonfun$$anonfun$$$outer().maxCategories$1), BoxesRunTime.boxToInteger((int)col)}))).toString());
                                                }
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                return;
                                            }
                                            throw new MatchError(tuple2);
                                        }
                                        {
                                            if ($outer == null) {
                                                throw new NullPointerException();
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                }
                                ++this.i$1.elem;
                                this.distinctLabels$1.$plus$eq((Object)BoxesRunTime.boxToDouble((double)label));
                                breeze.linalg.Vector<Object> brzFeatures = features.toBreeze();
                                IndexedSeq indexedSeq = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.$outer.startCol$1), this.$outer.endCol$1).map((Function1)new Serializable(this, label, brzFeatures){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun$3$$anonfun$apply$1 $outer;
                                    private final double label$1;
                                    private final breeze.linalg.Vector brzFeatures$1;

                                    public final Tuple3<Object, Object, Object> apply(int col) {
                                        double feature = this.brzFeatures$1.apply$mcID$sp(col);
                                        ((HashSet)this.$outer.allDistinctFeatures$1.apply((Object)BoxesRunTime.boxToInteger((int)col))).$plus$eq((Object)BoxesRunTime.boxToDouble((double)feature));
                                        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)col), (Object)BoxesRunTime.boxToDouble((double)feature), (Object)BoxesRunTime.boxToDouble((double)this.label$1));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                        this.label$1 = label$1;
                                        this.brzFeatures$1 = brzFeatures$1;
                                    }
                                }, IndexedSeq$.MODULE$.canBuildFrom());
                                return indexedSeq;
                            }
                            throw new MatchError((Object)labeledPoint);
                        }

                        public /* synthetic */ anonfun.3 org$apache$spark$mllib$stat$test$ChiSqTest$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.distinctLabels$1 = distinctLabels$1;
                            this.allDistinctFeatures$1 = allDistinctFeatures$1;
                            this.i$1 = i$1;
                        }
                    });
                }
                {
                    this.maxCategories$1 = maxCategories$1;
                    this.startCol$1 = startCol$1;
                    this.endCol$1 = endCol$1;
                }
            }, data.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple3.class)).countByValue(Ordering$.MODULE$.Tuple3((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Double$.MODULE$, (Ordering)Ordering.Double$.MODULE$));
            if ((scala.collection.immutable.Map)labels.elem == null) {
                labels.elem = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps((double[])((TraversableOnce)((TraversableLike)pairCounts.keys().filter((Function1)new Serializable(startCol){
                    public static final long serialVersionUID = 0L;
                    private final int startCol$1;

                    public final boolean apply(Tuple3<Object, Object, Object> x$1) {
                        return BoxesRunTime.unboxToInt((Object)x$1._1()) == this.startCol$1;
                    }
                    {
                        this.startCol$1 = startCol$1;
                    }
                })).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final double apply(Tuple3<Object, Object, Object> x$2) {
                        return BoxesRunTime.unboxToDouble((Object)x$2._3());
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double())).distinct()).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.conforms());
            }
            int numLabels2 = ((scala.collection.immutable.Map)labels.elem).size();
            pairCounts.keys().groupBy((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(Tuple3<Object, Object, Object> x$3) {
                    return BoxesRunTime.unboxToInt((Object)x$3._1());
                }
            }).foreach((Function1)new Serializable(methodName, results, labels, pairCounts, numLabels2){
                public static final long serialVersionUID = 0L;
                private final String methodName$1;
                private final ChiSqTestResult[] results$1;
                public final ObjectRef labels$1;
                public final Map pairCounts$1;
                private final int numLabels$1;

                public final void apply(Tuple2<Object, Iterable<Tuple3<Object, Object, Object>>> x0$3) {
                    Tuple2<Object, Iterable<Tuple3<Object, Object, Object>>> tuple2 = x0$3;
                    if (tuple2 != null) {
                        int col = tuple2._1$mcI$sp();
                        Iterable keys = (Iterable)tuple2._2();
                        scala.collection.immutable.Map features = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps((double[])((TraversableOnce)keys.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final double apply(Tuple3<Object, Object, Object> x$4) {
                                return BoxesRunTime.unboxToDouble((Object)x$4._2());
                            }
                        }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double())).distinct()).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.conforms());
                        int numRows2 = features.size();
                        DenseMatrix.mcD.sp contingency = new DenseMatrix.mcD.sp(numRows2, this.numLabels$1, new double[numRows2 * this.numLabels$1]);
                        keys.foreach((Function1)new Serializable(this, col, features, (DenseMatrix)contingency){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.chiSquaredFeatures.4 $outer;
                            private final int col$1;
                            private final scala.collection.immutable.Map features$1;
                            private final DenseMatrix contingency$1;

                            public final void apply(Tuple3<Object, Object, Object> x0$4) {
                                Tuple3<Object, Object, Object> tuple3 = x0$4;
                                if (tuple3 != null) {
                                    double feature = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                                    double label = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                                    int i = BoxesRunTime.unboxToInt((Object)this.features$1.apply((Object)BoxesRunTime.boxToDouble((double)feature)));
                                    int j = BoxesRunTime.unboxToInt((Object)((scala.collection.immutable.Map)this.$outer.labels$1.elem).apply((Object)BoxesRunTime.boxToDouble((double)label)));
                                    this.contingency$1.update$mcD$sp(i, j, this.contingency$1.apply$mcD$sp(i, j) + (double)BoxesRunTime.unboxToLong((Object)this.$outer.pairCounts$1.apply((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)this.col$1), (Object)BoxesRunTime.boxToDouble((double)feature), (Object)BoxesRunTime.boxToDouble((double)label)))));
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                                throw new MatchError(tuple3);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.col$1 = col$1;
                                this.features$1 = features$1;
                                this.contingency$1 = contingency$1;
                            }
                        });
                        this.results$1[col] = ChiSqTest$.MODULE$.chiSquaredMatrix(Matrices$.MODULE$.fromBreeze((Matrix<Object>)contingency), this.methodName$1);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.methodName$1 = methodName$1;
                    this.results$1 = results$1;
                    this.labels$1 = labels$1;
                    this.pairCounts$1 = pairCounts$1;
                    this.numLabels$1 = numLabels$1;
                }
            });
            ++batch;
        }
        return results;
    }

    public ChiSqTestResult chiSquared(Vector observed, Vector expected, String methodName) {
        NonLocalReturnControl nonLocalReturnControl2;
        block7: {
            ChiSqTestResult chiSqTestResult;
            Object object = new Object();
            try {
                double[] expArr;
                ChiSqTest.Method method = this.methodFromString(methodName);
                if (expected.size() != 0 && observed.size() != expected.size()) {
                    throw new IllegalArgumentException("observed and expected must be of the same size.");
                }
                int size = observed.size();
                if (size > 1000) {
                    this.logWarning((Function0<String>)new Serializable(size){
                        public static final long serialVersionUID = 0L;
                        private final int size$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Chi-squared approximation may not be accurate due to low expected frequencies ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" as a result of a large number of categories: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.size$1)}))).toString();
                        }
                        {
                            this.size$1 = size$1;
                        }
                    });
                }
                double[] obsArr = observed.toArray();
                double[] dArray = expArr = expected.size() == 0 ? (double[])Array$.MODULE$.tabulate(size, (Function1)new Serializable(size){
                    public static final long serialVersionUID = 0L;
                    private final int size$1;

                    public final double apply(int x$5) {
                        return this.apply$mcDI$sp(x$5);
                    }

                    public double apply$mcDI$sp(int x$5) {
                        return 1.0 / (double)this.size$1;
                    }
                    {
                        this.size$1 = size$1;
                    }
                }, ClassTag$.MODULE$.Double()) : expected.toArray();
                if (Predef$.MODULE$.doubleArrayOps(obsArr).forall((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(double x$6) {
                        return this.apply$mcZD$sp(x$6);
                    }

                    public boolean apply$mcZD$sp(double x$6) {
                        return x$6 >= 0.0;
                    }
                })) {
                    if (expected.size() != 0 && !Predef$.MODULE$.doubleArrayOps(expArr).forall((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(double x$7) {
                            return this.apply$mcZD$sp(x$7);
                        }

                        public boolean apply$mcZD$sp(double x$7) {
                            return x$7 >= 0.0;
                        }
                    })) {
                        throw new IllegalArgumentException("Negative entries disallowed in the expected vector.");
                    }
                } else {
                    throw new IllegalArgumentException("Negative entries disallowed in the observed vector.");
                }
                double obsSum = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(obsArr).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
                double expSum = (double)expected.size() == 0.0 ? 1.0 : BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(expArr).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
                double scale = package$.MODULE$.abs(obsSum - expSum) < 1.0E-7 ? 1.0 : obsSum / expSum;
                double statistic = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(obsArr).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(expArr), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)new Serializable(method, size, scale, object){
                    public static final long serialVersionUID = 0L;
                    private final ChiSqTest.Method method$1;
                    private final int size$1;
                    private final double scale$1;
                    private final Object nonLocalReturnKey1$1;

                    public final double apply(double x0$5, Tuple2<Object, Object> x1$1) {
                        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)x0$5), x1$1);
                        if (tuple2 != null) {
                            double stat = tuple2._1$mcD$sp();
                            Tuple2 tuple22 = (Tuple2)tuple2._2();
                            if (tuple22 != null) {
                                double obs = tuple22._1$mcD$sp();
                                double exp = tuple22._2$mcD$sp();
                                if (exp == 0.0) {
                                    if (obs == 0.0) {
                                        throw new IllegalArgumentException("Chi-squared statistic undefined for input vectors due to 0.0 values in both observed and expected.");
                                    }
                                    throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)new ChiSqTestResult(0.0, this.size$1 - 1, Double.POSITIVE_INFINITY, ChiSqTest$.MODULE$.PEARSON().name(), ChiSqTest$NullHypothesis$.MODULE$.goodnessOfFit().toString()));
                                }
                                double d = this.scale$1 == 1.0 ? stat + this.method$1.chiSqFunc().apply$mcDDD$sp(obs, exp) : stat + this.method$1.chiSqFunc().apply$mcDDD$sp(obs, exp * this.scale$1);
                                return d;
                            }
                        }
                        throw new MatchError((Object)tuple2);
                    }
                    {
                        this.method$1 = method$1;
                        this.size$1 = size$1;
                        this.scale$1 = scale$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                }));
                int df = size - 1;
                double pValue = 1.0 - new ChiSquaredDistribution((double)df).cumulativeProbability(statistic);
                chiSqTestResult = new ChiSqTestResult(pValue, df, statistic, this.PEARSON().name(), ChiSqTest$NullHypothesis$.MODULE$.goodnessOfFit().toString());
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block7;
                chiSqTestResult = (ChiSqTestResult)nonLocalReturnControl2.value();
            }
            return chiSqTestResult;
        }
        throw nonLocalReturnControl2;
    }

    public Vector chiSquared$default$2() {
        return Vectors$.MODULE$.dense((double[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Double()));
    }

    public String chiSquared$default$3() {
        return this.PEARSON().name();
    }

    public String chiSquaredFeatures$default$2() {
        return this.PEARSON().name();
    }

    public ChiSqTestResult chiSquaredMatrix(org.apache.spark.mllib.linalg.Matrix counts, String methodName) {
        ChiSqTestResult chiSqTestResult;
        ChiSqTest.Method method = this.methodFromString(methodName);
        int numRows2 = counts.numRows();
        int numCols = counts.numCols();
        double[] colSums = new double[numCols];
        double[] rowSums = new double[numRows2];
        double[] colMajorArr = counts.toArray();
        int colMajorArrLen = colMajorArr.length;
        for (int i = 0; i < colMajorArrLen; ++i) {
            double elem = colMajorArr[i];
            if (elem < 0.0) {
                throw new IllegalArgumentException("Contingency table cannot contain negative entries.");
            }
            int n = i / numRows2;
            colSums[n] = colSums[n] + elem;
            int n2 = i % numRows2;
            rowSums[n2] = rowSums[n2] + elem;
        }
        double total = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(colSums).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        double statistic = 0.0;
        for (int j = 0; j < colMajorArrLen; ++j) {
            int col = j / numRows2;
            double colSum = colSums[col];
            if (colSum == 0.0) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"Chi-squared statistic undefined for input matrix due to").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0 sum in column [", "]."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)col)}))).toString());
            }
            int row = j % numRows2;
            double rowSum = rowSums[row];
            if (rowSum == 0.0) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"Chi-squared statistic undefined for input matrix due to").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0 sum in row [", "]."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)row)}))).toString());
            }
            double expected = colSum * rowSum / total;
            statistic += method.chiSqFunc().apply$mcDDD$sp(colMajorArr[j], expected);
        }
        int df = (numCols - 1) * (numRows2 - 1);
        if (df == 0) {
            chiSqTestResult = new ChiSqTestResult(1.0, 0, 0.0, methodName, ChiSqTest$NullHypothesis$.MODULE$.independence().toString());
        } else {
            double pValue = 1.0 - new ChiSquaredDistribution((double)df).cumulativeProbability(statistic);
            chiSqTestResult = new ChiSqTestResult(pValue, df, statistic, methodName, ChiSqTest$NullHypothesis$.MODULE$.independence().toString());
        }
        return chiSqTestResult;
    }

    public String chiSquaredMatrix$default$2() {
        return this.PEARSON().name();
    }

    private ChiSqTest$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.PEARSON = new ChiSqTest.Method("pearson", (Function2<Object, Object, Object>)new anonfun.1());
    }
}

