/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg;

import breeze.linalg.DenseVector;
import org.apache.spark.mllib.linalg.DenseVector$;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vector$class;
import org.apache.spark.mllib.linalg.VectorUDT;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.sql.types.SQLUserDefinedType;
import org.json4s.JsonAST;
import org.json4s.JsonDSL$;
import org.json4s.jackson.JsonMethods$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Traversable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@SQLUserDefinedType(udt=VectorUDT.class)
@ScalaSignature(bytes="\u0006\u0001\u0005=d\u0001B\u0001\u0003\u00015\u00111\u0002R3og\u00164Vm\u0019;pe*\u00111\u0001B\u0001\u0007Y&t\u0017\r\\4\u000b\u0005\u00151\u0011!B7mY&\u0014'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0004\u000b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\t)b#D\u0001\u0003\u0013\t9\"A\u0001\u0004WK\u000e$xN\u001d\u0005\t3\u0001\u0011)\u0019!C\u00015\u00051a/\u00197vKN,\u0012a\u0007\t\u0004\u001fqq\u0012BA\u000f\u0011\u0005\u0015\t%O]1z!\tyq$\u0003\u0002!!\t1Ai\\;cY\u0016D3\u0001\u0007\u0012)!\t\u0019c%D\u0001%\u0015\t)c!\u0001\u0006b]:|G/\u0019;j_:L!a\n\u0013\u0003\u000bMKgnY3\"\u0003%\nQ!\r\u00181]AB\u0001b\u000b\u0001\u0003\u0002\u0003\u0006IaG\u0001\bm\u0006dW/Z:!Q\rQ#\u0005\u000b\u0005\u0006]\u0001!\taL\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005A\n\u0004CA\u000b\u0001\u0011\u0015IR\u00061\u0001\u001cQ\r\t$\u0005\u000b\u0015\u0004[\tB\u0003\"B\u001b\u0001\t\u00032\u0014\u0001B:ju\u0016,\u0012a\u000e\t\u0003\u001faJ!!\u000f\t\u0003\u0007%sG\u000fK\u00025E!BQ\u0001\u0010\u0001\u0005Bu\n\u0001\u0002^8TiJLgn\u001a\u000b\u0002}A\u0011qH\u0011\b\u0003\u001f\u0001K!!\u0011\t\u0002\rA\u0013X\rZ3g\u0013\t\u0019EI\u0001\u0004TiJLgn\u001a\u0006\u0003\u0003BAQA\u0012\u0001\u0005Bi\tq\u0001^8BeJ\f\u0017\u0010K\u0002FE!Ba!\u0013\u0001\u0005B\u0019Q\u0015\u0001\u0003;p\u0005J,WM_3\u0016\u0003-\u00032\u0001\u0014)\u001f\u001b\u0005i%BA\u0002O\u0015\u0005y\u0015A\u00022sK\u0016TX-\u0003\u0002\u0018\u001b\")!\u000b\u0001C!'\u0006)\u0011\r\u001d9msR\u0011a\u0004\u0016\u0005\u0006+F\u0003\raN\u0001\u0002S\"\u001a\u0011K\t\u0015\t\u000ba\u0003A\u0011I-\u0002\t\r|\u0007/_\u000b\u0002a!\u001aqKI.\"\u0003q\u000bQ!\r\u00182]ABQA\u0018\u0001\u0005B}\u000bQBZ8sK\u0006\u001c\u0007.Q2uSZ,GC\u00011d!\ty\u0011-\u0003\u0002c!\t!QK\\5u\u0011\u0015!W\f1\u0001f\u0003\u00051\u0007#B\bgoy\u0001\u0017BA4\u0011\u0005%1UO\\2uS>t'\u0007K\u0002^E%\f\u0013A[\u0001\u0006c92d\u0006\r\u0005\u0006Y\u0002!\t%\\\u0001\tQ\u0006\u001c\bnQ8eKR\tq\u0007C\u0003p\u0001\u0011\u0005c'\u0001\u0006ok6\f5\r^5wKND3A\u001c\u0012rC\u0005\u0011\u0018!B\u0019/i9\u0002\u0004\"\u0002;\u0001\t\u00032\u0014a\u00038v[:{gN_3s_ND3a\u001d\u0012r\u0011\u00159\b\u0001\"\u0011y\u0003!!xn\u00159beN,W#A=\u0011\u0005UQ\u0018BA>\u0003\u00051\u0019\u0006/\u0019:tKZ+7\r^8sQ\r1(%\u001d\u0005\u0006}\u0002!\tEN\u0001\u0007CJ<W.\u0019=)\tu\u0014\u0013\u0011A\u0011\u0003\u0003\u0007\tQ!\r\u00186]ABq!a\u0002\u0001\t\u0003\nI!\u0001\u0004u_*\u001bxN\\\u000b\u0002}!\"\u0011Q\u0001\u0012jQ\u001d\u0001\u0011qBA\u0010\u0003C\u0001B!!\u0005\u0002\u001c5\u0011\u00111\u0003\u0006\u0005\u0003+\t9\"A\u0003usB,7OC\u0002\u0002\u001a\u0019\t1a]9m\u0013\u0011\ti\"a\u0005\u0003%M\u000bF*V:fe\u0012+g-\u001b8fIRK\b/Z\u0001\u0004k\u0012$8EAA\u0012!\r)\u0012QE\u0005\u0004\u0003O\u0011!!\u0003,fGR|'/\u0016#UQ\r\u0001!\u0005K\u0004\b\u0003[\u0011\u0001\u0012AA\u0018\u0003-!UM\\:f-\u0016\u001cGo\u001c:\u0011\u0007U\t\tD\u0002\u0004\u0002\u0005!\u0005\u00111G\n\u0006\u0003cq\u0011Q\u0007\t\u0004\u001f\u0005]\u0012bAA\u001d!\ta1+\u001a:jC2L'0\u00192mK\"9a&!\r\u0005\u0002\u0005uBCAA\u0018\u0011!\t\t%!\r\u0005\u0002\u0005\r\u0013aB;oCB\u0004H.\u001f\u000b\u0005\u0003\u000b\nY\u0005\u0005\u0003\u0010\u0003\u000fZ\u0012bAA%!\t1q\n\u001d;j_:Dq!!\u0014\u0002@\u0001\u0007\u0001'\u0001\u0002em\"*\u0011q\b\u0012\u0002R\u0005\u0012\u00111K\u0001\u0006c9\u001ad\u0006\r\u0005\u000b\u0003/\n\t$!A\u0005\n\u0005e\u0013a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a\u0017\u0011\t\u0005u\u0013qM\u0007\u0003\u0003?RA!!\u0019\u0002d\u0005!A.\u00198h\u0015\t\t)'\u0001\u0003kCZ\f\u0017\u0002BA5\u0003?\u0012aa\u00142kK\u000e$\b&BA\u0019E\u0005E\u0003&BA\u0016E\u0005E\u0003")
public class DenseVector
implements Vector {
    private final double[] values;

    public static Option<double[]> unapply(DenseVector denseVector) {
        return DenseVector$.MODULE$.unapply(denseVector);
    }

    @Override
    public boolean equals(Object other) {
        return Vector$class.equals(this, other);
    }

    @Override
    public DenseVector toDense() {
        return Vector$class.toDense(this);
    }

    @Override
    public Vector compressed() {
        return Vector$class.compressed(this);
    }

    public double[] values() {
        return this.values;
    }

    @Override
    public int size() {
        return this.values().length;
    }

    public String toString() {
        return Predef$.MODULE$.doubleArrayOps(this.values()).mkString("[", ",", "]");
    }

    @Override
    public double[] toArray() {
        return this.values();
    }

    @Override
    public breeze.linalg.Vector<Object> toBreeze() {
        return new DenseVector.mcD.sp(this.values());
    }

    @Override
    public double apply(int i) {
        return this.values()[i];
    }

    @Override
    public DenseVector copy() {
        return new DenseVector((double[])this.values().clone());
    }

    @Override
    public void foreachActive(Function2<Object, Object, BoxedUnit> f) {
        int localValuesSize = this.values().length;
        double[] localValues = this.values();
        for (int i = 0; i < localValuesSize; ++i) {
            f.apply$mcVID$sp(i, localValues[i]);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        void var1_1;
        int result = 31 + this.size();
        int end = this.values().length;
        int nnz = 0;
        for (int i = 0; i < end && nnz < Vectors$.MODULE$.MAX_HASH_NNZ(); ++i) {
            double v = this.values()[i];
            if (v == 0.0) continue;
            result = 31 * result + i;
            long bits = Double.doubleToLongBits(this.values()[i]);
            result = 31 * result + (int)(bits ^ bits >>> 32);
            ++nnz;
        }
        return (int)var1_1;
    }

    @Override
    public int numActives() {
        return this.size();
    }

    @Override
    public int numNonzeros() {
        IntRef nnz = new IntRef(0);
        Predef$.MODULE$.doubleArrayOps(this.values()).foreach((Function1)new Serializable(this, nnz){
            public static final long serialVersionUID = 0L;
            private final IntRef nnz$2;

            public final void apply(double v) {
                this.apply$mcVD$sp(v);
            }

            public void apply$mcVD$sp(double v) {
                if (v != 0.0) {
                    ++this.nnz$2.elem;
                }
            }
            {
                this.nnz$2 = nnz$2;
            }
        });
        return nnz.elem;
    }

    @Override
    public SparseVector toSparse() {
        int nnz = this.numNonzeros();
        int[] ii = new int[nnz];
        double[] vv = new double[nnz];
        IntRef k = new IntRef(0);
        this.foreachActive((Function2<Object, Object, BoxedUnit>)new Serializable(this, ii, vv, k){
            public static final long serialVersionUID = 0L;
            private final int[] ii$1;
            private final double[] vv$1;
            private final IntRef k$1;

            public final void apply(int i, double v) {
                this.apply$mcVID$sp(i, v);
            }

            public void apply$mcVID$sp(int i, double v) {
                if (v != 0.0) {
                    this.ii$1[this.k$1.elem] = i;
                    this.vv$1[this.k$1.elem] = v;
                    ++this.k$1.elem;
                }
            }
            {
                this.ii$1 = ii$1;
                this.vv$1 = vv$1;
                this.k$1 = k$1;
            }
        });
        return new SparseVector(this.size(), ii, vv);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int argmax() {
        int n;
        if (this.size() == 0) {
            n = -1;
        } else {
            void var1_1;
            int maxIdx = 0;
            double maxValue = this.values()[0];
            for (int i = 1; i < this.size(); ++i) {
                if (!(this.values()[i] > maxValue)) continue;
                maxIdx = i;
                maxValue = this.values()[i];
            }
            n = var1_1;
        }
        return n;
    }

    @Override
    public String toJson() {
        JsonAST.JObject jValue = JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"type"), (Object)BoxesRunTime.boxToInteger((int)1)), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JValue apply(int x) {
                return JsonDSL$.MODULE$.int2jvalue(x);
            }
        }).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"values"), (Object)Predef$.MODULE$.doubleArrayOps(this.values()).toSeq()), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final JsonAST.JArray apply(Traversable<Object> s) {
                return JsonDSL$.MODULE$.seq2jvalue(s, (Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final JsonAST.JValue apply(double x) {
                        return JsonDSL$.MODULE$.double2jvalue(x);
                    }
                });
            }
        });
        return JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JsonAST.JValue)jValue));
    }

    public DenseVector(double[] values) {
        this.values = values;
        Vector$class.$init$(this);
    }
}

