/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import breeze.stats.distributions.RandBasis;
import breeze.stats.distributions.StudentsT;
import breeze.stats.distributions.StudentsT$;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.regression.LinearRegressionModel;
import org.apache.spark.ml.regression.LinearRegressionSummary$;
import org.apache.spark.mllib.evaluation.RegressionMetrics;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.TypeTags;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005d\u0001B\u0001\u0003\u00015\u0011q\u0003T5oK\u0006\u0014(+Z4sKN\u001c\u0018n\u001c8Tk6l\u0017M]=\u000b\u0005\r!\u0011A\u0003:fOJ,7o]5p]*\u0011QAB\u0001\u0003[2T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\r\u0001a\u0002\u0006\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=)\u0012B\u0001\f\u0011\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!A\u0002A!b\u0001\n\u0003I\u0012a\u00039sK\u0012L7\r^5p]N,\u0012A\u0007\t\u00037yi\u0011\u0001\b\u0006\u0003;\u0019\t1a]9m\u0013\tyBDA\u0005ECR\fgI]1nK\"A\u0011\u0005\u0001B\u0001B\u0003%!$\u0001\u0007qe\u0016$\u0017n\u0019;j_:\u001c\b\u0005\u000b\u0002!GA\u0011q\u0002J\u0005\u0003KA\u0011\u0011\u0002\u001e:b]NLWM\u001c;\t\u0011\u001d\u0002!Q1A\u0005\u0002!\nQ\u0002\u001d:fI&\u001cG/[8o\u0007>dW#A\u0015\u0011\u0005)jcBA\b,\u0013\ta\u0003#\u0001\u0004Qe\u0016$WMZ\u0005\u0003]=\u0012aa\u0015;sS:<'B\u0001\u0017\u0011\u0011!\t\u0004A!A!\u0002\u0013I\u0013A\u00049sK\u0012L7\r^5p]\u000e{G\u000e\t\u0005\tg\u0001\u0011)\u0019!C\u0001Q\u0005AA.\u00192fY\u000e{G\u000e\u0003\u00056\u0001\t\u0005\t\u0015!\u0003*\u0003%a\u0017MY3m\u0007>d\u0007\u0005\u0003\u00058\u0001\t\u0015\r\u0011\"\u00019\u0003\u0015iw\u000eZ3m+\u0005I\u0004C\u0001\u001e<\u001b\u0005\u0011\u0011B\u0001\u001f\u0003\u0005Ua\u0015N\\3beJ+wM]3tg&|g.T8eK2D\u0001B\u0010\u0001\u0003\u0002\u0003\u0006I!O\u0001\u0007[>$W\r\u001c\u0011\t\u0011\u0001\u0003!Q1A\u0005\n\u0005\u000b1\u0002Z5bO&sg/\u0011;X\u0003V\t!\tE\u0002\u0010\u0007\u0016K!\u0001\u0012\t\u0003\u000b\u0005\u0013(/Y=\u0011\u0005=1\u0015BA$\u0011\u0005\u0019!u.\u001e2mK\"A\u0011\n\u0001B\u0001B\u0003%!)\u0001\u0007eS\u0006<\u0017J\u001c<Bi^\u000b\u0005\u0005\u0003\u0004L\u0001\u0011\u0005!\u0001T\u0001\u0007y%t\u0017\u000e\u001e \u0015\r5su\nU)S!\tQ\u0004\u0001C\u0003\u0019\u0015\u0002\u0007!\u0004C\u0003(\u0015\u0002\u0007\u0011\u0006C\u00034\u0015\u0002\u0007\u0011\u0006C\u00038\u0015\u0002\u0007\u0011\bC\u0003A\u0015\u0002\u0007!\tC\u0004U\u0001\t\u0007I\u0011B+\u0002\u000f5,GO]5dgV\ta\u000b\u0005\u0002X96\t\u0001L\u0003\u0002Z5\u0006QQM^1mk\u0006$\u0018n\u001c8\u000b\u0005m3\u0011!B7mY&\u0014\u0017BA/Y\u0005E\u0011Vm\u001a:fgNLwN\\'fiJL7m\u001d\u0005\u0007?\u0002\u0001\u000b\u0011\u0002,\u0002\u00115,GO]5dg\u0002B#AX\u0012\t\u000f\t\u0004!\u0019!C\u0001G\u0006\tR\r\u001f9mC&tW\r\u001a,be&\fgnY3\u0016\u0003\u0015C3!Y3l!\t1\u0017.D\u0001h\u0015\tAg!\u0001\u0006b]:|G/\u0019;j_:L!A[4\u0003\u000bMKgnY3\"\u00031\fQ!\r\u00186]ABaA\u001c\u0001!\u0002\u0013)\u0015AE3ya2\f\u0017N\\3e-\u0006\u0014\u0018.\u00198dK\u0002B3!\\3l\u0011\u001d\t\bA1A\u0005\u0002\r\f\u0011#\\3b]\u0006\u00137o\u001c7vi\u0016,%O]8sQ\r\u0001Xm\u001b\u0005\u0007i\u0002\u0001\u000b\u0011B#\u0002%5,\u0017M\\!cg>dW\u000f^3FeJ|'\u000f\t\u0015\u0004g\u0016\\\u0007bB<\u0001\u0005\u0004%\taY\u0001\u0011[\u0016\fgnU9vCJ,G-\u0012:s_JD3A^3l\u0011\u0019Q\b\u0001)A\u0005\u000b\u0006\tR.Z1o'F,\u0018M]3e\u000bJ\u0014xN\u001d\u0011)\u0007e,7\u000eC\u0004~\u0001\t\u0007I\u0011A2\u0002)I|w\u000e^'fC:\u001c\u0016/^1sK\u0012,%O]8sQ\raXm\u001b\u0005\b\u0003\u0003\u0001\u0001\u0015!\u0003F\u0003U\u0011xn\u001c;NK\u0006t7+];be\u0016$WI\u001d:pe\u0002B3a`3l\u0011!\t9\u0001\u0001b\u0001\n\u0003\u0019\u0017A\u0001:3Q\u0011\t)!Z6\t\u000f\u00055\u0001\u0001)A\u0005\u000b\u0006\u0019!O\r\u0011)\t\u0005-Qm\u001b\u0005\n\u0003'\u0001\u0001R1A\u0005\u0002e\t\u0011B]3tS\u0012,\u0018\r\\:)\t\u0005EQm\u001b\u0005\n\u00033\u0001\u0001\u0012!Q!\ni\t!B]3tS\u0012,\u0018\r\\:!Q\r\t9b\t\u0015\u0005\u0003/)7\u000e\u0003\u0006\u0002\"\u0001A)\u0019!C\u0001\u0003G\tAB\\;n\u0013:\u001cH/\u00198dKN,\"!!\n\u0011\u0007=\t9#C\u0002\u0002*A\u0011A\u0001T8oO\"Q\u0011Q\u0006\u0001\t\u0002\u0003\u0006K!!\n\u0002\u001b9,X.\u00138ti\u0006t7-Z:!\u0011%\t\t\u0004\u0001b\u0001\n\u0013\t\u0019#\u0001\teK\u001e\u0014X-Z:PM\u001a\u0013X-\u001a3p[\"A\u0011Q\u0007\u0001!\u0002\u0013\t)#A\teK\u001e\u0014X-Z:PM\u001a\u0013X-\u001a3p[\u0002B\u0011\"!\u000f\u0001\u0011\u000b\u0007I\u0011A!\u0002#\u0011,g/[1oG\u0016\u0014Vm]5ek\u0006d7\u000fC\u0005\u0002>\u0001A\t\u0011)Q\u0005\u0005\u0006\u0011B-\u001a<jC:\u001cWMU3tS\u0012,\u0018\r\\:!\u0011%\t\t\u0005\u0001EC\u0002\u0013\u0005\u0011)A\rd_\u00164g-[2jK:$8\u000b^1oI\u0006\u0014H-\u0012:s_J\u001c\b\"CA#\u0001!\u0005\t\u0015)\u0003C\u0003i\u0019w.\u001a4gS\u000eLWM\u001c;Ti\u0006tG-\u0019:e\u000bJ\u0014xN]:!\u0011%\tI\u0005\u0001EC\u0002\u0013\u0005\u0011)A\u0004u-\u0006dW/Z:\t\u0013\u00055\u0003\u0001#A!B\u0013\u0011\u0015\u0001\u0003;WC2,Xm\u001d\u0011\t\u0013\u0005E\u0003\u0001#b\u0001\n\u0003\t\u0015a\u00029WC2,Xm\u001d\u0005\n\u0003+\u0002\u0001\u0012!Q!\n\t\u000b\u0001\u0002\u001d,bYV,7\u000f\t\u0015\u0004\u0001\u0005e\u0003c\u00014\u0002\\%\u0019\u0011QL4\u0003\u0019\u0015C\b/\u001a:j[\u0016tG/\u00197)\u0007\u0001)7\u000e")
public class LinearRegressionSummary
implements Serializable {
    private final transient DataFrame predictions;
    private final String predictionCol;
    private final String labelCol;
    private final LinearRegressionModel model;
    private final double[] diagInvAtWA;
    private final transient RegressionMetrics metrics;
    private final double explainedVariance;
    private final double meanAbsoluteError;
    private final double meanSquaredError;
    private final double rootMeanSquaredError;
    private final double r2;
    private transient DataFrame residuals;
    private long numInstances;
    private final long org$apache$spark$ml$regression$LinearRegressionSummary$$degreesOfFreedom;
    private double[] devianceResiduals;
    private double[] coefficientStandardErrors;
    private double[] tValues;
    private double[] pValues;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    private DataFrame residuals$lzycompute() {
        LinearRegressionSummary linearRegressionSummary = this;
        synchronized (linearRegressionSummary) {
            if (!this.bitmap$trans$0) {
                UserDefinedFunction t = functions$.MODULE$.udf((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double pred, double label) {
                        return this.apply$mcDDD$sp(pred, label);
                    }

                    public double apply$mcDDD$sp(double pred, double label) {
                        return label - pred;
                    }
                }, ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double());
                this.residuals = this.predictions().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{t.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.predictionCol()), functions$.MODULE$.col(this.labelCol())})).as("residuals")}));
                this.bitmap$trans$0 = true;
            }
            return this.residuals;
        }
    }

    private long numInstances$lzycompute() {
        LinearRegressionSummary linearRegressionSummary = this;
        synchronized (linearRegressionSummary) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.numInstances = this.predictions().count();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.numInstances;
        }
    }

    private double[] devianceResiduals$lzycompute() {
        LinearRegressionSummary linearRegressionSummary = this;
        synchronized (linearRegressionSummary) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                Column weighted = this.model().getWeightCol().isEmpty() ? functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)1.0)) : functions$.MODULE$.sqrt(functions$.MODULE$.col(this.model().getWeightCol()));
                Row dr = this.predictions().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.model().getLabelCol()).minus((Object)functions$.MODULE$.col(this.model().getPredictionCol())).multiply((Object)weighted).as("weightedResiduals")})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.min(functions$.MODULE$.col("weightedResiduals")).as("min"), functions$.MODULE$.max(functions$.MODULE$.col("weightedResiduals")).as("max")})).first();
                this.devianceResiduals = new double[]{dr.getDouble(0), dr.getDouble(1)};
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.devianceResiduals;
        }
    }

    private double[] coefficientStandardErrors$lzycompute() {
        LinearRegressionSummary linearRegressionSummary = this;
        synchronized (linearRegressionSummary) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                double d;
                if (this.diagInvAtWA().length == 1 && this.diagInvAtWA()[0] == 0.0) {
                    throw new UnsupportedOperationException("No Std. Error of coefficients available for this LinearRegressionModel");
                }
                if (this.model().getWeightCol().isEmpty()) {
                    d = this.meanSquaredError() * (double)this.numInstances();
                } else {
                    UserDefinedFunction t = functions$.MODULE$.udf((Function3)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final double apply(double pred, double label, double weight) {
                            return scala.math.package$.MODULE$.pow(label - pred, 2.0) * weight;
                        }
                    }, ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double());
                    d = this.predictions().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{t.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.model().getPredictionCol()), functions$.MODULE$.col(this.model().getLabelCol()), functions$.MODULE$.col(this.model().getWeightCol())})).as("wse")})).agg(functions$.MODULE$.sum(functions$.MODULE$.col("wse")), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0])).first().getDouble(0);
                }
                double rss = d;
                double sigma2 = rss / (double)this.org$apache$spark$ml$regression$LinearRegressionSummary$$degreesOfFreedom();
                this.coefficientStandardErrors = (double[])Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps(this.diagInvAtWA()).map((Function1)new Serializable(this, sigma2){
                    public static final long serialVersionUID = 0L;
                    private final double sigma2$1;

                    public final double apply(double x$7) {
                        return this.apply$mcDD$sp(x$7);
                    }

                    public double apply$mcDD$sp(double x$7) {
                        return x$7 * this.sigma2$1;
                    }
                    {
                        this.sigma2$1 = sigma2$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double x$8) {
                        return this.apply$mcDD$sp(x$8);
                    }

                    public double apply$mcDD$sp(double x$8) {
                        return scala.math.package$.MODULE$.sqrt(x$8);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.coefficientStandardErrors;
        }
    }

    private double[] tValues$lzycompute() {
        LinearRegressionSummary linearRegressionSummary = this;
        synchronized (linearRegressionSummary) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                if (this.diagInvAtWA().length == 1 && this.diagInvAtWA()[0] == 0.0) {
                    throw new UnsupportedOperationException("No t-statistic available for this LinearRegressionModel");
                }
                double[] estimate2 = this.model().getFitIntercept() ? (double[])Array$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new double[][]{this.model().coefficients().toArray(), {this.model().intercept()}}), ClassTag$.MODULE$.Double()) : this.model().coefficients().toArray();
                this.tValues = (double[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(estimate2).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(this.coefficientStandardErrors()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(Tuple2<Object, Object> x) {
                        return x._1$mcD$sp() / x._2$mcD$sp();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
            return this.tValues;
        }
    }

    private double[] pValues$lzycompute() {
        LinearRegressionSummary linearRegressionSummary = this;
        synchronized (linearRegressionSummary) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                if (this.diagInvAtWA().length == 1 && this.diagInvAtWA()[0] == 0.0) {
                    throw new UnsupportedOperationException("No p-value available for this LinearRegressionModel");
                }
                this.pValues = (double[])Predef$.MODULE$.doubleArrayOps(this.tValues()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ LinearRegressionSummary $outer;

                    public final double apply(double x) {
                        return this.apply$mcDD$sp(x);
                    }

                    public double apply$mcDD$sp(double x) {
                        double x$14 = this.$outer.org$apache$spark$ml$regression$LinearRegressionSummary$$degreesOfFreedom();
                        RandBasis x$15 = StudentsT$.MODULE$.apply$default$2(x$14);
                        return 2.0 * (1.0 - new StudentsT(x$14, x$15).cdf(scala.math.package$.MODULE$.abs(x)));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
            return this.pValues;
        }
    }

    public DataFrame predictions() {
        return this.predictions;
    }

    public String predictionCol() {
        return this.predictionCol;
    }

    public String labelCol() {
        return this.labelCol;
    }

    public LinearRegressionModel model() {
        return this.model;
    }

    private double[] diagInvAtWA() {
        return this.diagInvAtWA;
    }

    private RegressionMetrics metrics() {
        return this.metrics;
    }

    public double explainedVariance() {
        return this.explainedVariance;
    }

    public double meanAbsoluteError() {
        return this.meanAbsoluteError;
    }

    public double meanSquaredError() {
        return this.meanSquaredError;
    }

    public double rootMeanSquaredError() {
        return this.rootMeanSquaredError;
    }

    public double r2() {
        return this.r2;
    }

    public DataFrame residuals() {
        return this.bitmap$trans$0 ? this.residuals : this.residuals$lzycompute();
    }

    public long numInstances() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.numInstances$lzycompute() : this.numInstances;
    }

    public long org$apache$spark$ml$regression$LinearRegressionSummary$$degreesOfFreedom() {
        return this.org$apache$spark$ml$regression$LinearRegressionSummary$$degreesOfFreedom;
    }

    public double[] devianceResiduals() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.devianceResiduals$lzycompute() : this.devianceResiduals;
    }

    public double[] coefficientStandardErrors() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.coefficientStandardErrors$lzycompute() : this.coefficientStandardErrors;
    }

    public double[] tValues() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.tValues$lzycompute() : this.tValues;
    }

    public double[] pValues() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.pValues$lzycompute() : this.pValues;
    }

    public LinearRegressionSummary(DataFrame predictions, String predictionCol, String labelCol, LinearRegressionModel model, double[] diagInvAtWA) {
        this.predictions = predictions;
        this.predictionCol = predictionCol;
        this.labelCol = labelCol;
        this.model = model;
        this.diagInvAtWA = diagInvAtWA;
        this.metrics = new RegressionMetrics((RDD<Tuple2<Object, Object>>)predictions.select(predictionCol, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{labelCol})).map((Function1)new $anonfun$10(this), ClassTag$.MODULE$.apply(Tuple2.class)));
        this.explainedVariance = this.metrics().explainedVariance();
        this.meanAbsoluteError = this.metrics().meanAbsoluteError();
        this.meanSquaredError = this.metrics().meanSquaredError();
        this.rootMeanSquaredError = this.metrics().rootMeanSquaredError();
        this.r2 = this.metrics().r2();
        this.org$apache$spark$ml$regression$LinearRegressionSummary$$degreesOfFreedom = model.getFitIntercept() ? this.numInstances() - (long)model.coefficients().size() - 1L : this.numInstances() - (long)model.coefficients().size();
    }
}

