/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg.distributed;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.LU;
import breeze.linalg.MatrixSingularException;
import breeze.linalg.NumericOps;
import breeze.linalg.Tensor$;
import breeze.linalg.Transpose$;
import breeze.linalg.Vector$;
import breeze.linalg.inv$;
import breeze.linalg.qr;
import breeze.linalg.svd;
import breeze.linalg.svd$;
import breeze.numerics.package;
import breeze.storage.Zero;
import java.util.Arrays;
import org.apache.spark.Logging;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.DenseVector$;
import org.apache.spark.mllib.linalg.EigenValueDecomposition$;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.QRDecomposition;
import org.apache.spark.mllib.linalg.SingularValueDecomposition;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.SparseVector$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.linalg.distributed.CoordinateMatrix;
import org.apache.spark.mllib.linalg.distributed.DistributedMatrix;
import org.apache.spark.mllib.linalg.distributed.MatrixEntry;
import org.apache.spark.mllib.linalg.distributed.RowMatrix$;
import org.apache.spark.mllib.linalg.distributed.RowMatrix$$anonfun$24$;
import org.apache.spark.mllib.linalg.distributed.RowMatrix$SVDMode$2$;
import org.apache.spark.mllib.stat.MultivariateOnlineSummarizer;
import org.apache.spark.mllib.stat.MultivariateStatisticalSummary;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.random.XORShiftRandom;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.TraversableOnce$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.VolatileObjectRef;

@ScalaSignature(bytes="\u0006\u0001\t]b\u0001B\u0001\u0003\u0001=\u0011\u0011BU8x\u001b\u0006$(/\u001b=\u000b\u0005\r!\u0011a\u00033jgR\u0014\u0018NY;uK\u0012T!!\u0002\u0004\u0002\r1Lg.\u00197h\u0015\t9\u0001\"A\u0003nY2L'M\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\t\u00175A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001a\u0004\"a\u0006\r\u000e\u0003\tI!!\u0007\u0002\u0003#\u0011K7\u000f\u001e:jEV$X\rZ'biJL\u0007\u0010\u0005\u0002\u001c95\t\u0001\"\u0003\u0002\u001e\u0011\t9Aj\\4hS:<\u0007\u0002C\u0010\u0001\u0005\u000b\u0007I\u0011\u0001\u0011\u0002\tI|wo]\u000b\u0002CA\u0019!%J\u0014\u000e\u0003\rR!\u0001\n\u0005\u0002\u0007I$G-\u0003\u0002'G\t\u0019!\u000b\u0012#\u0011\u0005!JS\"\u0001\u0003\n\u0005)\"!A\u0002,fGR|'\u000fK\u0002\u001fYI\u0002\"!\f\u0019\u000e\u00039R!a\f\u0005\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u00022]\t)1+\u001b8dK\u0006\n1'A\u00032]Ar\u0003\u0007\u0003\u00056\u0001\t\u0005\t\u0015!\u0003\"\u0003\u0015\u0011xn^:!Q\r!DF\r\u0005\tq\u0001\u0011\t\u0019!C\u0005s\u0005)aNU8xgV\t!\b\u0005\u0002\u0012w%\u0011AH\u0005\u0002\u0005\u0019>tw\r\u0003\u0005?\u0001\t\u0005\r\u0011\"\u0003@\u0003%q'k\\<t?\u0012*\u0017\u000f\u0006\u0002A\u0007B\u0011\u0011#Q\u0005\u0003\u0005J\u0011A!\u00168ji\"9A)PA\u0001\u0002\u0004Q\u0014a\u0001=%c!Aa\t\u0001B\u0001B\u0003&!(\u0001\u0004o%><8\u000f\t\u0005\t\u0011\u0002\u0011\t\u0019!C\u0005\u0013\u0006)anQ8mgV\t!\n\u0005\u0002\u0012\u0017&\u0011AJ\u0005\u0002\u0004\u0013:$\b\u0002\u0003(\u0001\u0005\u0003\u0007I\u0011B(\u0002\u00139\u001cu\u000e\\:`I\u0015\fHC\u0001!Q\u0011\u001d!U*!AA\u0002)C\u0001B\u0015\u0001\u0003\u0002\u0003\u0006KAS\u0001\u0007]\u000e{Gn\u001d\u0011\t\u000bQ\u0003A\u0011A+\u0002\rqJg.\u001b;?)\u00111v+\u0017.\u0011\u0005]\u0001\u0001\"B\u0010T\u0001\u0004\t\u0003fA,-e!)\u0001h\u0015a\u0001u!)\u0001j\u0015a\u0001\u0015\"\u001a1\u000b\f\u001a\t\u000bQ\u0003A\u0011A/\u0015\u0005Ys\u0006\"B\u0010]\u0001\u0004\t\u0003f\u0001/-e!)\u0011\r\u0001C!E\u00069a.^7D_2\u001cH#\u0001\u001e)\u0007\u0001d#\u0007C\u0003f\u0001\u0011\u0005#-A\u0004ok6\u0014vn^:)\u0007\u0011d#\u0007\u0003\u0004i\u0001\u0011\u0005a![\u0001\u0018[VdG/\u001b9ms\u001e\u0013\u0018-\\5b]6\u000bGO]5y\u0005f$\"A\u001b;\u0011\u0007-|\u0017/D\u0001m\u0015\t)QNC\u0001o\u0003\u0019\u0011'/Z3{K&\u0011\u0001\u000f\u001c\u0002\f\t\u0016t7/\u001a,fGR|'\u000f\u0005\u0002\u0012e&\u00111O\u0005\u0002\u0007\t>,(\r\\3\t\u000bU<\u0007\u0019\u00016\u0002\u0003YDQa\u001e\u0001\u0005\u0002a\fAcY8naV$Xm\u0012:b[&\fg.T1ue&DH#A=\u0011\u0005!R\u0018BA>\u0005\u0005\u0019i\u0015\r\u001e:jq\"\u001aa\u000f\f\u001a\t\u000by\u0004A\u0011B@\u0002\u001f\rDWmY6Ok6\u001cu\u000e\\;n]N$2\u0001QA\u0001\u0011\u0019\t\u0019! a\u0001\u0015\u0006!1m\u001c7t\u0011\u001d\t9\u0001\u0001C\u0001\u0003\u0013\t!bY8naV$Xm\u0015,E)!\tY!!\u0005\u0002\u0016\u0005}\u0001#\u0002\u0015\u0002\u000eYK\u0018bAA\b\t\tQ2+\u001b8hk2\f'OV1mk\u0016$UmY8na>\u001c\u0018\u000e^5p]\"9\u00111CA\u0003\u0001\u0004Q\u0015!A6\t\u0015\u0005]\u0011Q\u0001I\u0001\u0002\u0004\tI\"\u0001\u0005d_6\u0004X\u000f^3V!\r\t\u00121D\u0005\u0004\u0003;\u0011\"a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003C\t)\u0001%AA\u0002E\fQA]\"p]\u0012DC!!\u0002-e!A\u0011q\u0001\u0001\u0005\u0002\u0019\t9\u0003\u0006\b\u0002\f\u0005%\u00121FA\u0017\u0003_\t\u0019$a\u000e\t\u000f\u0005M\u0011Q\u0005a\u0001\u0015\"A\u0011qCA\u0013\u0001\u0004\tI\u0002C\u0004\u0002\"\u0005\u0015\u0002\u0019A9\t\u000f\u0005E\u0012Q\u0005a\u0001\u0015\u00069Q.\u0019=Ji\u0016\u0014\bbBA\u001b\u0003K\u0001\r!]\u0001\u0004i>d\u0007\u0002CA\u001d\u0003K\u0001\r!a\u000f\u0002\t5|G-\u001a\t\u0005\u0003{\t\u0019ED\u0002\u0012\u0003\u007fI1!!\u0011\u0013\u0003\u0019\u0001&/\u001a3fM&!\u0011QIA$\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\t\n\t\r\u0005-\u0003\u0001\"\u0001y\u0003E\u0019w.\u001c9vi\u0016\u001cuN^1sS\u0006t7-\u001a\u0015\u0005\u0003\u0013b#\u0007C\u0004\u0002R\u0001!\t!a\u0015\u00025\r|W\u000e];uKB\u0013\u0018N\\2ja\u0006d7i\\7q_:,g\u000e^:\u0015\u0007e\f)\u0006C\u0004\u0002\u0014\u0005=\u0003\u0019\u0001&)\t\u0005=CF\r\u0005\b\u00037\u0002A\u0011AA/\u0003y\u0019w.\u001c9vi\u0016\u001cu\u000e\\;n]N+X.\\1ssN#\u0018\r^5ti&\u001c7\u000f\u0006\u0002\u0002`A!\u0011\u0011MA4\u001b\t\t\u0019GC\u0002\u0002f\u0019\tAa\u001d;bi&!\u0011\u0011NA2\u0005yiU\u000f\u001c;jm\u0006\u0014\u0018.\u0019;f'R\fG/[:uS\u000e\fGnU;n[\u0006\u0014\u0018\u0010\u000b\u0003\u0002Z1\u0012\u0004bBA8\u0001\u0011\u0005\u0011\u0011O\u0001\t[VdG/\u001b9msR\u0019a+a\u001d\t\u000f\u0005U\u0014Q\u000ea\u0001s\u0006\t!\t\u000b\u0003\u0002n1\u0012\u0004bBA>\u0001\u0011\u0005\u0011QP\u0001\u0013G>dW/\u001c8TS6LG.\u0019:ji&,7\u000f\u0006\u0002\u0002\u0000A\u0019q#!!\n\u0007\u0005\r%A\u0001\tD_>\u0014H-\u001b8bi\u0016l\u0015\r\u001e:jq\"*\u0011\u0011\u0010\u0017\u0002\b\u0006\u0012\u0011\u0011R\u0001\u0006c9\u0012d\u0006\r\u0005\b\u0003w\u0002A\u0011AAG)\u0011\ty(a$\t\u000f\u0005E\u00151\u0012a\u0001c\u0006IA\u000f\u001b:fg\"|G\u000e\u001a\u0015\u0006\u0003\u0017c\u0013q\u0011\u0005\b\u0003/\u0003A\u0011AAM\u00031!\u0018\r\u001c7TW&tg._)S)\u0011\tY*!)\u0011\u000b!\niJV=\n\u0007\u0005}EAA\bR%\u0012+7m\\7q_NLG/[8o\u0011)\t\u0019+!&\u0011\u0002\u0003\u0007\u0011\u0011D\u0001\tG>l\u0007/\u001e;f#\"*\u0011Q\u0013\u0017\u0002(\u0006\u0012\u0011\u0011V\u0001\u0006c9*d\u0006\r\u0005\t\u0003[\u0003A\u0011\u0001\u0004\u00020\u0006A2m\u001c7v[:\u001c\u0016.\\5mCJLG/[3t\t&k5+V'\u0015\r\u0005}\u0014\u0011WA^\u0011!\t\u0019,a+A\u0002\u0005U\u0016aB2pY6\u000bwm\u001d\t\u0005#\u0005]\u0016/C\u0002\u0002:J\u0011Q!\u0011:sCfDq!!0\u0002,\u0002\u0007\u0011/A\u0003hC6l\u0017\r\u0003\u0005\u0002B\u0002!\tEBAb\u0003!!xN\u0011:fKj,GCAAc!\u0011Y\u0017qY9\n\u0007\u0005%GNA\u0006EK:\u001cX-T1ue&D\bbBAg\u0001\u0011%\u0011qZ\u0001\u000ekB$\u0017\r^3Ok6\u0014vn^:\u0015\u0007\u0001\u000b\t\u000eC\u0004\u0002T\u0006-\u0007\u0019\u0001\u001e\u0002\u00035D\u0011\"a6\u0001#\u0003%\t!!7\u0002)\r|W\u000e];uKN3F\t\n3fM\u0006,H\u000e\u001e\u00133+\t\tYN\u000b\u0003\u0002\u001a\u0005u7FAAp!\u0011\t\t/!;\u000e\u0005\u0005\r(\u0002BAs\u0003O\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005=\u0012\u0012\u0002BAv\u0003G\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\ty\u000fAI\u0001\n\u0003\t\t0\u0001\u000bd_6\u0004X\u000f^3T-\u0012#C-\u001a4bk2$HeM\u000b\u0003\u0003gT3!]Ao\u0011%\t9\u0010AI\u0001\n\u0003\tI.\u0001\fuC2d7k[5o]f\f&\u000b\n3fM\u0006,H\u000e\u001e\u00132Q\r\u0001AFM\u0004\b\u0003{\u0014\u0001\u0012AA\u0000\u0003%\u0011vn^'biJL\u0007\u0010E\u0002\u0018\u0005\u00031a!\u0001\u0002\t\u0002\t\r1#\u0002B\u0001!\t\u0015\u0001cA\t\u0003\b%\u0019!\u0011\u0002\n\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000fQ\u0013\t\u0001\"\u0001\u0003\u000eQ\u0011\u0011q \u0005\t\u0005#\u0011\t\u0001\"\u0003\u0003\u0014\u0005QAO]5v)>4U\u000f\u001c7\u0015\u000be\u0014)B!\u0007\t\u000f\t]!q\u0002a\u0001\u0015\u0006\ta\u000e\u0003\u0005\u0003\u001c\t=\u0001\u0019AA[\u0003\u0005)\u0006B\u0003B\u0010\u0005\u0003\t\t\u0011\"\u0003\u0003\"\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011\u0019\u0003\u0005\u0003\u0003&\t=RB\u0001B\u0014\u0015\u0011\u0011ICa\u000b\u0002\t1\fgn\u001a\u0006\u0003\u0005[\tAA[1wC&!!\u0011\u0007B\u0014\u0005\u0019y%M[3di\"\"!\u0011\u0001\u00173Q\u0011\tY\u0010\f\u001a")
public class RowMatrix
implements DistributedMatrix,
Logging {
    private final RDD<Vector> rows;
    private long org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows;
    private int nCols;
    private transient Logger org$apache$spark$Logging$$log_;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RowMatrix$SVDMode$2$ SVDMode$1$lzycompute(VolatileObjectRef x$1) {
        RowMatrix rowMatrix = this;
        synchronized (rowMatrix) {
            if (x$1.elem != null) return (RowMatrix$SVDMode$2$)((Object)x$1.elem);
            x$1.elem = new RowMatrix$SVDMode$2$(this);
            return (RowMatrix$SVDMode$2$)((Object)x$1.elem);
        }
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public RDD<Vector> rows() {
        return this.rows;
    }

    public long org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows() {
        return this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows;
    }

    private void org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows_$eq(long x$1) {
        this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows = x$1;
    }

    private int nCols() {
        return this.nCols;
    }

    private void nCols_$eq(int x$1) {
        this.nCols = x$1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long numCols() {
        if (this.nCols() > 0) return this.nCols();
        try {
            this.nCols_$eq(((Vector)this.rows().first()).size());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw scala.sys.package$.MODULE$.error("Cannot determine the number of cols because it is not specified in the constructor and the rows RDD is empty.");
        }
        return this.nCols();
    }

    @Override
    public long numRows() {
        if (this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows() <= 0L) {
            this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows_$eq(this.rows().count());
            if (this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows() == 0L) {
                throw scala.sys.package$.MODULE$.error("Cannot determine the number of rows because it is not specified in the constructor and the rows RDD is empty.");
            }
        }
        return this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows();
    }

    public breeze.linalg.DenseVector<Object> multiplyGramianMatrixBy(breeze.linalg.DenseVector<Object> v) {
        int n = (int)this.numCols();
        Broadcast vbr = this.rows().context().broadcast(v, ClassTag$.MODULE$.apply(breeze.linalg.DenseVector.class));
        breeze.linalg.DenseVector x$6 = breeze.linalg.DenseVector$.MODULE$.zeros$mDc$sp(n, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
        Serializable x$7 = new Serializable(this, vbr){
            public static final long serialVersionUID = 0L;
            private final Broadcast vbr$1;

            /*
             * WARNING - void declaration
             */
            public final breeze.linalg.DenseVector<Object> apply(breeze.linalg.DenseVector<Object> U, Vector r) {
                void var3_3;
                block4: {
                    block3: {
                        breeze.linalg.Vector<Object> vector;
                        double a;
                        breeze.linalg.Vector<Object> rBrz;
                        block2: {
                            rBrz = r.toBreeze();
                            a = BoxesRunTime.unboxToDouble((Object)rBrz.dot(this.vbr$1.value(), Vector$.MODULE$.castOps(Predef$.MODULE$.conforms(), Predef$.MODULE$.conforms(), (UFunc.UImpl2)Vector$.MODULE$.canDot_V_V_Double())));
                            vector = rBrz;
                            if (!(vector instanceof breeze.linalg.DenseVector)) break block2;
                            breeze.linalg.package$.MODULE$.axpy((Object)BoxesRunTime.boxToDouble((double)a), (Object)((breeze.linalg.DenseVector)rBrz), U, (UFunc.InPlaceImpl3)DenseVector.canDaxpy$.MODULE$);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        if (!(vector instanceof breeze.linalg.SparseVector)) break block4;
                        breeze.linalg.package$.MODULE$.axpy((Object)BoxesRunTime.boxToDouble((double)a), (Object)((breeze.linalg.SparseVector)rBrz), U, breeze.linalg.SparseVector$.MODULE$.implScaleAdd_DVT_T_SVT_InPlace_Double());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return U;
                }
                throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Do not support vector operation from type ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var3_3.getClass().getName()})));
            }
            {
                this.vbr$1 = vbr$1;
            }
        };
        Serializable x$8 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final breeze.linalg.DenseVector<Object> apply(breeze.linalg.DenseVector<Object> U1, breeze.linalg.DenseVector<Object> U2) {
                return (breeze.linalg.DenseVector)U1.$plus$eq(U2, breeze.linalg.DenseVector$.MODULE$.canAddIntoD());
            }
        };
        int x$9 = this.rows().treeAggregate$default$4((Object)x$6);
        return (breeze.linalg.DenseVector)this.rows().treeAggregate((Object)x$6, (Function2)x$7, (Function2)x$8, x$9, ClassTag$.MODULE$.apply(breeze.linalg.DenseVector.class));
    }

    public Matrix computeGramianMatrix() {
        int n = (int)this.numCols();
        this.checkNumColumns(n);
        int nt = n % 2 == 0 ? n / 2 * (n + 1) : n * ((n + 1) / 2);
        DenseVector.mcD.sp x$10 = new DenseVector.mcD.sp(new double[nt]);
        Serializable x$11 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final breeze.linalg.DenseVector<Object> apply(breeze.linalg.DenseVector<Object> U, Vector v) {
                BLAS$.MODULE$.spr(1.0, v, U.data$mcD$sp());
                return U;
            }
        };
        Serializable x$12 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final breeze.linalg.DenseVector<Object> apply(breeze.linalg.DenseVector<Object> U1, breeze.linalg.DenseVector<Object> U2) {
                return (breeze.linalg.DenseVector)U1.$plus$eq(U2, breeze.linalg.DenseVector$.MODULE$.canAddIntoD());
            }
        };
        int x$13 = this.rows().treeAggregate$default$4((Object)x$10);
        breeze.linalg.DenseVector GU = (breeze.linalg.DenseVector)this.rows().treeAggregate((Object)x$10, (Function2)x$11, (Function2)x$12, x$13, ClassTag$.MODULE$.apply(breeze.linalg.DenseVector.class));
        return RowMatrix$.MODULE$.org$apache$spark$mllib$linalg$distributed$RowMatrix$$triuToFull(n, GU.data$mcD$sp());
    }

    private void checkNumColumns(int cols) {
        if (cols > 65535) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Argument with more than 65535 cols: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)cols)})));
        }
        if (cols > 10000) {
            long memMB = (long)cols * (long)cols / 125000L;
            this.logWarning((Function0<String>)new Serializable(this, cols, memMB){
                public static final long serialVersionUID = 0L;
                private final int cols$1;
                private final long memMB$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " columns will require at least ", " megabytes of memory!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.cols$1), BoxesRunTime.boxToLong((long)this.memMB$1)}));
                }
                {
                    this.cols$1 = cols$1;
                    this.memMB$1 = memMB$1;
                }
            });
        }
    }

    public SingularValueDecomposition<RowMatrix, Matrix> computeSVD(int k, boolean computeU, double rCond) {
        int maxIter = package$.MODULE$.max(300, k * 3);
        double tol = 1.0E-10;
        return this.computeSVD(k, computeU, rCond, maxIter, tol, "auto");
    }

    public SingularValueDecomposition<RowMatrix, Matrix> computeSVD(int k, boolean computeU, double rCond, int maxIter, double tol, String mode) {
        block21: {
            Enumeration.Value value;
            block26: {
                Tuple2 tuple2;
                Enumeration.Value computeMode;
                int n;
                VolatileObjectRef SVDMode$module;
                block23: {
                    block24: {
                        svd.SVD sVD;
                        block25: {
                            Tuple2 tuple22;
                            block22: {
                                Enumeration.Value value2;
                                block18: {
                                    String string;
                                    block20: {
                                        block19: {
                                            block17: {
                                                SVDMode$module = new VolatileObjectRef(null);
                                                n = (int)this.numCols();
                                                Predef$.MODULE$.require(k > 0 && k <= n, (Function0)new Serializable(this, k, n){
                                                    public static final long serialVersionUID = 0L;
                                                    private final int k$2;
                                                    private final int n$1;

                                                    public final String apply() {
                                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Requested k singular values but got k=", " and numCols=", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.k$2), BoxesRunTime.boxToInteger((int)this.n$1)}));
                                                    }
                                                    {
                                                        this.k$2 = k$2;
                                                        this.n$1 = n$1;
                                                    }
                                                });
                                                String string2 = string = mode;
                                                if ("auto" != null ? !"auto".equals(string2) : string2 != null) break block17;
                                                if (k > 5000) {
                                                    this.logWarning((Function0<String>)new Serializable(this, k, n){
                                                        public static final long serialVersionUID = 0L;
                                                        private final int k$2;
                                                        private final int n$1;

                                                        public final String apply() {
                                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"computing svd with k=", " and n=", ", please check necessity"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.k$2), BoxesRunTime.boxToInteger((int)this.n$1)}));
                                                        }
                                                        {
                                                            this.k$2 = k$2;
                                                            this.n$1 = n$1;
                                                        }
                                                    });
                                                }
                                                value2 = n < 100 || k > n / 2 && n <= 15000 ? (k < n / 3 ? this.SVDMode$1(SVDMode$module).LocalARPACK() : this.SVDMode$1(SVDMode$module).LocalLAPACK()) : this.SVDMode$1(SVDMode$module).DistARPACK();
                                                break block18;
                                            }
                                            String string3 = string;
                                            if ("local-svd" != null ? !"local-svd".equals(string3) : string3 != null) break block19;
                                            value2 = this.SVDMode$1(SVDMode$module).LocalLAPACK();
                                            break block18;
                                        }
                                        String string4 = string;
                                        if ("local-eigs" != null ? !"local-eigs".equals(string4) : string4 != null) break block20;
                                        value2 = this.SVDMode$1(SVDMode$module).LocalARPACK();
                                        break block18;
                                    }
                                    String string5 = string;
                                    if ("dist-eigs" != null ? !"dist-eigs".equals(string5) : string5 != null) break block21;
                                    value2 = this.SVDMode$1(SVDMode$module).DistARPACK();
                                }
                                value = computeMode = value2;
                                Enumeration.Value value3 = this.SVDMode$1(SVDMode$module).LocalARPACK();
                                Enumeration.Value value4 = value;
                                if (value3 != null ? !value3.equals(value4) : value4 != null) break block22;
                                Predef$.MODULE$.require(k < n, (Function0)new $anonfun$10(this, k, n));
                                breeze.linalg.DenseMatrix G = (breeze.linalg.DenseMatrix)this.computeGramianMatrix().toBreeze();
                                tuple2 = EigenValueDecomposition$.MODULE$.symmetricEigs((Function1<breeze.linalg.DenseVector<Object>, breeze.linalg.DenseVector<Object>>)new $anonfun$11(this, G), n, k, tol, maxIter);
                                break block23;
                            }
                            Enumeration.Value value5 = this.SVDMode$1(SVDMode$module).LocalLAPACK();
                            Enumeration.Value value6 = value;
                            if (value5 != null ? !value5.equals(value6) : value6 != null) break block24;
                            Predef$.MODULE$.require(n < 17515, (Function0)new $anonfun$12(this, n));
                            breeze.linalg.DenseMatrix G = (breeze.linalg.DenseMatrix)this.computeGramianMatrix().toBreeze();
                            sVD = (svd.SVD)svd$.MODULE$.apply((Object)G, (UFunc.UImpl)svd.Svd_DM_Impl$.MODULE$);
                            if (sVD == null) break block25;
                            breeze.linalg.DenseMatrix uFull = (breeze.linalg.DenseMatrix)sVD.leftVectors();
                            breeze.linalg.DenseVector sigmaSquaresFull = (breeze.linalg.DenseVector)sVD.singularValues();
                            if (uFull == null) break block25;
                            breeze.linalg.DenseMatrix denseMatrix = uFull;
                            if (sigmaSquaresFull == null) break block25;
                            breeze.linalg.DenseVector denseVector = sigmaSquaresFull;
                            Tuple2 tuple23 = tuple22 = new Tuple2((Object)denseMatrix, (Object)denseVector);
                            breeze.linalg.DenseMatrix uFull2 = (breeze.linalg.DenseMatrix)tuple23._1();
                            breeze.linalg.DenseVector sigmaSquaresFull2 = (breeze.linalg.DenseVector)tuple23._2();
                            tuple2 = new Tuple2((Object)sigmaSquaresFull2, (Object)uFull2);
                            break block23;
                        }
                        throw new MatchError((Object)sVD);
                    }
                    Enumeration.Value value7 = this.SVDMode$1(SVDMode$module).DistARPACK();
                    Enumeration.Value value8 = value;
                    if (value7 != null ? !value7.equals(value8) : value8 != null) break block26;
                    StorageLevel storageLevel = this.rows().getStorageLevel();
                    StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
                    if (!(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null)) {
                        this.logWarning((Function0<String>)new $anonfun$13(this));
                    }
                    Predef$.MODULE$.require(k < n, (Function0)new $anonfun$14(this, k, n));
                    tuple2 = EigenValueDecomposition$.MODULE$.symmetricEigs((Function1<breeze.linalg.DenseVector<Object>, breeze.linalg.DenseVector<Object>>)new $anonfun$15(this), n, k, tol, maxIter);
                }
                Tuple2 tuple24 = tuple2;
                if (tuple24 != null) {
                    breeze.linalg.DenseVector sigmaSquares = (breeze.linalg.DenseVector)tuple24._1();
                    breeze.linalg.DenseMatrix u = (breeze.linalg.DenseMatrix)tuple24._2();
                    if (sigmaSquares != null) {
                        breeze.linalg.DenseVector denseVector = sigmaSquares;
                        if (u != null) {
                            SingularValueDecomposition<RowMatrix, Matrix> singularValueDecomposition;
                            Tuple2 tuple25;
                            breeze.linalg.DenseMatrix denseMatrix = u;
                            Tuple2 tuple26 = tuple25 = new Tuple2((Object)denseVector, (Object)denseMatrix);
                            breeze.linalg.DenseVector sigmaSquares2 = (breeze.linalg.DenseVector)tuple26._1();
                            breeze.linalg.DenseMatrix u2 = (breeze.linalg.DenseMatrix)tuple26._2();
                            breeze.linalg.DenseVector sigmas = (breeze.linalg.DenseVector)package.sqrt$.MODULE$.apply((Object)sigmaSquares2, package.sqrt$.MODULE$.fromLowOrderCanMapValues(breeze.linalg.DenseVector$.MODULE$.handholdCMV(), (UFunc.UImpl)package.sqrt$.sqrtDoubleImpl$.MODULE$, breeze.linalg.DenseVector$.MODULE$.canMapValues(ClassTag$.MODULE$.Double())));
                            double sigma0 = sigmas.apply$mcD$sp(0);
                            double threshold = rCond * sigma0;
                            int i = 0;
                            if (sigmas.length() < k) {
                                this.logWarning((Function0<String>)new Serializable(this, k, sigmas){
                                    public static final long serialVersionUID = 0L;
                                    private final int k$2;
                                    private final breeze.linalg.DenseVector sigmas$1;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Requested ", " singular values but only found ", " converged."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.k$2), BoxesRunTime.boxToInteger((int)this.sigmas$1.length())}));
                                    }
                                    {
                                        this.k$2 = k$2;
                                        this.sigmas$1 = sigmas$1;
                                    }
                                });
                            }
                            while (i < package$.MODULE$.min(k, sigmas.length()) && sigmas.apply$mcD$sp(i) >= threshold) {
                                ++i;
                            }
                            int sk = i;
                            if (sk < k) {
                                this.logWarning((Function0<String>)new Serializable(this, k, sk){
                                    public static final long serialVersionUID = 0L;
                                    private final int k$2;
                                    private final int sk$1;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Requested ", " singular values but only found ", " nonzeros."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.k$2), BoxesRunTime.boxToInteger((int)this.sk$1)}));
                                    }
                                    {
                                        this.k$2 = k$2;
                                        this.sk$1 = sk$1;
                                    }
                                });
                            }
                            Enumeration.Value value9 = computeMode;
                            Enumeration.Value value10 = this.SVDMode$1(SVDMode$module).DistARPACK();
                            if (!(value9 != null ? !value9.equals(value10) : value10 != null)) {
                                StorageLevel storageLevel = this.rows().getStorageLevel();
                                StorageLevel storageLevel3 = StorageLevel$.MODULE$.NONE();
                                if (!(storageLevel != null ? !storageLevel.equals(storageLevel3) : storageLevel3 != null)) {
                                    this.logWarning((Function0<String>)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "The input data was not directly cached, which may hurt performance if its parent RDDs are also uncached.";
                                        }
                                    });
                                }
                            }
                            Vector s = Vectors$.MODULE$.dense(Arrays.copyOfRange(sigmas.data$mcD$sp(), 0, sk));
                            Matrix V = Matrices$.MODULE$.dense(n, sk, Arrays.copyOfRange(u2.data$mcD$sp(), 0, n * sk));
                            if (computeU) {
                                DenseMatrix.mcD.sp N = new DenseMatrix.mcD.sp(n, sk, Arrays.copyOfRange(u2.data$mcD$sp(), 0, n * sk));
                                int i2 = 0;
                                for (int j = 0; j < sk; ++j) {
                                    i2 = 0;
                                    double sigma = sigmas.apply$mcD$sp(j);
                                    while (i2 < n) {
                                        int n2 = i2++;
                                        int n3 = j;
                                        N.update$mcD$sp(n2, n3, N.apply$mcD$sp(n2, n3) / sigma);
                                    }
                                }
                                RowMatrix U = this.multiply(Matrices$.MODULE$.fromBreeze((breeze.linalg.Matrix<Object>)N));
                                singularValueDecomposition = new SingularValueDecomposition<RowMatrix, Matrix>(U, s, V);
                            } else {
                                singularValueDecomposition = new SingularValueDecomposition<RowMatrix, Matrix>(null, s, V);
                            }
                            return singularValueDecomposition;
                        }
                    }
                }
                throw new MatchError(tuple24);
            }
            throw new MatchError((Object)value);
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Do not support mode ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mode})));
    }

    public boolean computeSVD$default$2() {
        return false;
    }

    public double computeSVD$default$3() {
        return 1.0E-9;
    }

    public Matrix computeCovariance() {
        int n = (int)this.numCols();
        this.checkNumColumns(n);
        Tuple2 x$14 = new Tuple2((Object)BoxesRunTime.boxToLong((long)0L), (Object)breeze.linalg.DenseVector$.MODULE$.zeros$mDc$sp(n, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$));
        Serializable x$15 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, breeze.linalg.DenseVector<Object>> apply(Tuple2<Object, breeze.linalg.DenseVector<Object>> s, Vector v) {
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)(s._1$mcJ$sp() + 1L)), ((NumericOps)s._2()).$plus$eq(v.toBreeze(), (UFunc.InPlaceImpl2)breeze.linalg.DenseVector$.MODULE$.dv_v_ZeroIdempotent_InPlaceOp_Double_OpAdd()));
            }
        };
        Serializable x$16 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, breeze.linalg.DenseVector<Object>> apply(Tuple2<Object, breeze.linalg.DenseVector<Object>> s1, Tuple2<Object, breeze.linalg.DenseVector<Object>> s2) {
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)(s1._1$mcJ$sp() + s2._1$mcJ$sp())), ((NumericOps)s1._2()).$plus$eq(s2._2(), breeze.linalg.DenseVector$.MODULE$.canAddIntoD()));
            }
        };
        int x$17 = this.rows().treeAggregate$default$4((Object)x$14);
        Tuple2 tuple2 = (Tuple2)this.rows().treeAggregate((Object)x$14, (Function2)x$15, (Function2)x$16, x$17, ClassTag$.MODULE$.apply(Tuple2.class));
        if (tuple2 != null) {
            Tuple2 tuple22;
            long m = tuple2._1$mcJ$sp();
            breeze.linalg.DenseVector mean2 = (breeze.linalg.DenseVector)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)m), (Object)mean2);
            long m2 = tuple23._1$mcJ$sp();
            breeze.linalg.DenseVector mean3 = (breeze.linalg.DenseVector)tuple23._2();
            if (m2 <= 1L) {
                throw scala.sys.package$.MODULE$.error(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RowMatrix.computeCovariance called on matrix with only ", " rows."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)m2)}))).append((Object)"  Cannot compute the covariance of a RowMatrix with <= 1 row.").toString());
            }
            this.updateNumRows(m2);
            mean3.$colon$div$eq((Object)BoxesRunTime.boxToDouble((double)m2), breeze.linalg.DenseVector$.MODULE$.dv_s_UpdateOp_Double_OpDiv());
            breeze.linalg.DenseMatrix G = (breeze.linalg.DenseMatrix)this.computeGramianMatrix().toBreeze();
            int j = 0;
            double m1 = (double)m2 - 1.0;
            double alpha = 0.0;
            for (int i = 0; i < n; ++i) {
                alpha = (double)m2 / m1 * mean3.apply$mcD$sp(i);
                for (j = i; j < n; ++j) {
                    double Gij = G.apply$mcD$sp(i, j) / m1 - alpha * mean3.apply$mcD$sp(j);
                    G.update$mcD$sp(i, j, Gij);
                    G.update$mcD$sp(j, i, Gij);
                }
            }
            return Matrices$.MODULE$.fromBreeze((breeze.linalg.Matrix<Object>)G);
        }
        throw new MatchError((Object)tuple2);
    }

    public Matrix computePrincipalComponents(int k) {
        breeze.linalg.DenseMatrix u;
        int n = (int)this.numCols();
        Predef$.MODULE$.require(k > 0 && k <= n, (Function0)new Serializable(this, k, n){
            public static final long serialVersionUID = 0L;
            private final int k$1;
            private final int n$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k = ", " out of range (0, n = ", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.k$1), BoxesRunTime.boxToInteger((int)this.n$2)}));
            }
            {
                this.k$1 = k$1;
                this.n$2 = n$2;
            }
        });
        breeze.linalg.DenseMatrix Cov = (breeze.linalg.DenseMatrix)this.computeCovariance().toBreeze();
        svd.SVD sVD = (svd.SVD)svd$.MODULE$.apply((Object)Cov, (UFunc.UImpl)svd.Svd_DM_Impl$.MODULE$);
        if (sVD != null && (u = (breeze.linalg.DenseMatrix)sVD.leftVectors()) != null) {
            breeze.linalg.DenseMatrix denseMatrix;
            breeze.linalg.DenseMatrix denseMatrix2;
            breeze.linalg.DenseMatrix u2 = denseMatrix2 = (denseMatrix = u);
            return k == n ? Matrices$.MODULE$.dense(n, k, u2.data$mcD$sp()) : Matrices$.MODULE$.dense(n, k, Arrays.copyOfRange(u2.data$mcD$sp(), 0, n * k));
        }
        throw new MatchError((Object)sVD);
    }

    /*
     * WARNING - void declaration
     */
    public MultivariateStatisticalSummary computeColumnSummaryStatistics() {
        void var1_5;
        MultivariateOnlineSummarizer x$18 = new MultivariateOnlineSummarizer();
        Serializable x$19 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final MultivariateOnlineSummarizer apply(MultivariateOnlineSummarizer aggregator, Vector data) {
                return aggregator.add(data);
            }
        };
        Serializable x$20 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final MultivariateOnlineSummarizer apply(MultivariateOnlineSummarizer aggregator1, MultivariateOnlineSummarizer aggregator2) {
                return aggregator1.merge(aggregator2);
            }
        };
        int x$21 = this.rows().treeAggregate$default$4((Object)x$18);
        MultivariateOnlineSummarizer summary = (MultivariateOnlineSummarizer)this.rows().treeAggregate((Object)x$18, (Function2)x$19, (Function2)x$20, x$21, ClassTag$.MODULE$.apply(MultivariateOnlineSummarizer.class));
        this.updateNumRows(summary.count());
        return var1_5;
    }

    public RowMatrix multiply(Matrix B) {
        int n = (int)this.numCols();
        int k = B.numCols();
        Predef$.MODULE$.require(n == B.numRows(), (Function0)new Serializable(this, B, n){
            public static final long serialVersionUID = 0L;
            private final Matrix B$1;
            private final int n$3;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dimension mismatch: ", " vs ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.n$3), BoxesRunTime.boxToInteger((int)this.B$1.numRows())}));
            }
            {
                this.B$1 = B$1;
                this.n$3 = n$3;
            }
        });
        Predef$.MODULE$.require(B instanceof DenseMatrix, (Function0)new Serializable(this, B){
            public static final long serialVersionUID = 0L;
            private final Matrix B$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Only support dense matrix at this time but found ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.B$1.getClass().getName()}));
            }
            {
                this.B$1 = B$1;
            }
        });
        Broadcast Bb = this.rows().context().broadcast((Object)((breeze.linalg.DenseMatrix)B.toBreeze()).toDenseVector$mcD$sp().toArray$mcD$sp(ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        RDD AB = this.rows().mapPartitions((Function1)new Serializable(this, n, k, Bb){
            public static final long serialVersionUID = 0L;
            public final int n$3;
            public final int k$3;
            private final Broadcast Bb$1;

            public final Iterator<Vector> apply(Iterator<Vector> iter) {
                double[] Bi = (double[])this.Bb$1.value();
                return iter.map((Function1)new Serializable(this, Bi){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$20 $outer;
                    private final double[] Bi$1;

                    public final Vector apply(Vector row) {
                        breeze.linalg.DenseVector v = breeze.linalg.DenseVector$.MODULE$.zeros$mDc$sp(this.$outer.k$3, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
                        for (int i = 0; i < this.$outer.k$3; ++i) {
                            v.update$mcD$sp(i, BoxesRunTime.unboxToDouble((Object)row.toBreeze().dot((Object)new DenseVector.mcD.sp(this.Bi$1, i * this.$outer.n$3, 1, this.$outer.n$3), Vector$.MODULE$.castOps(Predef$.MODULE$.conforms(), Predef$.MODULE$.conforms(), (UFunc.UImpl2)Vector$.MODULE$.canDot_V_V_Double()))));
                        }
                        return Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector<Object>)v);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.Bi$1 = Bi$1;
                    }
                });
            }
            {
                this.n$3 = n$3;
                this.k$3 = k$3;
                this.Bb$1 = Bb$1;
            }
        }, this.rows().mapPartitions$default$2(), ClassTag$.MODULE$.apply(Vector.class));
        return new RowMatrix((RDD<Vector>)AB, this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows(), B.numCols());
    }

    public CoordinateMatrix columnSimilarities() {
        return this.columnSimilarities(0.0);
    }

    public CoordinateMatrix columnSimilarities(double threshold) {
        Predef$.MODULE$.require(threshold >= 0.0, (Function0)new Serializable(this, threshold){
            public static final long serialVersionUID = 0L;
            private final double threshold$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Threshold cannot be negative: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.threshold$1)}));
            }
            {
                this.threshold$1 = threshold$1;
            }
        });
        if (threshold > 1.0) {
            this.logWarning((Function0<String>)new Serializable(this, threshold){
                public static final long serialVersionUID = 0L;
                private final double threshold$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Threshold is greater than 1: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.threshold$1)}))).append((Object)"Computation will be more efficient with promoted sparsity, ").append((Object)" however there is no correctness guarantee.").toString();
                }
                {
                    this.threshold$1 = threshold$1;
                }
            });
        }
        double gamma = threshold < 1.0E-6 ? Double.POSITIVE_INFINITY : (double)10 * package$.MODULE$.log((double)this.numCols()) / threshold;
        return this.columnSimilaritiesDIMSUM(this.computeColumnSummaryStatistics().normL2().toArray(), gamma);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public QRDecomposition<RowMatrix, Matrix> tallSkinnyQR(boolean computeQ) {
        RowMatrix rowMatrix;
        int col = (int)this.numCols();
        RDD blockQRs = this.rows().glom().map((Function1)new Serializable(this, col){
            public static final long serialVersionUID = 0L;
            private final int col$1;

            public final breeze.linalg.DenseMatrix<Object> apply(Vector[] partRows) {
                breeze.linalg.DenseMatrix bdm = DenseMatrix$.MODULE$.zeros$mDc$sp(partRows.length, this.col$1, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
                IntRef i = new IntRef(0);
                Predef$.MODULE$.refArrayOps((Object[])partRows).foreach((Function1)new Serializable(this, bdm, i){
                    public static final long serialVersionUID = 0L;
                    private final breeze.linalg.DenseMatrix bdm$1;
                    private final IntRef i$1;

                    public final void apply(Vector row) {
                        ((NumericOps)this.bdm$1.apply((Object)BoxesRunTime.boxToInteger((int)this.i$1.elem), (Object)scala.package$.MODULE$.$colon$colon(), DenseMatrix$.MODULE$.canSliceRow())).$colon$eq(row.toBreeze().t(Tensor$.MODULE$.transposeTensor(Predef$.MODULE$.conforms())), Transpose$.MODULE$.liftInPlaceOps((UFunc.InPlaceImpl2)breeze.linalg.DenseVector$.MODULE$.dv_v_InPlaceOp_Double_OpSet()));
                        ++this.i$1.elem;
                    }
                    {
                        this.bdm$1 = bdm$1;
                        this.i$1 = i$1;
                    }
                });
                return (breeze.linalg.DenseMatrix)((qr.QR)qr.reduced$.MODULE$.apply((Object)bdm, (UFunc.UImpl)qr.reduced$.impl_reduced_DM_Double$.MODULE$)).r();
            }
            {
                this.col$1 = col$1;
            }
        }, ClassTag$.MODULE$.apply(breeze.linalg.DenseMatrix.class));
        breeze.linalg.DenseMatrix combinedR = (breeze.linalg.DenseMatrix)blockQRs.treeReduce((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final breeze.linalg.DenseMatrix<Object> apply(breeze.linalg.DenseMatrix<Object> r1, breeze.linalg.DenseMatrix<Object> r2) {
                breeze.linalg.DenseMatrix stackedR = DenseMatrix$.MODULE$.vertcat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new breeze.linalg.DenseMatrix[]{r1, r2}), DenseMatrix$.MODULE$.dm_dm_UpdateOp_Double_OpSet(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
                return (breeze.linalg.DenseMatrix)((qr.QR)qr.reduced$.MODULE$.apply((Object)stackedR, (UFunc.UImpl)qr.reduced$.impl_reduced_DM_Double$.MODULE$)).r();
            }
        }, blockQRs.treeReduce$default$2());
        Matrix finalR = Matrices$.MODULE$.fromBreeze((breeze.linalg.Matrix<Object>)combinedR.toDenseMatrix$mcD$sp(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$));
        if (computeQ) {
            try {
                breeze.linalg.DenseMatrix invR = (breeze.linalg.DenseMatrix)inv$.MODULE$.apply((Object)combinedR, inv$.MODULE$.canInvUsingLU((UFunc.UImpl)LU.LU_DM_Impl$.MODULE$));
                rowMatrix = this.multiply(Matrices$.MODULE$.fromBreeze((breeze.linalg.Matrix<Object>)invR));
            }
            catch (MatrixSingularException matrixSingularException) {
                this.logWarning((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "R is not invertible and return Q as null";
                    }
                });
                rowMatrix = null;
            }
        } else {
            rowMatrix = null;
        }
        RowMatrix finalQ = rowMatrix;
        return new QRDecomposition<Object, Matrix>(finalQ, finalR);
    }

    public boolean tallSkinnyQR$default$1() {
        return false;
    }

    public CoordinateMatrix columnSimilaritiesDIMSUM(double[] colMags, double gamma) {
        Predef$.MODULE$.require(gamma > 1.0, (Function0)new Serializable(this, gamma){
            public static final long serialVersionUID = 0L;
            private final double gamma$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Oversampling should be greater than 1: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.gamma$1)}));
            }
            {
                this.gamma$1 = gamma$1;
            }
        });
        Predef$.MODULE$.require((long)Predef$.MODULE$.doubleArrayOps(colMags).size() == this.numCols(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Number of magnitudes didn't match column dimension";
            }
        });
        double sg = package$.MODULE$.sqrt(gamma);
        double[] colMagsCorrected = (double[])Predef$.MODULE$.doubleArrayOps(colMags).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(double x) {
                return this.apply$mcDD$sp(x);
            }

            public double apply$mcDD$sp(double x) {
                return x == 0.0 ? 1.0 : x;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        SparkContext sc = this.rows().context();
        Broadcast pBV = sc.broadcast(Predef$.MODULE$.doubleArrayOps(colMagsCorrected).map((Function1)new Serializable(this, sg){
            public static final long serialVersionUID = 0L;
            private final double sg$1;

            public final double apply(double c) {
                return this.apply$mcDD$sp(c);
            }

            public double apply$mcDD$sp(double c) {
                return this.sg$1 / c;
            }
            {
                this.sg$1 = sg$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        Broadcast qBV = sc.broadcast(Predef$.MODULE$.doubleArrayOps(colMagsCorrected).map((Function1)new Serializable(this, sg){
            public static final long serialVersionUID = 0L;
            private final double sg$1;

            public final double apply(double c) {
                return this.apply$mcDD$sp(c);
            }

            public double apply$mcDD$sp(double c) {
                return package$.MODULE$.min(this.sg$1, c);
            }
            {
                this.sg$1 = sg$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        RDD sims = RDD$.MODULE$.rddToPairRDDFunctions(this.rows().mapPartitionsWithIndex((Function2)new Serializable(this, pBV, qBV){
            public static final long serialVersionUID = 0L;
            private final Broadcast pBV$1;
            private final Broadcast qBV$1;

            public final Iterator<Tuple2<Tuple2<Object, Object>, Object>> apply(int indx, Iterator<Vector> iter) {
                double[] p = (double[])this.pBV$1.value();
                double[] q = (double[])this.qBV$1.value();
                XORShiftRandom rand2 = new XORShiftRandom((long)indx);
                double[] scaled = new double[Predef$.MODULE$.doubleArrayOps(p).size()];
                return iter.flatMap((Function1)new Serializable(this, p, q, rand2, scaled){
                    public static final long serialVersionUID = 0L;
                    public final double[] p$1;
                    private final double[] q$1;
                    public final XORShiftRandom rand$1;
                    public final double[] scaled$1;

                    public final Iterator<Tuple2<Tuple2<Object, Object>, Object>> apply(Vector row) {
                        Vector vector;
                        block6: {
                            Iterator iterator;
                            block5: {
                                DenseVector denseVector;
                                Option<double[]> option;
                                block4: {
                                    SparseVector sparseVector;
                                    Option<Tuple3<Object, int[], double[]>> option2;
                                    vector = row;
                                    if (!(vector instanceof SparseVector) || (option2 = SparseVector$.MODULE$.unapply(sparseVector = (SparseVector)vector)).isEmpty()) break block4;
                                    int[] indices = (int[])((Tuple3)option2.get())._2();
                                    double[] values = (double[])((Tuple3)option2.get())._3();
                                    int nnz = Predef$.MODULE$.intArrayOps(indices).size();
                                    for (int k = 0; k < nnz; ++k) {
                                        this.scaled$1[k] = values[k] / this.q$1[indices[k]];
                                    }
                                    iterator = TraversableOnce$.MODULE$.flattenTraversableOnce((TraversableOnce)scala.package$.MODULE$.Iterator().tabulate(nnz, (Function1)new Serializable(this, indices, nnz){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$24$$anonfun$apply$4 $outer;
                                        private final int[] indices$1;
                                        private final int nnz$1;

                                        /*
                                         * WARNING - void declaration
                                         */
                                        public final ListBuffer<Tuple2<Tuple2<Object, Object>, Object>> apply(int k) {
                                            void var2_2;
                                            ListBuffer buf = new ListBuffer();
                                            int i = this.indices$1[k];
                                            double iVal = this.$outer.scaled$1[k];
                                            if (iVal != 0.0 && this.$outer.rand$1.nextDouble() < this.$outer.p$1[i]) {
                                                for (int l = k + 1; l < this.nnz$1; ++l) {
                                                    int j = this.indices$1[l];
                                                    double jVal = this.$outer.scaled$1[l];
                                                    Object object = jVal != 0.0 && this.$outer.rand$1.nextDouble() < this.$outer.p$1[j] ? buf.$plus$eq((Object)new Tuple2((Object)new Tuple2.mcII.sp(i, j), (Object)BoxesRunTime.boxToDouble((double)(iVal * jVal)))) : BoxedUnit.UNIT;
                                                }
                                            }
                                            return var2_2;
                                        }
                                        {
                                            if ($outer == null) {
                                                throw new NullPointerException();
                                            }
                                            this.$outer = $outer;
                                            this.indices$1 = indices$1;
                                            this.nnz$1 = nnz$1;
                                        }
                                    }), (Function1)Predef$.MODULE$.conforms()).flatten();
                                    break block5;
                                }
                                if (!(vector instanceof DenseVector) || (option = DenseVector$.MODULE$.unapply(denseVector = (DenseVector)vector)).isEmpty()) break block6;
                                double[] values = (double[])option.get();
                                int n = Predef$.MODULE$.doubleArrayOps(values).size();
                                for (int i = 0; i < n; ++i) {
                                    this.scaled$1[i] = values[i] / this.q$1[i];
                                }
                                iterator = TraversableOnce$.MODULE$.flattenTraversableOnce((TraversableOnce)scala.package$.MODULE$.Iterator().tabulate(n, (Function1)new Serializable(this, n){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$24$$anonfun$apply$4 $outer;
                                    private final int n$4;

                                    /*
                                     * WARNING - void declaration
                                     */
                                    public final ListBuffer<Tuple2<Tuple2<Object, Object>, Object>> apply(int i) {
                                        void var2_2;
                                        ListBuffer buf = new ListBuffer();
                                        double iVal = this.$outer.scaled$1[i];
                                        if (iVal != 0.0 && this.$outer.rand$1.nextDouble() < this.$outer.p$1[i]) {
                                            for (int j = i + 1; j < this.n$4; ++j) {
                                                double jVal = this.$outer.scaled$1[j];
                                                Object object = jVal != 0.0 && this.$outer.rand$1.nextDouble() < this.$outer.p$1[j] ? buf.$plus$eq((Object)new Tuple2((Object)new Tuple2.mcII.sp(i, j), (Object)BoxesRunTime.boxToDouble((double)(iVal * jVal)))) : BoxedUnit.UNIT;
                                            }
                                        }
                                        return var2_2;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                        this.n$4 = n$4;
                                    }
                                }), (Function1)Predef$.MODULE$.conforms()).flatten();
                            }
                            return iterator;
                        }
                        throw new MatchError((Object)vector);
                    }
                    {
                        this.p$1 = p$1;
                        this.q$1 = q$1;
                        this.rand$1 = rand$1;
                        this.scaled$1 = scaled$1;
                    }
                });
            }
            {
                this.pBV$1 = pBV$1;
                this.qBV$1 = qBV$1;
            }
        }, this.rows().mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.Double(), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).reduceByKey((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(double x$4, double x$5) {
                return this.apply$mcDDD$sp(x$4, x$5);
            }

            public double apply$mcDDD$sp(double x$4, double x$5) {
                return x$4 + x$5;
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final MatrixEntry apply(Tuple2<Tuple2<Object, Object>, Object> x0$1) {
                Tuple2<Tuple2<Object, Object>, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    double sim = tuple2._2$mcD$sp();
                    if (tuple22 != null) {
                        int i = tuple22._1$mcI$sp();
                        int j = tuple22._2$mcI$sp();
                        MatrixEntry matrixEntry = new MatrixEntry(i, j, sim);
                        return matrixEntry;
                    }
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(MatrixEntry.class));
        return new CoordinateMatrix((RDD<MatrixEntry>)sims, this.numCols(), this.numCols());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public breeze.linalg.DenseMatrix<Object> toBreeze() {
        void var3_3;
        int m = (int)this.numRows();
        int n = (int)this.numCols();
        breeze.linalg.DenseMatrix mat = DenseMatrix$.MODULE$.zeros$mDc$sp(m, n, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
        IntRef i = new IntRef(0);
        Predef$.MODULE$.refArrayOps((Object[])this.rows().collect()).foreach((Function1)new Serializable(this, mat, i){
            public static final long serialVersionUID = 0L;
            public final breeze.linalg.DenseMatrix mat$1;
            public final IntRef i$2;

            public final void apply(Vector vector) {
                vector.foreachActive((Function2<Object, Object, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$toBreeze$1 $outer;

                    public final void apply(int x0$2, double x1$1) {
                        this.apply$mcVID$sp(x0$2, x1$1);
                    }

                    public void apply$mcVID$sp(int x0$2, double x1$1) {
                        Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(x0$2, x1$1);
                        if (sp2 != null) {
                            int j = sp2._1$mcI$sp();
                            double v = sp2._2$mcD$sp();
                            this.$outer.mat$1.update$mcD$sp(this.$outer.i$2.elem, j, v);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError((Object)sp2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                ++this.i$2.elem;
            }
            {
                this.mat$1 = mat$1;
                this.i$2 = i$2;
            }
        });
        return var3_3;
    }

    private void updateNumRows(long m) {
        if (this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows() <= 0L) {
            this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows_$eq(m);
        } else {
            Predef$.MODULE$.require(this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows() == m, (Function0)new Serializable(this, m){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ RowMatrix $outer;
                private final long m$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The number of rows ", " is different from what specified or previously computed: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.m$1), BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows())}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.m$1 = m$1;
                }
            });
        }
    }

    private final RowMatrix$SVDMode$2$ SVDMode$1(VolatileObjectRef SVDMode$module$1) {
        return SVDMode$module$1.elem == null ? this.SVDMode$1$lzycompute(SVDMode$module$1) : (RowMatrix$SVDMode$2$)((Object)SVDMode$module$1.elem);
    }

    public RowMatrix(RDD<Vector> rows, long nRows, int nCols) {
        this.rows = rows;
        this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows = nRows;
        this.nCols = nCols;
        Logging.class.$init$((Logging)this);
    }

    public RowMatrix(RDD<Vector> rows) {
        this(rows, 0L, 0);
    }
}

