/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.recommendation;

import com.github.fommil.netlib.BLAS;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasPredictionCol$class;
import org.apache.spark.ml.recommendation.ALSModel$;
import org.apache.spark.ml.recommendation.ALSModelParams;
import org.apache.spark.ml.recommendation.ALSModelParams$class;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWritable$class;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StructType;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.JsonDSL$;
import org.json4s.package$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u00055f\u0001B\u0001\u0003\u00015\u0011\u0001\"\u0011'T\u001b>$W\r\u001c\u0006\u0003\u0007\u0011\taB]3d_6lWM\u001c3bi&|gN\u0003\u0002\u0006\r\u0005\u0011Q\u000e\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u000f)]\u00012a\u0004\t\u0013\u001b\u0005!\u0011BA\t\u0005\u0005\u0015iu\u000eZ3m!\t\u0019\u0002!D\u0001\u0003!\t\u0019R#\u0003\u0002\u0017\u0005\tq\u0011\tT*N_\u0012,G\u000eU1sC6\u001c\bC\u0001\r\u001c\u001b\u0005I\"B\u0001\u000e\u0005\u0003\u0011)H/\u001b7\n\u0005qI\"AC'M/JLG/\u00192mK\"Aa\u0004\u0001BC\u0002\u0013\u0005s$A\u0002vS\u0012,\u0012\u0001\t\t\u0003C\u001dr!AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\na\u0001\u0015:fI\u00164\u0017B\u0001\u0015*\u0005\u0019\u0019FO]5oO*\u0011ae\t\u0005\tW\u0001\u0011\t\u0011)A\u0005A\u0005!Q/\u001b3!\u0011!i\u0003A!b\u0001\n\u0003q\u0013\u0001\u0002:b].,\u0012a\f\t\u0003EAJ!!M\u0012\u0003\u0007%sG\u000f\u0003\u00054\u0001\t\u0005\t\u0015!\u00030\u0003\u0015\u0011\u0018M\\6!\u0011!)\u0004A!b\u0001\n\u00031\u0014aC;tKJ4\u0015m\u0019;peN,\u0012a\u000e\t\u0003qmj\u0011!\u000f\u0006\u0003u\u0019\t1a]9m\u0013\ta\u0014HA\u0005ECR\fgI]1nK\"Aa\b\u0001B\u0001B\u0003%q'\u0001\u0007vg\u0016\u0014h)Y2u_J\u001c\b\u0005\u000b\u0002>\u0001B\u0011!%Q\u0005\u0003\u0005\u000e\u0012\u0011\u0002\u001e:b]NLWM\u001c;\t\u0011\u0011\u0003!Q1A\u0005\u0002Y\n1\"\u001b;f[\u001a\u000b7\r^8sg\"Aa\t\u0001B\u0001B\u0003%q'\u0001\u0007ji\u0016lg)Y2u_J\u001c\b\u0005\u000b\u0002F\u0001\"1\u0011\n\u0001C\u0001\t)\u000ba\u0001P5oSRtD#\u0002\nL\u00196s\u0005\"\u0002\u0010I\u0001\u0004\u0001\u0003\"B\u0017I\u0001\u0004y\u0003\"B\u001bI\u0001\u00049\u0004\"\u0002#I\u0001\u00049\u0004\"\u0002)\u0001\t\u0003\t\u0016AC:fiV\u001bXM]\"pYR\u0011!kU\u0007\u0002\u0001!)Ak\u0014a\u0001A\u0005)a/\u00197vK\")a\u000b\u0001C\u0001/\u0006Q1/\u001a;Ji\u0016l7i\u001c7\u0015\u0005IC\u0006\"\u0002+V\u0001\u0004\u0001\u0003\"\u0002.\u0001\t\u0003Y\u0016\u0001E:fiB\u0013X\rZ5di&|gnQ8m)\t\u0011F\fC\u0003U3\u0002\u0007\u0001\u0005C\u0003_\u0001\u0011\u0005s,A\u0005ue\u0006t7OZ8s[R\u0011q\u0007\u0019\u0005\u0006Cv\u0003\raN\u0001\bI\u0006$\u0018m]3u\u0011\u0015\u0019\u0007\u0001\"\u0011e\u0003=!(/\u00198tM>\u0014XnU2iK6\fGCA3l!\t1\u0017.D\u0001h\u0015\tA\u0017(A\u0003usB,7/\u0003\u0002kO\nQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000b1\u0014\u0007\u0019A3\u0002\rM\u001c\u0007.Z7b\u0011\u0015q\u0007\u0001\"\u0011p\u0003\u0011\u0019w\u000e]=\u0015\u0005I\u0001\b\"B9n\u0001\u0004\u0011\u0018!B3yiJ\f\u0007CA:w\u001b\u0005!(BA;\u0005\u0003\u0015\u0001\u0018M]1n\u0013\t9HO\u0001\u0005QCJ\fW.T1q\u0011\u0015I\b\u0001\"\u0011{\u0003\u00159(/\u001b;f+\u0005Y\bC\u0001\r}\u0013\ti\u0018D\u0001\u0005N\u0019^\u0013\u0018\u000e^3sQ\u0011Ax0a\u0003\u0011\t\u0005\u0005\u0011qA\u0007\u0003\u0003\u0007Q1!!\u0002\u0007\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0013\t\u0019AA\u0003TS:\u001cW-\t\u0002\u0002\u000e\u0005)\u0011G\f\u001c/a!\u001a\u0001!!\u0005\u0011\t\u0005\u0005\u00111C\u0005\u0005\u0003+\t\u0019A\u0001\u0007FqB,'/[7f]R\fGnB\u0004\u0002\u001a\tA\t!a\u0007\u0002\u0011\u0005c5+T8eK2\u00042aEA\u000f\r\u0019\t!\u0001#\u0001\u0002 MA\u0011QDA\u0011\u0003O\ti\u0003E\u0002#\u0003GI1!!\n$\u0005\u0019\te.\u001f*fMB!\u0001$!\u000b\u0013\u0013\r\tY#\u0007\u0002\u000b\u001b2\u0013V-\u00193bE2,\u0007c\u0001\u0012\u00020%\u0019\u0011\u0011G\u0012\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000f%\u000bi\u0002\"\u0001\u00026Q\u0011\u00111\u0004\u0005\t\u0003s\ti\u0002\"\u0011\u0002<\u0005!!/Z1e+\t\ti\u0004\u0005\u0003\u0019\u0003\u007f\u0011\u0012bAA!3\tAQ\n\u0014*fC\u0012,'\u000fK\u0003\u00028}\fY\u0001\u0003\u0005\u0002H\u0005uA\u0011IA%\u0003\u0011aw.\u00193\u0015\u0007I\tY\u0005C\u0004\u0002N\u0005\u0015\u0003\u0019\u0001\u0011\u0002\tA\fG\u000f\u001b\u0015\u0006\u0003\u000bz\u00181\u0002\u0004\n\u0003'\ni\u0002AA\u000f\u0003+\u0012a\"\u0011'T\u001b>$W\r\\,sSR,'oE\u0002\u0002RmD!\"!\u0017\u0002R\t\u0005\t\u0015!\u0003\u0013\u0003!Ign\u001d;b]\u000e,\u0007bB%\u0002R\u0011\u0005\u0011Q\f\u000b\u0005\u0003?\n\u0019\u0007\u0005\u0003\u0002b\u0005ESBAA\u000f\u0011\u001d\tI&a\u0017A\u0002IA\u0001\"a\u001a\u0002R\u0011E\u0013\u0011N\u0001\tg\u00064X-S7qYR!\u00111NA9!\r\u0011\u0013QN\u0005\u0004\u0003_\u001a#\u0001B+oSRDq!!\u0014\u0002f\u0001\u0007\u0001EB\u0004\u0002v\u0005uA!a\u001e\u0003\u001d\u0005c5+T8eK2\u0014V-\u00193feN!\u00111OA\u001f\u0011\u001dI\u00151\u000fC\u0001\u0003w\"\"!! \u0011\t\u0005\u0005\u00141\u000f\u0005\u000b\u0003\u0003\u000b\u0019H1A\u0005\n\u0005\r\u0015!C2mCN\u001ch*Y7f+\t\t)\t\u0005\u0003\u0002\b\u0006EUBAAE\u0015\u0011\tY)!$\u0002\t1\fgn\u001a\u0006\u0003\u0003\u001f\u000bAA[1wC&\u0019\u0001&!#\t\u0013\u0005U\u00151\u000fQ\u0001\n\u0005\u0015\u0015AC2mCN\u001ch*Y7fA!A\u0011qIA:\t\u0003\nI\nF\u0002\u0013\u00037Cq!!\u0014\u0002\u0018\u0002\u0007\u0001\u0005\u0003\u0006\u0002 \u0006u\u0011\u0011!C\u0005\u0003C\u000b1B]3bIJ+7o\u001c7wKR\u0011\u00111\u0015\t\u0005\u0003\u000f\u000b)+\u0003\u0003\u0002(\u0006%%AB(cU\u0016\u001cG\u000fK\u0003\u0002\u001e}\fY\u0001K\u0003\u0002\u0018}\fY\u0001")
public class ALSModel
extends Model<ALSModel>
implements ALSModelParams,
MLWritable {
    private final String uid;
    private final int rank;
    private final transient DataFrame userFactors;
    private final transient DataFrame itemFactors;
    private final Param<String> userCol;
    private final Param<String> itemCol;
    private final Param<String> predictionCol;

    public static ALSModel load(String string) {
        return ALSModel$.MODULE$.load(string);
    }

    public static MLReader<ALSModel> read() {
        return ALSModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable$class.save(this, path);
    }

    @Override
    public Param<String> userCol() {
        return this.userCol;
    }

    @Override
    public Param<String> itemCol() {
        return this.itemCol;
    }

    @Override
    public void org$apache$spark$ml$recommendation$ALSModelParams$_setter_$userCol_$eq(Param x$1) {
        this.userCol = x$1;
    }

    @Override
    public void org$apache$spark$ml$recommendation$ALSModelParams$_setter_$itemCol_$eq(Param x$1) {
        this.itemCol = x$1;
    }

    @Override
    public String getUserCol() {
        return ALSModelParams$class.getUserCol(this);
    }

    @Override
    public String getItemCol() {
        return ALSModelParams$class.getItemCol(this);
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol$class.getPredictionCol(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public int rank() {
        return this.rank;
    }

    public DataFrame userFactors() {
        return this.userFactors;
    }

    public DataFrame itemFactors() {
        return this.itemFactors;
    }

    public ALSModel setUserCol(String value) {
        return (ALSModel)this.set(this.userCol(), value);
    }

    public ALSModel setItemCol(String value) {
        return (ALSModel)this.set(this.itemCol(), value);
    }

    public ALSModel setPredictionCol(String value) {
        return (ALSModel)this.set(this.predictionCol(), value);
    }

    @Override
    public DataFrame transform(DataFrame dataset) {
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(ALSModel.class.getClassLoader());
        JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(ALSModel.class.getClassLoader());
        public final class Org_apache_spark_ml_recommendation_ALSModel$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.TypeRef().apply($u.SingleType().apply($u.SingleType().apply($u.build().thisPrefix($m.RootClass()), $m.staticPackage("scala")), $m.staticModule("scala.package")), $u.build().selectType(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticModule("scala.package")).asModule()).moduleClass(), "Seq"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Float")).asType()).toTypeConstructor()})));
            }

            public Org_apache_spark_ml_recommendation_ALSModel$$typecreator1$1(ALSModel $outer) {
            }
        }
        public final class Org_apache_spark_ml_recommendation_ALSModel$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.TypeRef().apply($u.SingleType().apply($u.SingleType().apply($u.build().thisPrefix($m.RootClass()), $m.staticPackage("scala")), $m.staticModule("scala.package")), $u.build().selectType(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticModule("scala.package")).asModule()).moduleClass(), "Seq"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Float")).asType()).toTypeConstructor()})));
            }

            public Org_apache_spark_ml_recommendation_ALSModel$$typecreator2$1(ALSModel $outer) {
            }
        }
        UserDefinedFunction predict2 = functions$.MODULE$.udf((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSModel $outer;

            public final float apply(Seq<Object> userFeatures, Seq<Object> itemFeatures) {
                return userFeatures == null || itemFeatures == null ? Float.NaN : BLAS.getInstance().sdot(this.$outer.rank(), (float[])userFeatures.toArray(ClassTag$.MODULE$.Float()), 1, (float[])itemFeatures.toArray(ClassTag$.MODULE$.Float()), 1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Float(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSModel$$typecreator1$1(this)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_recommendation_ALSModel$$typecreator2$1(this)));
        return dataset.join(this.userFactors(), dataset.apply(this.$(this.userCol())).$eq$eq$eq((Object)this.userFactors().apply("id")), "left").join(this.itemFactors(), dataset.apply(this.$(this.itemCol())).$eq$eq$eq((Object)this.itemFactors().apply("id")), "left").select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{dataset.apply("*"), predict2.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.userFactors().apply("features"), this.itemFactors().apply("features")})).as(this.$(this.predictionCol()))}));
    }

    @Override
    public StructType transformSchema(StructType schema) {
        SchemaUtils$.MODULE$.checkColumnType(schema, this.$(this.userCol()), (DataType)IntegerType$.MODULE$, SchemaUtils$.MODULE$.checkColumnType$default$4());
        SchemaUtils$.MODULE$.checkColumnType(schema, this.$(this.itemCol()), (DataType)IntegerType$.MODULE$, SchemaUtils$.MODULE$.checkColumnType$default$4());
        return SchemaUtils$.MODULE$.appendColumn(schema, this.$(this.predictionCol()), (DataType)FloatType$.MODULE$, SchemaUtils$.MODULE$.appendColumn$default$4());
    }

    @Override
    public ALSModel copy(ParamMap extra) {
        ALSModel copied = new ALSModel(this.uid(), this.rank(), this.userFactors(), this.itemFactors());
        return (ALSModel)((Model)this.copyValues(copied, extra)).setParent(this.parent());
    }

    @Override
    public MLWriter write() {
        return new ALSModelWriter(this);
    }

    public ALSModel(String uid, int rank, DataFrame userFactors, DataFrame itemFactors) {
        this.uid = uid;
        this.rank = rank;
        this.userFactors = userFactors;
        this.itemFactors = itemFactors;
        HasPredictionCol$class.$init$(this);
        ALSModelParams$class.$init$(this);
        MLWritable$class.$init$(this);
    }

    public static class ALSModelWriter
    extends MLWriter {
        private final ALSModel instance;

        @Override
        public void saveImpl(String path) {
            Tuple2 extraMetadata = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"rank"), (Object)BoxesRunTime.boxToInteger((int)this.instance.rank()));
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sc(), (Option<JsonAST.JObject>)new Some((Object)JsonDSL$.MODULE$.pair2jvalue(extraMetadata, (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final JsonAST.JValue apply(int x) {
                    return JsonDSL$.MODULE$.int2jvalue(x);
                }
            })), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
            String userPath = new Path(path, "userFactors").toString();
            this.instance.userFactors().write().format("parquet").save(userPath);
            String itemPath = new Path(path, "itemFactors").toString();
            this.instance.itemFactors().write().format("parquet").save(itemPath);
        }

        public ALSModelWriter(ALSModel instance) {
            this.instance = instance;
        }
    }

    public static class ALSModelReader
    extends MLReader<ALSModel> {
        private final String className = ALSModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public ALSModel load(String path) {
            DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
            DefaultFormats$ format2 = DefaultFormats$.MODULE$;
            int rank = BoxesRunTime.unboxToInt((Object)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(metadata.metadata()).$bslash("rank")).extract((Formats)format2, (Manifest)ManifestFactory$.MODULE$.Int()));
            String userPath = new Path(path, "userFactors").toString();
            DataFrame userFactors = this.sqlContext().read().format("parquet").load(userPath);
            String itemPath = new Path(path, "itemFactors").toString();
            DataFrame itemFactors = this.sqlContext().read().format("parquet").load(itemPath);
            ALSModel model = new ALSModel(metadata.uid(), rank, userFactors, itemFactors);
            DefaultParamsReader$.MODULE$.getAndSetParams(model, metadata);
            return model;
        }
    }
}

