/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.param;

import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.ParamValidators$;
import org.apache.spark.ml.util.Identifiable;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import scala.Function0;
import scala.Function1;
import scala.NotImplementedError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b\u0001B\u0001\u0003\u00015\u0011Q\u0001U1sC6T!a\u0001\u0003\u0002\u000bA\f'/Y7\u000b\u0005\u00151\u0011AA7m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\u000b\u0003\u001dQ\u001a2\u0001A\b\u0016!\t\u00012#D\u0001\u0012\u0015\u0005\u0011\u0012!B:dC2\f\u0017B\u0001\u000b\u0012\u0005\u0019\te.\u001f*fMB\u0011\u0001CF\u0005\u0003/E\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001\"\u0007\u0001\u0003\u0006\u0004%\tAG\u0001\u0007a\u0006\u0014XM\u001c;\u0016\u0003m\u0001\"\u0001H\u0010\u000f\u0005Ai\u0012B\u0001\u0010\u0012\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001%\t\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005y\t\u0002\u0002C\u0012\u0001\u0005\u0003\u0005\u000b\u0011B\u000e\u0002\u000fA\f'/\u001a8uA!AQ\u0005\u0001BC\u0002\u0013\u0005!$\u0001\u0003oC6,\u0007\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u000e\u0002\u000b9\fW.\u001a\u0011\t\u0011%\u0002!Q1A\u0005\u0002i\t1\u0001Z8d\u0011!Y\u0003A!A!\u0002\u0013Y\u0012\u0001\u00023pG\u0002B\u0001\"\f\u0001\u0003\u0006\u0004%\tAL\u0001\bSN4\u0016\r\\5e+\u0005y\u0003\u0003\u0002\t1euJ!!M\t\u0003\u0013\u0019+hn\u0019;j_:\f\u0004CA\u001a5\u0019\u0001!Q!\u000e\u0001C\u0002Y\u0012\u0011\u0001V\t\u0003oi\u0002\"\u0001\u0005\u001d\n\u0005e\n\"a\u0002(pi\"Lgn\u001a\t\u0003!mJ!\u0001P\t\u0003\u0007\u0005s\u0017\u0010\u0005\u0002\u0011}%\u0011q(\u0005\u0002\b\u0005>|G.Z1o\u0011!\t\u0005A!A!\u0002\u0013y\u0013\u0001C5t-\u0006d\u0017\u000e\u001a\u0011\t\u000b\r\u0003A\u0011\u0001#\u0002\rqJg.\u001b;?)\u0015)u\tS%K!\r1\u0005AM\u0007\u0002\u0005!)\u0011D\u0011a\u00017!)QE\u0011a\u00017!)\u0011F\u0011a\u00017!)QF\u0011a\u0001_!)1\t\u0001C\u0001\u0019R)Q)\u0014+V-\")\u0011d\u0013a\u0001\u001dB\u0011qJU\u0007\u0002!*\u0011\u0011\u000bB\u0001\u0005kRLG.\u0003\u0002T!\na\u0011\nZ3oi&4\u0017.\u00192mK\")Qe\u0013a\u00017!)\u0011f\u0013a\u00017!)Qf\u0013a\u0001_!)1\t\u0001C\u00011R!Q)\u0017.\\\u0011\u0015Ir\u000b1\u0001\u001c\u0011\u0015)s\u000b1\u0001\u001c\u0011\u0015Is\u000b1\u0001\u001c\u0011\u0015\u0019\u0005\u0001\"\u0001^)\u0011)el\u00181\t\u000bea\u0006\u0019\u0001(\t\u000b\u0015b\u0006\u0019A\u000e\t\u000b%b\u0006\u0019A\u000e\t\r\t\u0004A\u0011\u0001\u0002d\u0003!1\u0018\r\\5eCR,GC\u00013h!\t\u0001R-\u0003\u0002g#\t!QK\\5u\u0011\u0015A\u0017\r1\u00013\u0003\u00151\u0018\r\\;f\u0011\u0015Q\u0007\u0001\"\u0001l\u0003\u00059HC\u00017p!\r1UNM\u0005\u0003]\n\u0011\u0011\u0002U1sC6\u0004\u0016-\u001b:\t\u000b!L\u0007\u0019\u0001\u001a\t\u000bE\u0004A\u0011\u0001:\u0002\u001d\u0011j\u0017N\\;tI\u001d\u0014X-\u0019;feR\u0011An\u001d\u0005\u0006QB\u0004\rA\r\u0005\u0006k\u0002!\tA^\u0001\u000bUN|g.\u00128d_\u0012,GCA\u000ex\u0011\u0015AG\u000f1\u00013\u0011\u0015I\b\u0001\"\u0001{\u0003)Q7o\u001c8EK\u000e|G-\u001a\u000b\u0003emDQ\u0001 =A\u0002m\tAA[:p]\")a\u0010\u0001C#\u007f\u0006AAo\\*ue&tw\rF\u0001\u001c\u0011\u001d\t\u0019\u0001\u0001C#\u0003\u000b\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003\u000f\u00012\u0001EA\u0005\u0013\r\tY!\u0005\u0002\u0004\u0013:$\bbBA\b\u0001\u0011\u0015\u0013\u0011C\u0001\u0007KF,\u0018\r\\:\u0015\u0007u\n\u0019\u0002C\u0004\u0002\u0016\u00055\u0001\u0019\u0001\u001e\u0002\u0007=\u0014'\u000eK\u0002\u0001\u00033\u0001B!a\u0007\u0002\"5\u0011\u0011Q\u0004\u0006\u0004\u0003?1\u0011AC1o]>$\u0018\r^5p]&!\u00111EA\u000f\u00051!UM^3m_B,'/\u00119j\u0001")
public class Param<T>
implements Serializable {
    private final String parent;
    private final String name;
    private final String doc;
    private final Function1<T, Object> isValid;

    public String parent() {
        return this.parent;
    }

    public String name() {
        return this.name;
    }

    public String doc() {
        return this.doc;
    }

    public Function1<T, Object> isValid() {
        return this.isValid;
    }

    public void validate(T value) {
        String string;
        if (BoxesRunTime.unboxToBoolean((Object)this.isValid().apply(value))) {
            return;
        }
        T t = value;
        if (ScalaRunTime$.MODULE$.isArray(t, 1)) {
            T t2 = t;
            string = Predef$.MODULE$.genericArrayOps(t2).mkString("[", ",", "]");
        } else {
            string = value.toString();
        }
        String valueToString = string;
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " parameter ", " given invalid value ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.parent(), this.name(), valueToString})));
    }

    public ParamPair<T> w(T value) {
        return this.$minus$greater(value);
    }

    public ParamPair<T> $minus$greater(T value) {
        return new ParamPair<T>(this, value);
    }

    public String jsonEncode(T value) {
        block4: {
            String string;
            block3: {
                T t;
                block2: {
                    t = value;
                    if (!(t instanceof String)) break block2;
                    String string2 = (String)t;
                    string = JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JsonAST.JValue)package$.MODULE$.JString().apply(string2)));
                    break block3;
                }
                if (!(t instanceof Vector)) break block4;
                T t2 = t;
                string = ((Vector)t2).toJson();
            }
            return string;
        }
        throw new NotImplementedError(new StringBuilder().append((Object)"The default jsonEncode only supports string and vector. ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " must override jsonEncode for ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getClass().getName(), value.getClass().getName()}))).toString());
    }

    public T jsonDecode(String json) {
        block4: {
            Object object;
            block3: {
                JsonAST.JValue jValue;
                block2: {
                    jValue = JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(json), JsonMethods$.MODULE$.parse$default$2());
                    if (!(jValue instanceof JsonAST.JString)) break block2;
                    JsonAST.JString jString = (JsonAST.JString)jValue;
                    String x = jString.s();
                    object = x;
                    break block3;
                }
                if (!(jValue instanceof JsonAST.JObject)) break block4;
                JsonAST.JObject jObject = (JsonAST.JObject)jValue;
                List v = jObject.obj();
                List keys = (List)v.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Tuple2<String, JsonAST.JValue> x$1) {
                        return (String)x$1._1();
                    }
                }, List$.MODULE$.canBuildFrom());
                Predef$.MODULE$.assert(keys.contains((Object)"type") && keys.contains((Object)"values"), (Function0)new Serializable(this, json){
                    public static final long serialVersionUID = 0L;
                    private final String json$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expect a JSON serialized vector but cannot find fields 'type' and 'values' in ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.json$1}));
                    }
                    {
                        this.json$1 = json$1;
                    }
                });
                object = Vectors$.MODULE$.fromJson(json);
            }
            return (T)object;
        }
        throw new NotImplementedError(new StringBuilder().append((Object)"The default jsonDecode only supports string and vector. ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " must override jsonDecode to support its value type."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getClass().getName()}))).toString());
    }

    public final String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "__", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.parent(), this.name()}));
    }

    public final int hashCode() {
        return ScalaRunTime$.MODULE$.hash((Object)this.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object obj) {
        Object object = obj;
        if (!(object instanceof Param)) return false;
        Param param = (Param)object;
        String string = param.parent();
        String string2 = this.parent();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = param.name();
        String string4 = this.name();
        if (string3 == null) {
            if (string4 == null) return true;
            return false;
        } else {
            if (!string3.equals(string4)) return false;
            return true;
        }
    }

    public Param(String parent, String name, String doc, Function1<T, Object> isValid) {
        this.parent = parent;
        this.name = name;
        this.doc = doc;
        this.isValid = isValid;
    }

    public Param(Identifiable parent, String name, String doc, Function1<T, Object> isValid) {
        this(parent.uid(), name, doc, isValid);
    }

    public Param(String parent, String name, String doc) {
        this(parent, name, doc, ParamValidators$.MODULE$.alwaysTrue());
    }

    public Param(Identifiable parent, String name, String doc) {
        this(parent.uid(), name, doc);
    }
}

