/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree.impl;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.mllib.tree.impl.BaggedPoint;
import org.apache.spark.mllib.tree.impl.NodeIdCache$;
import org.apache.spark.mllib.tree.impl.NodeIndexUpdater;
import org.apache.spark.mllib.tree.impl.TreePoint;
import org.apache.spark.mllib.tree.model.Bin;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0005}b!B\u0001\u0003\u0001!q!a\u0003(pI\u0016LEmQ1dQ\u0016T!a\u0001\u0003\u0002\t%l\u0007\u000f\u001c\u0006\u0003\u000b\u0019\tA\u0001\u001e:fK*\u0011q\u0001C\u0001\u0006[2d\u0017N\u0019\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sON\u0011\u0001a\u0004\t\u0003!Mi\u0011!\u0005\u0006\u0002%\u0005)1oY1mC&\u0011A#\u0005\u0002\u0007\u0003:L(+\u001a4\t\u0011Y\u0001!\u00111A\u0005\u0002a\t1C\\8eK&#7OR8s\u0013:\u001cH/\u00198dKN\u001c\u0001!F\u0001\u001a!\rQRdH\u0007\u00027)\u0011A\u0004C\u0001\u0004e\u0012$\u0017B\u0001\u0010\u001c\u0005\r\u0011F\t\u0012\t\u0004!\u0001\u0012\u0013BA\u0011\u0012\u0005\u0015\t%O]1z!\t\u00012%\u0003\u0002%#\t\u0019\u0011J\u001c;\t\u0011\u0019\u0002!\u00111A\u0005\u0002\u001d\nqC\\8eK&#7OR8s\u0013:\u001cH/\u00198dKN|F%Z9\u0015\u0005!Z\u0003C\u0001\t*\u0013\tQ\u0013C\u0001\u0003V]&$\bb\u0002\u0017&\u0003\u0003\u0005\r!G\u0001\u0004q\u0012\n\u0004\u0002\u0003\u0018\u0001\u0005\u0003\u0005\u000b\u0015B\r\u0002)9|G-Z%eg\u001a{'/\u00138ti\u0006t7-Z:!\u0011!\u0001\u0004A!b\u0001\n\u0003\t\u0014AE2iK\u000e\\\u0007o\\5oi&sG/\u001a:wC2,\u0012A\t\u0005\tg\u0001\u0011\t\u0011)A\u0005E\u0005\u00192\r[3dWB|\u0017N\u001c;J]R,'O^1mA!)Q\u0007\u0001C\u0001m\u00051A(\u001b8jiz\"2aN\u001d;!\tA\u0004!D\u0001\u0003\u0011\u00151B\u00071\u0001\u001a\u0011\u0015\u0001D\u00071\u0001#\u0011\u001da\u0004\u00011A\u0005\na\tq\u0003\u001d:fm:{G-Z%eg\u001a{'/\u00138ti\u0006t7-Z:\t\u000fy\u0002\u0001\u0019!C\u0005\u007f\u0005Y\u0002O]3w\u001d>$W-\u00133t\r>\u0014\u0018J\\:uC:\u001cWm]0%KF$\"\u0001\u000b!\t\u000f1j\u0014\u0011!a\u00013!1!\t\u0001Q!\ne\t\u0001\u0004\u001d:fm:{G-Z%eg\u001a{'/\u00138ti\u0006t7-Z:!\u0011\u001d!\u0005A1A\u0005\n\u0015\u000bqb\u00195fG.\u0004x.\u001b8u#V,W/Z\u000b\u0002\rB\u0019q\tT\r\u000e\u0003!S!!\u0013&\u0002\u000f5,H/\u00192mK*\u00111*E\u0001\u000bG>dG.Z2uS>t\u0017BA'I\u0005\u0015\tV/Z;f\u0011\u0019y\u0005\u0001)A\u0005\r\u0006\u00012\r[3dWB|\u0017N\u001c;Rk\u0016,X\r\t\u0005\b#\u0002\u0001\r\u0011\"\u00032\u00039\u0011H\rZ+qI\u0006$XmQ8v]RDqa\u0015\u0001A\u0002\u0013%A+\u0001\nsI\u0012,\u0006\u000fZ1uK\u000e{WO\u001c;`I\u0015\fHC\u0001\u0015V\u0011\u001da#+!AA\u0002\tBaa\u0016\u0001!B\u0013\u0011\u0013a\u0004:eIV\u0003H-\u0019;f\u0007>,h\u000e\u001e\u0011\t\u000be\u0003A\u0011\u0001.\u0002#U\u0004H-\u0019;f\u001d>$W-\u00138eS\u000e,7\u000f\u0006\u0003)7\u0012l\u0007\"\u0002/Y\u0001\u0004i\u0016\u0001\u00023bi\u0006\u00042AG\u000f_!\rAt,Y\u0005\u0003A\n\u00111BQ1hO\u0016$\u0007k\\5oiB\u0011\u0001HY\u0005\u0003G\n\u0011\u0011\u0002\u0016:fKB{\u0017N\u001c;\t\u000b\u0015D\u0006\u0019\u00014\u0002\u001d9|G-Z%e+B$\u0017\r^3sgB\u0019\u0001\u0003I4\u0011\t\u001dC'E[\u0005\u0003S\"\u00131!T1q!\tA4.\u0003\u0002m\u0005\t\u0001bj\u001c3f\u0013:$W\r_+qI\u0006$XM\u001d\u0005\u0006]b\u0003\ra\\\u0001\u0005E&t7\u000fE\u0002\u0011AA\u00042\u0001\u0005\u0011r!\t\u0011X/D\u0001t\u0015\t!H!A\u0003n_\u0012,G.\u0003\u0002wg\n\u0019!)\u001b8\t\u000ba\u0004A\u0011A=\u0002)\u0011,G.\u001a;f\u00032d7\t[3dWB|\u0017N\u001c;t)\u0005A\u0003F\u0001\u0001|!\tax0D\u0001~\u0015\tq\b\"\u0001\u0006b]:|G/\u0019;j_:L1!!\u0001~\u00051!UM^3m_B,'/\u00119j\u000f!\t)A\u0001E\u0001\u0011\u0005\u001d\u0011a\u0003(pI\u0016LEmQ1dQ\u0016\u00042\u0001OA\u0005\r\u001d\t!\u0001#\u0001\t\u0003\u0017\u00192!!\u0003\u0010\u0011\u001d)\u0014\u0011\u0002C\u0001\u0003\u001f!\"!a\u0002\t\u0011\u0005M\u0011\u0011\u0002C\u0001\u0003+\tA!\u001b8jiRIq'a\u0006\u0002\u001a\u0005u\u0011q\u0004\u0005\u00079\u0006E\u0001\u0019A/\t\u000f\u0005m\u0011\u0011\u0003a\u0001E\u0005Aa.^7Ue\u0016,7\u000f\u0003\u00041\u0003#\u0001\rA\t\u0005\n\u0003C\t\t\u0002%AA\u0002\t\nq!\u001b8jiZ\u000bG\u000e\u0003\u0006\u0002&\u0005%\u0011\u0013!C\u0001\u0003O\ta\"\u001b8ji\u0012\"WMZ1vYR$C'\u0006\u0002\u0002*)\u001a!%a\u000b,\u0005\u00055\u0002\u0003BA\u0018\u0003oi!!!\r\u000b\t\u0005M\u0012QG\u0001\nk:\u001c\u0007.Z2lK\u0012T!A`\t\n\t\u0005e\u0012\u0011\u0007\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007fAA\u0005w\"\u001a\u00111A>")
public class NodeIdCache {
    private RDD<int[]> nodeIdsForInstances;
    private final int checkpointInterval;
    private RDD<int[]> prevNodeIdsForInstances;
    private final Queue<RDD<int[]>> checkpointQueue;
    private int rddUpdateCount;

    public static int init$default$4() {
        return NodeIdCache$.MODULE$.init$default$4();
    }

    public static NodeIdCache init(RDD<BaggedPoint<TreePoint>> rDD, int n, int n2, int n3) {
        return NodeIdCache$.MODULE$.init(rDD, n, n2, n3);
    }

    public RDD<int[]> nodeIdsForInstances() {
        return this.nodeIdsForInstances;
    }

    public void nodeIdsForInstances_$eq(RDD<int[]> x$1) {
        this.nodeIdsForInstances = x$1;
    }

    public int checkpointInterval() {
        return this.checkpointInterval;
    }

    private RDD<int[]> prevNodeIdsForInstances() {
        return this.prevNodeIdsForInstances;
    }

    private void prevNodeIdsForInstances_$eq(RDD<int[]> x$1) {
        this.prevNodeIdsForInstances = x$1;
    }

    private Queue<RDD<int[]>> checkpointQueue() {
        return this.checkpointQueue;
    }

    private int rddUpdateCount() {
        return this.rddUpdateCount;
    }

    private void rddUpdateCount_$eq(int x$1) {
        this.rddUpdateCount = x$1;
    }

    public void updateNodeIndices(RDD<BaggedPoint<TreePoint>> data, Map<Object, NodeIndexUpdater>[] nodeIdUpdaters, Bin[][] bins) {
        BoxedUnit boxedUnit;
        if (this.prevNodeIdsForInstances() == null) {
            boxedUnit = BoxedUnit.UNIT;
        } else {
            RDD<int[]> qual$1 = this.prevNodeIdsForInstances();
            boolean x$2 = qual$1.unpersist$default$1();
            boxedUnit = qual$1.unpersist(x$2);
        }
        this.prevNodeIdsForInstances_$eq(this.nodeIdsForInstances());
        this.nodeIdsForInstances_$eq((RDD<int[]>)data.zip(this.nodeIdsForInstances(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))).map((Function1)new Serializable(this, nodeIdUpdaters, bins){
            public static final long serialVersionUID = 0L;
            private final Map[] nodeIdUpdaters$1;
            private final Bin[][] bins$1;

            public final int[] apply(Tuple2<BaggedPoint<TreePoint>, int[]> x0$1) {
                Tuple2<BaggedPoint<TreePoint>, int[]> tuple2 = x0$1;
                if (tuple2 != null) {
                    BaggedPoint point = (BaggedPoint)tuple2._1();
                    int[] node = (int[])tuple2._2();
                    for (int treeId = 0; treeId < this.nodeIdUpdaters$1.length; ++treeId) {
                        int newNodeIndex;
                        NodeIndexUpdater nodeIdUpdater = (NodeIndexUpdater)this.nodeIdUpdaters$1[treeId].getOrElse((Object)BoxesRunTime.boxToInteger((int)node[treeId]), (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Null$ apply() {
                                return null;
                            }
                        });
                        if (nodeIdUpdater == null) continue;
                        node[treeId] = newNodeIndex = nodeIdUpdater.updateNodeIndex(((TreePoint)point.datum()).binnedFeatures(), this.bins$1);
                    }
                    int[] nArray = node;
                    return nArray;
                }
                throw new MatchError(tuple2);
            }
            {
                this.nodeIdUpdaters$1 = nodeIdUpdaters$1;
                this.bins$1 = bins$1;
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))));
        this.nodeIdsForInstances().persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
        this.rddUpdateCount_$eq(this.rddUpdateCount() + 1);
        if (this.nodeIdsForInstances().sparkContext().getCheckpointDir().nonEmpty() && this.rddUpdateCount() % this.checkpointInterval() == 0) {
            boolean canDelete = true;
            while (this.checkpointQueue().size() > 1 && canDelete) {
                Object object;
                if (((RDD)this.checkpointQueue().get(1).get()).getCheckpointFile().isDefined()) {
                    RDD old = (RDD)this.checkpointQueue().dequeue();
                    FileSystem fs = FileSystem.get((Configuration)old.sparkContext().hadoopConfiguration());
                    object = BoxesRunTime.boxToBoolean((boolean)fs.delete(new Path((String)old.getCheckpointFile().get()), true));
                    continue;
                }
                canDelete = false;
                object = BoxedUnit.UNIT;
            }
            this.nodeIdsForInstances().checkpoint();
            this.checkpointQueue().enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RDD[]{this.nodeIdsForInstances()}));
        }
    }

    public void deleteAllCheckpoints() {
        while (this.checkpointQueue().nonEmpty()) {
            RDD old = (RDD)this.checkpointQueue().dequeue();
            old.getCheckpointFile().foreach((Function1)new Serializable(this, old){
                public static final long serialVersionUID = 0L;
                private final RDD old$1;

                public final boolean apply(String checkpointFile) {
                    FileSystem fs = FileSystem.get((Configuration)this.old$1.sparkContext().hadoopConfiguration());
                    return fs.delete(new Path(checkpointFile), true);
                }
                {
                    this.old$1 = old$1;
                }
            });
        }
        if (this.prevNodeIdsForInstances() != null) {
            RDD<int[]> qual$2 = this.prevNodeIdsForInstances();
            boolean x$3 = qual$2.unpersist$default$1();
            qual$2.unpersist(x$3);
        }
    }

    public NodeIdCache(RDD<int[]> nodeIdsForInstances, int checkpointInterval) {
        this.nodeIdsForInstances = nodeIdsForInstances;
        this.checkpointInterval = checkpointInterval;
        this.prevNodeIdsForInstances = null;
        this.checkpointQueue = (Queue)Queue$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.rddUpdateCount = 0;
    }
}

