/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg;

import org.apache.spark.SparkException;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.DenseVector$;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.SparseVector$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.NumericParser$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IndexedSeq;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class Vectors$ {
    public static final Vectors$ MODULE$;
    private final int MAX_HASH_NNZ;

    static {
        new Vectors$();
    }

    public Vector dense(double firstValue, double ... otherValues) {
        return this.dense(firstValue, (Seq<Object>)Predef$.MODULE$.wrapDoubleArray(otherValues));
    }

    public Vector dense(double firstValue, Seq<Object> otherValues) {
        double d = firstValue;
        return new DenseVector((double[])((TraversableOnce)otherValues.$plus$colon((Object)BoxesRunTime.boxToDouble((double)d), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double()));
    }

    public Vector dense(double[] values) {
        return new DenseVector(values);
    }

    public Vector sparse(int size, int[] indices, double[] values) {
        return new SparseVector(size, indices, values);
    }

    public Vector sparse(int size, Seq<Tuple2<Object, Object>> elements) {
        Predef$.MODULE$.require(size > 0, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The size of the requested sparse vector must be greater than 0.";
            }
        });
        Tuple2 tuple2 = ((GenericTraversableTemplate)elements.sortBy((Function1)new anonfun.1(), (Ordering)Ordering.Int$.MODULE$)).unzip((Function1)Predef$.MODULE$.conforms());
        if (tuple2 != null) {
            Tuple2 tuple22;
            Seq indices = (Seq)tuple2._1();
            Seq values = (Seq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)indices, (Object)values);
            Seq indices2 = (Seq)tuple23._1();
            Seq values2 = (Seq)tuple23._2();
            IntRef prev = new IntRef(-1);
            indices2.foreach((Function1)new Serializable(prev){
                public static final long serialVersionUID = 0L;
                private final IntRef prev$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    Predef$.MODULE$.require(this.prev$1.elem < i, (Function0)new Serializable(this, i){
                        public static final long serialVersionUID = 0L;
                        private final int i$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found duplicate indices: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.i$1)}));
                        }
                        {
                            this.i$1 = i$1;
                        }
                    });
                    this.prev$1.elem = i;
                }
                {
                    this.prev$1 = prev$1;
                }
            });
            Predef$.MODULE$.require(prev.elem < size, (Function0)new Serializable(size, prev){
                public static final long serialVersionUID = 0L;
                private final int size$1;
                private final IntRef prev$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"You may not write an element to index ", " because the declared "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.prev$1.elem)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"size of your vector is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.size$1)}))).toString();
                }
                {
                    this.size$1 = size$1;
                    this.prev$1 = prev$1;
                }
            });
            return new SparseVector(size, (int[])indices2.toArray(ClassTag$.MODULE$.Int()), (double[])values2.toArray(ClassTag$.MODULE$.Double()));
        }
        throw new MatchError((Object)tuple2);
    }

    public Vector sparse(int size, Iterable<Tuple2<Integer, Double>> elements) {
        return this.sparse(size, (Seq<Tuple2<Object, Object>>)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(elements).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Tuple2<Integer, Double> x0$1) {
                Tuple2<Integer, Double> tuple2 = x0$1;
                if (tuple2 != null) {
                    Integer i = (Integer)tuple2._1();
                    Double x = (Double)tuple2._2();
                    Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(i.intValue(), x.doubleValue());
                    return sp2;
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSeq());
    }

    public Vector zeros(int size) {
        return new DenseVector(new double[size]);
    }

    public Vector parse(String s) {
        return this.parseNumeric(NumericParser$.MODULE$.parse(s));
    }

    public Vector parseNumeric(Object any) {
        Object object;
        block4: {
            Vector vector;
            block3: {
                Seq seq;
                Some some;
                block2: {
                    object = any;
                    if (!(object instanceof double[])) break block2;
                    double[] dArray = (double[])object;
                    vector = this.dense(dArray);
                    break block3;
                }
                if (!(object instanceof Seq) || (some = Seq$.MODULE$.unapplySeq(seq = (Seq)object)).isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(3) != 0) break block4;
                Object size = ((SeqLike)some.get()).apply(0);
                Object indices = ((SeqLike)some.get()).apply(1);
                Object values = ((SeqLike)some.get()).apply(2);
                if (!(size instanceof Double)) break block4;
                double d = BoxesRunTime.unboxToDouble((Object)size);
                if (!(indices instanceof double[])) break block4;
                double[] dArray = (double[])indices;
                if (!(values instanceof double[])) break block4;
                double[] dArray2 = (double[])values;
                vector = this.sparse((int)d, (int[])Predef$.MODULE$.doubleArrayOps(dArray).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final int apply(double x$7) {
                        return this.apply$mcID$sp(x$7);
                    }

                    public int apply$mcID$sp(double x$7) {
                        return (int)x$7;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())), dArray2);
            }
            return vector;
        }
        throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot parse ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{object})));
    }

    public Vector fromBreeze(breeze.linalg.Vector<Object> breezeVector) {
        breeze.linalg.Vector<Object> vector;
        block6: {
            Vector vector2;
            block5: {
                block4: {
                    vector = breezeVector;
                    if (!(vector instanceof breeze.linalg.DenseVector)) break block4;
                    breeze.linalg.DenseVector denseVector = (breeze.linalg.DenseVector)vector;
                    vector2 = denseVector.offset() == 0 && denseVector.stride() == 1 && denseVector.length() == denseVector.data$mcD$sp().length ? new DenseVector(denseVector.data$mcD$sp()) : new DenseVector(denseVector.toArray$mcD$sp(ClassTag$.MODULE$.Double()));
                    break block5;
                }
                if (!(vector instanceof breeze.linalg.SparseVector)) break block6;
                breeze.linalg.SparseVector sparseVector = (breeze.linalg.SparseVector)vector;
                vector2 = sparseVector.index().length == sparseVector.used() ? new SparseVector(sparseVector.length(), sparseVector.index(), sparseVector.data$mcD$sp()) : new SparseVector(sparseVector.length(), (int[])Predef$.MODULE$.intArrayOps(sparseVector.index()).slice(0, sparseVector.used()), (double[])Predef$.MODULE$.doubleArrayOps(sparseVector.data$mcD$sp()).slice(0, sparseVector.used()));
            }
            return vector2;
        }
        if (vector != null) {
            breeze.linalg.Vector<Object> vector3 = vector;
            throw scala.sys.package$.MODULE$.error(new StringBuilder().append((Object)"Unsupported Breeze vector type: ").append((Object)vector3.getClass().getName()).toString());
        }
        throw new MatchError(vector);
    }

    public double norm(Vector vector, double p) {
        Vector vector2;
        block15: {
            double d;
            double[] dArray;
            block14: {
                double[] vs;
                SparseVector sparseVector;
                Option<Tuple3<Object, int[], double[]>> option;
                block13: {
                    double[] vs2;
                    DenseVector denseVector;
                    Option<double[]> option2;
                    Predef$.MODULE$.require(p >= 1.0, (Function0)new Serializable(p){
                        public static final long serialVersionUID = 0L;
                        private final double p$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"To compute the p-norm of the vector, we require that you specify a p>=1. ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"You specified p=", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.p$1)}))).toString();
                        }
                        {
                            this.p$1 = p$1;
                        }
                    });
                    vector2 = vector;
                    if (!(vector2 instanceof DenseVector) || (option2 = DenseVector$.MODULE$.unapply(denseVector = (DenseVector)vector2)).isEmpty()) break block13;
                    dArray = vs2 = (double[])option2.get();
                    break block14;
                }
                if (!(vector2 instanceof SparseVector) || (option = SparseVector$.MODULE$.unapply(sparseVector = (SparseVector)vector2)).isEmpty()) break block15;
                dArray = vs = (double[])((Tuple3)option.get())._3();
            }
            double[] values = dArray;
            int size = values.length;
            if (p == 1.0) {
                double sum = 0.0;
                for (int i = 0; i < size; ++i) {
                    sum += package$.MODULE$.abs(values[i]);
                }
                d = sum;
            } else if (p == (double)2) {
                double sum = 0.0;
                for (int i = 0; i < size; ++i) {
                    sum += values[i] * values[i];
                }
                d = package$.MODULE$.sqrt(sum);
            } else if (p == Double.POSITIVE_INFINITY) {
                double max2 = 0.0;
                for (int i = 0; i < size; ++i) {
                    double value = package$.MODULE$.abs(values[i]);
                    if (!(value > max2)) continue;
                    max2 = value;
                }
                d = max2;
            } else {
                double sum = 0.0;
                for (int i = 0; i < size; ++i) {
                    sum += package$.MODULE$.pow(package$.MODULE$.abs(values[i]), p);
                }
                d = package$.MODULE$.pow(sum, 1.0 / p);
            }
            return d;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"Do not support vector type ").append(vector2.getClass()).toString());
    }

    /*
     * WARNING - void declaration
     */
    public double sqdist(Vector v1, Vector v2) {
        block13: {
            void var3_3;
            block10: {
                DenseVector denseVector;
                Option<double[]> option;
                DenseVector denseVector2;
                Option<double[]> option2;
                Tuple2 tuple2;
                block12: {
                    double squaredDistance;
                    block11: {
                        block9: {
                            Predef$.MODULE$.require(v1.size() == v2.size(), (Function0)new Serializable(v1, v2){
                                public static final long serialVersionUID = 0L;
                                private final Vector v1$1;
                                private final Vector v2$1;

                                public final String apply() {
                                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Vector dimensions do not match: Dim(v1)=", " and Dim(v2)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.v1$1.size())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"=", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.v2$1.size())}))).toString();
                                }
                                {
                                    this.v1$1 = v1$1;
                                    this.v2$1 = v2$1;
                                }
                            });
                            squaredDistance = 0.0;
                            tuple2 = new Tuple2((Object)v1, (Object)v2);
                            if (tuple2 == null) break block9;
                            Vector v12 = (Vector)tuple2._1();
                            Vector v22 = (Vector)tuple2._2();
                            if (!(v12 instanceof SparseVector)) break block9;
                            SparseVector sparseVector = (SparseVector)v12;
                            if (!(v22 instanceof SparseVector)) break block9;
                            SparseVector sparseVector2 = (SparseVector)v22;
                            double[] v1Values = sparseVector.values();
                            int[] v1Indices = sparseVector.indices();
                            double[] v2Values = sparseVector2.values();
                            int[] v2Indices = sparseVector2.indices();
                            int nnzv1 = v1Indices.length;
                            int nnzv2 = v2Indices.length;
                            int kv1 = 0;
                            int kv2 = 0;
                            while (kv1 < nnzv1 || kv2 < nnzv2) {
                                double score = 0.0;
                                if (kv2 >= nnzv2 || kv1 < nnzv1 && v1Indices[kv1] < v2Indices[kv2]) {
                                    score = v1Values[kv1];
                                    ++kv1;
                                } else if (kv1 >= nnzv1 || kv2 < nnzv2 && v2Indices[kv2] < v1Indices[kv1]) {
                                    score = v2Values[kv2];
                                    ++kv2;
                                } else {
                                    score = v1Values[kv1] - v2Values[kv2];
                                    ++kv1;
                                    ++kv2;
                                }
                                squaredDistance += score * score;
                            }
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block10;
                        }
                        if (tuple2 == null) break block11;
                        Vector v13 = (Vector)tuple2._1();
                        Vector v23 = (Vector)tuple2._2();
                        if (!(v13 instanceof SparseVector)) break block11;
                        SparseVector sparseVector = (SparseVector)v13;
                        if (!(v23 instanceof DenseVector)) break block11;
                        DenseVector denseVector3 = (DenseVector)v23;
                        squaredDistance = this.sqdist(sparseVector, denseVector3);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block10;
                    }
                    if (tuple2 == null) break block12;
                    Vector v14 = (Vector)tuple2._1();
                    Vector v24 = (Vector)tuple2._2();
                    if (!(v14 instanceof DenseVector)) break block12;
                    DenseVector denseVector4 = (DenseVector)v14;
                    if (!(v24 instanceof SparseVector)) break block12;
                    SparseVector sparseVector = (SparseVector)v24;
                    squaredDistance = this.sqdist(sparseVector, denseVector4);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block10;
                }
                if (tuple2 == null) break block13;
                Vector vector = (Vector)tuple2._1();
                Vector vector2 = (Vector)tuple2._2();
                if (!(vector instanceof DenseVector) || (option2 = DenseVector$.MODULE$.unapply(denseVector2 = (DenseVector)vector)).isEmpty()) break block13;
                double[] vv1 = (double[])option2.get();
                if (!(vector2 instanceof DenseVector) || (option = DenseVector$.MODULE$.unapply(denseVector = (DenseVector)vector2)).isEmpty()) break block13;
                double[] vv2 = (double[])option.get();
                int sz = vv1.length;
                for (int kv = 0; kv < sz; ++kv) {
                    double score = vv1[kv] - vv2[kv];
                    squaredDistance += score * score;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return (double)var3_3;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"Do not support vector type ").append(v1.getClass()).append((Object)" and ").append(v2.getClass()).toString());
    }

    public double sqdist(SparseVector v1, DenseVector v2) {
        int iv1;
        int kv1 = 0;
        int[] indices = v1.indices();
        double squaredDistance = 0.0;
        int nnzv1 = indices.length;
        int nnzv2 = v2.size();
        int n = iv1 = nnzv1 > 0 ? indices[kv1] : -1;
        for (int kv2 = 0; kv2 < nnzv2; ++kv2) {
            double score = 0.0;
            if (kv2 != iv1) {
                score = v2.apply(kv2);
            } else {
                score = v1.values()[kv1] - v2.apply(kv2);
                if (kv1 < nnzv1 - 1) {
                    iv1 = indices[++kv1];
                }
            }
            squaredDistance += score * score;
        }
        return squaredDistance;
    }

    public boolean equals(IndexedSeq<Object> v1Indices, double[] v1Values, IndexedSeq<Object> v2Indices, double[] v2Values) {
        int v1Size = v1Values.length;
        int v2Size = v2Values.length;
        int k1 = 0;
        int k2 = 0;
        boolean allEqual = true;
        while (allEqual) {
            while (k1 < v1Size && v1Values[k1] == 0.0) {
                ++k1;
            }
            while (k2 < v2Size && v2Values[k2] == 0.0) {
                ++k2;
            }
            if (k1 >= v1Size || k2 >= v2Size) {
                return k1 >= v1Size && k2 >= v2Size;
            }
            allEqual = BoxesRunTime.unboxToInt((Object)v1Indices.apply(k1)) == BoxesRunTime.unboxToInt((Object)v2Indices.apply(k2)) && v1Values[k1] == v2Values[k2];
            ++k1;
            ++k2;
        }
        return allEqual;
    }

    public int MAX_HASH_NNZ() {
        return this.MAX_HASH_NNZ;
    }

    private Vectors$() {
        MODULE$ = this;
        this.MAX_HASH_NNZ = 128;
    }
}

